      FUNCTION VPSAT(T)
      IMPLICIT NONE
C
C**********************************************************************
C
C   NAME- VPSAT
C
C   LANGUAGE- FORTRAN     TYPE- FUNCTION        COMPUTER- AIX
C
C   VERSION- 1.0    DATE- 10/16/06   PROGRAMMER- FRANK TILLEY (IMSG)
C
C   FUNCTION- THIS FUNCTION RETURNS THE SATURATION VAPOR PRESSURE
C             OVER WATER(MB) GIVEN THE TEMPERATURE (CELSIUS).
C
C   CALLING SEQUENCE PARAMETERS-
C     VARIABLE          TYPE  I/O  FUNCTION
C     --------          ----  ---  --------
C     T                 REAL  I    TEMPERATURE (CELSIUS)
C
      REAL         VPSAT, T
C
C   LOCAL PARAMETERS- NONE
C
C   INTRINSIC FUNCTIONS USED- EXP
C
C**********************************************************************
C
C
      VPSAT = 6.1078 * EXP(T/(T+238.3)*17.2694)
      RETURN
      END
