/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.StringConcatFactory;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class HighchartScriptGenerator {
    private String grouping_name;
    private int terrain;
    private int stat_type;
    private int data_type;
    private float pressure;
    private boolean is_longterm_plot;
    private String baseline_name;
    private int num_days;
    private int num_weeks;
    private int num_months;
    private int date_start_index;
    private int date_end_index;
    private String[] date_strings;
    private String[] profile_names;
    private int[] dates;
    private int[] profile_system_ids;
    private int[] profile_system_numbers;
    private int[] profile_types;
    private float[] pressures;
    private Vector visible_profile_vector;
    private int min_count;
    private int max_count;
    private float min_stat;
    private float max_stat;
    private NarcsToHighchartsGlobals globals;
    private final int BIAS = 0;
    private final int STDDEV = 1;
    private final int RMS = 2;
    private final int SAMPLE_SIZE = 3;
    private final int SYSTEM = 0;
    private final int RETRIEVAL = 1;
    private final int GUESS = 2;
    private final int FORECAST = 3;
    private final int MICROWAVE = 4;
    private final int INFRARED = 5;
    private final int RAW_DRY = 6;
    private final int NUM_PIECES = 18;
    private PrintWriter pw;
    private PrintWriter out;
    private String file_name;

    public HighchartScriptGenerator(PrintWriter printWriter, String string, float f, int n, int n2, int n3, boolean bl, String string2, int n4, int n5, int n6, String[] stringArray, int[] nArray, int[] nArray2, int[] nArray3, int n7, int n8, String[] stringArray2, int[] nArray4, float[] fArray) {
        this.out = printWriter;
        this.grouping_name = string;
        this.pressure = f;
        this.terrain = n;
        this.stat_type = n2;
        this.data_type = n3;
        this.is_longterm_plot = bl;
        this.pressures = fArray;
        this.baseline_name = string2;
        this.num_days = n4;
        this.num_weeks = n5;
        this.num_months = n6;
        this.profile_names = stringArray;
        this.profile_system_ids = nArray;
        this.profile_system_numbers = nArray2;
        this.profile_types = nArray3;
        this.date_start_index = n7;
        this.date_end_index = n8;
        this.date_strings = stringArray2;
        this.dates = nArray4;
        this.globals = new NarcsToHighchartsGlobals();
        this.visible_profile_vector = new Vector();
    }

    public void generateGraph() {
        this.visible_profile_vector.removeAllElements();
        this.buildProfiles();
        this.findStatisticMinMax();
        this.removeUnwantedData();
        this.drawTitle();
        this.drawLegend();
        this.drawXAxis();
        this.out.println("        yAxis: {");
        this.out.println("          max: " + this.max_stat + ",");
        this.out.println("          min: " + this.min_stat + ",");
        this.out.println("             title: {");
        if (this.stat_type == 0) {
            this.out.println("                 text: 'BIAS'");
        } else if (this.stat_type == 1) {
            this.out.println("                 text: 'STDDEV'");
        } else if (this.stat_type == 2) {
            this.out.println("                 text: 'RMS'");
        }
        this.out.println("             },");
        this.out.println("             plotLines: [{");
        this.out.println("                 value: 0,");
        this.out.println("                 width: 1,");
        this.out.println("                 color: '#808080'");
        this.out.println("             }]");
        this.out.println("        },");
        this.out.println("        tooltip: {");
        this.out.println("            valueSuffix: ''");
        this.out.println("        },");
        this.out.println("        legend: {");
        this.out.println("            layout: 'horizontal',");
        this.out.println("            align: 'center',");
        this.out.println("            verticalAlign: 'bottom',");
        this.out.println("            borderWidth: 0");
        this.out.println("        },");
        this.out.flush();
        this.drawMainGraph();
        this.out.println("\n        }]");
        this.out.println("    })");
        this.out.flush();
    }

    private void drawTitle() {
        NarcsDataProfile narcsDataProfile = (NarcsDataProfile)this.visible_profile_vector.elementAt(0);
        Object object = "";
        Object object2 = this.grouping_name;
        if (this.terrain == 0) {
            object2 = (String)object2 + "_Sea";
        } else if (this.terrain == 1) {
            object2 = (String)object2 + "_Land";
        } else if (this.terrain == 2) {
            object2 = (String)object2 + "_LandAndSea";
        }
        if (this.data_type == 0) {
            object2 = (String)object2 + "_Temperature";
            object = "Temperature " + (int)this.pressure + " hPa Level Statistics";
        } else if (this.data_type == 1) {
            object2 = (String)object2 + "_WaterVapor";
            object = "Water Vapor Percent Error " + (int)this.pressure + " hPa Level Statistics";
        }
        if (this.stat_type == 0) {
            object2 = (String)object2 + "_Bias";
        } else if (this.stat_type == 1) {
            object2 = (String)object2 + "_StdDev";
        } else if (this.stat_type == 2) {
            object2 = (String)object2 + "_RMS";
        }
        object2 = (String)object2 + "_" + (int)this.pressure + "hPa";
        this.out.println("    $('#" + (String)object2 + "').highcharts({");
        this.is_longterm_plot = true;
        if (this.is_longterm_plot) {
            this.out.println("        chart: {");
            this.out.println("           zoomType: 'x'");
            this.out.println("        },");
        }
        this.out.println("        title: {");
        this.out.println("            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',");
        this.out.println("        },");
        String string = "            text: '" + (String)object + ", ";
        if (this.terrain == 0) {
            string = string + "Sea,";
        } else if (this.terrain == 1) {
            string = string + "Land,";
        } else if (this.terrain == 2) {
            string = string + "Land and Sea,";
        }
        if (this.stat_type == 0) {
            string = string + " Bias'";
        } else if (this.stat_type == 1) {
            string = string + " Std Dev'";
        } else if (this.stat_type == 2) {
            string = string + " RMS'";
        }
        this.out.println("        subtitle: {");
        this.out.println(string + ",");
        this.out.println("            style: {");
        this.out.println("            color: '#FF0000',");
        this.out.println("            fontWeight: 'bold'");
        this.out.println("            },");
        this.out.println("            x: -20 //center");
        this.out.println("        },");
        this.out.flush();
    }

    private void drawXAxis() {
        this.out.println("        xAxis: {");
        this.out.print("            categories: [");
        for (int i = 0; i < this.date_strings.length; ++i) {
            this.out.print("'" + this.date_strings[i] + "'");
            if (i == this.date_strings.length - 1) {
                this.out.print("],");
            }
            if (i != this.date_strings.length && i != this.date_strings.length - 1) {
                this.out.print(", ");
            }
            if (i % 6 != 0) continue;
            this.out.println(" ");
        }
        this.out.println("            labels: {");
        this.out.println("                rotation: 90");
        this.out.println("            },");
        this.out.println("            minorGridLineDashStyle: 'longdash',");
        this.out.println("            minorTickInterval: 'auto',");
        this.out.println("            minorTickWidth: 0,");
        this.out.println("            plotLines: [{");
        this.out.println("                dashStyle: 'longdash',");
        this.out.println("                value: 0,");
        this.out.println("                width: 1,");
        this.out.println("                color: '#808080'");
        this.out.println("            }]");
        this.out.println("        },");
        this.out.flush();
    }

    private void drawMainGraph() {
        int n = this.date_strings.length;
        this.out.println("        series: [{");
        for (int i = 0; i < this.visible_profile_vector.size(); ++i) {
            boolean bl = false;
            NarcsDataProfile narcsDataProfile = (NarcsDataProfile)this.visible_profile_vector.elementAt(i);
            String string = narcsDataProfile.getLabel();
            this.out.println("            name: '" + string + "',");
            this.out.println("data: [");
            float[] fArray = narcsDataProfile.getValues();
            for (int j = 0; j < fArray.length; ++j) {
                if (j != fArray.length - 1) {
                    if (fArray[j] != -32768.0f) {
                        this.out.print(fArray[j] + ", ");
                        continue;
                    }
                    this.out.print((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"null, "})));
                    continue;
                }
                if (fArray[j] != -32768.0f) {
                    this.out.print(fArray[j] + "] ");
                    continue;
                }
                this.out.print((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"null] "})));
            }
            if (i == this.visible_profile_vector.size() - 1) continue;
            this.out.println("}, { ");
        }
        this.out.flush();
    }

    public void drawLegend() {
        Object object;
        int n;
        int n2;
        int n3;
        Vector<boolean[]> vector = new Vector<boolean[]>();
        Vector<String> vector2 = new Vector<String>();
        Vector<NarcsDataProfile> vector3 = new Vector<NarcsDataProfile>();
        for (n3 = 0; n3 < this.visible_profile_vector.size(); ++n3) {
            NarcsDataProfile narcsDataProfile = (NarcsDataProfile)this.visible_profile_vector.elementAt(n3);
            n2 = narcsDataProfile.getSystemID();
            int n4 = n2 * 100 + (n = narcsDataProfile.getProfileType());
            object = new Integer(n4);
            if (vector.contains(object)) continue;
            vector.addElement((boolean[])object);
            vector2.addElement(narcsDataProfile.getLabel());
            vector3.addElement(narcsDataProfile);
        }
        n3 = 1;
        int n5 = vector.size();
        n2 = n5 + n3 + 1;
        n = 0;
        String string = (String)vector2.elementAt(0);
        object = this.globals.getShowCombination();
        boolean bl = object[6];
        this.out.print("        colors: ['#");
        for (int i = 0; i < vector.size(); ++i) {
            int n6 = (Integer)vector.elementAt(i);
            Color color = this.globals.getProfileColor(n6);
            this.out.print(String.format("%02x", color.getRed()) + String.format("%02x", color.getGreen()) + String.format("%02x", color.getBlue()));
            if (i == vector.size() - 1) continue;
            this.out.print("', '#");
        }
        this.out.println("'],");
        this.out.flush();
    }

    private void buildProfiles() {
        Vector vector = this.globals.getVisibleProfiles();
        for (int i = 0; i < vector.size(); ++i) {
            int n = (Integer)vector.elementAt(i);
            int n2 = n / 100;
            int n3 = n % 100;
            int n4 = Short.MIN_VALUE;
            for (int j = 0; j < this.profile_system_ids.length; ++j) {
                if (n2 != this.profile_system_ids[j]) continue;
                n4 = this.profile_system_numbers[j];
            }
            if (n4 == Short.MIN_VALUE) continue;
            boolean[] blArray = this.globals.getShowCombination();
            for (int j = 0; j < 18; ++j) {
                if (!blArray[j]) continue;
                NarcsDataProfile narcsDataProfile = null;
                NarcsDataProfile narcsDataProfile2 = null;
                narcsDataProfile = this.buildProfile(n2, n4, n3, 3, j, null);
                if (this.stat_type == 0) {
                    narcsDataProfile2 = this.buildProfile(n2, n4, n3, 0, j, narcsDataProfile);
                }
                if (this.stat_type == 1) {
                    narcsDataProfile2 = this.buildProfile(n2, n4, n3, 1, j, narcsDataProfile);
                }
                if (this.stat_type == 2) {
                    narcsDataProfile2 = this.buildProfile(n2, n4, n3, 2, j, narcsDataProfile);
                }
                narcsDataProfile2 = this.removeUnwantedStatisticData(narcsDataProfile2, narcsDataProfile);
                this.visible_profile_vector.add(narcsDataProfile2);
            }
        }
    }

    private NarcsDataProfile buildProfile(int n, int n2, int n3, int n4, int n5, NarcsDataProfile narcsDataProfile) {
        int n6;
        NarcsDataProfile narcsDataProfile2 = null;
        int n7 = this.globals.getTimeWindow();
        Object object = "/";
        object = n7 == 0 ? (String)object + "daily" : (n7 == 1 ? (String)object + "weekly" : (String)object + "monthly");
        object = (String)object + "_system" + n2;
        object = n3 < 10 ? (String)object + "_profile0" + n3 + "_" : (String)object + "_profile" + n3 + "_";
        int n8 = 0;
        if (this.data_type == 0) {
            object = (String)object + "templevel";
            for (n6 = 0; n6 < this.pressures.length; ++n6) {
                if (this.pressures[n6] != this.pressure) continue;
                n8 = n6;
            }
        } else if (this.data_type == 1) {
            object = (String)object + "wvaplevel";
            for (n6 = 0; n6 < this.pressures.length; ++n6) {
                if (this.pressures[n6] != this.pressure) continue;
                n8 = n6;
            }
        }
        object = (String)object + n8;
        if (n4 == 0) {
            object = (String)object + "_bias.dat";
        } else if (n4 == 1) {
            object = (String)object + "_stddev.dat";
        } else if (n4 == 2) {
            object = (String)object + "_rms.dat";
        } else if (n4 == 3) {
            object = (String)object + "_counts.dat";
        }
        String string = "input.file";
        try {
            Object object2;
            File file;
            DataInputStream dataInputStream = null;
            if (string != null && (file = new File(string)).exists()) {
                try {
                    object2 = new ZipFile(string);
                    ZipEntry zipEntry = ((ZipFile)object2).getEntry("narcsdir" + (String)object);
                    dataInputStream = new DataInputStream(((ZipFile)object2).getInputStream(zipEntry));
                }
                catch (ZipException zipException) {
                    zipException.printStackTrace();
                }
            }
            if (dataInputStream != null) {
                int n9;
                int n10 = this.num_days;
                if (this.globals.getTimeWindow() == 1) {
                    n10 = this.num_weeks;
                } else if (this.globals.getTimeWindow() == 2) {
                    n10 = this.num_months;
                }
                object2 = new byte[n10 * 4];
                int n11 = n5 * ((Object)object2).length;
                dataInputStream.skipBytes(n11);
                dataInputStream.readFully((byte[])object2);
                float[] fArray = new float[n10];
                DataInputStream dataInputStream2 = new DataInputStream(new ByteArrayInputStream((byte[])object2));
                for (n9 = 0; n9 < n10; ++n9) {
                    int n12 = dataInputStream2.readInt();
                    fArray[n9] = n12 == Short.MIN_VALUE ? -32768.0f : (n4 == 3 ? (float)n12 : (float)n12 / 1000.0f);
                }
                dataInputStream2.close();
                n9 = this.date_end_index - this.date_start_index + 1;
                float[] fArray2 = new float[n9];
                for (int i = this.date_start_index; i <= this.date_end_index; ++i) {
                    fArray2[i - this.date_start_index] = fArray[i];
                }
                String string2 = "system name";
                for (int i = 0; i < this.profile_names.length; ++i) {
                    if (n != this.profile_system_ids[i] || n3 != this.profile_types[i]) continue;
                    string2 = this.profile_names[i];
                }
                narcsDataProfile2 = new NarcsDataProfile(fArray2, Color.black, n, n2, n3, n4, n5, 0, 0, string2, narcsDataProfile);
                dataInputStream.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return narcsDataProfile2;
    }

    private void removeUnwantedData() {
        for (int i = 0; i < this.visible_profile_vector.size(); ++i) {
            NarcsDataProfile narcsDataProfile = (NarcsDataProfile)this.visible_profile_vector.elementAt(i);
            NarcsDataProfile narcsDataProfile2 = narcsDataProfile.getSampleSizeProfile();
            narcsDataProfile = this.removeUnwantedStatisticData(narcsDataProfile, narcsDataProfile2);
            this.visible_profile_vector.setElementAt(narcsDataProfile, i);
        }
    }

    private NarcsDataProfile removeUnwantedStatisticData(NarcsDataProfile narcsDataProfile, NarcsDataProfile narcsDataProfile2) {
        NarcsDataProfile narcsDataProfile3 = narcsDataProfile;
        boolean bl = this.globals.getIgnoreExtremeValues();
        float[] fArray = narcsDataProfile3.getValues();
        float[] fArray2 = narcsDataProfile2.getValues();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < fArray2.length; ++i) {
            if (fArray2[i] == -32768.0f) continue;
            n = (int)((float)n + fArray2[i]);
            ++n2;
        }
        float f = (float)n / (float)n2;
        float f2 = f * this.globals.getSampleSizeCutoff();
        for (int i = 0; i < fArray.length; ++i) {
            if (bl && (fArray[i] < this.min_stat || fArray[i] > this.max_stat)) {
                fArray[i] = -32768.0f;
            }
            if (!this.globals.getUseSampleSizeCutoff() || !(fArray2[i] < f2)) continue;
            fArray[i] = -32768.0f;
        }
        narcsDataProfile3.setValues(fArray);
        return narcsDataProfile3;
    }

    private void findStatisticMinMax() {
        this.min_stat = -5.0f;
        this.max_stat = 5.0f;
        if (this.globals.getMinMaxOption() == 1) {
            this.min_stat = this.globals.getStatDefaultMinimum(this.stat_type, this.data_type);
            this.max_stat = this.globals.getStatDefaultMaximum(this.stat_type, this.data_type);
        } else if (this.globals.getMinMaxOption() == 2) {
            this.min_stat = this.globals.getStatManualMinimum(this.stat_type, this.data_type);
            this.max_stat = this.globals.getStatManualMaximum(this.stat_type, this.data_type);
        } else {
            this.min_stat = 9999999.0f;
            this.max_stat = -9999999.0f;
            for (int i = 0; i < this.visible_profile_vector.size(); ++i) {
                NarcsDataProfile narcsDataProfile = (NarcsDataProfile)this.visible_profile_vector.elementAt(i);
                if (narcsDataProfile.getStatType() == 3) continue;
                float f = narcsDataProfile.getMinimumValue();
                float f2 = narcsDataProfile.getMaximumValue();
                if (f != -32768.0f) {
                    this.min_stat = Math.min(this.min_stat, f);
                }
                if (f2 == -32768.0f) continue;
                this.max_stat = Math.max(this.max_stat, f2);
            }
            if (this.min_stat == 9999999.0f || this.min_stat == -9999999.0f || this.max_stat == 9999999.0f || this.max_stat == -9999999.0f) {
                this.min_stat = -5.0f;
                this.max_stat = 5.0f;
            }
            if (this.min_stat == 0.0f && this.max_stat == 0.0f) {
                this.min_stat = -10.0f;
                this.max_stat = 10.0f;
            }
        }
    }
}

