/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class NarcsToHighcharts {
    private String version = "1.0";
    private String version_date = "October 3, 2024";
    private NarcsToHighchartsGlobals globals;
    private String input_file_name;
    private String output_file_name;
    private int date_range_start;
    private int date_range_end;
    private int file_start_date;
    private int file_end_date;
    private int global_start_date;
    private int global_end_date;
    private Vector grouping_vector;
    private Vector pressure_vector;
    private String baseline_name;
    private int num_days;
    private int num_weeks;
    private int num_months;
    private int num_temp_levels;
    private int num_temp_layers;
    private int num_wvap_levels;
    private int num_wvap_layers;
    private int[] days;
    private int[] week_starts;
    private int[] week_ends;
    private int[] months;
    private float[] temp_level_pressures;
    private float[] temp_layer_pressures;
    private float[] wvap_level_pressures;
    private float[] wvap_layer_pressures;
    private String[] day_strings;
    private String[] week_strings;
    private String[] month_strings;
    private int num_systems_in_file;
    private int num_profiles_in_file;
    private int[] system_ids_in_file;
    private int[] profile_system_ids_in_file;
    private int[] profile_system_numbers_in_file;
    private int[] profile_profile_types_in_file;
    private String[] system_names_in_file;
    private String[] profile_system_names_in_file;
    private String[] profile_profile_names_in_file;
    private boolean show_baseline_sea;
    private boolean show_baseline_nonsea;
    private boolean show_baseline_both;
    private boolean show_system_sea;
    private boolean show_system_nonsea;
    private boolean show_system_both;
    private boolean show_pass;
    private boolean show_fail;
    private boolean show_samplesize;
    private boolean show_bias;
    private boolean show_stddev;
    private boolean show_rms;
    private boolean use_sample_size_cutoff;
    private boolean is_longterm_plot;
    private float sample_size_cutoff;
    private boolean show_data_points;
    private int min_max_option;
    private int counts_min;
    private int counts_max;
    private float data_min;
    private float data_max;
    private boolean ignore_extreme_values;
    private int time_option;
    private int start_date;
    private int end_date;
    private int data_type;
    private float data_pressure;
    private final int NUM_PIECES = 18;
    private final int TEMPERATURE = 0;
    private final int WATER_VAPOR = 1;
    private final int RELATIVE_HUMIDITY = 2;
    private final int SAMPLE_SIZE = 0;
    private final int TEMPERATURE_LEVEL = 1;
    private final int TEMPERATURE_LAYER = 2;
    private final int WATER_VAPOR_LEVEL = 3;
    private final int WATER_VAPOR_LAYER = 4;

    public static void main(String[] stringArray) {
        NarcsToHighcharts narcsToHighcharts = new NarcsToHighcharts(stringArray);
        System.exit(0);
    }

    public NarcsToHighcharts(String[] stringArray) {
        System.out.println("====================================================================");
        System.out.print("Starting NarcsToHighcharts version " + this.version + " at ");
        this.printTime();
        System.out.println("");
        this.globals = new NarcsToHighchartsGlobals();
        this.globals.readDefaultColors();
        this.input_file_name = "input.file";
        this.output_file_name = "output.file";
        System.out.println("In:   " + this.input_file_name);
        System.out.println("Out:  " + this.output_file_name);
        if (stringArray.length > 1) {
            this.readGlobalDateRange(stringArray);
        }
        this.is_longterm_plot = false;
        if (stringArray.length == 3) {
            this.is_longterm_plot = true;
        }
        try {
            XMLParser xMLParser = new XMLParser();
            XMLTree xMLTree = xMLParser.parseFile("settings.file");
            if (xMLTree != null) {
                this.processGroupingSettings(xMLTree);
                this.processPressureSettings(xMLTree);
                this.processGraphSettings(xMLTree);
                this.readNarcsFileHeader();
                try {
                    PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(this.output_file_name, true)));
                    printWriter.println("$(function () {");
                    for (int i = 0; i < this.grouping_vector.size(); ++i) {
                        Grouping grouping = (Grouping)this.grouping_vector.elementAt(i);
                        for (int j = 0; j < this.pressure_vector.size(); ++j) {
                            float f = ((Float)this.pressure_vector.elementAt(j)).floatValue();
                            for (int k = 0; k < 3; ++k) {
                                for (int i2 = 0; i2 < 3; ++i2) {
                                    this.processStats(printWriter, grouping, f, k, i2, 0);
                                    this.processStats(printWriter, grouping, f, k, i2, 1);
                                }
                            }
                        }
                    }
                    printWriter.println("})");
                    printWriter.flush();
                    printWriter.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else {
                System.out.println("\nThe input parameter file could not be parsed.");
                System.out.println("The structure of the XML data is probably not correct.");
                System.out.println("Please check the file and try again.\n");
                System.exit(1);
            }
        }
        catch (XMLParserException xMLParserException) {
            System.out.println("\nThe input parameter file could not be parsed.");
            System.out.println("The structure of the XML data is probably not correct.");
            System.out.println("Please check the file and try again.\n");
            System.exit(1);
        }
    }

    private void processGroupingSettings(XMLTree xMLTree) {
        this.grouping_vector = new Vector();
        Object object = xMLTree.getValue("platform_groupings");
        if (object != null && object instanceof Vector) {
            Vector vector = (Vector)object;
            for (int i = 0; i < vector.size(); ++i) {
                Object object2;
                object = vector.elementAt(i);
                if (!(object instanceof XMLTree)) continue;
                XMLTree xMLTree2 = (XMLTree)object;
                Grouping grouping = new Grouping();
                object = xMLTree2.getValue("grouping_name");
                if (object != null && object instanceof String) {
                    object2 = (String)object;
                    grouping.setName((String)object2);
                }
                if ((object = xMLTree2.getValue("profiles")) != null && object instanceof Vector) {
                    object2 = (Vector)object;
                    for (int j = 0; j < ((Vector)object2).size(); ++j) {
                        ProfileSettings profileSettings = new ProfileSettings();
                        object = ((Vector)object2).elementAt(j);
                        if (object != null && object instanceof XMLTree) {
                            String string;
                            XMLTree xMLTree3 = (XMLTree)object;
                            if ((object = xMLTree3.getValue("platform_name")) != null && object instanceof String) {
                                string = (String)object;
                                profileSettings.setPlatformName(string);
                            }
                            if ((object = xMLTree3.getValue("platform_id")) != null && object instanceof String) {
                                string = (String)object;
                                profileSettings.setPlatformID(Integer.parseInt(string));
                            }
                            if ((object = xMLTree3.getValue("profile_name")) != null && object instanceof String) {
                                string = (String)object;
                                profileSettings.setProfileName(string);
                            }
                            if ((object = xMLTree3.getValue("profile_id")) != null && object instanceof String) {
                                string = (String)object;
                                profileSettings.setProfileID(Integer.parseInt(string));
                            }
                            if ((object = xMLTree3.getValue("line_color_red")) != null && object instanceof String) {
                                string = (String)object;
                                profileSettings.setLineColorRed(Integer.parseInt(string));
                            }
                            if ((object = xMLTree3.getValue("line_color_green")) != null && object instanceof String) {
                                string = (String)object;
                                profileSettings.setLineColorGreen(Integer.parseInt(string));
                            }
                            if ((object = xMLTree3.getValue("line_color_blue")) != null && object instanceof String) {
                                string = (String)object;
                                profileSettings.setLineColorBlue(Integer.parseInt(string));
                            }
                        }
                        grouping.addProfile(profileSettings);
                    }
                }
                this.grouping_vector.add(grouping);
            }
        }
    }

    private void processPressureSettings(XMLTree xMLTree) {
        this.pressure_vector = new Vector();
        Object object = xMLTree.getValue("pressures");
        if (object != null && object instanceof Vector) {
            Vector vector = (Vector)object;
            for (int i = 0; i < vector.size(); ++i) {
                XMLTree xMLTree2;
                object = vector.elementAt(i);
                if (object == null || !(object instanceof XMLTree) || (object = (xMLTree2 = (XMLTree)object).getValue("pressure")) == null || !(object instanceof String)) continue;
                String string = (String)object;
                float f = Float.parseFloat(string);
                this.pressure_vector.add(new Float(f));
            }
        }
        if (this.pressure_vector.size() == 0) {
            this.pressure_vector.add(new Float(10.2));
            this.pressure_vector.add(new Float(51.5));
            this.pressure_vector.add(new Float(113.9));
            this.pressure_vector.add(new Float(206.4));
            this.pressure_vector.add(new Float(293.1));
            this.pressure_vector.add(new Float(506.1));
            this.pressure_vector.add(new Float(729.6));
            this.pressure_vector.add(new Float(827.1));
        }
    }

    private void processGraphSettings(XMLTree xMLTree) {
        Object object = xMLTree.getValue("graph_settings");
        if (object != null && object instanceof Vector) {
            String string;
            Vector vector = (Vector)object;
            this.globals.setTimeWindow(2);
            object = xMLTree.getValue("time_window");
            if (object != null && object instanceof String) {
                string = (String)object;
                if ((string = string.toLowerCase()).equals("daily")) {
                    this.globals.setTimeWindow(0);
                } else if (string.equals("weekly")) {
                    this.globals.setTimeWindow(1);
                }
            }
            this.globals.setMinMaxOption(0);
            object = xMLTree.getValue("min_max_option");
            if (object != null && object instanceof String) {
                string = (String)object;
                if ((string = string.toLowerCase()).equals("default")) {
                    this.globals.setMinMaxOption(1);
                } else if (string.equals("manual")) {
                    this.globals.setMinMaxOption(2);
                }
            }
            if ((object = xMLTree.getValue("temp_bias_stats_min")) != null && object instanceof String) {
                this.globals.setTemperatureBiasStatsMin(Float.parseFloat((String)object));
                string = (String)object;
            }
            if ((object = xMLTree.getValue("temp_bias_stats_max")) != null && object instanceof String) {
                this.globals.setTemperatureBiasStatsMax(Float.parseFloat((String)object));
                string = (String)object;
            }
            if ((object = xMLTree.getValue("temp_stddev_stats_min")) != null && object instanceof String) {
                this.globals.setTemperatureStddevStatsMin(Float.parseFloat((String)object));
                string = (String)object;
            }
            if ((object = xMLTree.getValue("temp_stddev_stats_max")) != null && object instanceof String) {
                this.globals.setTemperatureStddevStatsMax(Float.parseFloat((String)object));
                string = (String)object;
            }
            if ((object = xMLTree.getValue("temp_rms_stats_min")) != null && object instanceof String) {
                this.globals.setTemperatureRMSStatsMin(Float.parseFloat((String)object));
                string = (String)object;
            }
            if ((object = xMLTree.getValue("temp_rms_stats_max")) != null && object instanceof String) {
                this.globals.setTemperatureRMSStatsMax(Float.parseFloat((String)object));
                string = (String)object;
            }
            if ((object = xMLTree.getValue("wvap_bias_stats_min")) != null && object instanceof String) {
                this.globals.setWaterVaporBiasStatsMin(Float.parseFloat((String)object));
                string = (String)object;
            }
            if ((object = xMLTree.getValue("wvaop_bias_stats_max")) != null && object instanceof String) {
                this.globals.setWaterVaporBiasStatsMax(Float.parseFloat((String)object));
                string = (String)object;
            }
            if ((object = xMLTree.getValue("wvap_stddev_stats_min")) != null && object instanceof String) {
                this.globals.setWaterVaporStddevStatsMin(Float.parseFloat((String)object));
                string = (String)object;
            }
            if ((object = xMLTree.getValue("wvap_stddev_stats_max")) != null && object instanceof String) {
                this.globals.setWaterVaporStddevStatsMax(Float.parseFloat((String)object));
                string = (String)object;
            }
            if ((object = xMLTree.getValue("wvap_rms_stats_min")) != null && object instanceof String) {
                this.globals.setWaterVaporRMSStatsMin(Float.parseFloat((String)object));
                string = (String)object;
            }
            if ((object = xMLTree.getValue("wvap_rms_stats_max")) != null && object instanceof String) {
                this.globals.setWaterVaporRMSStatsMax(Float.parseFloat((String)object));
                string = (String)object;
            }
            this.globals.setIgnoreExtremeValues(false);
            object = xMLTree.getValue("ignore_extreme_values");
            if (object != null && object instanceof String) {
                string = (String)object;
                if ((string = string.toLowerCase()).equals("yes")) {
                    this.globals.setIgnoreExtremeValues(true);
                }
            }
            this.globals.setUseSampleSizeCutoff(false);
            object = xMLTree.getValue("use_sample_size_cutoff");
            if (object != null && object instanceof String) {
                string = (String)object;
                if ((string = string.toLowerCase()).equals("yes")) {
                    this.globals.setUseSampleSizeCutoff(true);
                }
            }
            if ((object = xMLTree.getValue("sample_size_cutoff")) != null && object instanceof String) {
                this.globals.setSampleSizeCutoff(Float.parseFloat((String)object));
                string = (String)object;
            }
        }
    }

    private void readGlobalDateRange(String[] stringArray) {
        this.date_range_start = Short.MIN_VALUE;
        this.date_range_end = Short.MIN_VALUE;
        try {
            this.date_range_start = Integer.parseInt(stringArray[0]);
            this.date_range_end = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void processStats(PrintWriter printWriter, Grouping grouping, float f, int n, int n2, int n3) {
        int n4;
        System.out.println("-------------------------------------------");
        System.out.println("Processing Stats...");
        System.out.println("   Grouping:  " + grouping.getName());
        System.out.println("   Pressure:  " + f);
        System.out.println("   Terrain:   " + n);
        System.out.println("   Stat Type: " + n2);
        System.out.println("   Data Type: " + n3);
        System.out.println("");
        this.readBaselineInformation();
        this.replaceSystemAndProfileData(grouping);
        int[] nArray = this.findDateRangeIndices();
        int n5 = nArray[0];
        int n6 = nArray[1];
        String[] stringArray = this.getDateStrings(n5, n6);
        int[] nArray2 = this.getDates(n5, n6);
        String[] stringArray2 = new String[this.profile_system_names_in_file.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = this.profile_system_names_in_file[i].trim() + " " + this.profile_profile_names_in_file[i].trim();
        }
        float[] fArray = new float[this.temp_level_pressures.length];
        Arrays.fill(fArray, -32768.0f);
        if (n3 == 0) {
            for (n4 = 0; n4 < this.temp_level_pressures.length; ++n4) {
                fArray[n4] = this.temp_level_pressures[n4];
            }
        } else {
            fArray = new float[this.wvap_level_pressures.length];
            for (n4 = 0; n4 < this.wvap_level_pressures.length; ++n4) {
                fArray[n4] = this.wvap_level_pressures[n4];
            }
        }
        this.updateDataToDisplay(grouping, n, n2);
        HighchartScriptGenerator highchartScriptGenerator = new HighchartScriptGenerator(printWriter, grouping.getName(), f, n, n2, n3, this.is_longterm_plot, this.baseline_name, this.num_days, this.num_weeks, this.num_months, stringArray2, this.profile_system_ids_in_file, this.profile_system_numbers_in_file, this.profile_profile_types_in_file, n5, n6, stringArray, nArray2, fArray);
        highchartScriptGenerator.generateGraph();
    }

    private int[] findDateRangeIndices() {
        int[] nArray;
        block7: {
            int n;
            int n2;
            block8: {
                block6: {
                    nArray = new int[]{Short.MIN_VALUE, Short.MIN_VALUE};
                    n2 = this.globals.getDateRangeStart();
                    n = this.globals.getDateRangeEnd();
                    if (this.globals.getTimeWindow() != 0) break block6;
                    for (int i = 0; i < this.days.length; ++i) {
                        if (n2 == this.days[i]) {
                            nArray[0] = i;
                        }
                        if (n != this.days[i]) continue;
                        nArray[1] = i;
                    }
                    break block7;
                }
                if (this.globals.getTimeWindow() != 1) break block8;
                for (int i = 0; i < this.week_starts.length; ++i) {
                    if (n2 >= this.week_starts[i] && n2 <= this.week_ends[i]) {
                        nArray[0] = i;
                    }
                    if (n < this.week_starts[i] || n > this.week_ends[i]) continue;
                    nArray[1] = i;
                }
                break block7;
            }
            if (this.globals.getTimeWindow() != 2) break block7;
            int n3 = n2 / 10000;
            int n4 = n2 % 10000 / 100;
            int n5 = n / 10000;
            int n6 = n % 10000 / 100;
            for (int i = 0; i < this.months.length; ++i) {
                int n7 = this.months[i] / 100;
                int n8 = this.months[i] % 100;
                if (n3 == n7 && n4 == n8) {
                    nArray[0] = i;
                }
                if (n5 != n7 || n6 != n8) continue;
                nArray[1] = i;
            }
        }
        return nArray;
    }

    private int[] getDates(int n, int n2) {
        int[] nArray;
        block4: {
            block5: {
                block3: {
                    int n3 = n2 - n + 1;
                    nArray = new int[n3];
                    if (this.globals.getTimeWindow() != 0) break block3;
                    for (int i = n; i <= n2; ++i) {
                        nArray[i - n] = this.days[i];
                    }
                    break block4;
                }
                if (this.globals.getTimeWindow() != 1) break block5;
                for (int i = n; i <= n2; ++i) {
                    nArray[i - n] = this.week_starts[i];
                }
                break block4;
            }
            if (this.globals.getTimeWindow() != 2) break block4;
            for (int i = n; i <= n2; ++i) {
                int n4 = this.months[i] / 100;
                int n5 = this.months[i] % 100;
                nArray[i - n] = n4 * 10000 + n5 * 100 + 1;
            }
        }
        return nArray;
    }

    private String[] getDateStrings(int n, int n2) {
        String[] stringArray;
        block4: {
            block5: {
                block3: {
                    int n3 = n2 - n + 1;
                    stringArray = new String[n3];
                    if (this.globals.getTimeWindow() != 0) break block3;
                    for (int i = n; i <= n2; ++i) {
                        stringArray[i - n] = this.day_strings[i];
                    }
                    break block4;
                }
                if (this.globals.getTimeWindow() != 1) break block5;
                for (int i = n; i <= n2; ++i) {
                    stringArray[i - n] = this.week_strings[i];
                }
                break block4;
            }
            if (this.globals.getTimeWindow() != 2) break block4;
            for (int i = n; i <= n2; ++i) {
                stringArray[i - n] = this.month_strings[i];
            }
        }
        return stringArray;
    }

    private void createDateStrings() {
        int n;
        int n2;
        int n3;
        this.day_strings = new String[this.days.length];
        int n4 = 0;
        while (n4 < this.day_strings.length) {
            n3 = this.days[n4] / 10000;
            n2 = this.days[n4] % 10000 / 100;
            n = this.days[n4] % 100;
            this.day_strings[n4] = n2 < 10 ? " " + n2 + "/" : n2 + "/";
            if (n < 10) {
                int n5 = n4;
                this.day_strings[n5] = this.day_strings[n5] + "0";
            }
            int n6 = n4++;
            this.day_strings[n6] = this.day_strings[n6] + n + "/" + n3 % 100;
        }
        this.week_strings = new String[this.week_starts.length];
        n4 = 0;
        while (n4 < this.week_strings.length) {
            n3 = this.week_starts[n4] / 10000;
            n2 = this.week_starts[n4] % 10000 / 100;
            n = this.week_starts[n4] % 100;
            this.week_strings[n4] = n2 < 10 ? " " + n2 + "/" : n2 + "/";
            if (n < 10) {
                int n7 = n4;
                this.week_strings[n7] = this.week_strings[n7] + "0";
            }
            int n8 = n4++;
            this.week_strings[n8] = this.week_strings[n8] + n + "/" + n3 % 100;
        }
        this.month_strings = new String[this.months.length];
        for (n4 = 0; n4 < this.month_strings.length; ++n4) {
            n3 = this.months[n4] / 100;
            n2 = this.months[n4] % 100;
            this.month_strings[n4] = NarcsToHighcharts.getShortMonthString(n2) + " " + n3;
        }
    }

    public static String getShortMonthString(int n) {
        String string = "";
        switch (n) {
            case 1: {
                string = "Jan";
                break;
            }
            case 2: {
                string = "Feb";
                break;
            }
            case 3: {
                string = "Mar";
                break;
            }
            case 4: {
                string = "Apr";
                break;
            }
            case 5: {
                string = "May";
                break;
            }
            case 6: {
                string = "Jun";
                break;
            }
            case 7: {
                string = "Jul";
                break;
            }
            case 8: {
                string = "Aug";
                break;
            }
            case 9: {
                string = "Sep";
                break;
            }
            case 10: {
                string = "Oct";
                break;
            }
            case 11: {
                string = "Nov";
                break;
            }
            case 12: {
                string = "Dec";
            }
        }
        return string;
    }

    private void readNarcsFileHeader() {
        try {
            ZipFile zipFile = new ZipFile(this.input_file_name);
            ZipEntry zipEntry = zipFile.getEntry("narcsdir/header.dat");
            DataInputStream dataInputStream = new DataInputStream(zipFile.getInputStream(zipEntry));
            int n = dataInputStream.readInt();
            float f = (float)dataInputStream.readInt() / 10.0f;
            if (n != 78638165 || f != 3.0f) {
                System.out.println("The file type and version of the input file are not correct.");
                System.out.println("File name:  " + this.input_file_name);
                System.out.println("The <image_request> will be skipped.\n\n");
            } else {
                int n2;
                int n3;
                int n4 = dataInputStream.readInt();
                n4 = dataInputStream.readInt();
                int n5 = dataInputStream.readInt();
                int n6 = dataInputStream.readInt();
                int n7 = dataInputStream.readInt();
                int n8 = dataInputStream.readInt();
                this.temp_level_pressures = new float[n5];
                for (n3 = 0; n3 < n5; ++n3) {
                    this.temp_level_pressures[n3] = (float)dataInputStream.readInt() / 1000.0f;
                }
                this.wvap_level_pressures = new float[n6];
                for (n3 = 0; n3 < n6; ++n3) {
                    this.wvap_level_pressures[n3] = (float)dataInputStream.readInt() / 1000.0f;
                }
                this.temp_layer_pressures = new float[n7];
                for (n3 = 0; n3 < n7; ++n3) {
                    this.temp_layer_pressures[n3] = (float)dataInputStream.readInt() / 1000.0f;
                }
                this.wvap_layer_pressures = new float[n8];
                for (n3 = 0; n3 < n8; ++n3) {
                    this.wvap_layer_pressures[n3] = (float)dataInputStream.readInt() / 1000.0f;
                }
                this.num_days = dataInputStream.readInt();
                this.num_weeks = dataInputStream.readInt();
                this.num_months = dataInputStream.readInt();
                this.file_start_date = dataInputStream.readInt();
                this.file_end_date = dataInputStream.readInt();
                this.date_range_start = this.date_range_start == Short.MIN_VALUE ? this.file_start_date : Math.max(this.file_start_date, this.date_range_start);
                this.date_range_end = this.date_range_end == Short.MIN_VALUE ? this.file_end_date : Math.min(this.file_end_date, this.date_range_end);
                this.globals.setFileStartDate(this.file_start_date);
                this.globals.setFileEndDate(this.file_end_date);
                this.globals.setDateRangeStart(this.date_range_start);
                this.globals.setDateRangeEnd(this.date_range_end);
                this.days = new int[this.num_days];
                for (n3 = 0; n3 < this.num_days; ++n3) {
                    this.days[n3] = dataInputStream.readInt();
                }
                this.week_starts = new int[this.num_weeks];
                this.week_ends = new int[this.num_weeks];
                for (n3 = 0; n3 < this.num_weeks; ++n3) {
                    this.week_starts[n3] = dataInputStream.readInt();
                    this.week_ends[n3] = dataInputStream.readInt();
                }
                this.months = new int[this.num_months];
                for (n3 = 0; n3 < this.num_months; ++n3) {
                    this.months[n3] = dataInputStream.readInt();
                }
                this.createDateStrings();
                this.num_systems_in_file = dataInputStream.readInt();
                this.system_names_in_file = new String[this.num_systems_in_file];
                this.system_ids_in_file = new int[this.num_systems_in_file];
                Vector<Integer> vector = new Vector<Integer>();
                Vector<Integer> vector2 = new Vector<Integer>();
                Vector<Integer> vector3 = new Vector<Integer>();
                Vector<String> vector4 = new Vector<String>();
                Vector<Object> vector5 = new Vector<Object>();
                this.num_profiles_in_file = 0;
                for (n2 = 0; n2 < this.num_systems_in_file; ++n2) {
                    int n9;
                    this.system_ids_in_file[n2] = dataInputStream.readInt();
                    int n10 = dataInputStream.readInt();
                    this.system_names_in_file[n2] = "";
                    for (n9 = 0; n9 < n10; ++n9) {
                        int n11 = n2;
                        this.system_names_in_file[n11] = this.system_names_in_file[n11] + (char)dataInputStream.readInt();
                    }
                    n9 = dataInputStream.readInt();
                    for (int i = 0; i < n9; ++i) {
                        ++this.num_profiles_in_file;
                        int n12 = dataInputStream.readInt();
                        vector.addElement(new Integer(this.system_ids_in_file[n2]));
                        vector2.addElement(new Integer(n2));
                        vector3.addElement(new Integer(n12));
                        n10 = dataInputStream.readInt();
                        Object object = "";
                        for (int j = 0; j < n10; ++j) {
                            object = (String)object + (char)dataInputStream.readInt();
                        }
                        vector4.addElement(this.system_names_in_file[n2]);
                        vector5.addElement(object);
                    }
                }
                this.profile_system_ids_in_file = new int[this.num_profiles_in_file];
                this.profile_system_numbers_in_file = new int[this.num_profiles_in_file];
                this.profile_profile_types_in_file = new int[this.num_profiles_in_file];
                this.profile_system_names_in_file = new String[this.num_profiles_in_file];
                this.profile_profile_names_in_file = new String[this.num_profiles_in_file];
                for (n2 = 0; n2 < this.num_profiles_in_file; ++n2) {
                    this.profile_system_ids_in_file[n2] = (Integer)vector.elementAt(n2);
                    this.profile_system_numbers_in_file[n2] = (Integer)vector2.elementAt(n2);
                    this.profile_profile_types_in_file[n2] = (Integer)vector3.elementAt(n2);
                    this.profile_system_names_in_file[n2] = (String)vector4.elementAt(n2);
                    this.profile_profile_names_in_file[n2] = (String)vector5.elementAt(n2);
                }
            }
            dataInputStream.close();
        }
        catch (ZipException zipException) {
            System.out.println("*** Error reading the NARCS file ***");
            System.out.println("The image will be skipped.\n");
            zipException.printStackTrace();
        }
        catch (IOException iOException) {
            System.out.println("*** Error reading the NARCS file ***");
            System.out.println("The image will be skipped.\n");
            iOException.printStackTrace();
        }
    }

    private void readBaselineInformation() {
        try {
            ZipFile zipFile = new ZipFile(this.input_file_name);
            ZipEntry zipEntry = zipFile.getEntry("narcsdir/baseline_info.dat");
            DataInputStream dataInputStream = new DataInputStream(zipFile.getInputStream(zipEntry));
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            this.baseline_name = "";
            int n3 = dataInputStream.readInt();
            for (int i = 0; i < n3; ++i) {
                this.baseline_name = this.baseline_name + (char)dataInputStream.readInt();
            }
            dataInputStream.close();
        }
        catch (ZipException zipException) {
            System.out.println("*** Error reading the NARCS file ***");
            System.out.println("The image will be skipped.\n");
            zipException.printStackTrace();
        }
        catch (IOException iOException) {
            System.out.println("*** Error reading the NARCS file ***");
            System.out.println("The image will be skipped.\n");
            iOException.printStackTrace();
        }
    }

    private void initializeImageParameters() {
        this.start_date = Short.MIN_VALUE;
        this.end_date = Short.MIN_VALUE;
        this.data_type = 0;
        this.data_pressure = 1000.0f;
        this.min_max_option = 1;
        this.counts_min = 0;
        this.counts_max = 10000;
        this.data_min = -5.0f;
        this.data_max = 5.0f;
        this.ignore_extreme_values = false;
        this.time_option = 0;
        this.show_data_points = false;
        this.show_bias = true;
        this.show_stddev = true;
        this.show_rms = false;
        this.show_samplesize = false;
        this.use_sample_size_cutoff = true;
        this.sample_size_cutoff = 0.25f;
        this.show_baseline_both = true;
        this.show_baseline_sea = false;
        this.show_baseline_nonsea = false;
        this.show_system_both = true;
        this.show_system_sea = false;
        this.show_system_nonsea = false;
        this.show_pass = true;
        this.show_fail = false;
    }

    private void replaceSystemAndProfileData(Grouping grouping) {
        for (int i = 0; i < this.num_profiles_in_file; ++i) {
            for (int j = 0; j < grouping.getNumberOfProfiles(); ++j) {
                ProfileSettings profileSettings = grouping.getProfile(j);
                if (profileSettings.getPlatformID() != this.profile_system_ids_in_file[i] || profileSettings.getProfileID() != this.profile_profile_types_in_file[i]) continue;
                if (profileSettings.getPlatformName() != null) {
                    this.profile_system_names_in_file[i] = profileSettings.getPlatformName();
                }
                if (profileSettings.getProfileName() != null) {
                    this.profile_profile_names_in_file[i] = profileSettings.getProfileName();
                }
                int n = profileSettings.getPlatformID() * 100 + profileSettings.getProfileID();
                Color color = this.globals.getProfileColor(n);
                int n2 = color.getRed();
                int n3 = color.getGreen();
                int n4 = color.getBlue();
                if (profileSettings.getLineColorRed() == Short.MIN_VALUE || profileSettings.getLineColorGreen() == Short.MIN_VALUE || profileSettings.getLineColorBlue() == Short.MIN_VALUE) continue;
                n2 = profileSettings.getLineColorRed();
                n3 = profileSettings.getLineColorGreen();
                n4 = profileSettings.getLineColorBlue();
                color = new Color(n2, n3, n4);
                this.globals.setProfileColor(n, color);
            }
        }
    }

    private void updateDataToDisplay(Grouping grouping, int n, int n2) {
        int n3;
        int n4;
        boolean[] blArray = new boolean[3];
        Arrays.fill(blArray, false);
        boolean[] blArray2 = new boolean[3];
        Arrays.fill(blArray2, false);
        if (n == 2) {
            blArray[0] = true;
            blArray2[0] = true;
        } else if (n == 0) {
            blArray[1] = true;
            blArray2[1] = true;
        } else if (n == 1) {
            blArray[2] = true;
            blArray2[2] = true;
        }
        boolean[] blArray3 = new boolean[]{true, false};
        boolean[] blArray4 = new boolean[18];
        Arrays.fill(blArray4, false);
        for (n4 = 0; n4 < blArray.length; ++n4) {
            for (int i = 0; i < blArray2.length; ++i) {
                for (n3 = 0; n3 < blArray3.length; ++n3) {
                    int n5 = n3 * 9 + n4 * 3 + i;
                    blArray4[n5] = blArray[n4] && blArray2[i] && blArray3[n3];
                }
            }
        }
        this.globals.setShowCombination(blArray4);
        n4 = grouping.getNumberOfProfiles();
        Vector<Integer> vector = new Vector<Integer>(n4);
        for (n3 = 0; n3 < n4; ++n3) {
            ProfileSettings profileSettings = grouping.getProfile(n3);
            int n6 = profileSettings.getPlatformID() * 100 + profileSettings.getProfileID();
            vector.addElement(new Integer(n6));
        }
        this.globals.setVisibleProfiles(vector);
    }

    private void printTime() {
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(10);
        int n2 = calendar.get(12);
        int n3 = calendar.get(13);
        String string = n + ":";
        if (n2 < 10) {
            string = string + "0";
        }
        string = string + n2 + ":";
        if (n3 < 10) {
            string = string + "0";
        }
        string = string + n3 + "\t";
        System.out.println(string);
    }
}

