/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.util.HashMap;
import java.util.Vector;

public class NarcsToHighchartsGlobals {
    private static boolean variables_initialized;
    private static int file_start_date;
    private static int file_end_date;
    private static int date_range_start;
    private static int date_range_end;
    private static Vector visible_profiles;
    private static boolean show_bias;
    private static boolean show_stddev;
    private static boolean show_rms;
    private static boolean show_samplesize;
    private static boolean[] show_combination;
    private static int time_window;
    private static HashMap profile_color_map;
    private static int minmax_option;
    private static float temperature_bias_stats_min;
    private static float temperature_bias_stats_max;
    private static float temperature_stddev_stats_min;
    private static float temperature_stddev_stats_max;
    private static float temperature_rms_stats_min;
    private static float temperature_rms_stats_max;
    private static float water_vapor_bias_stats_min;
    private static float water_vapor_bias_stats_max;
    private static float water_vapor_stddev_stats_min;
    private static float water_vapor_stddev_stats_max;
    private static float water_vapor_rms_stats_min;
    private static float water_vapor_rms_stats_max;
    private static float default_temperature_bias_stats_min;
    private static float default_temperature_bias_stats_max;
    private static float default_temperature_stddev_stats_min;
    private static float default_temperature_stddev_stats_max;
    private static float default_temperature_rms_stats_min;
    private static float default_temperature_rms_stats_max;
    private static float default_water_vapor_bias_stats_min;
    private static float default_water_vapor_bias_stats_max;
    private static float default_water_vapor_stddev_stats_min;
    private static float default_water_vapor_stddev_stats_max;
    private static float default_water_vapor_rms_stats_min;
    private static float default_water_vapor_rms_stats_max;
    private static boolean ignore_extreme_values;
    private static boolean use_sample_size_display_cutoff;
    private static float sample_size_display_cutoff;
    private final int NUM_PIECES = 18;
    public static final int DAILY = 0;
    public static final int WEEKLY = 1;
    public static final int MONTHLY = 2;
    public static final int AUTOMATIC = 0;
    public static final int DEFAULT = 1;
    public static final int MANUAL = 2;
    public static final int TEMP_LEVEL = 0;
    public static final int TEMP_LAYER = 1;
    public static final int WVAP_LEVEL = 2;
    public static final int WVAP_LAYER = 3;
    public static final int TEMPERATURE = 0;
    public static final int WATER_VAPOR = 1;
    public static final int RELATIVE_HUMIDITY = 2;
    public static final int BIAS = 0;
    public static final int STDDEV = 1;
    public static final int RMS = 2;
    public static final int SAMPLE_SIZE = 3;
    public static final int SEA = 0;
    public static final int LAND = 1;
    public static final int LAND_AND_SEA = 2;

    public NarcsToHighchartsGlobals() {
        if (!variables_initialized) {
            this.initializeVariables();
        }
    }

    private void initializeVariables() {
        variables_initialized = true;
        file_start_date = Short.MIN_VALUE;
        file_end_date = Short.MIN_VALUE;
        date_range_start = Short.MIN_VALUE;
        date_range_end = Short.MIN_VALUE;
        visible_profiles = new Vector();
        show_combination = new boolean[18];
        for (int i = 0; i < 18; ++i) {
            NarcsToHighchartsGlobals.show_combination[i] = false;
        }
        NarcsToHighchartsGlobals.show_combination[0] = true;
        show_bias = true;
        show_stddev = true;
        show_rms = false;
        show_samplesize = false;
        time_window = 0;
        profile_color_map = new HashMap();
        minmax_option = 0;
        default_temperature_bias_stats_min = -5.0f;
        default_temperature_bias_stats_max = 5.0f;
        default_temperature_stddev_stats_min = 0.0f;
        default_temperature_stddev_stats_max = 5.0f;
        default_temperature_rms_stats_min = 0.0f;
        default_temperature_rms_stats_max = 5.0f;
        default_water_vapor_bias_stats_min = -50.0f;
        default_water_vapor_bias_stats_max = 50.0f;
        default_water_vapor_stddev_stats_min = 0.0f;
        default_water_vapor_stddev_stats_max = 100.0f;
        default_water_vapor_rms_stats_min = 0.0f;
        default_water_vapor_rms_stats_max = 100.0f;
        temperature_bias_stats_min = default_temperature_bias_stats_min;
        temperature_bias_stats_max = default_temperature_bias_stats_max;
        temperature_stddev_stats_min = default_temperature_stddev_stats_min;
        temperature_stddev_stats_max = default_temperature_stddev_stats_max;
        temperature_rms_stats_min = default_temperature_rms_stats_min;
        temperature_rms_stats_max = default_temperature_rms_stats_max;
        water_vapor_bias_stats_min = default_water_vapor_bias_stats_min;
        water_vapor_bias_stats_max = default_water_vapor_bias_stats_max;
        water_vapor_stddev_stats_min = default_water_vapor_stddev_stats_min;
        water_vapor_stddev_stats_max = default_water_vapor_stddev_stats_max;
        water_vapor_rms_stats_min = default_water_vapor_rms_stats_min;
        water_vapor_rms_stats_max = default_water_vapor_rms_stats_max;
        ignore_extreme_values = false;
        use_sample_size_display_cutoff = false;
        sample_size_display_cutoff = 0.25f;
        this.readDefaultColors();
    }

    public void readDefaultColors() {
        try {
            XMLParser xMLParser = new XMLParser();
            XMLTree xMLTree = xMLParser.parseFile("default_colors.xml");
            Object object = xMLTree.getValue("nprovs_color_ramps");
            if (object != null && object instanceof Vector) {
                Vector vector = (Vector)object;
                for (int i = 0; i < vector.size(); ++i) {
                    Object object2;
                    Object object3 = vector.elementAt(i);
                    if (object3 == null || !(object3 instanceof XMLTree)) continue;
                    XMLTree xMLTree2 = (XMLTree)object3;
                    int n = Short.MIN_VALUE;
                    object3 = xMLTree2.getValue("id");
                    if (object3 != null && object3 instanceof String) {
                        object2 = (String)object3;
                        n = Integer.parseInt((String)object2);
                    }
                    if ((object3 = xMLTree2.getValue("profiles")) == null || !(object3 instanceof Vector)) continue;
                    object2 = (Vector)object3;
                    for (int j = 0; j < ((Vector)object2).size(); ++j) {
                        object3 = ((Vector)object2).elementAt(j);
                        if (object3 == null || !(object3 instanceof XMLTree)) continue;
                        XMLTree xMLTree3 = (XMLTree)object3;
                        int n2 = Short.MIN_VALUE;
                        object3 = xMLTree3.getValue("type");
                        if (object3 != null && object3 instanceof String) {
                            String string = (String)object3;
                            n2 = Integer.parseInt(string);
                        }
                        int n3 = Short.MIN_VALUE;
                        object3 = xMLTree3.getValue("red");
                        if (object3 != null && object3 instanceof String) {
                            String string = (String)object3;
                            n3 = Integer.parseInt(string);
                        }
                        int n4 = Short.MIN_VALUE;
                        object3 = xMLTree3.getValue("green");
                        if (object3 != null && object3 instanceof String) {
                            String string = (String)object3;
                            n4 = Integer.parseInt(string);
                        }
                        int n5 = Short.MIN_VALUE;
                        object3 = xMLTree3.getValue("blue");
                        if (object3 != null && object3 instanceof String) {
                            String string = (String)object3;
                            n5 = Integer.parseInt(string);
                        }
                        if (n == Short.MIN_VALUE || n2 == Short.MIN_VALUE || n3 == Short.MIN_VALUE || n4 == Short.MIN_VALUE || n5 == Short.MIN_VALUE) continue;
                        int n6 = n * 100 + n2;
                        this.setProfileColor(n6, new Color(n3, n4, n5));
                    }
                }
            }
        }
        catch (XMLParserException xMLParserException) {
            System.out.println("\nThe default colors file could not be parsed.");
            System.out.println("The structure of the XML data is probably not correct.");
            System.out.println("Please check the file and try again.\n");
            System.exit(1);
        }
    }

    public void setFileStartDate(int n) {
        file_start_date = n;
    }

    public int getFileStartDate() {
        return file_start_date;
    }

    public void setFileEndDate(int n) {
        file_end_date = n;
    }

    public int getFileEndDate() {
        return file_end_date;
    }

    public void setDateRangeStart(int n) {
        date_range_start = n;
    }

    public int getDateRangeStart() {
        return date_range_start;
    }

    public void setDateRangeEnd(int n) {
        date_range_end = n;
    }

    public int getDateRangeEnd() {
        return date_range_end;
    }

    public void setProfileColor(int n, Color color) {
        profile_color_map.put(n, color);
    }

    public Color getProfileColor(int n) {
        Color color = (Color)profile_color_map.get(n);
        if (color == null) {
            color = Color.black;
        }
        return color;
    }

    public void setMinMaxOption(int n) {
        minmax_option = n;
    }

    public int getMinMaxOption() {
        return minmax_option;
    }

    public float getStatDefaultMinimum(int n, int n2) {
        float f = 0.0f;
        if (n2 == 0) {
            f = n == 0 ? default_temperature_bias_stats_min : (n == 1 ? default_temperature_stddev_stats_min : default_temperature_rms_stats_min);
        } else if (n2 == 1) {
            f = n == 0 ? default_water_vapor_bias_stats_min : (n == 1 ? default_water_vapor_stddev_stats_min : default_water_vapor_rms_stats_min);
        }
        return f;
    }

    public float getStatDefaultMaximum(int n, int n2) {
        float f = 0.0f;
        if (n2 == 0) {
            f = n == 0 ? default_temperature_bias_stats_max : (n == 1 ? default_temperature_stddev_stats_max : default_temperature_rms_stats_max);
        } else if (n2 == 1) {
            f = n == 0 ? default_water_vapor_bias_stats_max : (n == 1 ? default_water_vapor_stddev_stats_max : default_water_vapor_rms_stats_max);
        }
        return f;
    }

    public float getStatManualMinimum(int n, int n2) {
        float f = 0.0f;
        if (n2 == 0) {
            f = n == 0 ? temperature_bias_stats_min : (n == 1 ? temperature_stddev_stats_min : temperature_rms_stats_min);
        } else if (n2 == 1) {
            f = n == 0 ? water_vapor_bias_stats_min : (n == 1 ? water_vapor_stddev_stats_min : water_vapor_rms_stats_min);
        }
        return f;
    }

    public float getStatManualMaximum(int n, int n2) {
        float f = 0.0f;
        if (n2 == 0) {
            f = n == 0 ? temperature_bias_stats_max : (n == 1 ? temperature_stddev_stats_max : temperature_rms_stats_max);
        } else if (n2 == 1) {
            f = n == 0 ? water_vapor_bias_stats_max : (n == 1 ? water_vapor_stddev_stats_max : water_vapor_rms_stats_max);
        }
        return f;
    }

    public void setTemperatureBiasStatsMin(float f) {
        temperature_bias_stats_min = f;
    }

    public float getTemperatureBiasStatsMin() {
        return temperature_bias_stats_min;
    }

    public void setTemperatureBiasStatsMax(float f) {
        temperature_bias_stats_max = f;
    }

    public float getTemperatureBiasStatsMax() {
        return temperature_bias_stats_max;
    }

    public void setTemperatureStddevStatsMin(float f) {
        temperature_stddev_stats_min = f;
    }

    public float getTemperatureStddevStatsMin() {
        return temperature_stddev_stats_min;
    }

    public void setTemperatureStddevStatsMax(float f) {
        temperature_stddev_stats_max = f;
    }

    public float getTemperatureStddevStatsMax() {
        return temperature_stddev_stats_max;
    }

    public void setTemperatureRMSStatsMin(float f) {
        temperature_rms_stats_min = f;
    }

    public float getTemperatureRMSStatsMin() {
        return temperature_rms_stats_min;
    }

    public void setTemperatureRMSStatsMax(float f) {
        temperature_rms_stats_max = f;
    }

    public float getTemperatureRMSStatsMax() {
        return temperature_rms_stats_max;
    }

    public void setWaterVaporBiasStatsMin(float f) {
        water_vapor_bias_stats_min = f;
    }

    public float getWaterVaporBiasStatsMin() {
        return water_vapor_bias_stats_min;
    }

    public void setWaterVaporBiasStatsMax(float f) {
        water_vapor_bias_stats_max = f;
    }

    public float getWaterVaporBiasStatsMax() {
        return water_vapor_bias_stats_max;
    }

    public void setWaterVaporStddevStatsMin(float f) {
        water_vapor_stddev_stats_min = f;
    }

    public float getWaterVaporStddevStatsMin() {
        return water_vapor_stddev_stats_min;
    }

    public void setWaterVaporStddevStatsMax(float f) {
        water_vapor_stddev_stats_max = f;
    }

    public float getWaterVaporStddevStatsMax() {
        return water_vapor_stddev_stats_max;
    }

    public void setWaterVaporRMSStatsMin(float f) {
        water_vapor_rms_stats_min = f;
    }

    public float getWaterVaporRMSStatsMin() {
        return water_vapor_rms_stats_min;
    }

    public void setWaterVaporRMSStatsMax(float f) {
        water_vapor_rms_stats_max = f;
    }

    public float getWaterVaporRMSStatsMax() {
        return water_vapor_rms_stats_max;
    }

    public void setIgnoreExtremeValues(boolean bl) {
        ignore_extreme_values = bl;
    }

    public boolean getIgnoreExtremeValues() {
        return ignore_extreme_values;
    }

    public void setUseSampleSizeCutoff(boolean bl) {
        use_sample_size_display_cutoff = bl;
    }

    public boolean getUseSampleSizeCutoff() {
        return use_sample_size_display_cutoff;
    }

    public void setSampleSizeCutoff(float f) {
        sample_size_display_cutoff = f;
    }

    public float getSampleSizeCutoff() {
        return sample_size_display_cutoff;
    }

    public void setTimeWindow(int n) {
        time_window = n;
    }

    public int getTimeWindow() {
        return time_window;
    }

    public void setShowBias(boolean bl) {
        show_bias = bl;
    }

    public boolean getShowBias() {
        return show_bias;
    }

    public void setShowStdDev(boolean bl) {
        show_stddev = bl;
    }

    public boolean getShowStdDev() {
        return show_stddev;
    }

    public void setShowRMS(boolean bl) {
        show_rms = bl;
    }

    public boolean getShowRMS() {
        return show_rms;
    }

    public void setShowSampleSize(boolean bl) {
        show_samplesize = bl;
    }

    public boolean getShowSampleSize() {
        return show_samplesize;
    }

    public void setShowCombination(boolean[] blArray) {
        for (int i = 0; i < 18; ++i) {
            NarcsToHighchartsGlobals.show_combination[i] = blArray[i];
        }
    }

    public boolean[] getShowCombination() {
        boolean[] blArray = new boolean[18];
        for (int i = 0; i < 18; ++i) {
            blArray[i] = show_combination[i];
        }
        return blArray;
    }

    public void setVisibleProfiles(Vector vector) {
        visible_profiles = vector;
    }

    public Vector getVisibleProfiles() {
        return visible_profiles;
    }
}

