/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class HeatmapScriptGenerator {
    private String clean_profile_name;
    private String profile_name;
    private int terrain;
    private int stat_type;
    private int data_type;
    private boolean is_longterm_plot;
    private String baseline_name;
    private int num_days;
    private int num_weeks;
    private int num_months;
    private int date_start_index;
    private int date_end_index;
    private String[] date_strings;
    private String[] profile_names;
    private int[] dates;
    private int[] profile_system_ids;
    private int[] profile_system_numbers;
    private int[] profile_types;
    private float[] pressures;
    private int[] pressure_indices;
    private Vector visible_profile_vector;
    private int min_count;
    private int max_count;
    private float min_stat;
    private float max_stat;
    private float[][] data_array;
    private int[][] sample_size_array;
    private NarcsToHighchartsGlobals globals;
    private final int SYSTEM = 0;
    private final int RETRIEVAL = 1;
    private final int GUESS = 2;
    private final int FORECAST = 3;
    private final int MICROWAVE = 4;
    private final int INFRARED = 5;
    private final int RAW_DRY = 6;
    private final int NUM_PIECES = 18;
    private PrintWriter pw;
    private PrintWriter out;
    private String file_name;

    public HeatmapScriptGenerator(PrintWriter printWriter, String string, String string2, int n, int n2, int n3, boolean bl, String string3, int n4, int n5, int n6, String[] stringArray, int[] nArray, int[] nArray2, int[] nArray3, int n7, int n8, String[] stringArray2, int[] nArray4, float[] fArray, int[] nArray5) {
        this.out = printWriter;
        this.clean_profile_name = string;
        this.profile_name = string2;
        this.terrain = n;
        this.stat_type = n2;
        this.data_type = n3;
        this.is_longterm_plot = bl;
        this.pressures = fArray;
        this.pressure_indices = nArray5;
        this.baseline_name = string3;
        this.num_days = n4;
        this.num_weeks = n5;
        this.num_months = n6;
        this.profile_names = stringArray;
        this.profile_system_ids = nArray;
        this.profile_system_numbers = nArray2;
        this.profile_types = nArray3;
        this.date_start_index = n7;
        this.date_end_index = n8;
        this.date_strings = stringArray2;
        this.dates = nArray4;
        this.globals = new NarcsToHighchartsGlobals();
        this.visible_profile_vector = new Vector();
    }

    public void generateGraph() {
        this.visible_profile_vector.removeAllElements();
        this.buildDataArray();
        this.removeUnwantedData();
        this.findStatisticMinMax();
        this.drawTitle();
        this.drawXAxis();
        this.drawYAxis();
        this.drawColorScale();
        this.drawMainGraph();
        this.out.println("  })");
        this.out.flush();
    }

    private void drawTitle() {
        String string = this.clean_profile_name + "_";
        string = this.terrain == 0 ? string + "Sea_" : (this.terrain == 1 ? string + "Land_" : string + "LandAndSea_");
        if (this.data_type == 0) {
            string = string + "Temperature_";
        } else if (this.data_type == 1) {
            string = string + "WaterVapor_";
        }
        string = this.stat_type == 0 ? string + "Bias" : (this.stat_type == 1 ? string + "StdDev" : (this.stat_type == 2 ? string + "RMS" : string + "SampleSize"));
        this.out.println("");
        this.out.println("$('#" + string + "').highcharts(");
        this.out.println("  {");
        this.out.println("");
        this.out.println("  chart:");
        this.out.println("    {");
        this.out.println("    type: 'heatmap',");
        this.out.println("    plotBackgroundColor: '#000000',");
        this.out.println("    plotBorderWidth: 2,");
        this.out.println("    plotBorderColor:  '#000000'");
        this.out.println("    },");
        this.out.println("");
        this.out.println("  boost:");
        this.out.println("    {");
        this.out.println("    useGPUTranslations: true");
        this.out.println("    },");
        this.out.println("");
        this.out.println("  title:");
        this.out.println("    {");
        this.out.println("    text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',");
        this.out.println("    },");
        this.out.println("");
        String string2 = this.profile_name + ", ";
        string2 = this.terrain == 0 ? string2 + "Sea, " : (this.terrain == 1 ? string2 + "Land, " : string2 + "Land and Sea, ");
        if (this.data_type == 0) {
            string2 = string2 + "Temperature, ";
        } else if (this.data_type == 1) {
            string2 = string2 + "Water Vapor, ";
        }
        string2 = this.stat_type == 0 ? string2 + "Bias" : (this.stat_type == 1 ? string2 + "StdDev" : (this.stat_type == 2 ? string2 + "RMS" : string2 + "Sample Size"));
        this.out.println("  subtitle:");
        this.out.println("    {");
        this.out.println("    text: '" + string2 + "',");
        this.out.println("    style:");
        this.out.println("      {");
        this.out.println("      color: '#555555',");
        this.out.println("      fontWeight: 'bold'");
        this.out.println("      },");
        this.out.println("");
        this.out.println("    x: -20 //center");
        this.out.println("    },");
        this.out.println("");
        this.out.flush();
    }

    private void drawXAxis() {
        this.out.println("  xAxis:");
        this.out.println("    {");
        this.out.println("    categories:");
        this.out.println("      [");
        int n = 0;
        for (int i = 0; i < this.date_strings.length; ++i) {
            if (++n > 6) {
                this.out.println("");
                n = 1;
            }
            if (n == 1) {
                this.out.print("      ");
            }
            this.out.print("'" + this.date_strings[i] + "'");
            if (i == this.date_strings.length - 1) continue;
            this.out.print(", ");
        }
        this.out.println("\n      ],");
        this.out.println("");
        this.out.println("    labels:");
        this.out.println("      {");
        this.out.println("      rotation: 90");
        this.out.println("      },");
        this.out.println("");
        this.out.println("    minorGridLineDashStyle: 'longdash',");
        this.out.println("    minorTickInterval: 'auto',");
        this.out.println("    minorTickWidth: 0,");
        this.out.println("");
        this.out.println("    plotLines:");
        this.out.println("      [{");
        this.out.println("      dashStyle: 'longdash',");
        this.out.println("      value: 0,");
        this.out.println("      width: 1,");
        this.out.println("      color: '#808080'");
        this.out.println("      }]");
        this.out.println("    },");
        this.out.println("");
        this.out.flush();
    }

    private void drawYAxis() {
        this.out.println("  yAxis:");
        this.out.println("    {");
        this.out.println("    categories:");
        this.out.println("      [");
        int n = 0;
        String string = "      ";
        for (int i = 0; i < this.pressures.length; ++i) {
            ++n;
            this.out.print(string);
            if (this.pressures[i] >= 10.0f) {
                this.out.print("'" + (int)this.pressures[i] + "'");
            } else {
                this.out.print("'" + this.pressures[i] + "'");
            }
            if (n <= 9) {
                string = ", ";
                continue;
            }
            n = 0;
            string = ",\n      ";
        }
        this.out.println(", ' ', ' ', ' ', ' ', ' ', ' '");
        this.out.println("\n      ],");
        this.out.println("");
        this.out.println("    title:");
        this.out.println("      {");
        this.out.println("      text: \"Pressure (hPa)\"");
        this.out.println("      },");
        this.out.println("");
        this.out.println("    labels:");
        this.out.println("      {");
        this.out.println("      rotation: 0");
        this.out.println("      },");
        this.out.println("");
        this.out.println("    minorGridLineDashStyle: 'longdash',");
        this.out.println("    minorTickInterval: 'auto',");
        this.out.println("    minorTickWidth: 0,");
        this.out.println("");
        this.out.println("    plotLines:");
        this.out.println("      [{");
        this.out.println("      dashStyle: 'longdash',");
        this.out.println("      value: 0,");
        this.out.println("      width: 1,");
        this.out.println("      color: '#808080'");
        this.out.println("      }],");
        this.out.println("");
        this.out.println("    reversed: true");
        this.out.println("    },");
        this.out.println("");
        this.out.flush();
    }

    private void drawColorScale() {
        this.out.println("  colorAxis:");
        this.out.println("    {");
        this.out.println("    stops:");
        this.out.println("      [");
        if (this.stat_type == 0) {
            this.out.println("      [0, '#00ff00'],");
            this.out.println("      [0.01, '#00ff00'],");
            this.out.println("      [0.01, '#000088'],");
            this.out.println("      [0.5, '#ffffff'],");
            this.out.println("      [0.99, '#880000'],");
            this.out.println("      [0.99, '#ffff00'],");
            this.out.println("      [1, '#ffff00']");
        } else {
            this.out.println("      [0, '#8888ff'],");
            this.out.println("      [0.01, '#8888ff'],");
            this.out.println("      [0.01, '#ff00ff'],");
            this.out.println("      [0.20, '#0000ff'],");
            this.out.println("      [0.40, '#00ff00'],");
            this.out.println("      [0.60, '#ffff00'],");
            this.out.println("      [0.80, '#ff8800'],");
            this.out.println("      [0.99, '#880000'],");
            this.out.println("      [0.99, '#ff8888'],");
            this.out.println("      [1, '#ff8888']");
        }
        this.out.println("      ],");
        this.out.println("");
        float f = this.min_stat - (this.max_stat - this.min_stat) * 0.01f;
        float f2 = this.max_stat + (this.max_stat - this.min_stat) * 0.01f;
        this.out.println("    min: " + f + ",");
        this.out.println("    max: " + f2 + ",");
        this.out.println("    width: '50%',");
        this.out.println("    startOnTick: false,");
        this.out.println("    endOnTick: false,");
        this.out.println("");
        this.out.println("    labels:");
        this.out.println("      {");
        if (this.stat_type == 3) {
            this.out.println("      format: '{value}'");
        } else if (this.data_type == 0) {
            this.out.println("      format: '{value}\u00b0K'");
        } else {
            this.out.println("      format: '{value}%'");
        }
        this.out.println("      }");
        this.out.println("    },");
        this.out.println("");
        this.out.flush();
    }

    private void drawMainGraph() {
        this.out.println("  series:");
        this.out.println("    [{");
        this.out.println("    boostThreshold: 100,");
        this.out.println("    borderWidth: 0,");
        this.out.println("    nullColor: '#EFEFEF',");
        this.out.println("");
        this.out.println("    tooltip:");
        this.out.println("      {");
        if (this.stat_type == 0) {
            this.out.println("      headerFormat: 'Bias<br/>',");
        } else if (this.stat_type == 1) {
            this.out.println("      headerFormat: 'Std Dev<br/>',");
        } else if (this.stat_type == 2) {
            this.out.println("      headerFormat: 'RMS<br/>',");
        } else {
            this.out.println("      headerFormat: 'Sample Size<br/>',");
        }
        this.out.println("      pointFormatter: function()");
        this.out.println("        {");
        this.out.println("        return `${getPointCategoryName(this, 'x')}, ${getPointCategoryName(this, 'y')} hPa: <b>${this.value}</b>`;");
        this.out.println("        },");
        this.out.println("      nullFormat: \"Value not availible\"");
        this.out.println("      },");
        this.out.println("");
        this.out.println("    turboThreshold: Number.MAX_VALUE, // #3404, remove after 4.0.5 release");
        this.out.println("");
        this.out.println("    data:");
        this.out.println("      [");
        int n = 0;
        String string = "      ";
        for (int i = 0; i < this.pressures.length; ++i) {
            for (int j = 0; j < this.date_strings.length; ++j) {
                ++n;
                this.out.print(string);
                if (this.data_array[i][j] != -32768.0f) {
                    this.out.print("[" + j + ", " + i + ", " + this.data_array[i][j] + "]");
                } else {
                    this.out.print("[" + j + ", " + i + ", null]");
                }
                if (n <= 4) {
                    string = ", ";
                    continue;
                }
                n = 0;
                string = ",\n      ";
            }
        }
        this.out.println("\n      ],");
        this.out.println("");
        this.out.println("    //colsize: stepSize, //setting the column width");
        this.out.println("    //rowsize: 2 //setting the row height");
        this.out.println("    nullColor: '#000000'");
        this.out.println("    }]");
        this.out.println("");
        this.out.flush();
    }

    private void buildDataArray() {
        int n;
        int n2 = this.pressures.length;
        int n3 = this.dates.length;
        this.data_array = new float[n2][n3];
        this.sample_size_array = new int[n2][n3];
        for (int i = 0; i < n2; ++i) {
            for (n = 0; n < n3; ++n) {
                this.data_array[i][n] = -32768.0f;
                this.sample_size_array[i][n] = Short.MIN_VALUE;
            }
        }
        Vector vector = this.globals.getVisibleProfiles();
        n = (Integer)vector.elementAt(0);
        int n4 = n / 100;
        int n5 = n % 100;
        int n6 = Short.MIN_VALUE;
        for (int i = 0; i < this.profile_system_ids.length; ++i) {
            if (n4 != this.profile_system_ids[i]) continue;
            n6 = this.profile_system_numbers[i];
        }
        if (n6 != Short.MIN_VALUE) {
            boolean[] blArray = this.globals.getShowCombination();
            for (int i = 0; i < 18; ++i) {
                if (!blArray[i]) continue;
                NarcsDataProfile narcsDataProfile = null;
                NarcsDataProfile narcsDataProfile2 = null;
                for (int j = 0; j < this.pressures.length; ++j) {
                    int n7;
                    narcsDataProfile = this.buildProfile(n4, n6, n5, 3, this.pressure_indices[j], i, null);
                    narcsDataProfile2 = this.buildProfile(n4, n6, n5, this.stat_type, this.pressure_indices[j], i, narcsDataProfile);
                    if (narcsDataProfile != null) {
                        for (n7 = 0; n7 < n3; ++n7) {
                            this.sample_size_array[j][n7] = (int)narcsDataProfile.getValue(n7);
                        }
                    }
                    if (narcsDataProfile2 == null) continue;
                    for (n7 = 0; n7 < n3; ++n7) {
                        this.data_array[j][n7] = narcsDataProfile2.getValue(n7);
                    }
                }
            }
        }
    }

    private NarcsDataProfile buildProfile(int n, int n2, int n3, int n4, int n5, int n6, NarcsDataProfile narcsDataProfile) {
        NarcsDataProfile narcsDataProfile2 = null;
        int n7 = this.globals.getTimeWindow();
        Object object = "/";
        object = n7 == 0 ? (String)object + "daily" : (n7 == 1 ? (String)object + "weekly" : (String)object + "monthly");
        object = (String)object + "_system" + n2;
        object = n3 < 10 ? (String)object + "_profile0" + n3 + "_" : (String)object + "_profile" + n3 + "_";
        if (this.data_type == 0) {
            object = (String)object + "templevel";
        } else if (this.data_type == 1) {
            object = (String)object + "wvaplevel";
        }
        object = (String)object + n5;
        if (n4 == 0) {
            object = (String)object + "_bias.dat";
        } else if (n4 == 1) {
            object = (String)object + "_stddev.dat";
        } else if (n4 == 2) {
            object = (String)object + "_rms.dat";
        } else if (n4 == 3) {
            object = (String)object + "_counts.dat";
        }
        String string = "input.file";
        try {
            Object object2;
            File file;
            DataInputStream dataInputStream = null;
            if (string != null && (file = new File(string)).exists()) {
                try {
                    object2 = new ZipFile(string);
                    ZipEntry zipEntry = ((ZipFile)object2).getEntry("narcsdir" + (String)object);
                    if (zipEntry != null) {
                        dataInputStream = new DataInputStream(((ZipFile)object2).getInputStream(zipEntry));
                    }
                }
                catch (ZipException zipException) {
                    zipException.printStackTrace();
                }
            }
            if (dataInputStream != null) {
                int n8;
                int n9 = this.num_days;
                if (this.globals.getTimeWindow() == 1) {
                    n9 = this.num_weeks;
                } else if (this.globals.getTimeWindow() == 2) {
                    n9 = this.num_months;
                }
                object2 = new byte[n9 * 4];
                int n10 = n6 * ((Object)object2).length;
                dataInputStream.skipBytes(n10);
                dataInputStream.readFully((byte[])object2);
                float[] fArray = new float[n9];
                DataInputStream dataInputStream2 = new DataInputStream(new ByteArrayInputStream((byte[])object2));
                for (n8 = 0; n8 < n9; ++n8) {
                    int n11 = dataInputStream2.readInt();
                    if (n11 == Short.MIN_VALUE) {
                        fArray[n8] = -32768.0f;
                        continue;
                    }
                    fArray[n8] = n4 == 3 ? (float)n11 : (float)n11 / 1000.0f;
                }
                dataInputStream2.close();
                n8 = this.date_end_index - this.date_start_index + 1;
                float[] fArray2 = new float[n8];
                for (int i = this.date_start_index; i <= this.date_end_index; ++i) {
                    fArray2[i - this.date_start_index] = fArray[i];
                }
                String string2 = "system name";
                for (int i = 0; i < this.profile_names.length; ++i) {
                    if (n != this.profile_system_ids[i] || n3 != this.profile_types[i]) continue;
                    string2 = this.profile_names[i];
                }
                narcsDataProfile2 = new NarcsDataProfile(fArray2, Color.black, n, n2, n3, n4, n6, 0, 0, string2, narcsDataProfile);
                dataInputStream.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return narcsDataProfile2;
    }

    private void removeUnwantedData() {
        int n;
        int n2;
        int n3 = this.pressures.length;
        int n4 = this.dates.length;
        if (this.globals.getUseSampleSizeCutoff()) {
            n2 = 0;
            n = 0;
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n4; ++j) {
                    if ((float)this.sample_size_array[i][j] == -32768.0f || this.data_array[i][j] == -32768.0f) continue;
                    n2 += this.sample_size_array[i][j];
                    ++n;
                }
            }
            float f = (float)n2 / (float)n;
            float f2 = f * (1.0f / this.globals.getSampleSizeCutoff());
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n4; ++j) {
                    if (!((float)this.sample_size_array[i][j] < f2)) continue;
                    this.data_array[i][j] = -32768.0f;
                }
            }
        }
        if (this.globals.getIgnoreExtremeValues()) {
            this.findStatisticMinMax();
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < n4; ++n) {
                    if (!(this.data_array[n2][n] < this.min_stat) && !(this.data_array[n2][n] > this.max_stat)) continue;
                    this.data_array[n2][n] = -32768.0f;
                }
            }
        }
    }

    private void findStatisticMinMax() {
        this.min_stat = -5.0f;
        this.max_stat = 5.0f;
        if (this.globals.getMinMaxOption() == 1) {
            this.min_stat = this.globals.getStatDefaultMinimum(this.stat_type, this.data_type);
            this.max_stat = this.globals.getStatDefaultMaximum(this.stat_type, this.data_type);
        } else if (this.globals.getMinMaxOption() == 2) {
            this.min_stat = this.globals.getStatManualMinimum(this.stat_type, this.data_type);
            this.max_stat = this.globals.getStatManualMaximum(this.stat_type, this.data_type);
        } else {
            this.min_stat = 9999999.0f;
            this.max_stat = -9999999.0f;
            int n = this.pressures.length;
            int n2 = this.dates.length;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    if (this.data_array[i][j] == -32768.0f) continue;
                    this.min_stat = Math.min(this.min_stat, this.data_array[i][j]);
                    this.max_stat = Math.max(this.max_stat, this.data_array[i][j]);
                }
            }
            if (this.min_stat == 9999999.0f || this.min_stat == -9999999.0f || this.max_stat == 9999999.0f || this.max_stat == -9999999.0f) {
                this.min_stat = -5.0f;
                this.max_stat = 5.0f;
            }
            if (this.min_stat == 0.0f && this.max_stat == 0.0f) {
                this.min_stat = -10.0f;
                this.max_stat = 10.0f;
            }
        }
    }
}

