/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;

public class NarcsDataProfile
implements Externalizable {
    static final long serialVersionUID = 1L;
    private int class_version = 1;
    private boolean visible;
    private Color default_line_color;
    private Color line_color;
    private int default_line_thickness;
    private int line_thickness;
    private int default_line_style;
    private int line_style;
    private int system_id;
    private int group_num;
    private int profile_type;
    private int stat_type;
    private int piece;
    private int terrain_type;
    private int cloud_type;
    private String label;
    private float[] values;
    private NarcsDataProfile sample_size_profile;

    public NarcsDataProfile() {
    }

    public NarcsDataProfile(float[] fArray, Color color, int n, int n2, int n3, int n4, int n5, int n6, int n7, String string) {
        this.values = (float[])fArray.clone();
        this.line_color = color;
        this.system_id = n;
        this.group_num = n2;
        this.profile_type = n3;
        this.stat_type = n4;
        this.piece = n5;
        this.terrain_type = n6;
        this.cloud_type = n7;
        this.label = string;
        this.sample_size_profile = null;
        this.default_line_color = color;
    }

    public NarcsDataProfile(float[] fArray, Color color, int n, int n2, int n3, int n4, int n5, int n6, int n7, String string, NarcsDataProfile narcsDataProfile) {
        this.values = (float[])fArray.clone();
        this.line_color = color;
        this.system_id = n;
        this.group_num = n2;
        this.profile_type = n3;
        this.stat_type = n4;
        this.piece = n5;
        this.terrain_type = n6;
        this.cloud_type = n7;
        this.label = string;
        this.sample_size_profile = narcsDataProfile;
        this.default_line_color = color;
    }

    public void setValues(float[] fArray) {
        this.values = (float[])fArray.clone();
    }

    public float getValue(int n) {
        float f = -32768.0f;
        if (n < this.values.length) {
            f = this.values[n];
        }
        return f;
    }

    public float[] getValues() {
        return (float[])this.values.clone();
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public int getNumberOfPoints() {
        return this.values.length;
    }

    public float getMinimumValue() {
        float f = 999999.0f;
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == -32768.0f) continue;
            f = Math.min(f, this.values[i]);
        }
        return f;
    }

    public float getMaximumValue() {
        float f = -999999.0f;
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == -32768.0f) continue;
            f = Math.max(f, this.values[i]);
        }
        return f;
    }

    public int getSystemID() {
        return this.system_id;
    }

    public int getGroupNumber() {
        return this.group_num;
    }

    public int getProfileType() {
        return this.profile_type;
    }

    public int getStatType() {
        return this.stat_type;
    }

    public int getPieceNumber() {
        return this.piece;
    }

    public int getTerrainType() {
        return this.terrain_type;
    }

    public int getCloudType() {
        return this.cloud_type;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public void setLineColor(Color color) {
        this.line_color = color;
    }

    public Color getLineColor() {
        return this.line_color;
    }

    public Color getDefaultLineColor() {
        return this.default_line_color;
    }

    public void setLineThickness(int n) {
        this.line_thickness = n;
    }

    public int getLineThickness() {
        return this.line_thickness;
    }

    public int getDefaultLineThickness() {
        return this.default_line_thickness;
    }

    public void setLineStyle(int n) {
        this.line_style = n;
    }

    public int getLineStyle() {
        return this.line_style;
    }

    public int getDefaultLineStyle() {
        return this.default_line_style;
    }

    public NarcsDataProfile getSampleSizeProfile() {
        return this.sample_size_profile;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("visible", this.visible);
        hashMap.put("group_num", this.group_num);
        hashMap.put("profile_type", this.profile_type);
        hashMap.put("stat_type", this.stat_type);
        hashMap.put("piece", this.piece);
        hashMap.put("terrain_type", this.terrain_type);
        hashMap.put("cloud_type", this.cloud_type);
        hashMap.put("label", this.label);
        hashMap.put("values", this.values);
        hashMap.put("sample_size_profile", this.sample_size_profile);
        objectOutput.writeObject(hashMap);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        HashMap hashMap = (HashMap)objectInput.readObject();
        if (hashMap.containsKey("visible")) {
            this.visible = (Boolean)hashMap.get("visible");
        }
        if (hashMap.containsKey("group_num")) {
            this.group_num = (Integer)hashMap.get("group_num");
        }
        if (hashMap.containsKey("profile_type")) {
            this.profile_type = (Integer)hashMap.get("profile_type");
        }
        if (hashMap.containsKey("stat_type")) {
            this.stat_type = (Integer)hashMap.get("stat_type");
        }
        if (hashMap.containsKey("piece")) {
            this.piece = (Integer)hashMap.get("piece");
        }
        if (hashMap.containsKey("terrain_type")) {
            this.terrain_type = (Integer)hashMap.get("terrain_type");
        }
        if (hashMap.containsKey("cloud_type")) {
            this.cloud_type = (Integer)hashMap.get("cloud_type");
        }
        if (hashMap.containsKey("label")) {
            this.label = (String)hashMap.get("label");
        }
        if (hashMap.containsKey("values")) {
            this.values = (float[])hashMap.get("values");
        }
        if (hashMap.containsKey("sample_size_profile")) {
            this.sample_size_profile = (NarcsDataProfile)hashMap.get("sample_size_profile");
        }
    }
}

