import java.util.Vector;

/**
 * <PRE>
 * XMLTree.java
 *
 * Version: 1.0   Date:  9/01/2001   Programmer: Mike Pettey (Raytheon)
 * Version: 1.1   Date:  9/06/2001   Programmer: Mike Pettey (Raytheon)
 * Version: 1.2   Date: 10/18/2001   Programmer: Mike Pettey (Raytheon)
 *
 * This class contains tag and value pairings that were read from
 * an XML file. Each tag is stored within a tag vector while each
 * value is stored within a value vector. The values in the value
 * vector can either be a string or another XMLTree. An XMLTree
 * stored within the value vector indicates that the XML tags were
 * nested.
 *
 *   Version 1.1: Added the method getTagValue() which returns the
 *                value associated with a given tag. Also added the
 *                method containsTag() which returns true if the
 *                XMLTree contains a given tag.
 * 
 * </PRE>
 */

public class XMLTree
  {
  private String tag;
  private Object value;

  private int value_type;
  private int STRING = 0;
  private int BINARY_DATA = 1;
  private int VECTOR = 2;


  public XMLTree(String tag)
    {
    this.tag = tag;
    }



  /**
   * Adds the value portion of the tag/value pair.
   *
   * @param  value  The value to be added.
   */

  public void addValue(String value)
    {
    this.value = value;
    value_type = STRING;
    }


  /**
   * Adds the value portion of the tag/value pair.
   *
   * @param  value  The value to be added.
   */

  public void addValue(byte[] value)
    {
    this.value = value;
    value_type = BINARY_DATA;
    }


  /**
   * Adds the value portion of the tag/value pair.
   *
   * @param  value  The value to be added.
   */

  public void addValue(Vector value)
    {
    this.value = value;
    value_type = VECTOR;
    }


  /**
   * Returns the name of the tag.
   *
   * @return  the tag name.
   */

  public String getTag()
    {
    return tag;
    }
 

  /**
   * Returns the value.
   *
   * @return  Either a string, a binary array, or a 
   *          collection of one or a vector of XMLTrees.
   */

  public Object getValue()
    {
    return value;
    }


  /**
   * Returns the value associated with the given tag.
   *
   * @param   tag  the tag to search for.
   *
   * @return  the value associated with the tag or
   *          null if the tag is not found.
   */

  public Object getValue(String search_tag)
    {
    Object search_value = null;

    if (search_tag.equals(tag))
      {
      search_value = value;
      }
    else
      {
      if (value_type == VECTOR)
	      {
	      Vector subtrees = (Vector)value;

        for (int n=0; n<subtrees.size(); n++)
	        {
          XMLTree subtree = (XMLTree)(subtrees.elementAt(n));

	        Object subtree_value = subtree.getValue(search_tag);

	        if (subtree_value != null)
	          search_value = subtree_value;
	        }
        }
      }

    return search_value;
    }


  /**
   * Begins printing the names of the tag/value pairs to
   * standard output.
   */

  public void printTree()
    {
    printTree(0);
    }


  /**
   * Prints the names of the tag/value pairs to standard
   * output. Each tag/value pair will be indented a specified
   * number of spaces.
   *
   * @param  tab  the number of spaces to indent.
   */

  public void printTree(int tab)
    {

    // Add the appropriate number of spaces for indenting

    for (int i=0; i<tab; i++)
      System.out.print(" ");

    System.out.print("<" + tag + ">    ");

    if (value_type == STRING)
      {
      System.out.println((String)value);
      }
    else if (value_type == BINARY_DATA)
      {
      System.out.println("[binary data]");
      }
    else if (value_type == VECTOR)
      {
      System.out.println("");
      Vector subtrees = (Vector)value;
      for (int n=0; n<subtrees.size(); n++)
	{
	XMLTree subtree = (XMLTree)(subtrees.elementAt(n));
        subtree.printTree(tab+4);
	}
      }
    }
  }

// end of file
