FUNCTION getlat(point)
   IMPLICIT NONE
      
! ARGUMENTS

   REAL(4) :: getlat

   INTEGER, INTENT(IN) :: point

! LOCAL

   INTEGER :: latpoint

   REAL(4) :: startlat


   startlat = 90.0

   IF (point <= 1440) THEN
      latpoint = 0
   ELSE
      latpoint = (point / 1440)
      IF (MOD(point,1440) == 0) latpoint = latpoint - 1
   END IF

   getlat = startlat - (FLOAT(latpoint) * 0.25)

   IF (getlat < (-90.0)) getlat = -90.0

END FUNCTION getlat


