FUNCTION GETLON(point)
   IMPLICIT NONE
      
!  This function returns the Longitude value at "point".
!  The value of point is expected to be between 1 and 
!  1038240. There are 1440 longitide points for each of
!  721 latitude points. Longitudes start at 0.0 degrees.

! Arguments

   INTEGER, INTENT(IN) :: point
   
   REAL(4) :: getlon

! Local

   INTEGER :: lonpoint
   
   REAL(4) :: startlon

   startlon = 0.0
      
   IF (point <= 1440) THEN
      lonpoint = point - 1
   ELSE
      lonpoint = (MOD(point,1440)) -1
   END IF

   getlon = startlon + (FLOAT(lonpoint) * 0.25)

   IF (getlon > 180.0) getlon = getlon - 360.0

END FUNCTION GETLON


