FUNCTION spfh2mr(press,spfh)
   IMPLICIT NONE

   REAL(4) :: spfh2mr, press, spfh

   REAL(4) :: Ewv, tempr

   REAL(4), PARAMETER :: Epsilon=0.622

   IF (spfh .GT. 0.0) THEN
      Ewv = (spfh * press) / Epsilon

!  Calculate mixing ratio in grams per gram

      tempr = (Epsilon * Ewv) / (press - EWV)

!  Convert mixing ratio to grams per kilogram

      tempr = tempr * 1000.0
   ELSE
      Ewv = (0.0 * press) / Epsilon
      tempr = (Epsilon * Ewv) / (press - EWV)
      tempr = tempr * 1000.0
   END IF

   spfh2mr = tempr

END FUNCTION spfh2mr

      


     
