/*
   Name- createODSFromMIRS.c

   Language- C     Type- MAIN

   Version- 1.0    Date-  1/16/2007   Programmer- Mike Pettey (IMSG)
   Version- 1.1    Date-  1/09/2013   Programmer- Mike Pettey (IMSG)
   Version- 2.0    Date- 11/01/2013   Programmer- Mike Pettey (IMSG)
   Version- 3.0    Date-  5/26/2015   Programmer: Mike Pettey (IMSG)

   Function- This program extracts selected data from an MIRS
             Daily Data File (ADDF) and writes the data to an ODS
             file. The selected data are defined in the run script.
             Also in the run script are the starting date (YYYYMMDD)
             and hour and the ending date and hour.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "ods7_capture.h"


#define  RECORD_LENGTH_MIRS      4800
#define  NUM_HEADER_VALUES_MIRS  RECORD_LENGTH_MIRS/4
#define  NUM_DATA_VALUES_MIRS    RECORD_LENGTH_MIRS/2



struct parameter_info* processCaptureInfo7();

void processMirs(int date_to_process, float footprint_size, 
                 struct parameter_info *parameter_list);



main(int argc, char *argv[])
  {
  char   *capture_info_file;
  char   *output_file;
  int    date_to_process;
  float  footprint_size;

  struct parameter_info *parameter_list;
  struct parameter_info *ptr;

  date_to_process = -32768;


  // Print an initial message

  printf("\nODS Data Capture\n\n");
  printf("Capturing retrieval data\n\n");


  // Read the name of the input info file from the command line

  parameter_list = (struct parameter_info*)processCaptureInfo7();

  if (parameter_list == NULL)
    {
    printf("processCaptureInfo7() returned NULL. This indicates that there\n");
    printf("was a problem reading in the parameter data from the parameter\n");
    printf("information file. Execution cannot continue.\n\n");
    exit(1);
    }

  // Read the system description from the command line

  if (argc >= 2)
    {
    strcpy(system_description, argv[1]);
    }

  if (argc == 4)
    {
    date_to_process = atoi(argv[2]);
    footprint_size  = atof(argv[3]);
    }

  if (argc < 2)
    {
    strcpy(system_description, " ");

    printf("No system name was included as a command line argument.\n");
    printf("The file will be captured but the system name will be blank.\n\n");
    }

  // Print the list of parameters

  printf("The following parameters will be captured:\n\n");
  printf("Word\tDescription\n");
  printf("----\t-----------\n");

  ptr = parameter_list;

  while (ptr != NULL)
    {
    printf("%ld\t%s\n", ptr->word_number, ptr->parmdefs_file_name);
    ptr = ptr->next;
    }

  printf("\n\n");

  // If the data type is sequential, then capture the data sequentially

  processMirs(date_to_process, footprint_size, parameter_list);


  // Print a final message

  printf("The data have been successfully captured\n\n");
  }

// end of file
