/*
   Name- getMirsLayerData.c

   Language- C     Type- MAIN

   Version- 1.0    Date-  9/09/2014   Programmer- Mike Pettey (IMSG)

   Function- This program reads values from an MIRS file, calculates
             a value and returns it.
*/


#include <stdio.h>
#include <math.h>

#include "ods7_capture.h"



void convertFromLevelsToLayers(int num_layers, int num_levels, float *level_pressures,
                               float *level_data, float *layer_data);



void getMirsLayerData(struct parameter_info *parm_list, short *buffer, 
		      float *retrieved_temp_layers, float *retrieved_wvap_layers)
  {
  int   i, n, level;
  float pressures[100], data[100];
  int   do_retrieved_temp_layers, do_retrieved_wvap_layers;

  struct parameter_info *ptr;


  // Determine if the layer data will be processed at some point.

  do_retrieved_temp_layers = FALSE;
  do_retrieved_wvap_layers = FALSE;

  ptr = parm_list;

  while (ptr != NULL)
    {
    if (ptr->parameter_id == -1500)
      do_retrieved_temp_layers = TRUE;
    else if (ptr->parameter_id == -3500)
      do_retrieved_wvap_layers = TRUE;

    ptr = ptr->next;
    }

  // Unpack the level pressures

  for (n=0; n<100; n++)
    {
    pressures[n] = -32768.0;

    if (buffer[n+20] != -32768)
      {
      if (n <= 19)
	pressures[n] = buffer[n+20] / 1000.0;
      else
	pressures[n] = buffer[n+20] / 10.0;
      }
    }


  // If there is at least one retrieved temp layer, create a layer profile

  if (do_retrieved_temp_layers == TRUE)
    {

    // Unpack the temperatures

    for (n=0; n<100; n++)
      {
      if (buffer[n+221] != -32768)
	data[n] = buffer[n+221] / 64.0;
      else
	data[n] = -32768.0;
      }

    // Do the conversion

    convertFromLevelsToLayers(30, 100, pressures, data, retrieved_temp_layers);
    }



  // If there is at least one retrieved wvap layer, create a layer profile

  if (do_retrieved_wvap_layers == TRUE)
    {

    // Unpack the water vapors

    for (i=0; i<100; i++)
      {
      if (buffer[i+321] != -32768)
	data[i] = (float)(exp(buffer[i+321]/1024.0));
      else
	data[i] = -32768.0;

      if (data[i] < 0.001)
        data[i] = -32768.0;
      }

    // Do the conversion

    convertFromLevelsToLayers(20, 100, pressures, data, retrieved_wvap_layers);
    }
  }

// end of file
