/*
   Name- getSpecialMirsValue.c

   Language- C     Type- MAIN

   Version- 1.0    Date- 11/01/2013   Programmer- Mike Pettey (IMSG)

   Function- This program reads values from an MIRS file, calculates
             a value and returns it.
*/


#include <stdio.h>
#include <math.h>

#include "ods_capture.h"


#define  RECORD_LENGTH_MDDF      4800
#define  NUM_HEADER_VALUES_MDDF  RECORD_LENGTH_MDDF/4
#define  NUM_DATA_VALUES_MDDF    RECORD_LENGTH_MDDF/2


double getSpecialMirsValue(long parm_number, short buffer[NUM_DATA_VALUES_MDDF],
			   float *retrieved_layer_temps, float *guess_layer_temps, 
			   float *mw_layer_temps, float *retrieved_layer_wvaps,
			   float *guess_layer_wvaps, float *mw_layer_wvaps)
  {
  double value = -32768.0;
  int   i, n, parm, layer, ipressure, qc_flag;
  float pressure, max_pressure, fvalue, surface_pressure;
  float pressures[100], bottom_pressures[100], temps[100], wvaps[100];
  float layer_temps[30], layer_wvaps[20];
  char  orbital_node[11];

  // Date

  if (parm_number == -20002)
    {
    value = (buffer[5] * 10000) + buffer[6];
    }

  // Time

  else if (parm_number == -20003)
    {
    value = (buffer[7] * 10000) + buffer[8];
    }

  // Latitude

  else if (parm_number == -20000)
    {
    value = buffer[3];
    }

  // Longitude

  else if (parm_number == -20001)
    {
    value = buffer[4];
    }

  // Orbital node

  else if (parm_number == -20006)
    {
    value = buffer[17];
    }

  // QC flag

  else if (parm_number == -20007)
    {
    value = buffer[1056];
    }

  // Converted QC flag

  else if (parm_number == -16)
    {
    if ((buffer[1056] == 0) || (buffer[1056] == 1))
      value = 0;
    else if (buffer[1056] == 2)
      value = 2;
    }

  // Minute of day

  else if (parm_number == -20008)
    {
    fvalue = (buffer[7] * 60.0) + (buffer[8] / 100) + ((buffer[8] % 100) / 60.0);
    value = fvalue * 10;
    }
  
  // TPW
  
  else if (parm_number == -10)
    {
    if (buffer[1160] != -32768)
      value = (buffer[1160] / 10.0) * 100;
    }
  
  // Rain Rate Flag
  
  else if (parm_number == -15)
    {
    if (buffer[1169] != -32768)
      {
      value = buffer[1169] / 10.0;

      if (value == 0.0)
        value = 0.0;
      else
	value = 1.0;
      }
    }


  // Level temperatures and water vapors

  else if (parm_number <= -1600000000)
    {
    parm = parm_number / 1000000;
    ipressure = -1 * parm_number % 1000000;
    pressure = ipressure / 100.0;

    // Retrieved temperatures

    if (parm == -1600)
      {
      pressures[0] = 0.0090;
      pressures[1] = 0.025;
      pressures[2] = 0.055;
      pressures[3] = 0.104;
      pressures[4] = 0.177;
      pressures[5] = 0.28;
      pressures[6] = 0.42;
      pressures[7] = 0.604;
      pressures[8] = 0.837;
      pressures[9] = 1.128;
      pressures[10] = 1.483;
      pressures[11] = 1.91;
      pressures[12] = 2.416;
      pressures[13] = 3.009;
      pressures[14] = 3.696;
      pressures[15] = 4.485;
      pressures[16] = 5.384;
      pressures[17] = 6.401;
      pressures[18] = 7.544;
      pressures[19] = 8.821;
      pressures[20] = 10.2;
      pressures[21] = 11.8;
      pressures[22] = 13.5;
      pressures[23] = 15.4;
      pressures[24] = 17.4;
      pressures[25] = 19.7;
      pressures[26] = 22.1;
      pressures[27] = 24.7;
      pressures[28] = 27.6;
      pressures[29] = 30.6;
      pressures[30] = 33.9;
      pressures[31] = 37.4;
      pressures[32] = 41.1;
      pressures[33] = 45.1;
      pressures[34] = 49.3;
      pressures[35] = 53.7;
      pressures[36] = 58.5;
      pressures[37] = 63.5;
      pressures[38] = 68.7;
      pressures[39] = 74.3;
      pressures[40] = 80.1;
      pressures[41] = 86.3;
      pressures[42] = 92.7;
      pressures[43] = 99.5;
      pressures[44] = 106.5;
      pressures[45] = 113.9;
      pressures[46] = 121.6;
      pressures[47] = 129.7;
      pressures[48] = 138.0;
      pressures[49] = 146.7;
      pressures[50] = 155.8;
      pressures[51] = 165.2;
      pressures[52] = 175.0;
      pressures[53] = 185.1;
      pressures[54] = 195.6;
      pressures[55] = 206.4;
      pressures[56] = 217.6;
      pressures[57] = 229.2;
      pressures[58] = 241.2;
      pressures[59] = 253.6;
      pressures[60] = 266.3;
      pressures[61] = 279.5;
      pressures[62] = 293.0;
      pressures[63] = 307.0;
      pressures[64] = 321.3;
      pressures[65] = 336.0;
      pressures[66] = 351.2;
      pressures[67] = 366.7;
      pressures[68] = 382.7;
      pressures[69] = 399.1;
      pressures[70] = 415.9;
      pressures[71] = 433.1;
      pressures[72] = 450.7;
      pressures[73] = 468.7;
      pressures[74] = 487.2;
      pressures[75] = 506.1;
      pressures[76] = 525.4;
      pressures[77] = 545.1;
      pressures[78] = 565.2;
      pressures[79] = 585.8;
      pressures[80] = 606.8;
      pressures[81] = 628.2;
      pressures[82] = 650.1;
      pressures[83] = 672.3;
      pressures[84] = 695.0;
      pressures[85] = 718.1;
      pressures[86] = 741.6;
      pressures[87] = 765.6;
      pressures[88] = 790.0;
      pressures[89] = 814.8;
      pressures[90] = 840.0;
      pressures[91] = 865.6;
      pressures[92] = 891.6;
      pressures[93] = 918.1;
      pressures[94] = 944.9;
      pressures[95] = 972.2;
      pressures[96] = 1000.0;
      pressures[97] = 1028.0;
      pressures[98] = 1056.5;
      pressures[99] = 1085.3;

      for (n=0; n<100; n++)
        {
        if (buffer[n+221] != -32768)
          temps[n] = buffer[n+221] / 64.0;
	else
	  temps[n] = -32768.0;
        }

      interpolateValueAtPressure(pressure, 100, pressures, temps, &fvalue);

      if (buffer[1052] != -32768)
	{
	surface_pressure = buffer[1052] / 10.0;

	if (pressure > surface_pressure)
	  fvalue = -32768.0;
	}

      if (fvalue != -32768.0)
        value = fvalue * 64;
      }  // retrieved temp


    // Retrieved water vapor

    else if (parm == -3600)
      {
      pressures[0] = 0.0090;
      pressures[1] = 0.025;
      pressures[2] = 0.055;
      pressures[3] = 0.104;
      pressures[4] = 0.177;
      pressures[5] = 0.28;
      pressures[6] = 0.42;
      pressures[7] = 0.604;
      pressures[8] = 0.837;
      pressures[9] = 1.128;
      pressures[10] = 1.483;
      pressures[11] = 1.91;
      pressures[12] = 2.416;
      pressures[13] = 3.009;
      pressures[14] = 3.696;
      pressures[15] = 4.485;
      pressures[16] = 5.384;
      pressures[17] = 6.401;
      pressures[18] = 7.544;
      pressures[19] = 8.821;
      pressures[20] = 10.2;
      pressures[21] = 11.8;
      pressures[22] = 13.5;
      pressures[23] = 15.4;
      pressures[24] = 17.4;
      pressures[25] = 19.7;
      pressures[26] = 22.1;
      pressures[27] = 24.7;
      pressures[28] = 27.6;
      pressures[29] = 30.6;
      pressures[30] = 33.9;
      pressures[31] = 37.4;
      pressures[32] = 41.1;
      pressures[33] = 45.1;
      pressures[34] = 49.3;
      pressures[35] = 53.7;
      pressures[36] = 58.5;
      pressures[37] = 63.5;
      pressures[38] = 68.7;
      pressures[39] = 74.3;
      pressures[40] = 80.1;
      pressures[41] = 86.3;
      pressures[42] = 92.7;
      pressures[43] = 99.5;
      pressures[44] = 106.5;
      pressures[45] = 113.9;
      pressures[46] = 121.6;
      pressures[47] = 129.7;
      pressures[48] = 138.0;
      pressures[49] = 146.7;
      pressures[50] = 155.8;
      pressures[51] = 165.2;
      pressures[52] = 175.0;
      pressures[53] = 185.1;
      pressures[54] = 195.6;
      pressures[55] = 206.4;
      pressures[56] = 217.6;
      pressures[57] = 229.2;
      pressures[58] = 241.2;
      pressures[59] = 253.6;
      pressures[60] = 266.3;
      pressures[61] = 279.5;
      pressures[62] = 293.0;
      pressures[63] = 307.0;
      pressures[64] = 321.3;
      pressures[65] = 336.0;
      pressures[66] = 351.2;
      pressures[67] = 366.7;
      pressures[68] = 382.7;
      pressures[69] = 399.1;
      pressures[70] = 415.9;
      pressures[71] = 433.1;
      pressures[72] = 450.7;
      pressures[73] = 468.7;
      pressures[74] = 487.2;
      pressures[75] = 506.1;
      pressures[76] = 525.4;
      pressures[77] = 545.1;
      pressures[78] = 565.2;
      pressures[79] = 585.8;
      pressures[80] = 606.8;
      pressures[81] = 628.2;
      pressures[82] = 650.1;
      pressures[83] = 672.3;
      pressures[84] = 695.0;
      pressures[85] = 718.1;
      pressures[86] = 741.6;
      pressures[87] = 765.6;
      pressures[88] = 790.0;
      pressures[89] = 814.8;
      pressures[90] = 840.0;
      pressures[91] = 865.6;
      pressures[92] = 891.6;
      pressures[93] = 918.1;
      pressures[94] = 944.9;
      pressures[95] = 972.2;
      pressures[96] = 1000.0;
      pressures[97] = 1028.0;
      pressures[98] = 1056.5;
      pressures[99] = 1085.3;

      for (i=0; i<100; i++)
        {
        if (buffer[i+321] != -32768)
          wvaps[i] = (float)(exp(buffer[i+321]/1024.0));
        else
	  wvaps[i] = -32768.0;

        if (wvaps[i] < 0.001)
          wvaps[i] = -32768.0;
        }

      interpolateValueAtPressure(pressure, 100, pressures, wvaps, &fvalue);

      if (buffer[1052] != -32768)
	{
	surface_pressure = buffer[1052] / 10.0;

	if (pressure > surface_pressure)
	  fvalue = -32768.0;
	}

      if (fvalue != -32768.0)
        value = log(fvalue) * 1024;
      }  // retrieved water vapors
    }


  // Layer temperatures and water vapors

  else if (parm_number <= -150000)
    {
    parm  = parm_number / 100;
    layer = -1 * (parm_number % 100);

    // Retrieved temperatures

    if (parm == -1500)
      {
      if (retrieved_layer_temps[layer-1] != -32768.0)
        value = retrieved_layer_temps[layer-1] * 64;
      }

    // Retrieved water vapor

    else if (parm == -3500)
      {
      if (retrieved_layer_wvaps[layer-1] != -32768.0)
        value = log(retrieved_layer_wvaps[layer-1]) * 1024;
      }
    }  // else if (parm_number < -150000

  return value;
  }

// end of file
