/*
   Name- captureSeqIDDF.c

   Language- C     Type- MAIN

   Version- 1.0    Date-  1/16/2007   Programmer- Mike Pettey (IMSG)
   Version- 2.0    Date- 11/01/2013   Programmer- Mike Pettey (IMSG)

   Function- This program extracts selected data from a IDDF
             and writes the data to an ODS file.  The selected
             data is defined in the run script.  Also in the run
             script are the starting date (YYYYMMDD) and hour and
             the ending date and hour.
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "ods_capture.h"


#define  RECORD_LENGTH_IDDF       13000
#define  NUM_HEADER_VALUES_IDDF   RECORD_LENGTH_IDDF/4
#define  NUM_DATA_VALUES_IDDF     RECORD_LENGTH_IDDF/2

#define  SWAP_IN   FALSE
#define  SWAP_OUT  TRUE


void getIasiLayerData(struct parameter_info *parm_list, short *buffer, 
		      float *retrieved_temp_layers, float *guess_temp_layers, float *mw_temp_layers,
		      float *retrieved_wvap_layers, float *guess_wvap_layers, float *mw_wvap_layers);

short getSpecialIasiValue(int parm_number, short buffer[NUM_DATA_VALUES_IDDF],
			  float *retrieved_layer_temps, float *guess_layer_temps, 
			  float *mw_layer_temps, float *retrieved_layer_wvaps,
			  float *guess_layer_wvaps, float *mw_layer_wvaps);



void processIDDF(int date_to_process,
                 struct capture_information *capture_info,
	         struct parameter_info *parameter_list)
  {
  int    iddf_header[NUM_HEADER_VALUES_IDDF];
  short  iddf_buffer[NUM_DATA_VALUES_IDDF];
  short  out_buffer[BUFFER_SIZE];
  int    number_of_iddf_records, last_iddf_rec_written;
  int    first_record, last_record;
  int    iddf_record;

  long   seconds, earliest_seconds, latest_seconds;
  int    number_of_retrievals;
  int    earliest_date, earliest_time;
  int    latest_date, latest_time;
  int    retrieval_year, retrieval_mmdd;
  int    retrieval_hour, retrieval_mmss;
  long   retrieval_date, retrieval_time;

  long   offset;
  int    i4temp, i, j, n, count, status;
  short  i2temp;
  float  lat, lon;

  char   ods_file_name[1000];
  char   c, char12[12], char36[36];
  int    retrieval_count, retrieval_number; 
  int    header_length, block_length, number_of_blocks;
  int    buffer_index, block_index, output_index;
  int    use_fov, pass_both, pass_mw_only;

  float  retrieved_layer_temps[30], guess_layer_temps[30], mw_layer_temps[30];
  float  retrieved_layer_wvaps[20], guess_layer_wvaps[20], mw_layer_wvaps[20];

  struct parameter_info *ptr;

  int    month, day, year, hour, minute, second, today;

  time_t  date_time;
  struct  tm  *ts;   

  FILE   *iddf, *ods;


  // Open the new ODS file

  // if ((ods=fopen(capture_info->output_file_name,"w")) == NULL)
  //  {
  //  printf("\n\nThe ODS file could not be opened for output.\n");
  //  printf("Execution ending.\n\n");
  //  exit(1);
  //  }


  // Open the IDDF

  if ((iddf=fopen(capture_info->input_file_name,"r")) == NULL)
    {
    createEmptyFile(capture_info, parameter_list);

    printf("\n\nThe IDDF could not be opened for input.\n");
    printf("Execution ending.\n\n");
    exit(1);
    }

  // Position the read pointer to the start of the first record

  offset = 0;
  fseek(iddf, offset, SEEK_SET);

  // Read the header record

  fread(&iddf_header, RECORD_LENGTH_IDDF, 1, iddf);

  if (SWAP_IN == TRUE)
    {
    for (n=0; n<NUM_HEADER_VALUES_IDDF; n++)
      iddf_header[n] = htonl(iddf_header[n]);
    }


  number_of_iddf_records = iddf_header[2];

  printf("%s file:\n", capture_info->system_description);
  printf("   Number of records in the file:         %d\n",number_of_iddf_records);


  first_record = 2;
  last_record  = number_of_iddf_records;




// #########################################
// #########################################
// #########################################
last_record = 1500;
// #########################################
// #########################################
// #########################################




  // Loop through all of the records in the input file and count the number that
  // are within the time and geographic windows

  retrieval_count = 0;

  for (iddf_record=first_record; iddf_record<=last_record; iddf_record++)
    {

    // Position the read pointer to the start of the next record

    offset = (iddf_record - 1) * RECORD_LENGTH_IDDF;
    fseek(iddf, offset, SEEK_SET);

    // Read the data record

    fread(&iddf_buffer, RECORD_LENGTH_IDDF, 1, iddf);

    if (SWAP_IN == TRUE)
      {
      for (n=0; n<NUM_DATA_VALUES_IDDF; n++)
        iddf_buffer[n] = htons(iddf_buffer[n]);
      }


    if (iddf_buffer[0] == 0)
      {

      // Unpack the date, latitude and longitude

      retrieval_date = (iddf_buffer[5] * 10000) + iddf_buffer[6];

      lat = iddf_buffer[3] / 128.0;
      lon = iddf_buffer[4] / 128.0;

      // If the retrieval is within both windows, count it

      use_fov = FALSE;

      if ((date_to_process == -32768) || (retrieval_date == date_to_process))
	{
	if ((lat >= capture_info->bottom_latitude) && (lat <= capture_info->top_latitude))
  	  {
	  if ((capture_info->left_longitude <= capture_info->right_longitude))
	    {
	    if ((lon >= capture_info->left_longitude) && (lon <= capture_info->right_longitude))
	      {
	      use_fov = TRUE;
              }
	    }
	  else
	    { 
	    if ((lon <= capture_info->right_longitude) || (lon >= capture_info->left_longitude))
	      {
	      use_fov = TRUE;
	      }
	    }
	  }  // if (lats[fov]...
	}  // if (date_to_process...

      if (use_fov == TRUE)
	retrieval_count++;
      }  // if (iddf_buffer[0]...
    }  // for (iddf_record=first_record...



  printf("   Nu㏔er of records within the windows:  %d\n\n", retrieval_count);


  // Determine the header and block lengths

  //retrieval_count = (last_record - first_record) - 1;

  retrieval_number = -1;
  block_length = 1800 + (retrieval_count * 2);

  header_length = 116;


  // Initialize the earliest and latest seconds and the lat/lon range

  latest_seconds   = 0;
  earliest_seconds = secondsSinceYear(2000,20191231,235959);

  // Loop through the records of the IDDF

  buffer_index = 0;
  output_index = 0;

  for (iddf_record=first_record; iddf_record<=last_record; iddf_record++)
    {

    // Position the read pointer to the start of the next record

    offset = (iddf_record - 1) * RECORD_LENGTH_IDDF;
    fseek(iddf, offset, SEEK_SET);

    // Read the data record

    fread(&iddf_buffer, RECORD_LENGTH_IDDF, 1, iddf);

    if (SWAP_IN == TRUE)
      {
      for (n=0; n<NUM_DATA_VALUES_IDDF; n++)
        iddf_buffer[n] = htons(iddf_buffer[n]);
      }


    if (iddf_buffer[0] == 0)
      {

      // Unpack the date, latitude and longitude

      retrieval_date = (iddf_buffer[5] * 10000) + iddf_buffer[6];

      lat = iddf_buffer[3] / 128.0;
      lon = iddf_buffer[4] / 128.0;

      // If the retrieval is within both windows, count it

      use_fov = FALSE;

      if ((date_to_process == -32768) || (retrieval_date == date_to_process))
	{
	if ((lat >= capture_info->bottom_latitude) && (lat <= capture_info->top_latitude))
  	  {
	  if ((capture_info->left_longitude <= capture_info->right_longitude))
	    {
	    if ((lon >= capture_info->left_longitude) && (lon <= capture_info->right_longitude))
	      {
	      use_fov = TRUE;
              }
	    }
	  else
	    { 
	    if ((lon <= capture_info->right_longitude) || (lon >= capture_info->left_longitude))
	      {
	      use_fov = TRUE;
	      }
	    }
	  }  // if (lats[fov]...
	}  // if (date_to_process...


      if (use_fov == TRUE)
	{
        retrieval_number++;

        // Keep track of the earliest and latest time

        retrieval_date = (iddf_buffer[5] * 10000) + iddf_buffer[6];
        retrieval_time = (iddf_buffer[7] * 10000) + iddf_buffer[8];

        seconds = secondsSinceYear(2000,retrieval_date,retrieval_time);

        if (seconds < earliest_seconds)
          {
          earliest_seconds = seconds;
          earliest_date    = retrieval_date;
          earliest_time    = retrieval_time;
          }

        if (seconds > latest_seconds)
          {
          latest_seconds = seconds;
          latest_date    = retrieval_date;
          latest_time    = retrieval_time;
          }


	// Call the subroutine getIasiLayerData which will convert some or all
	// of the temperature and moisture data from levels to layers

	getIasiLayerData(parameter_list, iddf_buffer, 
			 retrieved_layer_temps, guess_layer_temps, mw_layer_temps,
			 retrieved_layer_wvaps, guess_layer_wvaps, mw_layer_wvaps);

        // Fill the buffers

        ptr = parameter_list;
        while (ptr != NULL)
	  {
          if (ptr->word_number > 0)
            {
            ptr->buffer[buffer_index] = iddf_buffer[ptr->word_number - 1];
            }  // if (word_number > 0...
          else
            {
	    ptr->buffer[buffer_index] = getSpecialIasiValue(ptr->word_number, iddf_buffer, 
							    retrieved_layer_temps, guess_layer_temps,
							    mw_layer_temps, retrieved_layer_wvaps,
							    guess_layer_wvaps, mw_layer_wvaps);
            }  // else word_number < 0...

          ptr = ptr->next;
  	  }

        buffer_index++;


        // If the buffers are full, write them to the file

        if (buffer_index >= BUFFER_SIZE)
          {
          buffer_index = 0;

          block_index = 0;
          ptr = parameter_list;

          while (ptr != NULL)
	    {
	    offset = header_length + (block_index*block_length) +
                     BLOCK_INFO_LENGTH + (output_index*2);

	    //fseek(ods, offset, SEEK_SET);

            for (i=0; i<BUFFER_SIZE; i++)
              {
              if (SWAP_OUT == FALSE)
                out_buffer[i] = ptr->buffer[i];
              else
                out_buffer[i] = htons(ptr->buffer[i]);
              }

            //fwrite(out_buffer, 2, BUFFER_SIZE, ods);

	    block_index++;
	    ptr = ptr->next;
	    }

          output_index = output_index + BUFFER_SIZE;
          }  // if (buffer_index...
	}  // if (use_fov...
      }  // if (buffer[0]...
    }  // for (iddf_record=first_record...


  // Write the remainder of the data to the file

  if (buffer_index > 0)
    {
    block_index = 0;
    ptr = parameter_list;

    while (ptr != NULL)
      {
      offset = header_length + (block_index*block_length) +
	       BLOCK_INFO_LENGTH + (output_index*2);

      //fseek(ods, offset, SEEK_SET);

      for (n=0; n<buffer_index; n++)
	{
	i2temp = ptr->buffer[n];

	if (SWAP_OUT == TRUE)
	  i2temp = htons(i2temp);

	//fwrite(&i2temp, 2, 1, ods);
	}

      block_index++;
      ptr = ptr->next;
      }
    }


  // Print the earliest and latest times found

  year   = earliest_date / 10000;
  month  = (earliest_date % 10000) / 100;
  day    = earliest_date % 100;
  hour   = earliest_time / 10000;
  minute = (earliest_time % 10000) / 100;
  second = earliest_time % 100;

  printf("\nEarliest retrieval found:  %d/%2d/%d %2d:%2d:%2d\n",
          month,day,year,hour,minute,second);

  year   = latest_date / 10000;

  month  = (latest_date % 10000) / 100;
  day    = latest_date % 100;
  hour   = latest_time / 10000;
  minute = (latest_time % 10000) / 100;
  second = latest_time % 100;

  printf("Latest retrieval found:    %d/%2d/%d %2d:%2d:%2d\n\n",
	  month,day,year,hour,minute,second);


  // Set up the block headers for the user-selected parameters


  /*  number_of_blocks = 0;
  ptr = parameter_list;

  block_index = 0;

  while (ptr != NULL)
    {
    number_of_blocks++;

    offset  = header_length + (block_index * block_length);
    fseek(ods, offset, SEEK_SET);

    for (j=0; j<36; j++)
      {
      c = ptr->description[j];
      fwrite(&c, 1, 1, ods);
      }

    i2temp = ptr->data_indicator;
    if (SWAP_OUT == TRUE)
      i2temp = htons(i2temp);
    fwrite(&i2temp, 2, 1, ods);

    i2temp = ptr->visibility;
    if (SWAP_OUT == TRUE)
      i2temp = htons(i2temp);
    fwrite(&i2temp, 2, 1, ods);

    i2temp = ptr->spot_size;
    if (SWAP_OUT == TRUE)
      i2temp = htons(i2temp);
    fwrite(&i2temp, 2, 1, ods);

    i2temp = ptr->scaling_factor;
    if (SWAP_OUT == TRUE)
      i2temp = htons(i2temp);
    fwrite(&i2temp, 2, 1, ods);

    i4temp = ptr->default_min;
    if (SWAP_OUT == TRUE)
      i4temp = htonl(i4temp);
    fwrite(&i4temp, 4, 1, ods);

    i4temp = ptr->default_max;
    if (SWAP_OUT == TRUE)
      i4temp = htonl(i4temp);
    fwrite(&i4temp, 4, 1, ods);

    i4temp = ptr->center_point;
    if (SWAP_OUT == TRUE)
      i4temp = htonl(i4temp);
    fwrite(&i4temp, 4, 1, ods);

    i2temp = ptr->pressure;
    if (SWAP_OUT == TRUE)
      i2temp = htons(i2temp);
    fwrite(&i2temp, 2, 1, ods);

    i2temp = ptr->alt_label_flag;
    if (SWAP_OUT == TRUE)
      i2temp = htons(i2temp);
    fwrite(&i2temp, 2, 1, ods);

    for (j=0; j<12; j++)
      char12[j] = '\0';
    strcpy(char12,ptr->unit);
    fwrite(char12, 12, 1, ods);

    i2temp = ptr->data_type;
    if (SWAP_OUT == TRUE)
      i2temp = htons(i2temp);
    fwrite(&i2temp, 2, 1, ods);

    for (n=0; n<10; n++)
      {
      i4temp = ptr->individual_value[n];
      if (SWAP_OUT == TRUE)
        i4temp = htonl(i4temp);
      fwrite(&i4temp, 4, 1, ods);
      }

    for (n=0; n<10; n++)
      {
      for (j=0; j<12; j++)
	char12[j] = ptr->individual_description[n][j];
      fwrite(char12, 12, 1, ods);
      }

    i2temp = ptr->scale_type;
    if (SWAP_OUT == TRUE)
      i2temp = htons(i2temp);
    fwrite(&i2temp, 2, 1, ods);

    // Color scales

    i2temp = -32768;

    if (SWAP_OUT == TRUE)
      i2temp = htons(i2temp);

    for (j=0; j<3; j++)
      {
      for (n=0; n<256; n++)
        {
	fwrite(&i2temp, 2, 1, ods);
        }
      }

    // Word number

    i2temp = ptr->word_number;
    if (SWAP_OUT == TRUE)
      i2temp = htons(i2temp);
    fwrite(&i2temp, 2, 1, ods);


    block_index++;
    ptr = ptr->next;
    }
  */

  // Calculate the date range.  Obtain the current system date 
  // and time and then convert the values from character to integer

  time (&date_time);         
  ts = localtime(&date_time);

  month  = ts->tm_mon + 1;    
  day    = ts->tm_mday;       
  year   = ts->tm_year;       

  if (year > 56)
    year = 1900 + year;
  else
    year = 2000 + year;

  today = year*10000 + month*100 + day;


  // Create the ODS header record

  sprintf(ods_file_name, "%s/header.xml", capture_info->output_file_name);

  if ((ods=fopen(ods_file_name,"w")) == NULL)
    {
    printf("\n\nThe ODS header.xml file could not be opened for output.\n");
    printf("Execution ending.\n\n");
    exit(1);
    }

  fprintf(ods, "<?xml version=\"1.0\" standalone=\"yes\" ?>\n\n");

  fprintf(ods, "<header>\n");
  fprintf(ods, "  <file_type>ODS7</file_type>\n\n");

  fprintf(ods, "  <file_creation_date>%d</file_creation_date>\n", today);
  fprintf(ods, "  <file_modification_date>%d</file_modification_date>\n\n", today);

  fprintf(ods, "  <oldest_data>\n");
  fprintf(ods, "    <date>%d</date>\n", earliest_date);
  fprintf(ods, "    <time>%06d</time>\n", earliest_time);
  fprintf(ods, "  </oldest_data>\n\n");

  fprintf(ods, "  <newest_data>\n");
  fprintf(ods, "    <date>%d</date>\n", latest_date);
  fprintf(ods, "    <time>%06d</time>\n", latest_time);
  fprintf(ods, "  </newest_data>\n\n");

  fprintf(ods, "  <data_format>binary</data_format>\n\n");

  fprintf(ods, "  <data_type>sequential</data_type>\n");
  fprintf(ods, "  <footprint_size>40.0</footprint_size>\n\n");

  fprintf(ods, "  <earth_coverage>\n");
  fprintf(ods, "    <left_longitude>%.2f</left_longitude>\n", capture_info->left_longitude);
  fprintf(ods, "    <right_longitude>%.2f</right_longitude>\n", capture_info->right_longitude);
  fprintf(ods, "    <top_latitude>%.2f</top_latitude>\n", capture_info->top_latitude);
  fprintf(ods, "    <bottom_latitude>%.2f</bottom_latitude>\n", capture_info->bottom_latitude);
  fprintf(ods, "  </earth_coverage>\n\n");

  fprintf(ods, "  <system_name>%s</system_name>\n", capture_info->system_description);
  fprintf(ods, "</header>\n");

  fclose(ods);
  }

// end of file
