/*
   Name- processECMWF.c

   Language- C     Type- MAIN

   Version- 1.0    Date-  7/05/2023   Programmer- Mike Pettey (IMSG)

   Function- This program extracts data from P72 EDR files in HDF5 format
             and writes the data to an EDGE orbital file.  The selected
             data is defined in the run script.  Also in the run
             script are the starting date (YYYYMMDD) and hour and
             the ending date and hour.
*/


#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <math.h>
#include <netcdf.h>



void processECMWF(char *file_name, int group_id)
  {
  int    n;
  int    nc_id, retval, num_attributes, num_dims, num_variables;
  int    level_dim, recdim;
  char   attr_name[NC_MAX_NAME];
  char   dim_name[NC_MAX_NAME];
  size_t dim_length;


  // Open the input netCDF file

  retval = nc_open(file_name, NC_NOWRITE, &nc_id);

  if (retval == NC_NOERR)
    {

    // Find out how many dimensions, variables and attributes there are

    ncinquire(nc_id, &num_dims, &num_variables, &num_attributes, &recdim);

    // Copy the attributes

    for (n=0; n<num_attributes; n++)
      {
      nc_inq_attname(nc_id, NC_GLOBAL, n, attr_name);
      nc_copy_att(nc_id, NC_GLOBAL, attr_name, group_id, NC_GLOBAL);
      }

    // Copy the dimensions

    for (n=0; n<num_dims; n++)
      {
      nc_inq_dim(nc_id, n, dim_name, &dim_length);
      nc_def_dim(group_id, dim_name, (int)dim_length, &level_dim);
      }

    // Copy the variables

    for (n=0; n<num_variables; n++)
      {
      retval = nc_copy_var(nc_id, n, group_id);
      }
    }  // if (retval == NC_NOERR...

  nc_close(nc_id);
  }

// end of file
