/*
   Name- processOzonesonde.c

   Language- C     Type- MAIN

   Version- 1.0    Date-  5/21/2023   Programmer- Mike Pettey (IMSG)

   Function- This program extracts data from P72 EDR files in HDF5 format
             and writes the data to an EDGE orbital file.  The selected
             data is defined in the run script.  Also in the run
             script are the starting date (YYYYMMDD) and hour and
             the ending date and hour.
*/


#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <math.h>
#include <netcdf.h>

int defineVariable(int nc_group_id, char *var_name, nc_type var_type, int ndims,
                   int *dimids, char *attr_string, char *attr);

void writeAttributeShort(int grp, char *attrVariable, short attrValue);
void writeAttributeText(int grp, char *attrVariable, char *attrValue);
void writeVariableFloat(int group_id, int var_id, size_t *index, size_t *num_vals, float value);
void writeVariableInteger(int group_id, int var_id, size_t *index, size_t *num_vals, int value);


int processOzonesonde(int collocation_group_id, char *file_name, int group_id)
  {
  int      n, nc_id, var_id, retval, num_attributes;
  int      num_variables, num_dims, level_dim, recdim;
  int      col_group_id;
  int      date, time;
  int      vid_lat, vid_lon, vid_date, vid_time;
  float    latitude, longitude;
  char     attr_name[NC_MAX_NAME];
  char     dim_name[NC_MAX_NAME];
  size_t   dim_length, index[1], num_vals[1];

  // Open the input netCDF file

  retval = nc_open(file_name, NC_NOWRITE, &nc_id);

  if (retval == NC_NOERR)
    {

    // Find out how many dimensions, variables and attributes there are

    ncinquire(nc_id, &num_dims, &num_variables, &num_attributes, &recdim);

    // Copy the attributes

    for (n=0; n<num_attributes; n++)
      {
      nc_inq_attname(nc_id, NC_GLOBAL, n, attr_name);
      nc_copy_att(nc_id, NC_GLOBAL, attr_name, group_id, NC_GLOBAL);
      }


    // Copy the dimensions

    for (n=0; n<num_dims; n++)
      {
      retval = nc_inq_dim(nc_id, n, dim_name, &dim_length);
      retval = nc_def_dim(group_id, dim_name, (int)dim_length, &level_dim);
      }

    // Copy the variables

    for (n=0; n<num_variables; n++)
      {
      retval = nc_copy_var(nc_id, n, group_id);
      printf("  copy:  %d    %d\n", n, retval);
      }


    // Create the collocation_info group

    nc_def_grp(collocation_group_id, "Collocation_Info", &col_group_id);

    // Write the collocation_info attributes

    writeAttributeShort(col_group_id, "Baseline_Data_Type", 0);
    writeAttributeText(col_group_id, "Baseline_Platform", "Ozonesonde");
    writeAttributeShort(col_group_id, "Baseline_Platform_ID", 0);

    // Define the collocation_info variables

    vid_lat  = defineVariable(col_group_id, "latitude", NC_FLOAT, 0, 0, "units", "degrees_north");
    vid_lon  = defineVariable(col_group_id, "longitude", NC_FLOAT, 0, 0, "units", "degrees_east");
    vid_date = defineVariable(col_group_id, "date", NC_INT, 0, 0, "format", "yyyymmdd");
    vid_time = defineVariable(col_group_id, "time", NC_INT, 0, 0, "format", "hhmmss");

    // Write the collocation_info variables

    index[0]    = 0;
    num_vals[0] = 1;

    // Latitude

    retval = nc_inq_varid(nc_id, "latitude", &var_id);
    retval = nc_get_var1_float(nc_id, var_id, index, &latitude);
    writeVariableFloat(col_group_id, vid_lat, index, num_vals, latitude);

    // Longitude

    retval = nc_inq_varid(nc_id, "longitude", &var_id);
    retval = nc_get_var1_float(nc_id, var_id, index, &longitude);
    writeVariableFloat(col_group_id, vid_lon, index, num_vals, longitude);

    // Date

    retval = nc_inq_varid(nc_id, "date", &var_id);
    retval = nc_get_var1_int(nc_id, var_id, index, &date);
    writeVariableInteger(col_group_id, vid_date, index, num_vals, date);

    // Time

    retval = nc_inq_varid(nc_id, "time", &var_id);
    retval = nc_get_var1_int(nc_id, var_id, index, &time);
    writeVariableInteger(col_group_id, vid_time, index, num_vals, time);
    }  // if (retval == NC_NOERR...

  nc_close(nc_id);

  return date;
  }


/*
int processOzonesonde(int collocation_group_id, char *file_name, int group_id)
  {
  int      n, nc_id, var_id, retval, num_attributes;
  int      num_variables, num_dims, level_dim, recdim;
  int      col_group_id;
  int      date, time;
  int      vid_lat, vid_lon, vid_date, vid_time;
  float    latitude, longitude;
  char     attr_name[NC_MAX_NAME];
  char     dim_name[NC_MAX_NAME];
  size_t   dim_length, index[1], num_vals[1];


  int varnum;
  char var_name[NC_MAX_NAME];
  int var_num_dims, var_dimids[NC_MAX_VAR_DIMS], var_num_attr;
  nc_type var_type;

  // Open the input netCDF file

  retval = nc_open(file_name, NC_NOWRITE, &nc_id);

  if (retval == NC_NOERR)
    {

    // Find out how many dimensions, variables and attributes there are

    ncinquire(nc_id, &num_dims, &num_variables, &num_attributes, &recdim);

    // Copy the attributes

    for (n=0; n<num_attributes; n++)
      {
      nc_inq_attname(nc_id, NC_GLOBAL, n, attr_name);
      nc_copy_att(nc_id, NC_GLOBAL, attr_name, group_id, NC_GLOBAL);
      }


    // Copy the dimensions

    for (n=0; n<num_dims; n++)
      {
      retval = nc_inq_dim(nc_id, n, dim_name, &dim_length);
      retval = nc_def_dim(group_id, dim_name, (int)dim_length, &level_dim);

var_dimids[0] = level_dim;
      }

    // Copy the variables

//    for (n=0; n<num_variables; n++)
//      {
//      retval = nc_copy_var(nc_id, n, group_id);
//      printf("  copy:  %d    %d\n", n, retval);
//      }

    // Copy the variables

    for (varnum=0; varnum<num_variables; varnum++)
      {
      retval = nc_inq_varname(nc_id, varnum, var_name);
      retval = nc_inq_var(nc_id, varnum, 0, &var_type, &var_num_dims, var_dimids, &var_num_attr);
      retval = nc_inq_varid(nc_id, var_name, &var_id);

      printf("VAR %d:  %s   %d   %d   %d\n", varnum, var_name, (int)var_type, var_num_dims, var_num_attr);

      // Define the variable

      if (var_num_dims != 0)
	retval = nc_def_var(group_id, var_name, var_type, var_num_dims, var_dimids, &var_id);
      else
	retval = nc_def_var(group_id, var_name, var_type, 0, 0, &var_id);

      // Copy the variable attributes

      retval = nc_inq_varnatts(nc_id, var_id, &num_attributes);

      for (n=0; n<num_attributes; n++)
	{
	  nc_inq_attname(nc_id, var_id, n, attr_name);
	  nc_copy_att(nc_id, var_id, attr_name, gorup_id, out_var_id);
	}




          // Set up the index and count arrays

          in_index = (size_t*)malloc(in_var_ndims*sizeof(size_t));
          in_count = (size_t*)malloc(in_var_ndims*sizeof(size_t));

          in_index[0] = closest_footprint_index;
          in_count[0] = 1;

          for (n=1; n<in_var_ndims; n++)
            {
            in_index[n] = 0;

            nc_inq_dim(in_id, in_var_dimids[n], dim_name, &dim_length);
            in_count[n] = dim_length;
            }

          out_index = (size_t*)malloc((out_var_ndims+1)*sizeof(size_t));
          out_count = (size_t*)malloc((out_var_ndims+1)*sizeof(size_t));

          out_index[0] = 0;
          out_count[0] = 1;

          for (n=0; n<out_var_ndims; n++)
            {
            out_index[n] = 0;

            nc_inq_dim(out_id, out_var_dimids[n], dim_name, &dim_length);
            out_count[n] = dim_length;
            }

          // Calculate the number of data values to read for this variable

          num_values = 1;

          if (out_var_ndims != 0)
            {
            for (n=0; n<out_var_ndims; n++)
              {
              nc_inq_dim(out_id, out_var_dimids[n], dim_name, &dim_length);
              num_values = num_values * (int)dim_length;
              }
            }

          // If the variable is "Time" then intercept the copying to convert
          // it from a single variable for Epoch time to two variables
          // for date and time

          if (strcmp(var_name, "Time") == 0)
            {
            retval = nc_get_vara_double(in_id, in_var_id, in_index, in_count, &epoch_time);

            convertEpochTimeToDateAndTime(epoch_time, &yyyy, &mmdd, &hh, &mmss);

            yyyymmdd = (yyyy * 10000) + mmdd;
            hhmmss   = (hh * 10000) + mmss;

            retval = nc_put_var1_int(out_id, date_id, out_index, &yyyymmdd);
            retval = nc_put_var1_int(out_id, time_id, out_index, &hhmmss);
            }
          else
            {

            // Copy the data based on the data type

            if (var_type == NC_FLOAT)
              {
              fval_array = (float*)malloc(num_values*sizeof(float));

              retval = nc_get_vara_float(in_id, in_var_id, in_index, in_count, fval_array);
              retval = nc_put_vara_float(out_id, out_var_id, out_index, out_count, fval_array);

              free (fval_array);
              }  // if (var_type == NC_FLOAT...
            else if (var_type == NC_DOUBLE)
              {
              dval_array = (double*)malloc(num_values*sizeof(double));

              retval = nc_get_vara_double(in_id, in_var_id, in_index, in_count, dval_array);
              retval = nc_put_vara_double(out_id, out_var_id, out_index, out_count, dval_array);

              free (dval_array);
              }  // if (var_type == NC_DOUBLE...
            else if ((var_type == NC_INT) || (var_type == NC_LONG))
              {
              i4val_array = (int*)malloc(num_values*sizeof(int));

              retval = nc_get_vara_int(in_id, in_var_id, in_index, in_count, i4val_array);
              retval = nc_put_vara_int(out_id, out_var_id, out_index, out_count, i4val_array);

              free (i4val_array);
              }  // if (var_type == NC_INT...
            else if (var_type == NC_SHORT)
              {
              i2val_array = (short*)malloc(num_values*sizeof(short));

              retval = nc_get_vara_short(in_id, in_var_id, in_index, in_count, i2val_array);
              retval = nc_put_vara_short(out_id, out_var_id, out_index, out_count, i2val_array);

              free (i2val_array);
              }  // if (var_type == NC_SHORT...
            else if (var_type == NC_INT64)
              {
              i8val_array = (long*)malloc(num_values*sizeof(long));

              retval = nc_get_vara_long(in_id, in_var_id, in_index, in_count, i8val_array);
              retval = nc_put_vara_long(out_id, out_var_id, out_index, out_count, i8val_array);

              free (i8val_array);
              }  // if (var_type == NC_INT64...
            else if (var_type == NC_CHAR)
              {
              //character_array = (constant signed char*)malloc(num_values*sizeof(constant signed char));

              //retval = nc_get_vara_schar(in_id, in_var_id, in_index, in_count, &character);
              //retval = nc_put_vara_schar(out_id, out_var_id, out_index, out_count, character);
              //printf("A char variable was found:  <%c>\n", character);

              //free (character_array);
              }  // if (var_type == NC_CHAR...
            }  // else (variable name is not Time...

//  char           *byte_array;
//  unsigned char  *u_byte_array;
//  char           *character_array;
//  unsigned short *u_i2val_array;
//  unsigned int   *u_i4val_array;
//  long           *u_i8val_array;
//  char           *string;

//NC_BYTE 8-bit signed integer
//NC_UBYTE 8-bit unsigned integer *
//NC_CHAR 8-bit character
//NC_USHORT 16-bit unsigned integer *
//NC_UINT 32-bit unsigned integer *
//NC_UINT64 64-bit unsigned integer *
//NC_STRING variable length character string +


          free(out_count);
          free(out_index);
          free(in_count);
          free(in_index);


 


      }  // for (varnum=0...



    // Create the collocation_info group

    nc_def_grp(collocation_group_id, "Collocation_Info", &col_group_id);

    // Write the collocation_info attributes

    writeAttributeShort(col_group_id, "Baseline_Data_Type", 0);
    writeAttributeText(col_group_id, "Baseline_Platform", "Ozonesonde");
    writeAttributeShort(col_group_id, "Baseline_Platform_ID", 0);

    // Define the collocation_info variables

    vid_lat  = defineVariable(col_group_id, "latitude", NC_FLOAT, 0, 0, "units", "degrees_north");
    vid_lon  = defineVariable(col_group_id, "longitude", NC_FLOAT, 0, 0, "units", "degrees_east");
    vid_date = defineVariable(col_group_id, "date", NC_INT, 0, 0, "format", "yyyymmdd");
    vid_time = defineVariable(col_group_id, "time", NC_INT, 0, 0, "format", "hhmmss");

    // Write the collocation_info variables

    index[0]    = 0;
    num_vals[0] = 1;

    // Latitude

    retval = nc_inq_varid(nc_id, "latitude", &var_id);
    retval = nc_get_var1_float(nc_id, var_id, index, &latitude);
    writeVariableFloat(col_group_id, vid_lat, index, num_vals, latitude);

    // Longitude

    retval = nc_inq_varid(nc_id, "longitude", &var_id);
    retval = nc_get_var1_float(nc_id, var_id, index, &longitude);
    writeVariableFloat(col_group_id, vid_lon, index, num_vals, longitude);

    // Date

    retval = nc_inq_varid(nc_id, "date", &var_id);
    retval = nc_get_var1_int(nc_id, var_id, index, &date);
    writeVariableInteger(col_group_id, vid_date, index, num_vals, date);

    // Time

    retval = nc_inq_varid(nc_id, "time", &var_id);
    retval = nc_get_var1_int(nc_id, var_id, index, &time);
    writeVariableInteger(col_group_id, vid_time, index, num_vals, time);
    }  // if (retval == NC_NOERR...

  nc_close(nc_id);

  return date;
  }
*/

// end of file
