/*
   Name- defineVariable.c

   Language- C     Type- MAIN

   Version- 1.0    Date-  1/01/2018   Programmer- Mike Pettey (IMSG)

   Function- This function converts a value from dewpoint temperature
             to water vapor mixing ratio.
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>


float dwptToWvmr(float pressure, float dwpt)
  {
  float wvmr;
  float saturation_pressure;

  wvmr = -32768.0;

  if ((pressure > 0.0) && (dwpt > 0.0))
    {
    saturation_pressure = 6.1078 * exp((dwpt-273.15) / ((dwpt-273.15)+238.3) * 17.2694);
    wvmr = (622.0 * saturation_pressure) / (pressure - saturation_pressure);
    }

  return wvmr;
  }

// end of file
