/*
   Name- calculateDistanceDifference.c

   Language- C     Type- MAIN

   Version- 1.0    Date-  1/11/2020   Programmer- Mike Pettey (IMSG)

   Function- This subroutine calculates the distance (in km) of two points
             on the Earth.
*/

#include <stdlib.h>
#include <math.h>


float calculateDistanceDifference(float lat1, float lon1, float lat2, float lon2)
  {
  double rlat1, rlon1, rlat2, rlon2;
  double theta;
  double distance = 0.0;

  if ((lat1 != lat2) || (lon1 != lon2))
    {

    // Convert to radians

    rlat1 = lat1 * 0.01745329;
    rlon1 = lon1 * 0.01745329;
    rlat2 = lat2 * 0.01745329;
    rlon2 = lon2 * 0.01745329;

    // Calculate the Great Circle Distance (assuming a spherical Earth for simplicity)

    theta = rlon2 - rlon1;

    distance = acos((sin(rlat1) * sin(rlat2)) + (cos(rlat1) * cos(rlat2) * cos(theta)));

    if (distance < 0.0)
      distance = distance + 3.1415926536;

    distance = distance * 6371.2;
    }

  return (float)distance;
  }



//  public static float calculateDistance2(float lat1, float lon1, float lat2, float lon2)
//    {
//    float dist = -32768F;
//
//    if ((lat1 != -32768F) && (lon1 != -32768F) && (lat2 != -32768F) && (lon2 != -32768F))
//      {
//      double degrad = 0.0174532925;
//      double emeanr = 6371.004;
//
//      double bound1 = Math.PI;
//      double bound2 = -Math.PI;
//      double dif360 = 2.0 * Math.PI;
//
//      double xlat1 = lat1 * degrad;
//      double xlon1 = lon1 * degrad;
//      double xlat2 = lat2 * degrad;
//      double xlon2 = lon2 * degrad;
//
//      double diflon = xlon1 - xlon2;
//
//      if (diflon > bound1)
//        diflon = diflon - dif360;
//
//      if (diflon < bound2)
//        diflon = diflon + dif360;
//
//      double dlon = Math.cos(diflon);
//
//      double argmnt = Math.sin(xlat1) * Math.sin(xlat2) +
//                      Math.cos(xlat1) * Math.cos(xlat2) * dlon;
//
//      argmnt = Math.max(argmnt,-1.0);
//      argmnt = Math.min(argmnt,1.0);
//
//      dist = (float)(Math.acos(argmnt) * emeanr);
//      }
//
//    return dist;
//    }
//
//
//
//  public static float calculateDistance(float lat1, float lon1, float lat2, float lon2)
//    {
//    double distance = 0.0;
//
//    if ((lat1 != lat2) || (lon1 != lon2))
//      {
//
//      // Convert to radians
//
//      double rlat1 = lat1 * 0.01745329;
//      double rlon1 = lon1 * 0.01745329;
//      double rlat2 = lat2 * 0.01745329;
//      double rlon2 = lon2 * 0.01745329;
//
//      // Calculate the Great Circle Distance (assuming a spherical Earth for simplicity)
//
//      double theta = rlon2 - rlon1;
//
//      distance = FastMath.acos((FastMath.sin(rlat1) * FastMath.sin(rlat2)) +
//                               (FastMath.cos(rlat1) * FastMath.cos(rlat2) * FastMath.cos(theta)));
//
//      if (distance < 0.0)
//        distance = distance + Math.PI;
//
//      distance = distance * 6371.2;
//      }
//
////System.out.println("distance: " + lat1 + "  " + lon1 + "    " + lat2 + "  " + lon2 + "      " + distance);
//    return (float)distance;
////theta = lon2 - lon1
////dist = acos(sin(lat1) × sin(lat2) + cos(lat1) × cos(lat2) × cos(theta))
////if (dist < 0) dist = dist + pi
////dist = dist × 6371.2
//    }

// end of file
