#include <stdio.h>
#include <stdlib.h>
#include <math.h>

/*
   Name- calculateFineLayerMeans.c

   Language- C     Type- MAIN

   Version- 1.0    Date-  9/09/2014   Programmer- Mike Pettey (IMSG)

   Function- This subroutine converts a profile from defined at
             pressure levels to one defined at pressure layers.
*/


float calculateTPW(float *pressures, float *water_vapors, int num_wvap_levels,
		   float surface_pressure, float surface_wvmr)
  {
  float tpw = 0.0;
  float *precip_profile;
  float upper_wvmr, lower_wvmr, upper_pressure, lower_pressure, pressure_diff;
  int   lowest_index, level;

  // Allocate memory for the precip profile

  precip_profile = (float*)malloc(sizeof(float) * num_wvap_levels);

  for (level=0; level<num_wvap_levels; level++)
    precip_profile[level] = -32768.0;


  lowest_index = 0;

  for (level=0; level<num_wvap_levels; level++)
    {
    if (water_vapors[level] != -32768.0)
      lowest_index = level;

    upper_wvmr = water_vapors[level];
    lower_wvmr = water_vapors[level+1];

    if ((upper_wvmr != -32768.0) && (lower_wvmr != -32768.0))
      {
      upper_pressure = pressures[level];
      lower_pressure = pressures[level+1];
      pressure_diff  = fabs(lower_pressure-upper_pressure);

      precip_profile[level] = (upper_wvmr + lower_wvmr) * pressure_diff / 1961.33 * 10.0;

      tpw = tpw + precip_profile[level];
      }  // if (upper_wvmr...
    }  // for (level=0...


  if ((surface_wvmr != -32768.0) && (surface_pressure != -32768.0) && 
      (surface_pressure > pressures[lowest_index]))
    {
    upper_wvmr = water_vapors[lowest_index];
    lower_wvmr = surface_wvmr;

    if ((upper_wvmr != -32768.0) && (lower_wvmr != -32768.0))
      {
      upper_pressure = pressures[lowest_index];
      lower_pressure = surface_pressure;
      pressure_diff  = fabs(lower_pressure-upper_pressure);

      precip_profile[lowest_index] = (upper_wvmr + lower_wvmr) * pressure_diff / 1961.33;
      precip_profile[lowest_index] = precip_profile[lowest_index] * 10.0;

      tpw = tpw + precip_profile[lowest_index];
      }
    }  // if (surface_wvmr...

  // Free the memory that was used for the precip profile

  free(precip_profile);

  return tpw;
  }

// end of file
