/*
   Name- calculateTimeDifference.c

   Language- C     Type- MAIN

   Version- 1.0    Date-  1/11/2020   Programmer- Mike Pettey (IMSG)

   Function- This program extracts selected data from an RRODF
             and writes the data to an EDGE file.  The selected
             data is defined in the run script.  Also in the run
             script are the starting date (YYYYMMDD) and hour and
             the ending date and hour.
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define TRUE  0
#define FALSE 1


int getCenturyDay(int year, int month, int day);
int getJulianDay(int year, int month, int day);
int isLeapYear(int year);


float calculateTimeDifference(int date1, int time1, int date2, int time2)
  {
  int  year1, month1, day1, hour1, minute1, second1;
  int  year2, month2, day2, hour2, minute2, second2;
  int  century_day_1, century_day_2;
  long century_seconds_1, century_seconds_2;
  long difference_in_seconds;

  float difference = 0.0;

  if ((date1 != -32768) && (time1 != -32768) && (date2 != -32768) && (time2 != -32768))
    {
    year1   = date1 / 10000;
    month1  = (date1 % 10000) / 100;
    day1    = date1 % 100;
    hour1   = time1 / 10000;
    minute1 = (time1 % 10000) / 100;
    second1 = time1 % 100;

    year2   = date2 / 10000;
    month2  = (date2 % 10000) / 100;
    day2    = date2 % 100;
    hour2   = time2 / 10000;
    minute2 = (time2 % 10000) / 100;
    second2 = time2 % 100;

    // Convert the dates to number of days since 2000

    century_day_1 = getCenturyDay(year1, month1, day1) - 1;
    century_day_2 = getCenturyDay(year2, month2, day2) - 1;

    // Calculate the number of seconds since 2000

    century_seconds_1 = ((long)century_day_1 * (long)86400) +
                        (long)(hour1 * 3600) + (long)(minute1 * 60) + (long)second1;

    century_seconds_2 = ((long)century_day_2 * (long)86400) +
                        (long)(hour2 * 3600) + (long)(minute2 * 60) + (long)second2;

    difference_in_seconds = century_seconds_2 - century_seconds_1;

    difference = (float)(difference_in_seconds / 3600) + ((float)(difference_in_seconds % 3600) / 3600.0);
    }  // if (date1 != -32768...

  return difference;
  }



int getCenturyDay(int year, int month, int day)
  {
  int century_day;
  int yr, number_of_prior_years;

  number_of_prior_years = year - 2000;

  century_day = number_of_prior_years * 365;

  for (yr=2000; yr<year; yr++)
    {
    if (isLeapYear(yr) == TRUE)
      century_day++;
    }

  century_day = century_day + getJulianDay(year, month, day);

  return century_day;
  }



int isLeapYear(int year)
  {
  int is_leap_year = FALSE;

  if ((year % 4) == 0)
    {
    is_leap_year = TRUE;

    if ((year % 100) == 0)
      is_leap_year = FALSE;

    if ((year % 400) == 0)
      is_leap_year = TRUE;
    }

  return is_leap_year;
  }



int getJulianDay(int year, int month, int day)
    {
    int n, julday, days_in_month[12];

    days_in_month[0]  = 31;
    days_in_month[1]  = 28;
    days_in_month[2]  = 31;
    days_in_month[3]  = 30;
    days_in_month[4]  = 31;
    days_in_month[5]  = 30;
    days_in_month[6]  = 31;
    days_in_month[7]  = 31;
    days_in_month[8]  = 30;
    days_in_month[9]  = 31;
    days_in_month[10] = 30;
    days_in_month[11] = 31;

    if (isLeapYear(year) == TRUE)
      days_in_month[1] = 29;

    julday = 0;

    for (n=1; n<month; n++)
      julday = julday + days_in_month[n-1];

    julday = julday + day;

    return julday;
    }

// end of file
