/*
   Name- convertEpochTimeToDateAndTime.c

   Language- C     Type- MAIN

   Version- 1.0    Date-  4/16/2021   Programmer- Mike Pettey (IMSG)

   Function- This program extracts selected data from an RRODF
             and writes the data to an EDGE file.  The selected
             data is defined in the run script.  Also in the run
             script are the starting date (YYYYMMDD) and hour and
             the ending date and hour.
*/

#include <time.h>


void convertEpochTimeToDateAndTime(double epoch_time, int *yr, int *md, int *hr, int *ms)
  {
  time_t  date_time;
  struct tm *ts;
  long    seconds_since_1970;
  int     year, month, day, mmdd;
  int     hour, minute, second, mmss;

  // Convert milliseconds to seconds

  date_time = epoch_time / 1000.0;

  // Use gmtime to convert the epoch time to date and time

  ts = gmtime(&date_time);

  month = ts->tm_mon + 1;
  day   = ts->tm_mday;
  year  = ts->tm_year;

  if (year > 56)
    year = year + 1900;
  else
    year = year + 2000;

  hour   = ts->tm_hour;
  minute = ts->tm_min;
  second = ts->tm_sec;

  mmdd = (month * 100) + day;
  mmss = (minute * 100) + second;

  // If the epoch time is 0, fill the date and time with missing values

  if (epoch_time == 0.0)
    {
    year = -32768;
    mmdd = -32768;
    hour = -32768;
    mmss = -32768;
    }

  // Return the values

  *yr = year;
  *md = mmdd;
  *hr = hour;
  *ms = mmss;
  }

// end of file
