/*
   Name- defineVariable.c

   Language- C     Type- MAIN

   Version- 1.0    Date-  1/27/2017   Programmer- Mike Pettey (IMSG)

   Function- This subroutine defines a netCDF variable and returns the
             variable id. If attribute information is not NULL, it is
	     attached to the variable.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <netcdf.h>


int defineVariable(int nc_group_id, char *var_name, nc_type var_type, int ndims, int *dimids, 
                   char *attr_string, char *attr)
  {
  int retval, var_id;

  if ((retval = nc_def_var(nc_group_id, var_name, var_type, ndims, dimids, &var_id)))
    {
    printf("\n***ERROR DURING defineVariable:  %s\n\n", var_name);
    printf("Error: %s, error num = %d\n", nc_strerror(retval), retval); 
    printf("\nExecution ending.\n\n");
    exit(1);
    }

  if ((attr_string != NULL) && (attr != NULL))
    {
    if ((retval = nc_put_att_text(nc_group_id, var_id, attr_string, 
				  strlen(attr), attr)))
      {
      printf("\n***ERROR DURING defineVariable:  %s\n\n", var_name);
      printf("Error: %s, error num = %d\n", nc_strerror(retval), retval); 
      printf("\nExecution ending.\n\n");
      exit(1);
      }
    }

  return var_id;
  }

// end of file
