/*
   Name- writeArrayFloat.c

   Language- C     Type- MAIN

   Version- 1.0    Date-  1/26/2017   Programmer- Mike Pettey (IMSG)

   Function- This subroutine writes a float array to a specific location
             within a NetCDF variable.
*/

#include <stdio.h>
#include <stdlib.h>
#include <netcdf.h>


// Handle errors by printing an error message and exiting with a
// non-zero status. 

//#define ERR(e) {printf("Error: %s, error num = %d\n", nc_strerror(e),e); return 2;}



writeArrayFloat(int group_id, int var_id, size_t *index, size_t *num_vals, float *value)
  {
  int retval;

  if (retval = nc_put_vara_float(group_id, var_id, index, num_vals, value))
    {
    printf("Error: %s, error num = %d\n", nc_strerror(retval), retval); 
    return 2;
    }
  }

// end of file
