/*
   Name- Nprovs2CDF4.c

   Language- C     Type- MAIN

   Version- 1.0    Date- 10/07/2012   Programmer- Charles Brown (IMSG)

   Function- This program extracts data from P72 EDR files in HDF5 format
             and writes the data to an EDGE orbital file.  The selected
             data is defined in the run script.  Also in the run
             script are the starting date (YYYYMMDD) and hour and
             the ending date and hour.
*/


#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <math.h>
#include <netcdf.h>


writeAttributeLong(int grp, char *attrVariable, long attrValue)
  {
  int status;
  status = nc_put_att_long(grp, NC_GLOBAL, attrVariable, NC_LONG, 1, &attrValue);

  if (status != NC_NOERR) 
    printf("writeAttributeLong: %s in nc_put_att_long call.\nVariable/value pair = %s / %d;\n", 
	   nc_strerror(status), attrVariable, attrValue);
  }

// end of file
