/*
   Name- Nprovs2CDF4.c

   Language- C     Type- MAIN

   Version- 1.0    Date- 10/07/2012   Programmer- Charles Brown (IMSG)

   Function- This program extracts data from P72 EDR files in HDF5 format
             and writes the data to an EDGE orbital file.  The selected
             data is defined in the run script.  Also in the run
             script are the starting date (YYYYMMDD) and hour and
             the ending date and hour.
*/


#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <math.h>
#include <netcdf.h>


// Handle errors by printing an error message and exiting with a
// non-zero status. 

//#define ERR(e) {printf("Error: %s, error num = %d\n", nc_strerror(e),e); return 2;}



writeAttributeShort(int grp, char *attrVariable, short attrValue)
  {
  int status;
  status = nc_put_att_short(grp, NC_GLOBAL, attrVariable, NC_SHORT, 1, &attrValue);

  if (status != NC_NOERR) 
    printf("writeAttributeShort: %s in nc_put_att_short call.\nvar/Variable/value = %s / %d;\n", 
	   nc_strerror(status),attrVariable, attrValue);
  }

// end of file
