/*
   Name- createProfileInfoFile

   Language- C     Type- MAIN

   Version- 1.0    Date-  2/04/2015   Programmer- Mike Pettey (IMSG)

   Function- This subroutines reads the parameter_info.xml file and
             creates a profile_info.xml file.
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "ods7_capture.h"


#define TEMPERATURE   0
#define DEWPOINT_TEMP 1
#define WATER_VAPOR   2


struct profile_level
  {
  float  pressure;
  int    parm_id;
  struct profile_level *next;
  };

struct profile
  {
  char   description[100];
  int    parm_id;
  int    profile_type;
  int    line_color;
  int    line_thickness;
  int    line_style;
  struct profile_level *levels;
  struct profile *next;
  };

struct profile *profiles;
struct profile *new_profile;


void addParameterLevel(int parm_id, float pressure);
void createNewProfile(int parm_id, struct profile_level *level);


void createProfileInfoFile()
  {
  int    i, ival, parm_id;
  int    build_id, build_pressure;
  float  pressure;
  char   c;
  char   parm_info_filename[1000], ods_file_name[1000];
  char   id_tag[15], pressure_tag[11], parm_start_tag[12], parm_end_tag[13];
  char   id_string[25], pressure_string[25];
  FILE   *in, *ods;

  struct profile *prof_ptr;
  struct profile_level *level_ptr;

  profiles = NULL;

  // Open the parameter definition file

  sprintf(parm_info_filename, "ods/parameter_info.xml");

  if ((in=fopen(parm_info_filename,"r")) == NULL)
    {
    printf("\n\nThe info file \"%s\" could not be opened for input.\n", parm_info_filename);
    printf("Execution ending.\n\n");
    exit(1);
    }

  // While looping one character at a time, copy the character and also look for
  // the file_name, parameter_name and pressure tags

  while (! feof(in))
    {
    c = getc(in);

    ival = (int)c;

    if (ival >= 0)
      {
      if (build_id == TRUE)
        {
        if (c == '<')
          {
          build_id = FALSE;
          parm_id = atoi(id_string);
          }  // if (c == '<'...
        else
          {
          sprintf(id_string, "%s%c", id_string, c);
          }
        }  // else if (build_id...


      else if (build_pressure == TRUE)
        {
        if (c == '<')
          {
          build_pressure = FALSE;
          pressure = atof(pressure_string);
          }  // if (c == '<'...
        else
          {
          sprintf(pressure_string, "%s%c", pressure_string, c);
          }
        }  // else if (build_pressure...


      else
        {
        
        // Build the parameter start tag

        for (i=1; i<12; i++)
          parm_start_tag[i-1] = parm_start_tag[i];

        parm_start_tag[10] = c;
        parm_start_tag[11] = '\0';

        if (strcmp(parm_start_tag, "<parameter>") == 0)
          {
          parm_id  = -32678;
          pressure = -32768.0;
          }
         
        // Build the parameter end tag

        for (i=1; i<13; i++)
          parm_end_tag[i-1] = parm_end_tag[i];

        parm_end_tag[11] = c;
        parm_end_tag[12] = '\0';

        if (strcmp(parm_end_tag, "</parameter>") == 0)
          {
          addParameterLevel(parm_id, pressure);
          }
        
        // Build the id tag

        for (i=1; i<14; i++)
          id_tag[i-1] = id_tag[i];

        id_tag[13] = c;
        id_tag[14] = '\0';

        if (strcmp(id_tag, "<parameter_id>") == 0)
          {
          build_id = TRUE;
          
          for (i=0; i<25; i++)
            id_string[i] = '\0';
          }

        // Build the pressure tag

        for (i=1; i<11; i++)
          pressure_tag[i-1] = pressure_tag[i];

        pressure_tag[9] = c;
        pressure_tag[10] = '\0';

        if (strcmp(pressure_tag, "<pressure>") == 0)
          {
          build_pressure = TRUE;
          
          for (i=0; i<25; i++)
            pressure_string[i] = '\0';
          }
        }  // else...
      }  // if (ival >= 0...
    }  // while (! feof...

  fclose(in);


  // Start writing to the profile_info.xml file

  if (profiles != NULL)
    {
    sprintf(ods_file_name, "out.dir/profile_info.xml");

    if ((ods=fopen(ods_file_name,"w")) == NULL)
      {
      printf("\n\nThe ODS profile_info.xml file could not be opened for output.\n");
      printf("Execution ending.\n\n");
      exit(1);
      }

    fprintf(ods, "<?xml version=\"1.0\" standalone=\"yes\" ?>\n\n");
    fprintf(ods, "<profile_info>\n");
    
    prof_ptr = profiles;
    
    while (prof_ptr != NULL)
      {
      fprintf(ods, "\n  <profile>\n");
      fprintf(ods, "    <description>%s</description>\n", prof_ptr->description);
      fprintf(ods, "    <parameter_id>%d</parameter_id>\n", prof_ptr->parm_id);
      
      if (prof_ptr->profile_type == TEMPERATURE)
        fprintf(ods, "    <type>temperature</type>\n\n");
      else if (prof_ptr->profile_type == DEWPOINT_TEMP)
        fprintf(ods, "    <type>dewpoint temp</type>\n\n");
      else if (prof_ptr->profile_type == WATER_VAPOR)
        fprintf(ods, "    <type>water vapor</type>\n\n");
      
      fprintf(ods, "    <line_color>%d</line_color>\n", prof_ptr->line_color);
      fprintf(ods, "    <line_thickness>%d</line_thickness>\n", prof_ptr->line_thickness);
      fprintf(ods, "    <line_style>%d</line_style>\n\n", prof_ptr->line_style);
      
      fprintf(ods, "    <levels>\n");
      
      level_ptr = prof_ptr->levels;
      
      while (level_ptr != NULL)
        {
        fprintf(ods, "      <pressure>%f</pressure>\n", level_ptr->pressure);
        level_ptr = level_ptr->next;
        }
      
      fprintf(ods, "    </levels>\n");
      fprintf(ods, "  </profile>\n");

      prof_ptr = prof_ptr->next;
      }  // while (prof_ptr != NULL...


    fprintf(ods, "</profile_info>\n");
    
    fclose(ods);
    }  // if (profiles != null...
  }


void printProfileTree()
  {
  struct profile *prof_ptr;
  struct profile_level *level_ptr;
  
  prof_ptr = profiles;
  
  while (prof_ptr != NULL)
    {
    printf("Prof:  %d\n", prof_ptr->parm_id);
    level_ptr = prof_ptr->levels;
    
    while (level_ptr != NULL)
      {
      printf("  Level:  %f\n", level_ptr->pressure);
      level_ptr = level_ptr->next;
      }
    
    prof_ptr = prof_ptr->next;
    }
  }



void addParameterLevel(int parm_id, float pressure)
  {
  int profile_located, position_located;
  struct profile       *prof_ptr;
  struct profile_level *level_temp;
  struct profile_level *level_ptr;
  struct profile_level *prev_level_ptr;

  if (parm_id <= -1100)
    {
    
    // Create a new profile level

    level_temp = (struct profile_level*)malloc(sizeof (struct profile_level));

    level_temp->parm_id  = parm_id;
    level_temp->pressure = pressure;
    level_temp->next = NULL;

    // Loop through the profiles

    if (profiles == NULL)
      {
      createNewProfile(parm_id, level_temp);
      profiles = new_profile;
      }
    else
      {
      prof_ptr = profiles;
      profile_located = FALSE;
      
      while (prof_ptr != NULL)
        {
        if (prof_ptr->parm_id == parm_id)
          {
          profile_located = TRUE;
          position_located = FALSE;

          level_ptr = prof_ptr->levels;
          prev_level_ptr = NULL;

          while ((level_ptr != NULL) && (position_located == FALSE))
            {

//****backwards GOES
	    if (pressure < level_ptr->pressure)
              {
	      level_temp->next = level_ptr;
              prev_level_ptr->next = level_temp;

              position_located = TRUE;
              }

            prev_level_ptr = level_ptr;
            level_ptr = level_ptr->next;
            }  // while (level_ptr...

          if (position_located == FALSE)
            {
            if (prev_level_ptr == NULL)
              prof_ptr->levels = level_temp;
            else
              prev_level_ptr->next = level_temp;
            }
          }  // if (prof_ptr->parm_id...

        prof_ptr = prof_ptr->next;
        }  // while (prof_ptr...

      // If a matching profile was not located, then add a new one
      // to the end of the list

      if (profile_located == FALSE)
        {
        prof_ptr = profiles;
        
        while (prof_ptr->next != NULL)
          prof_ptr = prof_ptr->next;
        
        createNewProfile(parm_id, level_temp);
        prof_ptr->next = new_profile;
        }
      }  // else (profiles != NULL...
    }  // if (parm_id >= 5000...
  }



void createNewProfile(int parm_id, struct profile_level *level)
  {
  new_profile = (struct profile*)malloc(sizeof (struct profile));

  if (parm_id == -1100)
    {
    sprintf(new_profile->description, "Retrieved");
    new_profile->parm_id        = parm_id;
    new_profile->profile_type   = TEMPERATURE;
    new_profile->line_color     = 255000000;
    new_profile->line_thickness = 5;
    new_profile->line_style     = 1;
    new_profile->levels         = level;
    new_profile->next           = NULL;
    }
  else if (parm_id == -1500)
    {
    sprintf(new_profile->description, "Retrieved Layer");
    new_profile->parm_id        = parm_id;
    new_profile->profile_type   = TEMPERATURE;
    new_profile->line_color     = 175000000;
    new_profile->line_thickness = 5;
    new_profile->line_style     = 1;
    new_profile->levels         = level;
    new_profile->next           = NULL;
    }
  else if (parm_id == -1600)
    {
    sprintf(new_profile->description, "Retrieved Level");
    new_profile->parm_id        = parm_id;
    new_profile->profile_type   = TEMPERATURE;
    new_profile->line_color     = 255100100;
    new_profile->line_thickness = 5;
    new_profile->line_style     = 1;
    new_profile->levels         = level;
    new_profile->next           = NULL;
    }

  else if (parm_id == -1101)
    {
    sprintf(new_profile->description, "First Guess");
    new_profile->parm_id        = parm_id;
    new_profile->profile_type   = TEMPERATURE;
    new_profile->line_color     = 000175000;
    new_profile->line_thickness = 5;
    new_profile->line_style     = 1;
    new_profile->levels         = level;
    new_profile->next           = NULL;
    }
  else if (parm_id == -1501)
    {
    sprintf(new_profile->description, "First Guess Layer");
    new_profile->parm_id        = parm_id;
    new_profile->profile_type   = TEMPERATURE;
    new_profile->line_color     = 000225000;
    new_profile->line_thickness = 5;
    new_profile->line_style     = 1;
    new_profile->levels         = level;
    new_profile->next           = NULL;
    }
  else if (parm_id == -1601)
    {
    sprintf(new_profile->description, "First Guess Level");
    new_profile->parm_id        = parm_id;
    new_profile->profile_type   = TEMPERATURE;
    new_profile->line_color     = 100255100;
    new_profile->line_thickness = 5;
    new_profile->line_style     = 1;
    new_profile->levels         = level;
    new_profile->next           = NULL;
    }

  else if (parm_id == -1102)
    {
    sprintf(new_profile->description, "MW-only");
    new_profile->parm_id        = parm_id;
    new_profile->profile_type   = TEMPERATURE;
    new_profile->line_color     = 000000255;
    new_profile->line_thickness = 5;
    new_profile->line_style     = 1;
    new_profile->levels         = level;
    new_profile->next           = NULL;
    }
  else if (parm_id == -1502)
    {
    sprintf(new_profile->description, "MW-only Layer");
    new_profile->parm_id        = parm_id;
    new_profile->profile_type   = TEMPERATURE;
    new_profile->line_color     = 000000150;
    new_profile->line_thickness = 5;
    new_profile->line_style     = 1;
    new_profile->levels         = level;
    new_profile->next           = NULL;
    }
  else if (parm_id == -1602)
    {
    sprintf(new_profile->description, "MW-only Level");
    new_profile->parm_id        = parm_id;
    new_profile->profile_type   = TEMPERATURE;
    new_profile->line_color     = 100100255;
    new_profile->line_thickness = 5;
    new_profile->line_style     = 1;
    new_profile->levels         = level;
    new_profile->next           = NULL;
    }

  else if (parm_id == -3100)
    {
    sprintf(new_profile->description, "Retrieved");
    new_profile->parm_id        = parm_id;
    new_profile->profile_type   = WATER_VAPOR;
    new_profile->line_color     = 255000000;
    new_profile->line_thickness = 5;
    new_profile->line_style     = 2;
    new_profile->levels         = level;
    new_profile->next           = NULL;
    }
  else if (parm_id == -3500)
    {
    sprintf(new_profile->description, "Retrieved Layer");
    new_profile->parm_id        = parm_id;
    new_profile->profile_type   = WATER_VAPOR;
    new_profile->line_color     = 255000000;
    new_profile->line_thickness = 5;
    new_profile->line_style     = 2;
    new_profile->levels         = level;
    new_profile->next           = NULL;
    }
  else if (parm_id == -3600)
    {
    sprintf(new_profile->description, "Retrieved Level");
    new_profile->parm_id        = parm_id;
    new_profile->profile_type   = WATER_VAPOR;
    new_profile->line_color     = 255000000;
    new_profile->line_thickness = 5;
    new_profile->line_style     = 2;
    new_profile->levels         = level;
    new_profile->next           = NULL;
    }

  else if (parm_id == -3101)
    {
    sprintf(new_profile->description, "First Guess");
    new_profile->parm_id        = parm_id;
    new_profile->profile_type   = WATER_VAPOR;
    new_profile->line_color     = 000175000;
    new_profile->line_thickness = 5;
    new_profile->line_style     = 2;
    new_profile->levels         = level;
    new_profile->next           = NULL;
    }
  else if (parm_id == -3501)
    {
    sprintf(new_profile->description, "First Guess Layer");
    new_profile->parm_id        = parm_id;
    new_profile->profile_type   = WATER_VAPOR;
    new_profile->line_color     = 000225000;
    new_profile->line_thickness = 5;
    new_profile->line_style     = 2;
    new_profile->levels         = level;
    new_profile->next           = NULL;
    }
  else if (parm_id == -3601)
    {
    sprintf(new_profile->description, "First Guess Level");
    new_profile->parm_id        = parm_id;
    new_profile->profile_type   = WATER_VAPOR;
    new_profile->line_color     = 100255100;
    new_profile->line_thickness = 5;
    new_profile->line_style     = 2;
    new_profile->levels         = level;
    new_profile->next           = NULL;
    }

  else if (parm_id == -3102)
    {
    sprintf(new_profile->description, "MW-only");
    new_profile->parm_id        = parm_id;
    new_profile->profile_type   = WATER_VAPOR;
    new_profile->line_color     = 000000255;
    new_profile->line_thickness = 5;
    new_profile->line_style     = 2;
    new_profile->levels         = level;
    new_profile->next           = NULL;
    }
  else if (parm_id == -3502)
    {
    sprintf(new_profile->description, "MW-only Layer");
    new_profile->parm_id        = parm_id;
    new_profile->profile_type   = WATER_VAPOR;
    new_profile->line_color     = 000000150;
    new_profile->line_thickness = 5;
    new_profile->line_style     = 2;
    new_profile->levels         = level;
    new_profile->next           = NULL;
    }
  else if (parm_id == -3602)
    {
    sprintf(new_profile->description, "MW-only Level");
    new_profile->parm_id        = parm_id;
    new_profile->profile_type   = WATER_VAPOR;
    new_profile->line_color     = 100100255;
    new_profile->line_thickness = 5;
    new_profile->line_style     = 2;
    new_profile->levels         = level;
    new_profile->next           = NULL;
    }

  else
    {
    new_profile = NULL;
    }
  }

// end of file
