#include <time.h>

/*
   Name- checkDate.c

   Language- C     Type- MAIN

   Version- 1.0    Date-  9/01/2001   Programmer- Mike Pettey (Raytheon)

   Function- This program accepts a date value in YYYYMMDD format and checks
             to see if the date is valid. A return value of 1 means the date
             is valid while a return value of 0 means it is not valid.
*/

void convertTime(double fov_time, int *yr, int *md, int *hr, int *ms)
  {
  time_t  date_time;
  struct  tm  *ts;
  long    seconds_since_1970;
  int     year, month, day, mmdd;
  int     hour, minute, second, mmss;

  /* Convert milliseconds to seconds */

  date_time = fov_time / 1000.0;

  /* Use gmtime to convert the epoch time to date and time */

  ts = gmtime(&date_time);

  month  = ts->tm_mon + 1;
  day    = ts->tm_mday;
  year   = ts->tm_year;

  if (year > 56)
    year = 1900 + year;
  else
    year = 2000 + year;

  hour   = ts->tm_hour;
  minute = ts->tm_min;
  second = ts->tm_sec;

  mmdd = (month * 100) + day;
  mmss = (minute * 100) + second;

  /* If the fov_time is 0, fill the date and time with missing values */

  if (fov_time == 0.0)
    {
    year = -32768;
    mmdd = -32768;
    hour = -32768;
    mmss = -32768;
    }

  /* Return the values */

  *yr = year;
  *md = mmdd;
  *hr = hour;
  *ms = mmss;
  }

/* end of file */
