#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <math.h>
#include "ods7_capture.h"

/*
   Name- copyIntegerBuffer.c

   Language- C     Type- MAIN

   Version- 1.0    Date-  7/07/2015   Programmer- Mike Pettey (IMSG)

   Function- This program accepts a date value in YYYYMMDD format and checks
             to see if the date is valid. A return value of 1 means the date
             is valid while a return value of 0 means it is not valid.
*/

#define  SWAP_IN   FALSE
#define  SWAP_OUT  TRUE

void copyIntegerBuffer(char *set_name, char *parm_file_name, int block_num, 
		       int *buffer, int num_used_fovs)
  {
  int     n, fov;
  char    ods_file_name[1000];
  FILE   *ods;

  // Create the output file

  sprintf(ods_file_name, "out.dir/%s/%s/block_%d.dat", set_name, parm_file_name, block_num);

  if ((ods=fopen(ods_file_name,"w")) == NULL)
    {
    printf("\n\nThe ODS block data file file %s could not be opened for output.\n",
	   ods_file_name);
    printf("Execution ending.\n\n");
    exit(1);
    }

  // Swap the bytes (if necessary)

  for (fov=0; fov<num_used_fovs; fov++)
    {
    if (SWAP_OUT == TRUE)
      buffer[fov] = htonl(buffer[fov]);
    }

  // Write the buffer to the output file

  fwrite(buffer, 4, num_used_fovs, ods);

  fclose(ods);
  }

// end of file
