<!--// JavaScript Document
//
		var ParmListFilenames=["cld1_asol",
					   "cld2_ecam",
					   "cld3_cttp",
					   "cld4_ctpr",
					   "cld5_clqc",
					   "cld6_cdif",
					   "cld7_cper",
					   "cld8_tprs",
					   "cld9_ttem",
					   "ra01_aolr",
					   "ra02_colr",
					   "ra03_clr1",
					   "ra04_clr2",
					   "ra05_clr3",
					   "ra06_clr4",
					   "ra07_acco"
					   ];
	var ParmList=["Aerosol Amount",
						 "Effective Cloud Amount", 
						 "Cloud Top Temperature",
						 "Cloud Top Pressure",
						 "Cloud QC",
						 "Cloud Difference",
						 "Cloud Product Error",
						 "Tropopause Pressure",
						 "Tropopause Temperature",
						 "All Sky OLR",
						 "Clear Sky OLR",
						 "Clear Sky LCR 1 (1000-700mb)",
						 "Clear Sky LCR 2 (700-500mb)",
						 "Clear Sky LCR 3 (500-240mb)",
						 "Clear Sky LCR 4 (240-10mb)",
						 "All Sky Clear OLR"];
	var ParmDescriptions=["The Aerosol Amount (%) is retrieved using the same algorithm as the water vapor clouds, with the exception that the Microwave Humidity Sounder (MHS), the High Resolution Infrared Sounder (HIRS) and the Advanced Microwave Sounder Unit (AMSU) are employed to determine if the atmosphere for the retrieval of this parameter is dry enough to qualify as not water vapor. A phase calculation would be required to determine if the Aerosol is Sea Salt, Quartz, Smoke, Industrial Pollution, Volcanic Ash, etc.",
		"The Effective Cloud Amount (%) represents the retrieved physical cloud and contains all atmospheric constituents (water vapor clouds and aerosols). This physical quantity is simply an intermediate variable representing the ratio of radiance difference fields and is used as input for Cloud Clearing of the HIRS/4 channels. Exceptions to this calculation are for  very thin, warm cloud features at low altitudes where a different algorithm had to be employed.",
		"The Cloud Top Temperature (K) is generally derived using the Newton-Raphson Iterative Technique. Exceptions to this calculation were generally in areas of very thin, warm cloud features at low altitudes.",
		"The Cloud Top Pressure (mb) is obtained by using the Cloud Top Temperature and the coincident (or near coincident) temperature sounding.",
		"This flag represents the processing path used to generate the cloud products as follows:<ul class='tighter'><li><strong style='color: #666;'>GRAY</strong>: CLEAR areas derived from the processing of water vapor clouds. </li><li><strong style='color: #082aa2;'>DARK BLUE:</strong> Retrieved water vapor clouds. </li><li><strong style='color: #ff0000;'>RED:</strong> Retrieved water vapor clouds where the CTT is greater than the Predicted CLEAR Temp. (almost never occurs). </li><li><strong style='color: #0f8528;'>DARK GREEN:</strong> Retrieved aerosols. </li><li><strong style='color: #ece402;'>YELLOW:</strong> Retrieved clouds where the Surf. Temp. Est. is greater than the Predicted CLEAR Temp. (almost never occurs). </li><li><strong style='color: #72ea24;'>BRIGHT GREEN:</strong> CLEAR where the CTP was below the model surface pressure (very accurate) </li><li><strong style='color: #11d4d2;'>CYAN:</strong> CLEAR where CTT is greater than the Predicted CLEAR Temp. (occurs occasionally) </li><li><strong>WHITE:</strong> Retrieved water vapor clouds or aerosols where the ECA is small and an extinction algorithm was used. </li><li><strong style='color: #6510C6;'>VIOLET:</strong> CLEAR areas derived from the processing of aerosols.</li></ul>  ",
		"This flag shows the difference between the ATOVS Cloud Detection Mask and the Cloud Products as follows: <ul class='tighter'><li><strong style='color: #11d4d2;'>CYAN:</strong> The temperature sounding is CLOUDY and the Cloud product is CLEAR (usually only 2% of coverage). </li><li><strong style='color: #0f8528;'>DARK GREEN:</strong> The temperature sounding is CLOUDY and so is the Cloud product. </li><li><strong style='color: #666;'>GRAY:</strong> The temperature sounding is CLEAR and so is the Cloud product. </li><li><strong style='color: #ff0000;'>RED:</strong> The temperature sounding is CLEAR and the Cloud product is CLOUDY (usually thin aerosols). </li></ul>",
		"The CPE is calculated with the same criteria as the ECA except Cloud Cleared HIRS/4 channels are used instead of measured channels. The Predicted CLEAR Temperature is kept the same. The CPE is displayed  +/- 5% as follows: <ul class='tighter'><li><strong style='color: #ff0000;'>RED:</strong> Positive errors < 5%. </li><li><strong style='color: #0030e3;'>BLUE:</strong>  Negative errors > -5%. </li><li><strong style='color: #72ea24;'>BRIGHT GREEN:</strong> Negative errors  < -5% (usually associated with large cloud features). </li><li><strong style='color: #ece402;'>YELLOW:</strong> Positive errors > 5% (usually associated with large cloud features).</li></ul>  ",
		"The Tropopause Pressure is is enerated from the ATOVS sounding, however, since this product is used in the Cloud Clearing step, it has been corrected for some seasonal errors associated with this same paramter contained in the sounding record.",
		"The Tropopause Temperature is is enerated from the ATOVS sounding, however, since this product is used in the Cloud Clearing step, it has been corrected for some seasonal errors associated with this same paramter contained in the sounding record.",
		"This OLR product is derived from HIRS/4 channels and is possibly slightly more accurate than that derived from AVHRR/3.",
		"This OLR product utilizes the ALL_SKY OLR and filters it with the Cloud products and terrain considerations to obtain the CLEAR_SKY OLR. ",
		"This LCR is generated only in CLEAR areas, for the (1000 - 700 mb layer), and is filtered for cloud and terrain considerations.",
		"This LCR is generated only in CLEAR areas, for the (700 - 500 mb layer), and is filtered for cloud and terrain considerations.",
		"This LCR is generated only in CLEAR areas, for the (500 - 240 mb layer), and is filtered for cloud and terrain considerations.",
		"This LCR is generated only in CLEAR areas, for the (240 -  10 mb layer), and is filtered only for very high clouds. ",
		"This OLR product is generated in the same manner as the ALL_SKY OLR except that Cloud Cleared HIRS/4 channels are used instead of the measured channels.",
		"This parameter is generated by subtracting the ALL_SKY OLR  from the  ALL_SKY CLEAR OLR."];

	var currentNode = "time1";
	var currentSat = "NOAA-19";
	var currentProductIndex = 1;
	var numProducts = ParmList.length;
	
function getNextProductIndex(ProductIndex) {
	var selbox = document.selectProduct.setProduct;
    if (ProductIndex != numProducts-1) ProductIndex++;
	else ProductIndex = 0;
	selbox.options.selectedIndex = ProductIndex; 
    return ProductIndex;
}

function getPrevProductIndex() {
	var nextProductIndex = numProducts-1;
	var selbox = document.selectProduct.setProduct;
    if (currentProductIndex != 0) nextProductIndex = currentProductIndex - 1;
	selbox.options.selectedIndex = nextProductIndex; 
    return nextProductIndex;
}


function loadCldRadImage(obj, sat, imageFolder, product, node) {
    if (document.getElementById) {
    	if (sat != " ") currentSat = sat;
    	if ((product >= 0) && (product <= numProducts-1)) currentProductIndex = product;
    	if (node != " ") 
    		if (node == "next") currentProductIndex = getNextProductIndex(currentProductIndex);
            else if (node == "prev") currentProductIndex = getPrevProductIndex();
			else if (node == 'asc') currentNode = "time1";
			else currentNode = "time2";
		currentProduct = ParmListFilenames[currentProductIndex];
		var ImageURL = imageFolder + "/" + currentSat + "/" + currentNode + "/clim/" + currentProduct + "_full.png";
		document.getElementById('PFPic').src = ImageURL;
		document.getElementById('PFH4').innerHTML = ParmDescriptions[currentProductIndex];
		document.getElementById('PFPic').alt = currentSat +" - "+ ParmList[currentProductIndex];
		document.getElementById('PFPic').title = currentSat +" - "+ ParmList[currentProductIndex];
	  }
}
//-->
