<!--// JavaScript Document
//
		var Ancillary=["clod_clam",
					   "clod_cmsk",
					   "clod_ctpr",
					   "depr_lodp",
					   "depr_stdp",
					   "depr_updp",
					   "temp_cttp",
					   "temp_sktp",
					   "temp_sstp",
					   "tooz_ozon",
					   "tooz_tozf",
					   "watr_cllw",
					   "watr_prfl",
					   "watr_topw"];
		var Temps=["temp_0005",
					"temp_0007",
					"temp_0010",
					"temp_0020",
					"temp_0030",
					"temp_0050",
					"temp_0070",
					"temp_0100",
					"temp_0150",
					"temp_0200",
					"temp_0250",
					"temp_0300",
					"temp_0400",
					"temp_0500",
					"temp_0700",
					"temp_0850",
					"temp_1000"];
		var Wvaps=[	"wvap_0200",
					"wvap_0250",
					"wvap_0300",
					"wvap_0400",
					"wvap_0500",
					"wvap_0700",
					"wvap_0850",
					"wvap_1000"];
	ProductAnc = ["Effective Cloud Amount", 
						 "Cloud Mask",
						 "Cloud Top Pressure",
						 "Lower Departure",
						 "Stability Departure",
						 "Upper Departure",
						 "Cloud Top Temperature",
						 "Skin Temperature",
						 "Sea Surface Temperature",
						 "Total Ozone",
						 "Ozone Quality Flag",
						 "Cloud Liquid Water",
						 "Precipitation Flag",
						 "Total Precipitable Water"];
	ProductTemps = ["Temp 5mb",
						 "Temp 7mb",
						 "Temp 10mb",
						 "Temp 20mb",
						 "Temp 30mb",
						 "Temp 50mb",
						 "Temp 70mb",
						 "Temp 100mb",
						 "Temp 150mb",
						 "Temp 200mb",
						 "Temp 250mb",
						 "Temp 300mb",
						 "Temp 400mb",
						 "Temp 500mb",
						 "Temp 700mb",
						 "Temp 850mb",
						 "Temp 1000mb"];
	ProductWvaps = ["Water Vapor 200mb",
						 "Water Vapor 250mb",
						 "Water Vapor 300mb",
						 "Water Vapor 400mb",
						 "Water Vapor 500mb",
						 "Water Vapor 700mb",
						 "Water Vapor 850mb",
						 "Water Vapor 1000mb"];
	//var currentProdtype = "parm";
	var currentNode = "time1";
	var currentSat = "NOAA-19";
	var currentProdtype = "temp";
	var currentProductIndex = 13;
	
function setProductList(prodtype) {
	var selbox = document.selectProduct.setProduct;
    selbox.options.length = 0;
	if (prodtype == "parm") {
		numOptions = Ancillary.length;
		currentProductIndex = 0;
		j = 0;
		while (j < numOptions) {
			selbox.options[selbox.options.length] = new Option(ProductAnc[j],j);
			j++; }
	} else if (prodtype == "temp") {
		numOptions = Temps.length;
		j = 0;
		while (j < numOptions) {
			selbox.options[selbox.options.length] = new Option(ProductTemps[j],j);
			j++; }
	} else {
		numOptions = Wvaps.length;
		j = 0;
		while (j < numOptions) {
			selbox.options[selbox.options.length] = new Option(ProductWvaps[j],j);
			j++; }
	}
}
function getNextProductIndex() {
	var selbox = document.selectProduct.setProduct;
	if (currentProdtype == "parm") numProducts = Ancillary.length;
	else if (currentProdtype == "temp") numProducts = Temps.length;
	else numProducts = Wvaps.length;
    if (currentProductIndex == numProducts-1) nextProductIndex = 0;
    else nextProductIndex = currentProductIndex + 1;
	selbox.options.selectedIndex = nextProductIndex; 
    return nextProductIndex;
}

function getPrevProductIndex() {
	var selbox = document.selectProduct.setProduct;
	if (currentProdtype == "parm") numProducts = Ancillary.length;
	else if (currentProdtype == "temp") numProducts = Temps.length;
	else numProducts = Wvaps.length;
    if (currentProductIndex == 0) nextProductIndex = numProducts-1;
    else nextProductIndex = currentProductIndex - 1;
	selbox.options.selectedIndex = nextProductIndex; 
    return nextProductIndex;
}


function loadProdImage(obj, sat, prodtype, imageFolder, product, node) {
    if (document.getElementById) {
    	if (sat != " ") currentSat = sat;
    	if (prodtype != " ") {
			currentProdtype = prodtype;
			currentProductIndex = 0;
			setProductList(prodtype);
		}
    	if ((product >= 0) && (product <= numProducts-1)) currentProductIndex = product;
    	if (node != " ") 
    		if (node == "next") currentProductIndex = getNextProductIndex();
            else if (node == "prev") currentProductIndex = getPrevProductIndex();
			else if (node == 'asc') currentNode = "time1";
			else currentNode = "time2";
		if (currentProdtype == "parm")  currentProduct = Ancillary[currentProductIndex];
		else 
		if (currentProdtype == "temp")  currentProduct = Temps[currentProductIndex];
		else 
		if (currentProdtype == "wvap")  currentProduct = Wvaps[currentProductIndex];
		var ImageURL = imageFolder + "/" + currentSat + "/" + currentNode + "/" + currentProdtype + "/" + currentProduct + "_full.png";
		document.getElementById('PFPic').src = ImageURL;
		document.getElementById('PFPic').alt = ImageURL + " Temperature ";
	  }
}
//-->
