<?php include ('includes/setAllPaths.inc');
include ($globalPath.'noCacheHeader.inc'); ?>
<title><?php include('includes/subsiteTitle.inc'); ?> - NPROVS User Interface</title>
<?php include($globalPath.'styleLinks.inc'); ?>
<style>
table#framework img {
	margin-bottom: 30px !important;
}

table#framework td {
	margin-left: 20px !important;
}
</style>
</head>
<body>
	<div id="wrap">
		<div class="outline">
			<?php include($globalPath.'headerNewStretchySearch.inc');	?>
			<div id="navContainer">
				<?php include("includes/NavDiv.inc"); ?>
				<!-- content inserted UNDER this comment and BEFORE the closing </div>
				 below will appear below the nav panel inside the left-hand column -->
			</div>
	<div id="main">
	  <div class="mainInner">
		<?php include($globalPath.'noScriptWarning.inc'); ?>
		<h1><?php include('includes/subsiteTitle.inc'); ?> - NPROVS</h1>
		<?php // page content insertion can start after this comment.  ?>

		<div><a href="images/narcs/narcs_example.png" class="fancybox"><img src="images/narcs/narcs_example.png" 
				  style="width: 500px; padding: 0 0 15px 15px;" id="rgt"
			  alt="NARCS"></a>
		</div>

		<h2>Download the program</h2>
		<p>Last Updated: <?php include($globalPath.'DateChanged.inc');?></p>

  <script type="text/javascript">
      function downloadApp(d) {
        window.location = 'https://www.star.nesdis.noaa.gov/smcd/opdb/nprovs/' + d;
      }
  </script>

 <p><a href="#" onClick="downloadApp('apps/NARCS.jar');"; >Click here to download NARCS <br>Version (4.11)</a> 

		<p><strong>*** NOTE: Beginning with version 4.02, it is necessary to include two external libraries within a "lib" 
		directory that is in the same directory as NARCS.jar. If these libraries are not present, NARCS will create them 
		and then display a dialog box that will say that the program needs to be restarted. At that point, close the dialog 
		box and restart the program to resume normal operation.</p>
        </strong>
		<p><a href="documents/NARCS_Quick_Start.pdf">NARCS Quick Start Guide</a> &nbsp;&nbsp;&nbsp;

		<h2>Download the files</h2>
		<p>NARCS data are available: 
		<a href="https://www.star.nesdis.noaa.gov/data/nprovs/monitoring/narcs/" target="_blank">from the NPROVS data page</a></p>
		<p>There are several files with qualifiers:</p>

<ul style="font-size: 1.1em; font-weight: bold;">
  <li>Second qualifier indicates whether it is standard NPROVS or NPROVPLUS which is only for a certain set of dedicated RAOB stations</li>
  <li>Third qualifier indicates a particular RAOB, conus meaning for just N. America region, nrt is Near Real Time, rep means reprocessed (usually for new RAOBS included)</li>
  <li>Last qualifier is a date indicating last update.  These files all start with 20080410 which is when NPROVS was started.  NPROVSPLUS did not start till 20130714. </li>
</ul>

<p>An example is <strong>narcs_nprovs_nrt_20190911.dat</strong> which is a standard NPROVS 
Near-Realtime file with data starting on April 10, 2008 and updated on September 11, 2019</p>

<h2>NARCS Overview</h2>

<p>The NPROVS Archive Statistics (NARCS) program is used to view long-term vertical 
accuracy statistics for multiple processing systems compared to a common baseline system 
(radiosondes). Daily, weekly and monthly statistics are generated for bias, standard 
deviation, root mean square, r-squared and sample size.</p>

<p>NARCS makes it easy to view the historical performance of all 
systems. It is capable of quickly identifying a variety of features:</p>

<br>

<table id="framework">
  <tr>
    <td><a href="images/narcs/narcs_comparison.png" class="fancybox"><img src="images/narcs/narcs_comparison.png" style="width: 500px;" alt="NARCS Comparison"></a></td>
    <td><strong>System Comparison</strong>
        <p>The relative performance of different systems can be compared for any chosen time period.</p></td>
  </tr>
  <tr>
    <td><a href="images/narcs/narcs_seasonal.png class="fancybox"><img src="images/narcs/narcs_seasonal.png" style="width: 500px;" alt="NARCS Seasonal"></a></td>
    <td><br><strong>Seasonal Trends</strong>
        <P>Seasonal trends are easily identifiable.</p></td>
  </tr>
  <tr>
    <td><a href="images/narcs/narcs_spikes.png" class="fancybox"><img src="images/narcs/narcs_spikes.png" style="width: 500px;" alt="NARCS Spikes"></a></td>
    <td><br><strong>Occasional Bad Data</strong>
        <P>If bad or questionable data are present in a system, the results from NARCS 
		will often show the existence of the data. It also makes it easy to isolate individual 
		days with bad data to make it easier to track down the problem.</p></td>
  </tr>
  <tr>
    <td><a href="images/narcs/narcs_sudden_problem.png" class="fancybox"><img 
	src="images/narcs/narcs_sudden_problem.png" style="width: 500px;" alt="NARCS Sudden Problem"></a></td>
    <td><br><strong>Sudden Problems</strong>
        <P>Negative changes in the performance of a system can be seen using NARCS.</td>
  </tr>
  <tr>
    <td><a href="images/narcs/narcs_improvement.png" class="fancybox"><img 
	src="images/narcs/narcs_improvement.png" style="width: 500px;" alt="NARCS Improvement"></a></td>
    <td><br><strong>Performance Improvements</strong>
        <p>When changes to a system result in positive improvements 
		in system performance, NARCS can verify the results.</p></td>
  </tr>
</table>

<br><br>

<H2>Installing and Running NARCS</H2>

<P>NARCS is a Java program. As such, it can be run on any system on which Java has been 
installed including Windows, Mac OS X, Linux and others. Installing the program is typically 
as simple as copying the NARCS.jar file (linked above) to a folder on a local computer. 
The icon can then be double-clicked to run it.</p>

<p>More information about running NARCS can be found in the NARCS User's Guide and the 
<a href="documents/NARCS_Quick_Start.pdf">NARCS Quick Start Guide</a></p>

<br>
<?php // end of user created page content ?>
	  </div>
	  </div>
<?php include($globalPath.'footer.inc'); ?>
<!-- closing the two enclosing divs -->
	  </div>
	</div>
</body>
</html>
