<?php include ('includes/setAllPaths.inc');
include ($globalPath.'noCacheHeader.inc'); ?>
<title><?php include('includes/subsiteTitle.inc'); ?> - NPROVS Data Access</title>
<?php include($globalPath.'styleLinks.inc'); ?>
</head>
<body>
	<div id="wrap">
		<div class="outline">
			<?php include($globalPath.'headerNewStretchySearch.inc');	?>
			<div id="navContainer">
				<?php  include("includes/NavDiv.inc"); ?>
				<!-- content inserted UNDER this comment and BEFORE the closing </div>
				 below will appear below the nav panel inside the left-hand column -->
			</div>
	<div id="main">
	  <div class="mainInner">
		<?php include($globalPath.'noScriptWarning.inc'); ?>
		<h1><?php include('includes/subsiteTitle.inc'); ?></h1>
		<?php // page content insertion can start after this comment. ?>




        <h2>NPROVS Data Access </h2>

	<p>Selected NPROVS data files are available for download. The data are divided
	into two categories: daily collocation files and files intended for use with
	NPROVS graphical applications.
	</p>


        <div><img src="images/NPROVS/nprovs_netcdf_structure.png" 
    	style="width: 300px;" id="rgt"
	alt="Structure of NPROVS netCDF file">
	</div>


        <h3>Collocation Files</h3>

	<p>Collocation files containing a single day of collocations are available for the
	<a href="https://www.star.nesdis.noaa.gov/data/nprovs/collocations/nprovs">Conventional</a>
	 NPROVS and for the
	<a href="https://www.star.nesdis.noaa.gov/data/nprovs/collocations/nprovs_special">NPROVS special</a>
	 system. The files are available in netCDF format. The structures of the NPROVS collocation
	 netCDF files are generally consistent but will vary slightly depending on the amount of
	 data contained within each file and the available data platforms.
	</p>

	<p> The top group within the file will contain one or more directories that contain the
	data for each data platform. The daily collocation files usually contain a single
	directory that is named after the date of the data in the file. In some cases, particularly
	when multiple days are combined into the same file, there will be more than one
	date directory.
	</p>

        <p>Within the date directory are subdirectories that contain the data for each platform.
	The names of the platform subdirectories are comprised of the platform name and an NPROVS
	internal id that is unique to each data platform.</p>

	<p>Also within the date directory is a subdirectory called "Collocation_Info". This
	directory contains the date, time, latitude and longitude of every collocation in the file.
	The dimension (Num_Collocations) and order of these variables match the dimension and order
	of all variables in the file.
	</p>

	<p>The top group of the file also contains variables that describe the included
	data platforms in the file.
	  <ul>
            <li>Num_Platforms: the dimension of the variables and is the number of included
	    platforms.</li>

	    <li>platform_name:  the platform names.</li>

	    <li>platform_dir_name:  matches the name of the subsirectories in the data group.
	    This typically makes it convenient to know the directory names without needing to
	    perform a query on the file.</li>

	    <li>platform_id:  An integer that is unique to each data platform. This number is
	    used internally by NPROVS to keep track of which data platform is which.</li>

	    <li>platform_type:  An integer used internally by NPROVS to know what type of data
	    each platform contains. The NPROVS graphical routines use this to know what
	    variables and what sounding profiles are available for a given platform.</li>
	  </ul>
	</p>


        <br>

        <h3>Graphical Application Files</h3>

	<p>In addition to the collocation files, NPROVS also produces files that are designed
	for specific use with the available graphical applications. The graphic files are
	available for downloading from the <a href="graphical_applications.php">Graphical 
	Applications</a> page. The data files may be downloaded from the following links:

	  <ul>
		<li><b><a href="https://www.star.nesdis.noaa.gov/data/nprovs/monitoring/profiledisplay">ProfileDisplay</a></b>:  The files for ProfileDisplay are often the collocation files combined into multiple days. The program is able to read the netCDF collocation files as well as older binary files. ProfileDisplay is able to display each individual collocation, calculate vertical accuracy statistics and filter the data that are displayed and used in the calculation of statistics.</li>

	        <li><b><a href="https://www.star.nesdis.noaa.gov/data/nprovs/monitoring/narcs">NPROVS Archive Statistics (NARCS)</a></b>:  The NARCS files are used by the NARCS graphical application.
                  <ul>
                    <li>Files in main directory: The *.narcs files contain statistics generated 
		    for the most recent five year period.</li>
		    <li>full_run:  The full_run directory contains NARCS files that show statistics
                    from 2008 to present for NPROVS and from 2013 to present for NPROVS Special.</li>
		    <li>alaska:  The alaska directory contains site specific statistics for every
		    radiosonde station in the Alaska region.</li>
		    <li>chuas:  The chuas directory contains site specific statistics for every
		    radiosonde station in the Caribbean region.</li>
                  </ul>

		<li><b><a href="https://www.star.nesdis.noaa.gov/data/nprovs/monitoring/ods">Orbital Display System (ODS)</a></b>:  The ODS files contain a single day of data for the various
		platforms. These files allow for the generation of images showing the available
		parameters. The most recent five days of data are available for downloading. </li>

	  </ul>

	</p>






<?php // end of user created page content ?>
	  </div>
	  </div>
<?php include($globalPath.'footer.inc'); ?>
<!-- closing the two enclosing divs -->
	  </div>
	</div>
</body>
</html>
