$(function () {
    $('#nucapsirmw_Sea_Temperature_Bias_10hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 10 hPa Level Statistics, Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: -5.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 0.396, -0.031, 0.0, 0.19, -0.579, -0.662, 0.112, 0.23, 0.025, -0.257, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, -0.597, -0.865, -1.009, -1.155, -1.55, -1.471, -0.634, -0.952, -1.231, -0.987, -0.812, -0.611, -0.86, -0.759, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 0.471, 0.526, 0.171, -0.185, -0.302, -0.251, 0.032, 0.316, 0.059, -0.23, -0.005, -0.316, 0.522, 0.366, -0.076, 0.273, 0.421, 0.091, 0.319, 0.162, 0.012, -0.027, 0.084, 0.009, 0.454, 0.495, 0.487, 0.53, 0.335, 0.194, 0.331, -0.007, 0.644, 0.253, 0.208, 0.553, 0.369, 0.212, -0.01, -0.086, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -0.846, 0.22, 0.39, 0.458, 0.648, 0.513, 0.534, 0.429, 0.639, 0.652, 0.449, -0.065, 0.097, 0.019, 0.209, 0.485, 0.155, 0.8, 0.461, 0.658, 0.301, 0.318, 0.285, 0.05, 0.181, -0.02, 0.038, 0.086, 0.235, 0.268, 0.318, 0.01, 0.017, 0.279, -0.263, 0.199, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 0.533, 0.345, 0.067, -0.194, -0.362, -0.25, 0.205, 0.203, 0.003, 0.502, 0.542, 0.025, 0.36, 0.464, -0.115, 0.0, 0.455, 0.474, 0.239, 0.205, 0.065, -0.176, -0.162, 0.01, 0.41, 0.05, -0.05, 0.45, -0.036, 0.037, -0.087, 0.152, 0.427, 0.388, 0.053, 0.061, 0.042, -0.212, -0.146, -0.289, 0.383, 0.528, 0.403, -0.227, 0.262, 0.367, 0.464, 0.298, 0.215, -0.006, 0.357, 0.492, 0.237, 0.26, 0.316, 0.121, -0.28, -0.467, 0.311, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.751, 0.639, 0.594, 0.38, 0.297, 0.117, 0.774, 0.989, 0.687, 0.538, 0.496, 0.412, 0.002, 0.412, null] 
        }]
    })
    $('#nucapsirmw_Sea_WaterVapor_Bias_10hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 10 hPa Level Statistics, Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 50.0,
          min: -50.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, -94.617, -96.235, -95.839, -96.72, -94.683, -93.567, -94.29, -95.039, -96.472, -96.333, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, -95.81, -96.443, -96.543, -95.669, -95.897, -95.078, -94.417, -95.28, -95.195, -95.473, -97.254, -98.12, -96.757, -97.758, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, -97.019, -96.471, -96.403, -95.775, -94.425, -93.844, -94.799, -95.688, -96.005, -95.528, -96.083, -97.996, -95.541, -97.129, -96.019, -97.101, -95.404, -95.053, -94.915, -95.451, -95.168, -95.707, -97.287, -96.902, -96.644, -94.929, -93.965, -91.572, -91.645, -90.933, -89.461, -91.933, -93.754, -92.733, -91.706, -95.493, -93.281, -91.955, -92.805, -92.308, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -94.812, -95.402, -93.261, -93.934, -91.306, -90.621, -91.219, -89.61, -93.015, -91.439, -92.41, -91.702, -90.326, -91.681, -92.284, -90.622, -91.165, -89.856, -88.716, -89.774, -91.203, -91.698, -91.282, -94.533, -93.744, -92.294, -92.429, -91.302, -91.314, -92.285, -91.952, -91.549, -90.551, -92.923, -93.616, -93.279, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, -94.349, -94.858, -96.051, -96.77, -94.82, -93.481, -95.059, -94.315, -94.789, -94.184, -93.246, -95.346, -94.612, -95.884, -94.146, -98.197, -94.165, -95.08, -96.231, -95.836, -94.967, -95.556, -94.952, -94.838, -95.4, -95.32, -92.387, -90.873, -92.001, -91.12, -90.049, -91.327, -90.904, -92.463, -91.241, -89.551, -90.028, -89.835, -89.923, -90.556, -89.562, -88.508, -89.832, -91.81, -92.423, -92.089, -95.015, -90.77, -91.574, -92.1, -90.878, -90.643, -91.344, -91.304, -91.378, -89.99, -94.786, -94.161, -93.219, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -90.944, -95.046, -90.836, -91.085, -92.533, -91.138, -90.336, -90.531, -92.724, -90.22, -91.751, -95.33, -94.442, -92.926, null] 
        }]
    })
    $('#nucapsirmw_Sea_Temperature_StdDev_10hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 10 hPa Level Statistics, Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.996, 1.987, 1.828, 2.417, 2.392, 2.114, 2.176, 1.921, 2.213, 1.981, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 2.066, 2.198, 1.989, 2.11, 2.333, 2.382, 2.207, 2.082, 2.032, 2.074, 1.953, 2.213, 1.901, 2.181, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 2.036, 1.975, 1.936, 2.369, 2.325, 2.14, 2.43, 2.286, 2.101, 1.879, 1.939, 1.808, 2.071, 2.19, 2.389, 2.436, 2.259, 2.323, 2.31, 2.007, 2.063, 2.074, 2.249, 2.091, 2.048, 2.174, 1.965, 2.197, 2.545, 2.187, 1.785, 2.188, 1.94, 1.79, 2.016, 2.129, 2.042, 1.948, 2.02, 2.134, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.939, 2.032, 1.902, 2.063, 2.147, 2.421, 2.268, 2.315, 2.18, 2.26, 1.825, 1.935, 2.018, 2.223, 1.83, 2.073, 2.26, 2.838, 2.596, 2.665, 2.171, 2.313, 1.873, 2.166, 1.963, 2.227, 2.373, 1.815, 2.023, 2.067, 2.313, 1.835, 2.231, 1.84, 1.944, 2.216, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 2.061, 1.96, 1.971, 2.274, 2.481, 2.424, 2.341, 2.173, 2.173, 2.153, 2.058, 2.128, 2.247, 2.197, 2.541, 2.591, 2.534, 2.614, 2.112, 1.953, 2.334, 1.908, 1.845, 1.751, 2.053, 2.094, 1.88, 2.108, 2.322, 2.188, 1.958, 2.064, 1.913, 1.928, 1.855, 2.041, 1.972, 1.98, 2.116, 2.144, 3.093, 2.727, 2.563, 2.258, 2.149, 1.728, 2.588, 2.005, 2.558, 1.948, 1.905, 2.332, 2.228, 2.132, 2.017, 2.109, 1.985, 2.186, 2.104, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.749, 2.528, 1.885, 2.239, 2.407, 2.014, 2.372, 2.136, 1.95, 2.279, 2.203, 2.051, 2.032, 1.777, null] 
        }]
    })
    $('#nucapsirmw_Sea_WaterVapor_StdDev_10hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 10 hPa Level Statistics, Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 2.357, 1.204, 2.258, 1.505, 2.585, 3.087, 2.676, 2.508, 1.495, 1.581, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 2.237, 1.758, 1.425, 2.217, 1.588, 1.611, 2.529, 2.43, 2.497, 2.425, 1.088, 0.599, 1.199, 0.964, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 1.335, 1.689, 1.909, 2.344, 2.976, 3.108, 2.67, 2.213, 1.954, 2.1, 1.773, 0.762, 2.276, 1.248, 2.082, 1.164, 1.967, 1.828, 2.007, 1.568, 2.456, 2.196, 1.183, 1.262, 1.301, 2.134, 2.663, 3.147, 3.038, 3.909, 3.653, 2.672, 2.41, 2.601, 2.864, 0.883, 3.271, 2.685, 3.697, 2.849, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 2.673, 1.983, 3.379, 2.563, 4.0, 3.692, 4.629, 4.68, 2.742, 3.162, 3.894, 3.95, 4.371, 4.198, 4.045, 4.03, 3.426, 4.629, 5.342, 4.8, 3.954, 2.957, 3.401, 2.28, 2.413, 3.199, 2.806, 3.8, 3.572, 3.995, 4.232, 4.231, 3.616, 3.104, 3.233, 3.009, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 2.845, 2.803, 2.154, 1.661, 2.521, 3.105, 2.025, 2.735, 2.437, 2.858, 3.004, 2.426, 2.005, 1.238, 2.881, 0.302, 2.816, 1.877, 1.18, 1.718, 2.361, 1.904, 2.511, 2.347, 1.574, 1.403, 3.152, 3.128, 3.96, 4.217, 4.412, 3.1, 2.84, 3.697, 2.828, 3.329, 3.935, 3.425, 3.63, 3.878, 4.845, 4.833, 4.351, 3.29, 2.508, 3.019, 1.302, 4.258, 3.647, 2.902, 3.314, 3.36, 3.166, 3.971, 3.617, 4.154, 2.645, 2.398, 2.536, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 3.033, 1.31, 4.221, 3.829, 2.889, 3.36, 3.471, 3.215, 2.732, 4.427, 3.522, 2.457, 2.283, 2.649, null] 
        }]
    })
    $('#nucapsirmw_Sea_Temperature_RMS_10hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 10 hPa Level Statistics, Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 2.035, 1.987, 1.828, 2.424, 2.461, 2.216, 2.179, 1.935, 2.213, 1.998, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 2.15, 2.362, 2.231, 2.405, 2.801, 2.8, 2.296, 2.29, 2.376, 2.297, 2.115, 2.296, 2.087, 2.309, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 2.09, 2.043, 1.944, 2.377, 2.344, 2.155, 2.43, 2.307, 2.102, 1.893, 1.939, 1.835, 2.135, 2.221, 2.39, 2.451, 2.298, 2.324, 2.332, 2.013, 2.063, 2.074, 2.251, 2.091, 2.098, 2.23, 2.025, 2.26, 2.567, 2.195, 1.815, 2.188, 2.044, 1.808, 2.027, 2.199, 2.075, 1.959, 2.02, 2.136, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 2.115, 2.044, 1.942, 2.113, 2.243, 2.475, 2.33, 2.355, 2.272, 2.352, 1.88, 1.936, 2.02, 2.223, 1.842, 2.129, 2.265, 2.948, 2.637, 2.745, 2.192, 2.335, 1.894, 2.167, 1.971, 2.227, 2.373, 1.818, 2.037, 2.084, 2.335, 1.835, 2.232, 1.861, 1.961, 2.225, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 2.129, 1.99, 1.972, 2.283, 2.507, 2.437, 2.35, 2.183, 2.173, 2.211, 2.128, 2.128, 2.276, 2.246, 2.543, 2.591, 2.575, 2.656, 2.125, 1.964, 2.334, 1.917, 1.852, 1.751, 2.094, 2.094, 1.881, 2.156, 2.322, 2.188, 1.96, 2.069, 1.961, 1.967, 1.855, 2.042, 1.973, 1.991, 2.121, 2.164, 3.117, 2.778, 2.595, 2.27, 2.165, 1.766, 2.63, 2.027, 2.567, 1.948, 1.938, 2.384, 2.241, 2.148, 2.042, 2.113, 2.004, 2.236, 2.126, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.903, 2.607, 1.976, 2.271, 2.425, 2.018, 2.495, 2.354, 2.068, 2.342, 2.258, 2.092, 2.032, 1.824, null] 
        }]
    })
    $('#nucapsirmw_Sea_WaterVapor_RMS_10hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 10 hPa Level Statistics, Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 95.538, 99.652, 97.6, 99.156, 96.346, 97.841, 98.406, 96.699, 99.206, 99.255, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 98.099, 98.994, 99.335, 98.626, 99.372, 99.405, 98.634, 98.228, 98.383, 97.637, 99.501, 99.793, 99.459, 99.476, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 99.243, 99.083, 98.448, 97.493, 96.461, 97.766, 97.848, 98.328, 98.584, 96.771, 99.073, 99.702, 98.469, 99.23, 98.065, 99.473, 98.945, 99.283, 99.185, 99.45, 97.34, 97.431, 99.337, 99.493, 99.44, 98.812, 98.5, 92.924, 92.835, 92.649, 90.782, 92.796, 98.811, 93.695, 92.765, 99.823, 97.824, 92.791, 95.907, 93.618, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 97.726, 99.015, 96.405, 98.605, 93.683, 92.189, 96.225, 92.479, 98.675, 92.698, 96.385, 94.348, 92.48, 96.0, 95.894, 92.512, 92.84, 92.437, 91.747, 92.167, 93.297, 92.813, 92.507, 98.887, 99.061, 93.831, 93.53, 93.327, 93.062, 96.797, 94.657, 94.254, 92.157, 94.639, 96.023, 94.949, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 95.977, 96.257, 97.714, 98.756, 96.418, 97.875, 99.054, 95.809, 96.051, 95.572, 94.566, 98.099, 99.147, 99.605, 96.353, 99.946, 98.098, 99.149, 99.593, 99.108, 98.599, 98.942, 97.242, 98.453, 99.409, 99.566, 94.103, 92.081, 96.64, 97.258, 92.169, 92.315, 91.785, 95.619, 92.222, 90.557, 91.75, 90.933, 91.486, 92.32, 92.219, 90.813, 91.815, 93.064, 93.172, 93.378, 99.653, 93.466, 93.469, 93.09, 92.162, 91.998, 92.637, 93.474, 92.861, 92.025, 97.366, 95.298, 94.245, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 92.107, 99.651, 93.334, 92.979, 93.564, 92.47, 91.616, 91.745, 98.78, 92.36, 98.069, 97.714, 95.503, 93.999, null] 
        }]
    })
    $('#nucapsirmw_Land_Temperature_Bias_10hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 10 hPa Level Statistics, Land, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: -5.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 0.137, -0.163, -0.195, -0.196, -0.385, -0.251, -0.301, -0.474, -0.401, -0.174, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, -0.514, -0.742, -0.691, -0.731, -0.859, -0.827, -0.813, -1.065, -0.864, -0.661, -0.187, -0.232, -0.381, -0.527, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 0.326, 0.133, 0.219, 0.306, 0.069, 0.184, 0.345, 0.0, -0.029, 0.091, 0.568, 0.574, 0.366, 0.305, 0.371, 0.357, 0.927, 0.7, 0.458, 0.146, -0.159, -0.079, 0.188, 0.405, 0.492, 0.508, 0.482, 0.649, 0.551, 0.733, 0.53, 0.545, 0.285, 0.406, 0.531, 0.507, 0.667, 0.555, 0.396, 0.48, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.438, 0.593, 0.68, 0.587, 0.565, 0.389, 0.554, 0.251, 0.328, 0.353, 0.648, 0.705, 0.776, 0.84, 0.809, 0.662, 0.283, 0.302, 0.838, 0.682, 0.494, 0.405, 0.391, 0.39, 0.53, 0.622, 0.666, 0.508, 0.369, 0.41, 0.204, 0.272, 0.349, 0.396, 0.5, 0.556, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 0.166, -0.056, -0.064, 0.022, -0.193, -0.225, -0.178, -0.338, -0.265, -0.02, 0.373, 0.481, 0.471, 0.313, 0.205, 0.238, 0.624, 0.346, 0.12, 0.081, -0.099, -0.055, 0.174, 0.307, 0.283, 0.177, 0.128, 0.104, -0.058, 0.187, -0.019, -0.093, -0.036, 0.291, 0.393, 0.415, 0.427, 0.254, -0.012, -0.16, -0.021, 0.445, 0.29, 0.021, 0.065, 0.162, 0.395, 0.531, 0.48, 0.342, 0.201, 0.227, 0.234, 0.186, 0.075, 0.029, 0.086, 0.25, 0.356, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.366, 0.623, 0.667, 0.554, 0.459, 0.302, 0.392, 0.532, 0.476, 0.325, 0.208, 0.259, 0.475, 0.596, null] 
        }]
    })
    $('#nucapsirmw_Land_WaterVapor_Bias_10hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 10 hPa Level Statistics, Land, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 50.0,
          min: -50.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, -98.722, -97.671, -96.943, -93.598, -94.788, -95.962, -94.581, -94.597, -97.395, -98.264, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, -98.924, -97.786, -96.914, -93.543, -94.371, -95.97, -94.344, -94.861, -97.523, -98.572, -99.179, -99.218, -98.922, -98.371, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, -99.052, -98.159, -97.338, -94.41, -94.819, -95.505, -94.313, -95.482, -97.765, -98.623, -99.23, -99.294, -99.073, -98.45, -97.357, -95.394, -94.63, -94.005, -94.149, -96.55, -97.675, -98.659, -99.191, -99.321, -99.122, -98.264, -96.965, -96.232, -96.403, -96.479, -96.72, -96.203, -97.184, -98.16, -98.91, -99.07, -98.91, -98.122, -96.856, -95.284, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -99.211, -99.025, -97.957, -96.396, -95.421, -96.172, -96.23, -96.494, -95.505, -96.952, -98.211, -98.866, -99.017, -98.815, -97.978, -96.328, -94.227, -93.044, -93.428, -94.704, -96.287, -96.787, -98.242, -98.931, -98.933, -98.716, -97.87, -95.849, -95.077, -95.146, -95.277, -94.926, -96.804, -96.989, -98.131, -98.708, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, -98.697, -97.635, -96.817, -93.486, -94.446, -95.704, -94.449, -94.701, -97.409, -98.338, -98.91, -99.019, -98.796, -97.978, -96.526, -95.156, -94.791, -94.976, -94.76, -97.138, -97.86, -98.351, -98.899, -99.055, -98.803, -97.829, -96.197, -95.335, -96.067, -96.66, -96.776, -95.651, -96.676, -98.078, -98.69, -98.844, -98.624, -97.739, -96.257, -94.025, -92.264, -93.551, -95.475, -96.23, -96.602, -98.04, -98.736, -98.712, -98.502, -97.588, -95.774, -94.953, -94.996, -95.558, -95.039, -96.761, -96.779, -97.92, -98.543, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -98.168, -98.755, -98.746, -98.505, -97.702, -96.095, -95.332, -95.207, -95.683, -95.243, -96.834, -96.878, -98.014, -98.53, null] 
        }]
    })
    $('#nucapsirmw_Land_Temperature_StdDev_10hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 10 hPa Level Statistics, Land, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.983, 1.729, 1.901, 2.163, 2.421, 2.616, 2.262, 2.194, 2.119, 2.035, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 2.012, 1.791, 1.944, 2.143, 2.428, 2.751, 2.267, 2.283, 2.125, 2.019, 2.162, 2.135, 1.961, 1.838, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 1.995, 1.759, 1.967, 2.127, 2.421, 2.727, 2.253, 2.289, 2.124, 2.054, 2.148, 2.1, 1.969, 1.835, 1.961, 2.201, 2.777, 2.427, 2.38, 2.276, 1.933, 1.931, 2.041, 2.054, 1.966, 1.822, 1.941, 2.189, 2.528, 2.435, 2.289, 2.149, 1.954, 1.944, 2.001, 2.024, 2.002, 1.854, 1.998, 2.165, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 2.175, 1.946, 1.821, 1.88, 2.158, 2.568, 2.44, 2.304, 2.177, 1.889, 1.927, 1.957, 1.965, 1.946, 1.807, 1.935, 2.241, 2.377, 2.621, 2.421, 2.11, 1.82, 1.893, 2.045, 2.062, 1.939, 1.848, 1.853, 2.263, 2.227, 2.353, 2.327, 2.354, 1.818, 1.856, 1.909, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.985, 1.735, 1.883, 2.119, 2.384, 2.617, 2.202, 2.187, 2.119, 2.065, 2.144, 2.099, 1.98, 1.799, 1.895, 2.105, 2.689, 2.393, 2.347, 2.214, 1.936, 1.908, 2.077, 2.097, 1.939, 1.793, 1.811, 2.119, 2.544, 2.499, 2.295, 2.079, 1.852, 1.893, 1.961, 2.003, 1.943, 1.754, 1.933, 2.168, 2.364, 2.539, 2.47, 2.08, 1.787, 1.866, 2.04, 2.032, 1.936, 1.837, 1.799, 2.225, 2.276, 2.382, 2.367, 2.295, 1.759, 1.861, 1.973, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.911, 2.037, 2.023, 1.927, 1.771, 1.793, 2.227, 2.288, 2.38, 2.333, 2.271, 1.786, 1.819, 1.859, null] 
        }]
    })
    $('#nucapsirmw_Land_WaterVapor_StdDev_10hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 10 hPa Level Statistics, Land, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 0.458, 1.042, 1.227, 2.601, 1.335, 0.995, 1.179, 2.267, 0.942, 0.815, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 0.485, 1.007, 1.293, 2.727, 1.937, 0.976, 1.998, 2.164, 0.934, 0.693, 0.406, 0.317, 0.506, 0.748, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 0.439, 0.838, 1.105, 2.341, 2.047, 1.26, 2.535, 1.91, 0.814, 0.678, 0.399, 0.24, 0.389, 0.736, 0.972, 1.491, 1.48, 1.358, 1.195, 0.852, 0.952, 0.642, 0.404, 0.337, 0.458, 0.801, 1.385, 1.337, 1.56, 0.551, 0.7, 1.011, 1.02, 0.805, 0.529, 0.462, 0.5, 0.853, 1.26, 1.867, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.393, 0.468, 1.003, 1.626, 1.611, 1.325, 0.581, 0.792, 1.409, 1.163, 0.789, 0.523, 0.472, 0.615, 0.92, 1.498, 1.978, 2.015, 1.961, 1.803, 1.143, 1.462, 0.881, 0.516, 0.495, 0.572, 0.96, 1.84, 1.847, 1.645, 1.262, 0.883, 0.945, 0.982, 0.846, 0.597, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 0.5, 1.11, 1.31, 2.671, 1.419, 1.06, 1.182, 2.138, 0.953, 0.78, 0.457, 0.382, 0.533, 0.922, 1.297, 1.451, 1.479, 1.238, 1.403, 0.796, 0.851, 0.772, 0.517, 0.45, 0.581, 1.015, 1.671, 1.597, 1.27, 0.363, 0.604, 1.216, 1.434, 0.895, 0.54, 0.54, 0.615, 1.024, 1.346, 2.076, 2.42, 1.801, 1.306, 1.081, 1.572, 0.958, 0.605, 0.597, 0.665, 1.072, 1.833, 2.028, 1.678, 1.098, 0.99, 1.022, 1.093, 0.947, 0.549, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.901, 0.554, 0.626, 0.7, 1.044, 1.615, 1.839, 1.679, 1.136, 0.959, 1.006, 1.182, 0.929, 0.759, null] 
        }]
    })
    $('#nucapsirmw_Land_Temperature_RMS_10hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 10 hPa Level Statistics, Land, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.988, 1.737, 1.911, 2.172, 2.451, 2.628, 2.282, 2.245, 2.157, 2.042, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 2.076, 1.938, 2.064, 2.265, 2.576, 2.873, 2.409, 2.519, 2.294, 2.125, 2.17, 2.147, 1.998, 1.912, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 2.021, 1.764, 1.979, 2.149, 2.422, 2.733, 2.28, 2.289, 2.124, 2.056, 2.222, 2.177, 2.003, 1.86, 1.996, 2.23, 2.928, 2.526, 2.424, 2.281, 1.939, 1.932, 2.05, 2.093, 2.027, 1.892, 1.999, 2.284, 2.587, 2.543, 2.35, 2.217, 1.975, 1.986, 2.071, 2.087, 2.111, 1.936, 2.037, 2.218, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 2.219, 2.035, 1.944, 1.97, 2.231, 2.597, 2.503, 2.318, 2.201, 1.922, 2.033, 2.08, 2.113, 2.12, 1.98, 2.045, 2.259, 2.396, 2.752, 2.515, 2.168, 1.865, 1.933, 2.081, 2.129, 2.037, 1.965, 1.921, 2.293, 2.264, 2.362, 2.343, 2.379, 1.86, 1.923, 1.988, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.992, 1.735, 1.884, 2.119, 2.392, 2.627, 2.209, 2.213, 2.136, 2.065, 2.176, 2.154, 2.036, 1.826, 1.906, 2.118, 2.761, 2.418, 2.35, 2.215, 1.939, 1.909, 2.084, 2.119, 1.96, 1.802, 1.816, 2.122, 2.545, 2.506, 2.295, 2.081, 1.853, 1.916, 2.0, 2.045, 1.99, 1.773, 1.933, 2.173, 2.364, 2.578, 2.487, 2.08, 1.788, 1.873, 2.077, 2.1, 1.995, 1.869, 1.81, 2.236, 2.288, 2.389, 2.368, 2.295, 1.761, 1.878, 2.004, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.946, 2.13, 2.13, 2.005, 1.829, 1.818, 2.262, 2.349, 2.427, 2.356, 2.281, 1.805, 1.881, 1.952, null] 
        }]
    })
    $('#nucapsirmw_Land_WaterVapor_RMS_10hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 10 hPa Level Statistics, Land, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 99.65, 99.347, 99.404, 98.82, 99.652, 99.759, 99.744, 98.878, 99.629, 99.495, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 99.713, 99.321, 99.403, 98.728, 99.331, 99.783, 99.298, 98.951, 99.632, 99.566, 99.741, 99.742, 99.655, 99.527, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 99.739, 99.529, 99.509, 98.909, 99.148, 99.66, 98.666, 99.052, 99.691, 99.587, 99.761, 99.764, 99.708, 99.576, 99.599, 99.509, 99.603, 99.724, 99.782, 99.792, 99.53, 99.605, 99.754, 99.759, 99.701, 99.466, 99.186, 99.472, 99.165, 99.911, 99.868, 99.72, 99.581, 99.564, 99.696, 99.734, 99.675, 99.483, 99.41, 99.069, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 99.751, 99.657, 99.329, 99.067, 99.388, 99.51, 99.915, 99.829, 99.525, 99.476, 99.494, 99.68, 99.701, 99.629, 99.445, 99.286, 99.249, 99.407, 99.427, 99.407, 99.635, 99.144, 99.354, 99.691, 99.674, 99.607, 99.428, 98.98, 99.253, 99.442, 99.684, 99.844, 99.715, 99.649, 99.48, 99.669, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 99.627, 99.233, 99.36, 98.818, 99.646, 99.759, 99.752, 99.013, 99.616, 99.496, 99.628, 99.663, 99.618, 99.482, 99.466, 99.545, 99.583, 99.702, 99.649, 99.784, 99.598, 99.543, 99.669, 99.66, 99.565, 99.326, 99.052, 99.425, 99.548, 99.962, 99.894, 99.66, 99.205, 99.402, 99.632, 99.647, 99.579, 99.392, 99.444, 99.209, 99.229, 99.519, 99.64, 99.71, 99.016, 99.276, 99.646, 99.59, 99.555, 99.352, 99.009, 99.062, 99.397, 99.727, 99.81, 99.675, 99.581, 99.41, 99.695, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 99.294, 99.659, 99.652, 99.53, 99.374, 99.191, 99.192, 99.357, 99.7, 99.819, 99.666, 99.473, 99.434, 99.425, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_Temperature_Bias_10hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 10 hPa Level Statistics, Land and Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: -5.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 0.097, -0.171, -0.221, -0.202, -0.369, -0.268, -0.28, -0.431, -0.385, -0.182, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, -0.524, -0.737, -0.684, -0.744, -0.882, -0.895, -0.82, -1.023, -0.87, -0.682, -0.236, -0.264, -0.417, -0.543, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 0.311, 0.147, 0.222, 0.291, 0.069, 0.138, 0.313, 0.051, -0.021, 0.083, 0.527, 0.539, 0.352, 0.303, 0.319, 0.357, 0.878, 0.629, 0.447, 0.132, -0.152, -0.082, 0.188, 0.375, 0.488, 0.505, 0.506, 0.646, 0.559, 0.642, 0.51, 0.552, 0.291, 0.378, 0.477, 0.494, 0.633, 0.542, 0.425, 0.431, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.384, 0.573, 0.663, 0.614, 0.607, 0.441, 0.537, 0.29, 0.387, 0.371, 0.594, 0.653, 0.735, 0.799, 0.78, 0.675, 0.291, 0.344, 0.813, 0.676, 0.507, 0.411, 0.393, 0.396, 0.494, 0.573, 0.637, 0.51, 0.379, 0.391, 0.171, 0.296, 0.337, 0.371, 0.473, 0.542, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 0.145, -0.065, -0.08, 0.006, -0.199, -0.242, -0.164, -0.315, -0.255, -0.03, 0.328, 0.43, 0.433, 0.286, 0.14, 0.202, 0.583, 0.307, 0.133, 0.071, -0.098, -0.051, 0.154, 0.275, 0.259, 0.148, 0.125, 0.108, -0.032, 0.15, -0.016, -0.047, -0.031, 0.228, 0.342, 0.364, 0.387, 0.215, -0.014, -0.174, -0.02, 0.397, 0.286, 0.007, 0.064, 0.162, 0.384, 0.473, 0.433, 0.315, 0.176, 0.212, 0.195, 0.106, 0.067, -0.005, 0.048, 0.202, 0.329, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.375, 0.609, 0.615, 0.505, 0.43, 0.285, 0.38, 0.491, 0.405, 0.324, 0.205, 0.235, 0.435, 0.561, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_WaterVapor_Bias_10hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 10 hPa Level Statistics, Land and Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 50.0,
          min: -50.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, -98.647, -97.555, -96.742, -93.678, -94.579, -95.688, -94.478, -94.41, -97.237, -98.239, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, -98.848, -97.677, -96.686, -93.58, -94.271, -95.686, -94.36, -94.606, -97.374, -98.526, -99.135, -99.177, -98.862, -98.317, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, -98.989, -98.058, -97.162, -94.434, -94.776, -95.26, -94.34, -95.281, -97.641, -98.587, -99.186, -99.258, -99.022, -98.378, -97.215, -95.27, -94.515, -93.913, -94.054, -96.375, -97.505, -98.56, -99.134, -99.262, -99.022, -98.072, -96.689, -95.801, -95.806, -96.041, -96.309, -95.789, -96.865, -97.929, -98.742, -98.967, -98.785, -97.884, -96.422, -94.906, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -99.093, -98.906, -97.733, -96.07, -94.925, -95.611, -95.895, -96.138, -95.071, -96.615, -98.028, -98.749, -98.904, -98.664, -97.749, -96.009, -93.728, -92.532, -93.027, -94.328, -95.872, -96.425, -98.017, -98.783, -98.789, -98.519, -97.612, -95.474, -94.743, -94.736, -94.832, -94.508, -96.465, -96.677, -97.91, -98.551, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, -98.614, -97.509, -96.628, -93.558, -94.423, -95.389, -94.402, -94.506, -97.255, -98.299, -98.859, -98.964, -98.706, -97.861, -96.321, -95.15, -94.568, -94.841, -94.664, -96.925, -97.691, -98.265, -98.814, -98.968, -98.693, -97.604, -95.882, -94.86, -95.544, -96.302, -96.425, -95.235, -96.342, -97.907, -98.571, -98.721, -98.473, -97.485, -95.969, -93.561, -91.839, -93.363, -95.014, -95.799, -96.242, -97.786, -98.578, -98.553, -98.283, -97.302, -95.399, -94.598, -94.574, -95.1, -94.662, -96.535, -96.48, -97.678, -98.426, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -97.934, -98.598, -98.58, -98.288, -97.426, -95.735, -94.904, -94.834, -95.263, -94.828, -96.639, -96.555, -97.79, -98.373, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_Temperature_StdDev_10hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 10 hPa Level Statistics, Land and Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.972, 1.762, 1.894, 2.163, 2.413, 2.585, 2.255, 2.18, 2.102, 2.003, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 2.003, 1.81, 1.936, 2.146, 2.453, 2.732, 2.29, 2.265, 2.117, 2.004, 2.129, 2.127, 1.957, 1.865, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 1.979, 1.771, 1.953, 2.132, 2.442, 2.698, 2.273, 2.268, 2.11, 2.027, 2.12, 2.085, 1.955, 1.856, 1.991, 2.214, 2.711, 2.409, 2.384, 2.259, 1.944, 1.929, 2.029, 2.035, 1.945, 1.828, 1.917, 2.173, 2.487, 2.393, 2.264, 2.134, 1.943, 1.922, 1.991, 2.012, 1.988, 1.852, 1.977, 2.16, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 2.169, 1.929, 1.827, 1.872, 2.139, 2.523, 2.409, 2.301, 2.159, 1.888, 1.922, 1.947, 1.959, 1.937, 1.81, 1.923, 2.233, 2.422, 2.645, 2.461, 2.13, 1.834, 1.893, 2.017, 2.047, 1.949, 1.862, 1.86, 2.258, 2.224, 2.381, 2.288, 2.354, 1.813, 1.847, 1.909, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.969, 1.762, 1.872, 2.121, 2.387, 2.583, 2.207, 2.16, 2.1, 2.041, 2.122, 2.081, 1.975, 1.82, 1.926, 2.11, 2.635, 2.4, 2.336, 2.205, 1.956, 1.891, 2.041, 2.061, 1.926, 1.796, 1.797, 2.104, 2.493, 2.464, 2.272, 2.068, 1.86, 1.892, 1.941, 1.995, 1.934, 1.763, 1.927, 2.17, 2.415, 2.568, 2.49, 2.096, 1.803, 1.846, 2.031, 2.017, 1.96, 1.852, 1.822, 2.22, 2.279, 2.421, 2.333, 2.289, 1.77, 1.855, 1.953, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.901, 2.022, 2.007, 1.947, 1.801, 1.814, 2.222, 2.281, 2.415, 2.296, 2.273, 1.785, 1.818, 1.841, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_WaterVapor_StdDev_10hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 10 hPa Level Statistics, Land and Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 0.49, 1.081, 1.321, 2.61, 1.427, 1.034, 1.235, 2.374, 0.983, 0.795, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 0.45, 1.07, 1.379, 2.785, 1.95, 1.038, 1.92, 2.286, 0.984, 0.702, 0.429, 0.357, 0.521, 0.762, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 0.396, 0.888, 1.173, 2.391, 1.99, 1.356, 2.531, 2.009, 0.846, 0.69, 0.434, 0.321, 0.438, 0.765, 1.015, 1.564, 1.567, 1.423, 1.267, 0.916, 1.001, 0.64, 0.433, 0.353, 0.458, 0.884, 1.472, 1.479, 1.788, 0.627, 0.767, 1.115, 1.126, 0.897, 0.568, 0.499, 0.553, 0.933, 1.409, 1.959, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.449, 0.52, 1.093, 1.745, 1.772, 1.476, 0.638, 0.853, 1.541, 1.282, 0.87, 0.567, 0.516, 0.684, 0.999, 1.277, 2.153, 2.214, 1.824, 1.798, 1.26, 1.599, 0.978, 0.569, 0.547, 0.657, 1.051, 1.995, 1.904, 1.812, 1.385, 0.979, 1.035, 1.071, 0.93, 0.655, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 0.491, 1.122, 1.4, 2.711, 1.47, 1.139, 1.234, 2.243, 1.005, 0.781, 0.483, 0.452, 0.529, 0.939, 1.387, 1.276, 1.59, 1.312, 1.48, 0.86, 0.901, 0.72, 0.563, 0.477, 0.658, 1.108, 1.774, 1.746, 1.424, 0.405, 0.679, 1.325, 1.55, 0.953, 0.585, 0.568, 0.671, 1.121, 1.154, 2.229, 2.615, 1.6, 1.42, 1.18, 1.71, 1.07, 0.633, 0.667, 0.769, 1.165, 1.985, 2.081, 1.851, 1.227, 1.075, 1.009, 1.194, 1.047, 0.579, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.012, 0.627, 0.665, 0.777, 1.146, 1.749, 1.963, 1.841, 1.257, 1.052, 0.98, 1.291, 1.014, 0.825, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_Temperature_RMS_10hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 10 hPa Level Statistics, Land and Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.974, 1.77, 1.907, 2.172, 2.441, 2.599, 2.272, 2.222, 2.137, 2.011, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 2.07, 1.955, 2.054, 2.272, 2.607, 2.875, 2.433, 2.485, 2.288, 2.117, 2.142, 2.143, 2.001, 1.942, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 2.004, 1.777, 1.966, 2.151, 2.443, 2.701, 2.295, 2.268, 2.11, 2.028, 2.184, 2.153, 1.987, 1.88, 2.016, 2.243, 2.85, 2.49, 2.426, 2.263, 1.95, 1.931, 2.038, 2.069, 2.005, 1.896, 1.983, 2.267, 2.549, 2.478, 2.321, 2.205, 1.965, 1.959, 2.047, 2.072, 2.087, 1.93, 2.022, 2.203, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 2.202, 2.012, 1.944, 1.97, 2.224, 2.561, 2.468, 2.319, 2.194, 1.924, 2.012, 2.054, 2.093, 2.096, 1.971, 2.039, 2.252, 2.446, 2.767, 2.552, 2.19, 1.88, 1.933, 2.056, 2.106, 2.032, 1.968, 1.929, 2.29, 2.258, 2.387, 2.307, 2.378, 1.851, 1.907, 1.985, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.975, 1.763, 1.873, 2.121, 2.395, 2.595, 2.214, 2.183, 2.116, 2.041, 2.147, 2.125, 2.022, 1.842, 1.931, 2.119, 2.699, 2.42, 2.34, 2.207, 1.958, 1.892, 2.047, 2.08, 1.944, 1.802, 1.802, 2.107, 2.493, 2.468, 2.272, 2.068, 1.86, 1.906, 1.971, 2.028, 1.972, 1.776, 1.927, 2.177, 2.415, 2.599, 2.506, 2.096, 1.805, 1.853, 2.067, 2.072, 2.007, 1.879, 1.83, 2.23, 2.287, 2.424, 2.334, 2.289, 1.77, 1.866, 1.98, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.937, 2.112, 2.099, 2.011, 1.852, 1.836, 2.255, 2.333, 2.449, 2.319, 2.283, 1.801, 1.87, 1.925, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_WaterVapor_RMS_10hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 10 hPa Level Statistics, Land and Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 99.682, 99.335, 99.364, 98.799, 99.617, 99.751, 99.723, 98.814, 99.615, 99.54, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 99.707, 99.307, 99.374, 98.662, 99.336, 99.774, 99.357, 98.89, 99.613, 99.571, 99.741, 99.74, 99.651, 99.549, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 99.774, 99.513, 99.472, 98.855, 99.219, 99.625, 98.679, 98.998, 99.677, 99.596, 99.759, 99.762, 99.713, 99.573, 99.576, 99.479, 99.557, 99.69, 99.755, 99.772, 99.515, 99.623, 99.759, 99.756, 99.696, 99.465, 99.168, 99.422, 99.084, 99.898, 99.855, 99.691, 99.547, 99.537, 99.692, 99.728, 99.68, 99.465, 99.366, 99.07, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 99.743, 99.648, 99.296, 99.023, 99.33, 99.467, 99.908, 99.817, 99.481, 99.438, 99.469, 99.672, 99.696, 99.62, 99.433, 99.569, 99.181, 99.331, 99.536, 99.461, 99.607, 99.096, 99.331, 99.681, 99.665, 99.592, 99.399, 98.917, 99.256, 99.373, 99.648, 99.823, 99.7, 99.622, 99.454, 99.66, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 99.663, 99.228, 99.317, 98.759, 99.624, 99.738, 99.731, 98.954, 99.599, 99.528, 99.627, 99.66, 99.622, 99.481, 99.422, 99.65, 99.536, 99.672, 99.609, 99.765, 99.586, 99.588, 99.667, 99.658, 99.589, 99.311, 99.017, 99.374, 99.511, 99.959, 99.886, 99.63, 99.18, 99.414, 99.626, 99.655, 99.582, 99.382, 99.66, 99.151, 99.136, 99.631, 99.616, 99.685, 98.975, 99.247, 99.64, 99.61, 99.538, 99.319, 98.946, 99.091, 99.328, 99.694, 99.788, 99.719, 99.55, 99.382, 99.688, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 99.276, 99.65, 99.642, 99.514, 99.343, 99.148, 99.164, 99.285, 99.672, 99.798, 99.725, 99.433, 99.412, 99.414, null] 
        }]
    })
    $('#nucapsirmw_Sea_Temperature_Bias_49hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 49 hPa Level Statistics, Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: -5.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 0.724, 0.49, 0.233, 0.191, -0.139, -0.013, -0.042, -0.157, -0.392, -0.291, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 0.584, 0.607, 0.412, 0.352, 0.087, -0.044, 0.302, 0.005, -0.187, 0.031, 0.111, 0.176, 0.302, 0.395, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 0.556, 0.688, 0.363, 0.105, -0.152, 0.153, 0.098, 0.076, -0.124, -0.093, 0.067, -0.134, 0.201, 0.291, 0.229, 0.111, -0.21, -0.305, -0.32, -0.196, -0.021, 0.139, 0.39, 0.307, 0.139, 0.265, 0.115, 0.061, 0.144, 0.188, 0.173, 0.604, 0.279, -0.311, 0.181, 0.401, 0.155, 0.336, 0.156, 0.42, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -0.01, -0.151, 0.044, 0.058, -0.259, -0.003, 0.141, 0.055, 0.209, 0.027, -0.388, -0.135, -0.016, -0.214, 0.048, 0.042, 0.109, 0.386, 0.616, 0.599, 0.6, 0.562, -0.061, 0.02, 0.033, 0.409, 0.296, 0.344, 0.266, 0.179, 0.077, -0.063, -0.123, -0.078, -0.439, -0.054, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 0.301, 0.043, -0.343, -0.492, -0.655, -0.668, -0.659, -0.803, -0.94, -0.857, -0.41, -0.589, -0.038, -0.184, -0.484, -0.405, -0.582, -0.827, -0.805, -0.772, -0.691, -0.564, -0.003, -0.072, -0.459, -0.308, -0.475, -0.805, -0.601, -0.567, -0.494, -0.477, -0.577, -0.992, -0.585, -0.092, -0.284, -0.327, -0.584, -0.746, -0.142, -0.372, 0.037, -0.384, -0.476, -0.681, -0.491, -0.14, -0.113, -0.231, -0.256, -0.407, -0.502, -0.7, -0.51, -0.558, -0.703, -1.044, -0.504, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -0.182, -0.111, 0.261, 0.434, 0.173, 0.124, 0.078, -0.188, -0.178, -0.23, -0.209, -0.286, -0.601, -0.163, null] 
        }]
    })
    $('#nucapsirmw_Sea_WaterVapor_Bias_49hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 49 hPa Level Statistics, Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 50.0,
          min: -50.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, -29.025, -27.779, -37.356, -26.128, -18.261, -13.062, -9.758, -49.092, -6.964, -16.501, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, -59.813, -56.614, -57.431, -33.822, -71.64, -59.125, -23.534, -56.049, -51.464, -43.977, -68.569, -67.751, -67.508, -76.016, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, -61.12, -59.923, -52.835, -49.437, -50.925, -66.237, -42.853, -50.329, -44.687, -39.469, -60.778, -76.016, -59.987, -66.611, -56.602, -71.156, -57.216, -32.909, -54.892, -57.043, -41.647, -33.578, -56.355, -59.495, -63.801, -48.706, -44.762, -22.314, 2.717, -42.948, 5.618, -3.497, -31.253, -41.619, -33.316, -40.563, -44.021, -12.328, -44.064, -17.171, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -29.896, -53.135, -42.796, -45.719, -14.883, -35.034, -32.887, -23.261, -5.16, -28.203, -32.342, -37.454, -37.093, -42.378, -40.869, -42.664, -11.889, -16.032, -7.324, 1.887, 9.373, -3.225, -25.448, -39.484, -35.367, -31.357, -15.726, 1.931, -100.263, -8.115, 20.337, 17.256, -14.893, -12.146, -17.718, -23.133, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, -38.601, -11.002, -20.219, -4.098, -23.373, -0.017, 14.18, -23.497, -49.422, -23.231, -48.766, -30.365, -51.384, -32.643, -15.143, -3.548, -8.369, 16.999, -9.646, -14.919, -19.147, -9.273, -33.775, -20.096, -29.51, -5.237, 2.105, 16.45, 6.924, 16.238, -5.426, 22.78, 1.34, -8.705, -8.138, 1.822, 5.535, 9.253, 8.485, 15.818, 29.347, 5.55, -9.019, 26.866, 0.722, -12.216, -30.302, -19.337, -30.992, -10.958, -100.258, -100.25, 33.057, 12.901, 29.594, -68.826, -0.202, -20.049, -29.014, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -11.903, -42.287, -22.753, -19.596, -1.027, 3.575, -100.236, 29.082, 52.544, 34.03, -68.686, 4.335, -20.187, -14.784, null] 
        }]
    })
    $('#nucapsirmw_Sea_Temperature_StdDev_49hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 49 hPa Level Statistics, Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.984, 1.812, 1.669, 1.731, 1.816, 1.828, 1.834, 1.908, 1.697, 1.848, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 1.954, 1.786, 1.697, 1.748, 1.658, 1.764, 1.973, 1.811, 1.783, 1.835, 1.722, 1.707, 1.572, 1.621, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 1.965, 1.689, 1.619, 1.782, 1.805, 1.849, 1.753, 1.79, 1.729, 1.857, 1.738, 1.814, 1.68, 1.508, 1.793, 1.745, 1.941, 1.945, 1.902, 2.006, 1.884, 2.18, 2.318, 1.789, 2.181, 2.1, 1.713, 1.811, 1.943, 1.933, 1.935, 2.031, 1.866, 1.829, 1.994, 1.601, 1.72, 1.651, 1.736, 1.697, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.57, 2.038, 1.837, 1.633, 1.669, 1.928, 1.862, 1.79, 1.955, 1.829, 1.855, 1.679, 1.559, 1.71, 1.614, 1.684, 1.709, 1.762, 1.924, 2.123, 1.946, 2.072, 1.776, 1.806, 1.869, 1.588, 1.604, 1.577, 1.621, 1.71, 1.621, 1.697, 1.736, 1.7, 1.612, 1.532, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.912, 1.758, 1.593, 1.701, 1.794, 1.759, 1.762, 1.788, 1.8, 1.863, 1.719, 1.753, 1.692, 1.682, 1.908, 1.842, 1.964, 1.876, 1.972, 1.892, 1.888, 1.939, 1.997, 1.865, 1.987, 1.987, 1.818, 1.785, 1.718, 1.827, 1.845, 2.092, 1.846, 1.858, 1.734, 1.649, 1.597, 1.7, 1.841, 1.615, 1.958, 1.996, 2.121, 1.983, 2.212, 1.852, 1.915, 1.889, 1.638, 1.602, 1.662, 1.654, 1.757, 1.698, 1.83, 1.729, 1.794, 1.622, 1.579, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.762, 1.995, 1.884, 1.655, 1.567, 1.56, 1.591, 1.675, 1.723, 1.819, 1.694, 1.803, 1.648, 1.533, null] 
        }]
    })
    $('#nucapsirmw_Sea_WaterVapor_StdDev_49hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 49 hPa Level Statistics, Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 35.03, 35.775, 23.277, 30.968, 34.356, 38.026, 40.687, 15.997, 44.955, 32.278, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 16.365, 17.139, 16.405, 22.617, 4.323, 7.173, 36.645, 11.246, 15.57, 23.445, 9.703, 9.632, 6.836, 8.274, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 16.868, 16.245, 20.123, 18.316, 17.383, 5.041, 19.613, 18.104, 22.943, 17.564, 10.704, 6.737, 13.902, 11.124, 14.354, 7.083, 14.907, 32.033, 12.659, 12.064, 20.3, 31.121, 16.879, 13.576, 13.947, 20.188, 20.63, 35.958, 51.086, 16.545, 54.622, 48.249, 29.645, 25.356, 27.406, 15.633, 21.159, 44.893, 23.397, 39.291, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 34.804, 17.807, 21.432, 21.331, 37.163, 23.831, 26.466, 20.222, 48.807, 29.148, 31.3, 28.033, 25.38, 21.586, 26.563, 24.616, 40.631, 38.856, 39.803, 53.77, 56.479, 50.395, 37.084, 24.866, 26.531, 27.427, 39.964, 50.108, 0.048, 28.372, 53.306, 48.576, 14.29, 38.806, 42.263, 40.128, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 24.132, 45.221, 36.811, 48.314, 27.844, 45.987, 59.044, 34.771, 11.868, 32.87, 11.846, 32.367, 14.863, 28.76, 27.462, 38.834, 23.536, 60.169, 42.465, 24.756, 29.971, 41.643, 26.364, 39.166, 29.693, 47.108, 38.192, 55.214, 50.859, 44.39, 39.681, 62.624, 51.781, 46.793, 46.557, 50.77, 53.545, 55.661, 46.939, 55.214, 67.348, 52.697, 26.124, 65.325, 52.343, 43.58, 29.217, 39.963, 27.316, 42.847, 0.0, 0.048, 64.884, 28.292, 67.004, 2.096, 48.395, 37.132, 15.585, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 41.382, 17.331, 30.802, 33.46, 49.193, 43.338, 0.0, 58.204, 75.266, 69.99, 2.011, 53.677, 38.346, 42.718, null] 
        }]
    })
    $('#nucapsirmw_Sea_Temperature_RMS_49hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 49 hPa Level Statistics, Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 2.112, 1.877, 1.685, 1.742, 1.821, 1.828, 1.835, 1.915, 1.742, 1.871, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 2.039, 1.886, 1.746, 1.783, 1.66, 1.765, 1.996, 1.811, 1.793, 1.835, 1.725, 1.716, 1.601, 1.669, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 2.042, 1.824, 1.659, 1.785, 1.811, 1.856, 1.755, 1.792, 1.734, 1.86, 1.74, 1.819, 1.692, 1.536, 1.808, 1.748, 1.952, 1.969, 1.928, 2.015, 1.884, 2.185, 2.351, 1.815, 2.185, 2.116, 1.717, 1.812, 1.948, 1.942, 1.943, 2.119, 1.887, 1.855, 2.003, 1.651, 1.727, 1.685, 1.743, 1.749, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.57, 2.043, 1.838, 1.634, 1.689, 1.928, 1.867, 1.791, 1.966, 1.829, 1.895, 1.685, 1.559, 1.723, 1.614, 1.684, 1.712, 1.804, 2.02, 2.206, 2.036, 2.147, 1.777, 1.806, 1.869, 1.64, 1.631, 1.614, 1.643, 1.719, 1.623, 1.698, 1.74, 1.702, 1.671, 1.533, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.936, 1.759, 1.629, 1.771, 1.91, 1.882, 1.881, 1.96, 2.031, 2.051, 1.767, 1.85, 1.693, 1.692, 1.969, 1.886, 2.048, 2.05, 2.131, 2.044, 2.011, 2.019, 1.997, 1.866, 2.04, 2.011, 1.879, 1.959, 1.82, 1.913, 1.91, 2.145, 1.934, 2.107, 1.83, 1.651, 1.622, 1.732, 1.931, 1.779, 1.964, 2.03, 2.122, 2.02, 2.262, 1.973, 1.977, 1.894, 1.642, 1.619, 1.682, 1.704, 1.828, 1.837, 1.9, 1.817, 1.927, 1.929, 1.658, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.771, 1.999, 1.902, 1.711, 1.576, 1.565, 1.592, 1.685, 1.733, 1.834, 1.707, 1.825, 1.754, 1.542, null] 
        }]
    })
    $('#nucapsirmw_Sea_WaterVapor_RMS_49hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 49 hPa Level Statistics, Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 79.018, 81.497, 93.515, 88.8, 87.49, 86.139, 84.827, 94.897, 81.369, 91.621, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 93.727, 93.661, 93.446, 93.869, 99.347, 98.674, 81.868, 97.437, 95.846, 90.309, 97.469, 97.385, 98.628, 97.127, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 92.403, 93.968, 91.199, 93.897, 94.911, 99.395, 94.535, 94.877, 91.329, 95.916, 97.641, 98.157, 95.305, 96.367, 95.895, 98.523, 95.102, 85.248, 97.361, 96.833, 93.561, 86.33, 94.258, 96.681, 94.923, 92.93, 93.803, 86.446, 79.386, 96.691, 73.661, 81.858, 89.446, 89.82, 89.584, 96.782, 93.54, 75.675, 91.649, 84.097, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 80.802, 94.115, 93.447, 92.722, 88.483, 93.806, 92.223, 97.261, 76.639, 91.169, 86.711, 88.673, 91.807, 93.238, 89.539, 90.594, 86.197, 87.461, 91.456, 73.808, 77.924, 73.571, 82.048, 91.919, 91.96, 91.523, 84.119, 79.997, 100.0, 96.145, 91.299, 92.188, 99.143, 88.268, 69.063, 73.232, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 91.399, 78.132, 85.229, 70.033, 92.271, 84.727, 70.571, 87.326, 97.612, 88.717, 97.544, 86.108, 96.285, 88.675, 94.121, 89.03, 96.606, 76.05, 84.476, 95.686, 92.112, 85.221, 90.395, 79.061, 88.84, 76.802, 91.5, 84.051, 81.871, 90.427, 88.382, 75.48, 65.733, 75.781, 70.854, 78.721, 68.271, 67.099, 86.112, 83.59, 75.849, 82.356, 95.646, 73.15, 71.365, 77.85, 90.085, 79.541, 91.06, 80.018, 100.0, 100.0, 82.005, 97.027, 75.637, 99.861, 78.992, 83.852, 97.662, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 82.896, 96.023, 90.918, 89.258, 63.314, 89.109, 100.0, 85.992, 87.708, 79.029, 99.865, 72.905, 81.486, 70.91, null] 
        }]
    })
    $('#nucapsirmw_Land_Temperature_Bias_49hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 49 hPa Level Statistics, Land, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: -5.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 0.222, 0.139, 0.162, 0.182, 0.183, 0.278, 0.33, 0.249, -0.024, -0.133, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 0.388, 0.206, 0.208, 0.149, 0.169, 0.487, 0.472, 0.283, 0.017, -0.118, 0.082, 0.291, 0.245, 0.133, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 0.119, 0.038, 0.069, 0.056, 0.09, 0.261, 0.366, 0.263, -0.055, -0.235, -0.183, -0.017, 0.073, 0.029, -0.072, 0.01, 0.019, -0.082, -0.277, -0.297, -0.351, -0.295, -0.24, -0.135, 0.017, 0.084, 0.067, 0.149, 0.351, 0.233, 0.096, 0.178, 0.0, -0.039, -0.069, -0.05, 0.062, 0.044, 0.049, 0.148, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.082, 0.071, 0.095, 0.007, 0.031, 0.251, 0.095, -0.042, -0.028, -0.185, -0.095, -0.025, -0.026, 0.082, 0.069, 0.063, 0.078, 0.05, 0.099, 0.176, 0.146, -0.061, 0.075, 0.238, 0.25, 0.479, 0.405, 0.308, 0.262, 0.458, 0.2, -0.001, -0.127, -0.033, -0.07, -0.045, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, -0.316, -0.461, -0.5, -0.505, -0.477, -0.385, -0.298, -0.422, -0.574, -0.625, -0.518, -0.299, -0.265, -0.35, -0.416, -0.408, -0.437, -0.488, -0.626, -0.645, -0.683, -0.582, -0.548, -0.412, -0.417, -0.375, -0.418, -0.378, -0.316, -0.414, -0.478, -0.409, -0.54, -0.458, -0.473, -0.389, -0.347, -0.395, -0.411, -0.4, -0.462, -0.38, -0.232, -0.233, -0.411, -0.467, -0.422, -0.233, -0.116, -0.209, -0.323, -0.482, -0.232, -0.394, -0.506, -0.558, -0.44, -0.553, -0.524, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -0.095, -0.027, 0.151, 0.228, 0.126, 0.023, -0.109, 0.243, 0.035, -0.093, -0.202, -0.067, -0.181, -0.239, null] 
        }]
    })
    $('#nucapsirmw_Land_WaterVapor_Bias_49hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 49 hPa Level Statistics, Land, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 50.0,
          min: -50.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, -86.367, -82.465, -80.27, -66.306, -83.031, -86.156, -84.061, -69.261, -81.726, -84.49, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, -88.157, -83.096, -79.258, -63.235, -82.702, -86.698, -83.06, -69.046, -81.894, -86.311, -89.224, -90.278, -88.225, -86.378, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, -89.342, -85.582, -81.498, -67.164, -81.244, -80.825, -76.415, -65.176, -82.118, -86.457, -89.691, -91.1, -89.726, -87.222, -82.972, -80.565, -76.579, -72.64, -72.567, -75.699, -84.892, -85.675, -88.905, -89.997, -88.503, -83.216, -76.66, -70.679, -78.777, -75.366, -86.077, -76.515, -74.603, -77.472, -81.612, -86.511, -85.375, -81.831, -75.469, -66.185, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -88.035, -87.513, -81.226, -72.964, -68.188, -77.692, -74.187, -85.122, -77.057, -74.337, -78.961, -83.094, -85.818, -84.358, -81.142, -73.667, -61.636, -67.397, -79.025, -72.743, -80.082, -68.28, -77.375, -83.758, -108.338, -106.152, -75.542, -59.919, -57.606, -70.079, -69.127, -70.42, -87.211, -73.936, -72.699, -76.451, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, -85.995, -82.57, -79.908, -65.863, -82.91, -85.422, -83.259, -70.06, -82.051, -84.504, -85.859, -87.383, -86.708, -82.454, -77.251, -76.672, -78.028, -79.115, -79.322, -80.906, -86.627, -81.885, -84.671, -85.636, -85.087, -79.894, -72.477, -73.428, -80.728, -75.515, -85.998, -78.648, -74.773, -77.528, -80.129, -83.172, -81.988, -79.133, -72.804, -66.324, -71.718, -77.811, -75.078, -79.008, -69.149, -75.515, -85.045, -81.753, -103.95, -72.401, -62.461, -63.173, -72.248, -70.2, -71.741, -85.002, -74.191, -70.051, -74.626, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -77.154, -80.618, -104.359, -103.678, -72.401, -63.316, -63.826, -72.915, -70.128, -72.225, -85.781, -75.021, -70.773, -73.073, null] 
        }]
    })
    $('#nucapsirmw_Land_Temperature_StdDev_49hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 49 hPa Level Statistics, Land, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.411, 1.405, 1.556, 1.613, 1.765, 2.017, 1.748, 1.751, 1.616, 1.54, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 1.396, 1.403, 1.569, 1.636, 1.826, 2.067, 1.797, 1.843, 1.653, 1.532, 1.396, 1.378, 1.326, 1.322, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 1.398, 1.407, 1.569, 1.628, 1.792, 2.127, 1.88, 1.861, 1.661, 1.513, 1.396, 1.358, 1.31, 1.362, 1.446, 1.597, 1.853, 1.712, 1.719, 1.77, 1.709, 1.477, 1.419, 1.451, 1.47, 1.485, 1.481, 1.694, 1.832, 1.824, 1.958, 1.984, 1.755, 1.626, 1.607, 1.492, 1.488, 1.459, 1.557, 1.722, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.446, 1.437, 1.433, 1.468, 1.68, 1.773, 1.787, 1.855, 1.906, 1.662, 1.517, 1.427, 1.416, 1.392, 1.373, 1.481, 1.661, 1.779, 1.849, 1.817, 1.823, 1.612, 1.523, 1.468, 1.415, 1.352, 1.375, 1.397, 1.629, 1.701, 1.81, 1.804, 1.941, 1.657, 1.554, 1.437, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.418, 1.414, 1.57, 1.616, 1.762, 2.021, 1.74, 1.727, 1.608, 1.547, 1.416, 1.382, 1.357, 1.385, 1.485, 1.591, 1.859, 1.698, 1.696, 1.812, 1.694, 1.498, 1.48, 1.479, 1.493, 1.46, 1.465, 1.635, 1.717, 1.796, 1.819, 1.764, 1.611, 1.523, 1.469, 1.464, 1.445, 1.433, 1.561, 1.652, 1.767, 1.802, 1.78, 1.818, 1.661, 1.594, 1.556, 1.491, 1.411, 1.415, 1.441, 1.647, 1.695, 1.799, 1.78, 1.875, 1.615, 1.553, 1.496, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.56, 1.544, 1.473, 1.384, 1.392, 1.404, 1.632, 1.68, 1.743, 1.753, 1.855, 1.622, 1.522, 1.467, null] 
        }]
    })
    $('#nucapsirmw_Land_WaterVapor_StdDev_49hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 49 hPa Level Statistics, Land, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 5.853, 7.629, 8.298, 14.815, 4.293, 2.908, 5.202, 13.244, 7.558, 6.856, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 5.415, 7.546, 8.844, 16.244, 4.876, 3.302, 5.454, 13.679, 7.743, 6.292, 5.288, 4.734, 5.591, 6.399, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 4.859, 6.511, 7.928, 14.58, 5.909, 4.895, 8.134, 15.068, 7.745, 6.244, 4.967, 4.246, 4.832, 5.8, 7.351, 6.985, 7.787, 9.796, 8.257, 8.553, 5.727, 6.315, 4.772, 4.255, 5.158, 6.566, 9.597, 10.008, 6.549, 6.748, 3.42, 8.1, 11.444, 9.636, 7.807, 6.12, 6.618, 8.013, 10.252, 12.989, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 5.717, 5.596, 7.566, 10.838, 11.346, 7.499, 6.783, 3.736, 6.648, 11.417, 9.155, 7.308, 6.408, 7.077, 8.282, 11.018, 14.997, 8.279, 4.568, 7.77, 6.342, 14.223, 9.714, 6.995, 0.0, 0.0, 10.385, 16.626, 16.004, 11.094, 6.24, 9.624, 0.758, 8.629, 12.101, 9.813, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 6.012, 7.536, 8.411, 15.073, 3.748, 3.108, 5.761, 12.645, 7.311, 6.82, 6.383, 5.646, 5.975, 7.674, 9.639, 8.504, 6.223, 7.321, 8.409, 6.873, 5.015, 7.684, 6.214, 5.852, 6.315, 7.769, 10.953, 9.622, 6.347, 6.929, 3.201, 6.543, 10.494, 9.318, 8.309, 7.338, 7.836, 8.977, 11.035, 13.627, 6.362, 5.67, 7.085, 6.651, 12.85, 10.066, 0.496, 7.612, 0.0, 11.353, 14.663, 13.515, 10.031, 6.449, 9.066, 0.906, 7.768, 12.355, 9.69, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 9.359, 8.112, 0.0, 0.0, 11.562, 14.466, 13.135, 9.462, 9.899, 8.83, 2.491, 7.184, 11.985, 12.132, null] 
        }]
    })
    $('#nucapsirmw_Land_Temperature_RMS_49hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 49 hPa Level Statistics, Land, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.428, 1.412, 1.565, 1.623, 1.775, 2.036, 1.779, 1.769, 1.616, 1.545, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 1.449, 1.418, 1.583, 1.643, 1.834, 2.123, 1.858, 1.865, 1.653, 1.536, 1.398, 1.409, 1.349, 1.329, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 1.403, 1.407, 1.57, 1.629, 1.795, 2.143, 1.916, 1.879, 1.662, 1.531, 1.408, 1.358, 1.312, 1.362, 1.448, 1.597, 1.853, 1.714, 1.741, 1.795, 1.745, 1.507, 1.439, 1.457, 1.47, 1.487, 1.483, 1.7, 1.865, 1.839, 1.96, 1.992, 1.755, 1.627, 1.609, 1.493, 1.49, 1.46, 1.558, 1.729, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.449, 1.439, 1.436, 1.468, 1.68, 1.791, 1.789, 1.856, 1.906, 1.672, 1.52, 1.427, 1.416, 1.395, 1.375, 1.483, 1.663, 1.779, 1.851, 1.826, 1.829, 1.613, 1.525, 1.487, 1.436, 1.435, 1.434, 1.431, 1.65, 1.762, 1.821, 1.804, 1.946, 1.657, 1.556, 1.437, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.453, 1.487, 1.648, 1.693, 1.826, 2.058, 1.765, 1.778, 1.707, 1.669, 1.508, 1.414, 1.382, 1.429, 1.542, 1.643, 1.91, 1.767, 1.808, 1.924, 1.826, 1.607, 1.579, 1.535, 1.55, 1.508, 1.524, 1.678, 1.746, 1.843, 1.881, 1.811, 1.7, 1.591, 1.544, 1.515, 1.486, 1.486, 1.614, 1.7, 1.827, 1.842, 1.796, 1.833, 1.711, 1.662, 1.612, 1.509, 1.416, 1.431, 1.477, 1.716, 1.711, 1.842, 1.851, 1.957, 1.674, 1.649, 1.585, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.563, 1.544, 1.481, 1.402, 1.398, 1.405, 1.635, 1.697, 1.744, 1.756, 1.866, 1.623, 1.533, 1.487, null] 
        }]
    })
    $('#nucapsirmw_Land_WaterVapor_RMS_49hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 49 hPa Level Statistics, Land, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 96.635, 95.433, 95.688, 92.147, 98.866, 99.268, 98.181, 93.407, 96.259, 96.146, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 97.422, 95.825, 95.991, 91.555, 98.685, 99.115, 98.244, 93.433, 96.317, 96.564, 97.345, 97.524, 96.975, 96.319, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 97.657, 96.474, 96.462, 92.36, 98.297, 98.933, 97.483, 93.467, 96.295, 96.739, 97.449, 97.773, 97.333, 96.785, 96.599, 97.576, 97.619, 96.85, 97.908, 97.179, 97.733, 96.836, 97.787, 98.25, 97.556, 97.414, 96.144, 97.084, 98.251, 98.336, 99.277, 97.641, 94.737, 95.777, 96.59, 96.853, 96.612, 96.071, 95.88, 95.395, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 97.195, 97.375, 96.887, 95.873, 96.546, 97.909, 98.536, 99.25, 98.471, 94.98, 95.822, 96.562, 96.779, 96.39, 95.881, 95.611, 94.59, 98.4, 99.244, 98.425, 98.419, 93.994, 95.972, 97.024, 100.0, 100.0, 95.406, 93.672, 95.02, 96.769, 99.084, 97.689, 99.914, 97.566, 94.559, 95.996, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 96.486, 95.45, 95.626, 91.922, 99.16, 99.238, 97.795, 93.854, 96.362, 96.156, 95.873, 96.455, 96.45, 96.067, 95.612, 97.038, 98.426, 97.663, 96.761, 97.708, 98.095, 96.24, 96.976, 97.018, 96.706, 96.594, 95.415, 96.672, 97.992, 98.335, 99.315, 98.19, 95.458, 95.722, 95.87, 95.862, 95.756, 95.458, 95.355, 94.645, 98.824, 98.796, 98.324, 98.073, 94.52, 95.407, 99.982, 96.025, 100.0, 94.954, 94.579, 95.618, 96.666, 98.887, 97.52, 99.893, 97.809, 94.429, 96.071, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 95.897, 96.162, 100.0, 100.0, 94.968, 94.758, 95.987, 97.068, 97.232, 97.603, 99.462, 98.101, 94.79, 93.767, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_Temperature_Bias_49hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 49 hPa Level Statistics, Land and Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: -5.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 0.231, 0.175, 0.169, 0.185, 0.154, 0.222, 0.288, 0.207, -0.058, -0.164, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 0.384, 0.239, 0.196, 0.155, 0.142, 0.388, 0.417, 0.245, -0.021, -0.098, 0.095, 0.276, 0.239, 0.14, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 0.14, 0.084, 0.081, 0.067, 0.062, 0.19, 0.336, 0.242, -0.069, -0.223, -0.159, -0.022, 0.076, 0.061, -0.039, 0.007, -0.013, -0.09, -0.268, -0.28, -0.309, -0.242, -0.164, -0.11, 0.012, 0.109, 0.096, 0.113, 0.296, 0.213, 0.082, 0.202, 0.032, -0.073, -0.041, -0.005, 0.092, 0.072, 0.088, 0.17, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.041, 0.035, 0.08, 0.024, -0.002, 0.209, 0.073, -0.046, -0.013, -0.168, -0.15, -0.043, -0.017, 0.061, 0.064, 0.059, 0.075, 0.101, 0.158, 0.222, 0.174, 0.002, 0.071, 0.196, 0.213, 0.437, 0.391, 0.311, 0.279, 0.42, 0.184, 0.005, -0.127, -0.064, -0.13, -0.055, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, -0.302, -0.42, -0.489, -0.5, -0.498, -0.439, -0.342, -0.457, -0.621, -0.645, -0.516, -0.305, -0.257, -0.325, -0.428, -0.428, -0.459, -0.484, -0.624, -0.651, -0.662, -0.543, -0.436, -0.361, -0.44, -0.359, -0.396, -0.41, -0.338, -0.408, -0.489, -0.424, -0.542, -0.522, -0.468, -0.351, -0.333, -0.384, -0.423, -0.443, -0.423, -0.345, -0.233, -0.253, -0.393, -0.485, -0.448, -0.239, -0.126, -0.207, -0.318, -0.455, -0.271, -0.413, -0.502, -0.561, -0.474, -0.597, -0.524, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -0.095, -0.034, 0.154, 0.218, 0.135, 0.041, -0.082, 0.19, -0.001, -0.103, -0.209, -0.091, -0.214, -0.224, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_WaterVapor_Bias_49hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 49 hPa Level Statistics, Land and Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 50.0,
          min: -50.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, -85.406, -81.316, -79.142, -65.386, -82.7, -85.495, -82.782, -68.405, -80.528, -83.382, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, -87.182, -81.813, -77.978, -62.065, -82.586, -86.0, -81.759, -67.747, -80.694, -85.186, -88.459, -89.477, -87.513, -85.814, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, -88.505, -84.489, -80.513, -66.44, -81.612, -82.276, -76.102, -64.475, -80.915, -85.333, -89.078, -90.357, -88.976, -86.38, -82.05, -79.727, -75.685, -71.985, -71.86, -77.129, -84.405, -84.586, -87.95, -88.915, -87.064, -81.083, -74.755, -68.574, -76.583, -74.569, -84.611, -74.243, -71.815, -74.983, -78.943, -84.733, -83.401, -79.409, -72.575, -61.783, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -86.25, -85.891, -79.077, -70.991, -65.739, -75.522, -74.578, -84.125, -75.334, -72.09, -77.099, -81.252, -84.037, -82.311, -78.93, -70.772, -57.849, -64.351, -76.713, -69.792, -77.432, -65.373, -74.537, -110.829, -111.323, -108.333, -72.092, -55.49, -107.354, -66.812, -65.894, -66.676, -85.057, -71.194, -69.763, -73.857, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, -85.06, -81.316, -78.86, -64.931, -82.47, -84.844, -82.006, -68.799, -80.844, -83.389, -85.251, -86.398, -85.531, -81.012, -75.511, -74.927, -75.74, -76.257, -77.065, -79.606, -85.649, -80.733, -83.412, -84.244, -83.632, -77.621, -70.439, -70.774, -78.415, -73.773, -84.751, -77.277, -72.813, -75.788, -78.303, -81.26, -80.034, -77.01, -69.893, -62.809, -68.346, -74.812, -72.072, -76.46, -66.221, -72.637, -119.584, -78.744, -105.267, -68.819, -104.742, -104.311, -68.613, -65.697, -68.195, -83.097, -111.704, -111.704, -72.685, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -74.143, -78.511, -105.71, -104.889, -68.697, -104.36, -104.0, -69.246, -66.646, -68.468, -84.09, -111.272, -67.941, -70.577, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_Temperature_StdDev_49hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 49 hPa Level Statistics, Land and Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.489, 1.462, 1.574, 1.641, 1.778, 2.023, 1.787, 1.774, 1.652, 1.572, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 1.462, 1.443, 1.575, 1.648, 1.822, 2.058, 1.838, 1.838, 1.668, 1.558, 1.422, 1.406, 1.35, 1.351, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 1.458, 1.458, 1.575, 1.634, 1.791, 2.103, 1.898, 1.852, 1.677, 1.547, 1.416, 1.389, 1.345, 1.393, 1.493, 1.62, 1.862, 1.745, 1.739, 1.833, 1.751, 1.563, 1.556, 1.485, 1.576, 1.556, 1.514, 1.715, 1.853, 1.829, 1.93, 1.967, 1.77, 1.647, 1.641, 1.509, 1.53, 1.486, 1.616, 1.741, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.451, 1.534, 1.471, 1.491, 1.688, 1.792, 1.789, 1.846, 1.896, 1.674, 1.548, 1.455, 1.434, 1.427, 1.405, 1.514, 1.686, 1.818, 1.859, 1.841, 1.855, 1.679, 1.57, 1.527, 1.508, 1.408, 1.409, 1.429, 1.62, 1.713, 1.79, 1.791, 1.916, 1.658, 1.567, 1.445, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.492, 1.473, 1.582, 1.64, 1.777, 2.023, 1.785, 1.743, 1.644, 1.589, 1.446, 1.42, 1.398, 1.429, 1.532, 1.632, 1.881, 1.735, 1.741, 1.849, 1.743, 1.597, 1.621, 1.531, 1.603, 1.552, 1.507, 1.668, 1.745, 1.801, 1.828, 1.79, 1.639, 1.567, 1.502, 1.495, 1.485, 1.47, 1.603, 1.699, 1.813, 1.836, 1.82, 1.848, 1.738, 1.649, 1.632, 1.606, 1.483, 1.453, 1.485, 1.643, 1.715, 1.786, 1.781, 1.863, 1.642, 1.578, 1.519, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.6, 1.622, 1.573, 1.46, 1.432, 1.455, 1.626, 1.702, 1.739, 1.75, 1.842, 1.637, 1.556, 1.513, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_WaterVapor_StdDev_49hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 49 hPa Level Statistics, Land and Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 6.028, 7.998, 8.652, 15.01, 4.117, 2.862, 5.431, 13.112, 7.78, 7.176, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 5.701, 7.979, 9.246, 16.466, 4.584, 3.264, 5.746, 13.912, 7.972, 6.649, 5.473, 4.944, 5.743, 6.435, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 4.971, 6.889, 8.189, 14.597, 5.332, 4.435, 8.239, 15.309, 7.945, 6.598, 5.103, 4.455, 5.046, 6.045, 7.553, 7.179, 8.091, 9.701, 8.449, 7.314, 5.522, 6.19, 5.043, 4.578, 5.579, 7.285, 10.165, 10.824, 6.725, 6.14, 3.697, 8.591, 12.389, 10.507, 8.587, 6.692, 7.255, 8.867, 11.125, 14.582, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 6.367, 6.094, 8.236, 11.504, 12.262, 7.74, 6.09, 3.869, 7.034, 12.126, 9.785, 7.892, 6.95, 7.765, 9.051, 12.035, 16.297, 9.148, 5.021, 8.502, 6.989, 15.237, 10.664, 0.048, 0.048, 0.0, 11.533, 18.06, 0.048, 11.859, 6.863, 10.416, 0.828, 9.099, 13.1, 10.545, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 6.156, 7.962, 8.742, 15.279, 3.73, 3.047, 6.003, 12.958, 7.57, 7.159, 6.506, 5.93, 6.346, 8.135, 10.126, 8.905, 6.868, 8.102, 8.837, 6.984, 5.109, 7.421, 6.548, 6.275, 6.67, 8.519, 11.631, 10.461, 6.882, 7.382, 3.373, 6.899, 11.0, 9.717, 8.846, 7.9, 8.388, 9.543, 12.046, 14.646, 6.997, 6.275, 7.809, 7.268, 13.841, 11.016, 0.069, 8.496, 0.0, 12.286, 0.048, 0.048, 10.943, 7.36, 9.089, 0.967, 0.048, 0.069, 10.056, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 10.343, 6.809, 0.0, 0.0, 12.504, 0.0, 0.048, 10.422, 10.401, 9.53, 2.384, 0.048, 12.831, 12.865, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_Temperature_RMS_49hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 49 hPa Level Statistics, Land and Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.507, 1.473, 1.583, 1.651, 1.784, 2.036, 1.81, 1.786, 1.653, 1.581, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 1.512, 1.463, 1.587, 1.655, 1.828, 2.094, 1.885, 1.854, 1.668, 1.561, 1.425, 1.433, 1.371, 1.358, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 1.464, 1.46, 1.577, 1.635, 1.792, 2.111, 1.927, 1.867, 1.679, 1.563, 1.425, 1.389, 1.347, 1.395, 1.493, 1.62, 1.862, 1.748, 1.759, 1.854, 1.778, 1.581, 1.564, 1.49, 1.576, 1.56, 1.517, 1.719, 1.876, 1.841, 1.931, 1.977, 1.77, 1.649, 1.642, 1.509, 1.533, 1.488, 1.618, 1.75, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.452, 1.534, 1.473, 1.492, 1.688, 1.804, 1.791, 1.846, 1.896, 1.682, 1.556, 1.455, 1.434, 1.428, 1.406, 1.515, 1.688, 1.821, 1.865, 1.854, 1.864, 1.679, 1.571, 1.539, 1.523, 1.474, 1.463, 1.463, 1.644, 1.764, 1.799, 1.791, 1.921, 1.659, 1.573, 1.446, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.523, 1.532, 1.656, 1.715, 1.846, 2.07, 1.818, 1.802, 1.758, 1.715, 1.535, 1.453, 1.422, 1.465, 1.591, 1.687, 1.937, 1.801, 1.85, 1.961, 1.865, 1.687, 1.679, 1.573, 1.663, 1.593, 1.558, 1.718, 1.777, 1.847, 1.892, 1.839, 1.727, 1.652, 1.574, 1.535, 1.522, 1.519, 1.657, 1.756, 1.862, 1.868, 1.835, 1.865, 1.782, 1.719, 1.692, 1.624, 1.488, 1.467, 1.519, 1.704, 1.737, 1.833, 1.85, 1.946, 1.709, 1.688, 1.607, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.603, 1.623, 1.581, 1.476, 1.438, 1.456, 1.628, 1.713, 1.739, 1.753, 1.854, 1.64, 1.57, 1.53, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_WaterVapor_RMS_49hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 49 hPa Level Statistics, Land and Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 96.753, 95.378, 95.614, 92.344, 98.97, 99.244, 98.168, 93.91, 96.342, 96.15, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 97.389, 95.725, 95.88, 91.846, 98.856, 99.121, 98.201, 93.62, 96.406, 96.534, 97.401, 97.523, 97.009, 96.524, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 97.773, 96.374, 96.409, 92.766, 98.598, 99.046, 97.436, 93.426, 96.413, 96.704, 97.504, 97.754, 97.309, 96.777, 96.635, 97.575, 97.517, 96.986, 97.861, 97.828, 97.975, 97.376, 97.762, 98.179, 97.536, 97.236, 96.098, 96.885, 98.389, 98.733, 99.244, 97.638, 94.593, 95.536, 96.479, 96.801, 96.544, 95.936, 95.837, 95.128, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 97.081, 97.346, 96.762, 95.725, 96.314, 98.021, 98.844, 99.238, 98.442, 94.923, 95.683, 96.484, 96.769, 96.302, 95.78, 95.411, 94.429, 98.267, 99.198, 98.334, 98.339, 93.815, 95.786, 100.0, 100.0, 100.0, 95.244, 93.544, 100.0, 96.809, 99.034, 97.688, 99.909, 97.614, 94.379, 95.951, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 96.647, 95.374, 95.56, 92.138, 99.175, 99.207, 97.768, 93.903, 96.406, 96.122, 96.04, 96.447, 96.465, 96.057, 95.661, 97.066, 98.297, 97.582, 96.914, 97.835, 98.176, 96.899, 96.927, 96.926, 96.773, 96.438, 95.318, 96.541, 97.966, 98.28, 99.304, 98.15, 95.494, 95.797, 95.82, 95.875, 95.784, 95.589, 95.149, 94.652, 98.766, 98.736, 98.225, 97.976, 94.296, 95.199, 100.0, 95.933, 100.0, 95.061, 100.0, 100.0, 96.634, 98.794, 97.903, 99.886, 100.0, 100.0, 96.157, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 95.706, 97.886, 100.0, 100.0, 95.138, 100.0, 100.0, 97.008, 97.426, 97.667, 99.515, 100.0, 94.714, 93.777, null] 
        }]
    })
    $('#nucapsirmw_Sea_Temperature_Bias_99hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 99 hPa Level Statistics, Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: -5.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, -0.176, 0.399, 0.378, 0.536, 0.155, -0.302, -0.395, -0.43, -0.595, -0.489, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, -0.23, 0.162, 0.273, 0.46, -0.268, -0.63, -0.756, -0.414, -0.409, -0.592, -0.249, 0.352, -0.161, 0.185, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, -0.485, 0.096, 0.207, 0.361, -0.184, -0.854, -0.774, -0.486, -0.371, -0.613, -0.141, 0.488, 0.156, 0.083, 0.549, 0.154, -0.156, 0.04, 0.576, 0.187, -0.077, -0.485, -0.139, 0.206, -0.048, 0.2, 0.903, 0.211, 0.076, -0.354, -0.689, -1.029, -0.5, -0.596, -0.184, -0.115, 0.035, 0.089, -0.112, -0.209, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.665, 0.415, 0.471, 1.212, 0.846, 0.523, 0.384, 0.091, -0.322, 0.229, 0.036, 0.388, 0.414, 0.599, 0.67, 0.552, 0.128, -0.258, -0.562, -1.066, -1.031, -0.745, -0.635, -0.098, 0.318, 0.305, 0.37, 0.502, 0.126, -0.1, -0.156, 0.168, 0.073, 0.014, 0.052, 0.127, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, -0.018, 0.412, 0.643, 0.77, 0.427, 0.056, -0.094, 0.071, -0.002, -0.077, 0.312, 0.483, 0.037, 0.287, 0.731, 0.446, 0.16, 0.385, 0.8, 0.418, 0.378, 0.028, -0.11, 0.514, 0.487, 0.579, 1.253, 0.737, 0.533, 0.632, 0.146, -0.178, 0.294, 0.173, 0.218, 0.804, 0.436, 0.519, 0.647, 0.204, -0.069, -0.027, -0.752, -0.614, -0.534, -0.569, -0.059, 0.25, 0.366, 0.283, 0.612, 0.307, 0.068, 0.184, 0.308, 0.418, 0.153, 0.071, -0.054, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -0.745, -0.196, 0.182, 0.18, 0.2, 0.323, -0.004, -0.173, -0.1, -0.035, 0.084, -0.135, 0.116, 0.028, null] 
        }]
    })
    $('#nucapsirmw_Sea_WaterVapor_Bias_99hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 99 hPa Level Statistics, Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 50.0,
          min: -50.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 35.759, 30.883, 48.735, 60.776, 68.636, 70.877, 104.517, 4.729, 58.619, 31.219, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, -13.516, 2.884, -11.524, 46.386, -43.19, -34.949, 16.164, -18.292, 6.099, 14.798, -47.183, -24.933, -34.699, -41.602, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, -6.011, 3.232, -7.425, 7.352, -0.947, -19.419, 37.165, 47.892, 12.518, -6.691, -18.319, -43.279, -9.7, -32.23, -18.988, -31.45, -10.253, 30.123, -25.458, -21.34, 18.369, 13.488, -13.793, -12.287, -15.107, -7.344, -5.163, 26.045, 73.001, -6.284, 87.211, 59.644, 32.999, 34.787, -11.97, 4.375, -4.369, 28.866, -5.651, 20.255, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 72.867, -1.566, -2.716, -6.033, 43.994, 28.414, 22.471, 43.222, 75.461, 54.426, 34.034, 25.235, -10.271, 5.597, -1.84, -0.714, 23.948, 13.211, 25.681, 80.657, 51.3, 60.317, 37.224, 2.687, 16.284, 16.291, 16.342, 31.3, 47.221, 38.808, 40.598, 50.988, 1.29, 34.93, 36.068, 26.615, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 23.633, 47.179, 56.173, 80.163, 38.936, 71.463, 84.971, 50.823, -12.26, 47.079, -16.309, 31.124, 0.212, 20.828, 8.079, 59.012, 39.159, 97.372, 92.737, 74.999, 59.833, 86.526, 19.11, 56.204, 59.886, 54.121, 44.365, 89.968, 84.73, 81.473, 99.262, 71.885, 66.199, 66.913, 41.861, 48.613, 39.879, 36.612, 28.924, 32.314, 38.843, 27.044, -27.95, 47.549, 45.346, 54.423, -100.256, 34.93, 31.452, 30.139, 42.703, 50.701, 74.824, 47.542, 56.822, 44.377, 51.063, 35.139, -65.321, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 53.24, 10.717, 29.88, 39.025, 27.432, 38.102, 60.826, 76.163, 70.857, 64.188, 67.56, 46.762, 33.726, 41.621, null] 
        }]
    })
    $('#nucapsirmw_Sea_Temperature_StdDev_99hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 99 hPa Level Statistics, Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 2.363, 1.842, 1.894, 1.974, 2.154, 2.117, 2.019, 1.69, 1.806, 1.678, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 2.342, 1.956, 1.949, 1.959, 1.88, 1.958, 2.029, 1.913, 1.815, 1.716, 1.987, 2.092, 2.044, 1.764, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 2.203, 1.82, 1.859, 1.864, 1.831, 1.803, 2.048, 1.811, 1.797, 1.669, 1.88, 1.983, 1.914, 1.834, 1.86, 1.75, 1.895, 1.997, 1.782, 1.848, 1.685, 1.909, 1.902, 1.897, 2.284, 2.386, 2.08, 2.029, 2.131, 2.539, 2.144, 2.018, 1.977, 1.991, 2.09, 2.354, 2.091, 2.09, 2.095, 1.956, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.956, 2.25, 2.238, 2.054, 2.15, 2.054, 2.183, 1.878, 1.898, 1.695, 1.719, 1.699, 1.971, 2.018, 1.748, 1.808, 1.705, 1.625, 1.918, 1.897, 1.771, 1.621, 1.722, 1.768, 1.968, 1.899, 1.841, 1.562, 1.579, 1.843, 1.898, 1.85, 1.615, 1.597, 1.517, 1.713, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 2.394, 1.75, 1.83, 1.893, 2.028, 1.984, 2.111, 1.838, 1.57, 1.777, 1.888, 2.122, 2.158, 1.786, 1.819, 1.76, 1.912, 2.008, 1.907, 1.742, 1.669, 1.696, 1.913, 1.989, 2.164, 2.268, 1.823, 1.82, 1.934, 2.258, 1.865, 1.844, 1.711, 1.619, 1.662, 2.055, 1.879, 1.722, 1.483, 1.693, 1.564, 1.577, 1.794, 1.658, 1.56, 1.767, 1.794, 1.925, 1.968, 1.791, 1.67, 1.663, 1.826, 1.988, 1.847, 1.68, 1.577, 1.537, 1.784, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.815, 1.767, 1.877, 1.946, 1.818, 1.629, 1.664, 1.813, 1.946, 1.821, 1.582, 1.587, 1.403, 1.601, null] 
        }]
    })
    $('#nucapsirmw_Sea_WaterVapor_StdDev_99hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 99 hPa Level Statistics, Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 60.932, 66.541, 72.305, 79.23, 81.843, 81.091, 97.811, 36.64, 70.74, 39.196, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 31.798, 44.265, 31.631, 65.738, 8.719, 8.748, 34.639, 13.614, 36.915, 51.43, 16.357, 22.854, 14.313, 21.163, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 41.428, 49.185, 36.211, 40.657, 27.212, 10.823, 51.704, 70.312, 40.107, 27.028, 23.529, 17.151, 36.831, 26.227, 25.231, 16.291, 27.816, 40.339, 12.608, 16.73, 35.394, 42.781, 34.92, 30.384, 33.383, 38.398, 29.572, 56.536, 69.563, 23.411, 90.466, 82.094, 56.308, 56.438, 25.421, 39.2, 40.98, 65.105, 45.901, 62.144, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 87.481, 32.728, 38.17, 36.03, 69.049, 51.889, 47.956, 41.613, 90.407, 73.843, 56.159, 62.269, 33.488, 47.867, 45.324, 41.618, 62.87, 44.46, 50.712, 88.928, 73.08, 80.979, 64.673, 42.523, 54.846, 55.729, 50.725, 65.893, 53.865, 53.749, 63.104, 67.169, 14.929, 64.607, 70.288, 67.659, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 59.49, 62.245, 67.602, 73.714, 33.185, 84.194, 80.523, 53.057, 22.236, 69.459, 20.074, 62.8, 36.54, 60.046, 32.03, 76.074, 29.351, 96.313, 99.407, 80.406, 75.902, 86.826, 50.634, 68.412, 72.11, 74.199, 43.69, 59.728, 91.818, 85.56, 84.422, 70.004, 70.731, 63.303, 57.18, 59.164, 40.375, 57.03, 41.573, 53.682, 67.798, 50.063, 11.128, 61.937, 60.071, 70.539, 0.0, 65.982, 68.335, 61.183, 60.779, 72.291, 70.118, 67.871, 73.589, 67.39, 65.759, 69.044, 2.005, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 73.953, 38.91, 62.698, 59.296, 58.755, 68.3, 63.788, 73.862, 85.494, 80.782, 81.478, 66.551, 68.433, 67.298, null] 
        }]
    })
    $('#nucapsirmw_Sea_Temperature_RMS_99hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 99 hPa Level Statistics, Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 2.369, 1.885, 1.931, 2.046, 2.159, 2.138, 2.058, 1.744, 1.902, 1.748, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 2.354, 1.963, 1.968, 2.013, 1.899, 2.057, 2.165, 1.958, 1.86, 1.816, 2.002, 2.121, 2.05, 1.774, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 2.256, 1.823, 1.87, 1.898, 1.84, 1.995, 2.189, 1.876, 1.835, 1.778, 1.886, 2.042, 1.92, 1.836, 1.94, 1.757, 1.902, 1.998, 1.873, 1.857, 1.687, 1.969, 1.907, 1.908, 2.284, 2.394, 2.268, 2.04, 2.132, 2.563, 2.252, 2.265, 2.039, 2.079, 2.098, 2.357, 2.091, 2.092, 2.098, 1.968, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 2.066, 2.288, 2.287, 2.385, 2.31, 2.12, 2.217, 1.88, 1.925, 1.711, 1.72, 1.743, 2.014, 2.105, 1.872, 1.89, 1.71, 1.646, 1.999, 2.176, 2.049, 1.784, 1.836, 1.77, 1.994, 1.924, 1.878, 1.641, 1.584, 1.846, 1.904, 1.857, 1.617, 1.597, 1.518, 1.718, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 2.394, 1.797, 1.94, 2.043, 2.073, 1.985, 2.113, 1.84, 1.57, 1.779, 1.914, 2.176, 2.158, 1.809, 1.961, 1.816, 1.918, 2.045, 2.068, 1.791, 1.711, 1.697, 1.916, 2.054, 2.219, 2.341, 2.212, 1.964, 2.006, 2.345, 1.87, 1.853, 1.736, 1.629, 1.677, 2.207, 1.929, 1.798, 1.619, 1.705, 1.566, 1.577, 1.945, 1.768, 1.649, 1.856, 1.795, 1.941, 2.002, 1.813, 1.779, 1.691, 1.828, 1.996, 1.872, 1.731, 1.585, 1.539, 1.785, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.962, 1.778, 1.886, 1.954, 1.829, 1.661, 1.664, 1.821, 1.948, 1.822, 1.585, 1.593, 1.408, 1.601, null] 
        }]
    })
    $('#nucapsirmw_Sea_WaterVapor_RMS_99hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 99 hPa Level Statistics, Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 61.093, 75.581, 72.396, 85.956, 81.85, 81.715, 101.481, 91.237, 91.221, 95.867, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 93.145, 88.086, 91.841, 87.96, 98.975, 98.91, 94.108, 98.549, 92.828, 87.087, 96.758, 95.888, 98.075, 93.721, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 89.492, 85.608, 91.552, 91.794, 96.525, 99.205, 92.304, 87.477, 93.268, 95.53, 96.331, 96.409, 89.61, 92.738, 95.347, 97.863, 95.068, 96.094, 98.969, 97.741, 95.189, 91.612, 90.853, 95.01, 92.408, 89.776, 94.633, 87.928, 81.904, 96.842, 96.609, 89.919, 90.406, 91.363, 96.756, 92.598, 90.863, 67.976, 85.087, 70.922, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 90.121, 95.136, 91.688, 91.164, 86.647, 90.907, 92.414, 97.269, 93.759, 89.844, 91.835, 83.172, 93.403, 87.219, 86.985, 90.444, 80.391, 91.806, 92.691, 91.473, 90.314, 80.979, 89.317, 91.715, 88.289, 86.333, 89.236, 79.695, 95.694, 94.315, 90.264, 92.577, 99.339, 86.583, 72.975, 76.963, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 81.786, 63.592, 69.47, 84.745, 96.974, 85.156, 95.834, 93.163, 96.252, 84.264, 97.032, 85.059, 93.098, 79.211, 95.429, 76.381, 97.782, 100.663, 101.192, 95.023, 88.353, 92.195, 87.839, 70.588, 72.978, 74.337, 95.836, 93.812, 91.818, 88.143, 100.512, 80.612, 76.888, 75.738, 58.72, 64.414, 50.015, 57.551, 44.862, 54.398, 85.203, 90.94, 98.687, 65.706, 61.975, 72.059, 100.0, 66.117, 71.97, 61.496, 62.085, 72.303, 81.522, 88.076, 74.08, 87.068, 67.477, 79.227, 99.91, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 74.201, 93.806, 87.587, 60.887, 86.926, 69.001, 71.422, 83.733, 85.604, 80.858, 82.182, 66.985, 78.515, 67.598, null] 
        }]
    })
    $('#nucapsirmw_Land_Temperature_Bias_99hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 99 hPa Level Statistics, Land, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: -5.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, -0.621, -0.369, -0.301, -0.333, -0.185, -0.421, -0.557, -0.528, -0.395, -0.402, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, -0.709, -0.229, -0.048, -0.144, -0.067, -0.391, -0.495, -0.352, -0.371, -0.495, -0.545, -0.47, -0.311, 0.091, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, -0.448, -0.031, 0.0, -0.116, -0.079, -0.465, -0.626, -0.454, -0.276, -0.376, -0.296, -0.171, -0.038, 0.174, 0.398, 0.211, -0.143, 0.022, 0.275, -0.099, -0.171, -0.408, -0.305, -0.186, -0.29, -0.042, 0.063, -0.258, -0.367, -0.379, -0.51, -0.581, -0.449, -0.451, -0.431, -0.265, -0.296, 0.053, -0.067, -0.012, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -0.171, -0.128, 0.122, 0.213, 0.041, -0.115, -0.186, -0.296, -0.221, -0.001, -0.106, -0.224, 0.056, -0.026, 0.331, 0.208, 0.231, -0.058, -0.104, -0.341, -0.228, -0.23, -0.45, -0.376, -0.172, -0.168, 0.106, 0.16, -0.095, -0.326, -0.302, -0.005, 0.086, 0.017, -0.092, -0.049, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, -0.405, -0.047, 0.067, 0.077, 0.094, -0.274, -0.316, -0.187, -0.134, -0.195, -0.17, -0.156, -0.078, 0.051, 0.341, 0.2, -0.135, 0.074, 0.272, 0.02, 0.085, -0.212, -0.08, -0.01, -0.089, 0.067, 0.223, 0.082, 0.005, -0.111, -0.201, -0.134, -0.055, -0.139, -0.147, -0.023, -0.114, 0.176, 0.138, 0.216, -0.002, -0.113, -0.358, -0.25, -0.284, -0.338, -0.144, -0.159, -0.188, 0.068, 0.267, 0.126, -0.117, -0.12, 0.106, 0.242, 0.032, -0.088, -0.094, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -0.377, -0.111, -0.174, -0.208, 0.011, 0.142, 0.041, -0.118, -0.066, 0.113, 0.256, 0.033, 0.016, 0.031, null] 
        }]
    })
    $('#nucapsirmw_Land_WaterVapor_Bias_99hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 99 hPa Level Statistics, Land, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 50.0,
          min: -50.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, -78.178, -75.914, -75.066, -66.359, -75.726, -75.111, -83.468, -72.74, -77.498, -79.906, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, -78.755, -74.923, -71.313, -61.667, -73.36, -75.033, -82.193, -71.374, -75.837, -80.625, -81.089, -80.081, -79.029, -78.8, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, -80.607, -78.004, -73.986, -64.906, -72.271, -65.905, -76.942, -65.385, -75.561, -80.234, -81.143, -81.056, -81.414, -80.282, -75.762, -73.579, -71.764, -66.371, -67.287, -60.799, -74.507, -81.051, -81.377, -80.984, -78.862, -70.688, -65.341, -60.512, -66.071, -57.49, -71.273, -68.349, -70.041, -67.27, -67.509, -73.863, -72.457, -68.075, -62.424, -55.362, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -76.998, -77.324, -67.517, -59.802, -57.579, -65.781, -54.069, -69.308, -67.583, -69.436, -70.242, -72.662, -72.923, -71.25, -67.864, -60.212, -51.716, -51.301, -65.101, -59.7, -73.867, -63.623, -69.062, -74.129, -73.35, -108.21, -63.928, -47.213, -47.798, -60.687, -102.855, -89.368, -105.821, -64.071, -62.419, -60.41, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, -77.613, -76.154, -74.516, -66.313, -75.058, -74.506, -83.292, -73.695, -77.833, -80.177, -78.362, -75.696, -76.317, -72.205, -68.554, -69.263, -73.098, -72.06, -72.96, -67.486, -74.568, -76.887, -76.036, -74.879, -75.41, -67.865, -63.207, -68.123, -73.531, -61.444, -72.409, -72.334, -72.39, -70.536, -70.362, -70.148, -68.773, -66.167, -62.733, -62.747, -62.69, -69.076, -66.362, -75.419, -67.992, -69.384, -71.16, -70.373, -110.646, -61.736, -55.195, -59.467, -67.26, -107.205, -88.348, -107.538, -67.387, -62.767, -61.069, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -70.045, -71.318, -70.555, -109.89, -61.469, -55.071, -58.881, -66.692, -103.136, -88.672, -107.537, -67.725, -62.492, -60.823, null] 
        }]
    })
    $('#nucapsirmw_Land_Temperature_StdDev_99hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 99 hPa Level Statistics, Land, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.606, 1.481, 1.573, 1.649, 1.73, 1.837, 1.71, 1.719, 1.67, 1.633, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 1.614, 1.471, 1.585, 1.611, 1.734, 1.898, 1.776, 1.796, 1.672, 1.659, 1.645, 1.607, 1.53, 1.483, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 1.579, 1.443, 1.552, 1.62, 1.735, 1.914, 1.818, 1.786, 1.665, 1.644, 1.612, 1.538, 1.51, 1.479, 1.539, 1.653, 1.82, 1.677, 1.656, 1.708, 1.701, 1.704, 1.628, 1.61, 1.633, 1.648, 1.639, 1.766, 1.902, 1.941, 1.945, 1.996, 1.979, 1.926, 1.973, 1.875, 1.834, 1.771, 1.767, 1.845, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.561, 1.567, 1.627, 1.633, 1.679, 1.69, 1.728, 1.703, 1.684, 1.627, 1.57, 1.573, 1.622, 1.602, 1.541, 1.586, 1.645, 1.656, 1.641, 1.68, 1.698, 1.67, 1.685, 1.569, 1.543, 1.549, 1.59, 1.56, 1.644, 1.722, 1.741, 1.681, 1.718, 1.741, 1.64, 1.645, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.59, 1.463, 1.555, 1.598, 1.668, 1.711, 1.63, 1.672, 1.597, 1.562, 1.588, 1.552, 1.556, 1.536, 1.528, 1.602, 1.75, 1.591, 1.591, 1.655, 1.627, 1.618, 1.623, 1.609, 1.553, 1.606, 1.578, 1.647, 1.62, 1.674, 1.654, 1.611, 1.623, 1.545, 1.587, 1.613, 1.623, 1.53, 1.607, 1.642, 1.666, 1.625, 1.657, 1.688, 1.701, 1.682, 1.641, 1.606, 1.624, 1.631, 1.56, 1.614, 1.701, 1.735, 1.683, 1.722, 1.741, 1.66, 1.714, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.737, 1.608, 1.581, 1.591, 1.564, 1.507, 1.592, 1.68, 1.702, 1.635, 1.701, 1.705, 1.612, 1.574, null] 
        }]
    })
    $('#nucapsirmw_Land_WaterVapor_StdDev_99hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 99 hPa Level Statistics, Land, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 9.874, 10.741, 10.968, 14.663, 8.108, 8.002, 6.853, 11.701, 9.79, 9.033, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 10.084, 11.369, 12.768, 16.551, 10.107, 8.302, 7.491, 12.536, 10.805, 9.053, 9.411, 9.852, 10.092, 10.011, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 9.254, 10.229, 11.715, 15.26, 10.737, 11.522, 9.296, 14.589, 10.898, 9.383, 9.238, 9.232, 9.016, 9.028, 11.161, 11.473, 11.151, 13.258, 10.927, 15.358, 11.176, 8.633, 8.346, 8.168, 9.717, 11.847, 14.846, 15.29, 12.886, 15.947, 10.791, 13.145, 13.341, 14.328, 14.053, 12.288, 12.656, 14.539, 16.319, 19.013, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 11.383, 10.417, 13.397, 16.991, 17.018, 13.423, 18.13, 11.753, 13.579, 13.667, 13.071, 12.634, 12.616, 13.315, 14.665, 17.354, 20.431, 18.955, 12.115, 15.529, 8.116, 15.548, 13.448, 11.614, 12.157, 0.0, 15.653, 22.148, 21.85, 16.528, 0.048, 0.124, 0.048, 14.213, 16.615, 17.09, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 10.085, 10.598, 11.152, 14.65, 8.337, 8.044, 6.89, 11.161, 9.58, 8.868, 10.088, 11.351, 11.025, 12.268, 13.813, 13.079, 9.819, 10.904, 11.241, 13.327, 11.062, 10.079, 10.281, 10.507, 10.713, 12.689, 15.254, 12.89, 10.236, 14.984, 10.168, 11.287, 11.727, 12.649, 13.145, 13.436, 14.065, 15.072, 15.721, 16.057, 14.687, 10.255, 12.028, 7.715, 13.148, 12.575, 12.413, 12.9, 0.048, 15.954, 18.253, 16.677, 13.816, 0.0, 0.161, 0.048, 11.717, 15.663, 16.042, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 12.329, 12.45, 12.962, 0.0, 16.287, 18.431, 16.802, 13.816, 0.048, 0.154, 0.0, 11.298, 16.158, 17.804, null] 
        }]
    })
    $('#nucapsirmw_Land_Temperature_RMS_99hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 99 hPa Level Statistics, Land, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.722, 1.527, 1.602, 1.683, 1.74, 1.885, 1.799, 1.798, 1.716, 1.682, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 1.764, 1.489, 1.585, 1.618, 1.735, 1.938, 1.844, 1.831, 1.713, 1.732, 1.733, 1.675, 1.561, 1.486, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 1.641, 1.443, 1.552, 1.624, 1.737, 1.969, 1.923, 1.843, 1.688, 1.687, 1.639, 1.548, 1.511, 1.49, 1.59, 1.667, 1.826, 1.677, 1.678, 1.711, 1.71, 1.753, 1.656, 1.62, 1.659, 1.649, 1.64, 1.785, 1.937, 1.977, 2.011, 2.079, 2.029, 1.979, 2.02, 1.894, 1.858, 1.772, 1.769, 1.845, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.57, 1.572, 1.631, 1.647, 1.679, 1.694, 1.738, 1.728, 1.699, 1.627, 1.574, 1.589, 1.623, 1.602, 1.577, 1.6, 1.661, 1.657, 1.645, 1.714, 1.714, 1.686, 1.744, 1.614, 1.552, 1.558, 1.594, 1.568, 1.647, 1.753, 1.767, 1.681, 1.72, 1.741, 1.642, 1.646, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.641, 1.464, 1.556, 1.6, 1.67, 1.733, 1.661, 1.682, 1.602, 1.575, 1.597, 1.559, 1.558, 1.537, 1.566, 1.615, 1.755, 1.593, 1.614, 1.655, 1.629, 1.632, 1.625, 1.609, 1.555, 1.608, 1.594, 1.649, 1.62, 1.678, 1.666, 1.617, 1.624, 1.551, 1.594, 1.613, 1.627, 1.54, 1.613, 1.657, 1.666, 1.629, 1.695, 1.706, 1.725, 1.716, 1.647, 1.614, 1.635, 1.633, 1.582, 1.619, 1.705, 1.739, 1.686, 1.739, 1.741, 1.663, 1.716, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.777, 1.612, 1.591, 1.605, 1.564, 1.514, 1.593, 1.684, 1.704, 1.639, 1.72, 1.706, 1.612, 1.574, null] 
        }]
    })
    $('#nucapsirmw_Land_WaterVapor_RMS_99hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 99 hPa Level Statistics, Land, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 95.539, 95.076, 94.886, 92.952, 97.123, 97.314, 96.209, 93.901, 94.757, 95.171, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 95.964, 95.068, 94.668, 92.458, 96.166, 97.285, 96.17, 93.902, 94.655, 95.446, 95.986, 95.517, 95.405, 95.826, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 96.348, 95.68, 95.308, 93.147, 96.114, 96.753, 96.222, 93.944, 94.822, 95.311, 95.938, 95.791, 95.948, 96.247, 95.199, 95.167, 95.815, 95.278, 96.846, 94.647, 94.927, 95.863, 96.556, 97.038, 96.193, 96.074, 94.423, 95.025, 95.679, 94.597, 96.249, 94.825, 94.017, 94.314, 94.643, 94.71, 94.985, 94.321, 94.1, 92.599, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 95.387, 96.043, 95.469, 93.837, 94.113, 95.348, 93.778, 96.056, 94.486, 93.908, 94.705, 94.575, 94.785, 94.597, 93.965, 93.666, 91.905, 93.973, 96.531, 95.189, 97.944, 94.175, 95.267, 95.594, 95.483, 100.0, 94.392, 92.557, 92.334, 94.042, 100.0, 99.998, 100.0, 95.11, 93.606, 93.997, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 95.337, 95.042, 94.787, 92.847, 97.085, 97.441, 96.136, 94.201, 94.761, 95.23, 94.812, 94.267, 94.844, 95.041, 94.053, 94.311, 96.454, 95.696, 94.901, 94.388, 94.611, 95.261, 95.34, 95.623, 95.491, 95.461, 93.957, 94.645, 95.734, 94.414, 96.114, 94.832, 94.526, 94.427, 93.999, 93.969, 94.02, 93.865, 93.838, 92.933, 94.422, 96.822, 95.827, 97.568, 94.41, 94.989, 94.579, 94.396, 100.0, 94.369, 93.612, 93.529, 93.894, 100.0, 99.998, 100.0, 95.815, 93.499, 94.017, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 95.303, 94.918, 94.801, 100.0, 94.433, 93.703, 93.804, 94.214, 100.0, 99.998, 100.0, 96.161, 93.282, 92.509, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_Temperature_Bias_99hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 99 hPa Level Statistics, Land and Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: -5.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, -0.549, -0.297, -0.207, -0.209, -0.132, -0.35, -0.501, -0.509, -0.364, -0.357, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, -0.643, -0.191, 0.009, -0.064, -0.066, -0.39, -0.483, -0.365, -0.34, -0.489, -0.52, -0.38, -0.256, 0.084, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, -0.413, -0.012, 0.047, -0.049, -0.089, -0.469, -0.616, -0.463, -0.271, -0.392, -0.292, -0.107, -0.007, 0.163, 0.399, 0.207, -0.165, -0.005, 0.29, -0.092, -0.176, -0.41, -0.29, -0.134, -0.23, -0.053, 0.172, -0.167, -0.303, -0.335, -0.496, -0.589, -0.439, -0.469, -0.381, -0.223, -0.263, 0.058, -0.089, -0.084, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -0.059, -0.049, 0.146, 0.331, 0.155, -0.037, -0.11, -0.256, -0.176, 0.06, -0.069, -0.14, 0.107, 0.05, 0.359, 0.231, 0.222, -0.085, -0.166, -0.443, -0.322, -0.301, -0.469, -0.364, -0.084, -0.092, 0.134, 0.212, -0.043, -0.268, -0.242, 0.023, 0.103, 0.03, -0.035, -0.034, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, -0.335, -0.003, 0.152, 0.179, 0.136, -0.189, -0.254, -0.176, -0.088, -0.156, -0.144, -0.075, -0.051, 0.03, 0.349, 0.217, -0.116, 0.081, 0.321, 0.065, 0.105, -0.186, -0.091, 0.041, -0.033, 0.055, 0.349, 0.185, 0.088, 0.0, -0.131, -0.07, 0.013, -0.111, -0.09, 0.049, -0.034, 0.203, 0.182, 0.214, -0.029, -0.147, -0.432, -0.311, -0.327, -0.377, -0.169, -0.091, -0.114, 0.103, 0.316, 0.184, -0.054, -0.047, 0.139, 0.272, 0.04, -0.036, -0.088, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -0.431, -0.158, -0.119, -0.151, 0.036, 0.173, 0.084, -0.092, -0.044, 0.102, 0.243, 0.026, 0.041, 0.029, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_WaterVapor_Bias_99hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 99 hPa Level Statistics, Land and Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 50.0,
          min: -50.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, -75.96, -73.566, -72.584, -62.806, -74.572, -74.02, -81.511, -69.944, -75.085, -77.637, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, -76.676, -72.596, -69.011, -58.519, -72.917, -73.911, -80.071, -68.519, -73.284, -78.516, -79.551, -78.023, -77.234, -77.23, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, -78.632, -75.855, -72.105, -62.329, -72.333, -68.214, -74.922, -62.417, -73.113, -78.137, -79.846, -79.114, -79.583, -78.367, -73.85, -71.405, -69.971, -65.152, -65.457, -60.526, -73.25, -79.108, -79.489, -78.649, -75.852, -67.05, -62.349, -57.035, -62.767, -55.845, -69.101, -64.871, -65.708, -62.174, -62.318, -70.423, -68.563, -64.167, -58.792, -50.182, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -73.331, -74.042, -63.699, -56.67, -53.923, -62.826, -53.757, -67.674, -64.751, -65.989, -66.533, -69.171, -69.629, -67.364, -64.328, -56.521, -47.009, -48.063, -62.187, -56.034, -70.914, -59.425, -64.178, -110.142, -68.268, -111.074, -58.784, -42.023, -42.287, -56.288, -103.586, -87.206, -107.461, -59.692, -57.292, -108.951, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, -75.482, -73.738, -72.086, -62.782, -73.693, -73.56, -81.387, -70.781, -75.493, -77.975, -76.856, -73.156, -73.771, -69.548, -65.967, -66.618, -70.276, -69.068, -70.118, -65.338, -72.606, -74.207, -73.319, -71.709, -72.185, -63.974, -59.992, -64.59, -70.576, -59.098, -70.295, -70.468, -69.196, -66.807, -66.789, -66.554, -65.002, -62.768, -59.471, -58.843, -58.95, -65.839, -62.612, -72.962, -64.028, -64.183, -113.168, -64.745, -106.293, -56.373, -50.16, -54.703, -62.845, -109.336, -86.009, -109.734, -64.072, -57.508, -106.244, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -64.628, -103.263, -64.673, -105.913, -55.934, -50.133, -53.568, -62.192, -104.0, -86.338, -109.762, -64.172, -57.356, -103.996, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_Temperature_StdDev_99hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 99 hPa Level Statistics, Land and Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.709, 1.588, 1.69, 1.753, 1.816, 1.923, 1.789, 1.739, 1.68, 1.665, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 1.701, 1.536, 1.64, 1.657, 1.765, 1.914, 1.827, 1.8, 1.68, 1.663, 1.68, 1.702, 1.605, 1.513, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 1.664, 1.504, 1.605, 1.644, 1.756, 1.915, 1.866, 1.776, 1.67, 1.644, 1.637, 1.616, 1.58, 1.525, 1.57, 1.678, 1.83, 1.709, 1.673, 1.724, 1.692, 1.706, 1.661, 1.665, 1.74, 1.778, 1.742, 1.859, 1.979, 2.028, 1.956, 2.016, 1.971, 1.926, 1.994, 1.936, 1.882, 1.818, 1.825, 1.904, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.673, 1.683, 1.719, 1.758, 1.796, 1.796, 1.812, 1.727, 1.718, 1.644, 1.595, 1.599, 1.676, 1.662, 1.584, 1.611, 1.66, 1.66, 1.684, 1.732, 1.746, 1.677, 1.683, 1.581, 1.661, 1.632, 1.664, 1.577, 1.652, 1.743, 1.769, 1.706, 1.712, 1.718, 1.626, 1.66, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.704, 1.555, 1.666, 1.686, 1.767, 1.811, 1.718, 1.693, 1.611, 1.594, 1.637, 1.673, 1.683, 1.615, 1.582, 1.657, 1.787, 1.658, 1.678, 1.681, 1.64, 1.634, 1.681, 1.71, 1.692, 1.77, 1.717, 1.763, 1.746, 1.833, 1.715, 1.675, 1.65, 1.568, 1.612, 1.698, 1.7, 1.589, 1.631, 1.67, 1.679, 1.669, 1.694, 1.718, 1.704, 1.692, 1.672, 1.734, 1.722, 1.697, 1.594, 1.637, 1.755, 1.784, 1.733, 1.725, 1.722, 1.652, 1.734, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.734, 1.645, 1.698, 1.673, 1.633, 1.547, 1.604, 1.71, 1.738, 1.686, 1.698, 1.69, 1.61, 1.59, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_WaterVapor_StdDev_99hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 99 hPa Level Statistics, Land and Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 10.544, 11.446, 11.673, 15.74, 7.494, 7.902, 7.276, 12.38, 10.419, 9.733, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 10.703, 12.108, 13.427, 17.481, 8.805, 8.253, 8.002, 13.308, 11.557, 9.747, 9.549, 10.496, 10.629, 10.387, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 9.868, 10.962, 12.241, 16.021, 8.943, 9.825, 9.715, 15.531, 11.581, 10.071, 9.29, 9.874, 9.642, 9.689, 11.704, 12.069, 11.305, 12.82, 11.241, 14.853, 10.438, 8.779, 8.911, 8.888, 10.633, 13.009, 15.637, 16.259, 13.273, 15.056, 11.331, 13.871, 14.597, 15.977, 15.791, 13.529, 14.005, 15.782, 17.334, 20.565, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 12.653, 11.454, 14.6, 17.922, 18.022, 13.912, 16.359, 12.14, 13.979, 14.594, 14.276, 13.873, 13.764, 14.687, 15.836, 18.448, 21.763, 19.182, 12.739, 15.887, 8.752, 16.792, 14.988, 0.0, 13.832, 0.0, 17.357, 23.681, 23.629, 17.575, 0.0, 0.142, 0.048, 14.868, 18.29, 0.0, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 10.707, 11.36, 11.842, 15.725, 7.909, 7.925, 7.31, 11.951, 10.202, 9.549, 10.257, 12.191, 11.86, 13.122, 14.529, 13.671, 10.328, 11.456, 11.879, 13.587, 11.03, 10.456, 11.074, 11.484, 11.564, 13.871, 16.034, 13.831, 10.928, 14.957, 10.644, 11.33, 12.519, 13.647, 14.317, 14.658, 15.323, 15.962, 16.692, 17.102, 15.379, 10.877, 12.828, 8.209, 14.286, 14.17, 0.048, 14.66, 0.0, 17.407, 19.702, 17.927, 15.016, 0.048, 0.172, 0.048, 7.73, 17.308, 0.069, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 14.0, 0.048, 14.79, 0.0, 17.764, 19.813, 18.414, 15.041, 0.0, 0.169, 0.048, 7.585, 17.716, 0.048, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_Temperature_RMS_99hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 99 hPa Level Statistics, Land and Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.795, 1.615, 1.703, 1.765, 1.82, 1.955, 1.858, 1.812, 1.719, 1.703, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 1.819, 1.548, 1.64, 1.658, 1.766, 1.953, 1.89, 1.837, 1.714, 1.734, 1.759, 1.744, 1.625, 1.515, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 1.714, 1.504, 1.606, 1.645, 1.758, 1.972, 1.965, 1.835, 1.692, 1.691, 1.663, 1.62, 1.58, 1.534, 1.62, 1.691, 1.838, 1.709, 1.698, 1.727, 1.701, 1.755, 1.686, 1.67, 1.755, 1.779, 1.751, 1.866, 2.002, 2.056, 2.018, 2.101, 2.019, 1.982, 2.03, 1.949, 1.901, 1.819, 1.827, 1.906, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.674, 1.684, 1.725, 1.789, 1.803, 1.797, 1.816, 1.746, 1.727, 1.645, 1.596, 1.606, 1.679, 1.663, 1.625, 1.628, 1.674, 1.662, 1.692, 1.788, 1.776, 1.704, 1.747, 1.622, 1.663, 1.634, 1.669, 1.591, 1.652, 1.764, 1.785, 1.706, 1.715, 1.718, 1.626, 1.66, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.737, 1.555, 1.673, 1.695, 1.772, 1.821, 1.736, 1.702, 1.614, 1.602, 1.643, 1.675, 1.684, 1.615, 1.62, 1.671, 1.791, 1.66, 1.708, 1.682, 1.643, 1.645, 1.684, 1.711, 1.693, 1.771, 1.752, 1.773, 1.748, 1.833, 1.72, 1.676, 1.65, 1.572, 1.615, 1.699, 1.7, 1.602, 1.642, 1.683, 1.68, 1.676, 1.749, 1.746, 1.735, 1.734, 1.68, 1.736, 1.726, 1.7, 1.625, 1.648, 1.756, 1.784, 1.739, 1.746, 1.723, 1.652, 1.736, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.787, 1.653, 1.702, 1.68, 1.633, 1.556, 1.606, 1.712, 1.738, 1.689, 1.715, 1.69, 1.61, 1.59, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_WaterVapor_RMS_99hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 99 hPa Level Statistics, Land and Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 95.487, 95.044, 94.876, 92.933, 97.738, 97.499, 96.313, 94.044, 94.845, 95.192, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 95.939, 94.997, 94.599, 92.453, 97.292, 97.453, 96.225, 93.988, 94.662, 95.402, 96.307, 95.484, 95.403, 95.863, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 96.296, 95.595, 95.259, 93.192, 97.458, 97.502, 96.289, 93.844, 94.861, 95.293, 96.29, 95.732, 95.872, 96.142, 95.237, 95.221, 96.064, 95.883, 96.89, 95.121, 96.042, 96.368, 96.503, 96.934, 96.153, 95.882, 94.421, 94.942, 95.935, 95.564, 96.204, 94.985, 94.031, 94.225, 94.48, 94.6, 94.847, 94.283, 94.096, 92.608, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 95.322, 95.987, 95.298, 93.746, 94.062, 95.492, 95.245, 96.044, 94.865, 94.002, 94.651, 94.491, 94.721, 94.475, 93.917, 93.608, 91.985, 94.423, 96.532, 95.552, 97.88, 94.105, 95.168, 100.0, 95.382, 100.0, 94.234, 92.565, 92.265, 94.231, 100.0, 99.998, 100.0, 95.464, 93.498, 100.0, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 95.314, 94.981, 94.761, 92.795, 97.552, 97.579, 96.191, 94.207, 94.837, 95.212, 95.178, 94.234, 94.836, 94.95, 94.061, 94.416, 96.512, 95.8, 95.002, 94.657, 95.256, 95.695, 95.288, 95.514, 95.553, 95.317, 94.042, 94.597, 95.713, 94.867, 96.074, 95.247, 94.623, 94.58, 93.979, 93.903, 93.931, 94.018, 93.753, 92.969, 94.571, 96.795, 95.804, 97.491, 94.291, 94.87, 100.0, 94.315, 100.0, 94.457, 93.591, 93.587, 93.9, 100.0, 99.998, 100.0, 98.561, 93.423, 100.0, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 95.203, 100.0, 94.728, 100.0, 94.572, 93.734, 93.663, 94.204, 100.0, 99.998, 100.0, 98.641, 93.333, 100.0, null] 
        }]
    })
    $('#nucapsirmw_Sea_Temperature_Bias_206hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 206 hPa Level Statistics, Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: -5.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, -0.443, -0.351, -0.181, -0.076, -0.078, 0.402, 0.341, 0.249, 0.277, 0.328, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, -0.176, -0.18, 0.056, 0.259, 0.444, 0.634, 0.469, 0.703, 0.36, 0.23, 0.018, -0.149, -0.344, -0.051, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 0.387, 0.269, 0.256, 0.422, 0.579, 0.989, 0.804, 0.615, 0.616, 0.813, 0.447, 0.426, 0.053, 0.041, 0.199, 0.378, 0.783, 0.691, 0.445, 0.435, 0.387, 0.773, 0.291, 0.231, 0.332, 0.231, 0.183, 0.72, 1.016, 0.707, 1.007, 1.242, 0.921, 0.983, 0.615, 0.627, 0.524, 0.548, 0.588, 0.362, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.007, -0.234, -0.355, -0.252, -0.042, 0.319, 0.246, 0.393, 0.295, 0.169, 0.208, -0.047, -0.256, -0.184, -0.282, -0.082, -0.09, 0.025, 0.465, 0.515, 0.508, 0.502, 0.379, -0.072, -0.267, 0.085, -0.238, -0.045, 0.155, 0.336, 0.348, 0.202, -0.082, 0.129, -0.209, -0.197, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, -0.405, -0.287, -0.227, -0.199, -0.116, 0.427, 0.102, -0.055, -0.109, 0.062, -0.446, -0.398, -0.522, -0.397, -0.216, -0.089, 0.234, 0.327, -0.006, 0.044, -0.103, 0.02, -0.321, -0.32, -0.343, -0.369, -0.147, 0.172, 0.19, 0.247, 0.284, 0.325, 0.136, 0.231, 0.02, -0.145, -0.134, -0.184, -0.302, -0.105, -0.009, 0.306, 0.301, 0.392, 0.185, 0.358, -0.104, -0.244, 0.082, -0.187, -0.226, -0.073, 0.333, 0.151, 0.085, 0.197, 0.178, -0.033, -0.236, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.518, 0.003, -0.217, 0.078, -0.076, -0.054, -0.021, 0.408, 0.28, 0.179, 0.47, 0.323, 0.116, -0.156, null] 
        }]
    })
    $('#nucapsirmw_Sea_WaterVapor_Bias_206hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 206 hPa Level Statistics, Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 50.0,
          min: -50.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 18.278, 16.954, 16.176, 22.144, 23.165, 24.385, 39.032, 32.498, 38.439, 38.095, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 52.589, 51.707, 34.8, 46.242, 38.943, 56.771, 61.382, 49.922, 61.626, 52.587, 37.06, 26.308, 33.488, 32.51, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 45.287, 42.228, 38.072, 54.805, 49.097, 57.635, 70.06, 57.307, 66.213, 58.822, 47.789, 26.244, 34.634, 28.084, 34.424, 38.761, 35.059, 53.29, 41.533, 41.333, 50.481, 36.754, 31.3, 25.314, 27.908, 32.817, 32.549, 33.326, 46.328, 38.521, 35.339, 44.109, 35.729, 33.156, 31.061, 36.401, 34.52, 28.83, 33.497, 33.398, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 24.013, 27.058, 39.353, 24.389, 31.546, 30.726, 34.349, 29.907, 35.307, 34.507, 28.099, 28.109, 20.529, 36.058, 23.611, 29.01, 35.184, 29.558, 29.169, 34.535, 29.281, 30.657, 29.99, 19.049, 23.191, 21.996, 33.151, 39.332, 39.908, 29.901, 32.524, -45.376, 37.284, 37.855, 34.931, 32.102, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 21.209, 17.715, 15.185, 28.147, 23.543, 24.347, 40.873, 40.486, 36.663, 33.425, 23.049, 8.281, 9.457, 10.606, 17.07, 22.266, 16.067, 26.958, 29.568, 29.344, 22.886, 14.001, 16.708, 6.596, 17.688, 21.156, 18.887, 22.942, 30.888, 28.324, 16.385, 20.86, 21.278, 19.496, 16.552, 14.601, 21.968, 9.063, 11.732, 16.517, 23.48, 20.748, 25.572, 15.376, 15.877, 13.239, 2.946, 5.418, 7.374, 16.655, 17.19, 20.681, 15.459, 22.153, 19.561, 20.359, -65.138, 14.215, 14.365, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 17.019, 5.141, 9.288, 12.101, 20.086, 18.423, -57.983, 17.607, 27.151, -63.829, 20.414, 20.4, 14.259, 20.34, null] 
        }]
    })
    $('#nucapsirmw_Sea_Temperature_StdDev_206hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 206 hPa Level Statistics, Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.259, 1.217, 1.265, 1.127, 1.125, 1.563, 1.477, 1.553, 1.39, 1.169, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 1.377, 1.307, 1.415, 1.37, 1.371, 1.663, 1.912, 1.856, 1.647, 1.381, 1.344, 1.387, 1.431, 1.538, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 1.314, 1.348, 1.316, 1.275, 1.223, 1.574, 1.782, 1.599, 1.404, 1.349, 1.362, 1.389, 1.291, 1.352, 1.31, 1.37, 1.489, 1.499, 1.764, 1.361, 1.261, 1.529, 1.503, 1.39, 1.42, 1.426, 1.486, 1.51, 1.798, 2.176, 2.129, 1.892, 2.197, 1.852, 2.102, 2.159, 2.065, 1.854, 2.038, 2.026, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.735, 1.317, 1.251, 1.218, 1.258, 1.47, 1.658, 1.538, 1.47, 1.382, 1.338, 1.239, 1.444, 1.228, 1.298, 1.486, 1.348, 1.601, 1.615, 1.372, 1.424, 1.489, 1.53, 1.527, 1.765, 1.602, 1.543, 1.639, 1.489, 1.595, 1.858, 2.746, 1.7, 1.491, 1.463, 1.603, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.198, 1.314, 1.237, 1.24, 1.105, 1.485, 1.524, 1.491, 1.25, 1.102, 1.111, 1.194, 1.158, 1.271, 1.381, 1.242, 1.512, 1.453, 1.3, 1.275, 1.195, 1.229, 1.33, 1.127, 1.315, 1.148, 1.199, 1.114, 1.292, 1.372, 1.459, 1.276, 1.14, 1.267, 1.091, 1.163, 1.129, 1.179, 1.103, 1.252, 1.469, 1.336, 1.401, 1.418, 1.213, 1.314, 1.483, 1.663, 1.404, 1.52, 1.538, 1.385, 1.494, 1.583, 1.464, 1.557, 1.368, 1.39, 1.373, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.391, 1.457, 1.555, 1.429, 1.354, 1.375, 3.174, 1.407, 1.515, 2.874, 1.46, 1.401, 1.386, 1.369, null] 
        }]
    })
    $('#nucapsirmw_Sea_WaterVapor_StdDev_206hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 206 hPa Level Statistics, Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 44.94, 44.738, 43.114, 46.029, 49.729, 40.367, 55.482, 53.126, 55.81, 59.74, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 61.537, 60.777, 59.644, 58.692, 59.319, 64.129, 66.493, 66.773, 63.91, 62.887, 52.77, 46.475, 55.358, 49.947, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 61.701, 56.244, 57.058, 68.246, 61.668, 66.237, 76.726, 53.989, 67.421, 66.683, 53.926, 45.238, 46.77, 50.333, 60.343, 56.231, 59.699, 65.143, 65.033, 57.234, 59.143, 52.256, 48.97, 47.817, 51.503, 49.739, 54.44, 52.579, 52.327, 60.05, 53.117, 60.043, 54.121, 55.285, 57.07, 60.464, 56.893, 51.106, 56.07, 51.329, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 38.404, 50.339, 52.446, 48.632, 51.061, 49.696, 49.948, 46.499, 48.071, 49.706, 50.254, 42.77, 42.088, 47.943, 46.02, 46.281, 49.11, 51.48, 53.511, 51.112, 45.568, 48.323, 48.815, 43.539, 45.454, 41.522, 45.815, 50.333, 51.063, 44.798, 47.363, 4.87, 50.387, 48.715, 49.124, 48.217, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 46.556, 42.791, 40.418, 49.303, 48.3, 42.857, 51.057, 54.218, 51.444, 57.118, 49.372, 36.925, 38.907, 34.547, 53.015, 48.49, 46.743, 44.293, 50.706, 46.118, 47.253, 41.049, 40.363, 36.212, 40.764, 45.176, 49.466, 48.524, 50.397, 43.498, 43.206, 47.597, 41.255, 45.104, 43.487, 44.546, 40.557, 37.921, 39.821, 41.143, 50.038, 48.263, 56.956, 39.465, 46.359, 41.619, 37.26, 45.928, 37.891, 44.297, 45.668, 44.104, 41.479, 43.877, 42.031, 41.949, 2.517, 44.569, 37.279, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 43.146, 40.243, 41.338, 39.837, 44.867, 43.785, 3.434, 45.248, 46.498, 3.723, 44.391, 42.568, 43.039, 44.685, null] 
        }]
    })
    $('#nucapsirmw_Sea_Temperature_RMS_206hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 206 hPa Level Statistics, Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.335, 1.267, 1.278, 1.13, 1.128, 1.614, 1.516, 1.573, 1.418, 1.215, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 1.389, 1.319, 1.416, 1.394, 1.441, 1.78, 1.969, 1.985, 1.686, 1.4, 1.344, 1.395, 1.472, 1.539, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 1.37, 1.375, 1.34, 1.344, 1.353, 1.859, 1.955, 1.713, 1.534, 1.576, 1.434, 1.453, 1.292, 1.353, 1.325, 1.421, 1.682, 1.651, 1.819, 1.428, 1.319, 1.714, 1.531, 1.41, 1.458, 1.445, 1.497, 1.673, 2.065, 2.288, 2.356, 2.263, 2.383, 2.097, 2.19, 2.248, 2.13, 1.933, 2.122, 2.058, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.735, 1.338, 1.301, 1.244, 1.258, 1.504, 1.676, 1.588, 1.499, 1.393, 1.354, 1.24, 1.467, 1.242, 1.328, 1.488, 1.351, 1.602, 1.681, 1.465, 1.512, 1.572, 1.577, 1.529, 1.785, 1.605, 1.561, 1.64, 1.497, 1.63, 1.891, 2.753, 1.702, 1.497, 1.478, 1.616, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.264, 1.345, 1.258, 1.256, 1.112, 1.545, 1.527, 1.492, 1.255, 1.104, 1.197, 1.259, 1.271, 1.332, 1.398, 1.245, 1.53, 1.49, 1.3, 1.276, 1.2, 1.229, 1.368, 1.172, 1.36, 1.206, 1.208, 1.128, 1.306, 1.394, 1.487, 1.317, 1.148, 1.288, 1.091, 1.172, 1.137, 1.193, 1.144, 1.257, 1.469, 1.37, 1.433, 1.471, 1.227, 1.361, 1.487, 1.681, 1.406, 1.531, 1.555, 1.387, 1.531, 1.59, 1.466, 1.57, 1.38, 1.39, 1.394, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.484, 1.457, 1.57, 1.432, 1.356, 1.376, 3.174, 1.465, 1.54, 2.88, 1.533, 1.438, 1.391, 1.378, null] 
        }]
    })
    $('#nucapsirmw_Sea_WaterVapor_RMS_206hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 206 hPa Level Statistics, Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 45.31, 44.852, 43.246, 46.03, 49.735, 40.399, 56.637, 53.144, 56.053, 59.807, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 63.71, 64.18, 59.81, 60.913, 60.025, 67.603, 72.7, 66.909, 67.869, 66.308, 55.075, 46.48, 55.741, 50.457, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 62.455, 58.126, 58.474, 70.44, 64.312, 69.388, 82.813, 60.937, 72.564, 70.262, 58.027, 45.447, 48.205, 50.334, 60.678, 58.199, 60.253, 68.105, 65.075, 58.735, 62.572, 53.843, 50.057, 47.96, 51.829, 50.843, 54.787, 53.131, 55.699, 61.65, 55.269, 62.907, 54.8, 55.812, 57.576, 61.73, 57.64, 51.463, 57.418, 52.904, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 38.942, 50.34, 54.484, 48.66, 51.418, 49.923, 50.59, 47.274, 50.036, 51.071, 50.523, 43.323, 42.118, 49.411, 46.027, 46.735, 50.718, 51.531, 53.603, 51.475, 46.142, 48.862, 49.442, 43.571, 45.492, 41.738, 47.554, 52.091, 53.178, 45.281, 48.048, 99.657, 51.484, 50.822, 50.794, 49.023, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 46.633, 42.845, 40.519, 49.444, 48.348, 42.962, 54.368, 55.484, 51.922, 57.452, 49.377, 38.019, 39.754, 34.771, 53.373, 48.573, 46.841, 44.577, 50.756, 46.707, 47.256, 41.169, 40.363, 37.755, 40.964, 45.331, 49.952, 48.536, 50.644, 44.035, 43.283, 47.619, 41.301, 45.111, 43.84, 45.42, 40.714, 39.11, 40.556, 41.143, 50.089, 48.277, 57.049, 39.49, 46.629, 42.105, 39.657, 49.064, 38.441, 44.306, 46.094, 44.104, 41.58, 43.881, 42.123, 41.949, 99.922, 44.788, 37.29, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 43.204, 42.288, 42.189, 39.893, 44.869, 44.041, 99.762, 45.248, 46.593, 99.727, 44.391, 42.594, 43.161, 44.691, null] 
        }]
    })
    $('#nucapsirmw_Land_Temperature_Bias_206hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 206 hPa Level Statistics, Land, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: -5.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 0.535, -0.019, -0.171, -0.011, 0.015, 0.274, 0.392, 0.443, 0.37, 0.383, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 0.85, 0.236, 0.037, 0.251, 0.295, 0.584, 0.728, 0.664, 0.658, 0.564, 0.849, 0.734, 0.71, 0.404, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 1.13, 0.426, 0.14, 0.415, 0.467, 0.658, 0.747, 0.612, 0.482, 0.622, 1.133, 1.006, 0.72, 0.197, 0.053, 0.174, 0.582, 0.693, 0.219, 0.144, 0.255, 0.367, 0.833, 0.882, 0.936, 0.299, 0.12, 0.428, 0.677, 0.376, 0.404, 0.419, 0.292, 0.909, 1.119, 1.029, 0.846, 0.507, 0.171, 0.211, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.031, -0.038, -0.202, -0.083, 0.201, 0.579, 0.483, 0.389, 0.197, -0.034, 0.323, 0.35, -0.145, -0.285, -0.253, -0.125, 0.032, 0.264, 0.575, 0.885, 0.647, 0.697, 0.808, 0.755, 0.332, -0.019, 0.08, 0.12, 0.348, 0.531, 0.581, 0.401, 0.173, 0.081, 0.093, -0.138, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 0.479, -0.008, -0.207, -0.133, -0.023, 0.315, 0.307, 0.237, 0.065, 0.018, 0.231, 0.305, 0.25, -0.035, -0.067, -0.094, 0.213, 0.394, 0.064, 0.042, -0.021, -0.05, 0.063, 0.208, 0.344, -0.003, -0.119, 0.043, 0.223, 0.169, 0.287, 0.208, 0.029, 0.422, 0.542, 0.369, 0.251, 0.103, -0.121, -0.166, 0.013, 0.358, 0.47, 0.382, 0.43, 0.532, 0.627, 0.599, 0.35, 0.237, -0.004, -0.105, 0.068, 0.101, 0.09, 0.006, 0.041, 0.088, 0.028, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.556, 0.526, 0.429, 0.163, 0.124, -0.062, -0.073, 0.157, 0.181, 0.141, 0.011, 0.074, 0.061, 0.082, null] 
        }]
    })
    $('#nucapsirmw_Land_WaterVapor_Bias_206hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 206 hPa Level Statistics, Land, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 50.0,
          min: -50.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, -3.981, -3.313, -5.279, -7.243, -9.728, -8.372, -30.352, -19.273, -15.093, -13.706, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 17.069, 18.722, 17.453, 13.586, 5.748, 6.832, -19.188, -2.962, 9.526, 5.634, 6.686, 6.211, 13.651, 4.875, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 16.592, 14.479, 13.989, 10.173, 10.522, 19.196, -3.777, 10.194, 10.531, 9.532, 10.109, 6.968, 11.203, 5.166, 6.442, 1.891, 5.305, 6.836, 1.5, 6.995, 3.435, -7.774, 1.977, -3.146, 7.203, 6.953, 11.438, 16.062, 15.437, 19.647, 8.135, 8.881, 13.598, 18.931, 15.527, 6.654, 8.489, 13.108, 24.018, 28.033, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 5.459, 4.649, 4.717, 7.802, 6.457, 0.508, 6.008, -7.327, -8.821, -3.282, 2.849, 8.587, 1.445, 2.201, 7.351, 19.069, 21.455, 19.57, 12.964, 17.078, 4.246, 14.625, 12.678, 10.24, 6.232, 2.725, 11.609, 20.479, -218.961, 10.935, 13.5, 6.028, 6.903, 7.072, 11.982, 12.006, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, -0.668, -2.203, -3.841, -7.903, -10.297, -8.376, -30.561, -21.53, -14.936, -12.127, -4.918, -5.744, -2.14, -1.779, -1.788, -7.419, -13.393, -17.515, -22.322, -12.473, -14.39, -18.082, -9.117, -10.841, -6.759, -4.998, -4.025, -9.293, -12.611, -5.473, -16.863, -17.325, -13.726, -10.351, -5.076, -7.953, -7.453, -3.313, 4.791, 1.646, -0.462, -5.881, -2.278, -10.138, -5.852, -8.344, -5.128, -7.223, -8.934, 0.338, 3.409, -315.746, -6.063, -3.114, -7.532, -6.163, -8.069, -6.227, -5.305, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -5.678, -0.571, -2.283, -4.538, 2.572, 5.133, -283.742, -6.328, -2.894, -9.517, -6.959, -7.147, -3.387, 1.135, null] 
        }]
    })
    $('#nucapsirmw_Land_Temperature_StdDev_206hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 206 hPa Level Statistics, Land, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.917, 1.741, 1.708, 1.68, 1.838, 1.903, 2.04, 2.028, 1.978, 2.001, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 2.079, 1.894, 1.849, 1.798, 2.021, 2.156, 2.208, 2.288, 2.38, 2.346, 2.152, 1.966, 2.072, 2.022, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 2.068, 1.913, 1.823, 1.78, 1.938, 2.096, 2.217, 2.127, 2.26, 2.324, 2.146, 2.014, 2.045, 1.837, 1.796, 1.878, 1.937, 2.201, 2.309, 2.21, 2.187, 2.134, 2.175, 2.158, 2.141, 1.968, 1.884, 1.967, 2.09, 2.286, 2.377, 2.611, 2.605, 2.649, 2.539, 2.535, 2.409, 2.209, 2.117, 2.147, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 2.037, 2.045, 1.885, 1.773, 1.849, 1.89, 2.026, 2.088, 2.186, 2.195, 2.19, 2.093, 2.135, 2.009, 1.849, 1.787, 1.872, 1.905, 2.031, 2.134, 2.182, 2.272, 2.179, 2.249, 2.146, 2.004, 1.909, 1.854, 1.806, 1.922, 2.056, 2.106, 2.255, 2.184, 2.031, 1.986, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.845, 1.715, 1.688, 1.667, 1.847, 1.896, 2.031, 2.003, 1.968, 1.949, 1.925, 1.823, 1.791, 1.638, 1.63, 1.732, 1.793, 1.957, 2.045, 2.058, 1.915, 1.835, 1.835, 1.81, 1.87, 1.752, 1.656, 1.7, 1.776, 1.901, 1.939, 2.008, 1.962, 1.965, 1.965, 1.923, 1.795, 1.672, 1.658, 1.763, 1.819, 1.889, 1.896, 1.973, 1.972, 1.968, 1.995, 1.913, 1.778, 1.726, 1.675, 1.641, 1.746, 1.827, 1.947, 2.016, 1.881, 1.787, 1.732, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.935, 1.912, 1.837, 1.743, 1.67, 1.656, 1.654, 1.774, 1.869, 2.017, 2.033, 1.87, 1.777, 1.686, null] 
        }]
    })
    $('#nucapsirmw_Land_WaterVapor_StdDev_206hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 206 hPa Level Statistics, Land, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 49.911, 52.695, 55.312, 56.409, 56.323, 56.248, 54.927, 55.654, 54.296, 54.274, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 62.828, 63.68, 68.942, 72.33, 71.992, 74.569, 66.232, 72.245, 73.327, 68.558, 61.049, 60.237, 61.132, 63.235, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 66.893, 64.627, 69.252, 71.346, 71.229, 73.014, 71.621, 72.944, 70.357, 69.705, 64.693, 63.527, 63.164, 65.252, 66.806, 69.163, 72.642, 74.387, 69.749, 69.301, 67.762, 62.492, 60.715, 61.384, 56.469, 58.305, 61.583, 65.927, 68.737, 70.525, 70.454, 72.585, 71.025, 71.617, 67.568, 60.688, 59.492, 59.215, 60.89, 63.754, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 53.631, 55.34, 56.749, 59.91, 62.082, 64.308, 63.666, 63.195, 62.735, 63.145, 62.934, 61.08, 54.466, 52.465, 54.693, 58.236, 60.91, 60.934, 66.548, 67.549, 67.935, 67.829, 63.293, 57.553, 54.274, 56.425, 54.488, 63.193, 0.477, 63.403, 65.23, 67.209, 67.88, 66.124, 61.73, 58.684, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 52.048, 53.401, 55.996, 56.607, 55.931, 56.986, 55.262, 55.051, 54.311, 54.709, 50.579, 49.308, 51.113, 52.793, 54.696, 58.145, 57.162, 57.685, 55.658, 55.211, 55.048, 50.168, 47.98, 48.919, 49.599, 50.113, 52.458, 54.792, 56.392, 55.79, 54.195, 54.13, 53.792, 54.107, 51.67, 49.243, 47.152, 48.718, 50.406, 50.307, 51.541, 52.89, 53.183, 54.128, 54.483, 50.078, 49.261, 48.482, 50.206, 48.616, 54.225, 0.515, 52.798, 53.802, 55.237, 56.415, 55.213, 50.494, 50.166, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 52.089, 51.01, 49.477, 50.496, 49.545, 55.044, 0.505, 55.59, 55.775, 57.358, 59.04, 57.545, 52.711, 50.143, null] 
        }]
    })
    $('#nucapsirmw_Land_Temperature_RMS_206hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 206 hPa Level Statistics, Land, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.99, 1.741, 1.717, 1.68, 1.838, 1.922, 2.077, 2.076, 2.013, 2.038, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 2.246, 1.908, 1.85, 1.816, 2.042, 2.234, 2.325, 2.383, 2.47, 2.413, 2.313, 2.098, 2.19, 2.062, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 2.357, 1.96, 1.829, 1.828, 1.993, 2.197, 2.339, 2.214, 2.311, 2.406, 2.427, 2.252, 2.169, 1.847, 1.797, 1.886, 2.023, 2.308, 2.32, 2.215, 2.202, 2.165, 2.329, 2.331, 2.336, 1.99, 1.888, 2.013, 2.197, 2.317, 2.412, 2.644, 2.621, 2.801, 2.775, 2.736, 2.553, 2.266, 2.124, 2.158, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 2.037, 2.046, 1.896, 1.775, 1.86, 1.977, 2.083, 2.124, 2.195, 2.196, 2.214, 2.122, 2.14, 2.029, 1.867, 1.792, 1.873, 1.923, 2.111, 2.31, 2.276, 2.376, 2.324, 2.372, 2.172, 2.005, 1.91, 1.858, 1.839, 1.994, 2.137, 2.144, 2.261, 2.185, 2.033, 1.991, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.906, 1.715, 1.701, 1.672, 1.847, 1.922, 2.054, 2.017, 1.969, 1.949, 1.939, 1.848, 1.808, 1.638, 1.632, 1.734, 1.806, 1.997, 2.046, 2.058, 1.915, 1.836, 1.836, 1.822, 1.901, 1.752, 1.66, 1.7, 1.79, 1.909, 1.96, 2.018, 1.962, 2.01, 2.038, 1.958, 1.813, 1.675, 1.662, 1.771, 1.819, 1.923, 1.953, 2.01, 2.019, 2.039, 2.091, 2.004, 1.812, 1.743, 1.675, 1.644, 1.747, 1.83, 1.949, 2.016, 1.881, 1.789, 1.732, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 2.013, 1.983, 1.886, 1.751, 1.674, 1.657, 1.656, 1.781, 1.878, 2.022, 2.033, 1.871, 1.778, 1.688, null] 
        }]
    })
    $('#nucapsirmw_Land_WaterVapor_RMS_206hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 206 hPa Level Statistics, Land, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 55.178, 58.62, 62.951, 64.959, 64.569, 62.925, 76.29, 69.76, 64.494, 64.121, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 64.234, 65.22, 71.668, 76.077, 75.852, 78.251, 87.4, 81.502, 76.752, 72.423, 63.117, 63.174, 63.072, 68.072, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 68.013, 66.314, 72.188, 75.305, 73.926, 73.558, 82.604, 76.717, 73.372, 72.966, 66.125, 66.375, 65.155, 69.716, 70.836, 75.491, 75.738, 78.634, 80.104, 73.403, 73.99, 72.15, 65.193, 68.122, 57.408, 61.271, 63.237, 66.691, 69.233, 70.829, 72.909, 76.015, 72.635, 71.925, 68.038, 62.502, 60.726, 59.998, 60.892, 63.895, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 56.404, 57.532, 61.184, 62.748, 64.001, 67.571, 65.573, 70.83, 72.218, 69.593, 66.743, 63.135, 58.786, 56.321, 57.414, 58.384, 60.93, 60.973, 67.587, 68.182, 72.361, 69.13, 65.37, 60.08, 57.052, 60.447, 56.09, 63.689, 100.0, 64.142, 65.909, 70.206, 72.209, 69.683, 63.285, 60.603, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 55.884, 58.309, 62.337, 65.305, 64.157, 63.37, 76.222, 70.184, 64.55, 63.592, 54.7, 55.139, 55.862, 57.73, 59.427, 65.952, 65.779, 68.765, 71.143, 64.234, 66.162, 62.264, 55.169, 56.889, 54.954, 56.327, 58.035, 61.374, 63.688, 59.807, 63.933, 66.371, 64.069, 61.678, 56.333, 54.643, 52.77, 53.022, 52.713, 52.695, 53.802, 58.184, 56.92, 61.877, 60.753, 57.184, 54.111, 54.035, 57.036, 51.908, 57.313, 99.999, 56.36, 57.248, 61.082, 63.621, 62.627, 55.929, 54.785, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 58.244, 55.174, 54.099, 55.953, 52.388, 57.358, 99.999, 58.84, 58.329, 63.433, 65.892, 63.992, 56.766, 53.17, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_Temperature_Bias_206hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 206 hPa Level Statistics, Land and Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: -5.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 0.434, -0.059, -0.195, -0.033, -0.024, 0.222, 0.353, 0.423, 0.35, 0.312, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 0.745, 0.213, 0.047, 0.253, 0.304, 0.569, 0.709, 0.684, 0.653, 0.524, 0.777, 0.648, 0.603, 0.367, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 1.061, 0.429, 0.163, 0.434, 0.495, 0.671, 0.76, 0.646, 0.521, 0.638, 1.055, 0.934, 0.647, 0.198, 0.076, 0.201, 0.623, 0.719, 0.284, 0.208, 0.304, 0.425, 0.792, 0.831, 0.854, 0.301, 0.145, 0.459, 0.715, 0.412, 0.463, 0.508, 0.4, 0.93, 1.026, 0.945, 0.81, 0.481, 0.229, 0.286, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.0, -0.054, -0.218, -0.098, 0.172, 0.556, 0.46, 0.391, 0.206, -0.013, 0.3, 0.292, -0.176, -0.259, -0.251, -0.12, 0.035, 0.239, 0.557, 0.847, 0.634, 0.655, 0.755, 0.638, 0.247, -0.004, 0.033, 0.087, 0.314, 0.503, 0.538, 0.393, 0.131, 0.078, 0.062, -0.154, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 0.381, -0.046, -0.238, -0.152, -0.054, 0.263, 0.25, 0.214, 0.039, -0.016, 0.139, 0.206, 0.144, -0.086, -0.115, -0.11, 0.197, 0.344, 0.044, 0.028, -0.039, -0.06, -0.005, 0.134, 0.241, -0.069, -0.151, 0.022, 0.208, 0.143, 0.268, 0.193, 0.034, 0.382, 0.436, 0.251, 0.184, 0.045, -0.151, -0.166, 0.003, 0.332, 0.463, 0.364, 0.386, 0.483, 0.484, 0.456, 0.287, 0.168, -0.038, -0.128, 0.051, 0.076, 0.085, -0.002, 0.036, 0.064, -0.016, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.544, 0.439, 0.345, 0.155, 0.09, -0.055, -0.07, 0.167, 0.169, 0.16, 0.03, 0.096, 0.073, 0.058, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_WaterVapor_Bias_206hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 206 hPa Level Statistics, Land and Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 50.0,
          min: -50.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, -2.69, -2.229, -3.215, -3.924, -5.733, -3.9, -20.482, -11.984, -8.388, -8.915, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 18.205, 20.457, 18.313, 17.252, 9.981, 12.397, -8.948, 6.075, 17.248, 10.635, 9.361, 8.079, 14.59, 7.373, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 18.006, 16.646, 14.959, 14.283, 13.582, 21.533, 4.868, 16.885, 18.205, 14.527, 12.171, 8.695, 12.536, 6.994, 9.314, 6.887, 9.515, 12.829, 8.419, 12.897, 9.073, -1.797, 5.932, 0.118, 9.501, 10.931, 14.542, 19.222, 18.819, 20.761, 11.341, 15.387, 18.097, 21.163, 17.843, 9.632, 11.416, 14.626, 24.523, 29.545, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 7.325, 6.796, 8.841, 10.608, 10.775, 5.27, 8.757, -2.692, -1.388, 2.329, 6.682, 10.69, 3.781, 5.271, 9.454, 21.062, 23.621, 20.976, 14.764, 20.262, 9.449, 17.547, 15.108, 12.751, 9.518, 6.043, 11.926, 14.117, -344.314, 9.887, 12.423, 2.775, 11.726, 12.5, 16.45, 15.438, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 0.495, -0.646, -2.25, -3.428, -5.291, -3.222, -19.725, -12.697, -7.745, -7.38, -3.479, -4.199, -1.168, -0.263, 0.333, -2.355, -6.673, -8.189, -13.244, -5.623, -7.991, -12.353, -5.346, -8.135, -4.531, -1.511, -1.391, -4.009, -6.465, -1.194, -10.971, -11.119, -9.342, -7.075, -3.519, -6.181, -5.438, -2.322, 5.571, 3.247, 1.68, -2.386, 1.684, -5.284, -2.442, -4.862, -439.538, -4.412, -5.952, 1.016, 0.289, 1814.865, -1.377, 1.836, -16.034, -1.319, -13.704, -2.135, -3.434, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -2.9, 228.301, 0.669, -1.702, 5.193, 7.516, -13756.073, -2.349, -0.209, -21.936, -1.97, -12.426, 0.904, 0.316, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_Temperature_StdDev_206hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 206 hPa Level Statistics, Land and Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.887, 1.7, 1.678, 1.657, 1.796, 1.868, 1.993, 1.998, 1.935, 1.932, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 2.043, 1.858, 1.826, 1.772, 1.984, 2.106, 2.159, 2.242, 2.306, 2.261, 2.094, 1.931, 2.034, 1.97, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 2.017, 1.867, 1.786, 1.741, 1.878, 2.023, 2.154, 2.064, 2.18, 2.232, 2.084, 1.966, 1.981, 1.781, 1.749, 1.827, 1.903, 2.118, 2.226, 2.125, 2.111, 2.071, 2.104, 2.081, 2.071, 1.9, 1.834, 1.917, 2.056, 2.267, 2.335, 2.547, 2.525, 2.542, 2.46, 2.479, 2.352, 2.174, 2.109, 2.128, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.948, 1.969, 1.82, 1.722, 1.788, 1.848, 1.989, 2.032, 2.125, 2.114, 2.113, 2.034, 2.07, 1.949, 1.81, 1.748, 1.809, 1.85, 1.984, 2.066, 2.122, 2.179, 2.126, 2.213, 2.077, 1.964, 1.913, 1.899, 1.835, 1.888, 2.078, 2.126, 2.211, 2.101, 1.995, 1.935, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.813, 1.678, 1.658, 1.645, 1.799, 1.861, 1.984, 1.967, 1.922, 1.879, 1.883, 1.788, 1.748, 1.6, 1.599, 1.688, 1.761, 1.898, 1.982, 1.98, 1.85, 1.778, 1.776, 1.748, 1.828, 1.701, 1.617, 1.653, 1.729, 1.862, 1.886, 1.943, 1.886, 1.9, 1.894, 1.868, 1.758, 1.643, 1.613, 1.702, 1.762, 1.833, 1.829, 1.905, 1.899, 1.902, 1.975, 1.873, 1.753, 1.742, 1.708, 1.798, 1.706, 1.79, 1.986, 2.017, 1.846, 1.756, 1.727, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.893, 1.864, 1.781, 1.712, 1.644, 1.623, 1.814, 1.748, 1.869, 2.085, 2.027, 1.834, 1.746, 1.748, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_WaterVapor_StdDev_206hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 206 hPa Level Statistics, Land and Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 49.605, 51.749, 53.364, 52.526, 52.57, 51.717, 56.314, 55.644, 54.253, 53.534, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 62.434, 64.083, 68.124, 70.882, 71.13, 73.215, 70.084, 73.682, 73.093, 68.146, 61.286, 59.583, 60.865, 63.349, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 66.464, 64.744, 68.338, 70.979, 70.876, 72.3, 73.4, 71.751, 70.82, 69.63, 64.682, 62.514, 62.537, 63.933, 65.776, 68.316, 70.984, 72.761, 70.376, 66.989, 68.544, 64.067, 61.139, 60.97, 56.007, 57.669, 60.02, 62.057, 63.849, 64.223, 65.63, 69.658, 64.951, 64.346, 63.064, 59.868, 58.275, 57.667, 58.173, 59.607, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 52.937, 54.745, 56.535, 58.803, 59.436, 60.958, 60.272, 61.32, 61.614, 59.42, 59.303, 58.106, 53.335, 51.62, 53.865, 55.48, 57.289, 56.965, 60.1, 62.949, 64.593, 62.903, 59.234, 55.954, 53.419, 59.045, 36.72, 15.637, 0.608, 31.084, 34.818, 15.538, 66.252, 64.07, 60.442, 58.037, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 51.688, 52.609, 53.073, 53.154, 52.67, 53.011, 57.129, 56.353, 54.644, 54.098, 50.409, 48.543, 50.072, 51.412, 52.55, 55.134, 53.571, 54.86, 54.114, 53.232, 54.027, 50.217, 48.118, 48.352, 49.267, 49.585, 50.801, 52.397, 53.564, 50.681, 51.246, 53.104, 50.427, 50.536, 48.92, 47.759, 46.018, 47.081, 47.782, 47.347, 48.048, 48.234, 50.956, 52.014, 51.428, 47.912, 0.558, 47.61, 53.38, 40.386, 17.252, 0.674, 49.17, 49.604, 8.094, 57.509, 10.317, 49.736, 48.35, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 53.64, 0.861, 48.881, 53.687, 49.16, 52.334, 0.658, 58.158, 38.439, 7.177, 59.41, 10.369, 51.812, 33.356, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_Temperature_RMS_206hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 206 hPa Level Statistics, Land and Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.936, 1.701, 1.689, 1.657, 1.796, 1.881, 2.024, 2.043, 1.966, 1.958, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 2.175, 1.87, 1.827, 1.79, 2.007, 2.181, 2.273, 2.344, 2.397, 2.321, 2.234, 2.037, 2.121, 2.004, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 2.28, 1.916, 1.793, 1.795, 1.942, 2.131, 2.285, 2.163, 2.241, 2.322, 2.337, 2.176, 2.084, 1.792, 1.751, 1.838, 2.003, 2.237, 2.244, 2.135, 2.133, 2.114, 2.248, 2.241, 2.24, 1.924, 1.84, 1.971, 2.177, 2.304, 2.381, 2.597, 2.557, 2.707, 2.665, 2.653, 2.488, 2.227, 2.121, 2.148, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.948, 1.969, 1.833, 1.724, 1.797, 1.93, 2.041, 2.069, 2.135, 2.114, 2.134, 2.055, 2.078, 1.967, 1.828, 1.752, 1.809, 1.865, 2.061, 2.233, 2.215, 2.276, 2.256, 2.303, 2.092, 1.964, 1.913, 1.901, 1.862, 1.954, 2.146, 2.162, 2.215, 2.103, 1.996, 1.941, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.853, 1.678, 1.675, 1.652, 1.8, 1.879, 2.0, 1.979, 1.922, 1.879, 1.889, 1.8, 1.754, 1.602, 1.603, 1.692, 1.772, 1.929, 1.983, 1.98, 1.851, 1.779, 1.776, 1.753, 1.844, 1.703, 1.624, 1.653, 1.742, 1.868, 1.905, 1.952, 1.886, 1.938, 1.944, 1.885, 1.767, 1.644, 1.62, 1.71, 1.762, 1.862, 1.887, 1.939, 1.938, 1.963, 2.034, 1.928, 1.776, 1.75, 1.708, 1.802, 1.707, 1.791, 1.988, 2.017, 1.847, 1.757, 1.727, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.97, 1.915, 1.814, 1.719, 1.646, 1.624, 1.815, 1.756, 1.877, 2.091, 2.027, 1.836, 1.748, 1.749, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_WaterVapor_RMS_206hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 206 hPa Level Statistics, Land and Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 54.518, 57.114, 58.943, 57.641, 57.65, 55.286, 67.521, 64.004, 60.435, 59.863, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 63.636, 65.238, 70.309, 72.74, 73.686, 74.909, 81.928, 77.909, 74.037, 69.973, 62.94, 62.024, 62.544, 67.143, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 67.42, 65.947, 70.594, 72.96, 72.675, 72.55, 78.387, 72.882, 71.601, 71.112, 65.932, 64.863, 64.198, 67.399, 68.103, 71.561, 72.477, 74.362, 75.356, 68.316, 72.151, 70.402, 64.188, 66.387, 56.68, 59.07, 60.567, 62.127, 63.902, 64.265, 66.485, 70.46, 65.233, 64.376, 63.188, 61.112, 59.067, 58.206, 58.21, 60.089, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 55.12, 56.478, 58.897, 60.33, 60.106, 62.473, 61.249, 65.512, 65.776, 62.189, 61.172, 59.346, 56.746, 54.398, 55.736, 55.484, 57.324, 56.969, 60.589, 63.191, 66.449, 63.302, 60.288, 57.515, 55.282, 73.509, 95.026, 99.234, 100.0, 97.306, 96.512, 99.106, 77.961, 65.675, 61.064, 59.094, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 55.245, 56.946, 58.008, 57.829, 57.184, 56.254, 67.463, 64.377, 60.549, 60.032, 54.255, 53.775, 54.325, 55.36, 56.025, 59.307, 57.547, 59.277, 61.793, 57.79, 60.28, 58.101, 53.449, 55.091, 53.96, 53.857, 54.527, 55.856, 57.411, 52.64, 56.568, 60.103, 56.979, 55.947, 52.86, 52.645, 50.942, 51.042, 49.677, 49.251, 50.029, 51.553, 53.452, 56.85, 55.517, 53.04, 100.002, 52.331, 68.064, 91.973, 98.76, 99.997, 51.128, 51.322, 99.612, 68.223, 99.536, 53.519, 86.463, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 74.543, 100.003, 52.533, 64.575, 51.236, 53.835, 99.998, 75.238, 94.077, 99.657, 70.288, 99.597, 54.43, 95.138, null] 
        }]
    })
    $('#nucapsirmw_Sea_Temperature_Bias_307hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 307 hPa Level Statistics, Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: -5.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 0.176, 0.288, 0.234, 0.375, 0.303, 0.007, -0.108, 0.057, 0.214, 0.036, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 0.235, 0.285, 0.281, 0.177, -0.087, -0.126, -0.122, -0.161, 0.237, 0.133, 0.068, 0.16, 0.208, -0.042, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 0.415, 0.522, 0.498, 0.585, 0.345, 0.103, 0.221, 0.534, 0.604, 0.437, 0.495, 0.375, 0.437, 0.513, 0.524, 0.416, 0.345, 0.379, 0.21, 0.417, 0.469, 0.266, 0.352, 0.47, 0.538, 0.656, 0.558, 0.526, 0.475, 0.429, 0.084, 0.548, 0.548, 0.174, 0.323, 0.545, 0.156, 0.264, 0.421, 0.645, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.037, 0.037, 0.103, 0.101, -0.152, -0.219, -0.251, -0.478, -0.37, -0.144, -0.064, 0.038, 0.05, -0.02, 0.142, 0.114, 0.031, -0.124, -0.448, -0.242, -0.289, -0.128, -0.116, -0.067, -0.053, -0.154, -0.03, 0.006, 0.036, -0.096, -0.235, -0.605, -0.079, 0.003, 0.084, 0.163, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 0.042, 0.095, 0.154, 0.22, 0.12, -0.177, -0.131, -0.115, 0.31, 0.029, 0.249, 0.13, 0.135, 0.168, 0.11, 0.16, -0.017, -0.158, -0.261, -0.043, 0.126, 0.006, 0.225, 0.229, 0.133, 0.143, 0.256, 0.129, 0.068, -0.109, -0.205, -0.102, 0.02, 0.028, 0.1, 0.216, 0.099, 0.191, 0.207, 0.208, -0.06, -0.385, -0.294, -0.116, 0.049, -0.071, 0.113, 0.031, -0.077, -0.051, 0.051, 0.144, -0.133, -0.365, -0.73, -0.124, 0.006, -0.052, 0.144, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -0.005, 0.102, 0.144, 0.092, 0.085, 0.15, 0.212, -0.035, -0.192, -0.615, -0.015, 0.077, 0.046, 0.266, null] 
        }]
    })
    $('#nucapsirmw_Sea_WaterVapor_Bias_307hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 307 hPa Level Statistics, Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 50.0,
          min: -50.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, -1.011, 0.053, 1.265, -0.384, 0.76, -3.34, 1.272, -3.028, 1.955, 6.296, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 12.28, 17.817, 9.053, 11.014, 10.489, 11.026, 9.11, 7.58, 11.715, 13.252, 9.294, 10.295, 12.079, 2.996, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 11.708, 13.959, 10.727, 14.876, 8.389, 13.404, 9.331, 5.985, 11.422, 15.587, 10.506, 10.404, 13.623, 9.755, 7.696, 12.948, 4.857, 11.459, 9.913, 5.75, 9.089, 9.594, 6.59, 12.132, 6.456, 4.152, 11.573, 13.516, 12.37, 6.273, 0.389, 10.723, -1.842, 0.326, 2.727, 3.521, 2.578, 0.668, -2.327, 9.006, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 11.907, 5.928, 10.948, 11.697, 4.811, 7.611, 6.504, 5.412, 3.357, -1.466, -0.115, 2.635, 0.852, 5.084, 0.156, -2.73, 2.906, 7.645, 0.565, 2.318, 1.262, -5.458, -4.399, -139.507, -1.021, 3.117, -1.413, 0.116, -3.303, 0.044, 5.953, 7.929, 2.822, 0.675, 1.975, 4.774, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.825, 1.521, 3.796, 7.385, 2.896, -1.049, 5.35, 4.355, 3.583, 4.412, 4.317, 1.097, 0.382, -3.063, -3.078, 1.737, 0.879, 1.661, 2.404, 0.976, 0.779, 2.43, -0.917, 1.651, 2.06, -0.16, 5.079, 9.276, 5.821, 1.996, 0.973, 7.913, -2.153, 0.527, 2.266, 1.093, 2.711, -1.456, -2.162, 6.259, 10.232, 1.546, -0.298, -0.15, -2.024, -4.824, 1.193, -3.517, 1.484, -3.019, -5.454, -1.305, -3.92, 1.477, 4.076, -4.654, -0.938, 3.775, -1.614, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -3.552, -1.853, 1.897, 7.099, 0.82, -0.792, 6.708, -4.528, 6.733, 3.636, -0.271, 2.731, 2.606, -1.881, null] 
        }]
    })
    $('#nucapsirmw_Sea_Temperature_StdDev_307hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 307 hPa Level Statistics, Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.025, 0.929, 1.003, 1.008, 1.044, 1.336, 1.17, 1.345, 1.106, 1.109, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 0.995, 1.02, 1.169, 1.172, 1.181, 1.503, 1.386, 1.55, 1.205, 1.05, 0.986, 1.054, 1.021, 1.188, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 1.043, 1.095, 1.107, 1.153, 1.097, 1.49, 1.43, 1.323, 1.137, 0.966, 1.034, 1.003, 0.979, 1.031, 1.184, 1.216, 1.193, 1.403, 1.478, 1.362, 1.176, 1.112, 1.197, 1.373, 1.448, 1.466, 1.625, 1.952, 2.038, 2.431, 2.496, 2.259, 2.084, 2.176, 2.453, 2.483, 2.421, 2.456, 2.309, 2.317, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.89, 1.032, 1.101, 1.083, 1.306, 1.179, 1.581, 1.406, 1.188, 1.005, 1.067, 0.928, 1.169, 1.023, 1.012, 1.025, 1.08, 1.309, 1.625, 1.235, 1.247, 1.059, 1.026, 1.19, 1.179, 1.068, 1.196, 1.212, 1.206, 1.187, 1.445, 1.892, 1.31, 1.195, 1.14, 1.211, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 0.921, 0.93, 0.977, 1.022, 1.037, 1.214, 1.291, 1.27, 1.084, 1.036, 0.928, 0.978, 0.809, 0.919, 1.034, 1.063, 1.086, 1.344, 1.446, 1.125, 1.019, 0.974, 1.068, 0.98, 0.917, 0.908, 0.986, 1.182, 0.993, 1.392, 1.265, 1.105, 0.966, 1.1, 0.915, 1.031, 0.926, 0.918, 0.965, 0.995, 1.152, 1.36, 1.428, 1.071, 1.073, 1.023, 1.205, 1.183, 0.991, 1.074, 1.025, 1.019, 1.216, 1.346, 1.759, 1.382, 1.164, 1.133, 1.135, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.998, 1.221, 1.155, 0.959, 1.026, 1.082, 0.992, 1.132, 1.205, 1.772, 1.193, 1.176, 1.07, 1.296, null] 
        }]
    })
    $('#nucapsirmw_Sea_WaterVapor_StdDev_307hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 307 hPa Level Statistics, Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 37.814, 37.183, 40.094, 37.311, 35.758, 33.424, 33.468, 34.103, 40.183, 38.129, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 44.981, 41.666, 39.931, 40.646, 39.227, 41.055, 42.033, 33.902, 42.015, 38.192, 38.14, 40.311, 37.515, 36.925, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 43.573, 43.196, 40.96, 44.718, 36.58, 42.845, 36.549, 34.024, 41.602, 41.357, 42.039, 41.027, 40.844, 39.626, 42.017, 42.638, 46.483, 49.129, 42.297, 39.263, 40.771, 35.204, 40.338, 42.707, 37.151, 41.771, 41.381, 49.73, 42.236, 48.454, 43.24, 49.359, 42.969, 40.78, 50.713, 43.433, 42.745, 45.931, 43.965, 51.967, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 32.63, 32.899, 42.996, 38.018, 38.884, 35.69, 34.983, 38.091, 33.934, 34.553, 34.01, 32.117, 30.316, 34.768, 35.687, 31.256, 38.029, 42.718, 34.09, 36.411, 36.545, 35.816, 30.334, 1.47, 31.722, 38.587, 31.448, 39.39, 30.638, 32.238, 37.675, 38.346, 33.866, 35.953, 36.122, 37.367, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 35.54, 36.403, 37.553, 38.783, 34.87, 34.432, 34.11, 34.585, 39.956, 42.988, 37.323, 36.193, 36.262, 33.242, 37.523, 38.888, 35.563, 38.815, 35.61, 35.603, 36.791, 37.725, 33.792, 33.032, 32.581, 36.266, 39.828, 42.016, 37.506, 33.678, 34.623, 44.225, 36.306, 39.0, 37.611, 36.742, 36.932, 33.556, 37.988, 41.596, 44.611, 33.478, 39.448, 36.466, 37.003, 30.597, 34.048, 34.871, 38.159, 33.178, 34.328, 42.033, 33.129, 33.506, 33.479, 32.387, 36.006, 36.205, 32.992, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 31.727, 34.956, 36.077, 40.316, 33.929, 33.074, 40.834, 34.748, 36.01, 37.338, 36.254, 38.21, 34.369, 37.826, null] 
        }]
    })
    $('#nucapsirmw_Sea_Temperature_RMS_307hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 307 hPa Level Statistics, Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.04, 0.972, 1.03, 1.075, 1.087, 1.336, 1.175, 1.346, 1.127, 1.11, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 1.023, 1.059, 1.202, 1.185, 1.184, 1.508, 1.392, 1.558, 1.228, 1.059, 0.989, 1.066, 1.042, 1.189, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 1.123, 1.213, 1.215, 1.293, 1.15, 1.493, 1.447, 1.427, 1.287, 1.06, 1.146, 1.071, 1.072, 1.151, 1.295, 1.286, 1.242, 1.454, 1.493, 1.425, 1.266, 1.143, 1.248, 1.451, 1.545, 1.606, 1.719, 2.022, 2.093, 2.468, 2.498, 2.324, 2.155, 2.183, 2.474, 2.542, 2.426, 2.471, 2.347, 2.406, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.891, 1.033, 1.106, 1.088, 1.315, 1.2, 1.601, 1.485, 1.245, 1.016, 1.069, 0.929, 1.17, 1.023, 1.022, 1.031, 1.08, 1.315, 1.686, 1.259, 1.28, 1.066, 1.033, 1.192, 1.18, 1.079, 1.196, 1.212, 1.207, 1.191, 1.464, 1.987, 1.312, 1.195, 1.143, 1.222, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 0.922, 0.935, 0.989, 1.046, 1.044, 1.227, 1.298, 1.275, 1.128, 1.036, 0.961, 0.987, 0.82, 0.934, 1.039, 1.075, 1.086, 1.353, 1.469, 1.126, 1.027, 0.974, 1.092, 1.007, 0.927, 0.919, 1.019, 1.19, 0.995, 1.397, 1.282, 1.11, 0.967, 1.101, 0.92, 1.053, 0.931, 0.937, 0.987, 1.017, 1.154, 1.413, 1.458, 1.077, 1.074, 1.026, 1.21, 1.184, 0.994, 1.075, 1.027, 1.029, 1.224, 1.395, 1.904, 1.388, 1.164, 1.134, 1.144, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.998, 1.226, 1.164, 0.964, 1.03, 1.093, 1.015, 1.132, 1.221, 1.876, 1.193, 1.179, 1.071, 1.323, null] 
        }]
    })
    $('#nucapsirmw_Sea_WaterVapor_RMS_307hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 307 hPa Level Statistics, Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 41.012, 40.484, 42.997, 40.869, 37.744, 36.664, 35.926, 38.482, 43.933, 40.003, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 45.424, 41.779, 41.075, 41.021, 39.526, 41.296, 43.615, 34.682, 42.702, 38.377, 38.232, 40.46, 37.582, 38.353, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 44.209, 43.246, 41.278, 44.726, 37.136, 43.093, 37.136, 34.792, 42.014, 41.432, 42.2, 41.098, 40.963, 40.465, 42.925, 42.789, 48.435, 50.56, 43.475, 40.969, 41.683, 35.588, 41.014, 42.777, 38.377, 43.305, 41.881, 50.146, 42.509, 50.031, 46.233, 49.83, 46.595, 42.786, 52.152, 44.709, 45.25, 48.547, 47.892, 53.197, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 32.674, 33.45, 43.774, 38.075, 40.711, 36.576, 35.788, 39.093, 35.934, 37.772, 36.708, 33.304, 32.545, 36.233, 38.753, 34.373, 40.197, 45.874, 38.011, 38.454, 39.545, 42.081, 34.24, 100.087, 34.231, 40.448, 33.731, 42.832, 34.158, 35.076, 38.686, 40.155, 36.32, 39.556, 37.693, 38.083, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 37.905, 39.147, 39.218, 39.918, 37.473, 36.609, 34.896, 35.86, 43.374, 45.388, 38.986, 38.022, 39.006, 37.111, 41.379, 40.882, 37.459, 41.291, 38.017, 37.889, 40.071, 39.588, 36.13, 34.595, 34.595, 39.89, 41.217, 43.544, 39.113, 35.644, 36.675, 45.24, 40.357, 41.765, 39.631, 39.049, 39.772, 37.037, 43.277, 43.175, 46.418, 36.431, 42.742, 40.21, 41.186, 35.301, 36.359, 38.843, 40.96, 36.178, 39.311, 45.582, 36.573, 34.938, 35.65, 36.544, 38.815, 37.108, 35.552, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 35.461, 38.261, 37.93, 41.319, 35.701, 35.643, 41.847, 38.427, 36.669, 39.281, 38.82, 39.514, 35.518, 39.314, null] 
        }]
    })
    $('#nucapsirmw_Land_Temperature_Bias_307hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 307 hPa Level Statistics, Land, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: -5.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, -0.346, 0.0, 0.144, 0.115, 0.023, -0.017, -0.096, -0.002, -0.095, -0.122, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 0.014, 0.303, 0.389, 0.21, -0.1, -0.244, -0.264, 0.112, 0.165, 0.175, 0.063, 0.0, -0.004, 0.112, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 0.213, 0.537, 0.663, 0.523, 0.424, 0.391, 0.346, 0.648, 0.635, 0.648, 0.354, 0.21, 0.275, 0.515, 0.612, 0.539, 0.342, 0.523, 0.676, 0.685, 0.679, 0.499, 0.377, 0.323, 0.361, 0.608, 0.679, 0.756, 0.667, 0.894, 0.81, 0.751, 0.899, 0.484, 0.255, 0.498, 0.48, 0.671, 0.709, 0.823, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -0.194, -0.086, 0.076, -0.059, -0.12, -0.262, -0.115, -0.212, -0.133, 0.074, 0.019, -0.152, -0.041, 0.003, 0.019, -0.024, -0.066, -0.164, -0.281, -0.24, -0.191, -0.037, -0.053, -0.154, -0.17, -0.067, -0.004, 0.023, -0.126, -0.182, -0.16, 0.047, 0.01, 0.114, 0.146, 0.116, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, -0.434, -0.123, 0.035, 0.037, -0.032, -0.15, -0.157, -0.012, -0.061, -0.095, -0.253, -0.455, -0.448, -0.231, -0.113, -0.112, -0.203, -0.137, -0.05, -0.131, -0.135, -0.229, -0.258, -0.352, -0.436, -0.189, -0.121, -0.145, -0.219, -0.137, -0.211, -0.241, -0.108, -0.283, -0.422, -0.379, -0.312, -0.259, -0.1, -0.103, -0.201, -0.292, -0.299, -0.312, -0.259, -0.343, -0.366, -0.41, -0.31, -0.186, -0.018, -0.061, -0.156, -0.129, -0.014, -0.155, -0.183, -0.19, -0.203, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -0.187, -0.171, -0.145, -0.039, 0.069, 0.192, 0.138, -0.024, -0.014, 0.087, 0.02, -0.04, -0.027, -0.058, null] 
        }]
    })
    $('#nucapsirmw_Land_WaterVapor_Bias_307hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 307 hPa Level Statistics, Land, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 50.0,
          min: -50.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, -4.907, -4.216, -2.635, 1.317, -0.806, -2.928, -4.637, -5.197, -2.988, -5.649, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 8.235, 11.661, 16.843, 18.149, 17.136, 10.769, 14.16, 11.678, 13.471, 13.175, 9.352, 5.984, 9.331, 6.9, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 8.514, 13.652, 18.419, 19.033, 17.774, 11.39, 14.296, 12.33, 13.338, 11.721, 11.824, 8.052, 12.762, 11.785, 17.674, 18.533, 15.762, 19.618, 21.297, 16.757, 11.458, 10.599, 10.478, 8.291, 4.382, 8.564, 16.144, 18.367, 17.968, 24.428, 23.716, 24.014, 19.83, 14.677, 10.754, 9.566, 9.353, 12.165, 14.313, 18.503, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 3.612, -0.736, 2.356, 7.545, 10.971, 10.112, 12.388, 8.948, 8.601, 5.868, 4.711, 4.338, 0.274, 0.665, 3.106, 5.043, 7.219, 7.661, 6.57, 6.066, 3.437, 1.152, 37.836, -1.007, -2.628, -2.257, 0.148, 5.403, 8.434, 10.948, 11.849, 11.759, 8.296, 68.022, 1.451, -0.476, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, -2.68, -2.071, 1.401, 5.485, 3.782, 1.175, -1.387, -1.393, 0.212, -2.579, -1.1, -2.094, -1.195, -1.352, -0.862, 0.489, -0.062, 0.022, 0.334, -1.865, -2.123, -2.875, -2.553, -2.699, -3.783, -4.674, -1.479, 1.421, 1.442, 2.027, -1.376, 0.415, 0.112, 0.174, -0.166, -2.54, -4.218, -3.055, -0.212, 2.276, 1.753, -1.176, 1.684, -0.576, -0.399, 23.04, -3.139, -3.44, -3.401, -3.594, -0.594, 1.501, 3.485, 4.671, 2.826, 1.746, 37.548, -2.426, -2.569, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 34.972, -2.026, -2.195, -1.29, -1.136, 2.786, 4.52, 5.775, 5.586, 4.034, 4.088, 40.317, -0.516, -0.258, null] 
        }]
    })
    $('#nucapsirmw_Land_Temperature_StdDev_307hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 307 hPa Level Statistics, Land, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.413, 1.437, 1.385, 1.388, 1.517, 1.646, 1.692, 1.6, 1.513, 1.46, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 1.302, 1.334, 1.374, 1.456, 1.75, 1.861, 1.966, 1.694, 1.521, 1.464, 1.429, 1.371, 1.372, 1.443, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 1.323, 1.366, 1.382, 1.517, 1.663, 1.759, 1.834, 1.645, 1.549, 1.488, 1.442, 1.395, 1.426, 1.348, 1.423, 1.532, 1.736, 1.813, 1.829, 1.769, 1.682, 1.609, 1.568, 1.714, 1.7, 1.77, 1.837, 1.99, 2.354, 2.61, 2.672, 2.81, 2.69, 2.694, 2.739, 2.823, 2.737, 2.599, 2.602, 2.551, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.355, 1.338, 1.348, 1.368, 1.375, 1.506, 1.641, 1.65, 1.69, 1.557, 1.495, 1.442, 1.463, 1.43, 1.302, 1.432, 1.387, 1.521, 1.581, 1.618, 1.617, 1.508, 1.492, 1.44, 1.444, 1.349, 1.336, 1.366, 1.438, 1.478, 1.612, 1.699, 1.719, 1.617, 1.513, 1.471, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.339, 1.364, 1.343, 1.37, 1.469, 1.588, 1.637, 1.557, 1.491, 1.446, 1.402, 1.372, 1.393, 1.278, 1.304, 1.371, 1.47, 1.532, 1.604, 1.539, 1.474, 1.428, 1.375, 1.395, 1.358, 1.343, 1.299, 1.342, 1.461, 1.568, 1.583, 1.585, 1.475, 1.407, 1.37, 1.404, 1.38, 1.276, 1.395, 1.373, 1.446, 1.493, 1.55, 1.54, 1.464, 1.434, 1.397, 1.406, 1.359, 1.317, 1.305, 1.396, 1.429, 1.534, 1.599, 1.586, 1.507, 1.45, 1.409, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.4, 1.366, 1.348, 1.305, 1.236, 1.259, 1.373, 1.442, 1.525, 1.603, 1.548, 1.476, 1.429, 1.338, null] 
        }]
    })
    $('#nucapsirmw_Land_WaterVapor_StdDev_307hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 307 hPa Level Statistics, Land, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 38.039, 39.69, 40.767, 39.802, 39.542, 36.865, 38.723, 38.967, 39.359, 40.431, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 44.453, 45.099, 49.393, 47.351, 48.065, 43.376, 46.816, 45.053, 43.984, 43.963, 40.285, 41.438, 42.269, 43.329, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 46.029, 49.816, 51.556, 49.625, 47.43, 44.611, 47.461, 48.005, 44.84, 48.271, 43.658, 44.447, 47.654, 48.223, 50.296, 48.247, 47.605, 48.944, 51.098, 50.599, 50.614, 46.065, 47.525, 49.693, 44.499, 45.792, 48.603, 52.167, 51.437, 56.903, 59.221, 61.451, 57.654, 57.522, 53.419, 55.192, 53.166, 53.893, 56.339, 57.509, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 42.639, 40.303, 41.909, 42.512, 44.049, 41.898, 43.148, 43.058, 44.972, 43.043, 45.202, 44.35, 40.829, 41.263, 42.209, 43.34, 42.692, 40.715, 40.698, 41.674, 41.618, 41.407, 4.304, 38.582, 39.079, 39.876, 40.246, 43.131, 45.703, 46.267, 42.107, 44.158, 44.492, 3.361, 41.06, 40.415, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 38.49, 39.855, 42.037, 41.629, 39.889, 37.386, 38.263, 41.152, 40.566, 41.82, 38.289, 37.763, 40.173, 40.565, 41.047, 40.031, 38.698, 39.094, 39.034, 42.001, 43.383, 38.711, 38.889, 40.013, 38.753, 37.493, 39.419, 40.925, 38.667, 39.045, 37.812, 40.915, 40.936, 42.76, 40.539, 38.571, 36.319, 38.768, 41.233, 40.607, 39.0, 37.598, 38.853, 38.857, 40.282, 5.33, 36.822, 37.387, 37.643, 38.42, 40.037, 40.909, 38.948, 39.365, 39.055, 41.233, 4.245, 39.148, 38.637, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 4.773, 37.647, 38.086, 39.008, 39.653, 41.972, 43.215, 40.83, 41.301, 41.094, 42.341, 4.261, 40.806, 40.603, null] 
        }]
    })
    $('#nucapsirmw_Land_Temperature_RMS_307hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 307 hPa Level Statistics, Land, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.454, 1.437, 1.393, 1.393, 1.518, 1.646, 1.695, 1.6, 1.516, 1.465, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 1.302, 1.368, 1.428, 1.471, 1.753, 1.877, 1.984, 1.698, 1.53, 1.474, 1.43, 1.371, 1.372, 1.448, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 1.34, 1.468, 1.533, 1.604, 1.716, 1.802, 1.867, 1.768, 1.674, 1.623, 1.485, 1.411, 1.452, 1.443, 1.549, 1.625, 1.769, 1.887, 1.95, 1.897, 1.814, 1.684, 1.612, 1.745, 1.738, 1.872, 1.958, 2.129, 2.446, 2.759, 2.792, 2.909, 2.837, 2.737, 2.751, 2.867, 2.779, 2.684, 2.697, 2.68, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.369, 1.34, 1.351, 1.369, 1.38, 1.528, 1.646, 1.663, 1.696, 1.558, 1.495, 1.45, 1.464, 1.43, 1.303, 1.433, 1.389, 1.53, 1.606, 1.636, 1.628, 1.509, 1.493, 1.449, 1.454, 1.351, 1.336, 1.367, 1.443, 1.489, 1.62, 1.7, 1.719, 1.621, 1.52, 1.476, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.407, 1.369, 1.344, 1.371, 1.469, 1.595, 1.644, 1.557, 1.492, 1.449, 1.425, 1.446, 1.464, 1.298, 1.309, 1.375, 1.484, 1.539, 1.605, 1.545, 1.48, 1.446, 1.399, 1.439, 1.426, 1.357, 1.304, 1.35, 1.478, 1.574, 1.597, 1.603, 1.479, 1.435, 1.434, 1.455, 1.415, 1.303, 1.398, 1.377, 1.46, 1.522, 1.579, 1.571, 1.487, 1.475, 1.444, 1.465, 1.394, 1.33, 1.306, 1.397, 1.438, 1.539, 1.599, 1.594, 1.518, 1.463, 1.423, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.413, 1.377, 1.356, 1.305, 1.238, 1.274, 1.38, 1.442, 1.525, 1.605, 1.548, 1.476, 1.429, 1.34, null] 
        }]
    })
    $('#nucapsirmw_Land_WaterVapor_RMS_307hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 307 hPa Level Statistics, Land, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 44.475, 45.56, 46.568, 42.898, 43.821, 41.173, 43.06, 44.115, 43.722, 47.706, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 46.861, 46.907, 50.363, 47.59, 48.69, 44.604, 47.06, 45.925, 44.817, 44.928, 41.948, 43.658, 43.878, 45.611, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 49.409, 51.48, 52.389, 49.963, 47.957, 46.279, 48.328, 49.009, 45.666, 50.147, 45.598, 46.641, 49.223, 49.752, 50.919, 48.404, 47.78, 49.208, 51.301, 51.008, 52.499, 47.909, 49.9, 52.103, 47.364, 47.378, 48.831, 52.417, 51.751, 56.921, 59.331, 61.692, 57.965, 58.539, 55.041, 56.862, 54.871, 55.34, 57.399, 57.834, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 46.588, 44.643, 45.034, 43.935, 44.978, 42.864, 43.57, 44.549, 46.905, 45.633, 48.194, 47.795, 45.194, 45.643, 45.512, 46.24, 44.188, 42.174, 43.021, 43.981, 44.995, 45.102, 99.915, 43.365, 44.111, 45.039, 44.331, 45.381, 47.922, 47.562, 42.776, 44.986, 46.172, 99.996, 44.598, 44.194, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 43.921, 44.961, 45.942, 43.566, 42.505, 40.337, 42.201, 45.294, 43.75, 47.503, 42.508, 42.493, 45.158, 45.26, 45.751, 43.351, 41.519, 42.902, 42.726, 46.796, 48.399, 44.122, 43.81, 44.807, 43.684, 42.419, 43.018, 43.757, 41.131, 41.219, 41.745, 44.967, 45.125, 47.172, 44.878, 43.007, 41.724, 43.45, 45.525, 43.025, 41.716, 42.297, 41.989, 43.204, 44.328, 99.877, 41.093, 42.127, 42.389, 43.636, 43.619, 44.684, 41.492, 41.342, 41.763, 45.023, 99.93, 43.561, 42.357, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 99.912, 41.499, 41.978, 42.799, 43.637, 44.451, 45.991, 42.47, 42.935, 42.993, 44.813, 99.929, 44.482, 44.234, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_Temperature_Bias_307hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 307 hPa Level Statistics, Land and Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: -5.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, -0.277, 0.024, 0.151, 0.117, 0.043, 0.012, -0.076, -0.006, -0.066, -0.072, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 0.046, 0.3, 0.373, 0.199, -0.096, -0.22, -0.218, 0.083, 0.173, 0.179, 0.058, 0.02, 0.025, 0.098, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 0.236, 0.529, 0.641, 0.508, 0.382, 0.352, 0.336, 0.606, 0.629, 0.63, 0.359, 0.239, 0.301, 0.499, 0.602, 0.514, 0.314, 0.475, 0.599, 0.635, 0.624, 0.466, 0.366, 0.342, 0.379, 0.586, 0.644, 0.693, 0.583, 0.792, 0.696, 0.711, 0.84, 0.443, 0.221, 0.493, 0.457, 0.617, 0.644, 0.748, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -0.131, -0.066, 0.075, -0.048, -0.108, -0.264, -0.132, -0.224, -0.144, 0.057, 0.008, -0.125, -0.026, -0.003, 0.026, -0.016, -0.051, -0.157, -0.294, -0.242, -0.213, -0.047, -0.049, -0.138, -0.132, -0.069, 0.013, 0.028, -0.105, -0.166, -0.15, -0.008, 0.012, 0.096, 0.146, 0.126, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, -0.371, -0.105, 0.036, 0.031, -0.036, -0.131, -0.136, -0.02, -0.034, -0.06, -0.201, -0.375, -0.365, -0.186, -0.074, -0.092, -0.196, -0.135, -0.07, -0.113, -0.118, -0.206, -0.201, -0.288, -0.368, -0.151, -0.095, -0.122, -0.207, -0.139, -0.195, -0.219, -0.09, -0.244, -0.34, -0.299, -0.265, -0.216, -0.079, -0.076, -0.181, -0.277, -0.291, -0.3, -0.23, -0.296, -0.293, -0.313, -0.259, -0.157, -0.001, -0.048, -0.147, -0.132, -0.068, -0.136, -0.154, -0.149, -0.147, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -0.172, -0.128, -0.092, -0.025, 0.082, 0.189, 0.131, -0.025, -0.016, 0.035, 0.03, -0.029, -0.005, -0.025, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_WaterVapor_Bias_307hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 307 hPa Level Statistics, Land and Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 50.0,
          min: -50.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, -4.221, -3.636, -2.925, -0.775, -2.921, -4.394, -4.384, -4.273, -1.97, -4.72, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 8.907, 11.59, 15.235, 16.313, 14.169, 9.457, 10.737, 9.463, 12.25, 12.642, 9.096, 6.949, 9.356, 7.012, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 8.617, 13.429, 17.062, 17.527, 14.719, 10.139, 11.452, 9.667, 12.489, 11.206, 11.352, 8.815, 12.229, 11.193, 15.255, 15.389, 12.724, 15.612, 16.582, 12.655, 9.227, 9.777, 10.479, 9.365, 4.959, 7.95, 13.221, 13.341, 13.646, 18.269, 14.131, 17.567, 12.92, 8.841, 5.445, 8.123, 7.99, 9.883, 9.317, 12.205, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 4.39, 0.134, 2.905, 6.636, 7.49, 7.714, 10.127, 6.766, 5.864, 3.108, 3.403, 2.944, 0.371, 0.736, 2.696, 3.493, 4.199, 4.222, 2.321, 2.514, 0.697, -1.029, 65.712, 5.792, -2.139, -1.341, -0.096, 3.492, 5.193, 7.361, 7.948, 8.218, 6.167, 42.759, 1.458, 0.287, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, -2.095, -1.946, 0.42, 3.56, 0.858, -1.048, -1.094, -0.824, 1.077, -2.063, -1.09, -1.661, -1.428, -1.642, -1.619, -1.088, -1.665, -1.444, -2.026, -2.949, -2.533, -2.85, -2.425, -2.261, -3.32, -3.473, -1.701, -0.077, -0.524, -0.59, -3.088, -0.79, -2.366, -1.67, -1.644, -2.791, -3.99, -3.22, -1.455, 0.438, -0.886, -3.723, -1.068, -2.553, -2.01, 35.305, 0.27, -3.788, -3.139, -3.795, -1.627, -0.678, -0.39, 0.452, -0.557, -0.371, 22.944, -2.539, -2.096, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 19.404, 2.47, -2.183, -0.667, -1.378, 1.537, 2.12, 2.437, 2.487, 2.318, 2.523, 25.786, -0.696, -0.048, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_Temperature_StdDev_307hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 307 hPa Level Statistics, Land and Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.38, 1.393, 1.357, 1.366, 1.5, 1.606, 1.638, 1.57, 1.478, 1.432, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 1.272, 1.31, 1.373, 1.436, 1.719, 1.822, 1.891, 1.674, 1.484, 1.431, 1.397, 1.333, 1.337, 1.403, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 1.289, 1.335, 1.37, 1.489, 1.651, 1.719, 1.771, 1.616, 1.508, 1.456, 1.407, 1.357, 1.384, 1.314, 1.402, 1.506, 1.702, 1.779, 1.798, 1.738, 1.676, 1.573, 1.527, 1.665, 1.671, 1.736, 1.823, 1.991, 2.347, 2.621, 2.679, 2.767, 2.66, 2.648, 2.707, 2.788, 2.708, 2.601, 2.598, 2.558, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.313, 1.305, 1.318, 1.343, 1.356, 1.479, 1.627, 1.62, 1.643, 1.505, 1.459, 1.396, 1.415, 1.382, 1.281, 1.381, 1.35, 1.48, 1.552, 1.577, 1.576, 1.469, 1.451, 1.41, 1.4, 1.315, 1.349, 1.348, 1.411, 1.468, 1.581, 1.706, 1.665, 1.58, 1.472, 1.426, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.304, 1.327, 1.319, 1.349, 1.455, 1.552, 1.591, 1.527, 1.452, 1.408, 1.374, 1.34, 1.348, 1.237, 1.285, 1.337, 1.437, 1.5, 1.573, 1.491, 1.439, 1.386, 1.327, 1.346, 1.32, 1.297, 1.27, 1.321, 1.431, 1.54, 1.552, 1.536, 1.426, 1.368, 1.333, 1.365, 1.336, 1.253, 1.339, 1.334, 1.412, 1.46, 1.497, 1.505, 1.429, 1.399, 1.374, 1.369, 1.312, 1.315, 1.279, 1.353, 1.413, 1.519, 1.625, 1.546, 1.478, 1.418, 1.381, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.366, 1.341, 1.305, 1.26, 1.24, 1.232, 1.33, 1.418, 1.518, 1.604, 1.5, 1.441, 1.397, 1.316, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_WaterVapor_StdDev_307hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 307 hPa Level Statistics, Land and Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 37.821, 39.061, 38.537, 36.239, 34.65, 32.726, 35.542, 37.495, 38.528, 38.748, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 43.997, 44.16, 46.792, 44.252, 43.504, 40.687, 42.907, 41.155, 41.622, 41.893, 39.66, 40.983, 41.229, 41.94, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 45.096, 48.453, 49.009, 46.485, 43.541, 41.823, 44.298, 43.089, 42.398, 45.579, 42.616, 43.676, 45.972, 46.036, 46.298, 45.048, 44.704, 45.568, 47.12, 44.119, 45.118, 43.403, 45.777, 48.054, 43.31, 44.078, 44.892, 47.001, 47.043, 50.971, 50.379, 54.447, 52.398, 50.276, 49.058, 52.743, 51.571, 51.541, 52.603, 52.891, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 41.597, 39.064, 40.741, 39.542, 39.573, 38.044, 38.552, 39.094, 40.027, 38.903, 40.278, 40.607, 39.123, 39.959, 40.192, 39.91, 39.775, 38.609, 36.58, 37.467, 38.101, 38.246, 3.683, 5.798, 37.88, 39.391, 39.833, 40.118, 40.25, 39.114, 38.473, 39.258, 40.159, 4.083, 39.277, 38.925, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 38.253, 39.138, 38.964, 38.049, 35.109, 33.623, 35.642, 38.368, 39.626, 40.028, 37.766, 37.378, 38.967, 38.896, 38.821, 37.631, 34.606, 35.276, 35.445, 37.792, 38.812, 37.067, 38.049, 38.744, 38.125, 37.045, 37.318, 37.936, 35.924, 34.805, 34.518, 38.505, 37.768, 39.003, 38.291, 37.084, 35.804, 37.326, 39.419, 39.105, 37.935, 33.987, 36.772, 36.564, 38.283, 4.727, 7.749, 36.44, 37.472, 37.926, 38.138, 38.655, 34.935, 44.193, 49.079, 37.496, 5.299, 38.19, 37.86, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 5.953, 7.295, 37.309, 38.746, 39.404, 39.584, 40.16, 36.816, 46.766, 37.412, 39.219, 5.319, 39.632, 38.792, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_Temperature_RMS_307hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 307 hPa Level Statistics, Land and Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.408, 1.393, 1.365, 1.371, 1.501, 1.606, 1.64, 1.57, 1.48, 1.434, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 1.273, 1.344, 1.423, 1.449, 1.722, 1.835, 1.903, 1.676, 1.494, 1.442, 1.398, 1.334, 1.338, 1.407, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 1.311, 1.436, 1.513, 1.573, 1.694, 1.755, 1.803, 1.726, 1.634, 1.586, 1.452, 1.378, 1.417, 1.406, 1.526, 1.591, 1.731, 1.841, 1.895, 1.851, 1.789, 1.64, 1.57, 1.7, 1.714, 1.833, 1.933, 2.108, 2.418, 2.738, 2.768, 2.857, 2.79, 2.685, 2.716, 2.831, 2.746, 2.673, 2.677, 2.665, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.32, 1.307, 1.32, 1.344, 1.36, 1.503, 1.633, 1.635, 1.649, 1.506, 1.459, 1.402, 1.415, 1.382, 1.281, 1.381, 1.351, 1.488, 1.58, 1.595, 1.59, 1.47, 1.451, 1.416, 1.407, 1.316, 1.349, 1.348, 1.415, 1.477, 1.588, 1.706, 1.665, 1.583, 1.479, 1.432, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.356, 1.331, 1.32, 1.349, 1.455, 1.558, 1.597, 1.527, 1.453, 1.409, 1.389, 1.391, 1.397, 1.251, 1.287, 1.341, 1.45, 1.507, 1.575, 1.496, 1.444, 1.402, 1.342, 1.376, 1.371, 1.306, 1.274, 1.326, 1.447, 1.546, 1.564, 1.551, 1.429, 1.389, 1.376, 1.398, 1.363, 1.272, 1.342, 1.337, 1.424, 1.486, 1.526, 1.535, 1.448, 1.43, 1.404, 1.404, 1.337, 1.324, 1.279, 1.354, 1.42, 1.525, 1.627, 1.552, 1.486, 1.426, 1.389, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.377, 1.347, 1.308, 1.26, 1.243, 1.246, 1.337, 1.418, 1.518, 1.605, 1.5, 1.441, 1.397, 1.316, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_WaterVapor_RMS_307hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 307 hPa Level Statistics, Land and Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 43.522, 44.177, 43.288, 39.736, 38.553, 36.709, 39.128, 41.64, 42.292, 44.327, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 45.774, 45.494, 47.701, 44.548, 44.371, 41.847, 43.708, 42.29, 42.441, 42.52, 41.025, 42.608, 42.527, 43.772, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 47.725, 49.671, 49.661, 46.765, 44.32, 43.287, 45.258, 44.442, 43.123, 46.958, 44.133, 45.226, 47.247, 47.245, 46.873, 45.468, 45.228, 46.142, 47.749, 45.032, 46.845, 44.832, 47.452, 49.651, 45.489, 45.323, 45.275, 47.59, 47.511, 51.163, 51.523, 55.132, 53.487, 51.945, 51.348, 54.312, 53.295, 53.126, 54.507, 54.096, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 44.643, 42.622, 43.105, 40.8, 41.082, 39.199, 39.114, 40.605, 42.361, 41.827, 42.879, 43.74, 42.996, 43.897, 43.249, 42.761, 42.296, 41.029, 40.284, 40.578, 42.139, 42.597, 99.942, 99.846, 42.42, 43.858, 43.993, 42.815, 43.065, 40.935, 40.003, 40.769, 42.21, 99.967, 42.274, 42.026, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 42.988, 43.744, 42.443, 40.192, 37.935, 36.64, 38.429, 41.517, 42.437, 44.561, 41.645, 41.514, 43.482, 43.162, 42.884, 41.127, 37.565, 38.688, 39.274, 42.208, 42.857, 41.558, 42.335, 42.829, 42.573, 41.075, 40.56, 41.004, 38.827, 37.578, 38.493, 42.561, 42.554, 43.466, 42.666, 41.308, 40.948, 41.961, 44.188, 42.648, 41.873, 38.99, 40.727, 41.397, 42.82, 99.901, 99.683, 41.125, 42.11, 43.105, 41.971, 42.976, 38.554, 51.436, 66.587, 41.488, 99.878, 42.384, 41.267, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 99.839, 99.733, 41.056, 42.272, 43.465, 42.333, 43.491, 39.085, 53.508, 39.501, 41.737, 99.88, 43.13, 41.744, null] 
        }]
    })
    $('#nucapsirmw_Sea_Temperature_Bias_506hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 506 hPa Level Statistics, Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: -5.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 0.055, -0.115, -0.145, -0.197, -0.128, -0.222, -0.266, -0.093, -0.199, -0.041, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 0.127, -0.142, -0.001, -0.028, 0.008, -0.062, 0.147, -0.009, -0.111, -0.304, -0.18, 0.013, 0.096, 0.143, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 0.096, -0.01, 0.037, 0.027, 0.005, -0.035, -0.024, 0.031, -0.303, -0.307, -0.107, -0.163, 0.011, 0.022, 0.135, 0.043, -0.084, 0.021, 0.143, -0.13, -0.22, -0.206, -0.061, -0.109, 0.326, 0.328, 0.234, 0.126, 0.285, 0.449, 0.287, 0.188, 0.315, 0.116, 0.26, 0.336, 0.268, 0.181, 0.29, 0.246, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -0.07, -0.072, -0.184, -0.191, -0.256, -0.166, -0.192, -0.242, -0.253, -0.346, -0.334, -0.255, -0.216, -0.097, -0.224, -0.338, -0.322, -0.296, -0.233, -0.258, -0.357, -0.394, -0.433, -0.352, -0.147, -0.158, -0.218, -0.169, -0.266, -0.251, -0.139, -0.206, -0.487, -0.374, -0.29, -0.341, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 0.109, -0.042, -0.156, -0.151, -0.145, -0.17, -0.177, -0.123, -0.267, -0.171, 0.015, 0.086, -0.078, 0.035, -0.19, -0.296, -0.215, -0.114, -0.171, -0.16, -0.181, -0.049, 0.06, -0.235, 0.001, -0.166, -0.152, -0.29, -0.231, -0.313, -0.278, -0.349, -0.275, -0.209, -0.128, -0.148, -0.174, -0.193, -0.345, -0.42, -0.341, -0.351, -0.208, -0.18, -0.236, -0.285, -0.246, -0.084, -0.148, -0.113, -0.162, -0.232, -0.11, -0.14, -0.318, -0.353, -0.312, -0.152, -0.231, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -0.036, -0.108, -0.113, -0.13, -0.055, -0.054, -0.062, 0.005, 0.156, -0.04, -0.04, -0.11, -0.079, -0.071, null] 
        }]
    })
    $('#nucapsirmw_Sea_WaterVapor_Bias_506hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 506 hPa Level Statistics, Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 50.0,
          min: -50.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, -7.643, -7.173, -10.685, -7.968, -13.358, -13.171, -15.044, -7.903, -9.931, -3.346, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, -5.069, -4.72, -7.506, -7.35, -8.212, -8.151, -4.309, -2.206, -5.334, -4.153, -4.353, -5.093, -4.81, -7.093, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, -6.162, -2.461, -12.458, -6.703, -5.967, -9.917, -3.409, -5.317, -6.177, -4.283, -5.146, -10.098, -5.747, -7.594, -10.384, -6.143, -8.0, -4.856, -5.104, -9.614, -9.019, -7.966, -8.1, -5.45, -4.023, -6.519, -3.58, -2.396, -3.84, -5.002, -2.703, -3.724, -9.125, -4.018, -2.006, -4.224, -5.446, -7.67, -3.406, -6.155, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -9.835, -6.224, -10.72, -6.705, -9.721, -7.953, -9.623, -6.841, -9.45, -12.424, -8.534, -6.898, -9.451, -9.113, -12.407, -8.863, -8.987, -14.417, -14.535, -13.397, -8.907, -13.013, 268.465, -10.055, -9.618, -7.687, -13.758, -10.084, -11.369, -14.743, -11.398, -9.803, -12.856, -10.55, -12.669, -10.314, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, -6.139, -6.129, -11.887, -4.319, -7.248, -11.158, -8.926, -5.256, -6.949, -3.29, -4.527, -6.873, -6.69, -5.163, -11.1, -7.834, -11.963, -7.001, -8.093, -7.375, -7.497, -4.917, -7.889, -2.616, -4.687, -8.395, -6.876, -6.55, -12.05, -11.227, -9.217, -3.209, -9.3, -7.856, -6.225, -8.236, -8.019, -10.037, -7.64, -6.015, -10.211, -10.372, -16.167, -10.113, -13.826, -7.744, -5.64, -12.453, -7.532, -11.912, -10.182, -11.895, -12.587, -10.122, -6.201, -8.067, -10.365, -11.219, -9.254, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -5.28, -9.346, -10.422, 52.598, -8.648, -8.359, -6.952, -10.184, -8.494, -5.983, -5.968, -3.539, -9.663, -10.226, null] 
        }]
    })
    $('#nucapsirmw_Sea_Temperature_StdDev_506hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 506 hPa Level Statistics, Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 0.996, 1.068, 1.076, 1.064, 1.065, 1.347, 1.192, 1.475, 1.13, 1.045, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 1.298, 1.372, 1.403, 1.372, 1.375, 1.616, 1.449, 1.703, 1.364, 1.345, 1.321, 1.306, 1.237, 1.474, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 1.328, 1.275, 1.441, 1.326, 1.411, 1.573, 1.378, 1.596, 1.408, 1.331, 1.339, 1.319, 1.342, 1.43, 1.296, 1.282, 1.419, 1.499, 1.8, 1.479, 1.335, 1.404, 1.342, 1.528, 1.234, 1.227, 1.3, 1.504, 1.554, 1.848, 2.021, 1.698, 1.653, 1.545, 1.452, 1.57, 1.681, 1.533, 1.637, 1.647, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.989, 1.121, 1.015, 1.065, 1.305, 1.232, 1.622, 1.651, 1.175, 1.144, 1.039, 1.035, 1.177, 1.149, 1.073, 1.211, 1.133, 1.526, 1.574, 1.314, 1.192, 1.28, 1.185, 1.12, 1.124, 1.132, 1.182, 1.198, 1.269, 1.271, 1.382, 1.549, 1.559, 1.239, 1.252, 1.21, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 0.966, 1.079, 1.043, 1.075, 1.068, 1.329, 1.259, 1.429, 1.158, 1.068, 0.982, 1.126, 0.974, 1.121, 1.122, 1.086, 1.204, 1.312, 1.185, 1.137, 1.089, 1.047, 1.082, 1.007, 1.002, 0.918, 1.012, 1.065, 1.057, 1.41, 1.471, 1.122, 1.09, 1.129, 1.002, 1.099, 1.053, 1.016, 1.12, 1.105, 1.126, 1.474, 1.234, 1.146, 1.065, 1.153, 1.151, 1.06, 1.104, 1.101, 1.181, 1.156, 1.145, 1.339, 1.38, 1.324, 1.113, 1.151, 1.15, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.037, 1.053, 1.028, 1.05, 1.004, 1.185, 1.104, 1.257, 1.375, 1.27, 1.182, 1.212, 1.048, 1.055, null] 
        }]
    })
    $('#nucapsirmw_Sea_WaterVapor_StdDev_506hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 506 hPa Level Statistics, Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 27.103, 25.732, 29.868, 29.805, 31.615, 30.697, 29.775, 33.384, 32.566, 34.382, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 29.764, 29.499, 27.307, 28.331, 34.446, 33.553, 34.86, 30.878, 32.708, 32.309, 26.887, 25.89, 28.755, 27.145, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 27.173, 29.945, 27.115, 28.865, 34.586, 32.923, 36.262, 32.672, 29.572, 30.836, 25.887, 27.59, 29.181, 27.612, 28.285, 30.98, 29.295, 36.791, 32.557, 25.672, 28.43, 25.163, 27.476, 29.226, 28.704, 28.309, 27.384, 30.396, 29.349, 28.926, 30.637, 30.872, 26.13, 29.896, 32.071, 27.412, 28.733, 29.194, 28.214, 26.538, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 20.176, 25.476, 30.376, 26.824, 26.458, 29.293, 28.409, 27.472, 28.935, 27.639, 28.907, 27.352, 26.054, 26.779, 24.995, 26.302, 28.64, 26.736, 28.69, 26.883, 27.033, 26.655, 6.872, 24.899, 27.255, 26.049, 24.453, 27.666, 28.853, 25.339, 28.597, 32.702, 27.276, 31.233, 27.353, 28.562, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 26.858, 27.712, 27.377, 29.117, 34.494, 31.383, 32.397, 31.591, 32.947, 31.263, 27.052, 27.769, 29.124, 30.663, 29.026, 35.1, 30.263, 34.699, 29.199, 29.089, 29.078, 27.148, 28.603, 28.975, 27.779, 29.753, 29.217, 33.716, 29.454, 26.711, 28.088, 33.588, 32.168, 29.707, 31.412, 29.732, 27.948, 28.073, 30.264, 30.614, 33.378, 31.803, 22.036, 27.558, 28.547, 31.001, 27.529, 26.968, 30.585, 28.743, 30.245, 31.68, 28.79, 31.944, 36.856, 29.845, 34.786, 31.339, 26.431, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 29.199, 28.146, 28.276, 10.316, 27.81, 28.956, 31.919, 28.644, 30.732, 36.395, 29.873, 36.977, 30.564, 29.731, null] 
        }]
    })
    $('#nucapsirmw_Sea_Temperature_RMS_506hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 506 hPa Level Statistics, Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 0.998, 1.074, 1.085, 1.083, 1.073, 1.365, 1.221, 1.478, 1.147, 1.046, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 1.305, 1.379, 1.403, 1.372, 1.375, 1.617, 1.456, 1.703, 1.368, 1.379, 1.333, 1.306, 1.241, 1.481, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 1.332, 1.275, 1.442, 1.326, 1.411, 1.574, 1.378, 1.596, 1.44, 1.366, 1.344, 1.329, 1.342, 1.43, 1.303, 1.283, 1.422, 1.499, 1.806, 1.485, 1.353, 1.419, 1.343, 1.532, 1.276, 1.27, 1.321, 1.51, 1.58, 1.902, 2.041, 1.709, 1.683, 1.549, 1.475, 1.605, 1.703, 1.543, 1.662, 1.665, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.991, 1.123, 1.032, 1.082, 1.33, 1.243, 1.633, 1.669, 1.202, 1.195, 1.092, 1.066, 1.196, 1.153, 1.096, 1.257, 1.178, 1.554, 1.591, 1.339, 1.245, 1.339, 1.262, 1.174, 1.134, 1.143, 1.202, 1.21, 1.297, 1.296, 1.389, 1.562, 1.633, 1.295, 1.286, 1.257, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 0.973, 1.08, 1.055, 1.085, 1.078, 1.339, 1.272, 1.434, 1.188, 1.082, 0.982, 1.129, 0.977, 1.122, 1.138, 1.126, 1.223, 1.317, 1.198, 1.148, 1.104, 1.048, 1.084, 1.034, 1.002, 0.933, 1.023, 1.104, 1.082, 1.445, 1.498, 1.176, 1.124, 1.148, 1.01, 1.109, 1.067, 1.034, 1.172, 1.183, 1.177, 1.515, 1.251, 1.16, 1.091, 1.187, 1.177, 1.064, 1.114, 1.107, 1.192, 1.179, 1.15, 1.347, 1.416, 1.371, 1.155, 1.161, 1.173, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.037, 1.059, 1.034, 1.058, 1.006, 1.186, 1.106, 1.257, 1.384, 1.271, 1.183, 1.217, 1.051, 1.057, null] 
        }]
    })
    $('#nucapsirmw_Sea_WaterVapor_RMS_506hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 506 hPa Level Statistics, Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 30.855, 29.429, 35.67, 34.036, 38.91, 37.689, 39.181, 39.043, 38.138, 38.27, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 33.284, 33.126, 32.453, 33.612, 41.55, 40.113, 41.368, 35.897, 37.869, 36.583, 29.625, 29.615, 31.927, 32.161, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 30.966, 32.981, 34.465, 33.883, 41.035, 40.748, 42.681, 39.446, 34.683, 34.783, 29.428, 33.981, 33.471, 32.417, 34.341, 36.41, 35.515, 43.142, 39.064, 31.518, 34.164, 30.019, 31.982, 33.173, 31.469, 32.672, 29.83, 32.863, 32.71, 33.044, 34.52, 34.577, 30.839, 32.673, 33.291, 29.81, 31.683, 33.651, 30.955, 30.773, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 25.302, 28.547, 37.247, 30.827, 31.428, 35.02, 35.896, 33.407, 35.103, 34.493, 33.745, 30.513, 30.794, 31.832, 32.216, 31.876, 34.455, 36.754, 38.714, 34.259, 33.275, 35.171, 99.8, 29.421, 32.037, 29.691, 32.259, 33.31, 35.238, 32.867, 34.782, 39.551, 35.189, 38.2, 34.605, 32.861, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 29.961, 30.779, 33.375, 31.948, 39.696, 37.384, 39.171, 36.855, 38.097, 34.372, 29.55, 31.186, 32.897, 33.187, 34.753, 39.817, 37.823, 39.604, 34.119, 32.686, 33.13, 29.624, 32.705, 30.834, 30.211, 34.725, 33.244, 38.073, 35.219, 33.163, 34.233, 37.21, 36.863, 33.726, 34.65, 33.994, 32.884, 33.42, 35.007, 35.1, 39.495, 39.002, 30.505, 33.263, 36.178, 35.563, 30.755, 33.692, 35.055, 35.386, 35.776, 38.737, 35.781, 37.409, 40.458, 34.811, 41.128, 37.068, 31.526, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 32.077, 32.639, 33.183, 99.615, 32.025, 33.006, 36.813, 33.839, 35.531, 41.342, 33.348, 40.165, 35.543, 33.805, null] 
        }]
    })
    $('#nucapsirmw_Land_Temperature_Bias_506hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 506 hPa Level Statistics, Land, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: -5.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 0.006, -0.169, -0.371, -0.413, -0.505, -0.602, -0.562, -0.495, -0.382, -0.254, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 0.151, 0.095, -0.006, 0.079, 0.0, -0.057, -0.051, 0.046, 0.031, 0.026, 0.039, 0.183, 0.144, 0.202, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 0.193, 0.184, 0.122, 0.147, 0.069, -0.015, 0.031, 0.035, 0.014, -0.069, -0.039, 0.131, 0.193, 0.296, 0.188, 0.208, 0.1, 0.172, 0.193, 0.185, -0.025, -0.028, -0.052, 0.057, 0.439, 0.508, 0.542, 0.531, 0.606, 0.663, 0.685, 0.647, 0.568, 0.395, 0.516, 0.712, 0.644, 0.744, 0.69, 0.736, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.087, 0.088, 0.104, 0.078, -0.013, -0.06, -0.104, -0.074, -0.016, -0.038, -0.033, 0.059, 0.128, 0.1, 0.11, 0.051, 0.042, -0.023, -0.059, -0.104, -0.047, -0.078, -0.082, 0.048, 0.115, 0.032, 0.092, 0.0, -0.018, -0.105, -0.058, -0.144, -0.093, -0.134, -0.154, -0.113, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, -0.089, -0.23, -0.373, -0.434, -0.559, -0.644, -0.66, -0.597, -0.501, -0.364, -0.193, -0.012, -0.054, -0.105, -0.316, -0.339, -0.34, -0.373, -0.396, -0.372, -0.411, -0.29, -0.228, -0.213, -0.171, -0.267, -0.327, -0.383, -0.39, -0.398, -0.393, -0.372, -0.374, -0.32, -0.222, -0.143, -0.138, -0.159, -0.297, -0.287, -0.28, -0.311, -0.3, -0.33, -0.352, -0.353, -0.289, -0.22, -0.268, -0.238, -0.322, -0.284, -0.268, -0.278, -0.347, -0.336, -0.367, -0.338, -0.258, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -0.14, -0.152, -0.133, -0.151, -0.098, -0.141, -0.053, 0.011, -0.019, -0.07, -0.147, -0.171, -0.205, -0.197, null] 
        }]
    })
    $('#nucapsirmw_Land_WaterVapor_Bias_506hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 506 hPa Level Statistics, Land, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 50.0,
          min: -50.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, -5.48, -7.724, -11.011, -10.708, -11.613, -10.684, -12.735, -9.968, -9.724, -9.297, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, -3.422, -6.429, -7.93, -6.789, -6.533, -3.269, -2.26, 1.221, -1.545, -3.651, -3.654, -3.565, -3.879, -5.899, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, -4.569, -6.014, -6.711, -7.309, -6.371, -5.023, -4.749, -1.211, -2.472, -7.494, -7.917, -6.319, -5.365, -5.845, -6.205, -4.224, -3.323, -4.147, -1.699, -2.562, -3.738, -6.58, -7.536, -7.05, -4.549, -3.083, -3.331, -3.467, -1.35, -0.384, 2.91, 2.205, -0.232, -1.66, -4.326, -2.77, -1.548, -1.829, -2.99, -4.018, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -6.582, -7.529, -6.699, -6.344, -7.254, -5.71, -3.817, -1.586, -2.244, -5.915, -7.283, -6.293, -7.013, -6.374, -7.45, -8.848, -7.683, -8.674, -7.591, -4.527, -4.376, -6.965, -7.816, -8.563, -6.318, -6.913, -4.871, -2.106, 0.074, 9.293, 27.691, -2.464, -5.588, -6.321, -8.588, -9.535, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, -4.308, -6.489, -9.97, -10.264, -11.043, -9.628, -11.386, -10.247, -8.938, -8.586, -6.696, -4.125, -3.145, -5.994, -8.966, -9.604, -8.891, -9.065, -9.527, -9.942, -8.416, -8.727, -9.167, -7.426, -7.051, -7.036, -9.76, -10.807, -9.104, -10.134, -9.141, -8.542, -9.052, -6.981, -6.495, -6.507, -5.254, -7.741, -9.001, -9.827, -10.454, -11.94, -10.291, -8.217, -8.83, -8.838, -9.348, -7.453, -5.876, -6.61, -5.335, -32.837, 82.293, 2.542, -9.251, -10.185, -9.381, -9.48, -8.522, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -5.51, -6.692, -5.093, -3.786, -4.045, -1.921, -5.968, 21.199, 9.763, 502.47, -5.538, -5.877, -6.824, -5.61, null] 
        }]
    })
    $('#nucapsirmw_Land_Temperature_StdDev_506hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 506 hPa Level Statistics, Land, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.254, 1.364, 1.448, 1.442, 1.568, 1.646, 1.612, 1.602, 1.5, 1.431, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 1.452, 1.526, 1.556, 1.525, 1.646, 1.734, 1.695, 1.689, 1.562, 1.527, 1.518, 1.502, 1.453, 1.558, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 1.453, 1.55, 1.578, 1.541, 1.62, 1.79, 1.697, 1.661, 1.598, 1.57, 1.538, 1.484, 1.503, 1.49, 1.553, 1.591, 1.669, 1.708, 1.723, 1.737, 1.638, 1.633, 1.613, 1.696, 1.525, 1.579, 1.59, 1.697, 1.902, 1.959, 2.025, 2.041, 1.944, 1.952, 2.03, 2.039, 1.99, 1.91, 1.908, 1.936, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.242, 1.311, 1.356, 1.358, 1.39, 1.507, 1.529, 1.607, 1.544, 1.422, 1.336, 1.299, 1.306, 1.349, 1.291, 1.396, 1.467, 1.496, 1.526, 1.516, 1.495, 1.43, 1.39, 1.334, 1.341, 1.327, 1.361, 1.414, 1.48, 1.529, 1.568, 1.532, 1.582, 1.513, 1.443, 1.425, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.238, 1.34, 1.408, 1.405, 1.52, 1.609, 1.587, 1.572, 1.472, 1.43, 1.319, 1.265, 1.263, 1.28, 1.33, 1.415, 1.487, 1.485, 1.519, 1.529, 1.446, 1.361, 1.284, 1.305, 1.255, 1.333, 1.316, 1.365, 1.495, 1.52, 1.534, 1.502, 1.436, 1.348, 1.268, 1.299, 1.281, 1.233, 1.319, 1.433, 1.456, 1.523, 1.495, 1.491, 1.424, 1.405, 1.329, 1.286, 1.274, 1.293, 1.4, 1.445, 1.518, 1.543, 1.52, 1.519, 1.456, 1.393, 1.351, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.361, 1.29, 1.235, 1.233, 1.237, 1.343, 1.415, 1.518, 1.554, 1.52, 1.528, 1.433, 1.363, 1.335, null] 
        }]
    })
    $('#nucapsirmw_Land_WaterVapor_StdDev_506hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 506 hPa Level Statistics, Land, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 31.507, 30.805, 31.814, 33.658, 33.171, 32.876, 35.811, 37.851, 37.499, 34.527, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 32.806, 31.265, 31.638, 35.285, 35.314, 37.14, 41.371, 39.298, 37.069, 33.958, 33.101, 32.136, 33.35, 33.748, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 34.564, 33.594, 32.66, 35.769, 35.496, 37.914, 39.161, 39.394, 39.735, 35.506, 34.031, 33.09, 35.367, 33.991, 34.583, 36.243, 39.356, 36.626, 39.144, 39.603, 38.952, 35.057, 35.809, 34.546, 33.111, 34.054, 33.726, 36.428, 35.832, 37.087, 39.161, 41.367, 39.417, 37.376, 34.565, 35.492, 36.249, 35.432, 36.623, 36.441, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 32.726, 32.261, 32.427, 33.062, 34.765, 35.632, 36.404, 37.814, 38.763, 37.407, 35.462, 34.881, 33.392, 34.541, 32.825, 34.71, 34.48, 33.019, 33.214, 36.631, 37.017, 36.224, 36.109, 32.796, 34.118, 32.615, 28.161, 22.434, 15.95, 9.549, 8.618, 37.241, 37.248, 36.648, 35.248, 32.797, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 31.58, 30.559, 31.992, 35.012, 32.983, 33.504, 35.233, 38.175, 37.898, 34.129, 29.202, 31.484, 33.842, 32.968, 33.905, 33.693, 35.505, 34.251, 34.49, 34.508, 37.52, 31.729, 31.485, 32.362, 31.795, 32.016, 31.994, 34.095, 33.543, 32.728, 33.474, 35.934, 35.498, 35.105, 32.751, 31.489, 32.266, 31.744, 34.471, 33.594, 31.442, 30.341, 33.702, 33.435, 33.406, 33.651, 30.365, 30.681, 38.631, 33.729, 26.963, 2.606, 2.786, 13.503, 34.81, 34.99, 35.042, 33.914, 31.059, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 34.609, 31.245, 31.514, 38.978, 33.664, 26.765, 36.774, 9.398, 13.493, 1.51, 36.523, 35.927, 34.385, 31.967, null] 
        }]
    })
    $('#nucapsirmw_Land_Temperature_RMS_506hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 506 hPa Level Statistics, Land, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.254, 1.374, 1.495, 1.5, 1.647, 1.753, 1.707, 1.677, 1.548, 1.454, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 1.46, 1.529, 1.556, 1.527, 1.646, 1.735, 1.696, 1.69, 1.563, 1.527, 1.518, 1.513, 1.46, 1.571, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 1.465, 1.561, 1.583, 1.548, 1.622, 1.79, 1.697, 1.661, 1.598, 1.572, 1.538, 1.49, 1.516, 1.519, 1.565, 1.604, 1.673, 1.716, 1.734, 1.747, 1.639, 1.633, 1.614, 1.697, 1.587, 1.659, 1.68, 1.779, 1.997, 2.068, 2.138, 2.141, 2.025, 1.992, 2.095, 2.159, 2.091, 2.05, 2.029, 2.072, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.245, 1.314, 1.36, 1.36, 1.39, 1.508, 1.532, 1.609, 1.544, 1.423, 1.336, 1.301, 1.312, 1.352, 1.295, 1.397, 1.468, 1.496, 1.527, 1.52, 1.495, 1.432, 1.392, 1.335, 1.346, 1.327, 1.364, 1.414, 1.48, 1.533, 1.57, 1.539, 1.584, 1.519, 1.451, 1.43, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.241, 1.36, 1.457, 1.471, 1.62, 1.733, 1.719, 1.682, 1.555, 1.476, 1.333, 1.266, 1.264, 1.285, 1.367, 1.455, 1.526, 1.532, 1.57, 1.574, 1.503, 1.392, 1.304, 1.322, 1.266, 1.359, 1.356, 1.418, 1.545, 1.572, 1.584, 1.547, 1.484, 1.386, 1.288, 1.307, 1.289, 1.243, 1.352, 1.461, 1.483, 1.554, 1.525, 1.527, 1.467, 1.449, 1.36, 1.305, 1.303, 1.315, 1.436, 1.473, 1.541, 1.568, 1.559, 1.556, 1.502, 1.434, 1.375, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.368, 1.299, 1.242, 1.242, 1.241, 1.351, 1.416, 1.518, 1.554, 1.521, 1.535, 1.443, 1.378, 1.35, null] 
        }]
    })
    $('#nucapsirmw_Land_WaterVapor_RMS_506hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 506 hPa Level Statistics, Land, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 35.621, 36.333, 39.356, 40.666, 39.788, 39.664, 43.383, 44.468, 44.097, 40.465, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 36.941, 37.62, 39.63, 43.208, 43.174, 44.053, 47.25, 44.536, 42.789, 38.982, 37.929, 35.433, 37.674, 39.605, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 38.796, 38.934, 39.93, 43.885, 43.12, 45.3, 45.66, 45.41, 45.425, 41.411, 39.652, 37.12, 39.579, 39.432, 41.723, 42.667, 45.456, 42.278, 44.66, 45.977, 45.838, 40.772, 40.613, 38.952, 36.841, 38.054, 38.032, 41.3, 39.571, 40.959, 42.576, 45.04, 43.83, 41.441, 38.161, 38.697, 39.447, 38.908, 41.276, 41.123, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 37.107, 37.288, 38.035, 38.128, 40.823, 41.071, 41.313, 42.628, 43.658, 43.499, 41.423, 39.425, 38.051, 39.579, 38.532, 41.517, 40.974, 40.231, 40.314, 42.36, 43.245, 42.289, 42.249, 38.338, 38.623, 37.075, 94.812, 97.154, 98.542, 99.505, 99.684, 41.296, 43.293, 42.528, 41.201, 38.385, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 35.158, 35.381, 38.577, 41.469, 39.441, 39.374, 41.747, 45.016, 44.141, 39.574, 33.665, 34.332, 37.078, 37.449, 39.843, 39.92, 41.166, 39.973, 39.98, 40.613, 43.917, 37.205, 36.806, 36.207, 35.858, 36.609, 37.599, 40.075, 38.66, 38.346, 38.966, 41.485, 41.547, 40.451, 37.126, 35.475, 36.1, 36.597, 40.513, 39.42, 37.573, 37.714, 40.077, 38.983, 39.044, 39.354, 35.217, 34.635, 89.608, 92.017, 95.622, 99.947, 99.961, 99.033, 39.978, 41.205, 41.064, 39.414, 35.184, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 38.88, 34.676, 34.409, 90.079, 92.511, 95.93, 41.659, 99.564, 99.172, 99.991, 40.956, 40.522, 38.656, 35.272, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_Temperature_Bias_506hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 506 hPa Level Statistics, Land and Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: -5.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 0.019, -0.153, -0.322, -0.359, -0.447, -0.53, -0.502, -0.431, -0.356, -0.239, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 0.148, 0.063, -0.002, 0.073, 0.017, -0.038, -0.037, 0.026, -0.006, 0.001, 0.002, 0.155, 0.123, 0.16, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 0.176, 0.149, 0.118, 0.141, 0.068, -0.013, 0.022, 0.014, -0.024, -0.099, -0.054, 0.104, 0.166, 0.256, 0.171, 0.19, 0.096, 0.151, 0.184, 0.139, -0.058, -0.042, -0.068, 0.042, 0.438, 0.494, 0.52, 0.514, 0.599, 0.662, 0.658, 0.609, 0.519, 0.383, 0.475, 0.662, 0.628, 0.701, 0.644, 0.68, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.044, 0.072, 0.074, 0.058, -0.021, -0.05, -0.089, -0.07, -0.033, -0.071, -0.065, 0.025, 0.097, 0.083, 0.082, 0.005, -0.003, -0.061, -0.071, -0.113, -0.084, -0.118, -0.124, -0.001, 0.062, 0.0, 0.054, -0.024, -0.038, -0.104, -0.059, -0.147, -0.115, -0.152, -0.168, -0.132, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, -0.059, -0.201, -0.32, -0.375, -0.49, -0.566, -0.575, -0.525, -0.463, -0.348, -0.162, -0.004, -0.044, -0.087, -0.288, -0.307, -0.298, -0.338, -0.333, -0.334, -0.358, -0.243, -0.198, -0.187, -0.138, -0.237, -0.289, -0.348, -0.353, -0.35, -0.359, -0.344, -0.347, -0.289, -0.199, -0.139, -0.116, -0.144, -0.29, -0.279, -0.274, -0.281, -0.27, -0.308, -0.324, -0.33, -0.263, -0.203, -0.24, -0.215, -0.292, -0.268, -0.23, -0.235, -0.318, -0.312, -0.332, -0.301, -0.242, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -0.114, -0.135, -0.12, -0.134, -0.081, -0.126, -0.046, 0.022, 0.005, -0.056, -0.127, -0.149, -0.168, -0.165, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_WaterVapor_Bias_506hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 506 hPa Level Statistics, Land and Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 50.0,
          min: -50.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, -5.533, -7.105, -10.224, -9.893, -11.42, -11.762, -12.32, -9.275, -9.148, -9.214, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, -3.73, -6.027, -7.965, -6.733, -7.04, -4.906, -2.999, -0.579, -2.4, -3.72, -4.093, -3.931, -4.098, -5.872, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, -4.96, -5.996, -7.09, -6.848, -7.0, -6.488, -5.505, -2.684, -3.675, -7.287, -7.549, -6.532, -5.695, -6.193, -6.665, -5.032, -4.039, -5.059, -3.12, -4.175, -4.622, -6.84, -7.345, -6.954, -4.762, -3.88, -4.235, -4.199, -2.657, -1.952, -1.222, -0.828, -3.055, -3.696, -5.018, -3.703, -2.957, -3.184, -3.702, -4.886, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -6.077, -7.481, -7.169, -6.762, -8.233, -6.91, -5.217, -3.426, -4.304, -7.3, -7.899, -7.297, -7.622, -7.244, -8.12, -9.276, -9.017, -10.716, -9.302, -7.098, -6.259, -8.887, -6.151, -9.554, -7.48, -7.37, -6.612, -4.736, -4.511, 1.42, 12.946, -4.988, -7.207, -7.683, -9.729, -9.771, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, -4.465, -5.895, -9.097, -8.992, -10.33, -10.507, -10.772, -8.994, -8.176, -7.837, -6.229, -4.405, -3.635, -5.79, -8.334, -9.462, -9.081, -9.707, -9.258, -9.009, -7.831, -8.09, -8.616, -6.794, -6.898, -7.06, -9.07, -10.193, -9.287, -10.452, -10.084, -8.754, -9.513, -7.481, -7.466, -7.26, -6.501, -8.633, -9.394, -10.279, -11.507, -12.996, -11.481, -9.371, -10.118, -9.815, -12.381, -8.523, -6.713, -7.934, -4.787, -27.537, 29.565, -3.604, -9.783, -10.638, -9.773, -10.056, -8.868, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -3.279, -7.262, -6.312, -3.347, -5.32, -1.834, -7.757, 14.863, 1.968, 106.88, -6.562, -6.481, -7.535, -6.545, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_Temperature_StdDev_506hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 506 hPa Level Statistics, Land and Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.227, 1.328, 1.419, 1.419, 1.536, 1.611, 1.581, 1.567, 1.464, 1.401, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 1.437, 1.508, 1.55, 1.535, 1.634, 1.724, 1.662, 1.686, 1.553, 1.512, 1.501, 1.478, 1.439, 1.552, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 1.441, 1.527, 1.566, 1.528, 1.605, 1.748, 1.658, 1.633, 1.576, 1.54, 1.508, 1.465, 1.484, 1.476, 1.53, 1.567, 1.659, 1.671, 1.707, 1.693, 1.623, 1.6, 1.591, 1.669, 1.485, 1.54, 1.565, 1.668, 1.879, 1.938, 1.999, 1.996, 1.914, 1.919, 1.977, 2.0, 1.954, 1.896, 1.898, 1.915, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.211, 1.286, 1.33, 1.324, 1.367, 1.472, 1.507, 1.57, 1.488, 1.386, 1.305, 1.271, 1.28, 1.313, 1.267, 1.367, 1.445, 1.469, 1.5, 1.481, 1.457, 1.399, 1.37, 1.317, 1.313, 1.3, 1.343, 1.389, 1.457, 1.499, 1.532, 1.511, 1.544, 1.477, 1.415, 1.396, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.208, 1.311, 1.381, 1.379, 1.484, 1.573, 1.559, 1.543, 1.439, 1.393, 1.289, 1.235, 1.239, 1.251, 1.3, 1.383, 1.463, 1.457, 1.494, 1.477, 1.413, 1.332, 1.246, 1.267, 1.231, 1.298, 1.293, 1.345, 1.461, 1.502, 1.505, 1.462, 1.404, 1.318, 1.239, 1.266, 1.259, 1.223, 1.302, 1.4, 1.421, 1.496, 1.459, 1.461, 1.399, 1.373, 1.302, 1.26, 1.25, 1.274, 1.367, 1.404, 1.487, 1.508, 1.492, 1.497, 1.423, 1.357, 1.321, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.32, 1.259, 1.206, 1.204, 1.219, 1.307, 1.373, 1.474, 1.516, 1.48, 1.485, 1.394, 1.328, 1.301, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_WaterVapor_StdDev_506hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 506 hPa Level Statistics, Land and Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 30.906, 30.518, 30.181, 30.682, 28.925, 28.058, 33.037, 34.583, 35.475, 32.967, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 32.005, 30.991, 30.655, 32.756, 33.007, 34.314, 37.892, 34.952, 34.463, 32.998, 31.893, 31.339, 32.422, 32.664, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 33.251, 32.717, 31.41, 33.733, 32.988, 34.378, 36.725, 35.322, 36.102, 34.257, 32.795, 32.059, 33.881, 32.42, 32.511, 33.051, 35.451, 34.472, 34.668, 33.782, 34.87, 32.372, 33.952, 33.279, 31.872, 32.201, 30.932, 31.861, 32.145, 32.762, 33.647, 36.325, 34.732, 33.287, 31.57, 33.576, 34.209, 33.32, 33.687, 33.191, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 31.738, 31.093, 31.247, 30.783, 30.928, 31.915, 32.192, 33.735, 34.661, 33.749, 32.418, 32.133, 31.789, 32.571, 30.992, 31.847, 31.228, 29.811, 30.568, 32.637, 32.982, 32.538, 26.314, 30.711, 32.177, 31.33, 31.378, 26.277, 20.263, 13.133, 11.366, 33.207, 33.625, 33.63, 32.596, 31.22, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 30.911, 30.372, 30.304, 31.429, 28.665, 28.588, 32.717, 34.842, 35.903, 32.73, 28.907, 30.783, 32.696, 31.541, 31.774, 30.581, 31.306, 30.489, 30.046, 30.63, 33.393, 29.574, 30.35, 31.321, 30.899, 30.868, 29.837, 30.972, 30.365, 28.446, 30.025, 32.551, 32.523, 32.132, 30.416, 30.094, 30.847, 30.17, 31.803, 31.152, 29.118, 28.127, 31.046, 30.5, 31.093, 31.325, 23.298, 29.303, 41.419, 37.104, 24.297, 3.529, 4.223, 18.972, 31.293, 31.99, 32.523, 31.53, 29.69, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 29.891, 29.438, 30.253, 33.904, 37.327, 24.035, 32.607, 11.147, 18.618, 2.098, 32.863, 33.244, 31.784, 30.029, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_Temperature_RMS_506hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 506 hPa Level Statistics, Land and Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.228, 1.337, 1.455, 1.464, 1.6, 1.696, 1.659, 1.625, 1.507, 1.422, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 1.445, 1.509, 1.55, 1.537, 1.634, 1.725, 1.662, 1.687, 1.554, 1.512, 1.501, 1.486, 1.444, 1.561, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 1.451, 1.535, 1.571, 1.534, 1.606, 1.748, 1.658, 1.633, 1.576, 1.543, 1.509, 1.469, 1.494, 1.498, 1.54, 1.579, 1.662, 1.678, 1.717, 1.699, 1.624, 1.601, 1.592, 1.669, 1.549, 1.618, 1.649, 1.746, 1.972, 2.048, 2.105, 2.087, 1.983, 1.957, 2.033, 2.107, 2.053, 2.022, 2.004, 2.033, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.212, 1.288, 1.332, 1.325, 1.367, 1.473, 1.51, 1.571, 1.488, 1.387, 1.306, 1.271, 1.284, 1.315, 1.269, 1.367, 1.445, 1.47, 1.502, 1.485, 1.459, 1.404, 1.375, 1.317, 1.315, 1.3, 1.344, 1.389, 1.458, 1.503, 1.533, 1.518, 1.548, 1.485, 1.425, 1.402, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.21, 1.326, 1.417, 1.429, 1.563, 1.672, 1.662, 1.63, 1.512, 1.436, 1.3, 1.235, 1.239, 1.254, 1.332, 1.417, 1.494, 1.496, 1.531, 1.514, 1.458, 1.354, 1.262, 1.281, 1.239, 1.319, 1.325, 1.389, 1.503, 1.542, 1.547, 1.502, 1.446, 1.35, 1.255, 1.274, 1.264, 1.232, 1.334, 1.428, 1.447, 1.522, 1.483, 1.493, 1.436, 1.413, 1.329, 1.276, 1.272, 1.292, 1.398, 1.429, 1.505, 1.527, 1.526, 1.529, 1.461, 1.39, 1.344, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.325, 1.267, 1.212, 1.212, 1.221, 1.314, 1.374, 1.474, 1.516, 1.481, 1.49, 1.402, 1.338, 1.312, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_WaterVapor_RMS_506hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 506 hPa Level Statistics, Land and Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 34.743, 35.227, 36.205, 36.019, 34.557, 34.343, 39.79, 39.955, 40.882, 38.398, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 36.047, 36.629, 37.916, 39.612, 40.39, 41.366, 43.66, 40.134, 39.646, 37.819, 36.493, 34.703, 36.542, 38.065, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 37.491, 37.771, 38.264, 40.509, 40.374, 41.983, 43.339, 41.159, 41.538, 39.963, 38.055, 36.157, 38.07, 37.607, 38.932, 39.162, 41.375, 40.397, 40.369, 39.361, 40.833, 37.667, 38.56, 37.688, 35.363, 35.965, 34.884, 35.826, 35.813, 36.293, 37.703, 40.326, 39.245, 37.289, 34.914, 36.796, 37.55, 36.926, 37.811, 37.565, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 35.903, 35.789, 36.57, 35.469, 36.349, 37.341, 37.226, 38.559, 39.728, 39.645, 38.0, 36.802, 36.548, 37.735, 36.747, 38.416, 38.027, 37.785, 37.986, 38.937, 39.119, 39.124, 95.555, 36.426, 36.927, 35.893, 93.083, 95.686, 97.373, 98.963, 99.329, 38.146, 39.76, 39.773, 38.795, 36.652, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 34.266, 34.474, 35.475, 36.154, 33.699, 34.042, 38.473, 40.037, 41.01, 37.312, 32.883, 33.603, 35.82, 35.355, 36.454, 35.616, 36.273, 35.8, 34.824, 35.051, 38.019, 33.944, 35.017, 34.796, 34.662, 35.074, 34.421, 35.712, 35.137, 33.686, 35.588, 37.554, 38.031, 37.015, 34.878, 34.286, 35.012, 35.24, 37.607, 37.05, 35.672, 35.669, 37.611, 36.074, 36.94, 37.173, 96.494, 33.641, 86.71, 89.379, 96.497, 99.911, 99.896, 97.823, 36.483, 38.103, 38.254, 36.943, 33.903, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 94.609, 32.966, 33.521, 92.96, 89.933, 96.73, 37.725, 99.455, 98.115, 99.978, 37.146, 37.577, 36.007, 33.485, null] 
        }]
    })
    $('#nucapsirmw_Sea_Temperature_Bias_743hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 743 hPa Level Statistics, Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: -5.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, -0.083, -0.089, -0.168, -0.148, 0.033, 0.138, -0.216, -0.461, -0.105, -0.184, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, -0.486, -0.538, -0.472, -0.374, -0.334, -0.236, -0.198, -0.44, -0.302, -0.473, -0.631, -0.569, -0.544, -0.531, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, -0.526, -0.416, -0.429, -0.374, -0.273, -0.148, -0.223, -0.177, -0.163, -0.36, -0.642, -0.622, -0.623, -0.522, -0.336, -0.359, -0.161, -0.36, -0.273, -0.337, -0.423, -0.453, -0.544, -0.471, -0.072, -0.07, -0.142, -0.033, 0.049, 0.088, 0.439, 0.243, 0.291, 0.235, -0.06, 0.06, -0.008, 0.019, -0.094, 0.041, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -0.211, -0.289, -0.133, -0.159, -0.262, -0.102, -0.226, -0.173, -0.136, -0.078, 0.017, -0.088, -0.094, -0.143, -0.1, -0.09, -0.073, -0.309, -0.164, 0.009, 0.002, 0.04, 0.116, -0.066, 0.078, 0.105, 0.001, 0.117, -0.078, 0.156, 0.016, 0.078, 0.036, 0.213, 0.219, 0.417, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 0.026, 0.05, -0.004, -0.026, 0.278, 0.274, 0.061, -0.047, 0.089, 0.122, 0.021, 0.035, 0.105, 0.261, 0.339, 0.203, 0.447, 0.223, -0.016, 0.246, 0.292, 0.375, 0.254, 0.301, 0.125, 0.209, 0.318, 0.24, 0.422, -0.07, 0.284, 0.231, 0.348, 0.317, 0.26, 0.263, 0.117, 0.108, 0.238, 0.216, 0.018, 0.024, 0.382, 0.285, 0.222, 0.246, 0.065, 0.088, 0.058, 0.055, 0.167, 0.132, 0.248, 0.253, 0.039, 0.248, 0.195, 0.242, 0.18, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -0.341, -0.447, -0.271, -0.316, -0.366, -0.27, -0.304, -0.231, -0.203, -0.477, -0.208, -0.306, -0.238, -0.319, null] 
        }]
    })
    $('#nucapsirmw_Sea_WaterVapor_Bias_743hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 743 hPa Level Statistics, Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 50.0,
          min: -50.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, -4.742, -2.325, -0.464, -3.123, -8.238, -12.68, -10.493, -13.35, -5.194, -6.493, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 2.75, 2.612, 2.699, 2.004, -0.355, -3.588, -7.192, -5.717, 6.56, 5.938, -0.363, -0.842, -0.145, 6.373, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 3.288, 2.184, -4.82, 0.105, -2.291, -5.677, -6.042, -5.555, 1.811, 0.711, -1.244, -1.369, 0.661, -0.083, 4.158, -1.956, -5.853, -2.404, -8.279, -4.054, -0.413, 1.751, -0.728, 0.079, 3.714, 2.833, 5.318, 2.566, 2.596, 0.065, 7.864, 5.262, 2.64, 4.417, 5.633, 4.33, 5.036, 2.04, 3.693, 1.732, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.018, 3.393, -0.663, 0.271, -0.325, -6.282, -5.443, -5.51, -0.806, -0.841, 1.568, 3.237, -1.121, 2.798, 1.235, -0.672, 0.595, -2.892, -4.368, -5.014, -1.067, 2.732, -1.027, -3.381, 0.213, -2.292, -0.838, 1.475, -3.363, -1.166, -1.337, -6.83, -7.332, -4.535, 1.101, 0.513, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, -1.852, -1.5, 0.401, -0.516, -3.563, -5.946, -5.735, -6.078, -1.095, -1.298, -4.511, -4.125, -2.336, -1.0, -0.901, 1.731, -4.657, -5.518, -6.846, -4.609, -1.496, -0.132, -4.034, -2.644, -0.841, -4.885, -1.488, -1.47, -4.892, -3.023, -5.66, -4.764, -4.988, -2.492, -0.799, -6.258, -5.127, -5.251, -4.857, -3.635, -5.897, -10.086, -11.157, -8.213, -5.808, -5.466, -12.56, -7.384, 17.922, -5.818, -8.818, -8.973, -9.338, -11.787, -14.34, -13.539, -11.497, -10.549, -11.017, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -1.773, -7.198, -3.59, 32.891, -0.671, -1.704, -3.857, -3.908, -6.597, -7.642, -8.102, -6.865, -6.728, -6.657, null] 
        }]
    })
    $('#nucapsirmw_Sea_Temperature_StdDev_743hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 743 hPa Level Statistics, Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.156, 1.141, 1.376, 1.354, 1.506, 1.76, 1.521, 1.412, 1.385, 1.143, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 1.429, 1.416, 1.631, 1.495, 1.524, 1.804, 1.724, 1.59, 1.544, 1.475, 1.43, 1.392, 1.409, 1.374, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 1.459, 1.337, 1.636, 1.36, 1.646, 1.882, 1.962, 1.493, 1.648, 1.369, 1.601, 1.525, 1.532, 1.659, 1.513, 1.475, 1.854, 1.859, 1.714, 1.523, 1.508, 1.545, 1.434, 1.436, 1.223, 1.275, 1.228, 1.303, 1.563, 1.681, 1.974, 1.452, 1.522, 1.435, 1.523, 1.635, 1.563, 1.509, 1.498, 1.395, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.217, 1.233, 1.226, 1.234, 1.288, 1.593, 1.667, 1.575, 1.376, 1.29, 1.156, 1.154, 1.274, 1.293, 1.309, 1.338, 1.343, 1.546, 1.593, 1.553, 1.398, 1.324, 1.348, 1.484, 1.369, 1.424, 1.27, 1.375, 1.394, 1.638, 1.468, 1.577, 1.593, 1.445, 1.602, 1.468, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.213, 1.397, 1.315, 1.301, 1.594, 1.735, 1.523, 1.408, 1.421, 1.068, 1.114, 1.148, 1.187, 1.25, 1.322, 1.279, 1.548, 1.686, 1.454, 1.348, 1.16, 1.235, 1.301, 1.17, 1.125, 1.301, 1.269, 1.328, 1.516, 1.474, 1.449, 1.36, 1.368, 1.318, 1.186, 1.309, 1.259, 1.285, 1.239, 1.318, 1.349, 1.424, 1.496, 1.351, 1.279, 1.313, 1.646, 1.288, 1.184, 1.159, 1.299, 1.271, 1.576, 1.355, 1.3, 1.462, 1.344, 1.308, 1.284, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.178, 1.678, 1.305, 1.115, 1.181, 1.223, 1.345, 1.516, 1.374, 1.3, 1.493, 1.295, 1.273, 1.279, null] 
        }]
    })
    $('#nucapsirmw_Sea_WaterVapor_StdDev_743hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 743 hPa Level Statistics, Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 21.428, 22.461, 29.294, 28.92, 31.351, 34.545, 31.003, 29.035, 30.086, 28.228, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 22.632, 23.593, 30.176, 27.336, 29.39, 34.47, 31.967, 31.201, 29.291, 30.39, 22.51, 21.457, 22.38, 25.097, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 23.407, 24.268, 28.783, 27.215, 28.868, 33.727, 30.005, 26.834, 28.539, 26.452, 22.266, 22.491, 22.714, 24.831, 29.956, 29.404, 30.081, 31.413, 28.046, 27.893, 26.536, 27.376, 25.152, 25.367, 22.156, 23.942, 25.829, 25.315, 26.92, 32.465, 35.534, 26.648, 27.375, 24.206, 26.64, 23.237, 22.394, 23.136, 23.911, 26.002, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 22.534, 24.055, 24.855, 25.04, 26.531, 27.007, 32.679, 34.165, 29.904, 25.015, 24.249, 24.72, 24.148, 23.023, 26.211, 24.674, 25.415, 30.764, 32.362, 28.506, 26.861, 28.632, 25.237, 25.35, 22.984, 23.402, 22.576, 27.221, 25.159, 30.097, 30.056, 35.536, 30.997, 27.832, 26.978, 26.707, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 21.841, 24.497, 27.464, 28.638, 29.981, 33.664, 28.841, 29.625, 31.547, 28.111, 21.203, 21.938, 22.955, 24.535, 29.296, 31.001, 29.37, 30.083, 31.528, 29.146, 26.907, 26.832, 23.432, 22.554, 24.204, 26.699, 26.143, 27.342, 26.914, 31.761, 34.055, 29.104, 24.287, 25.365, 27.162, 24.384, 19.895, 23.504, 22.922, 26.193, 31.323, 29.462, 27.593, 24.628, 26.168, 26.104, 24.063, 22.036, 13.998, 22.532, 26.412, 25.452, 29.161, 27.767, 30.588, 26.431, 26.096, 25.725, 21.533, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 23.402, 25.993, 21.687, 13.953, 23.458, 27.621, 25.689, 30.187, 30.169, 31.836, 28.517, 28.94, 27.21, 23.829, null] 
        }]
    })
    $('#nucapsirmw_Sea_Temperature_RMS_743hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 743 hPa Level Statistics, Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.159, 1.145, 1.386, 1.362, 1.507, 1.765, 1.536, 1.485, 1.389, 1.158, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 1.509, 1.515, 1.698, 1.541, 1.56, 1.82, 1.735, 1.65, 1.574, 1.55, 1.563, 1.504, 1.51, 1.474, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 1.551, 1.4, 1.692, 1.41, 1.668, 1.888, 1.974, 1.504, 1.656, 1.415, 1.725, 1.647, 1.654, 1.74, 1.55, 1.518, 1.861, 1.894, 1.736, 1.56, 1.566, 1.611, 1.534, 1.512, 1.226, 1.277, 1.236, 1.303, 1.564, 1.683, 2.022, 1.473, 1.55, 1.454, 1.525, 1.637, 1.563, 1.509, 1.501, 1.395, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.235, 1.267, 1.234, 1.244, 1.315, 1.596, 1.683, 1.584, 1.383, 1.292, 1.156, 1.157, 1.277, 1.301, 1.313, 1.342, 1.344, 1.577, 1.601, 1.553, 1.398, 1.325, 1.353, 1.485, 1.371, 1.428, 1.27, 1.38, 1.396, 1.646, 1.468, 1.579, 1.593, 1.461, 1.617, 1.526, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.213, 1.398, 1.315, 1.301, 1.618, 1.757, 1.525, 1.409, 1.424, 1.076, 1.114, 1.149, 1.192, 1.277, 1.365, 1.295, 1.612, 1.701, 1.454, 1.371, 1.196, 1.291, 1.326, 1.209, 1.132, 1.318, 1.308, 1.35, 1.574, 1.476, 1.477, 1.379, 1.412, 1.356, 1.214, 1.336, 1.264, 1.29, 1.262, 1.336, 1.349, 1.424, 1.544, 1.381, 1.298, 1.336, 1.648, 1.291, 1.185, 1.161, 1.31, 1.278, 1.596, 1.379, 1.301, 1.483, 1.358, 1.33, 1.297, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.227, 1.737, 1.333, 1.159, 1.236, 1.253, 1.379, 1.534, 1.388, 1.385, 1.508, 1.331, 1.295, 1.318, null] 
        }]
    })
    $('#nucapsirmw_Sea_WaterVapor_RMS_743hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 743 hPa Level Statistics, Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 22.794, 23.028, 29.708, 30.311, 34.649, 39.547, 35.342, 33.576, 32.312, 30.975, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 22.711, 23.679, 30.75, 27.67, 30.839, 37.263, 35.615, 33.172, 29.382, 30.45, 23.034, 22.105, 22.954, 25.1, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 23.479, 24.533, 30.984, 27.805, 30.558, 37.262, 33.184, 28.542, 29.013, 27.067, 23.035, 23.311, 23.256, 25.516, 30.156, 30.666, 32.983, 33.611, 32.524, 30.124, 27.783, 27.957, 25.779, 25.899, 22.188, 24.134, 25.885, 25.752, 27.341, 33.582, 35.668, 26.97, 27.78, 24.33, 26.665, 23.326, 22.411, 23.465, 24.125, 26.632, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 22.792, 24.171, 25.632, 25.738, 27.415, 29.627, 35.951, 37.408, 31.154, 26.041, 24.837, 24.882, 25.228, 23.221, 26.796, 25.704, 25.987, 32.801, 35.021, 32.012, 28.095, 29.303, 26.125, 27.118, 23.526, 24.602, 23.175, 27.839, 26.623, 31.223, 31.273, 38.818, 33.901, 29.633, 27.29, 27.216, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 22.666, 25.501, 28.141, 29.632, 32.21, 36.794, 32.305, 32.244, 33.016, 29.494, 23.078, 23.52, 24.174, 25.351, 30.437, 31.753, 31.507, 32.875, 35.122, 31.764, 28.175, 27.818, 24.859, 23.638, 25.119, 29.079, 27.553, 28.809, 29.198, 34.387, 37.132, 31.639, 26.531, 26.798, 28.501, 27.164, 22.288, 25.756, 25.494, 28.46, 34.268, 34.24, 32.095, 27.898, 29.463, 28.717, 30.995, 25.263, 99.448, 24.882, 30.089, 29.207, 33.06, 33.25, 37.517, 32.183, 30.848, 30.184, 25.964, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 24.545, 29.787, 22.914, 99.683, 24.037, 28.994, 27.474, 31.773, 32.526, 35.564, 31.277, 31.702, 29.828, 25.738, null] 
        }]
    })
    $('#nucapsirmw_Land_Temperature_Bias_743hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 743 hPa Level Statistics, Land, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: -5.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 0.172, 0.301, 0.261, 0.134, 0.064, 0.157, 0.138, -0.019, -0.128, -0.111, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, -0.379, -0.379, -0.231, -0.053, 0.199, 0.271, 0.238, 0.127, 0.047, -0.233, -0.451, -0.554, -0.483, -0.534, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, -0.321, -0.355, -0.223, -0.106, -0.005, 0.102, 0.052, 0.018, -0.117, -0.306, -0.38, -0.367, -0.398, -0.468, -0.284, -0.236, -0.09, -0.168, 0.054, -0.114, -0.21, -0.258, -0.412, -0.241, -0.102, -0.141, -0.014, 0.121, 0.268, 0.276, 0.245, 0.237, 0.234, 0.181, 0.065, 0.008, -0.076, -0.186, 0.021, -0.061, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.291, 0.153, 0.069, 0.103, 0.201, 0.302, 0.199, 0.166, 0.064, 0.106, 0.16, 0.253, 0.227, 0.121, -0.007, 0.102, 0.09, -0.012, 0.051, 0.175, 0.093, 0.134, 0.285, 0.41, 0.372, 0.207, 0.124, 0.06, 0.159, 0.245, 0.229, 0.227, 0.066, 0.155, 0.36, 0.397, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 0.414, 0.497, 0.515, 0.423, 0.408, 0.424, 0.315, 0.32, 0.298, 0.332, 0.3, 0.315, 0.392, 0.312, 0.466, 0.59, 0.601, 0.498, 0.48, 0.462, 0.456, 0.527, 0.536, 0.565, 0.443, 0.52, 0.534, 0.718, 0.762, 0.613, 0.562, 0.483, 0.538, 0.509, 0.535, 0.448, 0.353, 0.396, 0.559, 0.622, 0.584, 0.582, 0.37, 0.312, 0.272, 0.302, 0.224, 0.05, -0.03, 0.07, 0.168, 0.259, 0.345, 0.255, 0.229, 0.188, 0.209, 0.305, 0.208, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -0.271, -0.275, -0.422, -0.484, -0.412, -0.339, -0.222, -0.198, -0.293, -0.311, -0.297, -0.345, -0.218, -0.332, null] 
        }]
    })
    $('#nucapsirmw_Land_WaterVapor_Bias_743hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 743 hPa Level Statistics, Land, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 50.0,
          min: -50.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, -3.95, -4.053, -2.135, -3.285, -5.538, -5.304, -7.858, -5.557, -3.7, -3.762, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 1.778, 2.569, 4.809, 3.583, 2.808, 5.517, 2.725, 2.326, 4.783, 4.155, 4.951, 2.904, 1.711, -1.421, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 0.269, -0.657, -1.083, -4.015, -2.944, -1.074, -1.137, -3.11, 0.613, 2.572, 4.812, 2.43, 0.121, -1.157, -1.721, -4.152, -2.334, -1.58, -2.116, -0.272, 1.514, 3.135, 3.063, 0.924, -1.298, -1.958, -1.988, -6.632, -4.879, -2.937, -1.597, -1.189, 0.216, 1.985, 1.403, 0.773, -1.535, -2.725, -4.729, -3.017, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.69, -0.942, -1.632, -1.055, -6.325, -5.849, -5.006, -4.477, -1.123, 1.495, 3.977, 3.97, 0.425, -2.216, -2.411, -3.652, -2.481, -3.298, -4.559, -2.313, -1.245, 2.966, 5.205, 2.637, -0.073, -3.194, -4.692, -1.479, -3.631, 0.998, 33.96, 1.954, 1.279, 3.898, 13.084, 1.34, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 2.292, 3.289, 5.143, 4.025, 2.106, 2.914, 0.035, -0.843, 1.191, 1.26, 3.552, 3.5, 3.785, 4.4, 4.908, 2.157, 1.842, 0.56, -0.055, 1.537, 4.227, 5.69, 6.013, 3.429, 2.886, 4.146, 5.049, -0.402, -1.629, -0.212, -1.44, 0.11, 0.983, 3.625, 4.07, 1.912, 1.533, 1.053, 0.24, -0.05, -0.211, -1.575, -2.234, -2.245, -0.721, 0.709, -0.37, -2.192, -3.971, -4.566, -1.477, -4.53, -2.059, 18.653, -1.334, -2.493, -1.838, 4.129, -3.728, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 3.714, 1.78, 0.995, -0.014, -0.091, 3.391, 0.322, 4.755, 19.522, 2.431, 1.105, 3.313, 7.824, 0.271, null] 
        }]
    })
    $('#nucapsirmw_Land_Temperature_StdDev_743hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 743 hPa Level Statistics, Land, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.678, 1.656, 1.74, 1.828, 2.016, 2.15, 2.131, 2.057, 1.978, 1.879, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 1.857, 1.879, 1.979, 1.992, 2.213, 2.345, 2.256, 2.13, 1.989, 1.883, 1.838, 1.92, 1.842, 2.026, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 1.913, 1.925, 2.048, 2.043, 2.179, 2.308, 2.22, 2.166, 2.136, 1.945, 1.894, 1.932, 1.872, 1.868, 2.051, 2.116, 2.194, 2.164, 2.179, 2.162, 2.145, 2.023, 1.9, 1.931, 1.713, 1.8, 1.788, 1.922, 2.047, 2.103, 2.109, 2.109, 2.101, 1.968, 1.916, 1.938, 1.957, 1.893, 1.915, 1.951, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.662, 1.633, 1.703, 1.686, 1.839, 1.922, 1.94, 1.972, 1.871, 1.86, 1.722, 1.705, 1.685, 1.704, 1.645, 1.692, 1.855, 1.901, 1.97, 1.917, 1.849, 1.84, 1.801, 1.734, 1.699, 1.689, 1.677, 1.728, 1.856, 1.926, 2.044, 2.0, 1.894, 1.923, 1.828, 1.788, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.752, 1.687, 1.753, 1.837, 2.037, 2.134, 2.12, 2.043, 1.966, 1.853, 1.738, 1.751, 1.625, 1.558, 1.668, 1.763, 1.966, 1.859, 1.86, 1.876, 1.848, 1.721, 1.602, 1.668, 1.602, 1.656, 1.641, 1.743, 1.904, 1.911, 1.91, 1.832, 1.857, 1.73, 1.631, 1.634, 1.68, 1.571, 1.666, 1.827, 1.863, 1.926, 1.842, 1.86, 1.804, 1.827, 1.729, 1.632, 1.662, 1.622, 1.675, 1.743, 1.883, 1.907, 1.887, 1.889, 1.859, 1.807, 1.697, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.855, 1.745, 1.671, 1.648, 1.596, 1.673, 1.736, 1.872, 1.963, 1.916, 1.895, 1.882, 1.802, 1.687, null] 
        }]
    })
    $('#nucapsirmw_Land_WaterVapor_StdDev_743hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 743 hPa Level Statistics, Land, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 25.457, 27.873, 30.221, 33.665, 34.914, 34.591, 34.035, 33.197, 32.266, 28.469, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 24.899, 27.636, 31.917, 33.967, 37.31, 38.9, 36.409, 32.615, 31.472, 28.483, 26.782, 23.966, 24.779, 27.261, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 25.766, 27.855, 30.6, 32.208, 34.671, 35.861, 34.138, 31.398, 31.041, 29.089, 28.798, 25.117, 25.294, 27.863, 30.393, 31.701, 35.017, 32.336, 32.889, 32.472, 32.095, 31.962, 28.611, 27.321, 23.876, 27.724, 30.687, 31.633, 31.768, 34.58, 34.427, 34.044, 31.492, 28.948, 27.39, 26.074, 26.502, 26.973, 29.931, 31.477, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 25.501, 25.272, 28.333, 30.447, 30.531, 31.454, 33.691, 33.448, 32.138, 31.347, 29.555, 28.873, 27.072, 26.535, 27.013, 29.65, 31.941, 33.236, 32.494, 32.383, 31.008, 31.656, 32.569, 29.175, 27.155, 25.405, 26.26, 31.293, 33.123, 28.774, 8.603, 37.615, 42.361, 46.839, 27.656, 27.895, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 25.151, 27.995, 30.887, 33.7, 35.146, 34.775, 33.27, 32.189, 31.54, 28.803, 27.505, 26.379, 26.555, 29.393, 31.742, 32.708, 35.214, 34.075, 33.832, 33.217, 33.483, 33.228, 29.548, 27.746, 25.726, 29.647, 32.155, 32.202, 32.24, 33.27, 33.796, 32.8, 31.399, 30.146, 29.205, 26.901, 27.247, 27.211, 30.494, 32.483, 33.183, 32.584, 30.938, 29.833, 30.688, 30.968, 27.971, 25.393, 24.436, 25.314, 31.148, 31.785, 36.545, 10.809, 42.845, 46.234, 47.723, 31.567, 26.079, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 30.824, 28.294, 25.663, 25.103, 26.018, 32.164, 32.794, 32.82, 11.208, 44.017, 32.084, 49.612, 33.909, 26.827, null] 
        }]
    })
    $('#nucapsirmw_Land_Temperature_RMS_743hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 743 hPa Level Statistics, Land, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.687, 1.683, 1.759, 1.833, 2.017, 2.156, 2.136, 2.057, 1.982, 1.883, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 1.895, 1.917, 1.993, 1.993, 2.222, 2.36, 2.269, 2.134, 1.989, 1.897, 1.892, 1.999, 1.904, 2.095, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 1.94, 1.958, 2.06, 2.045, 2.179, 2.311, 2.221, 2.166, 2.14, 1.969, 1.931, 1.966, 1.914, 1.926, 2.07, 2.13, 2.196, 2.171, 2.18, 2.165, 2.156, 2.04, 1.944, 1.946, 1.716, 1.806, 1.788, 1.926, 2.065, 2.121, 2.123, 2.122, 2.114, 1.976, 1.917, 1.938, 1.959, 1.902, 1.915, 1.952, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.688, 1.64, 1.704, 1.69, 1.85, 1.946, 1.95, 1.979, 1.872, 1.863, 1.729, 1.724, 1.7, 1.708, 1.645, 1.695, 1.857, 1.901, 1.97, 1.925, 1.851, 1.845, 1.824, 1.782, 1.739, 1.701, 1.681, 1.729, 1.862, 1.941, 2.057, 2.013, 1.895, 1.93, 1.863, 1.832, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.801, 1.759, 1.827, 1.885, 2.077, 2.175, 2.144, 2.068, 1.989, 1.883, 1.764, 1.779, 1.672, 1.589, 1.732, 1.859, 2.056, 1.925, 1.921, 1.932, 1.903, 1.801, 1.689, 1.762, 1.662, 1.736, 1.726, 1.885, 2.051, 2.007, 1.991, 1.895, 1.934, 1.804, 1.717, 1.695, 1.717, 1.62, 1.758, 1.931, 1.952, 2.013, 1.879, 1.886, 1.825, 1.851, 1.744, 1.633, 1.662, 1.623, 1.683, 1.762, 1.914, 1.924, 1.901, 1.898, 1.871, 1.832, 1.71, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.875, 1.767, 1.724, 1.717, 1.648, 1.707, 1.751, 1.882, 1.985, 1.941, 1.918, 1.914, 1.815, 1.719, null] 
        }]
    })
    $('#nucapsirmw_Land_WaterVapor_RMS_743hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 743 hPa Level Statistics, Land, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 27.017, 29.554, 31.709, 36.146, 37.646, 37.155, 37.866, 36.838, 35.046, 30.437, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 25.235, 28.187, 32.614, 35.233, 38.862, 40.04, 37.873, 34.019, 32.049, 28.762, 26.863, 24.135, 25.132, 28.881, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 26.411, 29.079, 32.484, 35.654, 37.811, 38.724, 37.077, 34.834, 32.687, 29.587, 28.928, 25.324, 25.859, 29.383, 32.51, 34.897, 38.141, 34.795, 36.187, 34.865, 33.625, 32.784, 28.863, 27.928, 24.748, 29.274, 32.944, 35.372, 34.764, 37.418, 37.659, 36.487, 33.185, 29.506, 27.84, 26.579, 27.469, 28.558, 32.524, 34.154, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 25.939, 26.39, 30.253, 33.076, 34.878, 35.895, 38.174, 38.373, 34.705, 32.87, 30.148, 29.222, 27.894, 28.106, 29.09, 32.674, 35.101, 37.246, 36.756, 35.593, 33.443, 32.684, 33.025, 29.752, 28.131, 27.227, 29.257, 33.799, 36.885, 95.394, 99.656, 90.785, 87.612, 84.19, 96.408, 28.535, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 25.534, 28.477, 31.429, 34.88, 36.474, 36.013, 35.302, 34.894, 33.325, 29.742, 27.811, 26.573, 26.717, 29.894, 32.469, 34.031, 36.44, 35.24, 35.457, 34.701, 34.248, 33.685, 29.626, 28.034, 26.003, 30.042, 32.805, 33.79, 33.839, 34.869, 36.367, 34.498, 32.655, 30.727, 29.575, 27.452, 27.881, 28.2, 31.975, 34.226, 35.035, 34.74, 33.145, 32.151, 32.519, 32.271, 29.235, 26.9, 26.491, 27.95, 33.227, 35.346, 91.209, 99.423, 86.291, 81.687, 79.604, 94.484, 28.022, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 31.339, 28.926, 26.219, 25.84, 27.091, 32.921, 34.605, 94.482, 99.434, 86.954, 33.449, 79.92, 94.048, 27.535, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_Temperature_Bias_743hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 743 hPa Level Statistics, Land and Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: -5.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 0.158, 0.282, 0.237, 0.112, 0.062, 0.164, 0.125, -0.027, -0.096, -0.076, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, -0.392, -0.382, -0.248, -0.092, 0.142, 0.209, 0.163, 0.059, 0.008, -0.241, -0.469, -0.564, -0.492, -0.516, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, -0.355, -0.369, -0.244, -0.145, -0.022, 0.075, 0.011, -0.028, -0.119, -0.312, -0.41, -0.416, -0.432, -0.481, -0.302, -0.251, -0.1, -0.176, 0.022, -0.131, -0.238, -0.299, -0.448, -0.303, -0.098, -0.119, -0.017, 0.094, 0.271, 0.286, 0.283, 0.242, 0.263, 0.192, 0.058, 0.008, -0.059, -0.14, 0.036, -0.033, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.245, 0.131, 0.065, 0.085, 0.148, 0.261, 0.167, 0.144, 0.06, 0.137, 0.169, 0.22, 0.204, 0.113, 0.006, 0.106, 0.082, -0.027, 0.031, 0.154, 0.114, 0.132, 0.273, 0.341, 0.313, 0.203, 0.141, 0.083, 0.135, 0.251, 0.219, 0.215, 0.106, 0.173, 0.359, 0.384, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 0.392, 0.478, 0.485, 0.397, 0.397, 0.429, 0.347, 0.319, 0.327, 0.35, 0.308, 0.313, 0.392, 0.338, 0.471, 0.572, 0.58, 0.488, 0.473, 0.472, 0.454, 0.516, 0.518, 0.533, 0.438, 0.507, 0.525, 0.655, 0.733, 0.578, 0.553, 0.496, 0.549, 0.513, 0.53, 0.45, 0.36, 0.403, 0.547, 0.583, 0.545, 0.541, 0.385, 0.351, 0.294, 0.317, 0.233, 0.078, 0.022, 0.12, 0.209, 0.258, 0.358, 0.281, 0.251, 0.258, 0.251, 0.336, 0.231, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -0.251, -0.259, -0.374, -0.428, -0.361, -0.288, -0.215, -0.16, -0.249, -0.277, -0.216, -0.294, -0.174, -0.289, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_WaterVapor_Bias_743hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 743 hPa Level Statistics, Land and Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 50.0,
          min: -50.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, -3.698, -3.432, -0.98, -2.37, -4.928, -4.813, -7.049, -5.744, -3.399, -3.599, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 1.889, 2.585, 4.199, 2.851, 1.731, 3.268, 0.885, 1.43, 4.598, 4.33, 4.09, 2.828, 1.8, -0.825, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 0.158, -0.517, -1.3, -3.79, -3.576, -2.163, -2.633, -3.27, 0.825, 2.239, 3.472, 1.849, -0.143, -1.525, -1.966, -4.3, -4.091, -2.529, -3.595, -1.806, 0.47, 2.17, 1.811, 0.328, -1.063, -1.405, -1.586, -5.162, -4.666, -2.726, -1.177, -1.098, -0.352, 1.521, 1.235, 0.544, -1.328, -2.656, -4.439, -3.037, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.674, -0.527, -1.376, -0.911, -5.129, -5.96, -4.928, -4.977, -1.69, 0.137, 2.688, 3.04, -0.105, -2.202, -2.197, -3.562, -2.342, -3.914, -5.309, -3.167, -1.789, 1.973, 3.867, 1.677, -0.383, -3.259, -4.102, -0.723, -3.454, -0.025, 19.952, -0.72, -0.909, 1.981, 9.663, 0.98, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 2.028, 2.801, 4.714, 3.406, 1.099, 1.64, -0.783, -1.319, 0.837, 1.014, 2.562, 3.081, 3.23, 4.002, 4.303, 1.737, 0.178, 0.504, -0.695, 0.504, 2.824, 4.394, 4.5, 2.79, 2.374, 3.07, 3.687, -0.764, -2.133, -1.209, -2.439, -1.196, -0.679, 2.009, 2.605, 1.018, 0.429, -0.097, -1.155, -1.537, -2.779, -4.073, -4.879, -3.718, -2.282, -1.026, -1.976, -2.891, -3.926, -4.879, -2.19, -5.729, -4.197, 6.687, -4.726, -5.057, -3.545, 0.685, -4.208, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 2.3, 0.886, 0.628, 0.602, -0.032, 3.394, -1.591, 2.225, 10.382, -0.196, -0.908, 0.937, 4.948, 0.065, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_Temperature_StdDev_743hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 743 hPa Level Statistics, Land and Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.617, 1.604, 1.694, 1.774, 1.95, 2.084, 2.056, 1.968, 1.907, 1.814, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 1.806, 1.831, 1.929, 1.949, 2.153, 2.281, 2.195, 2.058, 1.953, 1.844, 1.792, 1.867, 1.806, 1.961, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 1.865, 1.879, 1.993, 1.996, 2.13, 2.256, 2.175, 2.084, 2.073, 1.899, 1.859, 1.901, 1.84, 1.833, 1.996, 2.046, 2.152, 2.117, 2.139, 2.099, 2.078, 1.965, 1.852, 1.886, 1.644, 1.724, 1.717, 1.825, 1.977, 2.021, 2.044, 2.025, 1.998, 1.873, 1.831, 1.868, 1.883, 1.835, 1.848, 1.87, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.59, 1.577, 1.64, 1.621, 1.756, 1.86, 1.876, 1.901, 1.793, 1.778, 1.654, 1.634, 1.627, 1.638, 1.599, 1.631, 1.775, 1.834, 1.899, 1.851, 1.785, 1.769, 1.736, 1.684, 1.644, 1.634, 1.632, 1.674, 1.784, 1.871, 1.959, 1.924, 1.836, 1.843, 1.766, 1.735, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.684, 1.637, 1.706, 1.786, 1.967, 2.063, 2.048, 1.959, 1.898, 1.786, 1.668, 1.68, 1.57, 1.521, 1.617, 1.702, 1.906, 1.811, 1.809, 1.807, 1.772, 1.657, 1.538, 1.609, 1.547, 1.598, 1.59, 1.686, 1.847, 1.849, 1.85, 1.779, 1.782, 1.671, 1.572, 1.586, 1.621, 1.544, 1.607, 1.759, 1.795, 1.861, 1.783, 1.794, 1.744, 1.755, 1.672, 1.581, 1.594, 1.574, 1.624, 1.677, 1.818, 1.828, 1.805, 1.83, 1.788, 1.738, 1.649, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.775, 1.679, 1.613, 1.578, 1.553, 1.614, 1.674, 1.809, 1.88, 1.84, 1.834, 1.806, 1.729, 1.645, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_WaterVapor_StdDev_743hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 743 hPa Level Statistics, Land and Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 25.281, 27.287, 29.961, 32.053, 32.382, 33.939, 33.29, 32.0, 31.061, 28.483, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 24.728, 27.16, 31.366, 32.391, 34.664, 36.634, 34.678, 30.945, 30.421, 28.593, 26.051, 24.102, 24.807, 27.117, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 25.376, 27.32, 29.971, 31.132, 32.696, 34.298, 33.11, 29.961, 29.998, 28.738, 27.751, 24.904, 25.106, 27.294, 29.626, 30.407, 32.75, 31.715, 31.614, 30.006, 30.156, 30.239, 27.485, 26.814, 23.785, 27.008, 28.899, 29.05, 29.714, 32.16, 33.661, 31.132, 28.992, 27.215, 26.715, 25.602, 25.773, 26.504, 28.236, 28.981, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 25.02, 25.032, 27.371, 28.834, 28.57, 29.617, 32.107, 32.629, 30.177, 28.834, 27.816, 27.641, 26.42, 25.794, 26.577, 28.343, 29.869, 30.44, 31.124, 31.001, 30.049, 30.277, 30.575, 28.09, 26.511, 24.812, 26.057, 49.114, 30.964, 34.525, 11.039, 42.462, 45.658, 49.068, 31.299, 27.441, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 25.009, 27.181, 29.771, 31.241, 31.315, 32.524, 32.033, 30.668, 30.183, 28.174, 26.618, 26.054, 26.079, 28.404, 30.248, 30.399, 31.469, 32.218, 31.971, 30.315, 30.432, 30.841, 27.618, 27.101, 25.538, 28.653, 29.447, 29.306, 29.859, 30.335, 32.144, 30.076, 28.728, 28.071, 27.68, 26.22, 26.08, 26.577, 28.182, 29.711, 29.537, 30.248, 28.85, 28.656, 28.931, 28.737, 26.815, 24.99, 46.381, 24.895, 48.804, 28.79, 42.424, 14.41, 46.141, 47.338, 45.206, 35.159, 25.69, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 28.73, 27.129, 25.287, 48.355, 25.727, 51.581, 46.805, 39.811, 14.817, 47.92, 30.39, 50.268, 37.899, 26.343, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_Temperature_RMS_743hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 743 hPa Level Statistics, Land and Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.624, 1.629, 1.711, 1.778, 1.951, 2.09, 2.06, 1.968, 1.909, 1.815, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 1.848, 1.871, 1.945, 1.951, 2.158, 2.291, 2.201, 2.059, 1.953, 1.86, 1.852, 1.951, 1.872, 2.028, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 1.898, 1.915, 2.008, 2.002, 2.13, 2.257, 2.175, 2.084, 2.076, 1.924, 1.903, 1.946, 1.89, 1.895, 2.019, 2.061, 2.154, 2.125, 2.14, 2.103, 2.092, 1.987, 1.905, 1.911, 1.647, 1.729, 1.717, 1.827, 1.996, 2.041, 2.063, 2.039, 2.015, 1.883, 1.831, 1.868, 1.884, 1.84, 1.848, 1.87, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.608, 1.582, 1.641, 1.623, 1.762, 1.878, 1.883, 1.906, 1.794, 1.783, 1.662, 1.649, 1.64, 1.642, 1.599, 1.635, 1.777, 1.834, 1.899, 1.857, 1.789, 1.774, 1.758, 1.719, 1.674, 1.646, 1.638, 1.676, 1.79, 1.887, 1.971, 1.936, 1.84, 1.852, 1.802, 1.777, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.729, 1.706, 1.774, 1.83, 2.006, 2.108, 2.077, 1.984, 1.926, 1.82, 1.696, 1.709, 1.618, 1.558, 1.684, 1.795, 1.992, 1.876, 1.87, 1.868, 1.829, 1.735, 1.623, 1.695, 1.608, 1.676, 1.675, 1.809, 1.987, 1.938, 1.931, 1.847, 1.864, 1.748, 1.659, 1.649, 1.661, 1.595, 1.698, 1.853, 1.876, 1.938, 1.824, 1.828, 1.769, 1.784, 1.688, 1.583, 1.595, 1.579, 1.637, 1.697, 1.854, 1.849, 1.823, 1.848, 1.805, 1.771, 1.665, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.793, 1.699, 1.656, 1.635, 1.594, 1.639, 1.688, 1.816, 1.897, 1.86, 1.847, 1.829, 1.738, 1.67, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_WaterVapor_RMS_743hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 743 hPa Level Statistics, Land and Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 26.68, 28.591, 30.774, 33.475, 34.18, 35.543, 36.256, 34.916, 33.215, 30.102, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 25.021, 27.609, 32.01, 33.48, 36.248, 38.236, 36.647, 32.235, 30.88, 28.815, 26.18, 24.277, 25.157, 28.382, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 26.011, 28.404, 31.773, 33.924, 35.736, 37.346, 36.504, 32.841, 31.315, 29.272, 27.985, 25.184, 25.746, 28.801, 31.592, 33.155, 36.182, 34.551, 35.352, 32.544, 31.749, 31.139, 27.889, 27.542, 24.61, 28.282, 30.585, 31.483, 32.22, 34.531, 36.366, 33.081, 30.443, 27.777, 27.138, 26.149, 26.69, 28.061, 30.553, 31.235, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 25.438, 26.013, 28.974, 30.817, 31.583, 33.468, 36.028, 37.266, 32.541, 30.375, 28.539, 28.062, 27.347, 27.298, 28.476, 30.954, 32.329, 33.963, 35.525, 34.381, 32.524, 31.466, 31.169, 28.814, 27.504, 26.567, 28.566, 74.592, 34.001, 92.736, 99.389, 86.428, 82.978, 79.302, 95.038, 28.091, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 25.386, 27.633, 30.144, 31.984, 32.366, 33.531, 33.966, 32.85, 31.653, 28.998, 26.996, 26.279, 26.297, 28.845, 30.818, 31.333, 32.699, 33.302, 33.586, 31.667, 31.192, 31.318, 27.763, 27.456, 25.891, 29.174, 30.071, 30.547, 31.366, 31.916, 34.644, 31.873, 30.137, 28.864, 28.223, 26.921, 26.919, 27.832, 29.936, 31.671, 32.024, 33.198, 32.083, 31.514, 31.233, 30.416, 28.562, 26.726, 80.032, 27.571, 68.237, 32.36, 85.508, 98.852, 79.66, 75.292, 83.082, 92.337, 27.757, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 29.387, 27.905, 25.879, 80.7, 26.71, 69.209, 80.6, 90.312, 98.919, 80.733, 32.14, 73.862, 91.698, 27.023, null] 
        }]
    })
    $('#nucapsirmw_Sea_Temperature_Bias_840hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 840 hPa Level Statistics, Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: -5.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, -0.093, 0.072, -0.012, -0.161, -0.217, -0.021, -0.083, -0.552, -0.136, -0.111, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, -0.638, -0.577, -0.548, -0.61, -0.617, -0.634, -0.585, -0.95, -0.539, -0.431, -0.874, -0.613, -0.589, -0.618, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, -0.584, -0.542, -0.582, -0.553, -0.522, -0.067, -0.372, -0.597, -0.288, -0.325, -0.886, -0.776, -0.676, -0.688, -0.571, -0.619, -0.421, -0.671, -0.672, -0.865, -0.586, -0.714, -0.904, -0.708, -0.384, -0.432, -0.39, -0.475, -0.294, -0.575, 0.096, -0.165, -0.202, -0.062, -0.183, -0.221, -0.212, -0.175, -0.613, -0.306, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -0.429, -0.422, -0.387, -0.476, -0.389, -0.231, -0.502, -0.536, -0.165, -0.326, -0.277, -0.288, -0.356, -0.397, -0.392, -0.427, -0.368, -0.204, -0.432, -0.208, -0.337, -0.244, -0.207, -0.491, -0.163, -0.35, -0.475, -0.295, -0.228, -0.197, -0.377, -0.437, -0.599, -0.194, -0.253, -0.059, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, -0.012, 0.194, 0.323, -0.065, 0.197, 0.087, -0.032, -0.433, -0.023, 0.172, -0.11, -0.069, 0.265, 0.226, 0.144, 0.261, 0.422, -0.002, -0.232, -0.229, 0.154, 0.223, 0.076, 0.145, 0.098, 0.023, 0.262, 0.164, 0.142, -0.269, -0.029, 0.028, 0.187, 0.284, 0.287, 0.236, 0.019, 0.192, 0.127, 0.1, 0.05, -0.247, -0.11, -0.054, -0.253, 0.047, -0.168, -0.004, -0.254, -0.339, -0.306, -0.166, -0.295, -0.3, -0.567, -0.437, -0.256, -0.312, -0.253, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -0.25, -0.417, -0.183, -0.427, -0.513, -0.363, -0.304, -0.502, -0.474, -0.705, -0.46, -0.48, -0.463, -0.485, null] 
        }]
    })
    $('#nucapsirmw_Sea_WaterVapor_Bias_840hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 840 hPa Level Statistics, Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 50.0,
          min: -50.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, -4.109, -2.892, -1.256, -4.907, -8.223, -9.606, -6.733, -8.318, -5.728, -6.362, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 2.492, 1.551, 0.104, -0.709, -1.686, -1.329, -4.34, -5.697, -0.936, 0.635, 0.014, 0.761, 1.407, 4.828, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 3.365, 3.61, 1.096, 1.119, -0.313, -2.47, -0.209, -0.286, 0.98, 1.512, 0.72, 3.64, 3.679, 2.66, 2.854, -0.921, -2.046, -4.069, 0.227, 1.727, 0.452, 1.988, 3.068, 2.497, 3.3, 3.026, 4.275, 1.566, 0.581, -1.896, -3.078, 1.288, -0.346, 0.928, -0.49, -1.622, -0.881, -0.345, 0.998, -0.303, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 4.662, 4.078, 3.201, 6.178, 2.756, -1.58, 1.167, -2.586, -0.518, 1.711, 2.8, 4.0, 0.929, 2.912, 3.213, 1.514, 4.846, -0.088, -0.415, -2.559, -0.452, 4.206, -0.109, 2.103, 0.026, 2.008, 4.269, 5.154, 2.55, 1.742, 1.163, 0.893, 2.269, 2.11, 0.526, 2.7, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 0.173, -1.115, 0.319, 0.235, -2.309, -3.298, -1.47, -2.056, -1.882, -1.67, -3.522, -1.766, -1.109, 1.609, -0.178, -0.103, -1.104, -1.428, -1.318, 0.483, 1.198, 1.782, -0.159, -0.303, -0.678, -0.901, 0.09, -0.83, 0.348, -0.326, -3.481, -3.059, -2.89, 0.105, -1.386, -5.306, -4.515, -2.999, -2.746, 1.363, -4.865, -4.787, -7.141, -5.266, -0.482, -3.591, -5.642, -5.543, 1.181, -2.711, -3.346, -3.835, -4.667, -4.464, -3.553, -3.608, -3.023, -5.579, -4.828, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -0.476, -0.371, -1.817, 8.215, 1.79, 0.76, 0.2, -1.805, -2.092, -3.247, -1.227, 1.365, -1.808, -2.238, null] 
        }]
    })
    $('#nucapsirmw_Sea_Temperature_StdDev_840hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 840 hPa Level Statistics, Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.366, 1.34, 1.628, 1.623, 1.497, 1.849, 1.548, 1.573, 1.611, 1.382, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 1.726, 1.704, 1.906, 1.699, 1.672, 1.974, 1.97, 1.768, 1.825, 1.541, 1.629, 1.638, 1.752, 1.778, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 1.659, 1.677, 1.839, 1.56, 1.739, 1.89, 2.0, 1.509, 1.765, 1.569, 1.835, 1.665, 1.715, 1.869, 1.597, 1.733, 2.003, 2.068, 1.993, 1.606, 1.715, 1.704, 1.533, 1.535, 1.414, 1.474, 1.521, 1.531, 1.574, 1.752, 1.849, 1.626, 1.553, 1.634, 1.483, 1.668, 1.591, 1.539, 1.66, 1.676, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.656, 1.461, 1.39, 1.426, 1.439, 1.549, 1.711, 1.729, 1.518, 1.445, 1.378, 1.314, 1.505, 1.472, 1.556, 1.626, 1.658, 1.687, 1.674, 1.522, 1.647, 1.641, 1.514, 1.579, 1.586, 1.594, 1.53, 1.599, 1.693, 1.733, 1.876, 1.991, 2.007, 1.796, 2.066, 1.923, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.395, 1.506, 1.523, 1.551, 1.621, 1.752, 1.548, 1.506, 1.61, 1.296, 1.246, 1.356, 1.393, 1.454, 1.528, 1.674, 1.784, 1.812, 1.652, 1.636, 1.405, 1.455, 1.412, 1.344, 1.474, 1.572, 1.512, 1.444, 1.622, 1.585, 1.746, 1.556, 1.599, 1.461, 1.346, 1.593, 1.304, 1.464, 1.463, 1.708, 1.829, 1.649, 1.645, 1.614, 1.416, 1.501, 1.445, 1.446, 1.454, 1.359, 1.49, 1.674, 1.655, 1.624, 1.629, 1.66, 1.485, 1.504, 1.504, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.238, 1.338, 1.261, 1.355, 1.327, 1.553, 1.482, 1.652, 1.677, 1.536, 1.558, 1.447, 1.407, 1.421, null] 
        }]
    })
    $('#nucapsirmw_Sea_WaterVapor_StdDev_840hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 840 hPa Level Statistics, Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 17.654, 19.18, 23.039, 21.583, 22.708, 23.111, 26.145, 23.497, 23.82, 21.107, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 17.659, 19.844, 20.055, 20.018, 19.449, 25.07, 23.454, 23.482, 20.747, 19.021, 17.009, 19.236, 18.053, 21.67, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 18.033, 19.315, 21.235, 19.83, 19.933, 24.611, 24.081, 21.278, 20.291, 19.673, 18.376, 17.56, 18.581, 19.718, 22.896, 20.888, 20.85, 23.206, 23.819, 22.279, 20.273, 20.833, 20.164, 17.958, 16.42, 19.426, 19.956, 19.136, 20.261, 23.018, 22.191, 19.384, 17.21, 19.23, 18.613, 16.847, 15.967, 16.605, 20.454, 20.9, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 19.714, 18.056, 21.096, 19.927, 20.611, 20.828, 28.581, 23.534, 22.259, 18.357, 20.367, 20.084, 17.506, 18.04, 18.858, 22.093, 23.926, 21.64, 24.586, 22.337, 22.372, 24.482, 19.942, 19.535, 18.122, 20.105, 18.786, 23.41, 20.997, 22.572, 25.242, 27.067, 24.335, 21.665, 20.363, 22.555, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 18.968, 19.144, 20.974, 21.641, 22.914, 23.406, 24.571, 25.187, 22.887, 19.615, 16.996, 17.488, 17.547, 20.59, 22.592, 20.815, 21.165, 21.641, 23.423, 25.776, 22.225, 21.528, 20.731, 18.119, 18.168, 20.164, 20.041, 20.889, 22.49, 26.599, 23.324, 23.946, 19.056, 20.014, 20.492, 18.262, 15.001, 18.076, 21.14, 24.013, 20.194, 22.668, 22.71, 20.082, 23.624, 19.006, 17.831, 16.889, 39.017, 17.542, 19.631, 19.658, 21.114, 23.966, 24.774, 23.221, 24.477, 20.67, 19.681, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 19.855, 17.122, 17.37, 39.671, 18.069, 21.276, 20.562, 22.971, 24.324, 25.75, 22.197, 24.429, 21.645, 20.303, null] 
        }]
    })
    $('#nucapsirmw_Sea_Temperature_RMS_840hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 840 hPa Level Statistics, Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.369, 1.342, 1.628, 1.632, 1.512, 1.85, 1.55, 1.667, 1.617, 1.387, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 1.84, 1.799, 1.983, 1.805, 1.782, 2.074, 2.055, 2.007, 1.903, 1.6, 1.848, 1.749, 1.848, 1.883, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 1.759, 1.762, 1.929, 1.656, 1.815, 1.892, 2.035, 1.623, 1.788, 1.603, 2.038, 1.837, 1.844, 1.992, 1.696, 1.84, 2.046, 2.174, 2.103, 1.825, 1.813, 1.848, 1.78, 1.691, 1.465, 1.536, 1.57, 1.603, 1.601, 1.844, 1.852, 1.634, 1.566, 1.636, 1.494, 1.683, 1.605, 1.549, 1.769, 1.703, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.711, 1.52, 1.443, 1.504, 1.491, 1.566, 1.783, 1.81, 1.526, 1.481, 1.405, 1.345, 1.546, 1.524, 1.605, 1.681, 1.699, 1.7, 1.729, 1.537, 1.681, 1.659, 1.529, 1.654, 1.595, 1.632, 1.602, 1.627, 1.708, 1.744, 1.914, 2.038, 2.095, 1.806, 2.082, 1.924, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.396, 1.518, 1.557, 1.552, 1.633, 1.755, 1.549, 1.567, 1.61, 1.308, 1.251, 1.358, 1.418, 1.471, 1.535, 1.694, 1.833, 1.812, 1.668, 1.652, 1.413, 1.472, 1.415, 1.352, 1.477, 1.573, 1.535, 1.453, 1.628, 1.608, 1.747, 1.556, 1.61, 1.489, 1.376, 1.61, 1.304, 1.476, 1.468, 1.711, 1.829, 1.668, 1.648, 1.614, 1.439, 1.502, 1.455, 1.446, 1.476, 1.401, 1.522, 1.682, 1.681, 1.652, 1.725, 1.717, 1.507, 1.536, 1.526, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.263, 1.402, 1.274, 1.421, 1.423, 1.595, 1.513, 1.727, 1.743, 1.691, 1.624, 1.525, 1.481, 1.502, null] 
        }]
    })
    $('#nucapsirmw_Sea_WaterVapor_RMS_840hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 840 hPa Level Statistics, Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 18.72, 19.742, 23.385, 23.158, 25.574, 26.498, 28.481, 26.56, 25.725, 22.931, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 17.664, 19.846, 20.221, 20.266, 19.932, 25.557, 24.781, 24.988, 21.069, 19.076, 17.158, 19.264, 18.054, 21.774, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 18.041, 19.332, 21.38, 19.943, 20.216, 25.448, 24.696, 21.609, 20.437, 19.717, 18.481, 17.623, 18.611, 19.723, 22.949, 21.376, 21.574, 24.562, 24.473, 22.501, 20.502, 20.882, 20.164, 17.961, 16.448, 19.426, 19.965, 19.239, 20.568, 24.263, 23.799, 19.541, 17.629, 19.408, 18.95, 17.3, 16.224, 16.769, 20.71, 21.371, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 19.852, 18.138, 21.096, 20.088, 20.625, 21.274, 29.105, 24.634, 22.678, 18.387, 20.374, 20.114, 17.573, 18.047, 18.862, 22.24, 23.936, 22.003, 25.181, 23.057, 22.822, 24.535, 20.178, 19.546, 18.247, 20.139, 18.881, 23.422, 21.031, 22.736, 25.651, 27.505, 24.888, 21.705, 20.475, 22.631, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 19.161, 19.566, 21.209, 22.043, 24.005, 24.562, 25.454, 26.178, 23.843, 20.086, 18.035, 17.934, 17.867, 20.724, 22.989, 21.173, 21.75, 22.312, 24.587, 26.446, 22.471, 21.615, 20.927, 18.345, 18.482, 20.616, 20.301, 21.3, 22.936, 27.638, 24.963, 25.188, 20.046, 20.29, 21.095, 19.807, 16.268, 18.871, 22.143, 24.465, 21.846, 24.56, 25.162, 21.732, 24.628, 20.206, 20.137, 18.517, 91.046, 18.247, 20.805, 21.01, 22.628, 25.888, 26.615, 25.39, 25.653, 22.636, 21.076, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 20.163, 17.481, 17.776, 92.581, 18.07, 21.486, 21.004, 23.685, 25.074, 27.15, 23.14, 24.61, 22.269, 20.766, null] 
        }]
    })
    $('#nucapsirmw_Land_Temperature_Bias_840hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 840 hPa Level Statistics, Land, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: -5.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, -0.142, -0.034, 0.201, 0.236, 0.577, 0.839, 0.846, 0.373, 0.02, -0.334, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, -0.865, -0.67, -0.386, -0.086, 0.217, 0.349, 0.382, -0.069, -0.319, -0.86, -0.986, -0.823, -0.882, -0.721, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, -0.894, -0.873, -0.586, -0.228, 0.122, 0.255, 0.211, -0.055, -0.155, -0.555, -0.722, -0.706, -0.877, -0.886, -0.644, -0.433, -0.001, -0.008, 0.038, -0.253, -0.377, -0.547, -0.852, -0.827, -0.84, -0.792, -0.585, -0.407, 0.051, -0.168, -0.087, -0.351, -0.171, -0.265, -0.454, -0.646, -0.81, -0.858, -0.792, -0.511, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -0.467, -0.61, -0.435, -0.197, -0.021, 0.328, 0.191, 0.207, -0.029, 0.005, -0.141, -0.304, -0.508, -0.632, -0.462, -0.37, -0.032, 0.172, 0.191, 0.114, -0.071, -0.11, -0.192, -0.375, -0.556, -0.672, -0.51, -0.34, -0.069, 0.124, 0.255, 0.161, -0.079, -0.16, -0.264, -0.339, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 0.032, 0.239, 0.476, 0.435, 0.668, 0.811, 0.928, 0.523, 0.205, -0.155, -0.287, 0.075, 0.368, 0.432, 0.514, 0.567, 0.729, 0.752, 0.669, 0.57, 0.488, 0.436, 0.351, 0.375, 0.33, 0.499, 0.519, 0.632, 0.789, 0.598, 0.613, 0.502, 0.558, 0.331, 0.289, 0.248, 0.323, 0.373, 0.394, 0.615, 0.789, 0.724, 0.207, 0.126, 0.087, -0.043, -0.164, -0.3, -0.289, -0.089, -0.013, 0.024, 0.128, 0.195, 0.176, -0.059, -0.005, -0.127, -0.251, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -0.348, -0.448, -0.55, -0.527, -0.351, -0.237, -0.2, -0.171, -0.065, -0.097, -0.217, -0.3, -0.404, -0.643, null] 
        }]
    })
    $('#nucapsirmw_Land_WaterVapor_Bias_840hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 840 hPa Level Statistics, Land, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 50.0,
          min: -50.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 0.693, 4.433, 12.72, 12.358, 9.526, 9.411, 7.391, 7.059, 12.087, 9.193, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 4.136, 9.11, 16.537, 16.103, 15.488, 16.224, 10.991, 9.761, 11.931, 7.181, 5.59, 3.615, 3.854, 1.905, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 6.18, 9.996, 14.827, 11.563, 11.462, 13.114, 10.905, 9.057, 16.231, 13.436, 10.834, 6.466, 5.72, 7.274, 16.125, 15.534, 14.226, 12.237, 13.864, 13.346, 13.219, 14.141, 10.983, 7.893, 3.056, 5.357, 11.015, 5.692, 7.141, 7.234, 11.214, 8.008, 7.601, 9.299, 3.867, 2.663, 1.439, 2.567, 5.476, 5.429, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 4.57, 4.985, 7.083, 11.651, 6.834, 8.509, 7.401, 10.902, 7.246, 7.383, 8.09, 6.558, 5.232, 3.592, 4.238, 5.994, 7.968, 10.013, 6.689, 8.523, 8.994, 8.842, 7.869, 4.86, 3.899, 2.211, 3.425, 9.764, 14.192, 10.898, 17.336, 10.895, 11.512, 10.106, 7.589, 5.601, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 3.188, 7.696, 16.169, 16.426, 14.445, 14.344, 10.462, 9.178, 13.254, 9.411, 4.733, 2.587, 4.669, 6.981, 15.704, 15.567, 14.026, 9.664, 11.12, 12.35, 11.03, 9.196, 7.262, 3.861, 4.668, 8.237, 14.677, 9.995, 10.1, 10.017, 11.582, 9.221, 8.502, 8.925, 5.467, 2.345, 2.609, 4.97, 8.794, 8.715, 9.335, 8.02, 8.241, 8.052, 7.264, 5.717, 2.297, -0.769, -0.382, 1.894, 8.943, 13.778, 9.725, 17.334, 10.279, 10.011, 8.515, 5.372, 0.676, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 7.969, 5.397, 3.216, 2.561, 4.673, 10.584, 15.567, 10.32, 17.87, 10.225, 10.956, 9.822, 8.116, 5.137, null] 
        }]
    })
    $('#nucapsirmw_Land_Temperature_StdDev_840hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 840 hPa Level Statistics, Land, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.818, 2.004, 2.125, 2.184, 2.483, 2.638, 2.81, 2.502, 2.304, 2.141, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 2.07, 2.238, 2.404, 2.353, 2.622, 2.797, 2.927, 2.532, 2.431, 2.213, 2.117, 2.034, 2.064, 2.271, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 2.13, 2.284, 2.425, 2.451, 2.681, 2.837, 2.895, 2.702, 2.606, 2.338, 2.173, 2.107, 2.127, 2.228, 2.394, 2.49, 2.82, 2.688, 2.664, 2.526, 2.471, 2.296, 2.185, 2.082, 1.98, 2.169, 2.213, 2.307, 2.584, 2.581, 2.516, 2.519, 2.497, 2.334, 2.139, 2.142, 2.21, 2.166, 2.307, 2.36, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 2.049, 2.024, 2.15, 2.123, 2.161, 2.351, 2.295, 2.367, 2.318, 2.328, 2.28, 2.13, 2.034, 2.033, 2.062, 2.142, 2.261, 2.304, 2.372, 2.348, 2.397, 2.393, 2.334, 2.181, 2.151, 2.093, 2.163, 2.176, 2.256, 2.326, 2.453, 2.472, 2.482, 2.495, 2.42, 2.333, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.863, 1.984, 2.175, 2.162, 2.41, 2.532, 2.73, 2.486, 2.294, 2.197, 2.018, 1.953, 1.935, 1.972, 2.1, 2.146, 2.418, 2.339, 2.291, 2.249, 2.236, 2.173, 2.04, 1.933, 1.948, 2.013, 2.043, 2.108, 2.341, 2.255, 2.287, 2.224, 2.267, 2.193, 2.049, 1.937, 1.905, 1.904, 2.035, 2.237, 2.348, 2.366, 2.313, 2.273, 2.316, 2.212, 2.085, 1.999, 1.944, 1.978, 2.052, 2.122, 2.257, 2.266, 2.355, 2.251, 2.334, 2.21, 2.091, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 2.201, 2.011, 1.912, 1.867, 1.929, 2.019, 2.065, 2.211, 2.257, 2.312, 2.21, 2.252, 2.152, 2.123, null] 
        }]
    })
    $('#nucapsirmw_Land_WaterVapor_StdDev_840hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 840 hPa Level Statistics, Land, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 23.696, 25.505, 31.204, 32.833, 32.084, 33.209, 30.563, 31.76, 32.798, 29.712, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 21.998, 26.369, 33.538, 34.162, 37.026, 38.758, 32.276, 32.235, 31.81, 27.14, 24.62, 21.812, 22.526, 26.673, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 23.055, 27.256, 33.33, 33.009, 34.314, 35.291, 31.057, 31.526, 33.882, 29.846, 26.984, 23.122, 23.283, 25.908, 33.387, 35.035, 35.941, 32.349, 33.261, 32.748, 32.872, 32.27, 28.068, 25.011, 21.795, 25.381, 30.632, 28.931, 30.402, 31.182, 33.721, 31.742, 29.883, 28.481, 25.076, 23.812, 23.182, 24.951, 28.57, 29.473, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 22.663, 22.544, 26.122, 29.808, 28.522, 30.79, 31.97, 34.217, 30.129, 28.79, 27.389, 25.986, 23.835, 23.867, 24.618, 27.745, 29.306, 32.225, 31.224, 31.178, 31.153, 31.049, 30.825, 25.581, 23.15, 22.414, 23.736, 29.867, 42.238, 33.239, 51.128, 33.473, 32.694, 31.358, 28.343, 25.204, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 21.846, 25.512, 31.748, 33.332, 32.107, 32.866, 30.052, 31.072, 31.473, 28.153, 24.37, 22.889, 23.143, 26.113, 31.558, 32.645, 34.927, 31.317, 31.005, 32.344, 30.64, 29.576, 26.327, 23.297, 22.789, 26.592, 30.895, 29.287, 30.526, 31.181, 32.895, 30.769, 29.553, 28.208, 26.02, 23.195, 23.697, 25.122, 28.54, 29.539, 31.583, 30.581, 30.213, 30.303, 30.438, 29.087, 25.037, 22.093, 22.035, 23.29, 29.426, 47.281, 31.664, 47.895, 31.982, 30.996, 30.227, 27.659, 44.448, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 29.195, 25.994, 22.328, 22.252, 23.179, 29.346, 42.822, 31.395, 47.878, 31.938, 31.09, 30.751, 28.079, 24.998, null] 
        }]
    })
    $('#nucapsirmw_Land_Temperature_RMS_840hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 840 hPa Level Statistics, Land, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.823, 2.005, 2.134, 2.197, 2.549, 2.768, 2.935, 2.529, 2.304, 2.167, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 2.243, 2.337, 2.435, 2.354, 2.631, 2.818, 2.952, 2.533, 2.452, 2.374, 2.335, 2.194, 2.245, 2.383, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 2.31, 2.445, 2.495, 2.462, 2.683, 2.848, 2.903, 2.703, 2.611, 2.403, 2.29, 2.223, 2.301, 2.398, 2.479, 2.527, 2.82, 2.688, 2.665, 2.539, 2.499, 2.361, 2.346, 2.241, 2.151, 2.309, 2.289, 2.342, 2.585, 2.586, 2.517, 2.543, 2.503, 2.349, 2.187, 2.237, 2.354, 2.33, 2.44, 2.415, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 2.101, 2.114, 2.194, 2.132, 2.161, 2.373, 2.303, 2.376, 2.318, 2.328, 2.285, 2.152, 2.097, 2.129, 2.113, 2.174, 2.262, 2.311, 2.379, 2.351, 2.398, 2.395, 2.342, 2.213, 2.222, 2.198, 2.222, 2.202, 2.257, 2.33, 2.466, 2.477, 2.483, 2.5, 2.435, 2.357, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.864, 1.998, 2.227, 2.205, 2.501, 2.659, 2.884, 2.54, 2.304, 2.202, 2.038, 1.955, 1.97, 2.019, 2.162, 2.22, 2.526, 2.457, 2.387, 2.32, 2.288, 2.217, 2.07, 1.969, 1.976, 2.074, 2.108, 2.201, 2.47, 2.333, 2.368, 2.28, 2.335, 2.217, 2.069, 1.953, 1.932, 1.94, 2.073, 2.32, 2.477, 2.474, 2.322, 2.277, 2.317, 2.212, 2.091, 2.022, 1.965, 1.98, 2.052, 2.122, 2.26, 2.275, 2.362, 2.252, 2.334, 2.214, 2.106, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 2.229, 2.061, 1.99, 1.94, 1.961, 2.033, 2.075, 2.218, 2.258, 2.314, 2.221, 2.272, 2.19, 2.219, null] 
        }]
    })
    $('#nucapsirmw_Land_WaterVapor_RMS_840hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 840 hPa Level Statistics, Land, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 24.198, 25.706, 31.222, 32.834, 32.118, 33.296, 30.655, 32.568, 32.932, 29.884, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 22.005, 26.4, 33.727, 34.238, 37.053, 38.772, 32.284, 32.5, 31.811, 27.184, 24.63, 21.842, 22.547, 27.062, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 23.062, 27.28, 33.383, 33.028, 34.359, 35.326, 31.061, 32.145, 33.882, 29.887, 27.154, 23.143, 23.289, 25.922, 33.459, 35.111, 35.944, 32.354, 33.261, 32.816, 32.909, 32.29, 28.173, 25.048, 21.914, 25.559, 30.704, 29.411, 30.773, 31.674, 34.062, 32.237, 30.48, 28.577, 25.268, 24.07, 23.585, 25.497, 28.893, 30.116, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 22.673, 22.546, 26.146, 29.81, 28.679, 30.865, 32.211, 34.383, 30.407, 29.047, 27.471, 25.995, 23.849, 24.003, 24.836, 27.859, 29.464, 32.431, 31.668, 31.428, 31.234, 31.119, 30.907, 25.659, 23.225, 22.688, 24.0, 29.914, 90.873, 33.297, 85.113, 33.518, 32.705, 31.41, 28.388, 25.24, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 21.95, 25.516, 31.962, 33.44, 32.182, 32.897, 30.053, 31.465, 31.484, 28.181, 24.445, 23.089, 23.176, 26.171, 31.637, 32.728, 34.975, 31.322, 31.011, 32.376, 30.654, 29.61, 26.331, 23.395, 22.811, 26.594, 30.985, 29.287, 30.526, 31.186, 32.93, 30.866, 29.695, 28.258, 26.134, 23.535, 24.007, 25.361, 28.577, 29.639, 31.699, 30.796, 30.463, 30.612, 30.795, 29.481, 25.554, 23.089, 23.028, 23.994, 29.566, 87.21, 31.767, 87.568, 32.065, 31.085, 30.418, 27.954, 52.007, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 29.243, 26.039, 22.422, 22.459, 23.268, 29.346, 90.771, 31.396, 88.32, 31.94, 31.09, 30.769, 28.086, 25.03, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_Temperature_Bias_840hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 840 hPa Level Statistics, Land and Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: -5.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, -0.123, -0.017, 0.16, 0.178, 0.438, 0.667, 0.682, 0.283, 0.01, -0.25, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, -0.843, -0.669, -0.427, -0.168, 0.087, 0.192, 0.198, -0.191, -0.358, -0.786, -0.972, -0.803, -0.854, -0.718, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, -0.875, -0.842, -0.585, -0.287, 0.032, 0.159, 0.082, -0.128, -0.181, -0.526, -0.741, -0.728, -0.863, -0.878, -0.664, -0.481, -0.099, -0.105, -0.057, -0.332, -0.414, -0.578, -0.874, -0.833, -0.772, -0.718, -0.585, -0.441, -0.035, -0.203, -0.06, -0.294, -0.153, -0.238, -0.421, -0.592, -0.716, -0.764, -0.758, -0.496, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -0.472, -0.571, -0.415, -0.235, -0.067, 0.233, 0.11, 0.128, -0.051, -0.021, -0.152, -0.312, -0.473, -0.576, -0.44, -0.388, -0.073, 0.097, 0.111, 0.064, -0.096, -0.131, -0.19, -0.385, -0.502, -0.626, -0.488, -0.328, -0.08, 0.09, 0.178, 0.063, -0.104, -0.164, -0.245, -0.321, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 0.048, 0.234, 0.418, 0.369, 0.566, 0.683, 0.792, 0.444, 0.194, -0.066, -0.222, 0.113, 0.378, 0.426, 0.496, 0.539, 0.673, 0.702, 0.609, 0.52, 0.471, 0.439, 0.375, 0.371, 0.343, 0.469, 0.48, 0.57, 0.708, 0.522, 0.56, 0.515, 0.543, 0.379, 0.322, 0.288, 0.328, 0.368, 0.358, 0.563, 0.706, 0.626, 0.185, 0.154, 0.11, 0.0, -0.112, -0.224, -0.243, -0.084, -0.005, 0.011, 0.09, 0.135, 0.108, -0.039, 0.015, -0.089, -0.199, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -0.312, -0.399, -0.463, -0.476, -0.331, -0.217, -0.198, -0.18, -0.112, -0.137, -0.194, -0.287, -0.36, -0.555, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_WaterVapor_Bias_840hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 840 hPa Level Statistics, Land and Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 50.0,
          min: -50.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 0.19, 3.305, 9.998, 8.629, 5.626, 4.92, 4.263, 3.866, 8.545, 6.123, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 4.189, 8.177, 13.332, 12.226, 10.931, 10.268, 7.068, 7.145, 9.577, 5.643, 5.096, 3.505, 3.829, 2.505, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 5.04, 8.276, 11.554, 8.524, 7.6, 7.538, 6.661, 5.915, 11.968, 10.243, 8.702, 5.153, 4.597, 5.789, 11.549, 10.172, 9.364, 6.793, 8.999, 8.214, 8.888, 10.599, 8.552, 6.174, 2.074, 3.993, 8.084, 3.184, 3.73, 3.708, 6.021, 4.298, 3.812, 5.375, 1.554, 0.988, -0.168, 0.895, 2.852, 1.931, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 5.162, 4.817, 6.609, 10.19, 5.668, 6.217, 5.422, 7.632, 5.305, 5.28, 6.402, 5.602, 4.278, 2.818, 3.797, 4.988, 6.042, 6.715, 4.189, 4.963, 5.655, 6.573, 5.94, 3.859, 2.652, 1.978, 3.209, 7.688, 10.076, 7.978, 11.41, 7.266, 8.407, 7.85, 6.061, 4.871, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 2.89, 6.487, 13.088, 12.468, 9.816, 9.404, 7.069, 6.289, 10.058, 7.098, 3.723, 1.958, 3.827, 5.826, 11.48, 10.612, 9.315, 6.087, 6.655, 7.877, 7.485, 6.739, 5.538, 3.122, 3.746, 6.363, 11.245, 7.021, 7.051, 6.26, 7.076, 5.449, 5.069, 5.994, 3.658, 1.119, 1.017, 3.177, 5.659, 5.074, 4.41, 3.072, 2.885, 3.24, 3.439, 2.821, 0.322, -2.102, -1.179, 0.677, 5.491, 8.197, 5.755, 8.606, 5.692, 5.409, 4.36, 2.527, -0.34, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 6.146, 4.2, 2.114, 2.609, 4.169, 8.312, 10.787, 7.781, 10.717, 5.986, 7.368, 7.02, 6.027, 4.422, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_Temperature_StdDev_840hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 840 hPa Level Statistics, Land and Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.754, 1.924, 2.048, 2.096, 2.359, 2.516, 2.649, 2.386, 2.198, 2.054, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 2.017, 2.168, 2.326, 2.299, 2.538, 2.711, 2.811, 2.455, 2.353, 2.147, 2.069, 2.001, 2.039, 2.221, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 2.073, 2.219, 2.344, 2.372, 2.587, 2.731, 2.772, 2.587, 2.494, 2.266, 2.136, 2.075, 2.094, 2.168, 2.308, 2.394, 2.716, 2.59, 2.583, 2.437, 2.385, 2.233, 2.113, 2.039, 1.907, 2.066, 2.109, 2.178, 2.441, 2.439, 2.423, 2.376, 2.351, 2.206, 2.028, 2.072, 2.121, 2.095, 2.2, 2.235, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.935, 1.943, 2.04, 2.027, 2.046, 2.237, 2.199, 2.268, 2.197, 2.188, 2.156, 2.021, 1.958, 1.951, 1.987, 2.042, 2.163, 2.197, 2.274, 2.239, 2.287, 2.276, 2.225, 2.095, 2.061, 2.015, 2.075, 2.095, 2.166, 2.233, 2.347, 2.373, 2.378, 2.373, 2.326, 2.257, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.793, 1.911, 2.089, 2.081, 2.293, 2.418, 2.577, 2.367, 2.192, 2.103, 1.932, 1.882, 1.859, 1.901, 2.009, 2.051, 2.31, 2.24, 2.196, 2.145, 2.123, 2.079, 1.947, 1.865, 1.872, 1.937, 1.967, 2.022, 2.24, 2.175, 2.208, 2.133, 2.156, 2.09, 1.956, 1.873, 1.834, 1.841, 1.958, 2.151, 2.252, 2.269, 2.199, 2.176, 2.199, 2.119, 2.001, 1.931, 1.868, 1.9, 1.976, 2.041, 2.171, 2.165, 2.24, 2.156, 2.207, 2.11, 2.02, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 2.09, 1.926, 1.84, 1.791, 1.852, 1.93, 1.979, 2.11, 2.134, 2.195, 2.111, 2.13, 2.043, 2.033, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_WaterVapor_StdDev_840hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 840 hPa Level Statistics, Land and Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 23.067, 24.325, 28.782, 29.002, 27.629, 29.39, 28.014, 28.553, 29.474, 27.366, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 21.631, 25.146, 30.58, 30.286, 31.291, 33.102, 29.356, 28.823, 28.417, 25.166, 23.521, 21.52, 22.044, 26.026, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 22.328, 25.804, 30.417, 29.516, 29.456, 31.028, 28.563, 27.997, 29.784, 27.352, 25.643, 22.584, 22.579, 24.674, 29.741, 29.727, 30.858, 29.05, 29.471, 28.134, 28.838, 29.127, 26.16, 24.024, 21.24, 23.835, 27.486, 25.21, 26.607, 27.606, 29.055, 27.736, 25.462, 25.197, 23.106, 22.767, 22.051, 23.552, 26.015, 26.03, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 22.425, 21.917, 24.773, 27.316, 25.441, 27.039, 29.069, 29.905, 26.87, 25.093, 24.902, 24.409, 22.989, 22.782, 23.606, 25.984, 26.218, 27.728, 27.971, 27.861, 27.881, 27.921, 27.929, 24.242, 22.225, 21.904, 23.032, 27.643, 47.229, 29.398, 53.347, 29.989, 29.199, 28.383, 26.122, 24.544, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 21.698, 24.255, 28.76, 29.093, 27.251, 28.602, 27.11, 28.03, 28.516, 25.96, 23.297, 22.212, 22.282, 24.59, 27.937, 27.565, 29.162, 27.14, 27.22, 27.718, 26.846, 26.563, 24.294, 22.53, 22.064, 24.824, 27.442, 25.645, 26.69, 27.462, 28.424, 27.043, 25.739, 25.323, 24.151, 22.269, 22.355, 23.743, 26.032, 26.139, 26.753, 26.835, 26.246, 26.737, 27.101, 26.069, 23.494, 21.136, 38.914, 22.391, 26.545, 50.172, 51.667, 51.029, 51.945, 27.672, 27.196, 25.333, 41.689, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 26.316, 24.142, 21.44, 40.959, 22.44, 26.698, 47.894, 53.318, 52.104, 28.254, 27.768, 27.757, 25.773, 24.202, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_Temperature_RMS_840hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 840 hPa Level Statistics, Land and Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 1.758, 1.924, 2.055, 2.104, 2.399, 2.603, 2.736, 2.403, 2.198, 2.069, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 2.186, 2.269, 2.365, 2.305, 2.54, 2.718, 2.818, 2.462, 2.38, 2.287, 2.286, 2.156, 2.211, 2.334, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 2.25, 2.374, 2.416, 2.389, 2.587, 2.736, 2.773, 2.59, 2.5, 2.327, 2.261, 2.199, 2.265, 2.339, 2.401, 2.442, 2.718, 2.592, 2.584, 2.459, 2.421, 2.307, 2.287, 2.203, 2.057, 2.187, 2.188, 2.223, 2.442, 2.448, 2.423, 2.394, 2.356, 2.219, 2.072, 2.155, 2.239, 2.23, 2.327, 2.289, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.992, 2.025, 2.082, 2.041, 2.047, 2.249, 2.202, 2.272, 2.198, 2.188, 2.162, 2.045, 2.014, 2.034, 2.036, 2.079, 2.164, 2.199, 2.277, 2.239, 2.289, 2.28, 2.234, 2.13, 2.122, 2.11, 2.132, 2.12, 2.168, 2.235, 2.354, 2.373, 2.38, 2.379, 2.339, 2.28, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 1.794, 1.926, 2.131, 2.114, 2.362, 2.513, 2.696, 2.409, 2.2, 2.104, 1.944, 1.885, 1.897, 1.948, 2.069, 2.12, 2.406, 2.348, 2.279, 2.207, 2.175, 2.125, 1.983, 1.901, 1.903, 1.993, 2.025, 2.101, 2.35, 2.237, 2.278, 2.194, 2.224, 2.124, 1.982, 1.895, 1.863, 1.878, 1.991, 2.224, 2.36, 2.354, 2.207, 2.181, 2.202, 2.119, 2.004, 1.944, 1.883, 1.902, 1.976, 2.041, 2.173, 2.169, 2.243, 2.156, 2.207, 2.112, 2.03, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 2.113, 1.967, 1.897, 1.853, 1.882, 1.942, 1.989, 2.118, 2.137, 2.199, 2.12, 2.15, 2.075, 2.108, null] 
        }]
    })
    $('#nucapsirmw_LandAndSea_WaterVapor_RMS_840hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 840 hPa Level Statistics, Land and Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#0000ff', '#009600', '#ff00ff', '#009696', '#ff7f00', '#c800c8'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP IR+MW',
data: [
null, 23.572, 24.522, 28.791, 29.019, 27.743, 29.595, 28.271, 29.433, 29.677, 27.64, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A IR+MW',
data: [
null, 21.631, 25.19, 30.681, 30.309, 31.292, 33.126, 29.415, 29.021, 28.418, 25.203, 23.525, 21.537, 22.052, 26.192, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B IR+MW',
data: [
null, 22.328, 25.809, 30.419, 29.585, 29.601, 31.306, 28.776, 28.64, 29.805, 27.352, 25.696, 22.584, 22.58, 24.71, 29.741, 29.734, 30.916, 29.373, 29.592, 28.413, 29.003, 29.132, 26.178, 24.025, 21.433, 24.039, 27.616, 25.738, 27.207, 28.462, 29.889, 28.525, 26.331, 25.539, 23.504, 23.237, 22.701, 24.272, 26.633, 27.093, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 22.426, 21.918, 24.777, 27.319, 25.505, 27.123, 29.361, 30.205, 27.13, 25.305, 24.982, 24.42, 23.029, 22.945, 23.78, 26.109, 26.362, 28.018, 28.621, 28.371, 28.164, 28.075, 28.053, 24.354, 22.366, 22.143, 23.215, 27.704, 85.882, 29.505, 76.054, 30.178, 29.265, 28.448, 26.175, 24.589, null] }, { 
            name: 'NUCAPS NOAA-20 IR+MW',
data: [
null, 21.79, 24.26, 28.907, 29.15, 27.253, 28.603, 27.158, 28.445, 28.55, 26.012, 23.402, 22.431, 22.335, 24.643, 27.946, 27.57, 29.162, 27.245, 27.326, 27.87, 26.921, 26.634, 24.312, 22.648, 22.116, 24.844, 27.469, 25.657, 26.708, 27.584, 28.633, 27.337, 26.035, 25.489, 24.37, 22.741, 22.859, 24.128, 26.253, 26.481, 27.276, 27.675, 27.174, 27.67, 27.942, 26.771, 24.348, 22.391, 44.281, 23.21, 26.894, 80.322, 66.936, 77.757, 68.728, 28.136, 27.799, 25.942, 47.795, null] }, { 
            name: 'NUCAPS NOAA-21 IR+MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 26.384, 24.225, 21.592, 44.722, 22.512, 26.701, 85.339, 68.174, 79.328, 28.39, 27.83, 27.828, 25.811, 24.237, null] 
        }]
    })
    $('#nucapsmw_Sea_Temperature_Bias_10hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 10 hPa Level Statistics, Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: -5.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, 0.048, -0.303, -0.24, -0.27, -1.088, -1.046, -0.278, -0.169, -0.549, -0.861, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, -0.633, -0.833, -1.133, -1.307, -1.591, -1.559, -0.941, -1.302, -1.427, -1.295, -1.019, -1.124, -0.978, -0.526, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, -0.284, -0.253, -0.536, -0.993, -1.066, -0.842, -0.553, -0.81, -0.797, -1.009, -0.851, -0.99, -0.318, -0.079, -0.79, -0.639, -0.435, -0.627, -0.551, -0.66, -0.852, -0.75, -0.667, -0.697, -0.323, -0.372, -0.174, -0.037, -0.338, -0.24, -0.38, -0.159, 0.392, -0.366, -0.736, -0.47, -0.297, -0.499, -0.631, -0.743, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -0.739, -0.071, -0.102, 0.096, 0.14, 0.024, -0.003, -0.525, 0.285, 0.488, -0.052, -0.449, -0.334, -0.078, -0.044, -0.138, -0.217, 0.204, 0.275, 0.116, 0.23, 0.393, -0.07, -0.402, -0.204, -0.294, -0.277, -0.278, -0.113, -0.044, -0.053, -0.315, -0.124, 0.107, -0.513, -0.129, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, 0.269, 0.312, 0.018, -0.335, -0.639, -0.356, 0.088, -0.004, -0.277, 0.048, 0.136, -0.394, 0.276, 0.156, -0.011, -0.003, 0.598, 0.253, 0.006, 0.132, 0.297, -0.463, -0.504, -0.141, 0.382, -0.142, 0.095, 0.443, 0.009, 0.09, -0.437, 0.413, 0.793, 0.009, -0.238, -0.188, -0.017, -0.13, 0.159, 0.054, 0.725, 0.711, 0.424, 0.246, 0.667, 0.191, 0.214, 0.1, 0.271, 0.003, 0.319, 0.289, 0.462, 0.387, -0.039, 0.251, 0.065, -0.679, -0.149, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.543, 0.583, 0.633, 0.518, 0.491, 0.378, 0.686, 0.913, 0.557, 0.171, 0.528, 0.65, -0.337, 0.293, null] 
        }]
    })
    $('#nucapsmw_Sea_WaterVapor_Bias_10hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 10 hPa Level Statistics, Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 50.0,
          min: -50.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, -92.339, -95.147, -93.593, -94.637, -94.262, -91.731, -93.196, -93.487, -95.299, -95.088, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, -94.01, -93.78, -94.655, -93.824, -94.373, -93.093, -92.706, -93.927, -94.386, -93.867, -97.02, -97.074, -94.109, -95.808, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, -93.893, -94.302, -94.107, -94.289, -93.177, -91.823, -92.896, -96.573, -95.291, -93.722, -95.333, -96.595, -94.228, -94.766, -93.745, -96.612, -93.016, -93.558, -93.775, -94.571, -93.986, -95.136, -95.93, -96.676, -96.163, -96.153, -95.813, -93.128, -93.058, -92.546, -91.814, -92.972, -93.833, -93.584, -94.18, -95.351, -94.43, -92.501, -92.963, -93.5, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -96.098, -96.979, -95.598, -95.13, -93.659, -92.685, -92.858, -92.246, -95.811, -93.208, -93.76, -94.758, -93.724, -93.638, -93.141, -92.344, -92.947, -92.397, -91.865, -92.792, -93.236, -94.376, -93.27, -95.048, -95.584, -94.639, -93.615, -92.936, -93.344, -94.007, -94.632, -94.365, -93.595, -95.043, -94.795, -95.63, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, -93.497, -92.325, -94.585, -94.636, -92.857, -91.688, -94.283, -93.309, -93.307, -92.229, -91.071, -95.355, -95.575, -97.0, -95.625, -98.624, -96.494, -96.2, -96.873, -96.633, -96.234, -97.268, -95.855, -96.273, -95.911, -95.87, -94.647, -93.101, -93.73, -93.374, -92.377, -93.527, -93.177, -94.132, -93.538, -92.218, -92.51, -92.179, -93.842, -93.248, -91.747, -91.63, -92.946, -93.557, -94.1, -93.525, -95.828, -92.834, -93.196, -93.484, -93.136, -93.436, -93.842, -94.424, -94.105, -93.967, -96.136, -95.43, -94.534, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -93.05, -95.896, -92.606, -93.525, -93.619, -92.85, -93.622, -93.659, -95.337, -93.834, -94.178, -96.354, -95.504, -94.379, null] 
        }]
    })
    $('#nucapsmw_Sea_Temperature_StdDev_10hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 10 hPa Level Statistics, Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, 2.029, 2.012, 1.875, 2.328, 2.424, 2.077, 2.211, 1.934, 2.234, 1.988, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, 2.282, 2.389, 2.127, 2.212, 2.38, 2.4, 2.467, 2.352, 2.142, 2.163, 2.052, 2.394, 2.039, 2.363, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, 2.219, 2.167, 2.048, 2.357, 2.398, 2.295, 2.559, 2.343, 2.258, 1.934, 2.104, 2.018, 2.064, 2.222, 2.373, 2.454, 2.281, 2.288, 2.235, 2.217, 2.155, 2.137, 2.31, 2.096, 2.119, 2.265, 2.018, 2.254, 2.392, 2.144, 2.144, 2.121, 2.049, 2.039, 2.086, 2.265, 2.075, 2.038, 2.093, 2.463, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.844, 2.082, 2.175, 2.029, 2.194, 2.323, 2.165, 2.241, 2.257, 2.279, 1.924, 2.065, 2.091, 2.256, 1.983, 2.081, 2.172, 2.619, 2.552, 2.493, 2.277, 2.313, 1.918, 2.21, 2.134, 2.384, 2.32, 1.925, 2.127, 2.26, 2.086, 1.997, 2.115, 1.752, 2.069, 2.261, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, 2.031, 1.991, 1.969, 2.265, 2.456, 3.508, 2.42, 2.126, 2.193, 2.1, 2.079, 2.14, 2.399, 2.1, 2.625, 2.606, 2.456, 2.668, 2.375, 2.037, 2.366, 2.016, 1.926, 1.766, 2.165, 2.144, 1.878, 2.21, 2.466, 2.122, 2.087, 2.11, 1.972, 2.039, 2.015, 2.042, 1.901, 2.099, 1.986, 2.157, 2.925, 2.884, 2.587, 2.276, 2.321, 1.749, 2.47, 2.03, 2.697, 2.174, 1.999, 2.366, 2.19, 2.093, 1.951, 2.073, 2.005, 2.115, 2.103, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.808, 3.678, 2.011, 2.386, 2.445, 2.201, 2.351, 2.057, 2.108, 2.306, 2.247, 1.995, 2.071, 1.809, null] 
        }]
    })
    $('#nucapsmw_Sea_WaterVapor_StdDev_10hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 10 hPa Level Statistics, Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, 3.576, 1.548, 3.319, 2.455, 2.224, 3.993, 3.223, 3.161, 2.019, 2.073, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, 2.566, 2.729, 2.304, 2.926, 1.798, 2.343, 3.519, 3.111, 2.671, 3.063, 0.803, 0.965, 2.264, 1.781, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, 2.683, 2.291, 2.937, 2.242, 2.845, 3.925, 3.595, 0.681, 1.981, 3.138, 1.636, 1.284, 2.214, 2.056, 3.177, 0.547, 3.143, 2.516, 2.511, 1.963, 3.047, 1.492, 1.419, 0.805, 1.502, 1.465, 1.646, 3.418, 3.022, 3.279, 4.105, 2.712, 2.684, 2.734, 2.613, 1.095, 2.166, 2.992, 3.488, 3.269, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.916, 0.997, 1.659, 2.002, 3.178, 3.039, 3.552, 3.382, 0.886, 3.002, 3.079, 2.049, 2.804, 2.986, 3.401, 3.211, 2.97, 3.363, 3.699, 2.93, 3.245, 2.082, 2.507, 2.192, 1.466, 2.373, 3.117, 3.443, 2.587, 3.004, 2.57, 2.855, 3.067, 2.493, 2.383, 1.553, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, 2.318, 3.862, 2.589, 2.695, 3.504, 3.991, 2.316, 3.086, 3.212, 3.289, 3.194, 1.974, 1.672, 0.922, 2.239, 0.225, 1.244, 1.537, 0.977, 1.396, 1.704, 1.009, 2.046, 1.684, 1.443, 1.23, 2.726, 2.462, 3.097, 3.212, 3.076, 2.162, 2.042, 2.848, 2.513, 2.448, 3.018, 2.355, 2.553, 2.612, 3.572, 3.342, 2.746, 2.234, 1.825, 2.296, 1.122, 3.473, 2.779, 2.157, 3.493, 2.336, 2.165, 2.44, 2.09, 2.656, 1.937, 1.789, 1.881, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 2.337, 1.128, 3.219, 3.135, 2.216, 2.82, 2.215, 2.111, 1.977, 2.301, 2.588, 1.824, 1.739, 1.958, null] 
        }]
    })
    $('#nucapsmw_Sea_Temperature_RMS_10hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 10 hPa Level Statistics, Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, 2.03, 2.035, 1.89, 2.344, 2.657, 2.326, 2.229, 1.942, 2.3, 2.167, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, 2.368, 2.53, 2.41, 2.569, 2.862, 2.862, 2.64, 2.688, 2.574, 2.521, 2.291, 2.645, 2.261, 2.421, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, 2.237, 2.182, 2.118, 2.558, 2.624, 2.445, 2.618, 2.479, 2.395, 2.181, 2.27, 2.248, 2.089, 2.223, 2.501, 2.536, 2.322, 2.372, 2.302, 2.313, 2.318, 2.265, 2.404, 2.209, 2.144, 2.296, 2.026, 2.255, 2.416, 2.157, 2.178, 2.127, 2.086, 2.071, 2.212, 2.313, 2.096, 2.099, 2.186, 2.573, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.987, 2.083, 2.178, 2.031, 2.199, 2.323, 2.165, 2.302, 2.275, 2.331, 1.924, 2.114, 2.118, 2.257, 1.983, 2.085, 2.183, 2.627, 2.567, 2.496, 2.288, 2.346, 1.92, 2.247, 2.144, 2.402, 2.336, 1.945, 2.13, 2.261, 2.087, 2.022, 2.119, 1.756, 2.132, 2.265, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, 2.049, 2.015, 1.969, 2.289, 2.538, 3.526, 2.422, 2.126, 2.211, 2.1, 2.084, 2.176, 2.415, 2.106, 2.625, 2.606, 2.528, 2.68, 2.375, 2.041, 2.385, 2.069, 1.991, 1.772, 2.199, 2.148, 1.88, 2.254, 2.466, 2.124, 2.133, 2.15, 2.126, 2.039, 2.029, 2.051, 1.901, 2.103, 1.992, 2.158, 3.013, 2.971, 2.621, 2.29, 2.415, 1.759, 2.479, 2.033, 2.711, 2.174, 2.025, 2.384, 2.238, 2.129, 1.951, 2.088, 2.006, 2.221, 2.108, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.888, 3.724, 2.109, 2.441, 2.493, 2.233, 2.449, 2.251, 2.181, 2.312, 2.309, 2.099, 2.099, 1.833, null] 
        }]
    })
    $('#nucapsmw_Sea_WaterVapor_RMS_10hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 10 hPa Level Statistics, Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, 97.499, 99.472, 96.268, 98.527, 98.992, 97.068, 97.815, 95.596, 98.929, 98.922, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, 98.55, 98.506, 98.803, 98.144, 99.388, 99.102, 97.56, 97.503, 98.174, 97.06, 99.759, 99.611, 98.888, 98.952, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, 98.372, 98.901, 97.766, 98.999, 98.561, 97.13, 96.821, 99.855, 98.997, 96.345, 99.368, 99.375, 98.899, 98.993, 97.391, 99.913, 98.134, 98.853, 98.773, 99.219, 97.575, 99.503, 99.398, 99.777, 99.274, 99.323, 99.229, 96.111, 94.784, 94.504, 95.27, 94.16, 98.461, 95.168, 98.362, 99.723, 98.945, 93.989, 95.746, 96.535, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 98.508, 99.619, 99.25, 98.999, 97.032, 94.306, 96.042, 94.174, 99.806, 95.006, 96.534, 99.004, 98.219, 97.867, 96.21, 94.037, 94.502, 94.425, 94.194, 94.253, 95.643, 99.116, 94.431, 98.638, 99.436, 98.555, 96.115, 95.483, 94.544, 96.837, 96.572, 97.257, 97.832, 97.451, 96.379, 99.343, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, 99.043, 97.043, 98.309, 97.938, 95.598, 97.074, 98.887, 95.088, 95.542, 93.892, 92.49, 99.087, 99.27, 99.697, 97.658, 99.961, 99.509, 99.228, 99.665, 99.265, 98.941, 99.559, 97.69, 98.936, 99.417, 99.61, 97.429, 94.143, 97.255, 97.528, 93.919, 94.316, 93.838, 96.396, 94.831, 93.135, 94.145, 92.942, 98.672, 94.457, 93.802, 93.32, 94.269, 94.447, 94.723, 94.537, 99.678, 95.682, 94.648, 94.254, 96.617, 94.417, 94.76, 95.966, 94.982, 98.464, 98.139, 96.312, 95.328, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 93.984, 99.668, 94.565, 97.575, 94.478, 94.133, 94.523, 94.504, 98.919, 94.869, 98.477, 98.137, 96.345, 95.259, null] 
        }]
    })
    $('#nucapsmw_Land_Temperature_Bias_10hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 10 hPa Level Statistics, Land, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: -5.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, 0.06, -0.117, -0.292, -0.421, -0.415, -0.055, -0.316, -0.637, -0.634, -0.39, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, -0.329, -0.458, -0.561, -0.702, -0.714, -0.522, -0.632, -0.979, -0.832, -0.582, -0.131, -0.204, -0.244, -0.25, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, 0.13, 0.025, -0.127, -0.263, -0.293, -0.109, -0.083, -0.483, -0.418, -0.17, 0.325, 0.247, 0.199, 0.136, -0.046, -0.258, 0.331, 0.09, -0.18, -0.398, -0.569, -0.38, -0.042, 0.006, 0.001, 0.053, -0.133, -0.181, -0.362, -0.078, -0.3, -0.244, -0.289, -0.028, 0.082, 0.112, 0.148, 0.103, -0.19, -0.306, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.152, 0.299, 0.328, 0.1, 0.069, -0.109, 0.151, -0.117, -0.09, -0.08, 0.215, 0.323, 0.441, 0.481, 0.39, 0.086, -0.294, -0.184, 0.349, 0.199, 0.064, 0.106, 0.18, 0.269, 0.408, 0.393, 0.363, 0.103, -0.055, -0.009, 0.039, -0.155, 0.099, 0.056, 0.145, 0.328, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, 0.371, 0.273, 0.116, 0.044, 0.035, 0.333, 0.133, -0.204, -0.235, 0.017, 0.515, 0.434, 0.301, 0.234, 0.12, 0.038, 0.535, 0.25, -0.111, -0.104, -0.28, -0.185, 0.023, 0.186, 0.21, 0.195, 0.073, 0.078, -0.039, 0.293, -0.008, -0.06, -0.118, 0.171, 0.23, 0.32, 0.377, 0.256, -0.03, -0.274, -0.055, 0.478, 0.214, 0.028, 0.03, 0.112, 0.307, 0.459, 0.436, 0.407, 0.189, 0.179, 0.197, 0.268, -0.127, 0.064, 0.001, 0.089, 0.182, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.4, 0.581, 0.711, 0.7, 0.665, 0.456, 0.417, 0.467, 0.52, 0.147, 0.357, 0.293, 0.365, 0.414, null] 
        }]
    })
    $('#nucapsmw_Land_WaterVapor_Bias_10hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 10 hPa Level Statistics, Land, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 50.0,
          min: -50.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, -98.313, -96.897, -95.468, -91.231, -92.719, -95.504, -93.893, -93.828, -97.136, -97.837, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, -98.346, -96.817, -95.39, -91.113, -92.717, -95.521, -93.953, -93.97, -97.126, -97.98, -98.697, -98.723, -98.307, -97.725, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, -98.348, -96.904, -95.46, -91.177, -92.473, -94.974, -93.151, -94.102, -97.136, -97.938, -98.713, -98.715, -98.317, -97.507, -95.811, -93.644, -93.384, -93.077, -92.778, -95.797, -97.034, -97.953, -98.706, -98.862, -99.073, -98.327, -97.145, -96.116, -96.743, -96.861, -97.497, -96.241, -97.306, -98.46, -98.997, -99.059, -98.834, -98.121, -97.132, -94.922, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -99.182, -99.076, -98.294, -97.141, -96.121, -96.799, -96.868, -97.458, -96.171, -97.327, -98.457, -98.98, -99.058, -98.84, -98.111, -97.117, -94.863, -94.124, -95.053, -95.739, -97.158, -97.322, -98.466, -99.02, -98.991, -98.816, -98.17, -96.974, -95.945, -96.105, -96.153, -95.857, -97.785, -97.586, -98.472, -98.967, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, -98.312, -96.829, -95.401, -91.281, -92.732, -95.523, -93.832, -93.932, -97.134, -97.949, -98.687, -98.959, -98.982, -98.475, -97.524, -96.293, -96.159, -96.189, -96.315, -97.833, -98.28, -98.781, -99.192, -99.271, -99.065, -98.308, -97.137, -96.149, -96.733, -96.845, -97.438, -96.269, -97.281, -98.459, -98.971, -99.039, -98.83, -98.113, -97.112, -94.856, -94.12, -95.033, -96.201, -97.129, -97.282, -98.448, -99.0, -98.972, -98.791, -98.105, -96.933, -95.943, -96.023, -96.13, -95.819, -97.811, -97.568, -98.457, -98.97, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -98.534, -99.005, -98.97, -98.792, -98.107, -96.939, -95.942, -96.02, -96.162, -95.838, -97.806, -97.533, -98.438, -98.858, null] 
        }]
    })
    $('#nucapsmw_Land_Temperature_StdDev_10hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 10 hPa Level Statistics, Land, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, 2.134, 1.878, 2.122, 2.309, 2.437, 2.744, 2.292, 2.263, 2.228, 2.255, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, 2.153, 1.925, 2.072, 2.197, 2.458, 2.79, 2.339, 2.338, 2.226, 2.155, 2.284, 2.282, 2.126, 2.089, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, 2.141, 1.922, 2.054, 2.178, 2.408, 2.728, 2.326, 2.277, 2.21, 2.165, 2.274, 2.269, 2.139, 1.987, 2.061, 2.211, 2.685, 2.467, 2.483, 2.324, 2.024, 2.03, 2.205, 2.233, 2.081, 1.966, 2.021, 2.252, 2.582, 2.551, 2.329, 2.145, 2.034, 2.038, 2.09, 2.126, 2.079, 1.958, 2.088, 2.225, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 2.141, 2.026, 1.951, 2.007, 2.215, 2.609, 2.533, 2.329, 2.13, 1.993, 1.99, 2.061, 2.09, 2.032, 1.903, 2.059, 2.327, 2.426, 2.585, 2.438, 2.136, 1.89, 1.99, 2.133, 2.15, 2.02, 1.99, 2.004, 2.338, 2.38, 2.448, 2.399, 2.371, 1.927, 1.954, 2.022, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, 2.033, 1.814, 2.001, 2.19, 2.395, 2.662, 2.292, 2.263, 2.17, 2.128, 2.187, 2.255, 2.038, 1.961, 1.998, 2.368, 2.723, 2.489, 2.51, 2.271, 1.957, 1.931, 2.096, 2.153, 2.075, 1.865, 1.886, 2.142, 2.623, 2.568, 2.428, 2.124, 1.957, 2.034, 1.983, 2.15, 2.02, 1.916, 1.998, 2.265, 2.458, 2.547, 2.425, 2.222, 1.88, 1.926, 2.095, 2.061, 1.963, 1.954, 1.909, 2.525, 2.491, 2.441, 2.37, 2.376, 1.864, 1.977, 2.018, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.978, 2.098, 2.101, 1.957, 1.92, 1.911, 2.495, 2.567, 2.437, 2.425, 2.441, 1.982, 1.904, 2.163, null] 
        }]
    })
    $('#nucapsmw_Land_WaterVapor_StdDev_10hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 10 hPa Level Statistics, Land, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, 0.694, 1.377, 1.813, 3.504, 1.881, 1.05, 1.378, 2.473, 1.021, 0.958, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, 0.685, 1.419, 1.864, 3.598, 1.816, 1.066, 1.38, 2.471, 1.021, 0.928, 0.608, 0.563, 0.788, 1.043, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, 0.687, 1.385, 1.8, 3.561, 1.974, 1.271, 2.804, 2.331, 1.009, 0.948, 0.601, 0.572, 0.787, 1.123, 1.571, 1.758, 0.626, 1.439, 1.582, 1.073, 1.222, 0.946, 0.579, 0.502, 0.475, 0.756, 1.175, 1.27, 0.914, 0.318, 0.446, 1.054, 1.03, 0.705, 0.471, 0.423, 0.596, 0.808, 0.954, 1.873, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.389, 0.45, 0.779, 1.182, 1.272, 0.898, 0.327, 0.47, 1.119, 1.0, 0.687, 0.465, 0.404, 0.587, 0.818, 0.96, 1.727, 1.445, 0.775, 1.258, 0.8, 1.146, 0.72, 0.521, 0.444, 0.539, 0.807, 1.163, 1.403, 0.81, 0.888, 0.865, 0.414, 0.813, 0.693, 0.352, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, 0.689, 1.443, 1.858, 3.486, 1.858, 1.048, 1.381, 2.411, 1.019, 0.924, 0.591, 0.477, 0.357, 0.619, 0.891, 1.043, 0.405, 0.853, 0.798, 0.542, 0.685, 0.581, 0.412, 0.333, 0.429, 0.765, 1.186, 1.277, 0.934, 0.34, 0.45, 1.044, 1.021, 0.699, 0.478, 0.461, 0.607, 0.787, 0.967, 1.743, 1.444, 0.78, 1.102, 0.827, 1.213, 0.74, 0.491, 0.472, 0.507, 0.858, 1.179, 1.409, 0.88, 0.881, 0.864, 0.386, 0.828, 0.705, 0.312, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.697, 0.471, 0.475, 0.537, 0.845, 1.175, 1.408, 0.877, 0.868, 0.869, 0.398, 0.905, 0.737, 0.573, null] 
        }]
    })
    $('#nucapsmw_Land_Temperature_RMS_10hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 10 hPa Level Statistics, Land, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, 2.134, 1.881, 2.142, 2.347, 2.472, 2.745, 2.314, 2.351, 2.317, 2.289, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, 2.178, 1.979, 2.147, 2.306, 2.559, 2.839, 2.423, 2.535, 2.376, 2.233, 2.287, 2.291, 2.14, 2.104, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, 2.145, 1.922, 2.057, 2.193, 2.425, 2.73, 2.327, 2.327, 2.25, 2.172, 2.297, 2.282, 2.148, 1.992, 2.061, 2.226, 2.705, 2.469, 2.49, 2.358, 2.102, 2.066, 2.205, 2.233, 2.081, 1.966, 2.026, 2.259, 2.608, 2.553, 2.349, 2.159, 2.055, 2.038, 2.091, 2.129, 2.085, 1.961, 2.097, 2.246, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 2.146, 2.048, 1.978, 2.01, 2.216, 2.611, 2.538, 2.332, 2.132, 1.995, 2.002, 2.087, 2.136, 2.088, 1.942, 2.061, 2.345, 2.433, 2.608, 2.446, 2.137, 1.893, 1.998, 2.15, 2.188, 2.058, 2.023, 2.007, 2.339, 2.38, 2.448, 2.404, 2.373, 1.927, 1.96, 2.048, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, 2.067, 1.834, 2.005, 2.19, 2.395, 2.683, 2.296, 2.273, 2.183, 2.128, 2.247, 2.296, 2.06, 1.975, 2.002, 2.369, 2.776, 2.501, 2.513, 2.273, 1.977, 1.94, 2.096, 2.161, 2.086, 1.875, 1.887, 2.144, 2.623, 2.585, 2.428, 2.125, 1.961, 2.041, 1.997, 2.174, 2.055, 1.933, 1.998, 2.282, 2.458, 2.592, 2.434, 2.223, 1.881, 1.93, 2.117, 2.111, 2.011, 1.996, 1.918, 2.532, 2.499, 2.456, 2.374, 2.376, 1.864, 1.979, 2.026, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 2.018, 2.177, 2.218, 2.078, 2.032, 1.965, 2.53, 2.609, 2.492, 2.43, 2.467, 2.004, 1.939, 2.202, null] 
        }]
    })
    $('#nucapsmw_Land_WaterVapor_RMS_10hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 10 hPa Level Statistics, Land, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, 99.535, 99.143, 99.091, 98.322, 99.485, 99.732, 99.671, 98.819, 99.598, 99.358, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, 99.54, 99.094, 99.041, 98.266, 99.521, 99.722, 99.666, 98.777, 99.599, 99.361, 99.563, 99.574, 99.466, 99.31, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, 99.541, 99.139, 99.108, 98.29, 99.455, 99.66, 98.613, 98.911, 99.618, 99.35, 99.57, 99.563, 99.451, 99.293, 99.301, 99.455, 99.935, 99.698, 99.642, 99.689, 99.362, 99.391, 99.624, 99.569, 99.686, 99.521, 99.396, 99.517, 99.696, 99.958, 99.926, 99.662, 99.514, 99.544, 99.699, 99.72, 99.663, 99.558, 99.603, 99.19, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 99.704, 99.688, 99.532, 99.387, 99.513, 99.698, 99.957, 99.925, 99.627, 99.537, 99.549, 99.689, 99.716, 99.663, 99.55, 99.598, 99.335, 99.624, 99.885, 99.603, 99.76, 99.348, 99.462, 99.72, 99.733, 99.657, 99.537, 99.462, 99.453, 99.818, 99.768, 99.802, 99.89, 99.7, 99.571, 99.829, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, 99.532, 99.042, 99.039, 98.333, 99.495, 99.731, 99.673, 98.871, 99.595, 99.353, 99.558, 99.645, 99.679, 99.578, 99.592, 99.659, 99.952, 99.793, 99.814, 99.826, 99.659, 99.632, 99.755, 99.739, 99.665, 99.516, 99.389, 99.515, 99.693, 99.957, 99.925, 99.668, 99.527, 99.544, 99.69, 99.706, 99.65, 99.565, 99.615, 99.319, 99.625, 99.885, 99.66, 99.754, 99.254, 99.457, 99.713, 99.708, 99.645, 99.507, 99.454, 99.445, 99.796, 99.764, 99.801, 99.893, 99.69, 99.556, 99.819, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 99.477, 99.715, 99.71, 99.649, 99.507, 99.455, 99.451, 99.796, 99.769, 99.8, 99.893, 99.628, 99.534, 99.529, null] 
        }]
    })
    $('#nucapsmw_LandAndSea_Temperature_Bias_10hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 10 hPa Level Statistics, Land and Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: -5.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, -0.005, -0.15, -0.329, -0.456, -0.443, -0.143, -0.332, -0.631, -0.659, -0.434, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, -0.374, -0.479, -0.593, -0.74, -0.771, -0.632, -0.681, -0.985, -0.874, -0.635, -0.212, -0.273, -0.301, -0.303, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, 0.07, -0.006, -0.162, -0.296, -0.339, -0.209, -0.159, -0.489, -0.447, -0.22, 0.25, 0.185, 0.138, 0.098, -0.122, -0.301, 0.251, 0.026, -0.202, -0.436, -0.606, -0.413, -0.092, -0.049, -0.022, 0.0, -0.117, -0.164, -0.333, -0.129, -0.311, -0.21, -0.26, -0.093, 0.0, 0.038, 0.099, 0.056, -0.204, -0.356, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.094, 0.267, 0.281, 0.118, 0.099, -0.079, 0.113, -0.127, -0.047, -0.037, 0.151, 0.251, 0.367, 0.427, 0.341, 0.084, -0.29, -0.174, 0.314, 0.193, 0.085, 0.133, 0.167, 0.223, 0.333, 0.325, 0.294, 0.079, -0.07, -0.022, -0.015, -0.137, 0.07, 0.064, 0.11, 0.291, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, 0.319, 0.234, 0.073, 0.002, 0.001, 0.247, 0.104, -0.206, -0.259, -0.016, 0.446, 0.364, 0.255, 0.181, 0.053, 0.016, 0.522, 0.23, -0.055, -0.088, -0.241, -0.192, -0.017, 0.152, 0.177, 0.141, 0.07, 0.079, -0.006, 0.244, -0.022, -0.011, -0.082, 0.093, 0.16, 0.242, 0.328, 0.196, -0.043, -0.273, -0.051, 0.447, 0.237, 0.056, 0.063, 0.103, 0.265, 0.382, 0.379, 0.337, 0.152, 0.155, 0.179, 0.213, -0.095, 0.055, 0.004, 0.037, 0.131, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.381, 0.537, 0.641, 0.642, 0.602, 0.424, 0.394, 0.449, 0.469, 0.184, 0.353, 0.295, 0.315, 0.357, null] 
        }]
    })
    $('#nucapsmw_LandAndSea_WaterVapor_Bias_10hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 10 hPa Level Statistics, Land and Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 50.0,
          min: -50.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, -98.198, -96.734, -95.175, -91.304, -92.594, -95.174, -93.742, -93.667, -96.944, -97.771, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, -98.232, -96.663, -95.115, -91.256, -92.659, -95.177, -93.783, -93.688, -96.931, -97.9, -98.624, -98.644, -98.197, -97.608, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, -98.234, -96.728, -95.195, -91.316, -92.526, -94.641, -93.112, -93.892, -96.953, -97.887, -98.64, -98.641, -98.215, -97.37, -95.569, -93.528, -93.157, -93.144, -92.868, -95.591, -96.833, -97.837, -98.613, -98.768, -98.993, -98.171, -96.897, -95.748, -96.314, -96.53, -97.153, -95.885, -96.991, -98.306, -98.899, -98.956, -98.697, -97.892, -96.79, -94.517, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -99.099, -98.992, -98.133, -96.898, -95.766, -96.367, -96.563, -97.116, -95.825, -97.016, -98.297, -98.88, -98.959, -98.704, -97.884, -96.784, -94.412, -93.858, -94.764, -95.379, -96.793, -97.001, -98.267, -98.884, -98.863, -98.643, -97.939, -96.646, -95.658, -95.806, -95.861, -95.55, -97.576, -97.354, -98.295, -98.851, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, -98.196, -96.666, -95.125, -91.319, -92.682, -95.192, -93.655, -93.715, -96.95, -97.875, -98.611, -98.898, -98.916, -98.386, -97.352, -96.24, -96.051, -96.099, -96.238, -97.661, -98.136, -98.71, -99.128, -99.211, -98.985, -98.151, -96.89, -95.786, -96.314, -96.557, -97.114, -95.921, -96.979, -98.311, -98.877, -98.94, -98.701, -97.898, -96.834, -94.44, -93.865, -94.763, -95.879, -96.763, -96.963, -98.249, -98.869, -98.847, -98.614, -97.874, -96.618, -95.671, -95.725, -95.819, -95.523, -97.616, -97.349, -98.286, -98.88, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -98.345, -98.873, -98.844, -98.617, -97.878, -96.629, -95.656, -95.717, -95.838, -95.543, -97.613, -97.311, -98.266, -98.739, null] 
        }]
    })
    $('#nucapsmw_LandAndSea_Temperature_StdDev_10hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 10 hPa Level Statistics, Land and Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, 2.102, 1.909, 2.195, 2.279, 2.435, 2.707, 2.29, 2.233, 2.225, 2.199, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, 2.153, 1.95, 2.066, 2.204, 2.484, 2.782, 2.355, 2.324, 2.214, 2.131, 2.269, 2.283, 2.117, 2.106, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, 2.132, 1.937, 2.043, 2.183, 2.428, 2.695, 2.328, 2.263, 2.198, 2.135, 2.257, 2.255, 2.124, 2.001, 2.079, 2.214, 2.646, 2.45, 2.47, 2.313, 2.042, 2.029, 2.184, 2.202, 2.062, 1.974, 1.998, 2.23, 2.539, 2.503, 2.306, 2.143, 2.03, 2.022, 2.088, 2.116, 2.071, 1.957, 2.069, 2.225, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 2.13, 2.014, 1.953, 1.983, 2.206, 2.567, 2.483, 2.308, 2.123, 2.0, 1.968, 2.052, 2.074, 2.029, 1.898, 2.043, 2.307, 2.463, 2.585, 2.453, 2.15, 1.908, 1.974, 2.103, 2.127, 2.042, 2.008, 1.996, 2.319, 2.367, 2.451, 2.364, 2.364, 1.913, 1.942, 2.023, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, 2.037, 1.831, 1.976, 2.178, 2.4, 2.659, 2.32, 2.225, 2.147, 2.097, 2.161, 2.218, 2.05, 1.963, 2.045, 2.33, 2.671, 2.458, 2.488, 2.283, 1.98, 1.91, 2.062, 2.103, 2.049, 1.887, 1.921, 2.135, 2.582, 2.538, 2.38, 2.117, 2.003, 2.004, 1.994, 2.121, 2.001, 1.902, 1.985, 2.27, 2.477, 2.555, 2.443, 2.248, 1.895, 1.905, 2.074, 2.044, 1.989, 1.964, 1.911, 2.502, 2.492, 2.456, 2.338, 2.359, 1.861, 1.953, 2.003, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.958, 2.093, 2.079, 2.014, 1.944, 1.912, 2.452, 2.527, 2.461, 2.38, 2.421, 1.964, 1.891, 2.113, null] 
        }]
    })
    $('#nucapsmw_LandAndSea_WaterVapor_StdDev_10hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 10 hPa Level Statistics, Land and Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, 0.703, 1.428, 1.927, 3.525, 1.953, 1.101, 1.457, 2.335, 1.076, 0.987, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, 0.708, 1.472, 1.964, 3.575, 1.864, 1.134, 1.461, 2.593, 1.079, 0.939, 0.613, 0.6, 0.815, 1.073, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, 0.697, 1.459, 1.901, 3.538, 1.994, 1.371, 2.795, 2.207, 1.068, 0.949, 0.617, 0.601, 0.827, 1.169, 1.656, 1.641, 0.708, 1.463, 1.647, 1.12, 1.269, 0.945, 0.614, 0.568, 0.44, 0.82, 1.266, 1.384, 1.013, 0.343, 0.484, 1.151, 1.137, 0.754, 0.521, 0.452, 0.611, 0.842, 0.98, 2.011, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.412, 0.433, 0.828, 1.266, 1.376, 1.002, 0.358, 0.507, 1.218, 1.105, 0.748, 0.457, 0.468, 0.625, 0.862, 0.967, 1.89, 1.499, 0.803, 1.304, 0.861, 1.255, 0.801, 0.575, 0.454, 0.605, 0.874, 1.293, 1.478, 0.894, 0.951, 0.969, 0.436, 0.874, 0.742, 0.353, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, 0.731, 1.496, 1.972, 3.556, 1.894, 1.096, 1.465, 2.307, 1.075, 0.951, 0.612, 0.488, 0.389, 0.655, 0.945, 0.986, 0.469, 0.877, 0.864, 0.589, 0.74, 0.631, 0.427, 0.322, 0.445, 0.809, 1.281, 1.391, 1.029, 0.367, 0.489, 1.129, 1.119, 0.747, 0.494, 0.494, 0.63, 0.839, 0.899, 1.882, 1.491, 0.807, 1.125, 0.898, 1.332, 0.801, 0.55, 0.441, 0.601, 0.923, 1.293, 1.48, 0.971, 0.948, 0.96, 0.416, 0.89, 0.738, 0.329, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.765, 0.535, 0.462, 0.613, 0.917, 1.287, 1.482, 0.967, 0.937, 0.966, 0.426, 0.984, 0.785, 0.644, null] 
        }]
    })
    $('#nucapsmw_LandAndSea_Temperature_RMS_10hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 10 hPa Level Statistics, Land and Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, 2.102, 1.915, 2.22, 2.325, 2.475, 2.711, 2.314, 2.321, 2.32, 2.241, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, 2.185, 2.008, 2.15, 2.325, 2.601, 2.853, 2.452, 2.524, 2.38, 2.224, 2.279, 2.299, 2.139, 2.128, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, 2.133, 1.937, 2.049, 2.203, 2.452, 2.704, 2.334, 2.315, 2.243, 2.146, 2.271, 2.263, 2.129, 2.004, 2.083, 2.234, 2.657, 2.45, 2.478, 2.354, 2.131, 2.07, 2.186, 2.203, 2.063, 1.974, 2.001, 2.236, 2.561, 2.506, 2.327, 2.153, 2.047, 2.025, 2.088, 2.117, 2.073, 1.958, 2.079, 2.253, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 2.132, 2.031, 1.973, 1.986, 2.209, 2.569, 2.486, 2.312, 2.123, 2.001, 1.974, 2.067, 2.106, 2.074, 1.928, 2.045, 2.325, 2.469, 2.604, 2.461, 2.151, 1.913, 1.981, 2.115, 2.153, 2.068, 2.03, 1.997, 2.32, 2.367, 2.451, 2.368, 2.365, 1.914, 1.946, 2.044, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, 2.062, 1.846, 1.977, 2.178, 2.4, 2.671, 2.322, 2.235, 2.162, 2.097, 2.206, 2.248, 2.065, 1.972, 2.046, 2.33, 2.721, 2.469, 2.489, 2.285, 1.995, 1.92, 2.062, 2.109, 2.057, 1.892, 1.922, 2.136, 2.582, 2.55, 2.38, 2.117, 2.004, 2.007, 2.0, 2.135, 2.028, 1.912, 1.985, 2.287, 2.477, 2.594, 2.454, 2.249, 1.896, 1.908, 2.091, 2.079, 2.025, 1.993, 1.917, 2.507, 2.499, 2.465, 2.34, 2.36, 1.861, 1.954, 2.008, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.994, 2.161, 2.176, 2.114, 2.035, 1.959, 2.484, 2.567, 2.505, 2.387, 2.446, 1.986, 1.917, 2.143, null] 
        }]
    })
    $('#nucapsmw_LandAndSea_WaterVapor_RMS_10hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 10 hPa Level Statistics, Land and Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, 99.572, 99.134, 99.029, 98.274, 99.45, 99.719, 99.642, 99.025, 99.58, 99.394, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, 99.575, 99.091, 98.997, 98.237, 99.495, 99.709, 99.639, 98.713, 99.577, 99.384, 99.564, 99.568, 99.459, 99.326, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, 99.577, 99.122, 99.051, 98.265, 99.439, 99.63, 98.659, 99.099, 99.598, 99.383, 99.57, 99.558, 99.457, 99.294, 99.267, 99.54, 99.924, 99.681, 99.606, 99.675, 99.362, 99.438, 99.622, 99.575, 99.698, 99.527, 99.377, 99.482, 99.671, 99.954, 99.92, 99.641, 99.482, 99.541, 99.693, 99.724, 99.662, 99.553, 99.638, 99.149, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 99.704, 99.696, 99.532, 99.369, 99.482, 99.674, 99.953, 99.919, 99.605, 99.507, 99.545, 99.682, 99.72, 99.662, 99.544, 99.647, 99.274, 99.622, 99.877, 99.604, 99.742, 99.314, 99.444, 99.712, 99.735, 99.649, 99.515, 99.426, 99.437, 99.795, 99.747, 99.776, 99.887, 99.677, 99.562, 99.819, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, 99.57, 99.041, 98.977, 98.236, 99.472, 99.717, 99.644, 99.044, 99.577, 99.378, 99.559, 99.641, 99.682, 99.576, 99.568, 99.709, 99.945, 99.783, 99.795, 99.816, 99.652, 99.67, 99.753, 99.748, 99.677, 99.521, 99.366, 99.48, 99.671, 99.953, 99.919, 99.648, 99.497, 99.54, 99.684, 99.71, 99.651, 99.559, 99.709, 99.273, 99.625, 99.879, 99.669, 99.735, 99.219, 99.436, 99.706, 99.715, 99.631, 99.485, 99.419, 99.433, 99.771, 99.743, 99.777, 99.89, 99.668, 99.548, 99.811, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 99.459, 99.709, 99.716, 99.635, 99.484, 99.422, 99.439, 99.772, 99.747, 99.777, 99.89, 99.602, 99.527, 99.524, null] 
        }]
    })
    $('#nucapsmw_Sea_Temperature_Bias_49hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 49 hPa Level Statistics, Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: -5.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, 0.013, -0.194, -0.66, -0.695, -1.211, -1.322, -1.27, -1.271, -1.408, -1.259, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, -0.305, -0.318, -0.506, -0.677, -0.954, -1.081, -0.834, -0.931, -1.086, -0.945, -0.813, -0.946, -0.636, -0.631, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, -0.166, -0.127, -0.5, -0.719, -0.936, -1.014, -0.951, -0.996, -1.109, -0.96, -0.648, -0.821, -0.469, -0.364, -0.63, -0.681, -1.038, -1.252, -1.191, -1.164, -0.976, -0.737, -0.264, -0.476, -0.685, -0.508, -0.332, -0.417, -0.539, 0.129, -0.066, 0.34, 0.174, -0.567, -0.485, -0.489, -0.606, -0.547, -0.464, -0.182, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -0.575, -0.717, -0.491, -0.255, -0.595, -0.617, 0.18, -0.051, 0.304, 0.018, -0.526, -0.41, -0.534, -0.712, -0.63, -0.463, -0.294, -0.174, 0.354, 0.284, 0.203, 0.302, -0.18, -0.279, -0.355, -0.209, -0.34, -0.023, 0.051, -0.433, -0.01, -0.289, -0.181, -0.34, -0.79, -0.492, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, -0.119, -0.14, -0.682, -0.774, -1.101, -1.339, -1.124, -1.191, -1.325, -1.246, -0.63, -0.904, -0.464, -0.404, -0.54, -0.298, -0.733, -0.366, -0.571, -0.403, -0.273, -0.335, -0.102, -0.561, -0.787, -0.612, -0.464, -0.693, -0.743, -0.037, -0.207, 0.203, -0.057, -0.737, -0.647, -0.641, -0.76, -0.598, -0.55, -0.526, -0.193, 0.194, 0.369, -0.019, 0.017, -0.4, -0.682, -0.634, -0.59, -0.655, -0.372, -0.385, -0.629, -0.524, -0.548, -0.444, -0.602, -0.996, -0.654, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.007, -0.106, -0.061, 0.04, -0.026, 0.243, 0.31, -0.013, 0.209, 0.042, 0.109, -0.036, -0.442, -0.22, null] 
        }]
    })
    $('#nucapsmw_Sea_WaterVapor_Bias_49hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 49 hPa Level Statistics, Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 50.0,
          min: -50.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, -6.658, 5.482, -16.338, 18.779, 12.802, 1.625, -1.019, -36.188, -24.655, -12.773, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, -35.682, -36.001, -38.726, -23.617, -67.891, -58.013, -36.476, -49.751, -42.667, -24.062, -54.892, -55.176, -49.881, -71.338, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, -31.95, -36.716, -40.187, -27.838, -50.673, -57.142, -42.216, -58.317, -54.722, -47.139, -41.038, -55.325, -42.07, -53.071, -29.807, -51.477, -49.407, -28.095, -47.095, -57.742, -47.739, -28.94, -53.876, -56.498, -65.866, -68.473, -62.623, -45.163, -54.991, -63.272, -54.629, -52.808, -57.904, -57.194, -61.429, -59.3, -61.567, -70.655, -55.053, -66.408, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -55.611, -65.568, -62.803, -60.967, -66.013, -51.994, -53.736, -46.388, -42.948, -56.187, -57.445, -63.426, -59.596, -59.286, -63.239, -58.059, -61.945, -51.811, -55.157, -37.989, -47.524, -28.83, -48.186, -58.078, -56.89, -55.563, -42.733, -39.257, -100.393, -45.128, -29.033, -33.225, -73.38, -44.276, -49.594, -52.931, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, -7.683, 11.024, 4.62, 47.336, -6.555, 13.251, 41.099, -18.613, -49.311, -35.803, -38.139, -37.485, -61.235, -66.115, -44.671, -59.529, -42.339, -41.387, -53.026, -45.59, -38.802, -34.15, -47.209, -40.784, -47.428, -27.365, -36.577, -21.208, -30.223, -34.057, -28.329, -26.846, -33.572, -30.051, -38.815, -25.006, -52.091, -23.624, -30.895, -39.2, -4.502, -41.92, -40.441, -27.291, -24.125, -32.131, -53.265, -49.233, -46.809, -28.088, -100.265, -100.254, -11.345, -22.644, -22.722, -71.014, -38.813, -51.368, -51.151, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -34.806, -59.686, -50.599, -47.082, -27.385, -26.485, -100.245, -9.74, -21.1, -13.203, -99.615, -29.328, -47.713, -46.489, null] 
        }]
    })
    $('#nucapsmw_Sea_Temperature_StdDev_49hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 49 hPa Level Statistics, Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, 1.995, 1.805, 1.675, 1.766, 1.86, 1.873, 1.977, 1.973, 1.817, 1.865, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, 1.952, 1.888, 1.721, 1.782, 1.752, 1.857, 2.06, 1.864, 1.804, 1.768, 1.749, 1.801, 1.625, 1.743, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, 1.959, 1.734, 1.6, 1.811, 1.748, 1.88, 1.913, 1.888, 1.762, 1.852, 1.73, 1.823, 1.725, 1.574, 1.838, 1.754, 1.981, 1.992, 1.981, 2.029, 1.956, 2.03, 2.145, 1.81, 2.316, 2.228, 1.903, 1.99, 2.35, 2.126, 2.117, 2.32, 2.033, 2.04, 1.926, 1.847, 1.914, 1.869, 1.919, 1.985, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.733, 2.174, 1.98, 1.827, 1.914, 2.308, 1.924, 1.879, 2.14, 1.84, 1.869, 1.672, 1.636, 1.768, 1.626, 1.821, 1.837, 1.843, 1.988, 2.079, 2.006, 1.988, 1.834, 1.783, 1.943, 1.767, 1.76, 1.658, 1.727, 2.035, 1.811, 1.87, 1.907, 1.874, 1.707, 1.658, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, 1.943, 2.716, 1.573, 1.703, 1.787, 2.733, 1.86, 1.901, 1.808, 1.822, 2.384, 1.754, 1.721, 1.674, 1.966, 1.885, 2.015, 1.801, 1.968, 1.868, 1.997, 1.903, 1.866, 1.754, 2.11, 2.177, 1.955, 1.911, 2.163, 2.061, 2.025, 2.358, 1.978, 1.919, 1.8, 1.701, 1.681, 1.655, 1.817, 1.704, 1.914, 1.964, 2.058, 2.008, 2.122, 1.914, 1.866, 1.879, 1.743, 1.653, 1.628, 1.734, 2.041, 1.802, 1.846, 1.866, 1.83, 1.614, 1.539, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.648, 2.532, 1.905, 1.795, 1.648, 1.633, 1.627, 1.985, 1.756, 1.825, 1.902, 1.872, 2.132, 1.575, null] 
        }]
    })
    $('#nucapsmw_Sea_WaterVapor_StdDev_49hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 49 hPa Level Statistics, Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, 30.57, 46.534, 28.7, 50.698, 48.522, 44.103, 40.833, 20.303, 15.48, 33.229, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, 26.259, 25.341, 24.715, 27.058, 5.039, 6.782, 16.391, 12.39, 18.119, 32.486, 13.972, 13.539, 12.726, 8.801, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, 28.375, 25.915, 23.253, 27.685, 9.493, 7.933, 14.858, 8.818, 13.39, 16.972, 18.432, 13.215, 20.096, 14.496, 23.333, 12.794, 10.366, 28.94, 16.601, 7.344, 12.032, 25.496, 14.139, 9.455, 13.107, 8.32, 13.625, 22.619, 12.78, 5.266, 8.757, 17.033, 13.577, 16.814, 13.996, 13.296, 12.244, 6.187, 17.301, 7.257, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 20.486, 12.447, 12.016, 14.45, 6.746, 18.204, 11.648, 14.416, 25.399, 12.865, 14.443, 13.193, 14.303, 15.032, 11.228, 11.532, 6.261, 11.59, 11.299, 23.889, 8.914, 34.976, 19.384, 15.155, 16.713, 14.443, 22.418, 24.287, 0.0, 17.385, 22.664, 21.217, 2.093, 21.879, 21.023, 19.674, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, 35.786, 36.206, 45.742, 73.855, 27.114, 48.654, 70.143, 29.732, 11.081, 18.708, 14.789, 23.369, 11.864, 7.259, 18.194, 9.934, 16.964, 14.892, 11.936, 13.795, 23.387, 30.548, 21.9, 28.405, 21.038, 35.403, 20.628, 36.956, 30.339, 24.092, 30.573, 32.75, 28.619, 34.953, 27.9, 36.397, 7.294, 34.303, 21.657, 13.314, 47.468, 11.276, 16.112, 17.428, 37.946, 33.374, 17.654, 21.391, 22.491, 34.998, 0.0, 0.0, 39.086, 21.302, 28.058, 1.879, 22.441, 18.384, 12.94, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 31.456, 12.999, 20.335, 21.259, 34.569, 30.493, 0.0, 39.963, 17.363, 41.45, 0.048, 34.734, 22.253, 22.894, null] 
        }]
    })
    $('#nucapsmw_Sea_Temperature_RMS_49hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 49 hPa Level Statistics, Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, 1.995, 1.816, 1.801, 1.898, 2.22, 2.292, 2.35, 2.347, 2.299, 2.25, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, 1.975, 1.915, 1.795, 1.906, 1.995, 2.149, 2.223, 2.083, 2.105, 2.004, 1.929, 2.035, 1.745, 1.854, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, 1.966, 1.738, 1.676, 1.948, 1.983, 2.136, 2.137, 2.135, 2.082, 2.086, 1.847, 2.0, 1.788, 1.616, 1.943, 1.882, 2.237, 2.352, 2.312, 2.339, 2.186, 2.16, 2.162, 1.872, 2.416, 2.285, 1.932, 2.033, 2.411, 2.129, 2.118, 2.345, 2.04, 2.117, 1.986, 1.911, 2.008, 1.948, 1.975, 1.993, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.826, 2.289, 2.04, 1.845, 2.005, 2.389, 1.932, 1.879, 2.162, 1.84, 1.942, 1.722, 1.721, 1.906, 1.744, 1.879, 1.86, 1.851, 2.019, 2.098, 2.016, 2.01, 1.843, 1.805, 1.975, 1.78, 1.793, 1.658, 1.728, 2.081, 1.811, 1.892, 1.915, 1.905, 1.881, 1.73, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, 1.947, 2.72, 1.715, 1.87, 2.099, 3.044, 2.174, 2.244, 2.242, 2.208, 2.466, 1.973, 1.783, 1.722, 2.039, 1.909, 2.144, 1.838, 2.049, 1.911, 2.015, 1.932, 1.869, 1.841, 2.252, 2.262, 2.009, 2.033, 2.287, 2.061, 2.036, 2.367, 1.979, 2.055, 1.913, 1.818, 1.845, 1.76, 1.899, 1.783, 1.924, 1.973, 2.091, 2.008, 2.122, 1.955, 1.987, 1.983, 1.841, 1.778, 1.67, 1.777, 2.136, 1.877, 1.926, 1.919, 1.927, 1.897, 1.673, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.648, 2.535, 1.906, 1.795, 1.648, 1.651, 1.656, 1.985, 1.769, 1.825, 1.905, 1.873, 2.178, 1.59, null] 
        }]
    })
    $('#nucapsmw_Sea_WaterVapor_RMS_49hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 49 hPa Level Statistics, Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, 93.681, 87.055, 93.442, 88.275, 87.729, 86.385, 88.383, 94.051, 97.812, 90.581, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, 90.329, 91.492, 90.769, 92.906, 99.278, 98.976, 96.505, 97.239, 95.155, 87.444, 96.04, 96.233, 97.394, 97.352, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, 89.423, 90.882, 91.832, 91.571, 98.519, 98.646, 96.805, 98.278, 96.302, 95.222, 95.323, 96.513, 94.212, 96.112, 93.816, 97.173, 98.253, 89.675, 95.42, 98.78, 97.588, 92.284, 95.879, 98.341, 94.635, 97.876, 94.93, 90.795, 96.842, 99.358, 98.603, 94.165, 95.77, 93.258, 94.667, 95.688, 96.081, 98.768, 93.333, 98.615, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 89.406, 95.356, 96.149, 94.527, 98.815, 93.354, 97.521, 96.82, 88.158, 96.603, 95.098, 94.971, 94.78, 94.17, 96.64, 97.192, 99.131, 97.681, 97.625, 91.854, 98.783, 76.812, 92.96, 94.482, 93.243, 95.566, 91.719, 91.019, 100.0, 95.377, 94.605, 94.745, 99.852, 91.58, 90.564, 90.787, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, 90.606, 94.521, 85.946, 78.806, 95.406, 87.49, 73.188, 92.07, 97.939, 95.781, 97.294, 93.57, 96.504, 98.603, 94.818, 97.882, 95.906, 97.144, 97.501, 97.156, 92.042, 85.402, 90.523, 84.249, 92.07, 79.974, 94.564, 82.855, 88.033, 92.706, 88.617, 86.766, 88.791, 74.49, 86.204, 77.436, 99.08, 85.499, 94.788, 97.823, 67.886, 98.41, 96.641, 97.065, 73.99, 76.118, 93.48, 90.527, 90.255, 79.668, 100.0, 100.0, 86.525, 96.082, 92.209, 99.895, 92.885, 93.3, 97.021, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 80.67, 96.015, 91.269, 91.721, 81.778, 89.086, 100.0, 86.01, 97.53, 80.633, 99.999, 77.085, 89.971, 89.437, null] 
        }]
    })
    $('#nucapsmw_Land_Temperature_Bias_49hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 49 hPa Level Statistics, Land, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: -5.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, -0.3, -0.345, -0.432, -0.387, -0.265, -0.169, -0.167, -0.309, -0.484, -0.446, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, -0.375, -0.447, -0.555, -0.61, -0.518, -0.326, -0.324, -0.435, -0.544, -0.52, -0.547, -0.532, -0.55, -0.542, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, -0.39, -0.47, -0.628, -0.697, -0.621, -0.49, -0.451, -0.525, -0.677, -0.681, -0.631, -0.505, -0.472, -0.464, -0.629, -0.585, -0.608, -0.777, -1.004, -1.022, -0.939, -0.745, -0.644, -0.591, -0.485, -0.413, -0.434, -0.276, -0.14, -0.188, -0.396, -0.249, -0.493, -0.487, -0.411, -0.535, -0.536, -0.474, -0.438, -0.281, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -0.267, -0.375, -0.343, -0.343, -0.163, -0.006, -0.157, -0.301, -0.136, -0.415, -0.288, -0.231, -0.503, -0.508, -0.453, -0.387, -0.128, -0.16, -0.096, -0.114, -0.157, -0.37, -0.187, 0.055, -0.117, 0.022, 0.004, 0.006, 0.152, 0.255, 0.057, -0.231, -0.3, -0.397, -0.417, -0.386, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, -0.47, -0.547, -0.633, -0.674, -0.567, -0.43, -0.471, -0.601, -0.732, -0.713, -0.654, -0.468, -0.442, -0.487, -0.523, -0.263, -0.224, -0.308, -0.568, -0.559, -0.628, -0.464, -0.385, -0.533, -0.527, -0.475, -0.456, -0.254, -0.058, -0.133, -0.336, -0.194, -0.471, -0.323, -0.343, -0.55, -0.591, -0.536, -0.423, -0.204, -0.242, -0.106, -0.079, -0.111, -0.382, -0.321, -0.311, -0.424, -0.324, -0.385, -0.422, -0.272, 0.076, -0.084, -0.326, -0.35, -0.449, -0.45, -0.456, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.277, 0.286, 0.17, 0.29, 0.251, 0.262, 0.416, 0.768, 0.592, 0.366, 0.296, 0.205, 0.147, 0.052, null] 
        }]
    })
    $('#nucapsmw_Land_WaterVapor_Bias_49hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 49 hPa Level Statistics, Land, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 50.0,
          min: -50.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, -82.375, -77.393, -73.867, -58.768, -79.831, -83.629, -81.44, -66.781, -80.126, -81.443, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, -82.977, -77.728, -73.901, -58.763, -79.98, -83.875, -81.298, -66.325, -79.933, -81.752, -83.383, -84.478, -82.514, -82.786, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, -82.87, -77.982, -73.66, -58.861, -76.505, -78.106, -74.181, -62.461, -78.491, -81.286, -83.464, -84.425, -82.477, -80.667, -74.913, -74.387, -70.249, -68.476, -69.757, -71.584, -82.027, -80.219, -83.351, -83.951, -89.721, -88.827, -83.646, -81.365, -85.147, -81.707, -90.378, -83.566, -80.884, -84.098, -87.141, -88.151, -86.563, -85.504, -82.942, -77.679, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -89.032, -89.847, -88.686, -83.635, -81.292, -85.261, -81.484, -90.324, -83.462, -80.967, -84.181, -86.834, -88.161, -86.747, -85.547, -83.079, -76.622, -79.771, -86.143, -82.616, -84.784, -78.428, -83.855, -89.227, -105.336, -104.569, -83.68, -79.33, -75.939, -79.167, -77.01, -77.452, -89.721, -83.44, -81.158, -84.301, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, -82.239, -77.423, -73.631, -58.813, -79.813, -83.595, -81.473, -67.181, -80.125, -81.499, -83.068, -87.072, -89.388, -88.041, -84.738, -84.437, -83.302, -82.972, -84.101, -85.417, -89.82, -87.827, -89.326, -89.486, -89.257, -88.033, -83.136, -81.365, -85.067, -81.636, -90.277, -83.355, -80.499, -83.856, -86.13, -87.348, -86.234, -84.949, -82.421, -76.376, -79.803, -86.119, -82.605, -84.782, -78.163, -83.396, -88.583, -86.631, -104.425, -82.796, -78.654, -75.784, -79.096, -77.117, -77.419, -89.703, -83.084, -80.763, -84.143, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -84.123, -88.756, -102.945, -104.425, -82.559, -78.612, -75.757, -79.114, -77.242, -77.404, -89.073, -82.997, -80.617, -82.213, null] 
        }]
    })
    $('#nucapsmw_Land_Temperature_StdDev_49hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 49 hPa Level Statistics, Land, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, 1.649, 1.611, 1.746, 1.949, 1.839, 2.092, 1.84, 1.919, 1.757, 2.031, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, 1.469, 1.441, 1.586, 1.672, 1.828, 2.054, 1.827, 1.847, 1.671, 1.572, 1.446, 1.402, 1.381, 1.423, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, 1.441, 1.415, 1.566, 1.633, 1.781, 2.012, 1.814, 1.837, 1.655, 1.562, 1.431, 1.389, 1.368, 1.36, 1.466, 1.592, 1.849, 1.76, 1.804, 1.819, 1.694, 1.48, 1.51, 1.507, 1.539, 1.536, 1.571, 1.853, 2.048, 2.051, 2.046, 2.251, 1.884, 1.774, 1.62, 1.676, 1.671, 1.617, 1.743, 1.906, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.425, 1.492, 1.456, 1.502, 1.764, 1.918, 1.913, 1.895, 2.049, 1.705, 1.594, 1.48, 1.463, 1.451, 1.406, 1.564, 1.747, 1.83, 1.895, 1.821, 1.856, 1.651, 1.622, 1.518, 1.49, 1.423, 1.457, 1.452, 1.732, 1.933, 1.928, 1.846, 2.029, 1.722, 1.582, 1.496, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, 1.507, 1.51, 1.812, 1.726, 1.82, 2.017, 1.815, 1.796, 1.658, 1.67, 1.477, 1.544, 1.434, 1.424, 1.451, 1.88, 1.982, 1.877, 1.756, 1.858, 1.855, 1.559, 1.603, 1.512, 1.636, 1.567, 1.49, 1.769, 1.908, 1.931, 1.946, 2.065, 1.684, 1.674, 1.478, 1.592, 1.489, 1.561, 1.576, 1.804, 1.863, 1.864, 1.797, 1.913, 1.674, 1.63, 1.581, 1.539, 1.465, 1.486, 1.445, 1.917, 1.988, 1.893, 1.797, 2.061, 1.723, 1.739, 1.544, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.622, 1.693, 1.611, 1.42, 1.467, 1.435, 1.805, 2.009, 1.84, 1.795, 2.088, 1.835, 1.634, 1.804, null] 
        }]
    })
    $('#nucapsmw_Land_WaterVapor_StdDev_49hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 49 hPa Level Statistics, Land, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, 7.543, 9.834, 11.141, 18.375, 4.576, 3.348, 6.189, 13.67, 8.051, 7.986, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, 7.328, 9.667, 11.181, 18.415, 4.497, 3.289, 6.218, 14.103, 8.16, 8.011, 7.429, 6.871, 7.707, 7.833, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, 7.403, 9.688, 11.335, 18.391, 5.418, 4.501, 8.999, 14.661, 8.76, 8.179, 7.392, 6.924, 7.776, 8.62, 10.881, 9.646, 8.655, 10.227, 9.797, 9.493, 6.776, 8.288, 6.496, 6.609, 4.129, 4.271, 6.617, 6.914, 4.616, 4.165, 1.807, 4.695, 7.83, 6.41, 5.303, 4.98, 5.695, 6.157, 6.98, 9.069, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 4.635, 4.069, 4.342, 6.622, 6.926, 4.605, 4.239, 1.826, 4.742, 7.781, 6.427, 5.431, 4.977, 5.645, 6.138, 6.939, 9.333, 4.622, 2.259, 3.379, 4.593, 8.746, 6.406, 0.47, 0.0, 0.0, 6.294, 8.25, 9.183, 7.475, 5.541, 6.985, 0.911, 4.945, 7.545, 5.439, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, 7.616, 9.798, 11.242, 18.386, 4.577, 3.352, 6.181, 13.499, 8.04, 7.99, 7.537, 5.962, 4.595, 5.265, 6.453, 5.859, 4.757, 5.835, 5.825, 4.963, 3.558, 5.013, 4.104, 4.203, 4.394, 4.659, 6.828, 6.917, 4.643, 4.192, 1.835, 4.76, 7.954, 6.498, 5.766, 5.383, 5.867, 6.405, 7.156, 9.409, 4.62, 2.26, 3.367, 4.579, 8.83, 6.626, 0.461, 5.371, 0.0, 6.651, 8.479, 9.248, 7.463, 5.558, 7.007, 0.907, 5.056, 7.684, 5.646, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 6.347, 0.454, 0.0, 0.0, 6.745, 8.514, 9.249, 7.459, 5.495, 7.008, 2.065, 5.095, 7.774, 7.527, null] 
        }]
    })
    $('#nucapsmw_Land_Temperature_RMS_49hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 49 hPa Level Statistics, Land, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, 1.676, 1.648, 1.798, 1.987, 1.858, 2.099, 1.847, 1.943, 1.822, 2.079, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, 1.516, 1.509, 1.681, 1.78, 1.9, 2.08, 1.856, 1.898, 1.758, 1.656, 1.546, 1.5, 1.487, 1.522, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, 1.493, 1.491, 1.687, 1.776, 1.887, 2.071, 1.869, 1.911, 1.789, 1.704, 1.564, 1.478, 1.447, 1.437, 1.595, 1.697, 1.947, 1.924, 2.065, 2.087, 1.937, 1.657, 1.642, 1.619, 1.613, 1.591, 1.63, 1.874, 2.053, 2.06, 2.084, 2.265, 1.947, 1.84, 1.672, 1.759, 1.755, 1.685, 1.798, 1.927, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.45, 1.539, 1.496, 1.541, 1.772, 1.918, 1.919, 1.919, 2.053, 1.755, 1.619, 1.497, 1.547, 1.537, 1.477, 1.612, 1.752, 1.837, 1.897, 1.824, 1.863, 1.692, 1.633, 1.519, 1.495, 1.423, 1.457, 1.452, 1.739, 1.949, 1.929, 1.861, 2.051, 1.767, 1.636, 1.545, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, 1.578, 1.607, 1.919, 1.853, 1.907, 2.063, 1.875, 1.894, 1.813, 1.816, 1.616, 1.614, 1.501, 1.505, 1.542, 1.898, 1.995, 1.902, 1.846, 1.941, 1.958, 1.627, 1.649, 1.603, 1.719, 1.638, 1.558, 1.788, 1.909, 1.935, 1.975, 2.074, 1.749, 1.705, 1.518, 1.685, 1.603, 1.65, 1.632, 1.815, 1.878, 1.867, 1.798, 1.917, 1.717, 1.662, 1.612, 1.597, 1.501, 1.535, 1.505, 1.937, 1.99, 1.894, 1.827, 2.09, 1.781, 1.797, 1.61, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.646, 1.717, 1.62, 1.449, 1.488, 1.459, 1.852, 2.151, 1.933, 1.832, 2.109, 1.847, 1.641, 1.805, null] 
        }]
    })
    $('#nucapsmw_Land_WaterVapor_RMS_49hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 49 hPa Level Statistics, Land, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, 95.877, 94.654, 94.524, 90.446, 98.939, 99.043, 97.615, 93.348, 95.919, 95.42, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, 95.943, 94.767, 94.457, 90.37, 98.973, 99.065, 97.618, 92.905, 95.843, 95.22, 95.529, 95.926, 95.519, 95.237, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, 95.873, 94.602, 94.331, 90.351, 98.788, 99.024, 96.42, 93.673, 95.573, 95.219, 95.548, 95.897, 95.42, 94.989, 94.423, 96.017, 97.524, 96.552, 96.643, 96.586, 96.886, 95.565, 96.978, 96.721, 97.76, 97.875, 96.758, 97.115, 98.303, 99.044, 99.533, 98.363, 95.96, 96.729, 97.133, 97.181, 96.802, 96.598, 96.5, 95.67, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 97.368, 97.804, 97.878, 96.752, 97.121, 98.3, 99.017, 99.528, 98.345, 95.999, 96.675, 97.072, 97.183, 96.803, 96.609, 96.506, 95.711, 98.876, 99.484, 99.293, 98.333, 95.624, 96.826, 99.978, 100.0, 100.0, 97.101, 96.09, 96.081, 97.061, 98.645, 97.764, 99.858, 98.273, 96.24, 97.803, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, 95.826, 94.698, 94.48, 90.401, 98.939, 99.043, 97.615, 93.424, 95.933, 95.397, 95.505, 96.477, 97.147, 96.805, 96.565, 97.475, 98.541, 97.803, 97.558, 98.009, 98.333, 97.236, 97.983, 97.753, 97.554, 97.638, 96.65, 97.112, 98.299, 99.032, 99.527, 98.341, 95.931, 96.688, 96.833, 96.898, 96.668, 96.455, 96.457, 95.695, 98.876, 99.486, 99.303, 98.339, 95.599, 96.683, 99.98, 97.239, 100.0, 96.934, 96.03, 96.051, 97.085, 98.624, 97.754, 99.858, 98.248, 96.182, 97.618, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 96.795, 99.98, 100.0, 100.0, 96.891, 95.998, 96.058, 97.086, 98.649, 97.755, 99.441, 98.227, 96.114, 95.784, null] 
        }]
    })
    $('#nucapsmw_LandAndSea_Temperature_Bias_49hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 49 hPa Level Statistics, Land and Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: -5.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, -0.309, -0.335, -0.454, -0.42, -0.354, -0.322, -0.289, -0.394, -0.577, -0.547, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, -0.398, -0.442, -0.575, -0.619, -0.58, -0.451, -0.411, -0.494, -0.625, -0.572, -0.561, -0.568, -0.57, -0.553, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, -0.396, -0.449, -0.625, -0.691, -0.658, -0.586, -0.526, -0.579, -0.736, -0.716, -0.622, -0.524, -0.475, -0.445, -0.626, -0.606, -0.661, -0.801, -1.009, -1.022, -0.94, -0.721, -0.572, -0.584, -0.545, -0.441, -0.431, -0.336, -0.239, -0.159, -0.354, -0.199, -0.427, -0.511, -0.442, -0.555, -0.563, -0.515, -0.449, -0.31, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -0.389, -0.45, -0.385, -0.356, -0.238, -0.117, -0.131, -0.272, -0.115, -0.369, -0.328, -0.269, -0.525, -0.542, -0.504, -0.412, -0.189, -0.204, -0.027, -0.06, -0.121, -0.289, -0.187, -0.005, -0.192, -0.049, -0.054, -0.007, 0.133, 0.142, 0.045, -0.197, -0.277, -0.384, -0.459, -0.41, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, -0.476, -0.535, -0.649, -0.684, -0.634, -0.559, -0.559, -0.662, -0.805, -0.771, -0.647, -0.508, -0.479, -0.506, -0.54, -0.32, -0.332, -0.288, -0.506, -0.517, -0.565, -0.399, -0.313, -0.532, -0.601, -0.522, -0.463, -0.339, -0.181, -0.122, -0.326, -0.183, -0.43, -0.375, -0.383, -0.576, -0.627, -0.585, -0.46, -0.28, -0.296, -0.053, -0.048, -0.084, -0.312, -0.327, -0.38, -0.506, -0.396, -0.442, -0.437, -0.302, -0.039, -0.114, -0.307, -0.338, -0.443, -0.489, -0.482, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.25, 0.217, 0.093, 0.214, 0.188, 0.239, 0.379, 0.642, 0.553, 0.375, 0.298, 0.197, 0.101, 0.03, null] 
        }]
    })
    $('#nucapsmw_LandAndSea_WaterVapor_Bias_49hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 49 hPa Level Statistics, Land and Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 50.0,
          min: -50.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, -80.963, -75.769, -72.28, -56.949, -79.305, -83.003, -80.228, -65.748, -79.056, -80.181, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, -81.533, -76.001, -72.34, -56.68, -79.38, -83.181, -80.066, -65.072, -78.738, -80.354, -82.398, -83.089, -81.173, -81.624, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, -81.434, -76.264, -72.028, -56.732, -76.66, -78.741, -73.828, -61.961, -77.341, -79.919, -82.474, -83.033, -81.05, -79.232, -73.219, -73.205, -69.216, -68.377, -69.677, -72.718, -81.396, -79.074, -82.037, -82.303, -88.769, -87.427, -82.385, -80.141, -83.951, -81.59, -89.349, -82.64, -79.561, -83.037, -86.078, -86.873, -85.244, -84.11, -81.37, -75.735, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -87.973, -88.865, -87.305, -82.406, -80.091, -84.103, -81.339, -89.269, -82.537, -79.642, -83.069, -85.769, -86.951, -85.466, -84.181, -81.558, -75.094, -78.459, -84.489, -80.671, -83.061, -76.421, -82.075, -150.848, -107.459, -106.331, -81.332, -106.356, -105.799, -77.449, -76.038, -76.464, -93.449, -119.63, -118.313, -82.786, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, -80.798, -75.688, -72.027, -56.949, -79.313, -82.954, -80.226, -66.07, -79.071, -80.121, -82.122, -86.037, -88.609, -87.179, -83.678, -83.751, -82.465, -81.863, -83.234, -84.869, -89.156, -87.13, -88.475, -88.504, -88.263, -86.643, -81.957, -80.156, -83.911, -81.521, -89.302, -82.552, -79.288, -82.794, -85.01, -86.079, -84.936, -83.539, -80.677, -74.84, -78.448, -84.482, -80.77, -83.085, -76.134, -81.545, -136.483, -84.582, -106.058, -80.331, -106.191, -105.732, -77.43, -76.054, -76.554, -93.498, -119.358, -118.002, -82.805, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -82.246, -134.812, -103.984, -106.054, -80.094, -106.153, -105.711, -77.443, -76.263, -76.391, -93.31, -119.198, -78.944, -80.76, null] 
        }]
    })
    $('#nucapsmw_LandAndSea_Temperature_StdDev_49hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 49 hPa Level Statistics, Land and Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, 1.745, 1.667, 1.807, 1.921, 1.859, 2.124, 1.9, 1.954, 1.803, 2.003, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, 1.529, 1.488, 1.6, 1.689, 1.839, 2.074, 1.882, 1.857, 1.693, 1.604, 1.469, 1.444, 1.414, 1.449, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, 1.506, 1.469, 1.582, 1.646, 1.784, 2.032, 1.866, 1.844, 1.675, 1.603, 1.451, 1.431, 1.403, 1.397, 1.513, 1.623, 1.875, 1.801, 1.825, 1.861, 1.741, 1.563, 1.618, 1.55, 1.666, 1.624, 1.631, 1.881, 2.113, 2.067, 2.052, 2.25, 1.903, 1.787, 1.649, 1.701, 1.707, 1.661, 1.776, 1.916, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.52, 1.628, 1.525, 1.568, 1.803, 2.003, 1.924, 1.896, 2.051, 1.718, 1.614, 1.511, 1.491, 1.496, 1.455, 1.605, 1.774, 1.858, 1.914, 1.853, 1.883, 1.713, 1.659, 1.609, 1.605, 1.517, 1.514, 1.507, 1.733, 1.995, 1.911, 1.846, 2.009, 1.725, 1.599, 1.523, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, 1.628, 1.568, 1.795, 1.749, 1.827, 2.058, 1.893, 1.811, 1.688, 1.69, 1.51, 1.562, 1.484, 1.464, 1.528, 1.874, 2.018, 1.881, 1.825, 1.922, 1.878, 1.634, 1.731, 1.697, 1.759, 1.69, 1.614, 1.807, 1.993, 1.969, 1.937, 2.062, 1.72, 1.685, 1.534, 1.614, 1.554, 1.603, 1.62, 1.844, 1.893, 1.906, 1.829, 1.941, 1.759, 1.671, 1.665, 1.666, 1.56, 1.574, 1.524, 1.896, 2.054, 1.879, 1.8, 2.023, 1.717, 1.721, 1.584, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.663, 1.77, 1.733, 1.557, 1.54, 1.515, 1.787, 2.058, 1.834, 1.819, 2.047, 1.807, 1.654, 1.794, null] 
        }]
    })
    $('#nucapsmw_LandAndSea_WaterVapor_StdDev_49hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 49 hPa Level Statistics, Land and Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, 7.813, 10.306, 11.604, 18.826, 4.475, 3.347, 6.329, 13.484, 8.226, 8.329, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, 7.657, 10.188, 11.614, 19.037, 4.426, 3.307, 6.371, 14.227, 8.385, 8.421, 7.581, 7.272, 8.092, 8.109, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, 7.733, 10.2, 11.846, 19.05, 5.208, 4.476, 8.695, 14.377, 8.933, 8.581, 7.581, 7.326, 8.213, 8.986, 11.31, 9.774, 8.719, 9.851, 9.218, 8.332, 6.61, 8.052, 6.85, 7.078, 4.341, 4.632, 6.992, 7.219, 4.777, 3.984, 1.933, 4.868, 8.135, 6.645, 5.478, 5.215, 6.017, 6.492, 7.311, 9.428, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 4.806, 4.288, 4.688, 6.991, 7.224, 4.755, 4.049, 1.957, 4.912, 8.088, 6.692, 5.597, 5.188, 5.959, 6.477, 7.249, 9.25, 4.829, 2.482, 3.709, 4.902, 9.344, 6.935, 0.0, 0.0, 0.0, 6.936, 0.0, 0.048, 7.751, 5.572, 6.436, 0.077, 0.048, 0.084, 5.83, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, 7.935, 10.341, 11.755, 18.858, 4.476, 3.351, 6.333, 13.367, 8.213, 8.385, 7.673, 6.261, 4.798, 5.483, 6.732, 5.826, 4.863, 5.917, 5.717, 4.841, 3.589, 4.776, 4.304, 4.439, 4.616, 5.012, 7.172, 7.222, 4.79, 4.003, 1.958, 4.912, 8.242, 6.735, 6.076, 5.637, 6.175, 6.752, 7.655, 9.342, 4.855, 2.476, 3.692, 4.881, 9.443, 7.179, 0.0, 5.923, 0.0, 7.32, 0.0, 0.048, 7.609, 5.685, 6.419, 0.069, 0.048, 0.069, 5.96, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 6.903, 0.0, 0.0, 0.0, 7.412, 0.0, 0.048, 7.606, 5.519, 6.669, 0.084, 0.048, 8.234, 7.946, null] 
        }]
    })
    $('#nucapsmw_LandAndSea_Temperature_RMS_49hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 49 hPa Level Statistics, Land and Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, 1.772, 1.701, 1.863, 1.966, 1.893, 2.149, 1.922, 1.993, 1.893, 2.076, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, 1.58, 1.553, 1.7, 1.799, 1.928, 2.122, 1.927, 1.922, 1.805, 1.703, 1.572, 1.552, 1.525, 1.551, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, 1.557, 1.537, 1.701, 1.785, 1.902, 2.115, 1.938, 1.933, 1.83, 1.755, 1.579, 1.524, 1.481, 1.467, 1.638, 1.733, 1.988, 1.971, 2.085, 2.124, 1.979, 1.721, 1.716, 1.656, 1.753, 1.683, 1.687, 1.91, 2.126, 2.073, 2.082, 2.258, 1.95, 1.858, 1.707, 1.789, 1.797, 1.739, 1.832, 1.941, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.569, 1.689, 1.573, 1.608, 1.819, 2.007, 1.928, 1.916, 2.054, 1.757, 1.647, 1.535, 1.581, 1.591, 1.54, 1.658, 1.784, 1.869, 1.914, 1.854, 1.887, 1.737, 1.67, 1.609, 1.616, 1.517, 1.515, 1.507, 1.738, 2.0, 1.912, 1.856, 2.028, 1.767, 1.664, 1.578, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, 1.696, 1.657, 1.909, 1.878, 1.934, 2.133, 1.974, 1.929, 1.87, 1.858, 1.643, 1.642, 1.559, 1.55, 1.621, 1.901, 2.046, 1.903, 1.894, 1.991, 1.961, 1.683, 1.76, 1.779, 1.859, 1.769, 1.679, 1.839, 2.002, 1.972, 1.965, 2.07, 1.773, 1.727, 1.581, 1.713, 1.675, 1.706, 1.684, 1.865, 1.916, 1.907, 1.83, 1.943, 1.786, 1.703, 1.708, 1.741, 1.61, 1.635, 1.586, 1.92, 2.054, 1.883, 1.826, 2.051, 1.774, 1.789, 1.655, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.681, 1.783, 1.735, 1.571, 1.551, 1.534, 1.827, 2.156, 1.916, 1.857, 2.068, 1.818, 1.657, 1.794, null] 
        }]
    })
    $('#nucapsmw_LandAndSea_WaterVapor_RMS_49hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 49 hPa Level Statistics, Land and Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, 96.06, 94.65, 94.496, 90.749, 98.984, 99.038, 97.666, 93.961, 96.041, 95.42, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, 96.065, 94.732, 94.464, 90.535, 99.005, 99.051, 97.677, 93.225, 95.936, 95.191, 95.725, 95.927, 95.541, 95.386, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, 95.996, 94.594, 94.26, 90.485, 98.871, 98.983, 96.763, 94.126, 95.718, 95.168, 95.698, 95.88, 95.401, 95.085, 94.497, 96.166, 97.587, 96.841, 97.094, 97.296, 97.197, 96.261, 96.903, 96.656, 97.762, 97.805, 96.711, 97.105, 98.333, 99.099, 99.512, 98.33, 96.009, 96.76, 97.25, 97.282, 96.864, 96.681, 96.627, 95.875, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 97.553, 97.795, 97.814, 96.702, 97.111, 98.332, 99.078, 99.507, 98.314, 96.044, 96.695, 97.173, 97.288, 96.861, 96.678, 96.648, 96.256, 98.845, 99.445, 99.236, 98.286, 95.507, 96.707, 100.0, 100.0, 100.0, 97.021, 100.0, 100.0, 97.164, 98.676, 98.218, 99.998, 100.0, 100.0, 97.702, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, 95.956, 94.634, 94.391, 90.695, 98.984, 99.038, 97.666, 93.995, 96.054, 95.362, 95.694, 96.497, 97.148, 96.879, 96.601, 97.588, 98.538, 97.902, 97.802, 98.182, 98.407, 97.712, 97.936, 97.735, 97.562, 97.58, 96.617, 97.097, 98.334, 99.091, 99.506, 98.311, 95.96, 96.715, 96.792, 97.013, 96.746, 96.532, 96.421, 96.222, 98.835, 99.447, 99.24, 98.297, 95.466, 96.553, 100.0, 97.179, 100.0, 96.86, 100.0, 100.0, 97.291, 98.614, 98.217, 99.998, 100.0, 100.0, 97.555, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 96.676, 100.0, 100.0, 100.0, 96.819, 100.0, 100.0, 97.29, 98.685, 98.108, 99.998, 100.0, 96.068, 95.765, null] 
        }]
    })
    $('#nucapsmw_Sea_Temperature_Bias_99hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 99 hPa Level Statistics, Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: -5.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, -1.943, -1.373, -1.024, -1.137, -1.384, -1.494, -1.596, -1.682, -1.754, -2.051, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, -1.107, -0.839, -0.66, -0.619, -1.03, -1.224, -1.392, -1.397, -1.297, -1.677, -1.307, -0.341, -1.015, -0.838, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, -1.522, -0.991, -0.643, -0.74, -1.067, -1.183, -1.403, -1.519, -1.268, -1.633, -1.55, -0.722, -1.124, -1.172, -0.807, -1.033, -1.206, -0.984, -0.371, -0.884, -1.055, -1.608, -1.545, -0.828, -0.072, 0.035, 0.423, 0.027, 0.304, 0.114, -0.185, -1.176, -0.506, -0.402, -0.144, 0.077, 0.188, 0.141, -0.424, -0.605, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.411, 0.019, 0.047, 0.496, 0.367, 0.378, 0.196, -0.062, -0.994, -0.372, -0.429, -0.369, 0.176, 0.098, 0.274, -0.282, -0.409, -0.684, -0.885, -1.245, -1.46, -1.105, -1.111, -0.699, 0.011, -0.164, -0.109, -0.3, -0.606, -0.341, -0.436, -0.188, -0.427, -0.367, -0.245, -0.402, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, -1.809, -1.287, -1.087, -1.058, -1.323, -1.377, -1.739, -1.624, -1.707, -2.08, -1.664, -0.769, -0.602, -0.57, -0.289, -0.401, -0.381, -0.171, 0.395, -0.5, -0.242, -0.891, -1.002, 0.072, -0.222, -0.12, 0.257, 0.036, 0.089, 0.077, -0.339, -1.357, -0.54, -0.545, -0.713, 0.194, -0.242, -0.218, -0.529, -0.719, -0.997, -0.919, -1.511, -1.572, -1.307, -1.302, -0.804, -0.106, -0.24, -0.318, -0.355, -0.57, -0.505, -0.462, -0.238, -0.465, -0.586, -0.703, -0.645, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -0.917, -0.373, 0.2, 0.059, 0.092, -0.048, -0.349, -0.182, -0.176, 0.074, -0.11, -0.302, -0.221, -0.277, null] 
        }]
    })
    $('#nucapsmw_Sea_WaterVapor_Bias_99hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 99 hPa Level Statistics, Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 50.0,
          min: -50.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, 90.599, 97.374, 118.956, 164.422, 135.905, 85.484, 121.351, 34.575, 50.712, 51.913, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, 39.198, 38.076, 40.833, 63.206, -49.588, -26.487, -6.905, -6.995, 21.628, 33.027, -26.081, 10.5, 2.03, -28.744, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, 58.529, 47.848, 30.659, 75.553, -11.155, -18.497, 21.477, -7.671, -10.613, -4.55, 11.723, 9.243, 36.02, -1.489, 35.88, 8.073, 1.681, 30.715, -2.876, -12.797, 12.491, 11.015, -11.225, 1.036, -20.701, -39.383, -39.331, -16.536, -21.798, -31.532, -30.12, -11.49, -33.2, -13.699, -35.856, -28.938, -33.478, -48.896, -40.296, -57.85, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 23.572, -25.797, -36.67, -35.949, -39.733, -4.643, -15.348, -9.382, 0.659, -24.114, -25.083, -36.769, -36.742, -31.898, -43.794, -40.886, -43.123, -39.546, -41.336, -22.318, -34.37, -2.707, -9.527, -26.18, -20.803, -19.566, -16.254, -21.796, -30.234, -15.09, -6.057, -12.298, -39.686, -14.041, -14.514, -23.098, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, 96.168, 131.426, 122.804, 156.408, 97.854, 101.17, 123.25, 72.482, -0.166, 29.829, 1.32, 37.566, -20.359, -22.311, -24.465, -9.173, -1.104, 28.579, -26.649, 16.699, 18.372, 38.349, -3.368, 25.499, 31.342, 18.213, 3.729, 33.303, 34.894, 33.414, 44.803, 21.996, 17.485, 27.979, 1.654, 11.854, -18.509, -1.869, -28.634, -35.342, -6.004, -20.947, -41.203, -1.941, 8.127, 12.48, -100.28, -7.585, -3.604, -7.439, 6.522, 0.081, 25.45, 14.263, 1.483, 5.788, 2.837, -6.705, -68.443, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 10.736, -24.306, -12.763, -1.469, -5.672, 3.018, 9.819, 29.214, 16.035, 11.44, 13.912, 7.463, -3.962, -6.449, null] 
        }]
    })
    $('#nucapsmw_Sea_Temperature_StdDev_99hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 99 hPa Level Statistics, Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, 2.582, 1.993, 2.118, 2.167, 2.245, 2.206, 2.249, 1.905, 2.013, 1.871, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, 2.593, 2.168, 2.293, 2.321, 2.232, 2.432, 2.479, 2.177, 2.044, 2.036, 2.157, 2.436, 2.186, 2.332, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, 2.504, 2.152, 2.208, 2.156, 2.11, 2.257, 2.332, 2.029, 2.014, 2.025, 2.037, 2.281, 2.082, 1.985, 2.107, 1.934, 2.083, 2.003, 2.0, 1.994, 1.803, 1.992, 2.104, 2.043, 2.337, 2.378, 2.462, 2.352, 2.437, 2.661, 2.364, 2.509, 2.248, 2.154, 2.145, 2.614, 2.513, 2.325, 2.236, 2.228, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.962, 2.219, 2.243, 2.307, 2.355, 2.321, 2.23, 1.96, 2.117, 1.848, 1.697, 1.741, 2.108, 1.952, 1.846, 1.743, 1.733, 1.716, 2.009, 1.985, 1.987, 1.817, 1.798, 1.831, 1.972, 1.894, 1.968, 1.775, 1.67, 2.042, 2.009, 1.984, 1.775, 1.777, 1.717, 1.768, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, 2.594, 2.593, 2.06, 2.188, 2.21, 2.747, 2.446, 1.938, 1.942, 1.974, 2.602, 2.364, 2.12, 1.831, 1.83, 1.842, 1.888, 1.985, 2.122, 2.014, 1.954, 1.831, 1.907, 1.827, 2.246, 2.225, 2.175, 2.128, 2.064, 2.233, 2.002, 2.077, 1.852, 1.761, 1.819, 2.105, 2.013, 1.815, 1.599, 1.719, 1.652, 1.876, 1.962, 1.827, 1.777, 1.843, 1.841, 1.952, 1.829, 1.801, 1.794, 1.682, 1.999, 1.965, 1.881, 1.704, 1.711, 1.667, 1.682, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.722, 2.428, 1.811, 1.828, 1.856, 1.771, 1.671, 1.972, 1.974, 1.897, 1.621, 1.718, 2.102, 1.589, null] 
        }]
    })
    $('#nucapsmw_Sea_WaterVapor_StdDev_99hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 99 hPa Level Statistics, Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, 74.796, 94.026, 112.055, 132.61, 115.832, 85.213, 106.183, 47.159, 43.605, 47.886, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, 55.146, 57.809, 53.835, 51.643, 6.737, 10.632, 17.973, 17.734, 43.319, 56.165, 22.89, 34.322, 27.244, 26.24, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, 72.334, 65.549, 47.938, 69.952, 13.571, 12.67, 30.245, 17.36, 25.052, 27.109, 38.081, 34.38, 55.299, 36.413, 45.799, 27.57, 20.315, 36.742, 18.813, 18.46, 28.597, 28.992, 27.974, 23.899, 31.532, 16.26, 18.626, 29.962, 21.097, 10.931, 10.609, 33.811, 19.369, 28.593, 22.203, 28.797, 26.373, 12.795, 20.683, 9.155, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 54.725, 22.836, 20.361, 21.465, 13.774, 37.818, 22.685, 23.952, 46.514, 17.179, 21.505, 22.948, 22.763, 28.739, 17.782, 18.944, 14.023, 12.095, 15.139, 15.856, 10.444, 46.501, 35.187, 28.279, 35.21, 30.649, 34.496, 30.388, 19.411, 30.009, 30.273, 31.901, 8.281, 37.559, 36.839, 33.431, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, 98.323, 108.139, 112.643, 93.064, 49.247, 92.923, 98.256, 63.261, 25.977, 39.271, 24.891, 60.191, 29.553, 27.549, 23.052, 34.683, 23.349, 58.56, 10.983, 45.54, 56.592, 64.062, 42.463, 54.769, 58.009, 56.25, 30.655, 60.594, 65.901, 64.371, 58.585, 49.543, 46.339, 44.508, 50.215, 41.327, 21.89, 45.774, 19.893, 15.319, 41.804, 20.476, 9.995, 44.087, 41.5, 50.288, 0.0, 47.268, 48.193, 41.386, 48.196, 46.709, 54.956, 54.394, 48.587, 48.514, 50.373, 45.995, 1.773, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 49.492, 27.15, 42.13, 47.089, 42.473, 50.345, 53.152, 55.146, 50.438, 51.74, 56.11, 45.037, 47.686, 47.237, null] 
        }]
    })
    $('#nucapsmw_Sea_Temperature_RMS_99hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 99 hPa Level Statistics, Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, 3.232, 2.42, 2.353, 2.448, 2.637, 2.665, 2.758, 2.542, 2.67, 2.776, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, 2.82, 2.325, 2.386, 2.402, 2.458, 2.723, 2.843, 2.587, 2.421, 2.638, 2.523, 2.46, 2.41, 2.478, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, 2.931, 2.369, 2.3, 2.279, 2.364, 2.548, 2.722, 2.535, 2.381, 2.601, 2.56, 2.392, 2.366, 2.305, 2.257, 2.193, 2.407, 2.232, 2.035, 2.182, 2.089, 2.56, 2.611, 2.205, 2.338, 2.378, 2.499, 2.352, 2.456, 2.664, 2.372, 2.771, 2.304, 2.192, 2.15, 2.615, 2.52, 2.329, 2.276, 2.308, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 2.004, 2.219, 2.243, 2.36, 2.383, 2.352, 2.239, 1.961, 2.339, 1.885, 1.751, 1.78, 2.115, 1.954, 1.866, 1.765, 1.781, 1.848, 2.195, 2.343, 2.465, 2.127, 2.114, 1.96, 1.972, 1.902, 1.971, 1.8, 1.776, 2.071, 2.056, 1.993, 1.825, 1.815, 1.735, 1.814, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, 3.162, 2.895, 2.329, 2.43, 2.576, 3.073, 3.002, 2.529, 2.586, 2.868, 3.089, 2.486, 2.204, 1.918, 1.853, 1.886, 1.926, 1.993, 2.159, 2.075, 1.969, 2.037, 2.155, 1.828, 2.257, 2.228, 2.19, 2.128, 2.066, 2.234, 2.03, 2.481, 1.929, 1.843, 1.954, 2.114, 2.027, 1.828, 1.684, 1.863, 1.93, 2.089, 2.477, 2.411, 2.206, 2.257, 2.009, 1.955, 1.845, 1.829, 1.829, 1.776, 2.061, 2.019, 1.896, 1.766, 1.809, 1.81, 1.802, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.951, 2.456, 1.822, 1.829, 1.858, 1.771, 1.708, 1.98, 1.982, 1.899, 1.624, 1.745, 2.114, 1.613, null] 
        }]
    })
    $('#nucapsmw_Sea_WaterVapor_RMS_99hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 99 hPa Level Statistics, Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, 102.034, 102.841, 114.848, 133.154, 122.864, 93.829, 106.248, 91.726, 96.583, 95.98, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, 95.631, 94.26, 94.674, 97.872, 99.307, 98.795, 97.521, 97.804, 92.79, 89.889, 96.008, 96.143, 97.431, 94.91, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, 96.402, 94.299, 94.851, 97.909, 98.831, 98.53, 95.856, 97.861, 95.681, 95.996, 94.803, 96.18, 94.055, 94.289, 95.795, 97.093, 97.895, 95.155, 97.703, 97.276, 96.462, 96.378, 95.184, 97.942, 90.385, 96.714, 95.081, 91.35, 95.387, 98.543, 98.63, 89.165, 94.981, 93.464, 93.906, 90.541, 91.582, 97.557, 93.829, 98.195, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 55.954, 95.103, 94.885, 93.762, 97.25, 87.483, 95.49, 95.272, 80.162, 96.993, 95.469, 93.14, 93.536, 89.52, 95.532, 94.896, 97.105, 97.99, 96.478, 97.629, 98.654, 74.727, 89.931, 91.612, 87.35, 91.707, 89.223, 90.701, 95.871, 91.74, 93.387, 90.838, 99.072, 84.798, 86.917, 87.846, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, 104.334, 125.787, 113.672, 111.22, 99.956, 98.726, 104.56, 95.132, 96.359, 96.007, 97.385, 93.272, 91.853, 92.972, 94.711, 89.841, 96.365, 83.312, 98.736, 89.656, 78.165, 64.521, 85.843, 55.252, 58.58, 64.457, 94.578, 60.813, 70.807, 67.294, 60.149, 49.652, 46.974, 45.356, 67.003, 41.766, 96.303, 57.165, 95.945, 97.212, 84.627, 96.053, 98.6, 83.429, 43.954, 54.032, 100.0, 73.725, 64.105, 85.509, 53.672, 82.4, 55.279, 80.363, 77.493, 82.645, 66.586, 76.239, 99.907, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 53.551, 92.884, 81.918, 57.573, 85.167, 62.107, 60.358, 55.151, 86.712, 59.125, 74.939, 49.004, 75.01, 72.203, null] 
        }]
    })
    $('#nucapsmw_Land_Temperature_Bias_99hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 99 hPa Level Statistics, Land, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: -5.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, -1.821, -1.552, -1.197, -1.129, -1.137, -1.227, -1.302, -1.177, -1.216, -1.578, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, -1.402, -1.032, -0.619, -0.575, -0.594, -0.79, -0.829, -0.72, -0.734, -1.135, -1.199, -1.069, -1.011, -0.685, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, -1.495, -1.098, -0.727, -0.634, -0.66, -0.861, -0.935, -0.84, -0.772, -1.17, -1.27, -1.189, -1.125, -0.886, -0.501, -0.594, -0.776, -0.548, -0.258, -0.491, -0.634, -1.139, -1.232, -0.924, -0.512, -0.418, -0.304, -0.315, -0.324, -0.273, -0.387, -0.622, -0.423, -0.472, -0.744, -0.329, -0.425, -0.314, -0.383, -0.226, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -0.517, -0.466, -0.359, -0.272, -0.294, -0.386, -0.301, -0.439, -0.655, -0.425, -0.578, -0.774, -0.242, -0.361, -0.228, -0.317, -0.277, -0.436, -0.385, -0.62, -0.631, -0.663, -0.856, -0.934, -0.628, -0.689, -0.569, -0.545, -0.621, -0.696, -0.582, -0.341, -0.279, -0.352, -0.492, -0.502, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, -1.673, -1.355, -1.021, -0.912, -0.89, -1.014, -1.049, -0.961, -1.023, -1.398, -1.502, -1.019, -0.69, -0.692, -0.449, -0.498, -0.602, -0.346, -0.164, -0.52, -0.511, -0.842, -0.882, -0.467, -0.698, -0.682, -0.578, -0.588, -0.667, -0.554, -0.683, -0.863, -0.691, -0.846, -0.989, -0.498, -0.642, -0.572, -0.727, -0.598, -0.67, -0.627, -0.95, -0.954, -0.933, -1.032, -0.934, -0.668, -0.738, -0.64, -0.58, -0.596, -0.788, -0.68, -0.528, -0.518, -0.635, -0.769, -0.814, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -0.755, -0.615, -0.374, -0.447, -0.351, -0.32, -0.358, -0.515, -0.41, -0.246, -0.209, -0.335, -0.467, -0.427, null] 
        }]
    })
    $('#nucapsmw_Land_WaterVapor_Bias_99hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 99 hPa Level Statistics, Land, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 50.0,
          min: -50.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, -72.122, -69.328, -67.147, -60.249, -70.202, -70.911, -81.411, -70.769, -75.88, -76.215, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, -73.322, -70.148, -67.256, -60.429, -70.341, -71.141, -81.249, -70.71, -75.857, -77.179, -74.523, -71.621, -72.699, -77.059, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, -73.098, -70.577, -66.89, -60.417, -66.722, -64.564, -76.717, -65.907, -74.405, -76.632, -74.7, -71.291, -72.623, -74.283, -68.268, -68.944, -67.469, -65.015, -67.24, -59.392, -72.947, -77.004, -75.054, -72.766, -83.26, -83.058, -78.807, -77.767, -78.876, -68.253, -77.78, -78.707, -78.996, -79.048, -80.614, -79.027, -77.16, -77.534, -77.515, -76.096, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -81.227, -83.507, -82.96, -78.821, -77.73, -79.016, -68.076, -77.736, -78.626, -79.064, -79.387, -80.321, -79.189, -77.43, -77.668, -77.764, -74.919, -72.522, -76.964, -72.943, -81.75, -78.028, -80.14, -81.38, -79.66, -113.106, -78.428, -76.354, -74.706, -75.488, -104.61, -87.56, -110.535, -79.268, -76.919, -75.532, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, -71.898, -69.457, -66.871, -60.257, -70.207, -70.853, -81.462, -71.093, -75.903, -76.261, -73.957, -75.676, -81.77, -82.399, -79.937, -79.993, -79.358, -76.435, -78.664, -75.166, -81.251, -84.44, -83.049, -81.653, -82.604, -82.014, -78.317, -77.794, -78.8, -68.117, -77.683, -78.444, -78.585, -78.711, -79.352, -77.845, -76.605, -76.684, -76.996, -74.58, -72.585, -76.829, -72.53, -81.728, -77.663, -79.445, -80.047, -78.564, -112.42, -77.249, -75.647, -74.59, -75.261, -104.718, -87.493, -110.561, -78.863, -76.276, -75.142, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -80.045, -80.239, -78.345, -112.42, -77.024, -75.617, -74.561, -75.28, -104.534, -87.486, -110.537, -78.807, -76.09, -74.781, null] 
        }]
    })
    $('#nucapsmw_Land_Temperature_StdDev_99hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 99 hPa Level Statistics, Land, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, 1.844, 1.707, 1.729, 1.986, 1.899, 2.089, 2.01, 2.026, 1.895, 2.137, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, 1.846, 1.682, 1.737, 1.91, 1.98, 2.167, 2.198, 2.098, 1.969, 1.932, 1.863, 1.738, 1.665, 1.853, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, 1.803, 1.628, 1.691, 1.847, 1.953, 2.151, 2.142, 2.061, 1.902, 1.879, 1.82, 1.701, 1.629, 1.645, 1.622, 1.803, 1.963, 1.89, 1.878, 1.831, 1.826, 1.838, 1.773, 1.747, 1.663, 1.711, 1.729, 1.89, 1.98, 2.013, 2.088, 2.198, 2.007, 1.96, 1.93, 2.118, 2.075, 1.994, 2.065, 2.085, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.612, 1.603, 1.652, 1.649, 1.763, 1.767, 1.718, 1.748, 1.807, 1.639, 1.645, 1.667, 1.758, 1.681, 1.611, 1.716, 1.743, 1.739, 1.699, 1.751, 1.817, 1.713, 1.742, 1.647, 1.654, 1.67, 1.742, 1.657, 1.724, 1.833, 1.813, 1.76, 1.884, 1.78, 1.699, 1.707, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, 1.827, 1.707, 1.872, 1.916, 1.915, 2.041, 2.07, 2.016, 1.894, 1.935, 1.817, 1.802, 1.615, 1.658, 1.561, 1.8, 1.855, 1.786, 1.69, 1.798, 1.79, 1.627, 1.765, 1.699, 1.693, 1.726, 1.661, 1.748, 1.75, 1.738, 1.807, 1.825, 1.639, 1.7, 1.674, 1.828, 1.729, 1.729, 1.742, 1.776, 1.753, 1.695, 1.752, 1.884, 1.745, 1.738, 1.689, 1.644, 1.683, 1.765, 1.634, 1.867, 1.855, 1.77, 1.705, 1.939, 1.759, 1.817, 1.738, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.76, 1.762, 1.678, 1.638, 1.731, 1.606, 1.767, 1.864, 1.719, 1.68, 1.93, 1.869, 1.728, 1.887, null] 
        }]
    })
    $('#nucapsmw_Land_WaterVapor_StdDev_99hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 99 hPa Level Statistics, Land, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, 12.754, 13.932, 15.175, 17.85, 10.153, 9.376, 7.663, 12.303, 10.312, 10.513, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, 12.259, 13.497, 15.158, 17.78, 10.142, 9.423, 7.757, 12.445, 10.326, 10.175, 11.954, 13.142, 12.803, 10.745, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, 12.42, 13.511, 15.361, 17.826, 11.11, 10.891, 9.11, 13.519, 10.881, 10.377, 11.863, 13.346, 12.908, 11.89, 14.978, 13.742, 12.024, 12.686, 11.438, 14.543, 11.507, 10.082, 10.543, 11.627, 7.05, 6.897, 9.097, 9.167, 8.194, 12.053, 7.712, 8.471, 8.736, 8.636, 8.491, 9.159, 9.937, 9.788, 9.718, 10.344, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 8.365, 6.944, 6.922, 9.092, 9.159, 8.163, 12.11, 7.739, 8.5, 8.704, 8.552, 8.583, 9.087, 9.857, 9.744, 9.629, 10.764, 10.892, 6.976, 9.899, 5.943, 8.963, 8.022, 7.617, 8.31, 0.069, 8.607, 9.848, 10.576, 10.304, 0.0, 0.158, 0.069, 7.427, 9.463, 9.404, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, 12.884, 13.819, 15.265, 17.852, 10.151, 9.391, 7.648, 12.184, 10.282, 10.536, 12.191, 11.658, 8.262, 7.831, 8.899, 8.662, 7.559, 9.073, 8.278, 9.51, 7.992, 6.649, 6.872, 7.632, 7.412, 7.356, 9.293, 9.143, 8.22, 12.081, 7.755, 8.556, 8.867, 8.759, 9.02, 9.726, 10.242, 10.157, 9.927, 10.896, 10.862, 6.987, 9.961, 5.933, 9.061, 8.306, 8.318, 9.018, 0.048, 9.141, 10.121, 10.623, 10.357, 0.0, 0.165, 0.069, 7.558, 9.745, 9.823, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 8.086, 8.204, 9.123, 0.048, 9.241, 10.126, 10.629, 10.349, 0.0, 0.158, 0.069, 7.579, 9.876, 10.799, null] 
        }]
    })
    $('#nucapsmw_Land_Temperature_RMS_99hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 99 hPa Level Statistics, Land, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, 2.592, 2.307, 2.103, 2.285, 2.213, 2.423, 2.395, 2.343, 2.252, 2.657, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, 2.318, 1.974, 1.844, 1.995, 2.067, 2.307, 2.349, 2.218, 2.102, 2.241, 2.215, 2.041, 1.948, 1.976, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, 2.342, 1.964, 1.84, 1.953, 2.062, 2.317, 2.337, 2.226, 2.053, 2.214, 2.219, 2.075, 1.98, 1.869, 1.697, 1.899, 2.111, 1.968, 1.896, 1.895, 1.934, 2.163, 2.159, 1.977, 1.74, 1.761, 1.756, 1.916, 2.006, 2.031, 2.124, 2.284, 2.051, 2.016, 2.069, 2.144, 2.118, 2.019, 2.1, 2.097, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.693, 1.669, 1.691, 1.671, 1.787, 1.809, 1.744, 1.803, 1.922, 1.693, 1.744, 1.838, 1.775, 1.719, 1.627, 1.746, 1.765, 1.793, 1.742, 1.858, 1.923, 1.837, 1.941, 1.893, 1.769, 1.806, 1.832, 1.744, 1.832, 1.961, 1.904, 1.793, 1.904, 1.814, 1.769, 1.78, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, 2.477, 2.179, 2.132, 2.122, 2.112, 2.279, 2.321, 2.233, 2.153, 2.388, 2.357, 2.07, 1.757, 1.797, 1.624, 1.868, 1.951, 1.82, 1.698, 1.872, 1.862, 1.832, 1.973, 1.762, 1.831, 1.856, 1.759, 1.844, 1.873, 1.824, 1.932, 2.019, 1.779, 1.899, 1.944, 1.895, 1.845, 1.822, 1.888, 1.875, 1.877, 1.807, 1.994, 2.112, 1.979, 2.022, 1.93, 1.774, 1.838, 1.877, 1.734, 1.96, 2.015, 1.897, 1.785, 2.007, 1.87, 1.974, 1.919, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.915, 1.866, 1.72, 1.698, 1.767, 1.638, 1.803, 1.934, 1.768, 1.698, 1.941, 1.898, 1.79, 1.935, null] 
        }]
    })
    $('#nucapsmw_Land_WaterVapor_RMS_99hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 99 hPa Level Statistics, Land, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, 94.904, 94.509, 93.744, 91.603, 96.448, 96.696, 95.539, 93.401, 94.442, 94.582, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, 94.995, 94.669, 93.706, 91.583, 96.43, 96.617, 95.471, 93.178, 94.444, 94.618, 94.462, 93.876, 94.528, 95.173, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, 94.91, 94.492, 93.63, 91.523, 96.294, 96.533, 95.3, 93.714, 94.306, 94.612, 94.522, 93.78, 94.429, 94.931, 93.368, 93.386, 95.377, 94.971, 95.561, 94.678, 93.94, 94.839, 95.855, 95.444, 96.874, 97.039, 95.396, 95.351, 96.125, 94.744, 96.756, 95.43, 95.149, 95.708, 95.622, 95.699, 95.453, 95.406, 94.976, 94.251, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 95.927, 96.919, 97.031, 95.395, 95.375, 96.117, 94.73, 96.745, 95.425, 95.171, 95.698, 95.594, 95.722, 95.457, 95.418, 95.0, 94.105, 94.836, 97.695, 95.637, 97.674, 95.297, 96.187, 96.518, 96.504, 100.0, 96.521, 95.352, 94.568, 94.39, 100.0, 99.998, 100.0, 96.758, 95.416, 96.217, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, 94.844, 94.587, 93.749, 91.613, 96.448, 96.693, 95.542, 93.442, 94.483, 94.499, 94.409, 94.616, 95.879, 96.128, 95.161, 95.147, 96.774, 95.827, 95.881, 95.541, 95.301, 96.404, 96.863, 96.678, 96.656, 96.843, 95.323, 95.368, 96.111, 94.739, 96.741, 95.397, 95.108, 95.662, 95.382, 95.409, 95.285, 95.272, 94.846, 94.048, 94.841, 97.697, 95.697, 97.685, 95.281, 96.066, 96.101, 96.041, 100.0, 96.298, 95.265, 94.543, 94.409, 100.0, 99.998, 100.0, 96.712, 95.273, 95.891, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 96.182, 96.179, 95.988, 100.0, 96.256, 95.262, 94.547, 94.407, 100.0, 99.998, 100.0, 96.708, 95.168, 94.669, null] 
        }]
    })
    $('#nucapsmw_LandAndSea_Temperature_Bias_99hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 99 hPa Level Statistics, Land and Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: -5.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, -1.756, -1.489, -1.118, -1.067, -1.121, -1.196, -1.285, -1.217, -1.217, -1.553, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, -1.329, -0.976, -0.55, -0.521, -0.583, -0.774, -0.841, -0.774, -0.748, -1.127, -1.2, -0.974, -0.967, -0.717, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, -1.428, -1.048, -0.659, -0.59, -0.659, -0.836, -0.933, -0.876, -0.792, -1.169, -1.282, -1.106, -1.095, -0.924, -0.537, -0.625, -0.824, -0.616, -0.278, -0.554, -0.681, -1.174, -1.255, -0.875, -0.415, -0.362, -0.153, -0.193, -0.197, -0.191, -0.352, -0.675, -0.444, -0.453, -0.675, -0.271, -0.353, -0.236, -0.404, -0.283, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -0.339, -0.363, -0.279, -0.113, -0.163, -0.234, -0.203, -0.397, -0.683, -0.424, -0.541, -0.711, -0.187, -0.294, -0.153, -0.332, -0.299, -0.464, -0.485, -0.743, -0.786, -0.773, -0.891, -0.93, -0.518, -0.59, -0.48, -0.497, -0.588, -0.592, -0.516, -0.323, -0.308, -0.378, -0.44, -0.489, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, -1.604, -1.302, -0.949, -0.863, -0.892, -0.993, -1.053, -1.01, -1.037, -1.393, -1.517, -0.948, -0.658, -0.672, -0.466, -0.504, -0.587, -0.384, -0.16, -0.588, -0.567, -0.863, -0.902, -0.413, -0.617, -0.634, -0.437, -0.473, -0.534, -0.47, -0.638, -0.909, -0.701, -0.819, -0.929, -0.452, -0.582, -0.499, -0.732, -0.615, -0.706, -0.727, -1.068, -1.112, -1.047, -1.073, -0.951, -0.586, -0.66, -0.546, -0.534, -0.559, -0.694, -0.622, -0.51, -0.546, -0.665, -0.735, -0.811, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -0.766, -0.623, -0.276, -0.358, -0.254, -0.266, -0.309, -0.418, -0.342, -0.226, -0.233, -0.357, -0.423, -0.424, null] 
        }]
    })
    $('#nucapsmw_LandAndSea_WaterVapor_Bias_99hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 99 hPa Level Statistics, Land and Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 50.0,
          min: -50.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, -68.903, -65.976, -63.677, -55.398, -69.027, -69.792, -79.357, -67.626, -73.597, -73.587, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, -70.104, -66.903, -64.007, -55.776, -69.376, -70.044, -79.108, -67.7, -73.507, -74.574, -72.23, -68.013, -69.435, -74.504, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, -69.833, -67.275, -63.564, -55.834, -66.303, -64.929, -74.513, -62.697, -71.9, -73.968, -72.414, -67.614, -69.154, -71.102, -64.991, -65.98, -65.053, -64.078, -65.437, -58.449, -71.249, -74.542, -71.95, -68.748, -81.125, -80.688, -76.762, -75.761, -77.033, -67.584, -76.112, -77.239, -76.904, -76.807, -78.486, -76.679, -74.568, -75.374, -75.605, -73.823, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -78.602, -81.34, -80.612, -76.837, -75.75, -77.231, -67.433, -76.028, -77.177, -76.952, -77.132, -78.239, -76.922, -74.943, -75.579, -75.879, -72.819, -71.092, -75.13, -70.937, -80.03, -75.342, -77.022, -103.975, -117.587, -107.086, -74.945, -73.252, -114.605, -72.562, -106.055, -85.473, -105.693, -76.819, -114.335, -106.6, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, -68.553, -66.022, -63.39, -55.468, -69.059, -69.718, -79.371, -67.951, -73.649, -73.585, -71.575, -72.914, -80.018, -80.796, -78.319, -78.673, -78.273, -75.503, -77.355, -74.348, -80.017, -82.839, -81.171, -79.358, -80.375, -79.663, -76.409, -75.875, -77.071, -67.57, -76.12, -77.158, -76.565, -76.454, -77.161, -75.523, -74.062, -74.499, -75.079, -72.513, -71.156, -75.069, -70.587, -80.05, -74.977, -76.245, -103.771, -115.766, -106.847, -73.701, -72.608, -114.36, -72.539, -106.143, -85.522, -114.42, -76.477, -114.102, -106.975, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -76.727, -103.675, -74.432, -106.847, -73.458, -72.609, -114.278, -72.542, -105.899, -85.488, -114.375, -76.398, -72.876, -104.607, null] 
        }]
    })
    $('#nucapsmw_LandAndSea_Temperature_StdDev_99hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 99 hPa Level Statistics, Land and Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, 1.974, 1.812, 1.893, 2.016, 1.963, 2.169, 2.06, 2.046, 1.906, 2.105, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, 1.937, 1.778, 1.846, 1.97, 2.042, 2.258, 2.251, 2.117, 1.98, 1.956, 1.883, 1.853, 1.767, 1.889, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, 1.904, 1.723, 1.802, 1.898, 2.007, 2.231, 2.191, 2.074, 1.914, 1.898, 1.838, 1.807, 1.736, 1.709, 1.679, 1.846, 1.997, 1.957, 1.928, 1.879, 1.836, 1.86, 1.824, 1.847, 1.802, 1.843, 1.931, 2.044, 2.126, 2.14, 2.134, 2.233, 2.037, 1.972, 1.954, 2.177, 2.129, 2.037, 2.079, 2.11, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.755, 1.749, 1.787, 1.868, 1.936, 1.945, 1.862, 1.807, 1.834, 1.667, 1.658, 1.666, 1.802, 1.721, 1.658, 1.719, 1.757, 1.744, 1.781, 1.835, 1.916, 1.756, 1.751, 1.67, 1.758, 1.741, 1.823, 1.686, 1.745, 1.902, 1.856, 1.807, 1.888, 1.777, 1.704, 1.73, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, 1.968, 1.795, 1.953, 1.971, 1.992, 2.145, 2.138, 2.029, 1.902, 1.949, 1.854, 1.907, 1.733, 1.719, 1.629, 1.828, 1.875, 1.822, 1.792, 1.884, 1.796, 1.669, 1.84, 1.915, 1.833, 1.875, 1.9, 1.906, 1.917, 1.903, 1.845, 1.849, 1.682, 1.7, 1.699, 1.871, 1.776, 1.764, 1.744, 1.804, 1.762, 1.795, 1.841, 1.986, 1.793, 1.743, 1.711, 1.744, 1.748, 1.863, 1.686, 1.868, 1.913, 1.812, 1.751, 1.922, 1.753, 1.786, 1.768, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.761, 1.782, 1.8, 1.728, 1.817, 1.662, 1.77, 1.912, 1.772, 1.755, 1.909, 1.836, 1.727, 1.855, null] 
        }]
    })
    $('#nucapsmw_LandAndSea_WaterVapor_StdDev_99hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 99 hPa Level Statistics, Land and Sea, Std Dev',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'STDDEV'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, 13.768, 15.013, 16.226, 19.425, 9.184, 9.164, 8.087, 13.125, 10.892, 11.325, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, 13.375, 14.547, 16.147, 19.349, 9.063, 9.2, 8.236, 13.305, 10.95, 11.024, 12.41, 14.421, 13.994, 11.671, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, 13.55, 14.583, 16.373, 19.398, 9.793, 10.23, 9.488, 14.366, 11.542, 11.244, 12.332, 14.66, 14.225, 13.039, 16.041, 14.548, 12.004, 11.973, 11.486, 14.099, 10.948, 10.384, 11.524, 12.985, 7.617, 7.55, 9.609, 9.653, 8.505, 11.194, 8.058, 8.56, 9.203, 9.195, 9.018, 9.621, 10.7, 10.272, 10.097, 10.845, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 8.967, 7.529, 7.569, 9.594, 9.642, 8.461, 11.247, 8.097, 8.578, 9.182, 9.134, 9.104, 9.543, 10.593, 10.203, 10.007, 11.152, 10.446, 7.343, 10.052, 6.275, 9.713, 8.896, 0.048, 0.0, 0.0, 9.539, 10.728, 0.048, 10.985, 0.0, 0.172, 0.0, 6.122, 0.048, 0.048, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, 14.02, 14.968, 16.319, 19.421, 9.178, 9.181, 8.081, 13.012, 10.846, 11.378, 12.682, 12.648, 8.802, 8.296, 9.335, 8.901, 7.422, 8.782, 8.311, 9.333, 7.777, 6.857, 7.426, 8.289, 8.016, 7.997, 9.753, 9.608, 8.494, 11.206, 8.069, 8.58, 9.312, 9.318, 9.687, 10.159, 10.988, 10.633, 10.351, 11.271, 10.433, 7.328, 10.113, 6.251, 9.809, 9.201, 0.0, 0.0, 0.0, 10.089, 10.976, 0.048, 10.918, 0.0, 0.179, 0.069, 6.174, 0.048, 0.048, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 9.018, 0.048, 10.258, 0.0, 10.195, 10.973, 0.048, 10.914, 0.0, 0.176, 0.069, 6.183, 10.803, 0.048, null] 
        }]
    })
    $('#nucapsmw_LandAndSea_Temperature_RMS_99hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 99 hPa Level Statistics, Land and Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, 2.642, 2.346, 2.199, 2.281, 2.261, 2.477, 2.428, 2.381, 2.261, 2.616, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, 2.349, 2.028, 1.926, 2.038, 2.124, 2.387, 2.403, 2.254, 2.117, 2.258, 2.233, 2.094, 2.015, 2.021, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, 2.381, 2.017, 1.919, 1.988, 2.112, 2.382, 2.381, 2.252, 2.072, 2.23, 2.241, 2.119, 2.053, 1.943, 1.763, 1.949, 2.16, 2.052, 1.948, 1.959, 1.958, 2.2, 2.214, 2.044, 1.849, 1.879, 1.937, 2.053, 2.136, 2.149, 2.163, 2.333, 2.085, 2.024, 2.067, 2.194, 2.158, 2.05, 2.118, 2.129, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.788, 1.787, 1.809, 1.871, 1.943, 1.959, 1.874, 1.85, 1.957, 1.721, 1.744, 1.812, 1.812, 1.746, 1.665, 1.751, 1.782, 1.805, 1.846, 1.98, 2.071, 1.919, 1.965, 1.912, 1.833, 1.839, 1.885, 1.758, 1.841, 1.992, 1.927, 1.836, 1.913, 1.817, 1.76, 1.798, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, 2.539, 2.218, 2.171, 2.152, 2.183, 2.364, 2.383, 2.267, 2.166, 2.396, 2.396, 2.129, 1.854, 1.846, 1.695, 1.896, 1.965, 1.862, 1.799, 1.974, 1.884, 1.879, 2.049, 1.96, 1.934, 1.979, 1.95, 1.964, 1.99, 1.961, 1.952, 2.06, 1.822, 1.887, 1.936, 1.924, 1.869, 1.833, 1.891, 1.906, 1.898, 1.937, 2.129, 2.277, 2.077, 2.047, 1.957, 1.84, 1.869, 1.941, 1.768, 1.95, 2.035, 1.916, 1.824, 1.998, 1.876, 1.932, 1.946, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.92, 1.888, 1.821, 1.764, 1.835, 1.684, 1.797, 1.957, 1.805, 1.769, 1.923, 1.871, 1.778, 1.903, null] 
        }]
    })
    $('#nucapsmw_LandAndSea_WaterVapor_RMS_99hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 99 hPa Level Statistics, Land and Sea, RMS',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 100.0,
          min: 0.0,
             title: {
                 text: 'RMS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, 94.99, 94.572, 93.818, 91.741, 97.361, 96.996, 95.705, 93.497, 94.574, 94.595, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, 94.985, 94.721, 93.778, 91.657, 97.395, 96.935, 95.577, 93.194, 94.543, 94.588, 94.752, 93.911, 94.555, 95.187, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, 94.921, 94.576, 93.708, 91.583, 97.289, 96.908, 95.491, 93.701, 94.396, 94.568, 94.803, 93.808, 94.422, 94.913, 93.464, 93.587, 95.896, 95.785, 95.856, 95.196, 95.245, 95.314, 95.735, 95.358, 96.855, 96.963, 95.414, 95.335, 96.221, 95.73, 96.723, 95.735, 95.219, 95.749, 95.745, 95.916, 95.395, 95.527, 95.152, 94.434, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 96.105, 96.89, 96.953, 95.407, 95.353, 96.22, 95.715, 96.704, 95.739, 95.233, 95.721, 95.705, 95.924, 95.398, 95.545, 95.175, 94.374, 95.702, 97.632, 95.901, 97.631, 95.183, 96.096, 100.0, 100.0, 100.0, 96.434, 95.266, 100.0, 94.535, 100.0, 99.998, 100.0, 98.256, 100.0, 100.0, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, 94.852, 94.603, 93.817, 91.729, 97.361, 96.995, 95.708, 93.531, 94.623, 94.5, 94.691, 94.633, 95.83, 96.093, 95.165, 95.288, 97.093, 96.321, 96.17, 95.888, 96.115, 96.763, 96.785, 96.61, 96.637, 96.777, 95.36, 95.343, 96.216, 95.715, 96.711, 95.719, 95.172, 95.703, 95.343, 95.665, 95.234, 95.406, 94.972, 94.315, 95.687, 97.639, 95.92, 97.643, 95.162, 95.978, 100.0, 100.0, 100.0, 96.221, 95.185, 100.0, 94.631, 100.0, 99.998, 100.0, 98.257, 100.0, 100.0, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 96.098, 100.0, 95.898, 100.0, 96.181, 95.182, 100.0, 94.63, 100.0, 99.998, 100.0, 98.259, 95.105, 100.0, null] 
        }]
    })
    $('#nucapsmw_Sea_Temperature_Bias_206hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Temperature 206 hPa Level Statistics, Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 5.0,
          min: -5.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, -1.368, -1.155, -0.957, -0.682, -0.583, 0.252, 0.14, 0.091, -0.372, -0.377, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, -1.356, -1.163, -1.323, -1.048, -0.866, -0.368, -0.751, -0.484, -0.779, -1.03, -0.839, -0.997, -1.347, -1.57, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, -1.167, -1.011, -0.927, -0.499, -0.342, 0.222, 0.046, 0.223, 0.0, -0.323, -0.583, -0.892, -1.435, -1.139, -0.585, -0.163, -0.086, -0.259, -0.581, -0.489, -0.568, -0.16, -0.708, -0.829, 0.649, 0.468, 0.36, 0.619, 0.522, 0.207, 0.294, 0.845, 0.533, 0.875, 0.691, 0.771, 0.417, 0.644, 0.98, 0.532, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0.133, 0.123, -0.095, 0.007, -0.007, -0.03, -0.286, -0.246, 0.442, 0.13, 0.39, 0.218, 0.231, -0.117, -0.022, 0.205, 0.037, 0.082, 0.034, 0.467, 0.412, 0.613, 0.686, 0.309, 0.156, 0.299, 0.103, 0.218, 0.227, 0.072, 0.028, -1.19, -0.181, 0.091, -0.013, 0.037, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, -1.529, -1.217, -1.038, -0.71, -0.732, 0.163, -0.008, -0.158, -0.452, -0.438, -1.043, -0.524, 0.044, 0.311, 0.37, 0.108, 0.303, 0.152, -0.269, 0.003, -0.116, 0.549, 0.322, 0.447, 0.451, 0.315, 0.319, 0.365, 0.24, 0.167, 0.159, 0.704, 0.356, 0.733, 0.658, 0.77, 0.406, 0.56, 0.501, 0.322, 0.257, 0.578, 0.91, 0.913, 0.903, 1.111, 0.754, 0.489, 0.607, 0.572, 0.34, 0.392, 0.503, 0.473, -0.626, 0.338, 0.373, 0.455, 0.383, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1.204, 0.924, 0.655, 0.699, 0.697, 0.552, 0.424, 0.623, 0.586, -0.369, 0.578, 0.473, 0.581, 0.345, null] 
        }]
    })
    $('#nucapsmw_Sea_WaterVapor_Bias_206hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 'Water Vapor Percent Error 206 hPa Level Statistics, Sea, Bias',
            style: {
            color: '#FF0000',
            fontWeight: 'bold'
            },
            x: -20 //center
        },
        colors: ['#00aaff', '#8cd78c', '#aa00aa', '#00ffff', '#c89678', '#ff80ff'],
        xAxis: {
            categories: ['Jul 2020',  
'Aug 2020', 'Sep 2020', 'Oct 2020', 'Nov 2020', 'Dec 2020', 'Jan 2021',  
'Feb 2021', 'Mar 2021', 'Apr 2021', 'May 2021', 'Jun 2021', 'Jul 2021',  
'Aug 2021', 'Sep 2021', 'Oct 2021', 'Nov 2021', 'Dec 2021', 'Jan 2022',  
'Feb 2022', 'Mar 2022', 'Apr 2022', 'May 2022', 'Jun 2022', 'Jul 2022',  
'Aug 2022', 'Sep 2022', 'Oct 2022', 'Nov 2022', 'Dec 2022', 'Jan 2023',  
'Feb 2023', 'Mar 2023', 'Apr 2023', 'May 2023', 'Jun 2023', 'Jul 2023',  
'Aug 2023', 'Sep 2023', 'Oct 2023', 'Nov 2023', 'Dec 2023', 'Jan 2024',  
'Feb 2024', 'Mar 2024', 'Apr 2024', 'May 2024', 'Jun 2024', 'Jul 2024',  
'Aug 2024', 'Sep 2024', 'Oct 2024', 'Nov 2024', 'Dec 2024', 'Jan 2025',  
'Feb 2025', 'Mar 2025', 'Apr 2025', 'May 2025', 'Jun 2025', 'Jul 2025'], 
            labels: {
                rotation: 90
            },
            minorGridLineDashStyle: 'longdash',
            minorTickInterval: 'auto',
            minorTickWidth: 0,
            plotLines: [{
                dashStyle: 'longdash',
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        yAxis: {
          max: 50.0,
          min: -50.0,
             title: {
                 text: 'BIAS'
             },
             plotLines: [{
                 value: 0,
                 width: 1,
                 color: '#808080'
             }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 0
        },
        series: [{
            name: 'NUCAPS NPP MW',
data: [
null, -6.541, -14.564, -10.758, 3.978, -5.864, -5.698, 9.344, -2.402, -3.67, -1.023, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-A MW',
data: [
null, -8.239, -15.788, -19.357, -5.084, -14.3, -13.882, -9.731, -17.81, -14.052, -14.931, -18.105, -23.568, -19.702, -24.06, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-B MW',
data: [
null, -9.567, -15.92, -18.229, -1.191, -11.845, -13.367, -5.02, -16.213, -9.981, -9.5, -14.973, -24.333, -19.507, -23.354, -18.017, -12.723, -13.691, -10.394, -14.383, -15.11, -8.627, -16.804, -22.981, -12.114, 19.974, 22.93, 13.919, 19.321, 15.129, 24.984, 23.04, 27.671, 25.279, 22.893, 16.641, 23.281, 25.673, 24.183, 16.152, 16.157, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null] }, { 
            name: 'NUCAPS MetOp-C MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 17.811, 21.965, 23.351, 18.875, 24.387, 24.344, 27.024, 30.319, 37.439, 30.637, 30.832, 18.056, 20.304, 30.822, 12.709, 13.116, 14.51, 19.762, 14.59, 35.239, 29.149, 37.288, 16.865, 26.151, 22.072, 21.421, 21.588, 21.135, -38.713, -1.908, 34.427, -5.445, 26.272, -37.475, 16.071, 20.147, null] }, { 
            name: 'NUCAPS NOAA-20 MW',
data: [
null, -9.551, -14.268, -13.08, 5.796, -8.066, -8.951, 3.367, -6.316, -6.666, -3.32, -10.888, -3.414, 11.575, 16.058, 16.856, 7.758, 13.531, 34.762, 28.772, 31.132, 30.589, 25.413, 14.706, 24.052, 21.955, 27.592, 18.502, 24.742, 27.357, 23.068, 20.156, 29.759, 29.648, 28.518, 19.23, 24.952, 26.344, 17.837, 6.95, 0.818, 16.125, 24.221, 37.772, 26.607, 36.815, 7.285, 15.59, 17.683, 16.047, 23.611, -64.368, 7.645, 5.857, 24.45, -31.878, -38.281, -56.283, 10.297, 19.532, null] }, { 
            name: 'NUCAPS NOAA-21 MW',
data: [
null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 34.8, 16.658, 19.675, 17.197, 24.555, 16.476, -69.661, -25.194, 23.683, -48.099, 22.143, 30.24, 11.402, 19.454, null] 
        }]
    })
    $('#nucapsmw_Sea_Temperature_StdDev_206hPa').highcharts({
        chart: {
           zoomType: 'x'
        },
        title: {
            text: 'NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)',
        },
        subtitle: {
            text: 