function getPointCategoryName(point)
  {
  let series = point.series;
  axis = series['yAxis'];
  console.log('category: ', axis.categories['y']);
  return axis.categories[point['y']];
  }
  
  
Highcharts.chart('container',
  {
  chart:
    {
    type: 'xrange'
    },

  title:
    {
    text: 'NPROVS Platform Availability'
    },

  accessibility:
    {
    point:
      {
      descriptionFormat: '{add index 1}. {yCategory}, {x:%e %B %Y} ' +
                         'to {x2:%e %B %Y}.'
      }
    },

  xAxis:
    {
    type: 'datetime',

    labels:
      {
      format: '{value:%B %Y}',
      rotation: 90
      }
    },

  yAxis:
    {
    title:
      {
      text: ''
      },

    categories:
      [
      'Radiosonde',
      'AIRS AQUA',
      'ATOVS MetOp-A',
      'ATOVS MetOp-B',
      'ATOVS MetOp-B Test',
      'ATOVS NOAA-18',
      'ATOVS NOAA-19',
      'ATOVS NOAA-19 Test',
      'COSMIC UCAR',
      'COSMIC-2 STAR',
      'COSMIC-2 UCAR',
      'CRIMSS NPP',
      'ECMWF',
      'EUMETSAT IASI MetOp-A',
      'EUMETSAT IASI MetOp-B',
      'EUMETSAT IASI MetOp-C',
      'GOES',
      'GOES-16',
      'GOES-18',
      'GOES-19',
      'GRAS',
      'HRRR',
      'HRRR (NUCAPS)',
      'Kompsat-5',
      'MIRS DMSP F18 Test',
      'MIRS MetOp-A',
      'MIRS MetOp-A Test',
      'MIRS MetOp-B',
      'MIRS MetOp-C',
      'MIRS NOAA-18',
      'MIRS NOAA-19',
      'MIRS NOAA-20',
      'MIRS NOAA-20 ATMS AI',
      'MIRS NOAA-20 CRIS AI',
      'MIRS NOAA-20 Comb AI',
      'MIRS NOAA-21',
      'MIRS NPP',
      'MIRS NPP (v11)',
      'MIRS SSMIS DMSP F16',
      'NUCAPS MetOp-A',
      'NUCAPS MetOp-B',
      'NUCAPS MetOp-B Test',
      'NUCAPS MetOp-C',
      'NUCAPS NOAA-20',
      'NUCAPS NOAA-20 Test',
      'NUCAPS NOAA-21',
      'NUCAPS NOAA-21 Test',
      'NUCAPS NPP',
      'NUCAPS NPP Test',
      'Unknown Platform',
      ],

    reversed: true
    },

   tooltip:
    {
    useHTML: true,

    formatter: function()
      {
      let start = Highcharts.dateFormat('%e %B %Y', this.x),
          end = Highcharts.dateFormat('%e %B %Y', this.x2);

      var info = this.point.options.extraInfo;

      return `<b>${getPointCategoryName(this)}:</b> ${start} to ${end}<br>Number of collocations: ${info}`
      },
    },  

  series:
    [{
    name: 'Platform',
    // pointPadding: 0,
    // groupPadding: 0,
    borderColor: 'gray',
    pointWidth: 20,

    data:
      [
      {
      x: Date.UTC(2008, 3, 8),
      x2: Date.UTC(2025, 6, 12),
      y: 0,
      extraInfo: '7,586,197',
      },

      {
      x: Date.UTC(2008, 3, 8),
      x2: Date.UTC(2025, 6, 12),
      y: 1,
      extraInfo: '6,648,500',
      },

      {
      x: Date.UTC(2008, 3, 8),
      x2: Date.UTC(2014, 10, 11),
      y: 2,
      extraInfo: '2,687,271',
      },

      {
      x: Date.UTC(2013, 4, 19),
      x2: Date.UTC(2023, 4, 9),
      y: 3,
      extraInfo: '4,046,665',
      },

      {
      x: Date.UTC(2012, 11, 1),
      x2: Date.UTC(2021, 9, 22),
      y: 4,
      extraInfo: '583,697',
      },

      {
      x: Date.UTC(2008, 3, 8),
      x2: Date.UTC(2014, 10, 11),
      y: 5,
      extraInfo: '2,746,238',
      },

      {
      x: Date.UTC(2009, 3, 25),
      x2: Date.UTC(2023, 9, 9),
      y: 6,
      extraInfo: '5,453,345',
      },

      {
      x: Date.UTC(2019, 11, 11),
      x2: Date.UTC(2023, 9, 9),
      y: 7,
      extraInfo: '1,088,635',
      },

      {
      x: Date.UTC(2008, 3, 8),
      x2: Date.UTC(2021, 9, 22),
      y: 8,
      extraInfo: '984,092',
      },

      {
      x: Date.UTC(2023, 0, 16),
      x2: Date.UTC(2025, 6, 12),
      y: 9,
      extraInfo: '216,517',
      },

      {
      x: Date.UTC(2020, 2, 11),
      x2: Date.UTC(2025, 6, 12),
      y: 10,
      extraInfo: '868,612',
      },

      {
      x: Date.UTC(2012, 11, 1),
      x2: Date.UTC(2014, 10, 11),
      y: 11,
      extraInfo: '635,201',
      },

      {
      x: Date.UTC(2013, 4, 19),
      x2: Date.UTC(2025, 6, 12),
      y: 12,
      extraInfo: '5,142,459',
      },

      {
      x: Date.UTC(2009, 2, 7),
      x2: Date.UTC(2021, 9, 22),
      y: 13,
      extraInfo: '5,007,122',
      },

      {
      x: Date.UTC(2013, 7, 11),
      x2: Date.UTC(2025, 6, 12),
      y: 14,
      extraInfo: '4,531,335',
      },

      {
      x: Date.UTC(2019, 11, 11),
      x2: Date.UTC(2025, 6, 12),
      y: 15,
      extraInfo: '1,953,183',
      },

      {
      x: Date.UTC(2008, 3, 8),
      x2: Date.UTC(2021, 9, 22),
      y: 16,
      extraInfo: '466,014',
      },

      {
      x: Date.UTC(2025, 1, 20),
      x2: Date.UTC(2025, 3, 7),
      y: 17,
      extraInfo: '16,734',
      },

      {
      x: Date.UTC(2025, 1, 19),
      x2: Date.UTC(2025, 6, 12),
      y: 18,
      extraInfo: '47,626',
      },

      {
      x: Date.UTC(2025, 3, 1),
      x2: Date.UTC(2025, 6, 12),
      y: 19,
      extraInfo: '36,194',
      },

      {
      x: Date.UTC(2014, 8, 14),
      x2: Date.UTC(2025, 6, 12),
      y: 20,
      extraInfo: '1,061,407',
      },

      {
      x: Date.UTC(2022, 3, 30),
      x2: Date.UTC(2025, 6, 12),
      y: 21,
      extraInfo: '148,738',
      },

      {
      x: Date.UTC(2022, 3, 30),
      x2: Date.UTC(2025, 6, 12),
      y: 22,
      extraInfo: '154,097',
      },

      {
      x: Date.UTC(2019, 11, 11),
      x2: Date.UTC(2023, 4, 9),
      y: 23,
      extraInfo: '42,729',
      },

      {
      x: Date.UTC(2012, 11, 1),
      x2: Date.UTC(2016, 9, 14),
      y: 24,
      extraInfo: '1,241,434',
      },

      {
      x: Date.UTC(2008, 3, 8),
      x2: Date.UTC(2021, 9, 22),
      y: 25,
      extraInfo: '5,322,716',
      },

      {
      x: Date.UTC(2012, 11, 1),
      x2: Date.UTC(2014, 10, 11),
      y: 26,
      extraInfo: '649,785',
      },

      {
      x: Date.UTC(2014, 7, 18),
      x2: Date.UTC(2025, 6, 12),
      y: 27,
      extraInfo: '4,297,375',
      },

      {
      x: Date.UTC(2019, 2, 8),
      x2: Date.UTC(2025, 6, 12),
      y: 28,
      extraInfo: '2,481,899',
      },

      {
      x: Date.UTC(2008, 3, 8),
      x2: Date.UTC(2021, 9, 22),
      y: 29,
      extraInfo: '4,951,625',
      },

      {
      x: Date.UTC(2009, 5, 14),
      x2: Date.UTC(2025, 6, 12),
      y: 30,
      extraInfo: '5,968,754',
      },

      {
      x: Date.UTC(2018, 0, 5),
      x2: Date.UTC(2025, 6, 12),
      y: 31,
      extraInfo: '3,155,472',
      },

      {
      x: Date.UTC(2019, 11, 5),
      x2: Date.UTC(2019, 11, 10),
      y: 32,
      extraInfo: '7,340',
      },

      {
      x: Date.UTC(2019, 11, 5),
      x2: Date.UTC(2019, 11, 10),
      y: 33,
      extraInfo: '7,234',
      },

      {
      x: Date.UTC(2019, 11, 5),
      x2: Date.UTC(2019, 11, 10),
      y: 34,
      extraInfo: '6,897',
      },

      {
      x: Date.UTC(2023, 9, 11),
      x2: Date.UTC(2025, 6, 12),
      y: 35,
      extraInfo: '684,097',
      },

      {
      x: Date.UTC(2012, 11, 1),
      x2: Date.UTC(2025, 6, 12),
      y: 36,
      extraInfo: '4,821,687',
      },

      {
      x: Date.UTC(2013, 4, 19),
      x2: Date.UTC(2016, 9, 14),
      y: 37,
      extraInfo: '595,634',
      },

      {
      x: Date.UTC(2009, 3, 1),
      x2: Date.UTC(2014, 4, 2),
      y: 38,
      extraInfo: '770,599',
      },

      {
      x: Date.UTC(2008, 6, 12),
      x2: Date.UTC(2021, 9, 22),
      y: 39,
      extraInfo: '5,254,962',
      },

      {
      x: Date.UTC(2014, 4, 3),
      x2: Date.UTC(2025, 6, 12),
      y: 40,
      extraInfo: '3,720,471',
      },

      {
      x: Date.UTC(2017, 0, 11),
      x2: Date.UTC(2017, 0, 31),
      y: 41,
      extraInfo: '903',
      },

      {
      x: Date.UTC(2022, 6, 28),
      x2: Date.UTC(2025, 6, 12),
      y: 42,
      extraInfo: '1,150,238',
      },

      {
      x: Date.UTC(2019, 2, 8),
      x2: Date.UTC(2025, 6, 12),
      y: 43,
      extraInfo: '2,586,745',
      },

      {
      x: Date.UTC(2018, 0, 5),
      x2: Date.UTC(2024, 4, 7),
      y: 44,
      extraInfo: '1,593,324',
      },

      {
      x: Date.UTC(2024, 4, 8),
      x2: Date.UTC(2025, 6, 12),
      y: 45,
      extraInfo: '484,252',
      },

      {
      x: Date.UTC(2023, 4, 10),
      x2: Date.UTC(2025, 6, 12),
      y: 46,
      extraInfo: '732,142',
      },

      {
      x: Date.UTC(2012, 11, 1),
      x2: Date.UTC(2022, 6, 27),
      y: 47,
      extraInfo: '3,347,355',
      },

      {
      x: Date.UTC(2015, 7, 8),
      x2: Date.UTC(2022, 6, 27),
      y: 48,
      extraInfo: '1,402,100',
      },

      {
      x: Date.UTC(2008, 6, 11),
      x2: Date.UTC(2022, 6, 28),
      y: 49,
      extraInfo: '9,767',
      },

      ],

    dataLabels:
      {
      enabled: true
      }
    }]
  });
