function getPointCategoryName(point)
  {
  let series = point.series;
  axis = series['yAxis'];
  console.log('category: ', axis.categories['y']);
  return axis.categories[point['y']];
  }
  
  
Highcharts.chart('container',
  {
  chart:
    {
    type: 'xrange'
    },

  title:
    {
    text: 'NPROVS Special Platform Availability'
    },

  accessibility:
    {
    point:
      {
      descriptionFormat: '{add index 1}. {yCategory}, {x:%e %B %Y} ' +
                         'to {x2:%e %B %Y}.'
      }
    },

  xAxis:
    {
    type: 'datetime',

    labels:
      {
      format: '{value:%B %Y}',
      rotation: 90
      }
    },

  yAxis:
    {
    title:
      {
      text: ''
      },

    categories:
      [
      'Radiosonde',
      'AIRS AQUA',
      'ATOVS MetOp-A',
      'ATOVS MetOp-B',
      'ATOVS NOAA-18',
      'ATOVS NOAA-19',
      'COSMIC UCAR',
      'COSMIC-2 STAR',
      'COSMIC-2 UCAR',
      'CRIMSS NPP',
      'ECMWF',
      'EUMETSAT IASI MetOp-A',
      'EUMETSAT IASI MetOp-B',
      'EUMETSET IASI MetOp-C',
      'GFS Analysis',
      'GOES',
      'GRAS',
      'Kompsat-5',
      'MIRS MetOp-A',
      'MIRS MetOp-A Test',
      'MIRS MetOp-B',
      'MIRS MetOp-C',
      'MIRS MetOp-C Test',
      'MIRS NOAA-18',
      'MIRS NOAA-19',
      'MIRS NOAA-20',
      'MIRS NOAA-20 Test',
      'MIRS NOAA-21',
      'MIRS NPP',
      'MIRS SSMIS DMSP F16',
      'MIRS SSMIS DMSP F18',
      'NUCAPS MetOp-A',
      'NUCAPS MetOp-B',
      'NUCAPS MetOp-C',
      'NUCAPS NOAA-20',
      'NUCAPS NOAA-20 Test',
      'NUCAPS NOAA-21',
      'NUCAPS NOAA-21 Test',
      'NUCAPS NPP',
      'NUCAPS NPP Test',
      ],

    reversed: true
    },

   tooltip:
    {
    useHTML: true,

    formatter: function()
      {
      let start = Highcharts.dateFormat('%e %B %Y', this.x),
          end = Highcharts.dateFormat('%e %B %Y', this.x2);

      var info = this.point.options.extraInfo;

      return `<b>${getPointCategoryName(this)}:</b> ${start} to ${end}<br>Number of collocations: ${info}`
      },
    },  

  series:
    [{
    name: 'Platform',
    // pointPadding: 0,
    // groupPadding: 0,
    borderColor: 'gray',
    pointWidth: 20,

    data:
      [
      {
      x: Date.UTC(2013, 6, 14),
      x2: Date.UTC(2025, 0, 5),
      y: 0,
      extraInfo: '83,240',
      },

      {
      x: Date.UTC(2013, 6, 14),
      x2: Date.UTC(2025, 0, 5),
      y: 1,
      extraInfo: '64,713',
      },

      {
      x: Date.UTC(2013, 6, 14),
      x2: Date.UTC(2014, 10, 6),
      y: 2,
      extraInfo: '5,495',
      },

      {
      x: Date.UTC(2013, 6, 14),
      x2: Date.UTC(2014, 10, 6),
      y: 3,
      extraInfo: '5,144',
      },

      {
      x: Date.UTC(2013, 6, 14),
      x2: Date.UTC(2014, 10, 6),
      y: 4,
      extraInfo: '4,375',
      },

      {
      x: Date.UTC(2013, 6, 14),
      x2: Date.UTC(2014, 10, 6),
      y: 5,
      extraInfo: '3,380',
      },

      {
      x: Date.UTC(2013, 6, 14),
      x2: Date.UTC(2021, 10, 23),
      y: 6,
      extraInfo: '4,271',
      },

      {
      x: Date.UTC(2023, 3, 10),
      x2: Date.UTC(2025, 0, 5),
      y: 7,
      extraInfo: '0',
      },

      {
      x: Date.UTC(2020, 2, 17),
      x2: Date.UTC(2025, 0, 5),
      y: 8,
      extraInfo: '9,456',
      },

      {
      x: Date.UTC(2013, 6, 14),
      x2: Date.UTC(2014, 10, 6),
      y: 9,
      extraInfo: '4,074',
      },

      {
      x: Date.UTC(2013, 6, 14),
      x2: Date.UTC(2025, 0, 5),
      y: 10,
      extraInfo: '77,127',
      },

      {
      x: Date.UTC(2013, 6, 14),
      x2: Date.UTC(2021, 10, 23),
      y: 11,
      extraInfo: '48,355',
      },

      {
      x: Date.UTC(2014, 4, 22),
      x2: Date.UTC(2025, 0, 5),
      y: 12,
      extraInfo: '64,984',
      },

      {
      x: Date.UTC(2019, 10, 28),
      x2: Date.UTC(2025, 0, 5),
      y: 13,
      extraInfo: '33,221',
      },

      {
      x: Date.UTC(2017, 3, 16),
      x2: Date.UTC(2024, 9, 7),
      y: 14,
      extraInfo: '41,962',
      },

      {
      x: Date.UTC(2013, 6, 14),
      x2: Date.UTC(2014, 10, 6),
      y: 15,
      extraInfo: '928',
      },

      {
      x: Date.UTC(2014, 10, 7),
      x2: Date.UTC(2025, 0, 5),
      y: 16,
      extraInfo: '18,400',
      },

      {
      x: Date.UTC(2019, 10, 28),
      x2: Date.UTC(2023, 3, 9),
      y: 17,
      extraInfo: '1,113',
      },

      {
      x: Date.UTC(2013, 6, 14),
      x2: Date.UTC(2014, 10, 6),
      y: 18,
      extraInfo: '4,825',
      },

      {
      x: Date.UTC(2013, 6, 14),
      x2: Date.UTC(2014, 10, 6),
      y: 19,
      extraInfo: '3,967',
      },

      {
      x: Date.UTC(2014, 10, 7),
      x2: Date.UTC(2025, 0, 5),
      y: 20,
      extraInfo: '65,212',
      },

      {
      x: Date.UTC(2019, 10, 28),
      x2: Date.UTC(2025, 0, 5),
      y: 21,
      extraInfo: '37,157',
      },

      {
      x: Date.UTC(2019, 3, 4),
      x2: Date.UTC(2019, 10, 27),
      y: 22,
      extraInfo: '5,104',
      },

      {
      x: Date.UTC(2013, 6, 14),
      x2: Date.UTC(2014, 10, 6),
      y: 23,
      extraInfo: '5,148',
      },

      {
      x: Date.UTC(2013, 6, 14),
      x2: Date.UTC(2014, 10, 6),
      y: 24,
      extraInfo: '4,430',
      },

      {
      x: Date.UTC(2018, 0, 8),
      x2: Date.UTC(2025, 0, 5),
      y: 25,
      extraInfo: '42,874',
      },

      {
      x: Date.UTC(2019, 3, 4),
      x2: Date.UTC(2019, 10, 27),
      y: 26,
      extraInfo: '4,959',
      },

      {
      x: Date.UTC(2024, 9, 8),
      x2: Date.UTC(2025, 0, 5),
      y: 27,
      extraInfo: '1,393',
      },

      {
      x: Date.UTC(2013, 6, 14),
      x2: Date.UTC(2025, 0, 5),
      y: 28,
      extraInfo: '69,816',
      },

      {
      x: Date.UTC(2013, 6, 14),
      x2: Date.UTC(2014, 4, 21),
      y: 29,
      extraInfo: '914',
      },

      {
      x: Date.UTC(2013, 6, 14),
      x2: Date.UTC(2014, 10, 6),
      y: 30,
      extraInfo: '4,242',
      },

      {
      x: Date.UTC(2013, 6, 14),
      x2: Date.UTC(2021, 10, 23),
      y: 31,
      extraInfo: '49,240',
      },

      {
      x: Date.UTC(2014, 4, 22),
      x2: Date.UTC(2025, 0, 5),
      y: 32,
      extraInfo: '60,393',
      },

      {
      x: Date.UTC(2022, 7, 13),
      x2: Date.UTC(2025, 0, 5),
      y: 33,
      extraInfo: '16,166',
      },

      {
      x: Date.UTC(2019, 3, 4),
      x2: Date.UTC(2025, 0, 5),
      y: 34,
      extraInfo: '39,743',
      },

      {
      x: Date.UTC(2018, 0, 8),
      x2: Date.UTC(2024, 9, 7),
      y: 35,
      extraInfo: '24,249',
      },

      {
      x: Date.UTC(2023, 3, 10),
      x2: Date.UTC(2025, 0, 5),
      y: 36,
      extraInfo: '6,386',
      },

      {
      x: Date.UTC(2024, 0, 1),
      x2: Date.UTC(2025, 0, 5),
      y: 37,
      extraInfo: '5,329',
      },

      {
      x: Date.UTC(2013, 6, 14),
      x2: Date.UTC(2022, 7, 12),
      y: 38,
      extraInfo: '42,694',
      },

      {
      x: Date.UTC(2017, 3, 16),
      x2: Date.UTC(2022, 7, 12),
      y: 39,
      extraInfo: '8,518',
      },

      ],

    dataLabels:
      {
      enabled: true
      }
    }]
  });
