<?php include ('includes/setAllPaths.inc');
include ($globalPath.'noCacheHeader.inc'); ?>
<title><?php include('includes/subsiteTitle.inc'); ?> - NPROVS Statistics</title>
<?php include($globalPath.'styleLinks.inc'); ?>
</head>
<body>
	<div id="wrap">
	<div class="outline">
	<?php include($globalPath.'headerNewStretchySearch.inc');	?>
		<div id="navContainer">
<?php include('includes/NavDiv.inc'); ?>
<!-- content inserted UNDER this comment and BEFORE the closing </div>
 below will appear below the nav panel inside the left-hand column -->
	</div>
	<div id="main">
	  <div class="mainInner">
		<?php include($globalPath.'noScriptWarning.inc'); ?>
		<?php // page content insertion can start after this comment. ?>



                <h1>NPROVS Statistic Plots</h1>

                <p>Collocated sounding data from NPROVS are used as input into routines that generate a
		variety of statistics that can be used to evaluate the performance of every collocated
		data platform. This is done by comparing temperature and moisture data from each platform
		to a baseline system, typically radiosondes and dropsondes. The resulting statistical data
		can be downloaded and viewed using graphical applications. They are also used to create
		the charts that are available from this page.
        	</p>


	        <div style="margin-top: 40px !important; clear: both;"><img src="images/NPROVS/nprovs_highcharts_level_stats.png"
        	   style="width: 500px; margin-left: 20px !important;" id="rgt"
        	   alt="NPROVS statistics - Sample image showing RMS temperature statistics">
        	</div>
		<br>

                <h2><a href="nprovs_longterm_trends.php">Long-Term Performance Trends</a></h2>

   	        <p>Long-term performance trend plots are available from the
		<b><a href="nprovs_longterm_trends.php">Long-Term Trends</a></b> page. Hovering over the
		blue menu bar just above the graph will allow for the selection of platform grouping,
		terrain, data type, statistic, and pressure level.
		</p>

		<p>To reduce the number of plots on each graph, the platforms are divided into groups:
		  <ul>
		    <li>NUCAPS IR + MW</li>
		    <li>NUCAPS MW only</li>
		    <li>AIRS and MIRS</li>
		    <li>Forecast/GPRSO:  ECMWF Analysis, HRRR Analysis and COSMIC-2</li>
		  </ul>
		</p>

		<p>The graphs have been separated into three terrain options: Sea only, Land only, and
		Land and Sea combined.
		</p>

		<p>Statistics are available for temperature and water vapor mixing ratio percent error.
		</p>

		<p>The available statistic options are bias (platform minus radiosonde), standard deviation,
		and root mean square.
		</p>

		<p>NPROVS typically generates statistics at 100 pre-defined pressure levels. A subset of
		the 100 levels are available.
		</p>

		<p>Although NPROVS is capable of generating statistics from 2008 to the present, the
		plots shown here show the most recent 5 year period. The plots show monthly statistical
		averages. They are usually updated during the first week of each month.</p>


<p> </p>

	        <div style="margin-top: 40px !important; clear: both;"><img src="images/NPROVS/nprovs_highcharts_heatmap.png"
        	   style="width: 500px; margin-left: 20px !important;" id="rgt"
        	   alt="NPROVS statistics - Sample image showing a heat map of temperature statistics">
        	</div>

		<br><br><br>

                <h2><a href="nprovs_heatmap.php">Statistical Heat Maps</a></h2>

                <p>Long-term performance trend plots showing statistics displayed as heat maps are
		available from the <b><a href="nprovs_heatmap.php">Heat Maps</a></b> page. Hovering
		over the blue menu bar just above the graph will allow for the selection of a specific
		platform profile, terrain, data type, and statistic.
		</p>

		<p>The NPROVS heat maps show long-term trends for a chosen profile at every pressure
		level over the most recent five year period. 
		</p>

		<p>The heat map plots have similar options as the performance trend plots do. In
		addition to selecting individual profiles, it is also possible to select terrain
		type, data type and statistic type.
		</p>



<div class="clearing"></div>
	  </div>
	  </div>
<?php include($globalPath.'footer.inc'); ?>
<!-- closing the two enclosing divs -->
		</div>
	</div>
</body>
</html>
