<?php include ('includes/setAllPaths.inc');
include ($globalPath.'noCacheHeader.inc'); ?>
<title><?php include('includes/subsiteTitle.inc'); ?> - NPROVS User Interface</title>
<?php include($globalPath.'styleLinks.inc'); ?>
</head>
<body>
	<div id="wrap">
		<div class="outline">
			<?php include($globalPath.'headerNewStretchySearch.inc');	?>
			<div id="navContainer">
				<?php include("includes/NavDiv.inc"); ?>
				<!-- content inserted UNDER this comment and BEFORE the closing </div>
				 below will appear below the nav panel inside the left-hand column -->
			</div>
	<div id="main">
	  <div class="mainInner">
		<?php include($globalPath.'noScriptWarning.inc'); ?>
		<h1><?php include('includes/subsiteTitle.inc'); ?> - NPROVS</h1>
		<?php // page content insertion can start after this comment.  ?>

<div><img src="images/ods/ods.png" 
    	  style="width: 500px; padding: 0 0 15px 15px" id="rgt"
	  alt="Orbital Display System (ODS)">
</div>
			
<h2>Download the program</h2>
  <p>Last Updated: <?php include($globalPath.'DateChanged.inc');?></p>

  <script type="text/javascript">
      function downloadApp(d) {
        window.location = 'https://www.star.nesdis.noaa.gov/smcd/opdb/nprovs/' + d;
      }
  </script>

 <p><a href="#" onClick="downloadApp('apps/ODS.jar');"; >Download ODS Version (7.23)</a> 
  Click on the link and then choose where to save the file, recommend in a folder.</p>

  <p><strong>*** NOTE: Beginning with version 7.18, it is necessary to include two external 
  libraries within a "lib" directory that is in the same directory as ODS.jar. If 
  these libraries are not present, ODS will create them and then display a dialog 
  box that will say that the program needs to be restarted. At that point, close 
  the dialog box and restart the program to resume normal operation.</p>
  </strong>
<p><a href="documents/ODS_Quick_Start.pdf" target="_blank">ODS Quick Start Guide</a></p>


<h2>Download the files</h2>
<p>The most recent 5 days of data for every system that is used by NPROVS are 
available via FTP. For any available file, click on the link and then choose where 
to save the file.</p>

<p><a href="https://www.star.nesdis.noaa.gov/pub/smcd/opdb/nprovs/ods/" target="_blank">Data Site 
for latest files</a></p>


<h2>ODS Overview</h2>

<p>The primary purpose of the NPROVS Orbital Display System (ODS) is to display images that show data from 
every satellite that is input into the NPROVS system. For each system, all parameters that are produced by
the system can be displayed. The images that are produced by ODS can be altered to display the data in a variety of ways. 
</p>

<p>The images produced by ODS are only a starting point. Using ODS, it is possible to dig deeper into the data. 
If the file from which the data are generated contains sounding profiles, then any location on the image can
be selected to view all temperature and moisture sounding profiles at the selected location. In addition to the
profiles, raw data, such as quality flags, that are associated with the selected location are displayed.
</p>

<p>The availability of sounding data also provides the ability to view vertical cross-sections of the atmosphere. 
Simply turn the cross-section option on and draw a line across an image to create a vertical cross-section of the
atmosphere along the line. The cross-section will contain data for all available temperature and moisture profiles.
</p>

<img_src="images/ods/ods_difference.png" alt="ODS Difference illustration">

<p>Yet another useful feature of ODS is the ability to compare data. Differencing can be applied to any two images. 
The resulting image will show the difference between each pixel in both images by subtracting the second image from 
the first image. The image above shows this feature. The difference image on the right shows the result of the
second image subtracted from the first. In this example, it is easy to see where the first image is warmer (red areas) 
and where the first image is colder (blue areas).</p>

<h2>Available Systems</h2>

<p>Data from many processing systems are currently available for downloading and viewing. The following is only a partial 
list of the available systems. Many of the following include data from multiple spacecraft and from operational and
test systems:</p>
<table>
<tr>
<td>
<ul>
  <li>NUCAPS</li>
  <li>NUCAPS Cloud Cleared Radiances (CCR)</li>
  <li>NOAA IASI</li>
  <li>EUMETSAT IASI</li>
  <li>MIRS</li>
  <li>AIRS</li>
  <li>ATOVS</li>
</ul>
</td>
<td>
<ul>
  <li>GOES</li>
  <li>COSMIC</li>
  <li>GRAS</li>
  <li>KOMPSAT 5</li>
  <li>ECMWF</li>
  <li>NCEP GFS Forecast</li>
  <li>Viirs Cloud EDR</li>
</ul>
</td></tr>
</table>

<h2>Installing and Running ODS</h2>

<p>ODS is a Java program. As such, it can be run on any system on which 
Java has been installed including Windows, Mac OS X, Linux and others. 
Installing the program is typically as simple as copying the ODS.jar 
file (linked above) to a folder on a local computer. The icon can then 
be double-clicked to run it.</p>

<p>More information about running ODS can be found in the ODS User's Guide and the 
<a href="documents/ODS_Quick_Start.pdf" target="_blank">ODS Quick Start Guide</a></p>

<?php // end of user created page content ?>
	  </div>
	  </div>
<?php include($globalPath.'footer.inc'); ?>
<!-- closing the two enclosing divs -->
	  </div>
	</div>
</body>
</html>
