<?php include ('includes/setAllPaths.inc');
include ($globalPath.'noCacheHeader.inc'); ?>
<title><?php include('includes/subsiteTitle.inc'); ?> - NPROVS User Interface</title>
<?php include($globalPath.'styleLinks.inc');  ?>
</head>
<body>
	<div id="wrap">
		<div class="outline">
			<?php include($globalPath.'headerNewStretchySearch.inc');	?>
			<div id="navContainer">
				<?php include("includes/NavDiv.inc"); ?>
				<!-- content inserted UNDER this comment and BEFORE the closing </div>
				 below will appear below the nav panel inside the left-hand column -->
			</div>
	<div id="main">
	  <div class="mainInner">
		<?php include($globalPath.'noScriptWarning.inc'); ?>
		<h1><?php include('includes/subsiteTitle.inc'); ?> - NPROVS</h1>
		<?php // page content insertion can start after this comment.  
			?>

<div class='fbContainer' style='float:right; padding:10px; width: 400px;'>
        <a href='images/pdisp/pdisp.png' title='PDISP Overview' class='fancybox'>
        <img src='images/pdisp/pdisp.png' alt='PDISP Overview '
        title='PDISP Overview - click to enlarge'
        style="float:right; padding:10px; margin: 0px; width: 400px;" ></a>
        <h4 title='click image to enlarge'>PDISP Overview - click to enlarge</h4>
</div>
<?php phpinfo() ?>
<h2>Download the program</h2>
<p>Last updated <?php include($globalPath.'DateChanged.inc');?>
  <script type="text/javascript">
      function downloadApp(d) {
        window.location = 'https://www.star.nesdis.noaa.gov/smcd/opdb/nprovs/' + d;
      }
  </script>

 <p><a href="#" onClick="downloadApp('apps/ProfileDisplay.jar');"; >Click here to download ProfileDisplay Version (6.69)</a> 
    
<p><strong>*** NOTE: Beginning with version 6.44, it is necessary to include two external libaries within 
     a "lib" directory that is in the same directory as ProfileDisplay.jar. 
	 If these libaries are not present, ProfileDisplay will create them and then display a dialog box 
	 that will say that the program needs to be restarted. 
	 At that point, close the dialog box and restart the program to resume normal operation.</p>
     </strong>
<p><a href="documents/ProfileDisplay_Quick_Start.pdf" target="_blank">ProfileDisplay Quick Start Guide</a></p>

<p><a href="documents/ProfileDisplay_Users_Guide.pdf" target="_blank">ProfileDisplay User's Guide</a></p>

<a id="download"></a>
<h2>Download the NPROVS Conventional files:</h2>
<p>There are 2 types of files generated from the NPROVS Conventional processing system: 
   <strong>Binary and NETCDF fomatted</strong>.  
   The latest version (6.69) of ProfileDisplay can only ingest the binary formatted files. 
   We are working on a new version of ProfileDisplay which is currently in beta testing, thus not avalable now.
</p>
<p>For the Binary files, we have combined weekly files available for downloading.  
   Due to data space limitations, we can only provide the 
   latest 5 years of weekly files.  If wish to download any files from 2008 to 2018, 
   please contact the project leader <a href="mailto:Tony.Reale&#064;noaa.gov">Tony.Reale&#064;noaa.gov</a> </p>
<p>Use the dropdown selections below for the <strong>Binary formatted</strong> weekly files:</p>
   <?php
       include('includes/DataFilePulldownListGen.inc');
   ?></p>
<p>We do provide access to the NETCDF formatted daily files for anyone interested in viewing the collocation date.
   Use the dropdown selections below for the <strong>NETCDF formatted</strong> daily files:</p>
   <?php
       include('includes/NetcdfDataFilePulldownListGen.inc');
   ?></p>
</p>

<h2>Download the NPROVS Special files:</h2>
<p>The NPROVS Special processing system also generatesi binary and NETCDF formatted daily files.
   ProfileDisplay can handle more than a week's worth of binary Special collocations because there are 
   significantly less radiosondes. 
   So we have generated yearly files (2013-present) including the latest year's worth.
</p>
<p>Use the dropdown selections for the <strong>Binary formatted</strong> weekly files:</p>
   <?php include('includes/SpecialDataFilePulldownListGen.inc');  ?>
</p>
<p>Below is dropdown selections for the <strong>NETCDF formatted</strong> daily files:</p>
<p>
   <?php
       include('includes/NetcdfSpecialDataFilePulldownListGen.inc');
   ?>
</p>

<h2>ProfileDisplay Overview</h2>

<p>The NPROVS ProfileDisplay (PDISP) program is used to view data from a variety of satellite and other processing systems that have all been collocated to a single baseline system (typically radiosondes). The input into ProfileDisplay is an NPROVS collocation file. The collocation file typcially contains one ore more days of collocations. Each collocation contains data from a baseline system, usually radiosondes, and data from other processing systems that are within distance and time limits.

     <div class='fbContainer' style='float:left; padding:10px; width: 250px;'>
        <a href='images/pdisp/profile_graph.png' title='PDISP Profile Graph panel' class='fancybox'>
        <img src='images/pdisp/profile_graph.png' alt='PDISP Profile Graph panel '
        title='PDISP Profile Graph panel - click to enlarge'
        style="margin: 0px; width: 250px;" id="lft"></a>
        <h4 title='click image to enlarge'>PDISP Profile Graph panel - click to enlarge</h4>
     </div>

<h2>Profile Graph</h2>
     <p>The profile graph is the heart of ProfileDisplay. Temperature (solid line) and moisture (dashed line) profiles
     are display on a graph that can be changed among several XY graph options and several Skew-T Log-P options.
     For any collocation, profiles from every system that has been collocated to the baseline system can be displayed.
     <p>Information is displayed about the closeness (time and distance) between each systems and the baseline system.
     <p>Arrow buttons on the lower right provide the ability to switch between collocations.
        <div class='fbContainer' style='float:right; padding:10px; width: 250px;'>
        <a href='images/pdisp/raw_data.png' title='PDISP Raw Data panel' class='fancybox'>
        <img src='images/pdisp/raw_data.png' alt='PDISP Raw Data panel '
        title='PDISP Raw Data panel - click to enlarge'
        style="margin: 0px; width: 250px;" id="rgt"></a>
        <h4 title='click image to enlarge'>PDISP Raw Data panel - click to enlarge</h4>
	<p> </p>
	<p> </p>
	<p> </p>
        </div>
 <h2>Raw Data</h2>
        <p>For every collocation, raw data from every collocated system can be displayed. All data that is
           produced by the system is shown as well as the raw data values from the temperature and moisture
           profiles.
        <p>The raw data also contains a table showing raw temperature and moisture data values for every 
           profile from every system at every pressure level.</TD>
<br>

        <div class='fbContainer' style='float:left; padding:10px; width: 250px;'>
        <a href='images/pdisp/vstat.png' title='PDISP Vertical Statistics' class='fancybox'>
        <img src='images/pdisp/vstat.png' alt='PDISP Vertical Statistics '
        title='PDISP Vertical Statistics - click to enlarge'
        style="margin: 0px; width: 250px;" id="rgt"></a>
        <h4 title='click image to enlarge'>PDISP Vertical Statistics - click to enlarge</h4>
        </div>
    <h2>Vertical Accuracy Statistics</h2>
        <p>Vertical accuracy statistics for temperature and moisture can be generated using all
           available collocations or a sub-selection of collocations. The resulting graph is capable
           of displaying bias, standard deviation, RMS, R-squared, mean, and the largest and smallest
           differences at every pressure level or layer. </TD>

<br>

        <div class='fbContainer' style='float:right; padding:10px; width: 250px;'>
        <a href='images/pdisp/scatter_plot.png' title='PDISP Scatter Plot panel' class='fancybox'>
        <img src='images/pdisp/scatter_plot.png' alt='PDISP Scatter Plot panel '
        title='PDISP Scatter Plot panel - click to enlarge'
        style="margin: 0px; width: 250px;" id="rgt"></a>
        <h4 title='click image to enlarge'>PDISP Scatter Plot panel - click to enlarge</h4>
        </div>
    <h2>Scatter Plot</h2>
        <p>Scatter plot diagrams can be generated at every pressure level or layer to show the 
           distributions of system minus baseline differences for every collocation and every 
           system. Outliers can be quickly identified to view potentially questionable data.
        <p>An additional feature of the scatter plot is the ability to compute and display a 
           best fit line for every system as well as the corresponded slopes and intercepts.</p>

<br>

        <div class='fbContainer' style='float:left; padding:10px; width: 250px;'>
        <a href='images/pdisp/subselection.png' title='PDISP Data Filtering panel' class='fancybox'>
        <img src='images/pdisp/subselection.png' alt='PDISP Data Filtering panel '
        title='PDISP Data Filtering panel - click to enlarge'
        style="margin: 0px; width: 250px;" id="rgt"></a>
        <h4 title='click image to enlarge'>PDISP Data Filtering panel - click to enlarge</h4>
        </div>
  <h2>Data Filtering</h2>
        <p>Data filtering is perhaps the most powerful feature of ProfileDisplay. By defaults, all
           collocations in a file are available for viewing and when generated vertical statistics
           and scatter plots. By applying data filtering, it is possible to create a subset of data
           to display and from which to generate statistics.</p>
        <p>Every system contains a unique set of filtering options. When combined, the filtering 
           options from all systems provides users with the ability to concentrate on a very specific
           set of data.</p>
<br><br>

<h2>Installing and Running ProfileDisplay</h2>

<p>ProfileDisplay is a Java program. As such, it can be run on any system on which Java 
has been installed including Windows, Mac OS X, Linux and others. Installing the program 
is typically as simple as copying the ProfileDisplay.jar file (linked above) to a folder 
on a local computer. The icon can then be double-clicked to run it.</p>

<p>More information about running PDISP can be found in the ProfileDisplay User's Guide 
and the <a href="documents/ProfileDisplay_Quick_Start.pdf" target="_blank">ProfileDisplay 
Quick Start Guide</a></p>

<br>

<?php // end of user created page content ?>
	  </div>
	  </div>
<?php include($globalPath.'footer.inc'); ?>
<!-- closing the two enclosing divs -->
	  </div>
	</div>
</body>
</html>
