#! /bin/csh -f
# This C-SHELL script is to compute the two morning times
# for differnt data processing or ET computation usage.
# 1. Read in the spatial domain and time (year, doy) information
# 2. Compute the morning times
# 3. Moved the output to the ALEXI input location

set work_dir = $SCRIPT_DIR
set out_dir = $OUT_DATA_DIR/ALEXI_MET


# Check if called properly with right command line inputs
 if ($#argv != 2) then
   echo "Usage: $0 [Year] [DOY]"
     goto done
 endif

## save command line args in variables
echo "Computing two morning times on day $1 $2"
set in_year=$1
set iday=$2

#Make 3 digits for the day of the year
  if ($iday < 10 ) then
    set in_doy=00$iday
  else if($iday < 100) then
    set in_doy=0$iday
  else
    set in_doy=$iday
  endif

set cur_out_dir = $out_dir/$in_year$in_doy

#Compute the time. 
    $BIN_DIR/getd.x -sunrise $SCRIPT_DIR/sunrise1km_global.cfg $in_year $in_doy

    if ( -e  $work_dir/rise15 && -e $work_dir/rise55) then
      if (! -d $cur_out_dir ) then
        echo Creating $cur_out_dir
        mkdir $cur_out_dir
      endif

      if ( -e $cur_out_dir/rise15 ) then
        rm -f $cur_out_dir/rise15
      endif

      if ( -e $cur_out_dir/rise55 ) then
        rm -f $cur_out_dir/rise55
      endif

      echo move data from $work_dir to $cur_out_dir
      mv -f $work_dir/rise15 $cur_out_dir/rise15
      mv -f $work_dir/rise55 $cur_out_dir/rise55

      mv -f $work_dir/dayflag15 $cur_out_dir/dayflag15
      mv -f $work_dir/dayflag55 $cur_out_dir/dayflag55

      mv -f $work_dir/rise15MET $cur_out_dir/rise15MET
      mv -f $work_dir/rise55MET $cur_out_dir/rise55MET

    else
      echo Cannot generate sun rise file.
      goto error
    endif
done:
  exit 0
error:
  exit 1
