;This program returns MIDTIME to main program for each pixel after duplicating using scan level values. 
;It was found that maybe using start and end time in filename works better without any hassle and that already takes in to account of leap seconds. 
;So new program is written that uses start and end time instead of midtime.

;updated to handle all profile data instead. Also filter out sza<0.


;@read_IMOPO.pro
;@read_OONPO.pro
;@read_GONPO.pro
@ymd2dn.pro
@ncreadvari_v8pro_dn.pro

PRO get_valid_ozone_params_NP_aday_ncdf, slat, slon, time, sza, toz, totozpixels, year, doy, pixtime, ozfile, path, ozcode, ozprofile_all_v8

	;path='/net/orbit226l/disk1/pub/suprety/NP_IMOPO/'


;	openr, 1, path + 'GONPO.txt'
        openr, 1, path + 'V8PRO.txt'

	geo_filename='' ;continue using geo_filename for V8PRO files
	filecnt=0

	slat= fltarr(1000000)
	slon= fltarr(1000000)
	time= Lon64arr(1000000)
	sza= fltarr(1000000)
	toz= fltarr(1000000)
	refl= fltarr(1000000)
	ozcode= bytarr(1000000)
	pixtime= fltarr(1000000)
	datacnt=0
	ozfile= strarr(1000000)
	ozprofile_all=fltarr(12, 10000)
        ozprofile_all_v8=fltarr(21, 10000)

  WHILE NOT EOF(1) do begin							;Complete work for 1 DAY*************

	;IF filecnt EQ 10 then BREAK		;Remove later. Just for quick test purpose

	readf, 1, geo_filename
	print, ' Processing file no:', filecnt+1, '   ', geo_filename

	;----------------------------------- Avoid 1st data in SCDR file which contain data from previous day ---------
	p=strpos(geo_filename, 'j01_s')
	day=strmid(geo_filename, p+5+6, 2)
	month=strmid(geo_filename, p+5+4, 2)
	tmpyear=strmid(geo_filename, p+5, 4)
	tmpjdoy= ymd2dn(tmpyear, month, day)

;;	IF tmpyear NE year OR tmpjdoy NE doy THEN CONTINUE
	;---------------------------------------------------------------------------------------------------------------


	time_stamp=strmid(geo_filename, p+5, 26)		;TO find matching INCTO_filename

	;----------Find matching INCTo for selected Geo.
;	oz_filename= find_matching_oz_file(geo_filename)		;matching IMOPO/OONPO file found for given geo. Now 
; No need to match GEO and EDR. V8 contains everything.
        oz_filename=geo_filename

;;	IF strlen(oz_filename) LE 20 then BEGIN					;Sometimes oz_filename length=8 and its still invalid. So using 20 makes safer consider as still invalid
;;	   openw, 3, 'NO_matching_oz_file_for_these_Geo_files.txt', /APPEND	;writes those Geo filenames into a text file with no matching oz file. ****LOG FILE***
;;	   printf, 3, geo_filename
;;	   close, 3
;;
;;	   CONTINUE		;NO oz file found for given Geo file. Hence just continue with next Geo file.
;;	ENDIF

	;--- Read Geo and oz files
;	read_GONPO, geo_filename, tmpslat, tmpslon, tmptime, tmpsza		;time=midtime (in microseconds since 01/01/1958)
;	read_IMOPO, oz_filename, tmptoz, tmpozcode, ozprofile				;tmpozcode=tmpOzErFlagForProfile
;       read_OONPO, oz_filename, tmptoz, tmpozcode, ozprofile
; Need one read for V8PRO
        ncreadvari_v8pro_dn, oz_filename, oz
; equate oz structure to variables program needs
        tmpslat = oz.latitude
        tmpslon = oz.longitude
        tmptime = oz.midtime
        tmpsza = oz.solarzenithangle
;        tmptoz = oz.columnamounto3_to3  ; total column
        tmptoz = oz.columnamounto3_profile ; total profile amount
        tmpozcode = oz.errorcode_profile
        ozprofile = oz.o3final  ; profile ozone (21 layers)
; end assignment of v8 struture variables

	num=n_elements(tmpslat)
	numtime=n_elements(tmptime)

	;----------Filter the band data. Increase speed by saving time and memory for processing
; commented out for test of 1st column only below:
	tmpslat= reform(tmpslat, n_elements(tmpslat))
	tmpslon= reform(tmpslon, n_elements(tmpslon))
	tmptime= reform(tmptime(*))
	tmpsza= reform(tmpsza, n_elements(tmpsza))
	tmptoz= reform(tmptoz, n_elements(tmptoz))
;	;tmprefl= reform(tmprefl, n_elements(tmprefl))
	tmpozcode= reform(tmpozcode, n_elements(tmpozcode))
;	tmpozprof=reform(ozprofile, n_elements(ozprofile))
        tmpozprof=reform(ozprofile, 21,25)
;        tmpoz_prof = ozprofile(*,0,*)

; try using only 1st column of data since other colums are -9999.0
; took out to use all data instead of 1st column
;        tmpslat= oz.latitude(0,*) 
;        tmpslat=mean(tmpslat)
;        tmpslon= oz.longitude(0,*)
;        tmpsloz=mean(tmpslon)
;        tmpstime= oz.midtime(0,*)
;        tmpstime=mean(tmpstime)
;        tmpsza= oz.solarzenithangle(0,*)
;        tmpsza=mean(tmpsza)
;        tmptoz= oz.columnamounto3_profile(0,*)
;        tmptoz=mean(tmptoz)
;        tmpozcode= oz.errorcode_profile(0,*)
;        tmpozcode=mean(tmpozcode)
;        tmpozprof= oz.o3final(*,0,*)

;        test_tmpozprof=reform(tmpozprof)
;        prof_mean=mean(test_tmpozprof,dimension=2)
 ;       tmpozprof= prof_mean
;        tmpozprof=test_tmpozprof

;stop
	;************ Filtration based on 1. ozcode and 2. SZA (Make sure with Eric/Larry that use only these few.) These are chosen based on old program
	;CHECK!	;Do we want more QF based filtration such as snow, ice, SAA, reflectivity, aerosols and more?

       ;data. 0: Ozone quality GOOD & 2: SO2 index too high (will be corrected in future)	;This info copied from old program "OMPSNM_overpass3_incto_test3_nointerpolation_test_time2.pro"
;	w=where (((tmpozcode eq 0.0) OR (tmpozcode eq 2.0)) AND (tmptoz ge 0) AND (tmptoz lt 700) AND (tmpsza LT 80.0) AND min(ozprofile) GT 0.0, ct)
;        w=where (((tmpozcode(0) eq 0.0) OR (tmpozcode(0) eq 2.0)) AND (tmptoz(0) ge 0) AND (tmptoz(0) lt 700) AND (tmpsza(0) LT 80.0) AND min(ozprofile(*,0,*)) GT 0.0, ct)
;
;************************
;eb-4/25/2019: Profile Error code 3 (tmpozcode) is common since about 8/2/2018
; and data is getting filtered out. Thus output file contains zero values
; after this date. This will be fixed in a future V8PRO delivery.
;
;
;        w=where (((tmpozcode eq 0.0) OR (tmpozcode eq 2.0)) AND (tmptoz ge 0) AND (tmptoz lt 700) AND (tmpsza LT 80.0) AND min(ozprofile(*,0,0)) GT 0.0, ct)

; test whether all profiles can be used
       w=where (((tmpozcode eq 0.0) OR (tmpozcode eq 2.0)) AND (tmptoz ge 0) AND (tmptoz lt 700) AND (tmpsza GE 0) AND (tmpsza LT 80.0) AND (tmptime ne -9999.0) AND (tmpozprof) GE 0.0, ct)

; put filtered ozprof into new variable
       tmpozprof1=tmpozprof(*,w)

;stop  ;  The statement above is not returning valid values so w>= 0

	IF ct EQ 0 then begin
		print, '!!!!No valid OZONE data found for this file!!!! Start checking for next file!'
		filecnt=filecnt+1

		CONTINUE	;For some files there are no valid data at all such as 
	ENDIF

	print, 'Total valid_ozone counts: ', ct
;stop
;stopped working 1/20 at this line
;
	;**********************************************************

	;---Copy valid data from each file into large array variables for aday
	slat(datacnt: datacnt+ct-1)= tmpslat(w)
	slon(datacnt: datacnt+ct-1)= tmpslon(w)
	time(datacnt: datacnt+ct-1)= tmptime(w)
	sza(datacnt: datacnt+ct-1)= tmpsza(w)
	toz(datacnt: datacnt+ct-1)= tmptoz(w)
	;refl(datacnt: datacnt+ct-1)= tmprefl(w)
	ozcode(datacnt: datacnt+ct-1)= tmpozcode(w)
	ozfile(datacnt: datacnt+ct-1)= oz_filename
;	ozprofile_all_v8(*, datacnt)=  tmpozprof
;        ozprofile_all_v8(*, datacnt)= ozprofile(*,0,0)
; test whether prog can handle all profile data
        ozprofile_all_v8(*, datacnt:datacnt+ct-1)= tmpozprof1(*,w)
; cont from here:
;      for k=0,20 do begin
;        for i=0,4 do begin
;          for j=0,4 do begin
;            ozprofile(
           
	;======================================= Seconds of the given day 
	;*******2. Start and end time based pixel time (Simpler than above and accuracy within few seconds)

	sthh= strmid(geo_filename, p+5+10, 2)
	stmm= strmid(geo_filename, p+5+12, 2)
	stss= strmid(geo_filename, p+5+14, 3)/10.0
	sttime=sthh*60.*60 + stmm*60. + stss

	enhh= strmid(geo_filename, p+5+19, 2)
	enmm= strmid(geo_filename, p+5+21, 2)
	enss= strmid(geo_filename, p+5+23, 3)/10.0
	entime=enhh*60.*60 + enmm*60. + enss

	num_of_pixels=1
	pixtime_interval=(entime-sttime)/2		;Assign center time since only 1 pixel per file. num_of_pixels replaces num in INCTO. Here is only 1 pixel. So just give the cente rtime for pixel. There are just fill in values. Don't divide time stamp for fill in values as in INCTO.
	;tmppixtime=findgen(num) * pixtime_interval + sttime
	tmppixtime=pixtime_interval + sttime

	pixtime(datacnt: datacnt+ct-1)= tmppixtime(w)
	;*****************************************************

	datacnt=datacnt + ct
	filecnt=filecnt+1
	totozpixels=datacnt+ct

ENDWHILE
CLOSE, 1

	slat=reform(slat(0:datacnt-1))
	slon=reform(slon(0:datacnt-1))
	time=reform(time(0:datacnt-1))
	sza=reform(sza(0:datacnt-1))
	toz=reform(toz(0:datacnt-1))
	;refl=reform(refl(0:datacnt-1))
	ozcode=reform(ozcode(0:datacnt-1))

	pixtime=reform(pixtime(0:datacnt-1))

;	ozprofile_all=reform(ozprofile_all(*, 0:datacnt-1))

        ozprofile_all_v8=reform(ozprofile_all_v8(*, 0:datacnt-1))
; test for using all profiles
;        ozprofile_all_v8=reform(ozprofile_all_v8(*, 0:datacnt-1, 0:datacnt-1))

	totozpixels= datacnt
; stop
END
