;After copying this program to any other directory, please change the path in line 47!!!!!!!! VERY IMPORTANT. This is all you need to do. If any problem persists, please contact sirish.uprety@noaa.gov OR eric.beach@noaa.gov
; 10/13/15 EB - changed path location

; Be sure to update leap second code below when a new leap second occurs
;==================================================================================================================================================================================================================================
;Note:
;a) Filtration criteria:
;	1. Solar zenith threshold: 80 degrees
;	2. Total ozone: 0 to 700
;	3. Ozone profile: at least greater than 0
;	4. (tmpozcode eq 0.0) OR (tmpozcode eq 2.0)
;
;b) Ozone values: FinalO3Profile
;c) If a single orbit exists to be good and rest of the orbits for a day are bad or missing, it still uses that orbit to record if some stations are closeby
;d) In addition to weighted ozone params, it also stores closest distance ozone parameters.
;e) IT uses STAR backed up data (backed up data from Gravite => scdr => STAR server)
;
;While porting the program from one system to another following changes are recommended for this program to work without any error message:
;1. Change path in line 41. Put the path same as where this program resides.
;
; Run main.pro in IDL manually if script dies during year changover.
;
;eb-Updated 3/23/17 to start using OONPO instead of IMOPO which switch on 3/8/17.
;eb-This version was adapted to run on the reprocessed V8PRO files that Zhihua
; reprocessed in Spring-Summer 2017.
;eb-updated to run on N20 V8PRO files 6/2020
;eb-updated to use the full output ozprofile_v8_all array size instead of 
; just 1st value.
;
;8/17/23 -ran for entire record of operational data from 1/17/18- 8/17/23
; various versions conatined in the record (v3r0 - v3r3)
;=============================================================================================


@calc_start_end_time.pro
@convert_month_str_to_int.pro
@check_day_if_already_processed.pro
@ymd2dn.pro
@leapyr.pro
;@read_GOTCO.pro
;@read_INCTO.pro
;@get_valid_ozone_params_NP_aday.pro
@get_valid_ozone_params_NP_aday_ncdf.pro
current_time=systime()			;Tue Jan  7 10:59:39 2014
yr=strmid(current_time, 20, 24)
convert_month_str_to_int, strmid(current_time, 4, 3), month
day=strmid(current_time, 8, 2)

;ran on 4/19/2019 on N20 V8PRO data so set to 420 to reach back to 1/17/2018
;ran on 6/18/2020 on N20 V8PRO so set to 856 (feb 11, 2018)
;interval=1151  ; to get to 1/17/2018 from 3/12/2021
;interval=1550  ; to get to 1/17/2018 from 4/13/2022
;testing, run a few days ago
;run for entire record of ops data (1/17/2018 v3r0 - current v4r1)
;interval=2040 ;(from 8/17/23 back to 1/17/2018)
interval=4 
; re-run NP to recreate July 2024 due to missed data
;interval=2400
doy=0.0

st_yr=0.0
st_day=0.0
end_day1=0.0
end_yr=0.0
st_day2=0.0
end_day2=0.0


;path='/net/orbit226l/disk1/pub/suprety/NP_IMOPO/Overpass_using_distance_weighted_STAR_backup_data/'			;CHANGE!!!!!!!!!!!!!!!!!!!
;path='/data/data074/users/beach/dobson_overpass/NPP/NP_IMOPO/Overpass_using_distance_weighted_STAR_backup_data/'
path='/data/smcd9/ebeach/dobson_overpass/N20/V8PRO_NDE_test2/'

result_path_distweigh=path + 'RESULTS_dist_weighted/'
result_path_distweigh_closestdist=path + 'RESULTS_dist_weighted_and_closest_dist/'



;-------------------
resultdir=''
resultdir = FILE_SEARCH(path + 'RESULTS_dist_weighted')
IF strlen(resultdir) LE 0 then begin
	file_mkdir, path + 'RESULTS_dist_weighted'		;If results directory doesn't exist then just create one.
ENDIF

resultdir=''
resultdir = FILE_SEARCH(path + 'RESULTS_dist_weighted_and_closest_dist')
IF strlen(resultdir) LE 0 then begin
	file_mkdir, path + 'RESULTS_dist_weighted_and_closest_dist'		;If results directory doesn't exist then just create one.
ENDIF
;-------------------



calc_start_end_time, float(yr), float(month), float(day), st_yr, st_day1, end_day1, end_yr, st_day2, end_day2, interval		;works correct only if interval <= 365*2


 for year=st_yr, end_yr do begin				;YEAR LOOP************

   st_doy=st_day1
   end_doy=end_day1

  if st_yr NE end_yr then begin
   if year EQ st_yr then st_doy=st_day1
   if year EQ st_yr then end_doy=end_day1

   if year EQ end_yr then st_doy=st_day2
   if year EQ end_yr then end_doy=end_day2

   if (year NE end_yr) AND (year NE st_yr) then st_doy=1
   if (year NE end_yr) AND (year NE st_yr) then end_doy=365 + leapyr(year)
  endif


   doy=st_doy
   doy_cnt=0

print, ''
print, st_doy, end_doy
print, ''

;STOP

  while doy LE end_doy do begin			;----------Process for each day for recent 90 days------		;DOY LOOP**************

   ;refdoy=doy
   ;IF doy EQ 74 then STOP		;REMOVE LATER

   CALDAT, JULDAY(1, doy, year), month, day			

	str_yr=strtrim(uint(year), 1)
	str_day=strtrim(uint(day), 1)
	str_month=strtrim(uint(month), 1)
	if day LE 9 then str_day='0' +strtrim(uint(day), 1)
	if month LE 9 then str_month='0' +strtrim(uint(month), 1)

	tmpdate= str_month+ '/' + str_day + '/' + str_yr		;Prints date

	print, '******************* PROCESSING ******************' + strtrim(uint(month), 1) + '/' + strtrim(uint(day), 1) + '/' + strtrim(uint(year), 1)

	print, 'Processing DOY: ', doy

;STOP

	check= check_day_if_already_processed(doy, year, result_path_distweigh_closestdist, yesorno)
	;yesORno=0	;(FOR DUPLICATE CHECK, PLEASE COMMENT THIS))
	IF yesORno EQ 1 then begin							;print, 'Don't process this day SINCE this day is already processed earlier!!!!'
		print, 'Do not process this day SINCE this day is already processed earlier (Avoids duplicate day processing)!!!!'
		print, ''
		doy=doy+1		
		CONTINUE
	ENDIF


	;*************************** Read 1 day INCTO and GOTCO data *****************
	;;--------- NOT USED. Uses data already backed up in server. This section works
	;;=================================== Port program from /net/orbit226l/disk1/pub/suprety/NM_INCTO/OMPSNM_overpass3_incto_test3_nointerpolation_test_time2.pro ====================
	;tmpdate=str_month + '/' + str_day + '/' + str_yr
	;openw, 11, 'VIIRS_processing_day_pick.txt'
	;printf,  11, tmpdate
	;close, 11

	;;-----Use shell script to download VIIRS filenames------		;scdr-files --type INCTO 20150501 >>INCTO.txt
	;spawn, 'chmod 775 tmp2.sh'
	;spawn, './tmp2.sh'
	;;-------------------------------------------------------

	;;---Check if there are valid files for this day. If no file exists, just continue with the next day.
	;file_info= file_info('GONPO.txt')
	;IF file_info.size LE 0 then begin
	;   doy=doy+1
	;   CONTINUE
	;ENDIF
	;;----------------------------------------

	;------------This section reads NM (incto/gotco) data from the backed up files unlike the direct scdr read as above ------------
	 yyyy=strtrim(string(year,format='(i4)'),2)
        mm=strtrim(string(month,format='(i2.2)'),2)
        dd=strtrim(string(day,format='(i2.2)'),2)
	 curdate=yyyy+'/'+mm+'/'+dd
	
;        dir='/data/data074/NPP/OMPS/DATA/NP/'+curdate+'/IMOPO'
;        cmd='find '+dir+' -name "IMOPO_npp*"'
;        spawn,cmd,imopo
 ;       dir='/data/data074/NPP/OMPS/DATA/NP/'+curdate+'/OONPO'
;        cmd='find '+dir+' -name "OONPO_npp*"'
;        spawn,cmd,oonpo
;  use for operational NDE data
        dir='/data/data446/N20/OMPS/DATA/NP/'+curdate+'/V8PRO_OP'
        cmd='find '+dir+' -name "V8PRO-EDR_v*_j01_*.nc"'
        spawn,cmd,V8PRO_OP

;  no need for GONPO when using V8 data
;        dir='/data/data446/N20/OMPS/DATA/NP/'+curdate+'/GONPO/'
;        cmd='find '+dir+' -name "GONPO_j01*"'
;        spawn,cmd,gonpo

;	s1=size(oonpo, /dimensions)
        s1=size(V8PRO_OP, /dimensions)
;        s1=size(V8PRO_REP, /dimensions)  ; for reprocessed data
;	s2=size(gonpo, /dimensions)

;	if s1 LE 1 OR s2 LE 1 then begin
        if s1 le 1 then begin
		print,"NO file"
		doy=doy+1
		CONTINUE					;Continue WHILE doy loop and continue with the next day!!!
	endif

;	s=size(oonpo, /dimensions)
;	openw, 11, 'OONPO.txt'
        s=size(V8PRO_OP, /dimensions)
;        s=size(V8PRO_REP, /dimensions) ; use V8PRO_REP for reprocessed data
        openw, 11, 'V8PRO.txt'
;	FOR i=0, s(0)-1 do begin
;	   printf, 11, oonpo(i)
;	ENDFOR
        FOR i=0, s(0)-1 do begin ; normal loop for files
          printf, 11, V8PRO_OP(i) 
;           printf, 11, V8PRO_REP(i) ; V8PRO_REP for reprocessed
        ENDFOR
	CLOSE, 11

; not needed for V8
;	s=size(gonpo, /dimensions)
;	openw, 11, 'GONPO.txt'
;	FOR i=0, s(0)-1 do begin
;	   printf, 11, gonpo(i)
;	ENDFOR
;	CLOSE, 11
	;----------------------------------------------------------------
	;***************************************************************************

;stop

	;----- Read all ozone params for the given day. Note that data is already filtered out to save memory and improve the run time.
;	get_valid_ozone_params_NP_aday, slat, slon, midtime, sza, toz, totozpixels, year, doy, pixtime, ozfile, path, ozcode, ozprofile_all			;IMOPO
        get_valid_ozone_params_NP_aday_ncdf, slat, slon, midtime, sza, toz, totozpixels, year, doy, pixtime, ozfile, path, ozcode, ozprofile_all

        profcnt_size=size(ozprofile_all, /dimensions)
        profcnt=profcnt_size(0)         ;Total number of profiles. 12 previously and 21 with Ver8.

	IF totozpixels LE 5 then begin	;In this day, total valid pixels from all granules is just 5, something problem with datasets. So, just jump to next day.
	   doy= doy + 1
	   CONTINUE
	ENDIF

	jday=doy
	jdate=string(year,format='(i4)')+string(jday(0),format='(i3.3)')

; to avoid producing overpass past 9/20/17 (last reprocessed data available)
;        if (long(jdate) ge 2017263) then continue
;

	;****************** Two techniques are used in generating time stamp for each pixel 	1.Midtime based	2.start and end time based ***********

	;---------- large floating point numbers are not correctly giving output in line 137 above. ---- Just quickly changed the code in string to handle this. (not efficient, change later)
	;=========================================================================
	tmptime1= string(midtime)
	tmptime1= strmid(tmptime1, strlen(tmptime1(0))-6-9, 9)		;1804000297253625 changes to 804000297 neglect after decimal and 1st digit			6:from microsec to sec. 5: 86400 used, so 5 digits should be enough to handle this.

	time_new1= string(midtime)
	time_new1= double(time_new1* 10.^(-6))/86400.			;1804000297253625 changes to 20789.xxxxxx
	time_new1= string(double(uint(time_new1)*86400.), format='(i20)');20879 * 86400  gives 1803945600
	time_new1= strmid(time_new1, strlen(time_new1(0))-9, strlen(time_new1(0)))	; 1803945600 changes to 803945600 removing 1st digit
	time_new1= double(tmptime1) - double(time_new1)									;Contains the residual seconds for a day

	indx=where(time_new1 LE 100, c2)			;For negative, this works good!
	IF c2 GT 0 AND max(time_new1) GE 86000. then time_new1(indx)=time_new1(indx)+86400.		;Time_new1 can be larger than 86400 BEACAUSE it needs to take into account the LEAP SECONDS. MIDTIME doesn't care leap seconds. However the start and end time in filename has leap seconds already accounted!

	;-------convert time to sec of day. subtract 34 leap seconds from TAI time to get UTC time (Sirish updated for float)
       ;new leap second on 7/1/2012. USNO website (leapsec.dat)
	if (long(jdate) ge 2012182) then time_new1= time_new1 - 35
	;new leap second on 7/1/2015. USNO website 
	if (long(jdate) ge 2015182) then time_new1= time_new1 - 36			;Contains the residual seconds for a day
        if (long(jdate) ge 2017001) then time_new1= time_new1 - 37
	;=========================================================================	


	;*******2. Start and end time based pixel time (Simpler than above and accuracy within few seconds)
	;"pixtime" returned by "get_valid_ozone_params_aday.pro" in line 119 contains pixel time for each valid pixel based on start and end time.
	time_new2=pixtime


	;I am choosing pixtime as the time stamp. You can either choose based on midtime or based on pixtime (start-end time).
	;time_new= time_new2	OR time_new=time_new1	;either pixtime (based on start and end time of data acquire in filename) or midtime
	time_new= time_new2
	time= time_new2

; switched back to midtime for V8PRO
        time_new= time_new1
        time= time_new1

;stop
	;::::::::::::::::::::: STATION READ AND EXTRACT OZNONE ::::::::::::::::::::::::::
	newslat=0.0 & newslon=0.0 & newtoz=0.0 &newtime=0.0 &newsza=0.0 &newprof=fltarr(profcnt,1)

  
    ; Determine orbit ending indices
    st       = shift(time_new,1)        
    dt       = abs(st-time_new)
;    orbitend = where (dt gt 3130)  ;time jumps btwn orbits usually 3132 seconds
;
; Sirish inserted below code 1/11/2016 to fix missing data issues
    indx = where (dt gt 3130, ct)  ;time jumps between orbits usually 3132 seconds

     orbitend=indx
     s= size(slat, /dimensions)
      IF max(indx) LT s(0)-1 then begin
        orbitend= intarr(ct+1)
        orbitend(0:ct-1)= indx
        orbitend(ct)= s(0)-1
      ENDIF
;end new code

    ; If only one orbit of data present
    IF (n_elements(orbitend) le 1)  AND abs(max(slat) - min(slat)) GE 2.0 THEN begin 			;1-ORBIT
        n=0   
        ozone=toz
        tlat=slat
        tlon=slon
        tsza=sza
        ttime=time
	 tprof= ozprofile_all

        ; Check for date line breaks
        w       = where(tlon lt 0, ct)
        IF ct GE 1 then tlon(w) = tlon(w)+360       ; Change to 0-360 degrees longitude

        ; Define interpolation points-every half degree
        num     = max(tlat)-min(tlat)               ; # of degrees in orbit
        num     = round(num)*2.
        reflat  = findgen(num)/2.                   ; Reference latitude array
        m       = round(min(tlat))
        reflat  = reflat+float(m)                   ; From max to min
        intoz   = interpol(ozone,tlat,reflat)       ; Interpolated ozone
        intlon  = interpol(tlon,tlat,reflat)
        inttime = interpol(ttime,tlat,reflat)
        intsza  = interpol(tsza,tlat,reflat)

;        intprof=fltarr(12,n_elements(reflat))
        intprof=fltarr(profcnt,n_elements(reflat))              ;change. profcnt=12 or 21

          for nn=0,profcnt-1 do begin
             w=where (tprof(nn,*) gt 0)                         
             if (w(0) ge 0) then begin
              intprof(nn,*)=interpol(tprof(nn,w),tlat(w),reflat)
             endif
          endfor

        w= where(tlon gt 180, ct)
        IF ct GE 1 then tlon(w)   = tlon(w)-360                 ; Change back to -180 to 180
        w= where(intlon gt 180, ct)
        IF ct GE 1 then intlon(w) = intlon(w)-360               ; Change back to -180 to 180
        
        newslat = [newslat,reflat]
        newslon = [newslon,intlon]
        newtoz  = [newtoz,intoz]  
        newsza  = [newsza,intsza]
        newtime = [newtime,inttime]

       xprof=fltarr(profcnt,n_elements(newprof(3,*))+n_elements(intprof(3,*)))
           for n=0,profcnt-1 do begin
            xprof(n,*)=[reform(newprof(n,*)),reform(intprof(n,*))]
            endfor
          newprof=xprof
     ENDIF


    ;Multiple orbits... Since orbitend returns 16 orbits instead of 15, n goes from 0 to ..-2! Note 1st value is 0 so look slike 16 orbits but its actually only 15 orbit!
    FOR n=0., n_elements(orbitend)-2 DO begin

	 ozone = toz(orbitend(n):orbitend(n+1)-1)
        tlat  = slat(orbitend(n):orbitend(n+1)-1)
        tlon  = slon(orbitend(n):orbitend(n+1)-1)
        tsza  = sza(orbitend(n):orbitend(n+1)-1)
        ttime = time(orbitend(n):orbitend(n+1)-1)
        tprof = ozprofile_all(*,orbitend(n):orbitend(n+1)-1)

       if (n_elements(tlat) lt 20) then begin      ; If too few points to interpolate
            newslat = [newslat,tlat]
            newslon = [newslon,tlon]
            newtoz  = [newtoz,ozone]
            newsza  = [newsza,tsza]
            newtime = [newtime,ttime]

        ;    xprof=fltarr(12,n_elements(newprof(3,*))+n_elements(tprof(3,*)))
           xprof=fltarr(profcnt,n_elements(newprof(3,*))+n_elements(tprof(3,*)))
            for nn=0,profcnt-1 do begin
              xprof(nn,*)=[reform(newprof(nn,*)),reform(tprof(nn,*))]			;Sirish comment: 12 or 21 profile values!
            endfor
            newprof=xprof
	     CONTINUE
	endif


        ; Check for date line breaks
            w       = where (tlon lt 0, ct)
            IF ct GE 1 then tlon(w) = tlon(w)+360                   ; Change to 0-360 degrees longitude


        ; Define interpolation points-every half degree
        num    = max(tlat)-min(tlat)                ; # of degrees in orbit
        num    = round(num)*2.
        reflat = findgen(num)/2.                    ; Reference latitude array
        m      = round(min(tlat))
        reflat = reflat+float(m)+.5                 ; From max to min

        if (max(tlat) gt max(reflat)+.5) then begin ; Add endpoints
            reflat=[reflat,max(reflat)+.5]
        endif

        intoz   = interpol(ozone,tlat,reflat)       ; Interpolated ozone
        intlon  = interpol(tlon,tlat,reflat)
        inttime = interpol(ttime,tlat,reflat)
        intsza  = interpol(tsza,tlat,reflat)
	 ;intlat is reflat!
;        intprof=fltarr(12,n_elements(reflat))
        intprof=fltarr(profcnt,n_elements(reflat))
         for nn=0,profcnt-1 do begin
           w=where (tprof(nn,*) gt 0)                         ;remove -77's 
          if (w(0) ge 0) then begin
           intprof(nn,*)=interpol(tprof(nn,w),tlat(w),reflat)
          endif
         endfor

        ; Check for date line breaks
        if (max(tlon) gt 180) then begin
            w       = where(tlon gt 180)
            tlon(w) = tlon(w)-360                   ; Change back to -180 to 180
            w       = where(intlon gt 180)
            if (w(0) ge 0) then begin
                intlon(w)=intlon(w)-360             ; Change back to -180 to 180
            endif
        endif

        newslat = [newslat,reflat]                  ; Concatenate latitudes
        newslon = [newslon,intlon]
        newtoz  = [newtoz,intoz]
        newsza  = [newsza,intsza]
        newtime = [newtime,inttime]

;        xprof=fltarr(12,n_elements(newprof(3,*))+n_elements(intprof(3,*)))
;         for nn=0,11 do begin
        xprof=fltarr(profcnt,n_elements(newprof(3,*))+n_elements(intprof(3,*)))
         for nn=0,profcnt-1 do begin
           xprof(nn,*)=[reform(newprof(nn,*)),reform(intprof(nn,*))]         ;concat profiles
         endfor
        newprof=xprof

	;print, min(newtoz), max(newtoz), min(newsza), max(newsza)
	;read, a
	;IF a EQ 1 then STOP
    ENDFOR


    newslat   = newslat(1:*)
    newslon   = newslon(1:*)
    newtoz    = newtoz(1:*)
    newsza    = newsza(1:*)
    newtime   = newtime(1:*)
    newprof   = newprof(*,1:*)




	;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
	
	;********************* For each station, find if there exists overpass nearby. If so, collect the data and store based on station text file specific
	openr,3, path + 'platform_e_woudc_neubrew.txt'
	head=''
	readf, 3, head
	while NOT EOF (3) do begin									;LOOP for each station!!. Eric has updated by adding some new stations!!
	       ; Adding to read in entire station list from WOUDC (platform_e_nvu.txt)
		readf, 3, sta,staminlat,stamaxlat,staminlon,stamaxlon,staminhgt,stamaxhgt

       	; Find avg lat, lon, height for each station
       	stalat=(staminlat + stamaxlat) / 2
       	stalon=(staminlon + stamaxlon) / 2
       	stahgt=(staminhgt + stamaxhgt) / 2

		;IF sta EQ 34 then STOP	;sanity check
		;CONTINUE FROM HERE--------------------------



	;-------------------------------------------------------------
		; This box applies to NP
       	w=where(abs(stalat-newslat) LE 2.0 and abs(stalon-newslon) LE 10.0, nws)		;box pf +/-10 degree for NP
		print, 'Number of valid pixels at Station', sta, ':', nws

		IF nws GE 1 then begin
		   radius=6370.0  ;radius of the earth
		   latdist=abs((newslat - stalat) * radius * !DTOR)
		   londist=abs((newslon - stalon) *(radius*cos(stalat*!DTOR))*!DTOR)
       	   dist= sqrt(latdist^2+londist^2)

           		; Make weighted averages
          	 	; Total ozone
           		weight=(1/dist(w))*newtoz(w)/total(1/dist(w))
           		wavg=total(weight)

           		; Distance weighted time
           		weight=(1./dist(w))*newtime(w)/total(1./dist(w))
         		wtime=total(weight)
           		wtime=round(wtime)                         ; Round to nearest second

          		; Weighted distance
          		weight=(1./dist(w))/total(1./dist(w))
           		wdist=total(weight*dist(w))

          		; Weighted sza
          		weight=(1./dist(w))*newsza(w)/total(1./dist(w))
           		wsza=total(weight)


          		; Weighted ozone profile
                        wprof=fltarr(profcnt)
                        for n=0,profcnt-1 do begin       ;now for profile
             		  weight=(1./dist(w))*newprof(n,w)/total(1./dist(w))
             		  wprof(n)=total(weight)
              	  if ((wprof(n) lt 0) or (wprof(n) gt 99)) then wprof(n) = 0.0
            		endfor
		ENDIF

            if nws LE 0 then begin		;CONTINUE (INCTO program uses continue. Change that as well)	;No valid pixel within this lat/lon box (0.5 by 0.5 degree)
		   wtime=0.0
		   wdist=0.0
		   num=0
		   wsza=0.0
		   wavg=0.0
                   wprof=fltarr(profcnt)
                   wprof(0:profcnt-1)=0.0
	     endif		
	;-------------------------------------------------------------


	;------------ Closest pixel Total ozone (NASA does this in their station overpass result) ---------
		radius=6370.0  ;radius of the earth
		latdist=abs((slat - stalat) * radius * !DTOR)
		londist=abs((slon - stalon) *(radius*cos(stalat*!DTOR))*!DTOR)
       	dist= sqrt(latdist^2+londist^2)

		closest_dist= min(dist)
		indx= where(dist EQ closest_dist, c1)
		closest_toz=0
		closest_wtime=0
		closest_sza=0

		IF c1 GT 0 then begin
		  tmptoz=reform(toz(w))
		  tmpwtime=reform(time_new(w))
		  tmpsza=reform(sza(w))

		  closest_toz= toz(indx(0))
		  closest_wtime= time_new(indx(0))
		  closest_sza= sza(indx(0))
		  closest_dist= dist(indx(0))
		ENDIF
	;-----------------------------------------------------------------
	
ozfill_value= fltarr(9)
ozfill_value(*)=-99.0

;stop

	;---------- Write distance weighted ozone params --------------------------------
          filename= result_path_distweigh + 'ovr'+string(sta,format='(i3.3)')+'.omps.wavg'
	   file_info= file_info(filename)

          openw, 4, filename,/append
           IF file_info.size LE 0 then printf, 4, 'Yr/Jdoy  wTime    wdist   Num  wSZA    wToz       Ozone-Layer-Profile'
          IF profcnt EQ 12 then printf,4,format='(i7,1x, i6,3x, f6.1,2x, i2, f8.1, 3x,f6.1, 3x, 12f10.5, 9f10.2)',jdate(0),wtime,wdist,nws,wsza,wavg, wprof, ozfill_value
          IF profcnt EQ 21 then printf,4,format='(i7,1x, i6,3x, f6.1,2x, i2, f8.1, 3x,f6.1, 3x, 21f10.5)',jdate(0),wtime,wdist,nws,wsza,wavg, wprof
           close, 4

	;--------------------------------------------------------------------------------

	;---------- Write distance weighted ozone params --------------------------------
          filename= result_path_distweigh_closestdist + 'ovr'+string(sta,format='(i3.3)')+'.omps.wavg'
	   file_info= file_info(filename)

          openw, 4, filename,/append
	   IF file_info.size LE 0 then printf, 4, 'Yr/Jdoy  wTime    wdist   Num  wSZA    wToz       Ozone-Layer-Profile (21 values)								    Closest_Dist KM (CD)   Time_secs (CD)  SZA (CD)     TOZ_ColumnAmountO3 (CD)'

          IF profcnt EQ 12 then printf,4,format='(i7,1x, i6,3x, f6.1,2x, i2, f8.1, 3x,f6.1, 3x, 12f10.5, 9f10.2,      4x,f8.2, 16x,i6, 10x,f6.2, 8x,f6.2)',jdate(0),wtime,wdist,nws,wsza,wavg,wprof, ozfill_value, closest_dist, closest_wtime, closest_sza,closest_toz
          IF profcnt EQ 21 then printf,4,format='(i7,1x, i6,3x, f6.1,2x, i2, f8.1, 3x,f6.1, 3x, 21f10.5,      4x,f8.2, 16x,i6, 10x,f6.2, 8x,f6.2)',jdate(0),wtime,wdist,nws,wsza,wavg,wprof, closest_dist, closest_wtime, closest_sza,closest_toz
           close, 4

	;--------------------------------------------------------------------------------

;IF sta EQ 902 then stop


	ENDWHILE		;Station File
	close, 3
	;*********************************************

	doy=doy+1

  ENDWHILE		;DOY LE endDOY

ENDFOR		;YEAR loop

;EXIT


END
