
; code is written to read NetCDF V8TOZ variables -- Zhihua Zhang@IMSG/NOAA Jan. 5, 2016


pro ncreadvari_v8pro_dn,filename,data


;filename = '/data/data074/users/zhihuaz/V8PRO_NDE_DELIVERY_1/output_dat/V8PRO-EDR_v1r0_npp_s201512180109252_e201512180110026_c201606101230450.nc'



;;; ---------- read in data -------

  fid = ncdf_open(filename)

  ncdf_varget,fid, ncdf_varid(fid,'Latitude'),               Latitude
  ncdf_varget,fid, ncdf_varid(fid,'Longitude'),              Longitude
  ncdf_varget,fid, ncdf_varid(fid,'LatCorner'),       LatCorner
  ncdf_varget,fid, ncdf_varid(fid,'LonCorner'),              LonCorner
  ncdf_varget,fid, ncdf_varid(fid,'FINALRESIDUAL'),       FINALRESIDUAL
  ncdf_varget,fid, ncdf_varid(fid,'INITIALRESIDUAL'),     INITIALRESIDUAL
  ncdf_varget,fid, ncdf_varid(fid,'ColumnAmountO3_Profile'),        ColumnAmountO3_Profile
  ncdf_varget,fid, ncdf_varid(fid,'ColumnAmountO3_TO3'),           ColumnAmountO3_TO3
  ncdf_varget,fid, ncdf_varid(fid,'MidTime'),          MidTime
  ncdf_varget,fid, ncdf_varid(fid,'NValue'),          NValue
  ncdf_varget,fid, ncdf_varid(fid,'O3Apriori'),       O3Apriori
  ncdf_varget,fid, ncdf_varid(fid,'O3FINAL'),         O3FINAL
  ncdf_varget,fid, ncdf_varid(fid,'O3Initial'),            O3Initial
  ncdf_varget,fid, ncdf_varid(fid,'O3MixingRatio'),              O3MixingRatio
  ncdf_varget,fid, ncdf_varid(fid,'Pressure'),           Pressure
  ncdf_varget,fid, ncdf_varid(fid,'PressureMixingRatio'),            PressureMixingRatio
  ncdf_varget,fid, ncdf_varid(fid,'Reflectivity331'),        Reflectivity331
  ncdf_varget,fid, ncdf_varid(fid,'Reflectivity340'),        Reflectivity340
  ncdf_varget,fid, ncdf_varid(fid,'RelativeAzimuthAngle'),               RelativeAzimuthAngle
  ncdf_varget,fid, ncdf_varid(fid,'Residual_TO3'),             Residual_TO3
  ncdf_varget,fid, ncdf_varid(fid,'SolarAzimuthAngle'),           SolarAzimuthAngle
  ncdf_varget,fid, ncdf_varid(fid,'SolarZenithAngle'),             SolarZenithAngle
  ncdf_varget,fid, ncdf_varid(fid,'StepOneO3'),       StepOneO3
  ncdf_varget,fid, ncdf_varid(fid,'StepTwoO3'),         StepTwoO3
  ncdf_varget,fid, ncdf_varid(fid,'SurfaceCategory'),          SurfaceCategory
  ncdf_varget,fid, ncdf_varid(fid,'TemperatureClimatology'),          TemperatureClimatology
  ncdf_varget,fid, ncdf_varid(fid,'TerrainPressure'),          TerrainPressure
  ncdf_varget,fid, ncdf_varid(fid,'UVAerosolIndex'),               UVAerosolIndex
  ncdf_varget,fid, ncdf_varid(fid,'ViewingAzimuthAngle'),                   ViewingAzimuthAngle
  ncdf_varget,fid, ncdf_varid(fid,'ViewingZenithAngle'),        ViewingZenithAngle
  ncdf_varget,fid, ncdf_varid(fid,'WaveLength'),     WaveLength
  ncdf_varget,fid, ncdf_varid(fid,'Wavelength_Profile'),           Wavelength_Profile
  ncdf_varget,fid, ncdf_varid(fid,'Wavelength_TO3'),           Wavelength_TO3
  ncdf_varget,fid, ncdf_varid(fid,'dndo_TO3'),           dndo_TO3
  ncdf_varget,fid, ncdf_varid(fid,'dndr_TO3'),           dndr_TO3
  ncdf_varget,fid, ncdf_varid(fid,'yearday'),            yearday
  ncdf_varget,fid, ncdf_varid(fid,'ErrorCode_Profile'),   ErrorCode_Profile 
  ncdf_varget,fid, ncdf_varid(fid,'AverageSolutionResidual'),               AverageSolutionResidual
  ncdf_varget,fid, ncdf_varid(fid,'Ascending_Descending'),   Ascending_Descending

;;; ---------- make data structure ----
  data=create_struct(                                             $
      "Latitude",                 Latitude,                       $
      "Longitude",                Longitude,                      $
      "LatCorner",         LatCorner,                             $
      "LonCorner",                LonCorner,                      $
      "FINALRESIDUAL",         FINALRESIDUAL,                     $
      "INITIALRESIDUAL",       INITIALRESIDUAL,             $
      "ColumnAmountO3_Profile",          ColumnAmountO3_Profile,                $
      "ColumnAmountO3_TO3",             ColumnAmountO3_TO3,                   $
      "MidTime",            MidTime,                  $
      "NValue",            NValue,                  $
      "O3Apriori",         O3Apriori,               $
      "O3FINAL",           O3FINAL,                 $
      "O3Initial",              O3Initial,                    $
      "O3MixingRatio",                O3MixingRatio,                      $
      "Pressure",             Pressure,                   $
      "PressureMixingRatio",              PressureMixingRatio,                    $
      "Reflectivity331",          Reflectivity331,                $
      "Reflectivity340",          Reflectivity340,                $
      "RelativeAzimuthAngle",                 RelativeAzimuthAngle,                       $
      "Residual_TO3",               Residual_TO3,                     $
      "SolarAzimuthAngle",             SolarAzimuthAngle,                   $
      "SolarZenithAngle",               SolarZenithAngle,                     $
      "StepOneO3",         StepOneO3,               $
      "StepTwoO3",           StepTwoO3,                 $
      "SurfaceCategory",            SurfaceCategory,                  $
      "TemperatureClimatology",            TemperatureClimatology,                  $
      "TerrainPressure",            TerrainPressure,                  $
      "UVAerosolIndex",                 UVAerosolIndex,                       $
      "ViewingAzimuthAngle",                     ViewingAzimuthAngle,                           $
      "ViewingZenithAngle",          ViewingZenithAngle,                $
      "WaveLength",       WaveLength,             $
      "Wavelength_Profile",             Wavelength_Profile,                   $
      "Wavelength_TO3",             Wavelength_TO3,                   $
      "dndo_TO3",             dndo_TO3,                   $
      "dndr_TO3",             dndr_TO3,                   $
      "yearday",              yearday,                    $
      "ErrorCode_Profile",     ErrorCode_Profile,       $
      "AverageSolutionResidual",                 AverageSolutionResidual,                       $
      "Ascending_Descending",     Ascending_Descending            )

  ncdf_close, fid


;stop

end
