; This version reads in the V6 ozone profile values for overpass program
PRO read_OONPO, filename, toz, OzoneErrorFlagForProfile, ozprofile

;;file_id = H5F_OPEN(filename)
file_id = ncdf_open(filename)

	data=H5G_GET_MEMBER_NAME(file_id,'All_Data',0)

	Dataname='/All_Data/'+data+'/TotalO3SolutionProfile'
	dataset_id= H5D_OPEN(file_id,Dataname)
	toz = H5D_Read(dataset_id)
	H5D_CLOSE, dataset_id

	Dataname='/All_Data/'+data+'/FinalO3Profile'
	dataset_id= H5D_OPEN(file_id,Dataname)
	ozprofile = H5D_Read(dataset_id)
	H5D_CLOSE, dataset_id


	p=strpos(filename, 'npp_d')
	day=strmid(filename, p+5+6, 2)
	month=strmid(filename, p+5+4, 2)
	year=strmid(filename, p+5, 4)
	doy= ymd2dn(year, month, day)

    if (year lt 2013) then ozcode='/ErrorFlag'
    if (year eq 2013) and (doy le 191) then ozcode='/ErrorFlag'
    if (year eq 2013) and (doy gt 191) then ozcode='/OzoneErrorFlagForProfile'
    if (year gt 2013) then ozcode='/OzoneErrorFlagForProfile'

    if (year ge 2017) and (doy gt 067) then ozcode='/OzoneErrorFlagforProfile'


   if (year eq 2013) and (doy GE 190) AND (doy LE 191) then begin

	Result = H5_PARSE(filename)
	attributes= TAG_NAMES(Result.ALL_DATA.OMPS_NP_IP_ALL)
	s=size(attributes, /dimensions)

	FOR i=0, s(0)-1 do begin
	;IF filename EQ '/data/data074/NPP/OMPS/DATA/NP/2013/07/09/GONPO/GONPO_npp_d20130709_t2207088_e2207463_b08804_c20130710042345318721_noaa_ops.h5' then print, attributes
		IF attributes(i) EQ 'ErrorFlag' then begin
			ozcode='/ErrorFlag'
			BREAK
		ENDIF
		IF attributes(i) EQ 'OZONEERRORFLAGFORPROFILE' then begin
			ozcode='/OzoneErrorFlagForProfile'
			BREAK
		ENDIF
	ENDFOR
   endif


	;Dataname='/All_Data/'+data+ '/OzoneErrorFlagForProfile'
	Dataname='/All_Data/'+data+ ozcode
	dataset_id= H5D_OPEN(file_id,Dataname)
	OzoneErrorFlagForProfile = H5D_Read(dataset_id)
	H5D_CLOSE, dataset_id

	H5F_close, file_id



END

