@../../../setup/mirs_paths_idl.pro
@covMatrx_sub.pro
;------------------------------------------------------------------
; Program used to generate a geophysical covariance matrix
; from an atmopsheric set of profiles and a set of surface params.
;
; Sid-Ahmed Boukabara. 2005.
;
; Updated February/March 2008. Sid-Ahmed Boukabara, NOAA/NESDIS
;------------------------------------------------------------------
device,true=24,retain=2,decompose=0
device,pseudo_color=8,retain=2
device,pseudo_color=8,decompose=0
device,get_visual_name=thisvisualClass
loadct,39
defineColors,colors,nc
device='x'
set_plot,'x'

if (thisvisualClass ne 'pseudoColor') then device,decomposed=0
close,/all

;------------------------------------------------------------------
PRINT, 'Do you want to read again the data (0), re-compute the stats (1)  or re-plot the figures (2)  ?'
read,answer
IF (answer eq 1) then GOTO, sels
IF (answer eq 2) then GOTO, sels2
Loadct,39
device='x'
set_plot,'x'

;-----------------------------------------------------------------------------------
;
; User-driven information. Needs cross-consistency between the parameters.
;
;-----------------------------------------------------------------------------------
ichoiceSfcTyp     = 0                 ; 0->ocean, 1:sea-ice, 2:land, 3:snow
Sensor            = 'f18_ssmis'            ;'n18_amsua_mhs' or 'metopA_amsua_mhs' or 'f16_ssmis' or 'coriolis_windsat' or 'aqua_amsre' or 'npp_atms'

dataset1          = 'ecmwf'           ;'noaa88' or 'mm5' or 'ecmwf60'
dataset2          = 'mm5'           ;'noaa88' or 'mm5' or 'ecmwf60' (mm5 used to replace dataset1 hydrometeors for rain/graupel)

IF (ichoiceSfcTyp eq 0) THEN extSfcTyp='oc'
IF (ichoiceSfcTyp eq 1) THEN extSfcTyp='ic'
IF (ichoiceSfcTyp eq 2) THEN extSfcTyp='ld'
IF (ichoiceSfcTyp eq 3) THEN extSfcTyp='sn'

;---T/Q/Emissivity/Cld/Hydrometeors file & output files
;Path='/net/orbit041l/disk2/pub/kgarrett/preProcess/processedFiles/'+Sensor+'/'
Path='/net/orbit232l/home/pub/kgarrett/mirs_utilities/src/covmtrx_gen/processedFiles/'+Sensor+'/'
file_in_1     = Path+'Scene_'+extSfcTyp+'_'+Sensor+'_'+dataset1+'.dat'
file_in_2     = Path+'Scene_'+extSfcTyp+'_'+Sensor+'_'+dataset2+'.dat'
covA_out      = './data/'+Sensor+'/CovBkgMatrxAtm_'+extSfcTyp+'.dat'
covS_out      = './data/'+Sensor+'/CovBkgMatrxSfc_'+extSfcTyp+'_'+Sensor+'.dat'

;---Read scene filename(s) 
print,'-----------------------------------------------'
print,' Dataset1: Reading the data from ....'+strcompress(file_in_1)
ReadScene,file_in_1,nprofiles,nlay,nlev,nchan,nAbsorb,nParmCLW,nParmRain,              $
  nParmSnow,nParmIce,nParmGrpl,AbsorbID,CentrFrq,Polarty,iH2o,iO3,ProfIndx,            $
  Pres_lay,Pres_lev,Temp_lay,Abso_lay,clw,rain,snow,ice,grpl,Angle,Emiss,              $
  Refl,WindSp,Tskin,SfcPres,SfcTyp,deltaT,scene,Lat,Lon,windU,windV
print,' Dataset2: Reading the data from ....'+strcompress(file_in_2)
ReadScene,file_in_2,nprofiles2,nlay2,nlev2,nchan2,nAbsorb2,nParmCLW2,nParmRain2,       $
  nParmSnow2,nParmIce2,nParmGrpl2,AbsorbID2,CentrFrq2,Polarty2,iH2o_2,iO3_2,ProfIndx2, $
  Pres_lay2,Pres_lev2,Temp_lay2,Abso_lay2,clw2,rain2,snow2,ice2,grpl2,Angle2,Emiss2,   $
  Refl2,WindSp2,Tskin2,SfcPres2,SfcTyp2,deltaT2,scene2,Lat2,Lon2,windU2,windV2
consistCheck,nlay,nlev,nchan,nAbsorb,nParmCLW,nParmRain,nParmSnow,nParmIce,            $
  nParmGrpl,AbsorbID,CentrFrq,Polarty,iH2o,iO3,nlay2,nlev2,nchan2,nAbsorb2,nParmCLW2,  $
  nParmRain2,nParmSnow2,nParmIce2,nParmGrpl2,AbsorbID2,CentrFrq2,Polarty2,iH2o_2,iO3_2

;----Description of parameters, their indexes, storage modes, etc
npAtm        = 10 ;#parameters: T+WV+O3+CLW+Rain+Snow+Ice+Graupel+'TSKIN+SFCP
DescParamAtm = ['TEMP', 'WVAP',   'OZON',    'CLW',   'RAIN',   'SNOW',    'ICE',   'GRPL',  'TSKIN',    'SFCP']
iModeAtm     = [     0,      1,        0,        1,        1,        1,        1,        1,        0,        0 ] ;=0->geoph, 1->Log-space
IndexAtm     = [     1, Nlay+1, 2*nLay+1, 3*nLay+1, 4*nLay+1, 5*nLay+1, 6*nLay+1, 7*nLay+1, 8*nLay+1,  8*nLay+2] ;index within state vector
LengthAtm    = [  Nlay,   Nlay,     Nlay,     Nlay,     Nlay,     Nlay,     Nlay,     Nlay,        1,         1] ;lengths of the params vectors
unitsAtm     = [   'K', 'g/Kg',   'g/Kg',     'mm',     'mm',     'mm',     'mm',     'mm',      'K',      'mb'] ;units
AtmDisab     = [     1,      1,        1,        1,        1,        1,        1,        1,        1,         1] ;Disable cov for these params (if =0)
AtmSetSrc    = [     1,      1,        1,        1,        2,        2,        2,        2,        1,         1] ;file source of params (1:file1, 2:file2) 
AtmBlocDiag  = [     0,      0,        1,        0,        1,        1,        1,        0,        0,         0] ;0:keep inter-params covar, 1:bloc diagonal
nparamsAtm   = TOTAL(LengthAtm[0:npAtm-1])

npSfc        = 6  ;#parameters: Emiss+Refl+WindSp+Tskin+DeltaT+SfcPres
DescParamSfc = ['EMIS',  'REFL',  'WINDSP',   'TSKIN',  'DELTAT',    'SFCP']
iModeSfc     = [     0,       0,         0,         0,         0,         0] ;=0->geoph (x)-space,1->Log(x)-space, 2->Log(-Log(x)) space
IndexSfc     = [     1, nchan+1, 2*nchan+1, 2*nchan+2, 2*nchan+3, 2*nchan+4] ;index within state vector
LengthSfc    = [ nchan,   nchan,         1,         1,         1,         1]
unitsSfc     = [   ' ',     ' ',     'm/s',       'K',       'K',      'mb']
SfcDisab     = [     1,       1,         1,         1,         1,         1]      
SfcSetSrc    = [     1,       1,         1,         1,         1,         1] 
SfcBlocDiag  = [     1,       1,         1,         1,         1,         1] ;0:keep inter-params corr, 1:bloc diagonal
nparamsSfc   = TOTAL(LengthSfc[0:npSfc-1])


;---Transform the EDRs into Log (optional)
print,'-----------------------------------------------'
print,' Converting Absorbers amount into Log ....'
TransfParams,Temp_Lay,Abso_Lay,clw,rain,snow,ice,grpl,Tskin,SfcPres,Emiss,Refl,windsp,DeltaT,iModeAtm,$
  iModeSfc,nProfiles,nLay,nchan,iH2O,iO3
TransfParams,Temp_Lay2,Abso_Lay2,clw2,rain2,snow2,ice2,grpl2,Tskin2,SfcPres2,Emiss2,Refl2,windsp2,DeltaT2,iModeAtm,$
  iModeSfc,nProfiles2,nLay2,nchan2,iH2O_2,iO3_2
;----Put together the state vector with all parameters together
putTogetherX,xArrAtm,xArrSfc,nprofiles,nchan,nparamsAtm,nparamsSfc,iH2O,iO3,IndexAtm,IndexSfc,LengthAtm,$
  LengthSfc,Temp_Lay,Abso_Lay,clw,rain,snow,ice,grpl,Tskin,SfcPres,Emiss,Refl,windsp
putTogetherX,xArrAtm2,xArrSfc2,nprofiles2,nchan2,nparamsAtm,nparamsSfc,iH2O_2,iO3_2,IndexAtm,IndexSfc,LengthAtm,$
  LengthSfc,Temp_Lay2,Abso_Lay2,clw2,rain2,snow2,ice2,grpl2,Tskin2,SfcPres2,Emiss2,Refl2,windsp2


sels: impr = 0

;-----------------------------------------------------------------------------------
;
;   COMPUTATION of STATISTICS (MEAN & COV MATRX)
;
;-----------------------------------------------------------------------------------                                 
;---Compute statistics for all parameters (mean+covariances)
print,'-----------------------------------------------'
print,' Computing Stats ....'
Stats,xArrAtm,nparamsAtm,nProfiles,M_Atm,C_Atm
Stats,xArrSfc,nparamsSfc,nProfiles,M_Sfc,C_Sfc
Stats,xArrAtm2,nparamsAtm,nProfiles2,M_Atm2,C_Atm2
Stats,xArrSfc2,nparamsSfc,nProfiles2,M_Sfc2,C_Sfc2

;-----------------------------------------------------------------------------------
;
;   Modify artificially the backgrounds 
;
;-----------------------------------------------------------------------------------                                 
print,'-----------------------------------------------'
read,  prompt='Artificially replace the mean backgrounds of cloud/hydrometeors profiles with sample profile? (1:Yes, 0:No):',iModifyArtificiallyHydrom
IF (iModifyArtificiallyHydrom eq 1) THEN BEGIN
    ;---Scene#1
    ind0=where(scene.clwvec(0:nprofiles-1) ge 0.1,ncount)
    IF (ncount gt 0) THEN M_Atm(IndexAtm(3)-1:IndexAtm(3)-1+LengthAtm(3)-1)      = clw(ind0(0),0:nParmCLW-1)
    ind0=where(scene.rwpvec(0:nprofiles-1) ge 0.1,ncount)
    IF (ncount gt 0) THEN M_Atm(IndexAtm(4)-1:IndexAtm(4)-1+LengthAtm(4)-1)      = rain(ind0(0),0:nParmRain-1)
    ind0=where(scene.gwpvec(0:nprofiles-1) ge 0.1,ncount)
    IF (ncount gt 0) THEN M_Atm(IndexAtm(7)-1:IndexAtm(7)-1+LengthAtm(7)-1)      = grpl(ind0(0),0:nParmGrpl-1)
    ;---Scene#2
    ind0=where(scene2.clwvec(0:nprofiles-1) ge 0.1,ncount)
    IF (ncount gt 0) THEN M_Atm2(IndexAtm(3)-1:IndexAtm(3)-1+LengthAtm(3)-1)      = clw2(ind0(0),0:nParmCLW-1)
    ind0=where(scene2.rwpvec(0:nprofiles-1) ge 0.1,ncount)
    IF (ncount gt 0) THEN M_Atm2(IndexAtm(4)-1:IndexAtm(4)-1+LengthAtm(4)-1)      = rain2(ind0(0),0:nParmRain-1)
    ind0=where(scene2.gwpvec(0:nprofiles-1) ge 0.1,ncount)
    IF (ncount gt 0) THEN M_Atm2(IndexAtm(7)-1:IndexAtm(7)-1+LengthAtm(7)-1)      = grpl2(ind0(0),0:nParmGrpl-1)
ENDIF

;----Replace statistics computed on dataset1 by those computed with dataset2
print,'-----------------------------------------------'
print,' Replacing statistics computed on dataset1 by those computed with dataset2 ....'
;---Atm
FOR id=0,npAtm-1 DO BEGIN
    IF (AtmSetSrc(id) eq 2) THEN BEGIN
        print,' Replacing:',DescParamAtm(id)
        FOR j=IndexAtm(id)-1,IndexAtm(id)-1+LengthAtm(id)-1 DO BEGIN                
            M_Atm(j)  = M_Atm2(j)
            C_Atm(j,0:nparamsAtm-1) = C_Atm2(j,0:nparamsAtm-1)
            C_Atm(0:nparamsAtm-1,j) = C_Atm2(0:nparamsAtm-1,j)
        ENDFOR
    ENDIF
ENDFOR
;---Sfc
FOR id=0,npSfc-1 DO BEGIN
    IF (SfcSetSrc(id) eq 2) THEN BEGIN
        print,' Replacing:',DescParamSfc(id)
        FOR j=IndexSfc(id)-1,IndexSfc(id)-1+LengthSfc(id)-1 DO BEGIN                
            M_Sfc(j)  = M_Sfc2(j)
            C_Sfc(j,0:nparamsSfc-1) = C_Sfc2(j,0:nparamsSfc-1)
            C_Sfc(0:nparamsSfc-1,j) = C_Sfc2(0:nparamsSfc-1,j)
        ENDFOR
    ENDIF
ENDFOR

;----Possibility to replace some statistics by off-line computed stats
print,'-----------------------------------------------'
read,  prompt='Replace internally-computed stats of EMISSIVITY by off-line values (1:Yes, 0:No):',iOfflStats_emiss
IF (iOfflStats_emiss eq 1) THEN BEGIN
    Cov_Bkg_file_Sfc_emiss=''
    read, format='(a)', prompt='Name of file containing off-line stats (no quotes):',Cov_Bkg_file_Sfc_emiss
    ReadCovBkgFile,Cov_Bkg_file_sfc_emiss,nchan_sfc_emiss,M_emiss,C_emiss,ichoiceSfcTyp,extSfcTyp
    ;---sanity checks
    IF (nchan_sfc_emiss ne nchan)        THEN STOP, 'Error in number of channels compatibility -1-.'
    IF (nchan_sfc_emiss ne LengthSfc(0)) THEN STOP, 'Error in number of channels compatibility -2-.'
    ;---replace covariance matrix of emissivity
    M_Sfc(IndexSfc(0)-1:IndexSfc(0)-1+LengthSfc(0)-1)                                            = M_Emiss(0:nchan-1)
    C_Sfc(IndexSfc(0)-1:IndexSfc(0)-1+LengthSfc(0)-1,IndexSfc(0)-1:IndexSfc(0)-1+LengthSfc(0)-1) = C_Emiss(0:nchan-1,0:nchan-1)
ENDIF

print,'-----------------------------------------------'
print, 'The following files are going to be generated:'
print,covA_out
print,covS_out

;-----------------------------------------------------------------------------------
;
;   Disable certain covariances
;
;-----------------------------------------------------------------------------------                                 
FOR id=0,npAtm-1 DO BEGIN;---Temp+WVap+Ozon+CLW+Rain+Snow+Ice+Graupel+Tskin+SfcP
    print,id,DescParamAtm[id],AtmDisab[id],IndexAtm(id)-1,IndexAtm(id)-1+LengthAtm(id)-1,nparamsAtm
    IF (AtmDisab[id] eq 0) THEN BEGIN
        FOR i=IndexAtm(id)-1,IndexAtm(id)-1+LengthAtm(id)-1 DO BEGIN
            C_Atm(i,0:nparamsAtm-1)=0.000
            C_Atm(0:nparamsAtm-1,i)=0.000
            ;C_Atm(i,i)=randomn(0,/uniform)*100.
            C_Atm(i,i)=100.
        ENDFOR
    ENDIF
ENDFOR
FOR id=0,npSfc-1 DO BEGIN;---Emiss+Refl+Tskin+SfcP
    print,id,DescParamSfc[id],SfcDisab[id],IndexSfc(id)-1,IndexSfc(id)-1+LengthSfc(id)-1,nparamsSfc
    IF (SfcDisab[id] eq 0) THEN BEGIN
        FOR i=IndexSfc(id)-1,IndexSfc(id)-1+LengthSfc(id)-1 DO BEGIN
            C_Sfc(i,0:nparamsSfc-1)=0.000
            C_Sfc(0:nparamsSfc-1,i)=0.000
            ;C_Sfc(i,i)=randomn(0,/uniform)*100.
            C_Sfc(i,i)=100.
        ENDFOR
    ENDIF
ENDFOR

;-----------------------------------------------------------------------------------
;
;   Make covariance bloc-diagonal (parameters intra-correlated, not ultra-correlated)
;
;-----------------------------------------------------------------------------------                                 
FOR id=0,npAtm-1 DO BEGIN
    print,'---',id,DescParamAtm[id],AtmBlocDiag[id],IndexAtm(id)-1,IndexAtm(id)-1+LengthAtm(id)-1
    IF (AtmBlocDiag[id] eq 1) THEN BEGIN
        FOR i=IndexAtm(id)-1,IndexAtm(id)-1+LengthAtm(id)-1 DO BEGIN
            IF (IndexAtm(id)-2 ge 0)                                THEN C_Atm(i,0:IndexAtm(id)-2)                              =0.00
            IF (nparamsAtm-1   ge IndexAtm(id)-1+LengthAtm(id)-1+1) THEN C_Atm(i,IndexAtm(id)-1+LengthAtm(id)-1+1:nparamsAtm-1) =0.00
            IF (IndexAtm(id)-2 ge 0)                                THEN C_Atm(0:IndexAtm(id)-2,i)                              =0.00
            IF (nparamsAtm-1   ge IndexAtm(id)-1+LengthAtm(id)-1+1) THEN C_Atm(IndexAtm(id)-1+LengthAtm(id)-1+1:nparamsAtm-1,i) =0.00
        ENDFOR
    ENDIF
ENDFOR
FOR id=0,npSfc-1 DO BEGIN;---Emiss+Refl+Tskin+SfcP
    IF (SfcBlocDiag[id] eq 1) THEN BEGIN
        FOR i=IndexSfc(id)-1,IndexSfc(id)-1+LengthSfc(id)-1 DO BEGIN
            IF (IndexSfc(id)-2 ge 0)                                THEN C_Sfc(i,0:IndexSfc(id)-2)                              =0.00
            IF (nparamsSfc-1   ge IndexSfc(id)-1+LengthSfc(id)-1+1) THEN C_Sfc(i,IndexSfc(id)-1+LengthSfc(id)-1+1:nparamsSfc-1) =0.00
            IF (IndexSfc(id)-2 ge 0)                                THEN C_Sfc(0:IndexSfc(id)-2,i)                              =0.00
            IF (nparamsSfc-1   ge IndexSfc(id)-1+LengthSfc(id)-1+1) THEN C_Sfc(IndexSfc(id)-1+LengthSfc(id)-1+1:nparamsSfc-1,i) =0.00
        ENDFOR
    ENDIF
ENDFOR


;---Modify artificially the sfcpres stats when over ocean
IF (ichoiceSfcTyp eq 0) THEN C_Atm(IndexAtm(9)-1,IndexAtm(9)-1)=100.

;-----------------------------------------------------------------------------------
;
;   Compute correlation matrix (Atm)
;
;-----------------------------------------------------------------------------------                                 
CorrAtm=fltarr(nparamsAtm,nparamsAtm)
FOR i=0,nparamsAtm-1 DO BEGIN
    FOR j=0,nparamsAtm-1 DO BEGIN
        IF (C_Atm(i,i) ne 0. and C_Atm(j,j) ne 0.) THEN BEGIN
            CorrAtm(i,j)=C_Atm(i,j)/sqrt(C_Atm(i,i)*C_Atm(j,j))
        ENDIF
        IF (C_Atm(i,i) eq 0. or  C_Atm(j,j) eq 0.) THEN BEGIN
            CorrAtm(i,j)=0.
        ENDIF
        CorrAtm(j,i)=CorrAtm(i,j)
    ENDFOR
    ;print,i,C_Atm(i,i),CorrAtm(i,i)
ENDFOR

;-----------------------------------------------------------------------------------
;
;   Compute correlation matrix (Sfc)
;
;-----------------------------------------------------------------------------------                                 
CorrSfc=fltarr(nparamsSfc,nparamsSfc)
FOR i=0,nparamsSfc-1 DO BEGIN
    FOR j=0,nparamsSfc-1 DO BEGIN
        IF (C_Sfc(i,i) ne 0. and C_Sfc(j,j) ne 0.) THEN BEGIN
            CorrSfc(i,j)=C_Sfc(i,j)/sqrt(C_Sfc(i,i)*C_Sfc(j,j))
        ENDIF
        IF (C_Sfc(i,i) eq 0. or  C_Sfc(j,j) eq 0.) THEN BEGIN
            CorrSfc(i,j)=1.
        ENDIF
        CorrSfc(j,i)=CorrSfc(i,j)
    ENDFOR
    ;print,i,C_Sfc(i,i),CorrSfc(i,i)
ENDFOR


;-----------------------------------------------------------------------------------
;
;   EOF decomposition
;
;-----------------------------------------------------------------------------------                                 
print,'-----------------------------------------------'
print,' Performing EOF decomposition ....'
;----decompose directly the big matrix
;EigenvDecomp,C_Atm,D_Atm,A_Atm,neigenvAtm     ;Atmospheric state
;EigenvDecomp,C_Sfc,D_Sfc,A_Sfc,neigenvSfc     ;Surface state
;----decompose the cov matrix bloc diagonal by bloc diagonal
A_Atm      = make_array(nparamsAtm,nparamsAtm,/float,value=0.)
neigenvAtm = 0
FOR id=0,npAtm-1 DO BEGIN
    C=C_Atm(IndexAtm(id)-1:IndexAtm(id)-1+LengthAtm(id)-1,IndexAtm(id)-1:IndexAtm(id)-1+LengthAtm(id)-1)
    IF (LengthAtm(id) gt 1) THEN BEGIN
        EigenvDecomp,C,D,A,neigenv
    ENDIF
    IF (LengthAtm(id) eq 1) THEN BEGIN
        A       = make_array(1,1,/float,value=1.)
        neigenv = 1
    ENDIF
    neigenvAtm = neigenvAtm + neigenv
    A_Atm(IndexAtm(id)-1:IndexAtm(id)-1+LengthAtm(id)-1,IndexAtm(id)-1:IndexAtm(id)-1+LengthAtm(id)-1)=A(0:neigenv-1,0:neigenv-1)
ENDFOR
A_Sfc      = make_array(nparamsSfc,nparamsSfc,/float,value=0.)
neigenvSfc = 0
FOR id=0,npSfc-1 DO BEGIN
    C=C_Sfc(IndexSfc(id)-1:IndexSfc(id)-1+LengthSfc(id)-1,IndexSfc(id)-1:IndexSfc(id)-1+LengthSfc(id)-1)
    IF (LengthSfc(id) gt 1) THEN BEGIN
        EigenvDecomp,C,D,A,neigenv
    ENDIF
    IF (LengthSfc(id) eq 1) THEN BEGIN
        A       = make_array(1,1,/float,value=1.)
        neigenv = 1
    ENDIF
    neigenvSfc = neigenvSfc + neigenv
    A_Sfc(IndexSfc(id)-1:IndexSfc(id)-1+LengthSfc(id)-1,IndexSfc(id)-1:IndexSfc(id)-1+LengthSfc(id)-1)=A(0:neigenv-1,0:neigenv-1)
ENDFOR


;-----------------------------------------------------------
;
;   Open ATM output file and write out cov/transf/bkg files
;
;-----------------------------------------------------------
;---Atmospheric cov/bkg/transf matrx
nTypAtm      = 1  & iTypAtm = intarr(nTypAtm) & DescTypAtm=strarr(nTypAtm)
iTypAtm      = [ichoiceSfcTyp]
DescTypAtm   = [extSfcTyp]  
print,'-----------------------------------------------'
print,' Output Stats in pieces (atm) ... in:',covA_out
writeOutHdrCovMatrx,0,covA_out,ioutAtm,npAtm,IndexAtm,DescParamAtm,nTypAtm,iTypAtm,DescTypAtm,$
  pres_lay(0,*),pres_lev(0,*),CentrFrq,Polarty,iModeAtm
FOR id=0,npAtm-1 DO BEGIN;---Temp+WVap+Ozon+CLW+Rain+Snow+Ice+Graupel+Tskin+SfcP
    writeOutInPiecesCovMatrx,ioutAtm,LengthAtm(id),DescParamAtm[id],IndexAtm[id],$
      C_Atm(IndexAtm(id)-1:IndexAtm(id)-1+LengthAtm(id)-1,IndexAtm(id)-1:IndexAtm(id)-1+LengthAtm(id)-1),$
      A_Atm(IndexAtm(id)-1:IndexAtm(id)-1+LengthAtm(id)-1,IndexAtm(id)-1:IndexAtm(id)-1+LengthAtm(id)-1),$
      M_Atm(IndexAtm(id)-1:IndexAtm(id)-1+LengthAtm(id)-1)
ENDFOR
;----Output Big Cov/Trsnf/Bkg arrays
writeOutInPiecesCovMatrx,ioutAtm,NEIGENVatm,'All-EDRs-atm-',0,C_atm,A_atm,M_atm

;-----------------------------------------------------------
;
;   Open SFC output file and write out cov/transf/bkg files
;
;-----------------------------------------------------------
;---Surface cov/bkg/transf matrx
nTypSfc      = 1  & iTypSfc = intarr(nTypSfc) & DescTypSfc=strarr(nTypSfc)
iTypSfc      = [ichoiceSfcTyp]
DescTypSfc   = [extSfcTyp]
print,'-----------------------------------------------'
print,' Output Stats in pieces (sfc) ... in:',covS_out
writeOutHdrCovMatrx,1,covS_out,ioutSfc,npSfc,IndexSfc,DescParamSfc,nTypSfc,iTypSfc,DescTypSfc,$
  pres_lay(0,*),pres_lev(0,*),CentrFrq,Polarty,iModeSfc
FOR id=0,5 DO BEGIN;---Emissivity+Reflectivity+WindSp+Tskin+DeltaT+SfcPress
    writeOutInPiecesCovMatrx,ioutSfc,LengthSfc(id),DescParamSfc[id],IndexSfc[id],$
      C_Sfc(IndexSfc(id)-1:IndexSfc(id)-1+LengthSfc(id)-1,IndexSfc(id)-1:IndexSfc(id)-1+LengthSfc(id)-1), $
      A_Sfc(IndexSfc(id)-1:IndexSfc(id)-1+LengthSfc(id)-1,IndexSfc(id)-1:IndexSfc(id)-1+LengthSfc(id)-1),$
      M_Sfc(IndexSfc(id)-1:IndexSfc(id)-1+LengthSfc(id)-1)
ENDFOR
;----Output of Cov/Trsnf/Bkg arrays
writeOutInPiecesCovMatrx,ioutSfc,NEIGENVsfc,'All-EDRs-sfc-',0,C_sfc,A_sfc,M_sfc

sels2: 
    impr = 0

;-----------------------------------------------------------
;
;   PLOTTONG SECTION
;
;-----------------------------------------------------------
imp:
    !p.font=1

    ;---Plotting the data themselves
    plot_TempProfiles      = 0
    plot_WVapProfiles      = 0
    plot_OzonProfiles      = 0
    plot_CLWProfiles       = 0
    plot_RainProfiles      = 0
    plot_SnowProfiles      = 0
    plot_IceProfiles       = 0
    plot_GrplProfiles      = 0
    plot_EmissSpectra      = 0
    plot_SfcParams         = 0
    ;---EOF reconstruction
    plot_Reconstr          = 0
    plot_ReconstrSfcParams = 0
    ;---Show PDF distributions
    plot_WVdistr           = 0
    plot_CLWdistr          = 0
    plot_EmissDistr        = 0
    ;---Show correlation matrix 
    plot_corrMatrxAtm      = 1
    plot_corrMatrxSfc      = 0



    ;-------------Atm Correlation matrix display
    IF (plot_corrMatrxAtm eq 1) THEN BEGIN
        DisplParamAtm = ['TEMP/','WVAP/', 'OZON/',  'CLW/',  'RAIN/',  'SNOW/',   'ICE/',  'GRPL/', 'TSKIN/',   'SFCP/']
        DisplAtm      = [     1,      1,        0,       1,        1,        0,        0,        1,        1,         1]
        set_plot,'x'
        format         ='png'
        fileout        ='SaAtm.png'
        xsize          = 0
        FOR id=0,npAtm-1 DO BEGIN ;---Temp+WVap+Ozon+CLW+Rain+Snow+Ice+Graupel+Tskin+SfcP
            IF (DisplAtm[id] eq 1) THEN BEGIN
                xsize = xsize+LengthAtm(id)
            ENDIF
        ENDFOR
        CorrAtm0 = fltarr(xsize,xsize)
        filter   = make_array(xsize,/integer,value=0)
        ii       = -1
        FOR id=0,npAtm-1 DO BEGIN ;---Temp+WVap+Ozon+CLW+Rain+Snow+Ice+Graupel+Tskin+SfcP
            IF (DisplAtm[id] eq 1) THEN BEGIN
                FOR i=IndexAtm(id)-1,IndexAtm(id)-1+LengthAtm(id)-1 DO BEGIN
                    ii           = ii +1
                    filter (ii) = i
                ENDFOR
            ENDIF
        ENDFOR
        FOR i=0,xsize-1 DO BEGIN
            FOR j=0,xsize-1 DO BEGIN
                CorrAtm0(i,j) = CorrAtm(filter(i),filter(j))
            ENDFOR
        ENDFOR
        xsize0          = 800
        ysize0          = 800
        erase
        window,0,xsize=xsize0,ysize=xsize0
        wset,0
        erase,colors.white
        ind=where(DisplAtm eq 1,ncount)
        DescrPar ='Params:'
        FOR i=0,ncount-1 DO BEGIN
            DescrPar=DescrPar+DisplParamAtm(ind(i))
        ENDFOR
        index=findgen(xsize)+1
        sectionDisplay,rot(CorrAtm0,0),'Correlation Matrix for '+strcompress(DescrPar,/remove_all) ,'','(f7.1)',$
          nc,index,index,-1,1,'Parameters Index','Parameters Index',0,xsize0-150,xsize0-190,1.3,IndexAtm(0:npAtm-1)-1,IndexAtm(0:npAtm-1)-1
        captureInAnyFormat,0,fileOut,format
        set_plot,'x'
    ENDIF

    ;-------------Sfc Correlation matrix display
    IF (plot_corrMatrxSfc eq 1) THEN BEGIN
        DisplParamSfc = ['EMIS/','REFL/', 'WINDSP/',  'TSKIN/',  'DELTAT/',  'SFCP/']
        DisplSfc      = [      1,      0,         1,         1,          0,        0] 
        set_plot,'x'
        format         ='png'
        fileout        ='SaSfc.png'
        xsize          = 0
        FOR id=0,npSfc-1 DO BEGIN 
            IF (DisplSfc[id] eq 1) THEN BEGIN
                xsize = xsize+LengthSfc(id)
            ENDIF
        ENDFOR
        CorrSfc0 = fltarr(xsize,xsize)
        filter   = make_array(xsize,/integer,value=0)
        ii       = -1
        FOR id=0,npSfc-1 DO BEGIN 
            IF (DisplSfc[id] eq 1) THEN BEGIN
                FOR i=IndexSfc(id)-1,IndexSfc(id)-1+LengthSfc(id)-1 DO BEGIN
                    ii           = ii +1
                    filter (ii) = i
                ENDFOR
            ENDIF
        ENDFOR
        FOR i=0,xsize-1 DO BEGIN
            FOR j=0,xsize-1 DO BEGIN
                CorrSfc0(i,j) = CorrSfc(filter(i),filter(j))
            ENDFOR
        ENDFOR
        xsize0          = 800
        ysize0          = 800
        erase
        window,0,xsize=xsize0,ysize=xsize0
        wset,0
        erase,colors.white
        ind=where(DisplSfc eq 1,ncount)
        DescrPar ='Params:'
        FOR i=0,ncount-1 DO BEGIN
            DescrPar=DescrPar+DisplParamSfc(ind(i))
        ENDFOR
        index=findgen(xsize)+1
        sectionDisplay,rot(CorrSfc0,0),'Correlation Matrix for '+strcompress(DescrPar,/remove_all) ,'','(f7.1)',$
          nc,index,index,-1,1,'Parameters Index','Parameters Index',0,xsize0-150,xsize0-190,1.3,IndexSfc(0:npSfc-1)-1,IndexSfc(0:npSfc-1)-1
        captureInAnyFormat,0,fileOut,format
        set_plot,'x'
    ENDIF

    ;--------------PDF distributions----------------
    IF (plot_EmissDistr eq 1) THEN BEGIN
        erase
        !p.multi=[6,2,3,0,0]
        iChan2Analyze=[0,2,4,6,8,10]
        xtits=['Emiss value','Emiss Log value']
        FOR i=0,n_elements(iChan2Analyze)-1 DO BEGIN
            x=Emiss(*,iChan2Analyze[i])
            tit='Distribution @ Channel:'+string(iChan2Analyze[i]+1,'(i3)')+' / F:'+string(centrFrq(iChan2Analyze[i]),'(f5.1)')+'GHz'
            plotHist,x,40,tit,xtits[iModeSfc(0)],'PDF',m_sfc(iChan2Analyze[i]),0,min(x),max(x),res,0,0,1.5
        ENDFOR
    ENDIF
    IF (plot_CLWdistr eq 1) THEN BEGIN
        erase
        !p.multi=[6,2,3,0,0]
        iLay2Analyze=[70,75,80,85,90,94]
        xtits=['CLW value', 'CLW log value']
        FOR i=0,n_elements(iLay2Analyze)-1 DO BEGIN
            x=CLW(*,iLay2Analyze[i])
            tit='Distribution @ Layer:'+string(iLay2Analyze[i]+1,'(i3)')+' / P:'+string(mean(pres_lay(*,iLay2Analyze[i])),'(f5.1)')+'mb'
            plotHist,x,40,tit,xtits[iModeAtm(3)],'PDF',m_Atm(IndexAtm(3)-1+iLay2Analyze[i]),0,min(x),max(x),res,0,0,1.5
        ENDFOR
    ENDIF
    IF (plot_WVdistr eq 1) THEN BEGIN
        erase
        !p.multi=[6,2,3,0,0]
        iLay2Analyze=[70,75,80,85,90,94]
        xtits=['WV mix. ratio value','WV mix. ratio Log value']
        FOR i=0,n_elements(iLay2Analyze)-1 DO BEGIN
            x=Abso_Lay(*,iLay2Analyze[i],iH2O)
            tit='Distribution @ Layer:'+string(iLay2Analyze[i]+1,'(i3)')+' / P:'+string(mean(pres_lay(*,iLay2Analyze[i])),'(f5.1)')+'mb'
            plotHist,x,40,tit,xtits[iModeAtm(1)],'PDF',m_Atm(IndexAtm(1)-1+iLay2Analyze[i]),0,min(x),max(x),res,0,0,1.5
        ENDFOR
    ENDIF

    ;--------------EOF reconstructions----------------
    iprof    = 200
    Xatm     = (xArrAtm(iprof,0:nparamsAtm-1))
    Xsfc     = (xArrSfc(iprof,0:nparamsSfc-1))
    IF (plot_Reconstr eq 1) THEN BEGIN
        ;---Atmosphere parameters
        Eig2test = [20,90]
        Reconstr,Xatm,Eig2test,A_Atm(*,*),nparamsAtm,M_Atm(*),X0vec,dX0vec,xmin,xmax,dxmin,dxmax
        FOR id=0,7 DO BEGIN       
            xtit = DescParamAtm[id]+' in '+unitsAtm(id) 
            ytit = 'Pressure [mb]'
            FOR i=0,n_elements(Eig2test)-1 DO BEGIN
                tit  = 'Use of '+string(Eig2Test[i],'(i4)')+'  Eigenvalues'
                plotVec,Xatm(IndexAtm(id)-1:IndexAtm(id)-1+LengthAtm(id)-1),pres_lay(iprof,*),$
                  X0vec[i,IndexAtm(id)-1:IndexAtm(id)-1+LengthAtm(id)-1],[xmin,xmax],[dxmin,dxmax],[4-i*2,2,2,0,0],[3-i*2,2,2,0,0],$
                  xtit,ytit,tit,0
            ENDFOR
        ENDFOR
        ;---Surface parameters
        Eig2test = [2,20]
        id   = 0 ;Emissivity
        ytit = DescParamSfc[id]+' in '+unitsSfc(id) 
        xtit = 'Frequency [GHz]'
        Reconstr,Xsfc,Eig2test,A_Sfc(*,*),nparamsSfc,M_Sfc(*),X0vec,dX0vec,xmin,xmax,dxmin,dxmax
        FOR i=0,n_elements(Eig2test)-1 DO BEGIN
            tit  = 'Use of '+string(Eig2Test[i],'(i4)')+'  Eigenvalues'
            !p.multi=[4-i*2,2,2,0,0]
            plot,centrFrq,Xsfc(IndexSfc(id)-1:IndexSfc(id)-1+LengthSfc(id)-1),xtitle=xtit,ytitle=ytit,title=tit
            oplot,centrFrq,X0vec[i,IndexSfc(id)-1:IndexSfc(id)-1+LengthSfc(id)-1],linestyle=2
            !p.multi=[3-i*2,2,2,0,0]
            plot,CentrFrq,Xsfc(IndexSfc(id)-1:IndexSfc(id)-1+LengthSfc(id)-1)-$
              X0vec[i,IndexSfc(id)-1:IndexSfc(id)-1+LengthSfc(id)-1],xtitle='Difference Original-Reconstructed'
        ENDFOR
    ENDIF



    IF (plot_ReconstrSfcParams eq 1) THEN BEGIN
        erase
        !p.multi=[3,1,3,0,0]
        TskinReconstr  = fltarr(nprofiles)
        WindSpReconstr = fltarr(nprofiles)
        DeltaTReconstr = fltarr(nprofiles)
        id_tskin       = 8
        id_wspeed      = 2
        id_deltat      = 4
        FOR iprof=0L,nprofiles-1 DO begin
            Xatm     = (xArrAtm(iprof,0:nparamsAtm-1))
            Xsfc     = (xArrSfc(iprof,0:nparamsSfc-1))
            Reconstr,Xatm,[1],A_Atm(*,*),nparamsAtm,M_Atm(*),X0vec,dX0vec,xmin,xmax,dxmin,dxmax
            TskinReconstr(iprof) = X0vec(0,IndexAtm(id_tskin)-1)
            ;Reconstr,Xsfc,[1],A_Sfc(*,*),nparamsSfc,M_Sfc(*),X0vec,dX0vec,xmin,xmax,dxmin,dxmax
            ;WindSpReconstr(iprof) = X0vec(0,IndexSfc(id_wspeed)-1)
            ;DeltaTReconstr(iprof) = X0vec(0,IndexSfc(id_deltat)-1)
        ENDFOR
        ;----Tskin
        ytit = 'Tskin Difference [K] (orig. - Reconstr.)'
        xtit = 'Profile Index'
        plot,xArrAtm(0:nProfiles-1,IndexAtm(id_tskin)-1)-TskinReconstr(0:nProfiles-1),xtitle=xtit,ytitle=ytit
        ;----Wind Speed
        ;ytit = 'Wind Speed Difference [m/s] (orig. - Reconstr.)'
        ;xtit = 'Profile Index'
        ;plot,xArrSfc(0:nProfiles-1,IndexSfc(id_wspeed)-1)-WindSpReconstr(0:nProfiles-1),xtitle=xtit,ytitle=ytit
        ;----Air-Sea Temper Difference
        ;ytit = 'DeltaT Difference [K] (orig. - Reconstr.)'
        ;xtit = 'Profile Index'
        ;plot,xArrSfc(0:nProfiles-1,IndexSfc(id_wspeed)-1)-DeltaTReconstr(0:nProfiles-1),xtitle=xtit,ytitle=ytit
    ENDIF




    IF (plot_SfcParams eq 1) THEN BEGIN
        erase
        !p.multi=[3,1,3,0,0]
        plot,Tskin,ytitle='Tskin [K]',yrange=[min(Tskin),max(Tskin)],$
          xtitle='Profile Index',charsize=1.7,xstyle=1,thick=1
        plot,WindSp,ytitle='Wind Speed [m/s]',$
          xtitle='Profile Index',charsize=1.7,xstyle=1,thick=1
        plot,DeltaT,ytitle='Air-Surface Temp Gradient [K]',$
          xtitle='Profile Index',charsize=1.7,xstyle=1,thick=1
    ENDIF

    

    IF (plot_EmissSpectra eq 1) THEN BEGIN
        erase
        !p.multi=1
        y=Emiss
        plot,CentrFrq,y(0,*),ytitle='Emissivity',yrange=[0.2,1],$
          xtitle='Centr. Frequency (GHz)',charsize=1.7,xstyle=1,thick=1
        FOR i=1L,nprofiles-1 DO BEGIN
            IF ((i mod 1) eq 0) THEN BEGIN

                oplot,CentrFrq,y(i,*),thick=1
            ENDIF
        ENDFOR
    ENDIF



    IF (plot_WVapProfiles eq 1) THEN BEGIN
        erase
        !p.multi=1
        ind=where(pres_lay(0,*) le SfcPres(0))
        plot,exp(Abso_lay(0,ind,iH2O)),pres_lay(0,ind),xtitle='Water Vapor Mix Ratio [g/Kg]',$
          ytitle='Pressure [mb]',yrange=[1000,0.1],charsize=1.7,$
          xrange=[0,30],xstyle=1,thick=1
        FOR i=1L,nprofiles-1 DO BEGIN
            IF ((i mod 1) eq 0) THEN BEGIN
                ind=where(pres_lay(i,*) le SfcPres(i))
                oplot,exp(Abso_lay(i,ind,iH2O)),pres_lay(i,ind),thick=1
            ENDIF
        ENDFOR
        indMean = where(pres_lay(0,*) le M_Atm(IndexAtm(9)-1))
        Q   = exp(M_Atm(IndexAtm(1)-1:IndexAtm(1)-1+lengthAtm(1)-1))
        oplot,Q(indMean),pres_lay(0,indMean),thick=3,color=240
        erase
        !p.multi=1
        ind=where(pres_lay(0,*) le SfcPres(0))
        plot,exp(Abso_lay(0,ind,iH2O)),pres_lay(0,ind),xtitle='Water Vapor Mix Ratio [g/Kg]',$
          ytitle='Pressure [mb]',yrange=[1000,0.1],charsize=1.7,$
          xrange=[0,30],xstyle=1,thick=1,/xlog
        FOR i=1L,nprofiles-1 DO BEGIN
            IF ((i mod 1) eq 0) THEN BEGIN
                ind=where(pres_lay(i,*) le SfcPres(i))
                oplot,exp(Abso_lay(i,ind,iH2O)),pres_lay(i,ind),thick=1
            ENDIF
        ENDFOR
        oplot,Q(indMean),pres_lay(0,indMean),thick=3,color=240
    ENDIF



    IF (plot_OzonProfiles eq 1) THEN BEGIN
        erase
        !p.multi=1
        ind=where(pres_lay(0,*) le SfcPres(0))
        plot,Abso_lay(0,ind,iO3),pres_lay(0,ind),xtitle='Ozone Mix Ratio [g/Kg]',$
          ytitle='Pressure [mb]',yrange=[1000,0.1],charsize=1.7,$
          xrange=[min(Abso_lay(*,*,iO3)),max(Abso_lay(*,*,iO3))],xstyle=1,thick=1,/ylog
        FOR i=1L,nprofiles-1 DO BEGIN
            IF ((i mod 1) eq 0) THEN BEGIN
                ind=where(pres_lay(i,*) le SfcPres(i))
                oplot,Abso_lay(i,ind,iO3),pres_lay(i,ind),thick=1
            ENDIF
        ENDFOR
        indMean = where(pres_lay(0,*) le M_Atm(IndexAtm(9)-1))
        O3   = exp(M_Atm(IndexAtm(2)-1:IndexAtm(2)-1+lengthAtm(2)-1))
        oplot,O3(indMean),pres_lay(0,indMean),thick=3,color=240
    ENDIF



    IF (plot_TempProfiles eq 1) THEN BEGIN
        erase
        !p.multi=1
        ind=where(pres_lay(0,*) le SfcPres(0))
        plot,Temp_Lay(0,ind),pres_lay(0,ind),xtitle='Temperature [K]',ytitle='Pressure [mb]',/ylog,$
          yrange=[1000,0.1],charsize=1.7,$
          xrange=[170,330],xstyle=1,thick=1
        FOR i=1L,nprofiles-1 DO BEGIN
            IF ((i mod 1) eq 0) THEN BEGIN
                ind=where(pres_lay(i,*) le SfcPres(i))
                oplot,Temp_Lay(i,ind),pres_lay(i,ind),thick=1
            ENDIF
        ENDFOR
        indMean = where(pres_lay(0,*) le M_Atm(IndexAtm(9)-1))
        T   = M_Atm(IndexAtm(0)-1:IndexAtm(0)-1+lengthAtm(0)-1)
        oplot,T(indMean),pres_lay(0,indMean),thick=3,color=240
    ENDIF



    IF (plot_ClwProfiles eq 1) THEN BEGIN
        erase
        !p.multi=1
        ind=where(pres_lay(0,*) le SfcPres(0))
        plot,exp(clw(0,ind)),pres_lay(0,ind),xtitle='CLW [mm]',ytitle='Pressure [mb]',$
          yrange=[1000,0.1],charsize=1.7,$
          xrange=[0,0.2],xstyle=1,thick=1
        FOR i=1L,nprofiles-1 DO BEGIN
            IF ((i mod 1) eq 0) THEN BEGIN
                ind=where(pres_lay(i,*) le SfcPres(i))
                oplot,exp(clw(i,ind)),pres_lay(i,ind),thick=1
            ENDIF
        ENDFOR
        indMean = where(pres_lay(0,*) le M_Atm(IndexAtm(9)-1))
        C   = M_Atm(IndexAtm(3)-1:IndexAtm(3)-1+lengthAtm(3)-1)
        oplot,exp(C(indMean)),pres_lay(0,indMean),thick=3,color=240
    ENDIF



    IF (plot_RainProfiles eq 1) THEN BEGIN
        erase
        !p.multi=1
        x=exp(rain)
        ind=where(pres_lay(0,*) le SfcPres(0))
        plot,x(0,ind),pres_lay(0,ind),xtitle='Rain [mm]',ytitle='Pressure [mb]',$
          yrange=[1000,0.1],charsize=1.7,$
          xrange=[max([min(x),-30]),max(x)],xstyle=1,thick=1
        FOR i=1L,nprofiles-1 DO BEGIN
            IF ((i mod 1) eq 0) THEN BEGIN
                ind=where(pres_lay(i,*) le SfcPres(i))
                oplot,x(i,ind),pres_lay(i,ind),thick=1
            ENDIF
        ENDFOR
        indMean = where(pres_lay(0,*) le M_Atm(IndexAtm(9)-1))
        R   = M_Atm(IndexAtm(4)-1:IndexAtm(4)-1+lengthAtm(4)-1)
        oplot,exp(R(indMean)),pres_lay(0,indMean),thick=3,color=240
    ENDIF


    IF (plot_SnowProfiles eq 1) THEN BEGIN
        erase
        !p.multi=1
        x=exp(snow)
        ;x=(snow)
        ind=where(pres_lay(0,*) le SfcPres(0))
        plot,x(0,ind),pres_lay(0,ind),xtitle='Snow [mm]',ytitle='Pressure [mb]',$
          yrange=[1000,0.1],charsize=1.7,$
          xrange=[max([min(x),-30]),max(x)],xstyle=1,thick=1
        FOR i=1L,nprofiles-1 DO BEGIN
            IF ((i mod 1) eq 0) THEN BEGIN
                ind=where(pres_lay(i,*) le SfcPres(i))
                oplot,x(i,ind),pres_lay(i,ind),thick=1
            ENDIF
        ENDFOR
        indMean = where(pres_lay(0,*) le M_Atm(IndexAtm(9)-1))
        S   = M_Atm(IndexAtm(5)-1:IndexAtm(5)-1+lengthAtm(5)-1)
        oplot,exp(S(indMean)),pres_lay(0,indMean),thick=3,color=240
    ENDIF



    IF (plot_IceProfiles eq 1) THEN BEGIN
        erase
        !p.multi=1
        x=exp(ice)
        ;x=(ice)
        ind=where(pres_lay(0,*) le SfcPres(0))
        plot,x(0,ind),pres_lay(0,ind),xtitle='Ice [mm]',ytitle='Pressure [mb]',$
          yrange=[1000,0.1],charsize=1.7,$
          xrange=[max([min(x),-30]),max(x)],xstyle=1,thick=1
        FOR i=1L,nprofiles-1 DO BEGIN
            IF ((i mod 1) eq 0) THEN BEGIN
                ind=where(pres_lay(i,*) le SfcPres(i))
                oplot,x(i,ind),pres_lay(i,ind),thick=1
            ENDIF
        ENDFOR
        indMean = where(pres_lay(0,*) le M_Atm(IndexAtm(9)-1))
        I   = M_Atm(IndexAtm(6)-1:IndexAtm(6)-1+lengthAtm(6)-1)
        oplot,exp(I(indMean)),pres_lay(0,indMean),thick=3,color=240
    ENDIF


    IF (plot_GrplProfiles eq 1) THEN BEGIN
        erase
        !p.multi=1
        x=exp(grpl)
        ;x=(grpl)
        ind=where(pres_lay(0,*) le SfcPres(0))
        plot,x(0,ind),pres_lay(0,ind),xtitle='Graupel [mm]',ytitle='Pressure [mb]',$
          yrange=[1000,0.1],charsize=1.7,$
          xrange=[max([min(x),-30]),max(x)],xstyle=1,thick=1
        FOR i=1L,nprofiles-1 DO BEGIN
            IF ((i mod 1) eq 0) THEN BEGIN
                ind=where(pres_lay(i,*) le SfcPres(i))
                oplot,x(i,ind),pres_lay(i,ind),thick=1
            ENDIF
        ENDFOR
        indMean = where(pres_lay(0,*) le M_Atm(IndexAtm(9)-1))
        G   = M_Atm(IndexAtm(7)-1:IndexAtm(7)-1+lengthAtm(7)-1)
        oplot,exp(G(indMean)),pres_lay(0,indMean),thick=3,color=240
    ENDIF


    IF (impr eq 1) THEN begin
        close,/all
        device ='x'
        GOTO, bo
    ENDIF
    Print,'________________________________________________'
    boucle:print,'PS/Exit(1/0)'
    read,impr
    IF (impr gt 3) THEN GOTO, boucle
    IF (impr eq 0) THEN GOTO, bo
ip: IF (impr eq 1) THEN BEGIN
        ficres='visu.ps'
        print,' PostScript File created:',ficres
        set_plot,'ps'
        device,filename=ficres,/color,ysize=23,xsize=16,yoffset=2,/portrait
        goto,imp
    ENDIF
    bo: print,'________________________________________________'
    impr=0
    device = 'x'
    set_plot,'x'
    fin:close,/all
    print,'End of procesing...'

END
