;-------------------------------------------------------------------------------
; File containing a set of subroutines needed for the program
; covMatrx.pro that generates covariance matrix based on geophysical data
;-------------------------------------------------------------------------------

PRO TransfParams,Temp_Lay,Abso_Lay,clw,rain,snow,ice,grpl,Tskin,SfcPres,Emiss,Refl,windsp,DeltaT,iModeAtm,$
                 iModeSfc,nProfiles,nLay,nchan,iH2O,iO3
   x=Temp_Lay(*,*)      & OptionalTransfIntoLogArr,iModeAtm(0),nProfiles,nLay,x      & Temp_Lay(*,*)      = x
   x=Abso_Lay(*,*,iH2O) & OptionalTransfIntoLogArr,iModeAtm(1),nProfiles,nLay,x      & Abso_Lay(*,*,iH2O) = x
   x=Abso_Lay(*,*,iO3)  & OptionalTransfIntoLogArr,iModeAtm(2),nProfiles,nLay,x      & Abso_Lay(*,*,iO3)  = x
   x=clw(*,*)           & OptionalTransfIntoLogArr,iModeAtm(3),nProfiles,nLay,x      & clw(*,*)           = x
   x=rain(*,*)          & OptionalTransfIntoLogArr,iModeAtm(4),nProfiles,nLay,x      & rain(*,*)          = x
   x=snow(*,*)          & OptionalTransfIntoLogArr,iModeAtm(5),nProfiles,nLay,x      & snow(*,*)          = x
   x=ice(*,*)           & OptionalTransfIntoLogArr,iModeAtm(6),nProfiles,nLay,x      & ice(*,*)           = x
   x=grpl(*,*)          & OptionalTransfIntoLogArr,iModeAtm(7),nProfiles,nLay,x      & grpl(*,*)          = x
   x=Tskin(*)           & OptionalTransfIntoLogVec,iModeAtm(8),nProfiles,x           & Tskin(*)           = x
   x=SfcPres(*)         & OptionalTransfIntoLogVec,iModeAtm(9),nProfiles,x           & SfcPres(*)         = x
   x=Emiss(*,*)         & OptionalTransfIntoLogArr,iModeSfc(0),nProfiles,nchan,x     & Emiss(*,*)         = x
   x=Refl(*,*)          & OptionalTransfIntoLogArr,iModeSfc(1),nProfiles,nchan,x     & Refl(*,*)          = x
   x=windsp(*)          & OptionalTransfIntoLogVec,iModeSfc(2),nProfiles,x           & windsp(*)          = x
   x=DeltaT(*)          & OptionalTransfIntoLogVec,iModeSfc(4),nProfiles,x           & DeltaT(*)          = x
END

PRO putTogetherX,xArrAtm,xArrSfc,nprofiles,nchan,nparamsAtm,nparamsSfc,iH2O,iO3,IndexAtm,IndexSfc,LengthAtm,$
                 LengthSfc,Temp_Lay,Abso_Lay,clw,rain,snow,ice,grpl,Tskin,SfcPres,Emiss,Refl,windsp
   xArrAtm = fltarr(nprofiles,nparamsAtm)
   xArrSfc = fltarr(nprofiles,nparamsSfc)
   ;----Atmospheric state vector
   xArrAtm(0:nprofiles-1,IndexAtm(0)-1:IndexAtm(0)-1+LengthAtm(0)-1) = Temp_Lay(0:nprofiles-1,0:LengthAtm(0)-1) ;Temperature
   xArrAtm(0:nprofiles-1,IndexAtm(1)-1:IndexAtm(1)-1+LengthAtm(1)-1) = Abso_Lay(0:nprofiles-1,0:LengthAtm(1)-1,iH2O) ;Moisture
   xArrAtm(0:nprofiles-1,IndexAtm(2)-1:IndexAtm(2)-1+LengthAtm(2)-1) = Abso_Lay(0:nprofiles-1,0:LengthAtm(2)-1,iO3) ;Ozone
   xArrAtm(0:nprofiles-1,IndexAtm(3)-1:IndexAtm(3)-1+LengthAtm(3)-1) = clw(0:nprofiles-1,0:LengthAtm(3)-1) ;clw
   xArrAtm(0:nprofiles-1,IndexAtm(4)-1:IndexAtm(4)-1+LengthAtm(4)-1) = rain(0:nprofiles-1,0:LengthAtm(4)-1) ;rain
   xArrAtm(0:nprofiles-1,IndexAtm(5)-1:IndexAtm(5)-1+LengthAtm(5)-1) = snow(0:nprofiles-1,0:LengthAtm(5)-1) ;snow
   xArrAtm(0:nprofiles-1,IndexAtm(6)-1:IndexAtm(6)-1+LengthAtm(6)-1) = ice(0:nprofiles-1,0:LengthAtm(6)-1) ;ice
   xArrAtm(0:nprofiles-1,IndexAtm(7)-1:IndexAtm(7)-1+LengthAtm(7)-1) = grpl(0:nprofiles-1,0:LengthAtm(7)-1) ;graupel
   xArrAtm(0:nprofiles-1,IndexAtm(8)-1:IndexAtm(8)-1+LengthAtm(8)-1) = Tskin(0:nprofiles-1) ;Tskin
   xArrAtm(0:nprofiles-1,IndexAtm(9)-1:IndexAtm(9)-1+LengthAtm(9)-1) = SfcPres(0:nprofiles-1) ;sfcPress
   ;----Surface state vector
   xArrSfc(0:nprofiles-1,IndexSfc(0)-1:IndexSfc(0)-1+LengthSfc(0)-1) = Emiss(0:nprofiles-1,0:LengthSfc(0)-1) ;Emissivity
   xArrSfc(0:nprofiles-1,IndexSfc(1)-1:IndexSfc(1)-1+LengthSfc(1)-1) = Refl(0:nprofiles-1,0:LengthSfc(1)-1) ;Reflectivity
   xArrSfc(0:nprofiles-1,IndexSfc(2)-1:IndexSfc(2)-1+LengthSfc(2)-1) = windsp(0:nprofiles-1) ;Wind speed
   xArrSfc(0:nprofiles-1,IndexSfc(3)-1:IndexSfc(3)-1+LengthSfc(3)-1) = Tskin(0:nprofiles-1) ;Tskin
   xArrSfc(0:nprofiles-1,IndexSfc(4)-1:IndexSfc(4)-1+LengthSfc(4)-1) = SfcPres(0:nprofiles-1) ;Sfc Pressure
END

PRO putTogetherTb,xArrRad,nprofiles,nchan,nparamsRad,IndexRad,LengthRad,Tb
   xArrRad = fltarr(nprofiles,nparamsRad)
   ;----brightness temperature vector
   xArrRad(0:nprofiles-1,IndexRad(0)-1:IndexRad(0)-1+LengthRad(0)-1) = Tb(0:nprofiles-1,0:LengthRad(0)-1)
END


PRO consistCheck,nlay,nlev,nchan,nAbsorb,nParmCLW,nParmRain,nParmSnow,nParmIce,            $
                 nParmGrpl,AbsorbID,CentrFrq,Polarty,iH2o,iO3,nlay2,nlev2,nchan2,nAbsorb2,nParmCLW2,  $
                 nParmRain2,nParmSnow2,nParmIce2,nParmGrpl2,AbsorbID2,CentrFrq2,Polarty2,iH2o_2,iO3_2
   IF (nlay ne nlay2)           THEN STOP,'Error in consistency between dataset1 and dataset2. #1'
   IF (nlev ne nlev2)           THEN STOP,'Error in consistency between dataset1 and dataset2. #2'
   IF (nchan ne nchan2)         THEN STOP,'Error in consistency between dataset1 and dataset2. #3'
   IF (nAbsorb ne nAbsorb2)     THEN STOP,'Error in consistency between dataset1 and dataset2. #4'
   IF (nParmCLW ne nParmCLW2)   THEN STOP,'Error in consistency between dataset1 and dataset2. #5'
   IF (nParmRain ne nParmRain2) THEN STOP,'Error in consistency between dataset1 and dataset2. #6'
   IF (nParmSnow ne nParmSnow2) THEN STOP,'Error in consistency between dataset1 and dataset2. #7'
   IF (nParmIce ne nParmIce2)   THEN STOP,'Error in consistency between dataset1 and dataset2. #8'
   IF (nParmGrpl ne nParmGrpl2) THEN STOP,'Error in consistency between dataset1 and dataset2. #9'
   FOR i=0,nAbsorb-1 DO BEGIN
       IF (AbsorbID(i) ne AbsorbID2(i))   THEN STOP,'Error in consistency between dataset1 and dataset2. #10'
   ENDFOR
   FOR i=0,nchan-1 DO BEGIN
       IF (ABS(CentrFrq(i)-CentrFrq2(i)) ge 0.01) THEN STOP,'Error in consistency between dataset1 and dataset2. #11'
       IF (Polarty(i) ne Polarty2(i))             THEN STOP,'Error in consistency between dataset1 and dataset2. #12'
   ENDFOR
END

PRO SfcTypeSelect,ichoiceSfcTyp,extSfcTyp
   ;-------------------------------------------------------------------
   ;     Surface Type Selection
   ;-------------------------------------------------------------------
   print, 'Choose Surface Type:'
   print, '0: Water (open ocean)' 
   print, '1: Sea Ice' 
   print, '2: Land (snow-free)'
   print, '3: Snow'
   print, '4: Desert'
   read,  prompt='Choice:',ichoiceSfcTyp
   IF (ichoiceSfcTyp eq 0) THEN extSfcTyp='oc'
   IF (ichoiceSfcTyp eq 1) THEN extSfcTyp='ic'
   IF (ichoiceSfcTyp eq 2) THEN extSfcTyp='ld'
   IF (ichoiceSfcTyp eq 3) THEN extSfcTyp='sn'
   IF (ichoiceSfcTyp eq 4) THEN extSfcTyp='ds'
   print, '---------------------------------------------'
END

PRO SelectParams,npAtm,DescParamAtm,iModeAtm,npSfc,DescParamSfc,iModeSfc,iCorrAtmTskin,iCorrAtmSfcP
   ;-------------------------------------------------------------------
   ;    General info + selection of selection mode (geophysical or Log space)
   ;-------------------------------------------------------------------
   npAtm        = 10            ;#parameters: T+WV+O3+CLW+Rain+Snow+Ice+Graupel+'TSKIN+SFCP
   DescParamAtm = ['TEMP', 'WVAP',  'OZON', 'CLW',   'RAIN',   'SNOW', 'ICE', 'GRPL', 'TSKIN', 'SFCP']
   iModeAtm     = [0,        1,       0,      1,       1,        1,      1,     1,       0,       0  ] ;=0->geoph, 1->Log-space
   npSfc        = 6 ;#parameters: Emiss+Refl+WindSp+Tskin+DeltaT+SfcPres
   DescParamSfc = ['EMIS',  'REFL', 'WINDSP','TSKIN','DELTAT', 'SFCP' ]
   iModeSfc     = [0,        0,       0,      0,       0,        0    ]       ;=0->geoph (x)-space,1->Log(x)-space, 2->Log(-Log(x)) space
   ;-------------------------------------------------------------
   ; The Tskin is put on both the surface covariance and the
   ; atmospheric one. In the atmospheric one, it could be
   ; determined from the temperature source or the Q source.
   ; The choice of which parameter (T or Q) to correlate Tskin
   ; with is determined by the following parameter
   ;-------------------------------------------------------------
   iCorrAtmTskin=1 ;0-> No correlation =1-> correlate with T, =2-> correlate with Q
   ;-------------------------------------------------------------
   ; The SFCP is put on both the surface covariance and the
   ; atmospheric one. In the atmospheric one, it could be
   ; determined from the temperature source or the Q source.
   ; The choice of which parameter (T or Q) to correlate sfcP
   ; with is determined by the following parameter
   ;-------------------------------------------------------------
   iCorrAtmSfcP=0 ;0-> No correlation =1-> correlate with T, =2-> correlate with Q
END

PRO InstrConfigSelect,ichoiceInstr,SubDir
   ;-------------------------------------------------------------------
   ;     Instrument configuration Selection
   ;-------------------------------------------------------------------
   print, 'Choose Instrumental configuration:'
   print, '1: ATMS'
   print, '2: SSMI/S'
   print, '3: NOAA-18 AMSUA/MHS'
   print, '4: WindSat'
   read,  prompt='Choice:',ichoiceInstr
   IF (ichoiceInstr eq 1) THEN SubDir='npp_atms'
   IF (ichoiceInstr eq 2) THEN SubDir='f16_ssmis'
   IF (ichoiceInstr eq 3) THEN SubDir='n18_amsua_mhs'
   IF (ichoiceInstr eq 4) THEN SubDir='coriolis_windsat'
   print, '---------------------------------------------'
END

PRO DataSourcesSelect,ichoice_atm_non_Cloud_T,ichoice_atm_non_Cloud_Q,ichoice_precip_cloud,ichoice_sfc,extAtm_T,extAtm_Q,extCld,extSfc
    ;-------------------------------------------------------------------
    ;     Data-source selection (for Temperature atmospheric parameters)
    ;-------------------------------------------------------------------
    print, 'Choose data source for the ATM (temperature) parameters:'
    print, '1: NOAA-88 '   
    print, '2: MM5 '
    print, '3: ECMWF'
    print, '4: noaa88+ecmwf'
    print, '5: gdas'
    read,  prompt='Choice:',ichoice_atm_non_Cloud_T
    print, '---------------------------------------------'
    IF (ichoice_atm_non_Cloud_T eq 1) THEN extAtm_T='noaa88'
    IF (ichoice_atm_non_Cloud_T eq 2) THEN extAtm_T='mm5'
    IF (ichoice_atm_non_Cloud_T eq 3) THEN extAtm_T='ecmwf'
    IF (ichoice_atm_non_Cloud_T eq 4) THEN extAtm_T='noaa88+ecmwf'
    IF (ichoice_atm_non_Cloud_T eq 5) THEN extAtm_T='gdas'
    ;-------------------------------------------------------------------
    ;     Data-source selection (for WV atmospheric parameters)
    ;-------------------------------------------------------------------
    print, 'Choose data source for the ATM (water vapor) parameters:'
    print, '1: NOAA-88 '   
    print, '2: MM5 '
    print, '3: ECMWF'
    print, '4: noaa88+ecmwf'
    print, '5: gdas'
    read,  prompt='Choice:',ichoice_atm_non_Cloud_Q
    print, '---------------------------------------------'
    IF (ichoice_atm_non_Cloud_Q eq 1) THEN extAtm_Q='noaa88'
    IF (ichoice_atm_non_Cloud_Q eq 2) THEN extAtm_Q='mm5'
    IF (ichoice_atm_non_Cloud_Q eq 3) THEN extAtm_Q='ecmwf'
    IF (ichoice_atm_non_Cloud_Q eq 4) THEN extAtm_Q='noaa88+ecmwf'
    IF (ichoice_atm_non_Cloud_Q eq 5) THEN extAtm_Q='gdas'
    ;-------------------------------------------------------------------
    ;     Data-source selection (for cloud/precip parameters)
    ;-------------------------------------------------------------------
    print, 'Choose data source for the cloud/precip parameters:'
    print, '1: NOAA-88 '   
    print, '2: MM5 '
    print, '3: ECMWF'
    print, '4: noaa88+ecmwf'
    print, '5: gdas'
    read,  prompt='Choice:',ichoice_precip_cloud
    print, '---------------------------------------------'
    IF (ichoice_precip_Cloud eq 1) THEN extCld='noaa88'
    IF (ichoice_precip_Cloud eq 2) THEN extCld='mm5'
    IF (ichoice_precip_Cloud eq 3) THEN extCld='ecmwf'
    IF (ichoice_precip_Cloud eq 4) THEN extCld='noaa88+ecmwf'
    IF (ichoice_precip_Cloud eq 5) THEN extCld='gdas'

    ;-------------------------------------------------------------------
    ;     Data-source selection (for surface parameters)
    ;-------------------------------------------------------------------
    print, 'Choose data source for the surface parameters:'
    print, '1: NOAA-88 '   
    print, '2: MM5 '
    print, '3: ECMWF'
    print, '4: noaa88+ecmwf'
    print, '5: gdas'
    read,  prompt='Choice:',ichoice_sfc
    print, '---------------------------------------------'
    IF (ichoice_sfc eq 1) THEN extSfc='noaa88'
    IF (ichoice_sfc eq 2) THEN extSfc='mm5'
    IF (ichoice_sfc eq 3) THEN extSfc='ecmwf'
    IF (ichoice_sfc eq 4) THEN extSfc='noaa88+ecmwf'
    IF (ichoice_sfc eq 5) THEN extSfc='gdas'
END



PRO ConstructAtm,atm,iTemp,iWvap,iOzon,iClw,iRain,iSnow,iIce,iGrpl,NEIGENV_temp,$
  NEIGENV_wvap,NEIGENV_ozon,NEIGENV_clw,NEIGENV_rain,NEIGENV_snow,NEIGENV_ice,NEIGENV_grpl,$
  Temp,Wvap,Ozon,Clw,Rain,snow,ice,grpl
  atm(iTemp:iTemp+NEIGENV_temp-1,iTemp:iTemp+NEIGENV_temp-1) = Temp(0:NEIGENV_temp-1,0:NEIGENV_temp-1)
  atm(iWvap:iWvap+NEIGENV_wvap-1,iWvap:iWvap+NEIGENV_wvap-1) = Wvap(0:NEIGENV_wvap-1,0:NEIGENV_wvap-1)
  atm(iOzon:iOzon+NEIGENV_ozon-1,iOzon:iOzon+NEIGENV_ozon-1) = Ozon(0:NEIGENV_ozon-1,0:NEIGENV_ozon-1)
  atm(iClw:iClw+NEIGENV_clw-1,   iClw:iClw+NEIGENV_clw-1)    = Clw(0:NEIGENV_clw-1,  0:NEIGENV_clw-1 )
  atm(iRain:iRain+NEIGENV_rain-1,iRain:iRain+NEIGENV_rain-1) = Rain(0:NEIGENV_rain-1,0:NEIGENV_rain-1)
  atm(iSnow:iSnow+NEIGENV_snow-1,iSnow:iSnow+NEIGENV_snow-1) = snow(0:NEIGENV_snow-1,0:NEIGENV_snow-1)
  atm(iIce:iIce+NEIGENV_ice-1,   iIce:iIce+NEIGENV_ice-1)    = ice(0:NEIGENV_ice-1,  0:NEIGENV_ice-1 )
  atm(iGrpl:iGrpl+NEIGENV_grpl-1,iGrpl:iGrpl+NEIGENV_grpl-1) = grpl(0:NEIGENV_grpl-1,0:NEIGENV_grpl-1)
END

PRO ConstructSfc,sfc,iEmiss,iRefl,iWindSp,iTskin,iDeltaT,iSfcPres,NEIGENV_Emiss,$
  NEIGENV_refl,NEIGENV_windsp,NEIGENV_tskin,NEIGENV_deltat,NEIGENV_SfcPres,$
  Emiss,Refl,WindSp,Tskin,deltaT,SfcPres
  sfc(iEmiss:iEmiss+NEIGENV_emiss-1,iEmiss:iEmiss+NEIGENV_emiss-1) = Emiss(0:NEIGENV_emiss-1,0:NEIGENV_emiss-1)
  sfc(iRefl:iRefl+NEIGENV_refl-1,iRefl:iRefl+NEIGENV_refl-1)       = Refl(0:NEIGENV_refl-1,0:NEIGENV_refl-1)
  sfc(iWindSp:iWindSp+NEIGENV_windsp-1,iWindSp:iWindSp+NEIGENV_WindSp-1) = WindSp(0:NEIGENV_windsp-1,0:NEIGENV_windsp-1)
  sfc(iTskin:iTskin+NEIGENV_tskin-1,iTskin:iTskin+NEIGENV_tskin-1) = Tskin(0:NEIGENV_tskin-1,0:NEIGENV_tskin-1)
  sfc(iDeltaT:iDeltaT+NEIGENV_deltat-1,iDeltaT:iDeltaT+NEIGENV_deltat-1) = DeltaT(0:NEIGENV_deltat-1,0:NEIGENV_deltat-1)
  sfc(iSfcPres:iSfcPres+NEIGENV_SfcPres-1,iSfcPres:iSfcPres+NEIGENV_SfcPres-1) = SfcPres(0:NEIGENV_sfcPres-1,0:NEIGENV_sfcPres-1)
END


PRO PlotReconstr,xVec,Eig2Test,A,NEIGENV,M,xtit,ytit,press
  erase
  ;---Project profile into EIGENV space and back into geoph. space
  X        = transpose(xVec)
  n2test   = n_elements(Eig2Test)
  X0vec    = fltarr(n2test,n_elements(X))
  dX0vec   = fltarr(n2test,n_elements(X))
  FOR i=0,n2test-1 DO BEGIN
      ProjectAndRecover,X,A[*,NEIGENV-Eig2Test[i]:NEIGENV-1],X0,M
      X0vec[i,*]  = X0
      dX0vec[i,*] = X-X0
  ENDFOR
  xmin  = min([min(X),min(X0vec)])
  xmax  = max([max(X),max(X0vec)])
  dxmin = min(dX0vec)
  dxmax = max(dX0vec)
  FOR i=0,n2test-1 DO BEGIN
      tit  = 'Use of '+string(Eig2Test[i],'(i4)')+'  Eigenvalues'
      ;plotVec,X,press,X0vec[i,*],[xmin,xmax],[dxmin,dxmax],[16-i*2,4,4,0,0],[15-i*2,4,4,0,0],$
      ;  xtit,ytit,tit,0
      plotVec,X,press,X0vec[i,*],[xmin,xmax],[dxmin,dxmax],[4-i*2,2,2,0,0],[3-i*2,2,2,0,0],$
        xtit,ytit,tit,0
  ENDFOR
END

PRO Reconstr,xVec,Eig2Test,A,NEIGENV,M,X0vec,dX0vec,xmin,xmax,dxmin,dxmax
  erase
  ;---Project profile into EIGENV space and back into geoph. space
  X        = transpose(xVec)
  n2test   = n_elements(Eig2Test)
  X0vec    = fltarr(n2test,n_elements(X))
  dX0vec   = fltarr(n2test,n_elements(X))
  FOR i=0,n2test-1 DO BEGIN
      ProjectAndRecover,X,A[*,NEIGENV-Eig2Test[i]:NEIGENV-1],X0,M
      X0vec[i,*]  = X0
      dX0vec[i,*] = X-X0
  ENDFOR
  xmin  = min([min(X),min(X0vec)])
  xmax  = max([max(X),max(X0vec)])
  dxmin = min(dX0vec)
  dxmax = max(dX0vec)
END


PRO ProjectAndRecover,X,A,X0,M
  ;---First projection (of the vector X)
  ;Xtilda  = matrix_multiply(transpose(A),X)
  ;X0      = matrix_multiply(A,Xtilda)
  ;--Second projection (of the departure of X from M)
  Xtilda  = matrix_multiply(transpose(A),X-M)
  X0      = matrix_multiply(A,Xtilda)+M
END

