@/net/orbit041l/disk2/pub/kgarrett/mirs_latest/setup/paths_idl.pro
@covMatrx_sub.pro
;------------------------------------------------------------------
; Program used to merge covariance matrix files generated 
; independently, into one single file to be fed to the retrieval
; system.
;
; Sid-Ahmed Boukabara. 2006.
;------------------------------------------------------------------
close,/all
;---User-driven Information
read,  prompt='Do you want to merge Atm(0) or Sfc(1) cov files?:',iAtmOrSfc
read,  prompt='How many files do you want to merge?:',nFiles2merge
Files2merge = strarr(nFiles2merge)
Uids        = intarr(nFiles2merge)
TypesIds    = intarr(nFiles2merge)
TypesDesc   = strarr(nFiles2merge)
xFile       = ''
file_out    = ''
;----Read file names and open/read headers
FOR ifile=0,nFiles2merge-1 do begin
    ;---Input name of file
    read,  prompt='File#'+string(ifile+1,'(i)')+' you want to merge?:',xFile
    Files2merge(ifile)=strcompress(xFile,/remove_all)
    ;---Input its header
    ReadHdrCovMatrx,iAtmOrSfc,Files2merge(ifile),iIn,nEDRs,iParam,DescParam,nTyp,iTyp,DescTyp,$
                pres_lay,pres_lev,cfreq,polar,iMode,nLev,nLay,nFreq
    Uids(ifile)=iIn
    ;----Checks
    IF (nTyp ne 1) THEN BEGIN
        print,'Error: nTyp must be 1 in files to merge. Multi-types files are not merged'
        stop
    ENDIF
    TypesIds(ifile)            = iTyp
    TypesDesc(ifile)           = DescTyp
    IF (ifile ge 1) THEN BEGIN
        resIparam=array_equal(iparam,iparam0,/no_typeconv)
        resImode=array_equal(iMode,iMode0,/no_typeconv)
        resDescrParam=array_equal(DescParam,DescParam0,/no_typeconv)
        IF (nEDRs0 ne nEDRs)           THEN STOP,'Error: nEDRs not identical between files'
        IF (resIparam eq 0)      THEN STOP,'Error: iParam not identical between files'
        IF (resDescrParam eq 0)  THEN STOP,'Error: DescParam not identical between files'
        IF (resImode eq 0)       THEN STOP,'Error: iMode not identical between files'
        IF (iAtmOrSfc eq 0) THEN BEGIN
            maxPresLayDiff = max(abs(pres_lay(0:nLay-1)-pres_lay0(0:nLay-1)))
            maxPresLevDiff = max(abs(pres_lev(0:nLev-1)-pres_lev0(0:nLev-1)))
            ;resPresLay=array_equal(pres_lay,pres_lay0,/no_typeconv)
            ;resPresLev=array_equal(pres_lev,pres_lev0,/no_typeconv)
            IF (maxPresLayDiff gt 0.1) THEN STOP,'Error: pres_lay not identical between files'
            IF (maxPresLevDiff gt 0.1) THEN STOP,'Error: pres_lev not identical between files'
            ;IF (resPresLay eq 0)  THEN STOP,'Error: pres_lay not identical between files'
            ;IF (resPresLev eq 0)  THEN STOP,'Error: pres_lev not identical between files'
            IF (nLev0   ne nLev)  THEN STOP,'Error: nLev not identical between files'
            IF (nLay0   ne nLay)  THEN STOP,'Error: nLay not identical between files'
        ENDIF
        IF (iAtmOrSfc eq 1) THEN BEGIN
            resCfreq=array_equal(cfreq,cfreq0,/no_typeconv)
            resPolar=array_equal(polar,polar0,/no_typeconv)
            IF (resCfreq   eq 0)     THEN STOP,'Error: cFreq not identical between files'
            IF (resPolar   eq 0)     THEN STOP,'Error: polar not identical between files'
            IF (nFreq0     ne nFreq) THEN STOP,'Error: nFreq not identical between files'
        ENDIF
    ENDIF
    nEDRs0     = nEDRs
    iParam0    = iParam
    DescParam0 = DescParam
    iMode0     = iMode
    IF (iAtmOrSfc eq 0) THEN pres_lay0  = pres_lay
    IF (iAtmOrSfc eq 0) THEN pres_lev0  = pres_lev
    IF (iAtmOrSfc eq 0) THEN nLev0      = nLev
    IF (iAtmOrSfc eq 0) THEN nLay0      = nLay
    IF (iAtmOrSfc eq 1) THEN cfreq0     = cfreq
    IF (iAtmOrSfc eq 1) THEN polar0     = polar
    IF (iAtmOrSfc eq 1) THEN nFreq0     = nFreq
ENDFOR

;---Test that types are in order
TypesIdsSorted=TypesIds(sort(TypesIds))
res=array_equal(TypesIdsSorted,TypesIds,/no_typeconv)
IF (res eq 0) THEN BEGIN
    print, 'Error: Types must be in order. Here they are from the files as they were entered:'
    print,TypesIds(0:nFiles2merge-1)
    stop
ENDIF
;---Write header of merged file
read,  prompt='Name of output file:',file_out
writeOutHdrCovMatrx,iAtmOrSfc,file_Out,iout,nEDRs,iParam,DescParam,nFiles2merge,$
  TypesIds,TypesDesc,pres_lay,pres_lev,cfreq,polar,iMode

;---Loop over the files, read their contents and merge them in output
FOR ifile=0,nFiles2merge-1 do begin
    ;---Loop over the EDRs
    FOR ip=0,nEDRs-1 DO BEGIN
        ReadInPiecesCovMatrx,Uids(ifile),np,DescrPar,IndxPar,Sa,U,Xb
        writeOutInPiecesCovMatrx,iout,np,DescrPar,IndxPar,Sa,U,Xb
    ENDFOR
    ;---all-EDRs cov/bkg
    ReadInPiecesCovMatrx,Uids(ifile),np,DescrPar,IndxPar,Sa,U,Xb
    writeOutInPiecesCovMatrx,iout,np,DescrPar,IndxPar,Sa,U,Xb
    close,Uids(ifile)
    free_lun,Uids(ifile)
ENDFOR
close,iout

END
