!----------------------------------------------------------------------------
! This program serves the following:
!
!  - It merges two different geophysical files
!
!    Author: Sid-Ahmed Boukabara. IMSG Inc @ NOAA/NESDIS/STAR. Jan. 2006. 
! 
!----------------------------------------------------------------------------
program mergeProcessGeophData
  !---Use library modules
  USE Consts
  USE misc
  USE IO_Scene
  USE IO_InstrConfig
  USE utils
  !---Use CRTM-provided modules

  !---Everything explicitly declared
  IMPLICIT NONE
  INTEGER, PARAMETER                 :: MxScanPos=100,AlgSN=1030
  INTEGER                            :: nPrf1,nPrf2,nPrf,iprof,iprofT,fID1,fID2,fID,ierr
  TYPE(Scene_type)                   :: Scene1,Scene2,Scene
  CHARACTER(LEN=120)                 :: File1,File2,mrgFile
  NAMELIST /mrgCntrl/File1,File2,mrgFile

  !---Read Control parameters 
  READ(*,NML=mrgCntrl)

  !---Read headers of input files
  CALL ReadHdrScene(fID1,File1,Scene1,nPrf1)
  CALL ReadHdrScene(fID2,File2,Scene2,nPrf2)
  
  !---Consistency checks
  IF (Scene1%nLay           .ne. Scene2%nLay)         STOP'#Layers not consistent'
  IF (Scene1%nLev           .ne. Scene2%nLev)         STOP'#Levels not consistent'
  IF (Scene1%nChan          .ne. Scene2%nChan)        STOP'#Channels not consistent'
  IF (Scene1%nAbsorb        .ne. Scene2%nAbsorb)      STOP'#Absorbents not consistent'
  IF (Scene1%nqc            .ne. Scene2%nqc)          STOP'#QC(Atm) not consistent'
  IF (Scene1%nPosScan       .ne. Scene2%nPosScan)     STOP'#Scan Positions not consistent'
  IF (Scene1%nScanLines     .ne. Scene2%nScanLines)   STOP'#Scan lines not consistent'
  IF (Any(Scene1%absorbID   .ne. Scene2%absorbID))    STOP'#Absorbers not consistent'

  print *, scene1%nabsorb,scene2%nabsorb
  print *, scene1%absorbid
  print *, scene2%absorbID

  !---Initialize/Write header of resulting scene file
  CALL InitHdrScene(Scene1%nLev,Scene1%nLay,Scene1%nChan,Scene1%CentrFreq, &
       Scene1%polarity,Scene1%pres_lev,Scene1%pres_lay,Scene,      Scene1%nLay,        &
       Scene1%nLay,    Scene1%nLay,    Scene1%nLay,    Scene1%nLay,Scene1%nAbsorb,     &
       Scene1%AbsorbID,Scene1%nqc,0,Scene1%nPosScan,Scene1%nScanLines,AlgSN)
  CALL WriteHdrScene(fID,mrgFile,Scene,nPrf1+nPrf2)

  iprofT=0
  ProfLoop1: DO iprof=1,nPrf1
     !---Read the Profiles data
     CALL ReadScene(fID1,Scene1,ierr)
     IF (ierr.ne.0) CYCLE ProfLoop1
     CALL WriteScene(fID,Scene1)
     iprofT=iprofT+1
     !print *, 'Profile #',iprof,' from file#1',iprofT
  ENDDO ProfLoop1

  ProfLoop2: DO iprof=1,nPrf2
     !---Read the Profiles data
     CALL ReadScene(fID2,Scene2,ierr)
     IF (ierr.ne.0) CYCLE ProfLoop2
     CALL WriteScene(fID,Scene2)
     iprofT=iprofT+1
     !print *, 'Profile #',iprof,' from file#2',iprofT
  ENDDO ProfLoop2
  close(fID1)
  close(fID2)
  close(fID)
end program mergeProcessGeophData
