MODULE AMV_EN_XPATH_M
!********************************************************************************
!> @file
!> NAME:         WINDS_AMV_EN_LABELS_Mod
!>
!> FUNCTION:     All data labels needed by AIT Framework
!>
!> DESCRIPTION:
!>
!>     All data labels needed by AIT Framework
!>
!> REFERENCE:
!
!> CALLING SEQUENCE:
!>
!> INPUTS:
!>
!> OUTPUTS:
!>
!> DEPENDENCIES:
!>
!>
!> RESTRICTIONS:
!>
!> HISTORY:
!> - 11/2017 - Brian Helgans - Created.
!>
!> @ingroup WINDS_AMV_EN
!********************************************************************************

IMPLICIT NONE

CHARACTER(len=*), PARAMETER :: INPUT_FIRST_TIME_STAMP_LBL = 'input/TM1/sat/TimeStamp'
CHARACTER(len=*), PARAMETER :: INPUT_MIDDLE_TIME_STAMP_LBL = 'input/T0/sat/TimeStamp'
CHARACTER(len=*), PARAMETER :: INPUT_LAST_TIME_STAMP_LBL = 'input/TP1/sat/TimeStamp'
CHARACTER(len=*), PARAMETER :: INPUT_ORBITAL_PERIOD_LBL = 'input/T0/sat/OrbitalPeriod'

!Input Sat Data
CHARACTER(len=*), PARAMETER :: INPUT_FIRST_SAT_SCAN_TIME1970_LBL = 'input/TM1/sat/ScanTime_1970'
CHARACTER(len=*), PARAMETER :: INPUT_MIDDLE_SAT_SCAN_TIME1970_LBL = 'input/T0/sat/ScanTime_1970'
CHARACTER(len=*), PARAMETER :: INPUT_LAST_SAT_SCAN_TIME1970_LBL = 'input/TP1/sat/ScanTime_1970'


CHARACTER(len=*), PARAMETER :: INPUT_FIRST_MAXFPT_LBL = 'input/TM1/sat/MaxFocalPlnTemp'
CHARACTER(len=*), PARAMETER :: INPUT_MIDDLE_MAXFPT_LBL = 'input/T0/sat/MaxFocalPlnTemp'
CHARACTER(len=*), PARAMETER :: INPUT_LAST_MAXFPT_LBL = 'input/TP1/sat/MaxFocalPlnTemp'
CHARACTER(len=*), PARAMETER :: INPUT_FIRST_RADIOMETRIC_DATA_LBL = 'input/TM1/sat/RADIOMETRIC_DATA'
CHARACTER(len=*), PARAMETER :: INPUT_MIDDLE_RADIOMETRIC_DATA_LBL = 'input/T0/sat/RADIOMETRIC_DATA'
CHARACTER(len=*), PARAMETER :: INPUT_LAST_RADIOMETRIC_DATA_LBL = 'input/TP1/sat/RADIOMETRIC_DATA'

CHARACTER(len=*), PARAMETER :: INPUT_MCIDAS_ID_LBL = 'input/T0/sat/MCIDAS_ID'
CHARACTER(len=*), PARAMETER :: INPUT_SENSOR_SERIES_LBL = 'input/T0/sat/SensorSeries'
CHARACTER(len=*), PARAMETER :: INPUT_MIDDLE_BT_COHERANCE_CHECK_LBL = 'input/T0/sat/BT_COHERANCE_CHECK'
CHARACTER(len=*), PARAMETER :: INPUT_MIDDLE_RAD_COHERANCE_CHECK_LBL = 'input/T0/sat/RAD_COHERANCE_CHECK'
CHARACTER(len=*), PARAMETER :: INPUT_SPACE_MSK_LBL = 'input/T0/sat/SpaceMask'
CHARACTER(len=*), PARAMETER :: INPUT_SOL_ZEN_LBL = 'input/T0/sat/SolarZenith'


!Navigation Data
CHARACTER(len=*), PARAMETER :: INPUT_PROJECTED_LAT_LBL = 'input/T0/sat/ProjectedLatitude'
CHARACTER(len=*), PARAMETER :: INPUT_PROJECTED_LON_LBL = 'input/T0/sat/ProjectedLongitude'
CHARACTER(len=*), PARAMETER :: INPUT_ORBITAL_RADIUS_LBL = 'input/T0/sat/OrbitalRadius' !< For Meteosat8
CHARACTER(len=*), PARAMETER :: INPUT_COLUMN_FACTOR_LBL = 'input/T0/sat/ColumnFactor' !< For Meteosat8
CHARACTER(len=*), PARAMETER :: INPUT_LINE_FACTOR_LBL = 'input/T0/sat/LineFactor' !< For Meteosat8
CHARACTER(len=*), PARAMETER :: INPUT_COLUMN_OFFSET_LBL = 'input/T0/sat/ColumnOffset' !< For Meteosat8
CHARACTER(len=*), PARAMETER :: INPUT_LINE_OFFSET_LBL = 'input/T0/sat/nav/LineOffset' !< For Meteosat8

CHARACTER(len=*), PARAMETER :: INPUT_X_SCALE_LBL = 'input/T0/sat/X_Scale' !< For Fix Grid Satellites
CHARACTER(len=*), PARAMETER :: INPUT_Y_SCALE_LBL = 'input/T0/sat/Y_Scale' !< For Fix Grid Satellites
CHARACTER(len=*), PARAMETER :: INPUT_X_OFFSET_LBL = 'input/T0/sat/X_Offset' !< For Fix Grid Satellites
CHARACTER(len=*), PARAMETER :: INPUT_Y_OFFSET_LBL = 'input/T0/sat/Y_Offset' !< For Fix Grid Satellites
CHARACTER(len=*), PARAMETER :: INPUT_X_LBL = 'input/T0/sat/X' !< For Fix Grid Satellites
CHARACTER(len=*), PARAMETER :: INPUT_Y_LBL = 'input/T0/sat/Y' !< For Fix Grid Satellites

CHARACTER(len=*), PARAMETER :: INPUT_LOW_RESOLUTION_LBL = 'input/LOW_RESOLUTION'
CHARACTER(len=*), PARAMETER :: INPUT_MAP_TO_LOW_X = 'input/T0/sat/MAP_TO_LOW_X' !< For Mapping from high resolution to low resolution
CHARACTER(len=*), PARAMETER :: INPUT_MAP_TO_LOW_Y = 'input/T0/sat/MAP_TO_LOW_Y' !< For Mapping from high resolution to low resolution

!GVAR Parameters
CHARACTER(len=*), PARAMETER ::  INPUT_GVAR_NORTH_VIS_PIX_LBL = ""
CHARACTER(len=*), PARAMETER ::  INPUT_GVAR_ELEM_RES_LBL = ""
CHARACTER(len=*), PARAMETER ::  INPUT_GVAR_LINE_RES_LBL = ""
CHARACTER(len=*), PARAMETER ::  INPUT_GVAR_WEST_VIS_PIX_LBL = ""


!NWP
CHARACTER(len=*), PARAMETER :: INPUT_NWP_PRESSURE_LEVELS_LBL = 'input/T0/nwp/PressProf'
CHARACTER(len=*), PARAMETER :: INPUT_NWP_TEMPERATURE_PROF_LBL = 'input/T0/nwp/TempProf' !< NWP Temperature Profile
CHARACTER(len=*), PARAMETER :: INPUT_NWP_WND_U_PROF_LBL = 'input/T0/nwp/WndU_Prof' !< NWP Wind U Profiles
CHARACTER(len=*), PARAMETER :: INPUT_NWP_WND_V_PROF_LBL = 'input/T0/nwp/WndV_Prof' !< NWP Wind V Profiles
CHARACTER(len=*), PARAMETER :: INPUT_NWP_X_LBL = 'input/T0/nwp/X_NWP' !< NWP Wind V Profiles
CHARACTER(len=*), PARAMETER :: INPUT_NWP_Y_LBL = 'input/T0/nwp/Y_NWP' !< NWP Wind V Profiles

!Land Mask
CHARACTER(len=*), PARAMETER :: INPUT_LAND_MASK_LBL = 'input/T0/land_mask/LandMask'

!CLOUDS
CHARACTER(len=*), PARAMETER :: INPUT_CLD_MASK_LBL = 'input/T0/cloud_mask/CloudMask' !<
CHARACTER(len=*), PARAMETER :: INPUT_CLD_PHASE_LBL = 'input/T0/cloud_phase/CldPhase' !<
CHARACTER(len=*), PARAMETER :: INPUT_CLD_TYPE_LBL = 'input/T0/cloud_phase/CldType' !<
CHARACTER(len=*), PARAMETER :: INPUT_CLD_TOP_EMISS_LBL = 'input/T0/cloud_height/CldTopEmiss' !<
CHARACTER(len=*), PARAMETER :: INPUT_CLD_TOP_HEIGHT_LBL = 'input/T0/cloud_height/CldTopHeight' !<
CHARACTER(len=*), PARAMETER :: INPUT_CLD_HEIGHT_FLAG_LBL = 'input/T0/cloud_height/HeightFlag' !<
CHARACTER(len=*), PARAMETER :: INPUT_CLD_TOP_PRESS_LBL = 'input/T0/cloud_height/CldTopPres' !<
CHARACTER(len=*), PARAMETER :: INPUT_CLD_TOP_PRESS_ERROR_LBL = 'input/T0/cloud_height/CldTopPresUncertainty' !<
CHARACTER(len=*), PARAMETER :: INPUT_CLD_HEIGHT_DEGRAD_LBL = 'input/T0/cloud_height/DegradationFlag' !<
CHARACTER(len=*), PARAMETER :: PAR_CLD_HEIGHT_FLAG_PRESSURE_INDEX_LBL = 'parameters/cloud_height/HeightFlag_PressureIndex' !<
CHARACTER(len=*), PARAMETER :: INPUT_CLD_TOP_TEMP_LBL = 'input/T0/cloud_height/CldTopTemp' !<
CHARACTER(len=*), PARAMETER :: INPUT_CLD_TOP_TEMP_ERROR_LBL = 'input/T0/cloud_height/CldTopTempUncertainty' !<
CHARACTER(len=*), PARAMETER :: INPUT_CLD_INVERSION_FLAG_LBL = 'input/T0/cloud_height/InversionFlag' !<
CHARACTER(len=*), PARAMETER :: INPUT_CLD_OPTICAL_DEPTH_LBL = 'input/T0/cloud_height/CldOpticalDepth' !<
CHARACTER(len=*), PARAMETER :: INPUT_CLD_COST_LBL = 'input/T0/cloud_height/Cost' !<
!WCB
CHARACTER(len=*), PARAMETER :: INPUT_CLD_HEIGHT_QF_LBL = 'input/T0/cloud_height/CldHeightQF'

!Parameters
CHARACTER(len=*), PARAMETER :: PAR_DUMP_ASCII_LBL = 'parameters/DUMP_ASCII'

CHARACTER(len=*), PARAMETER :: PAR_AMV_IDX_LBL = 'parameters/AMV_IDX'
CHARACTER(len=*), PARAMETER :: PAR_COVERAGE_LBL = 'parameters/COVERAGE'
CHARACTER(len=*), PARAMETER :: PAR_BOX_SIZE_LBL = 'parameters/BOX_SIZE'
CHARACTER(len=*), PARAMETER :: PAR_NESTED_TRACKING_FLAG_LBL = 'parameters/NESTED_TRACKING_FLAG'
CHARACTER(len=*), PARAMETER :: PAR_EE_FILTER_FLAG_LBL = 'parameters/EE_FILTER_FLAG'
CHARACTER(len=*), PARAMETER :: PAR_TARGET_TYPE_LBL = 'parameters/TARGET_TYPE'
CHARACTER(len=*), PARAMETER :: PAR_LAG_SIZE_LBL = 'parameters/LAG_SIZE'
CHARACTER(len=*), PARAMETER :: PAR_NAV_TYPE_LBL = 'parameters/NAV_TYPE'
CHARACTER(len=*), PARAMETER :: PAR_MAX_WINDS_PER_SEGMENT_LBL = 'parameters/MAX_WINDS_PER_SEGMENT'
CHARACTER(len=*), PARAMETER :: PAR_SECOND_CHOICE_LBL = 'parameters/SECOND_CHOICE'
! aab - HIRES mod
CHARACTER(len=*), PARAMETER :: PAR_HIRES_JOB_LBL = 'parameters/HIRES_JOB'

!
!Polar Satellite Parameters
!
!> @var the projection origin in floating point
CHARACTER(len=*), PARAMETER :: INPUT_NAV_ORIGIN_LINE_LBL = 'input/T0/sat/nav/PROJECTION_OriginLine'
!> @var projection origin element in floating point
CHARACTER(len=*), PARAMETER :: INPUT_NAV_ORIGIN_ELEM_LBL = 'input/T0/sat/nav/PROJECTION_OriginElement'
!> @var projection origin latitude [Degree, Minute, second format: DDDMMSS]
CHARACTER(len=*), PARAMETER :: INPUT_NAV_ORIGIN_LAT_DDDMMSS_LBL = 'input/T0/sat/nav/PROJECTION_OriginLat_DDDMMSS'
!> @var projection origin longitude [Degree, Minute, second format: DDDMMSS]
CHARACTER(len=*), PARAMETER :: INPUT_NAV_ORIGIN_LON_DDDMMSS_LBL = 'input/T0/sat/nav/PROJECTION_OriginLon_DDDMMSS'
!> @var latitude at which the standard spacing is applied [Degree, Minute, second format: DDDMMSS]
CHARACTER(len=*), PARAMETER :: INPUT_NAV_STANDARD_LAT_DDDMMSS_LBL = 'input/T0/sat/nav/PROJECTION_StandardLat_DDDMMSS'
!> @var standard spacing, a nominal spacing between grid points at the standard location [m]
CHARACTER(len=*), PARAMETER :: INPUT_NAV_STANDARD_SPACING_LBL = 'input/T0/sat/nav/PROJECTION_StandardSpacing'
!> @var radius at the equator [m]
CHARACTER(len=*), PARAMETER :: INPUT_NAV_RADIUS_EQ_LBL = 'input/T0/sat/nav/PROJECTION_RadiusAtEquator'
!> @var eccentricity of earth
CHARACTER(len=*), PARAMETER :: INPUT_NAV_ECC_PLANET_LBL = 'input/T0/sat/nav/PROJECTION_Eccentricity'


!Expected Error Parameters
CHARACTER(len=*), PARAMETER :: PAR_TABLE_CONST_LBL = 'parameters/expected_err_coeff/CONST' !< Parameter_in_table
CHARACTER(len=*), PARAMETER :: PAR_TABLE_QSIP_LBL = 'parameters/expected_err_coeff/QSIP' !< Parameter_in_table
CHARACTER(len=*), PARAMETER :: PAR_TABLE_QIDR_LBL = 'parameters/expected_err_coeff/QIDR' !< Parameter_in_table
CHARACTER(len=*), PARAMETER :: PAR_TABLE_QIVS_LBL = 'parameters/expected_err_coeff/QIVS' !< Parameter_in_table
CHARACTER(len=*), PARAMETER :: PAR_TABLE_QILC_LBL = 'parameters/expected_err_coeff/QILC' !< Parameter_in_table
CHARACTER(len=*), PARAMETER :: PAR_TABLE_QIFC_LBL = 'parameters/expected_err_coeff/QIFC' !< Parameter_in_table
CHARACTER(len=*), PARAMETER :: PAR_TABLE_SPD_LBL = 'parameters/expected_err_coeff/SPD' !< Parameter_in_table
CHARACTER(len=*), PARAMETER :: PAR_TABLE_PW_LBL = 'parameters/expected_err_coeff/PW' !< Parameter_in_table
CHARACTER(len=*), PARAMETER :: PAR_TABLE_SHEAR_LBL = 'parameters/expected_err_coeff/SHEAR' !< Parameter_in_table
CHARACTER(len=*), PARAMETER :: PAR_TABLE_TEMPG_LBL = 'parameters/expected_err_coeff/TEMPG' !< Parameter_in_table


CHARACTER(len=*), PARAMETER :: TIME_INTERVAL_MINUS_LBL = 'capability/TimeInterval_Minus' !<
CHARACTER(len=*), PARAMETER :: TIME_INTERVAL_AVERAGE_LBL = 'capability/TimeInterval_Average' !<
CHARACTER(len=*), PARAMETER :: TIME_INTERVAL_PLUS_LBL = 'capability/TimeInterval_Plus' !<

CHARACTER(len=*), PARAMETER :: FIRST_GMT_YYYYJJJ_LBL = 'capability/TM1/GMT_YYYYJJJ'
CHARACTER(len=*), PARAMETER :: FIRST_GMT_HHMMSS_LBL = 'capability/TM1/GMT_HHMMSS'
CHARACTER(len=*), PARAMETER :: FIRST_GMT_EPOCH1970_LBL = 'capability/TM1/GMT_Epoch1970'
CHARACTER(len=*), PARAMETER :: MIDDLE_GMT_YYYYJJJ_LBL = 'capability/T0/GMT_YYYYJJJ'
CHARACTER(len=*), PARAMETER :: MIDDLE_GMT_HHMMSS_LBL = 'capability/T0/GMT_HHMMSS'
CHARACTER(len=*), PARAMETER :: MIDDLE_GMT_EPOCH1970_LBL = 'capability/T0/GMT_Epoch1970'
CHARACTER(len=*), PARAMETER :: LAST_GMT_YYYYJJJ_LBL = 'capability/TP1/GMT_YYYYJJJ'
CHARACTER(len=*), PARAMETER :: LAST_GMT_HHMMSS_LBL = 'capability/TP1/GMT_HHMMSS'
CHARACTER(len=*), PARAMETER :: LAST_GMT_EPOCH1970_LBL = 'capability/TP1/GMT_Epoch1970'


CHARACTER(len=*), PARAMETER :: FIRST_TARGET_YYYYJJJ_LBL = 'capability/perTarget/TM1/YYYYJJJ'
CHARACTER(len=*), PARAMETER :: FIRST_TARGET_HHMMSS_LBL = 'capability/perTarget/TM1/HHMMSS'
CHARACTER(len=*), PARAMETER :: MIDDLE_TARGET_YYYYJJJ_LBL = 'capability/perTarget/T0/YYYYJJJ'
CHARACTER(len=*), PARAMETER :: MIDDLE_TARGET_HHMMSS_LBL = 'capability/perTarget/T0/HHMMSS'
CHARACTER(len=*), PARAMETER :: LAST_TARGET_YYYYJJJ_LBL = 'capability/perTarget/TP1/YYYYJJJ'
CHARACTER(len=*), PARAMETER :: LAST_TARGET_HHMMSS_LBL = 'capability/perTarget/TP1/HHMMSS'

CHARACTER(len=*), PARAMETER :: FIRST_TARGET_EPOCH_LBL = 'capability/perTarget/TM1/Epoch1970'
CHARACTER(len=*), PARAMETER :: MIDDLE_TARGET_EPOCH_LBL = 'capability/perTarget/T0/Epoch1970'
CHARACTER(len=*), PARAMETER :: LAST_TARGET_EPOCH_LBL = 'capability/perTarget/TP1/Epoch1970'




!capability of Targets
CHARACTER(len=*), PARAMETER :: WIND_DATA_ADHOC = 'WIND_DATA'
!CHARACTER(len=*), PARAMETER :: TARGET_TYPE_LBL = 'capability/TargetType'
CHARACTER(len=*), PARAMETER :: WIND_LON_LBL = 'capability/perTarget/Longitude' !<
CHARACTER(len=*), PARAMETER :: WIND_LAT_LBL = 'capability/perTarget/Latitude' !<
CHARACTER(len=*), PARAMETER :: WIND_SPEED_LBL = 'capability/perTarget/Speed' !<
CHARACTER(len=*), PARAMETER :: WIND_DIRECTION_LBL = 'capability/perTarget/Direction' !<
CHARACTER(len=*), PARAMETER :: MEDIAN_PRESS_LBL = 'capability/perTarget/Pressure_MED' !<
CHARACTER(len=*), PARAMETER :: PRESSURE_VARIANCE_LBL = 'capability/perTarget/Pressure_VAR' !<
CHARACTER(len=*), PARAMETER :: FCST_SPD_LBL = 'capability/perTarget/ForecastSpeed' !<
CHARACTER(len=*), PARAMETER :: FCST_DIR_LBL = 'capability/perTarget/ForecastDirection' !<
CHARACTER(len=*), PARAMETER :: MEDIAN_BT_LBL = 'capability/perTarget/BT_MED' !<
CHARACTER(len=*), PARAMETER :: QI_LBL = 'capability/perTarget/QI' !<
CHARACTER(len=*), PARAMETER :: SPD_FLAG_LBL = 'capability/perTarget/QISpeedFlag' !<
CHARACTER(len=*), PARAMETER :: DIR_FLAG_LBL = 'capability/perTarget/QIDirectionFlag' !<
CHARACTER(len=*), PARAMETER :: VEC_FLAG_LBL = 'capability/perTarget/QIVectorFlag' !<
CHARACTER(len=*), PARAMETER :: LOC_CONSISTENCY_FLG_LBL = 'capability/perTarget/QILocationConsistencyFlag' !<
CHARACTER(len=*), PARAMETER :: FCST_FLAG_LBL = 'capability/perTarget/QIForecastFlag' !<
! add QINF (QI without forecast)
CHARACTER(len=*), PARAMETER :: QINF_LBL = 'capability/perTarget/QINF' !<
CHARACTER(len=*), PARAMETER :: FLAG_LBL = 'capability/perTarget/Flag' !<
CHARACTER(len=*), PARAMETER :: EXPECTED_ERR_LBL = 'capability/perTarget/ExpectedError' !<
CHARACTER(len=*), PARAMETER :: SAT_ZEN_LBL = 'capability/perTarget/SatelliteZenith' !<
CHARACTER(len=*), PARAMETER :: POINT_INDEX_LBL = 'capability/perTarget/PointIndex' !<
CHARACTER(len=*), PARAMETER :: ALTITUDE_LBL = 'capability/perTarget/Altitude' !<
CHARACTER(len=*), PARAMETER :: LAND_FLAG_LBL = 'capability/perTarget/LandFlag' !<
CHARACTER(len=*), PARAMETER :: INVERSION_FLAG_LBL = 'capability/perTarget/InversionFlag' !<
CHARACTER(len=*), PARAMETER :: CLOUD_PHASE_LBL = 'capability/perTarget/CloudPhase' !<
CHARACTER(len=*), PARAMETER :: CLOUD_TYPE_LBL = 'capability/perTarget/CloudType' !<
CHARACTER(len=*), PARAMETER :: TEMP_GRAD_LBL = 'capability/perTarget/TemperatureGradient' !<
CHARACTER(len=*), PARAMETER :: SHEAR_LBL = 'capability/perTarget/Shear' !<
CHARACTER(len=*), PARAMETER :: CTP_MIN_LBL = 'capability/perTarget/CloudTopPressure_MIN' !<
CHARACTER(len=*), PARAMETER :: CTP_MAX_LBL = 'capability/perTarget/CloudTopPressure_MAX' !<
CHARACTER(len=*), PARAMETER :: CTT_MIN_LBL = 'capability/perTarget/CloudTopTemperature_MIN' !<
CHARACTER(len=*), PARAMETER :: CTT_MAX_LBL = 'capability/perTarget/CloudTopTemperature_MAX' !<
CHARACTER(len=*), PARAMETER :: HGT_ERR_MED_LBL = 'capability/perTarget/HeightError_MED' !<
CHARACTER(len=*), PARAMETER :: TEMP_ERR_MED_LBL = 'capability/perTarget/TemperatureError_MED' !<
CHARACTER(len=*), PARAMETER :: ORIG_FCST_SPEED_LBL = 'capability/perTarget/OriginalForecastSpeed' !<
CHARACTER(len=*), PARAMETER :: ORIG_FCST_DIR_LBL = 'capability/perTarget/OriginalForecastDirection' !<
CHARACTER(len=*), PARAMETER :: BEST_FIT_PRES_LVL_LBL = 'capability/perTarget/BestFitPresLevel' !<
CHARACTER(len=*), PARAMETER :: WGHT_CTP_LBL = 'capability/perTarget/WeightedCloudTopPressure' !<
CHARACTER(len=*), PARAMETER :: MIN_OPTICAL_DEPTH_LBL = 'capability/perTarget/OpticalDepth_MIN' !<
CHARACTER(len=*), PARAMETER :: MEDIAN_OPTICAL_DEPTH_LBL = 'capability/perTarget/OpticalDepth_MED' !<
CHARACTER(len=*), PARAMETER :: MAX_OPTICAL_DEPTH_LBL = 'capability/perTarget/OpticalDepth_MAX' !<
CHARACTER(len=*), PARAMETER :: MIN_ACHA_COST_LBL = 'capability/perTarget/ACHA_Cost_MIN' !<
CHARACTER(len=*), PARAMETER :: MAX_ACHA_COST_LBL = 'capability/perTarget/ACHA_Cost_MAX' !<
CHARACTER(len=*), PARAMETER :: MEDIAN_ACHA_COST_LBL = 'capability/perTarget/ACHA_Cost_MED' !<
CHARACTER(len=*), PARAMETER :: ELEMENT_LBL = 'capability/perTarget/Element' !<
CHARACTER(len=*), PARAMETER :: LINE_LBL = 'capability/perTarget/Line' !<


CHARACTER(len=*), PARAMETER :: CORR_COEFF_LBL = 'capability/perTarget/Sample1/CorrelationCoefficient' !<
CHARACTER(len=*), PARAMETER :: CORR_COEFF2_LBL = 'capability/perTarget/Sample2/CorrelationCoefficient' !<
CHARACTER(len=*), PARAMETER :: LAT_MATCH1_LBL = 'capability/perTarget/Sample1/LatitudeMatch' !<
CHARACTER(len=*), PARAMETER :: LON_MATCH1_LBL = 'capability/perTarget/Sample1/LongitudeMatch' !<
CHARACTER(len=*), PARAMETER :: LAT_MATCH2_LBL = 'capability/perTarget/Sample2/LatitudeMatch' !<
CHARACTER(len=*), PARAMETER :: LON_MATCH2_LBL = 'capability/perTarget/Sample2/LongitudeMatch' !<
CHARACTER(len=*), PARAMETER :: U_COMPONENT_1_LBL = 'capability/perTarget/Sample1/UComponent' !<
CHARACTER(len=*), PARAMETER :: V_COMPONENT_1_LBL = 'capability/perTarget/Sample1/VComponent' !<
CHARACTER(len=*), PARAMETER :: U_COMPONENT_2_LBL = 'capability/perTarget/Sample2/UComponent' !<
CHARACTER(len=*), PARAMETER :: V_COMPONENT2_LBL = 'capability/perTarget/Sample2/VComponent' !<
CHARACTER(len=*), PARAMETER :: STD_DEV_MVD1_LBL = 'capability/perTarget/Sample1/MeanVectorDifference_STDDEV' !<
CHARACTER(len=*), PARAMETER :: STD_DEV_MVD2_LBL = 'capability/perTarget/Sample2/MeanVectorDifference_STDDEV' !<
CHARACTER(len=*), PARAMETER :: PCT_OF_AVG1_LBL = 'capability/perTarget/Sample1/PercentOfAverage' !<
CHARACTER(len=*), PARAMETER :: PCT_OF_AVG2_LBL = 'capability/perTarget/Sample2/PercentOfAverage' !<
CHARACTER(len=*), PARAMETER :: NUM_CLUSTERS1_LBL = 'capability/perTarget/Sample1/NumberClusters' !<
CHARACTER(len=*), PARAMETER :: MAX_CLUSTER_SIZE1_LBL = 'capability/perTarget/Sample1/ClusterSize_MAX' !<
CHARACTER(len=*), PARAMETER :: NUM_CLUSTERS2_LBL = 'capability/perTarget/Sample2/NumberClusters' !<
CHARACTER(len=*), PARAMETER :: MAX_CLUSTER_SIZE2_LBL = 'capability/perTarget/Sample2/ClusterSize_MAX' !<
CHARACTER(len=*), PARAMETER :: MAX_PCT1_LBL = 'capability/perTarget/Sample1/ClusterSize_MAXPCT' !<
CHARACTER(len=*), PARAMETER :: MAX_PCT2_LBL = 'capability/perTarget/Sample2/ClusterSize_MAXPCT' !<




CHARACTER(len=*), PARAMETER :: ERROR_COUNTS_ADHOC = 'ERROR_COUNTS' !<
CHARACTER(len=*), PARAMETER :: STAT_QA_VALUE_URI = "capability/overallStatistics/QAValue"
CHARACTER(len=*), PARAMETER :: STAT_NUM_TARGETS_LBL = 'capability/overallStatistics/NumberTargets' !<
CHARACTER(len=*), PARAMETER :: STAT_NUM_GOOD_WINDS_LBL = 'capability/overallStatistics/NumberGoodWinds' !<
CHARACTER(len=*), PARAMETER :: STAT_NUM_GOOD_TARGETS_LBL = 'capability/overallStatistics/NumberGoodTargets' !<
CHARACTER(len=*), PARAMETER :: STAT_PCT_GOOD_CLEAR_LBL = 'capability/overallStatistics/PercentGoodWindsClearOfCloud' !<
CHARACTER(len=*), PARAMETER :: STAT_PCT_BAD_TARGETS_LBL = 'capability/overallStatistics/PercentBadTargets'

CHARACTER(len=*), PARAMETER :: STAT_CLD_HGT_LAYER1_URI = 'capability/overallStatistics/CloudHeight_Layer1_'
CHARACTER(len=*), PARAMETER :: STAT_CLD_HGT_LAYER2_URI = 'capability/overallStatistics/CloudHeight_Layer2_'
CHARACTER(len=*), PARAMETER :: STAT_CLD_HGT_LAYER3_URI = 'capability/overallStatistics/CloudHeight_Layer3_'
CHARACTER(len=*), PARAMETER :: STAT_WIND_SPD_LAYER1_URI = 'capability/overallStatistics/WindSpeed_Layer1_'
CHARACTER(len=*), PARAMETER :: STAT_WIND_SPD_LAYER2_URI = 'capability/overallStatistics/WindSpeed_Layer2_'
CHARACTER(len=*), PARAMETER :: STAT_WIND_SPD_LAYER3_URI = 'capability/overallStatistics/WindSpeed_Layer3_'
CHARACTER(len=*), PARAMETER :: STAT_NUM_GOOD_WINDS_LAYER1_LBL = 'capability/overallStatistics/NumberGoodWinds_Layer1'
CHARACTER(len=*), PARAMETER :: STAT_NUM_GOOD_WINDS_LAYER2_LBL = 'capability/overallStatistics/NumberGoodWinds_Layer2'
CHARACTER(len=*), PARAMETER :: STAT_NUM_GOOD_WINDS_LAYER3_LBL = 'capability/overallStatistics/NumberGoodWinds_Layer3'
CHARACTER(len=*), PARAMETER :: STAT_WIND_SPD_URI = 'capability/overallStatistics/WindSpeed_'





CHARACTER(len=*), PARAMETER :: OUT_STAT_CldHght_BLBL= 'capability/statistics/CldHgt'


END MODULE AMV_EN_XPATH_M
