!-------------------------------------------------------------------------------
! Name:
!   WINDS_INC
!
! Function:
!   This module is converted from AMV include file, it contains variables used in
!   AMV
!
! Description:
!
!
! Reference:
!   None
!
! Calling sequence:
!   None
!
! Inputs:
!   None
!
! Outputs:
!   None
!
! Dependencies:
!   None
!
! Side effects:
!   None
!
! History:
!   11/2013 -
!-------------------------------------------------------------------------------
MODULE AMV_EN_WINDS_INC

   USE TYPE_KINDS_AIT
   USE GEOCAT_CONSTANTS
   IMPLICIT NONE

   INTEGER(LONG), PARAMETER :: CSWV_CLEAR = sym%YES
   INTEGER(LONG), PARAMETER :: CSWV_CLOUD = sym%NO
   CHARACTER(len=*), PARAMETER :: TARGET_CLEAR = "CS"
   CHARACTER(len=*), PARAMETER :: TARGET_CLOUD = "CT"

   INTEGER(SHORT), PARAMETER :: Location_Dimensions = 2
   INTEGER(SHORT), PARAMETER :: PIXEL_OFFSET = 2

   INTEGER(SHORT), PARAMETER :: BUFFER_SEGMENTS_POLAR = 21
   INTEGER(SHORT), PARAMETER :: BUFFER_SEGMENTS_GEO = 7
   REAL(SINGLE), PARAMETER :: MIN_PERCENT_PRESS_VALUES_POLAR = 0.01
   REAL(SINGLE), PARAMETER :: MIN_PERCENT_PRESS_VALUES_GEO = 0.02

   ! default box spacing
   !INTEGER(SHORT), PARAMETER :: NOMINAL_BOX_SIZE = 15
   INTEGER(SHORT), PARAMETER :: NOMINAL_BOX_SIZE_DEFAULT = 15

   ! Hurricane Sandy test
   !INTEGER(SHORT), PARAMETER :: NOMINAL_BOX_SIZE = 11

   ! aab HIRES TC MESO Box
   INTEGER(SHORT), PARAMETER :: NOMINAL_BOX_SIZE_HIRES = 5

   INTEGER(SHORT), PARAMETER :: NOMINAL_SWIR_BOX_SIZE = 7

   REAL(SINGLE), PARAMETER ::  IR_GRADIENT_THRESHOLD_POLAR = 2.0

   REAL(SINGLE), PARAMETER ::  IR_GRADIENT_THRESHOLD_GEO = 4.0
   ! aab HIRES TC MESO
   REAL(SINGLE), PARAMETER ::  IR_GRADIENT_THRESHOLD_GEO_HIRES = 2.0

   REAL(SINGLE), PARAMETER ::  WVCS_GRADIENT_THRESHOLD = 1.5

   REAL(SINGLE), PARAMETER ::  WVCT_GRADIENT_THRESHOLD = 2.0
   ! aab HIRES TC MESO
   REAL(SINGLE), PARAMETER ::  WVCT_GRADIENT_THRESHOLD_HIRES = 1.0

   REAL(SINGLE), PARAMETER ::  VISIBLE_GRADIENT_THRESHOLD = 12.0
   ! aab HIRES TC MESO
   REAL(SINGLE), PARAMETER ::  VISIBLE_GRADIENT_THRESHOLD_HIRES = 1.0

   REAL(SINGLE), PARAMETER ::  SWIR_GRADIENT_THRESHOLD = 3.0
   REAL(SINGLE), PARAMETER ::  IR_COLD_THRESHOLD = 0.25
   REAL(SINGLE), PARAMETER ::  WVCT_COLD_THRESHOLD = .99
   REAL(SINGLE), PARAMETER ::  WVCS_COLD_THRESHOLD = 0.20
   REAL(SINGLE), PARAMETER ::  ACCEL_THRESHOLD = 10.0

   ! baseline
   !REAL(SINGLE), PARAMETER ::  ACCEL_THRESHOLD_VZ = 5.0
   ! modified threshold to capture low level winds around tropical cyclones
   REAL(SINGLE), PARAMETER ::  ACCEL_THRESHOLD_VZ = 7.5

   REAL(SINGLE), PARAMETER :: STDDEV_THRESHOLD = 1.0
   REAL(SINGLE), PARAMETER :: PRESSURE_CONSISTENCY_THRESHOLD = 100.0

   REAL(SINGLE), PARAMETER :: CORR_MIN_POLAR = 0.5              ! min for entire target scene
   REAL(SINGLE), PARAMETER :: CORR_MIN_GEO = 0.6                ! min for entire target scene
   REAL(SINGLE), PARAMETER :: MIN_VALID_REFLECTANCE = 0.0       ! min valid value for reflectance in percent
   REAL(SINGLE), PARAMETER :: MAX_VALID_REFLECTANCE = 200.0     ! max valid value for reflectance in percent
   REAL(SINGLE), PARAMETER :: MIN_VALID_BT = 150.0              ! min valid value for Brightness temp
   REAL(SINGLE), PARAMETER :: MAX_VALID_BT = 340.0              ! max valid value for Brightness temp

   REAL(SINGLE), PARAMETER :: COHERENCE_THRESHOLD_PCT = 0.8
   ! aab HIRES TC MESO
   REAL(SINGLE), PARAMETER :: COHERENCE_THRESHOLD_PCT_HIRES = 0.95

   REAL(SINGLE), PARAMETER :: SAMPLE_THRESHOLD_PCT = 0.8
   REAL(SINGLE), PARAMETER :: SIGMA_1 = 1.0                     ! 1 sigma cutoff value of distribution
   REAL(SINGLE), PARAMETER :: SIGMA_3 = 3.0                     ! 3 sigma cutoff value of distribution
   REAL(SINGLE), PARAMETER :: LOWER_GAUSSIAN_EXPONENT = -10.0

   ! nested tracking parameters

   REAL(SINGLE), PARAMETER :: EPS_POLAR = 3.3                    ! neighborhood radius in pixels
   REAL(SINGLE), PARAMETER :: EPS_GEO = 0.5
   REAL(DOUBLE), PARAMETER :: CORR_COEFF_5X5_GEO        = 0.8   ! 5x5 correlation threshold

   ! new variables - 1/25/16
   REAL(DOUBLE), PARAMETER :: CORR_COEFF_5X5_POLAR_CSWV = 0.0
   REAL(DOUBLE), PARAMETER :: CORR_COEFF_5X5_POLAR_CLD  = 0.6

   INTEGER(LONG), PARAMETER :: DEFAULT_TIME_INTERVAL_POLAR = 30

   INTEGER(SHORT), PARAMETER :: SCALE_FACTOR = 10
   INTEGER(SHORT), PARAMETER :: BRTTEMP_MIN = 1
   INTEGER(SHORT), PARAMETER :: BRTTEMP_MAX = 340 * SCALE_FACTOR
   REAL(SINGLE), PARAMETER :: MIN_HISTOGRAM_VALUE = 0.0
   REAL(SINGLE), PARAMETER :: MAX_HISTOGRAM_VALUE = 199.0
   INTEGER(SHORT), PARAMETER :: NUMBER_OF_SLOTS = 200
   REAL(SINGLE), PARAMETER :: INTERVAL_LENGTH = (MAX_HISTOGRAM_VALUE - MIN_HISTOGRAM_VALUE) / REAL(NUMBER_OF_SLOTS - 1)


   ! Flag values
   INTEGER(SHORT), PARAMETER :: BOX_ON_EDGE_FAILURE        = -2
   INTEGER(SHORT), PARAMETER :: ZERO_GRADIENT_FAILURE      = -1
   INTEGER(SHORT), PARAMETER :: GOOD_TARGET                =  0
   INTEGER(SHORT), PARAMETER :: GRADIENT_THRESHOLD_FAILURE =  1
   INTEGER(SHORT), PARAMETER :: EARTH_EDGE_FAILURE         =  2
   INTEGER(SHORT), PARAMETER :: CLOUD_AMOUNT_FAILURE       =  3
   INTEGER(SHORT), PARAMETER :: BAD_PRESS_FAILURE          =  4
   INTEGER(SHORT), PARAMETER :: BAD_BT_FAILURE             =  5
   INTEGER(SHORT), PARAMETER :: MULTIPLE_LAYERS_FAILURE    =  6
   INTEGER(SHORT), PARAMETER :: COHERENCY_FAILURE          =  7
   INTEGER(SHORT), PARAMETER :: CORRELATION_FAILURE        =  8
   INTEGER(SHORT), PARAMETER :: U_ACCELERATION_FAILURE     =  9
   INTEGER(SHORT), PARAMETER :: V_ACCELERATION_FAILURE     = 10
   INTEGER(SHORT), PARAMETER :: UV_ACCELERATION_FAILURE    = 11
   INTEGER(SHORT), PARAMETER :: SLOW_WIND_FAILURE          = 12
   INTEGER(SHORT), PARAMETER :: TERMINATOR_FAILURE         = 13
   INTEGER(SHORT), PARAMETER :: PRESS_THRESHOLD_FAILURE    = 14
   ! Error 15 is assigned in feature_tracking utils
   INTEGER(SHORT), PARAMETER :: GROSS_ERROR_FAILURE        = 16
   INTEGER(SHORT), PARAMETER :: CTP_CONSISTENCY_FAILURE    = 17
   INTEGER(SHORT), PARAMETER :: SEARCH_NOT_FULL_FAILURE    = 18
   INTEGER(SHORT), PARAMETER :: EE_REJECT_FLAG             = 19
   ! Error 20 is assigned in feature_tracking utils
   ! Error 21 is assigned in feature_tracking utils
   ! Error 22 is assigned in feature_tracking utils

   ! WCB - add cloud height quality flag
   INTEGER(BYTE), PARAMETER :: CTH_DQF_GOOD_RETREVIAL = 0
   INTEGER(BYTE), PARAMETER :: CTH_DQF_MARGINAL_RETREVIAL = 1
   INTEGER(BYTE), PARAMETER :: CTH_DQF_RETREVIAL_ATTEMPTED = 2
   INTEGER(BYTE), PARAMETER :: CTH_DQF_BAD_RETREVIAL = 3
   INTEGER(BYTE), PARAMETER :: CTH_DQF_OPAQUE_RETREVIAL = 4

   ! 4-pt centered difference kernel
   REAL(SINGLE), DIMENSION(5), PARAMETER :: Kernel = &
       (/ -1.0 / 12.0, &
          8.0 / 12.0, &
          0.0, &
          -8.0 / 12.0, &
          1.0 / 12.0 /)

   !INTEGER(LONG), PARAMETER :: Max_Wind_Records = 1700000 !Configurable
   !INTEGER(SHORT), PARAMETER :: MAX_PARAMETERS = 85
   ! increased for stereo winds and second QI value (QINF)
   INTEGER(SHORT), PARAMETER :: MAX_PARAMETERS = 90

   REAL(SINGLE), PARAMETER :: PMIN_VISIBLE = 700.0
   ! aab HIRES TC MESO
   REAL(SINGLE), PARAMETER :: PMIN_VISIBLE_HIRES = 40.0

   REAL(SINGLE), PARAMETER :: PMIN_SWIR = 700.0
   REAL(SINGLE), PARAMETER :: PMIN_CTWV = 100.0
   REAL(SINGLE), PARAMETER :: PMIN_LWIR = 100.0
   REAL(SINGLE), PARAMETER :: PMAX_CTWV = 350.0
   REAL(SINGLE), PARAMETER :: PMAX_CTWV_MODIS = 600.0
   REAL(SINGLE), PARAMETER :: PMIN_CSWV10 = 450.0
   REAL(SINGLE), PARAMETER :: PMAX_CSWV10 = 700.0
   REAL(SINGLE), PARAMETER :: PMAX_ALL_WINDS = 1000.0
   REAL(SINGLE), PARAMETER :: CLR_CLDY_PRESS_CUTOFF = 600.0
   REAL(SINGLE), PARAMETER :: MAX_SOLAR_ZEN_VISIBLE = 80.0
   REAL(SINGLE), PARAMETER :: MIN_SOLAR_ZEN_SWIR = 90.0
   REAL(SINGLE), PARAMETER :: MAX_SOLAR_ZEN_SWIR = 200.0
   REAL(SINGLE), PARAMETER :: CTP_MAX = 1100.0

   ! Gross error thresholds
   REAL(SINGLE), PARAMETER :: VEC_DIFF_VZ     =  6.0
   REAL(SINGLE), PARAMETER :: VEC_DIFF_SWIR   =  7.0
   REAL(SINGLE), PARAMETER :: VEC_DIFF_WVCT8  =  8.5 ! AAB update from 10.0 to 8.5
   REAL(SINGLE), PARAMETER :: VEC_DIFF_WVCS8  = 12.0
   REAL(SINGLE), PARAMETER :: VEC_DIFF_WVCS9  = 12.0
   REAL(SINGLE), PARAMETER :: VEC_DIFF_WVCS10 = 12.0
   REAL(SINGLE), PARAMETER :: VEC_DIFF_LWIR   =  8.0 ! AAB update from 10.0 to 8.0
   REAL(SINGLE), PARAMETER :: VEC_DIFF_LWIR_POLAR   = 7.0

   REAL(SINGLE), PARAMETER, PUBLIC :: SHEAR_PMIN =  100.0
   REAL(SINGLE), PARAMETER, PUBLIC :: SHEAR_PMAX = 1000.0

   ! WCB
   ! satellite zenith angle cutoff
   REAL(SINGLE), PARAMETER, PUBLIC :: ZENITH_ANGLE_CUTOFF = 70.0

   ! QI parameters
   REAL(SINGLE), PARAMETER :: INIT_MISSING_VALUE_QI = -0.98
   REAL(SINGLE), PARAMETER :: MIN_SPD = 0.0             ! Minimum speed accepted by automatic quality control (AQC)
   REAL(SINGLE), PARAMETER :: W_SPD = 1.0               ! AQC wind speed weight
   REAL(SINGLE), PARAMETER :: W_DIR = 1.0               ! AQC wind direction weight
   REAL(SINGLE), PARAMETER :: W_VEC = 1.0               ! AQC wind vector weight
   REAL(SINGLE), PARAMETER :: W_UC = 0.0                ! AQC wind u-component weight
   REAL(SINGLE), PARAMETER :: W_VC = 0.0                ! AQC wind v-component weight
   REAL(SINGLE), PARAMETER :: W_LC = 2.0                ! AQC buddy check weight
   REAL(SINGLE), PARAMETER :: W_FC = 1.0                ! AQC forecast weight
   ! set forecast weight back to 1.0
   !REAL(SINGLE), PARAMETER :: W_FC = 0.0                ! AQC forecast weight
   REAL(SINGLE), PARAMETER :: S1 = 0.2                  ! speed test parameter 1 (fraction)
   REAL(SINGLE), PARAMETER :: S2 = 1.0                  ! speed test parameter 2 (offset)
   REAL(SINGLE), PARAMETER :: S3 = 3.0                  ! speed test parameter 3 (exp. for normalization)
   REAL(SINGLE), PARAMETER :: D1 = 20.0                 ! direction test parameter 1  (exp. dependency)
   REAL(SINGLE), PARAMETER :: D2 = 10.0                 ! direction test parameter 2A (fraction)
   REAL(SINGLE), PARAMETER :: D22= 10.0                 ! direction test parameter 2B (offset)
   REAL(SINGLE), PARAMETER :: D3 = 4.0                  ! direction test parameter 3  (exp. for normalization)
   REAL(SINGLE), PARAMETER :: VEC1 = 0.2                ! vector test parameter 1 (fraction)
   REAL(SINGLE), PARAMETER :: VEC2 = 1.0                ! vector test parameter 2 (offset)
   REAL(SINGLE), PARAMETER :: VEC3 = 3.0                ! vector test parameter 3 (exp. for normalization)
   REAL(SINGLE), PARAMETER :: L1 = 0.2                  ! local con parameter 1 (fraction)
   REAL(SINGLE), PARAMETER :: L2 = 1.0                  ! local con parameter 2 (offset)
   REAL(SINGLE), PARAMETER :: L3 = 3.0                  ! local con parameter 3 (exp. for normalization)
   REAL(SINGLE), PARAMETER :: LOC_PRES_DIF = 50.0       ! max pressure difference (mb)
   REAL(SINGLE), PARAMETER :: LOC_BOX_DEF = 1.0         ! collocation box area (degrees)
   REAL(SINGLE), PARAMETER :: F1 = 0.4                  ! forecast parameter 1 (fraction)
   REAL(SINGLE), PARAMETER :: F2 = 1.0                  ! forecast parameter 2 (offset)
   REAL(SINGLE), PARAMETER :: F3 = 2.0                  ! forecast parameter 3 (exp. for normalization)
   REAL(SINGLE), PARAMETER :: U1 = 1.0                  ! u-component paramter 1 (fraction)
   REAL(SINGLE), PARAMETER :: U2 = 1.0                  ! u-component paramter 2 (offset)
   REAL(SINGLE), PARAMETER :: U3 = 2.0                  ! u-component paramter 3 (exp. for normalization)
   REAL(SINGLE), PARAMETER :: V1 = 1.0                  ! v-component paramter 1 (fraction)
   REAL(SINGLE), PARAMETER :: V2 = 1.0                  ! v-component paramter 2 (offset)
   REAL(SINGLE), PARAMETER :: V3 = 2.0                  ! v-component paramter 3 (exp. for normalization)

   ! EE parameters
   !CHARACTER(LEN=9) :: Predictors = 'EE_COEFFS' !Configurable
   CHARACTER(LEN=256) :: Predictors
   INTEGER(SHORT), PARAMETER :: MAX_NUM_PREDICTORS = 10
   REAL(SINGLE), PARAMETER :: PRESSURE_OFFSET = 200.0
   REAL(SINGLE), PARAMETER :: EE_LIMIT_BAND02 = 5.5        ! Band 02 EE cutoff.
   REAL(SINGLE), PARAMETER :: EE_SPD_LIMIT_BAND02 = 30.0   ! Band 02 Speed cutoff.
   REAL(SINGLE), PARAMETER :: EE_QI_LIMIT_BAND02 = 0.95    ! Band 02 QI cutoff.
   REAL(SINGLE), PARAMETER :: EE_LIMIT_BAND07 = 5.0        ! Band 07 EE cutoff.
   REAL(SINGLE), PARAMETER :: EE_SPD_LIMIT_BAND07 = 30.0   ! Band 07 Speed cutoff.
   REAL(SINGLE), PARAMETER :: EE_QI_LIMIT_BAND07 = 0.95    ! Band 07 QI cutoff.
   REAL(SINGLE), PARAMETER :: EE_LIMIT_BAND08 = 5.0        ! Band 08 EE cutoff. Clear Sky.
   REAL(SINGLE), PARAMETER :: EE_SPD_LIMIT_BAND08 = 30.0   ! Band 08 Speed cutoff. Clear Sky.
   REAL(SINGLE), PARAMETER :: EE_QI_LIMIT_BAND08 = 0.95    ! Band 08 QI cutoff. Clear Sky.
   REAL(SINGLE), PARAMETER :: EE_LIMIT_BAND10 = 5.0        ! Band 10 EE cutoff. Clear Sky.
   REAL(SINGLE), PARAMETER :: EE_SPD_LIMIT_BAND10 = 30.0   ! Band 10 Speed cutoff. Clear Sky.
   REAL(SINGLE), PARAMETER :: EE_QI_LIMIT_BAND10 = 0.95    ! Band 10 QI cutoff. Clear Sky.
   REAL(SINGLE), PARAMETER :: EE_LIMIT_BAND14 = 4.5        ! Band 14 EE cutoff.
   REAL(SINGLE), PARAMETER :: EE_SPD_LIMIT_BAND14 = 25.0   ! Band 14 Speed cutoff.
   REAL(SINGLE), PARAMETER :: EE_QI_LIMIT_BAND14 = 0.9     ! Band 14 QI cutoff.

   ! Land Mask
   INTEGER(SHORT), PARAMETER :: LAND_BINARY_MASK        = 1
   INTEGER(SHORT), PARAMETER :: WATER_BINARY_MASK       = 0


   INTEGER(LONG), PARAMETER :: DBSCAN_Output_Variables = 18


   !----------------------------------
   ! ABI channel
   !----------------------------------
   INTEGER(LONG), PUBLIC, PARAMETER :: NATIVE_ABI_CHN1  =  1
   INTEGER(LONG), PUBLIC, PARAMETER :: NATIVE_ABI_CHN2  =  2
   INTEGER(LONG), PUBLIC, PARAMETER :: NATIVE_ABI_CHN3  =  3
   INTEGER(LONG), PUBLIC, PARAMETER :: NATIVE_ABI_CHN4  =  4
   INTEGER(LONG), PUBLIC, PARAMETER :: NATIVE_ABI_CHN5  =  5
   INTEGER(LONG), PUBLIC, PARAMETER :: NATIVE_ABI_CHN6  =  6
   INTEGER(LONG), PUBLIC, PARAMETER :: NATIVE_ABI_CHN7  =  7
   INTEGER(LONG), PUBLIC, PARAMETER :: NATIVE_ABI_CHN8  =  8
   INTEGER(LONG), PUBLIC, PARAMETER :: NATIVE_ABI_CHN9  =  9
   INTEGER(LONG), PUBLIC, PARAMETER :: NATIVE_ABI_CHN10 = 10
   INTEGER(LONG), PUBLIC, PARAMETER :: NATIVE_ABI_CHN11 = 11
   INTEGER(LONG), PUBLIC, PARAMETER :: NATIVE_ABI_CHN12 = 12
   INTEGER(LONG), PUBLIC, PARAMETER :: NATIVE_ABI_CHN13 = 13
   INTEGER(LONG), PUBLIC, PARAMETER :: NATIVE_ABI_CHN14 = 14
   INTEGER(LONG), PUBLIC, PARAMETER :: NATIVE_ABI_CHN15 = 15
   INTEGER(LONG), PUBLIC, PARAMETER :: NATIVE_ABI_CHN16 = 16


END MODULE AMV_EN_WINDS_INC

