; get_CO_data.pro
;
; Written by Chuanyu Xu in 2018 
;
; Purpose: Gets the CO granules to make VIIRS JSTAR Mapper
;          image
;
; Inputs: year1  | Year of image
;         month1 | Month of image
;         day1   | Day of image
;         year2  | Year of previous day
;         month2 | Month of previous day
;         day2   | previous day
;         img_dir| Directory where image will be written
;         data_dir | Directory where data is saved 
;
; Called by: run_CO_mapper.sh
;
; Programs called: make_CO_mapper.pro
;
; Note: Because we want to show a continuous stream for JSTAR Mapper, it
;       is necessary to include some of the previous or next days orbits in the
;       image (e.g. 1/2/2018 will also have some data from 1/1/2018)

pro get_TROPOMI_CO_data, year1,   $
                  month1, $
                  day1,   $
                  year2,  $
                  month2, $
                  day2,   $
                  img_dir=img_dir,$
                  data_dir=data_dir
   print,'=================='
   print, img_dir
   print,data_dir
   print,'=================='

   ; Remove any white space from the strings
   yS1 = STRCOMPRESS(year1, /REMOVE_ALL)
   yS2 = STRCOMPRESS(year2, /REMOVE_ALL)
   mS1 = STRCOMPRESS(month1, /REMOVE_ALL)
   mS2 = STRCOMPRESS(month2, /REMOVE_ALL)
   dS1 = STRCOMPRESS(day1, /REMOVE_ALL)
   dS2 = STRCOMPRESS(day2, /REMOVE_ALL)

   ; Add proceeding zeros to day and month variables if necessary
   if strlen(dS1) eq 1 then dS1 = '0'+dS1
   if strlen(dS2) eq 1 then dS2 = '0'+dS2
   if strlen(mS1) eq 1 then mS1 = '0'+mS1
   if strlen(mS2) eq 1 then mS2 = '0'+mS2
   if strlen(day1) eq 1 then dS1 = '0'+day1
   if strlen(day2) eq 1 then dS1 = '0'+day2


   ; Remove any files in the data_dir and prepare for new data files
   spawn,'rm -f '+data_dir+'/S5P*_L2__CO_*nc'

   ; Open a file to list all current day CO data filenames  
   OPENW,wunit1,'CO_files_ymds1',/GET_LUN
   FREE_LUN,wunit1

   ; Open a file to list the required yesterday CO data filenames
   OPENW,wunit2,'CO_files_ymds2',/GET_LUN
   FREE_LUN,wunit2

   ; Link current day data files from the SCDR server
   spawn,'/data/starfs1/bin/scdr-files -t S5P_NRTI_L2_CO '+yS1+mS1+dS1+' >CO_files_ymds1'
   str1=''
   close,10
   openr,10,'CO_files_ymds1'
   while not eof(10) do begin
     readf,10,str1
       parts=strsplit(str1,'/',/extract)
       nparts=n_elements(parts)
     spawn, 'ln -s '+str1+' '+data_dir+'/'+parts[nparts-1]
   endwhile
   close,10

   ; Link yesterday data files from the SCDR server
   spawn,'/data/starfs1/bin/scdr-files -t S5P_NRTI_L2_CO -stime "'+yS2+'-'+mS2+'-'+dS2+' 23:00 UTC" -etime "'+yS2+'-'+mS2+'-'+dS2+' 23:59 UTC" >CO_files_ymds2'
   str2=''
   close,11
   openr,11,'CO_files_ymds2'
   while not eof(11) do begin
     readf,11,str2
       parts=strsplit(str2,'/',/extract)
       nparts=n_elements(parts)
    spawn, 'ln -s '+str2+' '+data_dir+'/'+parts[nparts-1]
   endwhile
   close,11
 

   ;spawn,'/data/smcd12/cxu/S5P/JSTARMapper/DataCheckScripts/UpdatedForOneday/findCObad_oneday.sh '+yS1+mS1+dS1

   ; List all CO files to an array to read and then generate image fro JStarMapper 
   spawn,'ls '+data_dir+'/S5P_NRTI_L2__CO_____'+yS1+mS1+dS1+'T* >currentDay_CO_files'
   spawn,'chmod 755 currentDay_CO_files' 
        nlines1=0L    
        nlines1=file_lines('currentDay_CO_files')
        if nlines1 ge 1 then begin
           afary=strarr(nlines1)
           openr,lunr,'currentDay_CO_files',/get_lun
           readf,lunr,afary
           free_lun,lunr
        endif

       nlines2=0L
       result=file_test(data_dir+'S5P_NRTI_L2__CO_____'+yS2+mS2+dS2+'T23???_'+yS1+mS1+dS1+'T0*.nc')
       if result eq 1 then begin  
          spawn,'ls '+data_dir+'/S5P_NRTI_L2__CO_____'+yS2+mS2+dS2+'T23???_'+yS1+mS1+dS1+'T0*.nc >previousDay_CO_files'
          spawn,'chmod 755 previousDay_CO_files'
          nlines2=file_lines('previousDay_CO_files')
          if nlines2 eq 1 then begin
             afary2=strarr(nlines2)
             openr,lunr,'previousDay_CO_files',/get_lun
             readf,lunr,afary2
             free_lun,lunr
          endif 
      endif 
       nlines_all=0l
       if nlines1 ge 1 and nlines2 eq 1 then afary=[afary,afary2]
       if nlines1 ge 1 and nlines2 eq 0 then afary=afary
       if nlines1 eq 0 and nlines2 eq 1 then afary=afary2
          nlines_all=n_elements(afary)
       if nlines_all ge 1 then begin
          TIC
          make_TROPOMI_CO_mapper, afary, img_dir, yS1, mS1, dS1, year1, month1, day1
          TOC
       endif else begin
          print,'Stop: No Data'
       endelse
end
